package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.Ccta1Dao;
import com.ejie.y41b.model.Ccta1;

/**
 * Ccta1ServiceImpl  
 * 
 *  
 */

@Service(value = "ccta1Service")
public class Ccta1ServiceImpl implements Ccta1Service {

	@Autowired()
	private Ccta1Dao ccta1Dao;

	/**
	 * Inserts a single row in the Ccta1 table.
	 * 
	 * @param ccta1
	 *            Ccta1
	 * @return Ccta1
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ccta1 add(Ccta1 ccta1) {
		return this.ccta1Dao.add(ccta1);
	}

	/**
	 * Updates a single row in the Ccta1 table.
	 * 
	 * @param ccta1
	 *            Ccta1
	 * @return Ccta1
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ccta1 update(Ccta1 ccta1) {
		return this.ccta1Dao.update(ccta1);
	}

	/**
	 * Finds a single row in the Ccta1 table.
	 * 
	 * @param ccta1
	 *            Ccta1
	 * @return Ccta1
	 */
	public Ccta1 find(Ccta1 ccta1) {
		return (Ccta1) this.ccta1Dao.find(ccta1);
	}

	/**
	 * Finds a List of rows in the Ccta1 table.
	 * 
	 * @param ccta1
	 *            Ccta1
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Ccta1> findAll(Ccta1 ccta1, Pagination pagination) {
		return (List<Ccta1>) this.ccta1Dao.findAll(ccta1, pagination);
	}

	/**
	 * Counts rows in the Ccta1 table.
	 * 
	 * @param ccta1
	 *            Ccta1
	 * @return Long
	 */
	public Long findAllCount(Ccta1 ccta1) {
		return this.ccta1Dao.findAllCount(ccta1);
	}

	/**
	 * Finds rows in the Ccta1 table using like.
	 * 
	 * @param ccta1
	 *            Ccta1
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Ccta1> findAllLike(Ccta1 ccta1, Pagination pagination,
			Boolean startsWith) {
		return (List<Ccta1>) this.ccta1Dao.findAllLike(ccta1, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Ccta1 table using like.
	 * 
	 * @param ccta1
	 *            Ccta1
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Ccta1 ccta1, Boolean startsWith) {
		return this.ccta1Dao.findAllLikeCount(ccta1, startsWith);
	}

	/**
	 * Deletes a single row in the Ccta1 table.
	 * 
	 * @param ccta1
	 *            Ccta1
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Ccta1 ccta1) {
		this.ccta1Dao.remove(ccta1);
	}

	/**
	 * Deletes multiple rows in the Ccta1 table.
	 * 
	 * @param ccta1List
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Ccta1> ccta1List) {
		for (Ccta1 ccta1Aux : ccta1List) {
			this.ccta1Dao.remove(ccta1Aux);
		}
	}

}
