package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.CcarDao;
import com.ejie.y41b.model.Ccar;

/**
 * CcarServiceImpl  
 * 
 *  
 */

@Service(value = "ccarService")
public class CcarServiceImpl implements CcarService {

	@Autowired()
	private CcarDao ccarDao;

	/**
	 * Inserts a single row in the Ccar table.
	 * 
	 * @param ccar
	 *            Ccar
	 * @return Ccar
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ccar add(Ccar ccar) {
		return this.ccarDao.add(ccar);
	}

	/**
	 * Updates a single row in the Ccar table.
	 * 
	 * @param ccar
	 *            Ccar
	 * @return Ccar
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ccar update(Ccar ccar) {
		return this.ccarDao.update(ccar);
	}

	/**
	 * Finds a single row in the Ccar table.
	 * 
	 * @param ccar
	 *            Ccar
	 * @return Ccar
	 */
	public Ccar find(Ccar ccar) {
		return (Ccar) this.ccarDao.find(ccar);
	}

	/**
	 * Finds a List of rows in the Ccar table.
	 * 
	 * @param ccar
	 *            Ccar
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Ccar> findAll(Ccar ccar, Pagination pagination) {
		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("arbitro.arnif")) {
				pagination.setSort("ArbitroARNIF");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("arbitro.arnombre")) {
				pagination.setSort("ArbitroARNOMBRE");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("aacc.cccodigo")) {
				pagination.setSort("M1COCC");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("aacc.organismo.nombreEs")) {
				pagination.setSort("OrganismoNOMBREES");
			}
			if (pagination.getSort() != null
					&& pagination.getSort().equals("aacc.organismo.nombreEu")) {
				pagination.setSort("OrganismoNOMBREEU");
			}
		}
		return (List<Ccar>) this.ccarDao.findAll(ccar, pagination);
	}

	/**
	 * Counts rows in the Ccar table.
	 * 
	 * @param ccar
	 *            Ccar
	 * @return Long
	 */
	public Long findAllCount(Ccar ccar) {
		return this.ccarDao.findAllCount(ccar);
	}

	/**
	 * Finds rows in the Ccar table using like.
	 * 
	 * @param ccar
	 *            Ccar
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Ccar> findAllLike(Ccar ccar, Pagination pagination,
			Boolean startsWith) {
		return (List<Ccar>) this.ccarDao.findAllLike(ccar, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Ccar table using like.
	 * 
	 * @param ccar
	 *            Ccar
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Ccar ccar, Boolean startsWith) {
		return this.ccarDao.findAllLikeCount(ccar, startsWith);
	}

	/**
	 * Deletes a single row in the Ccar table.
	 * 
	 * @param ccar
	 *            Ccar
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Ccar ccar) {
		this.ccarDao.remove(ccar);
	}

	/**
	 * Deletes multiple rows in the Ccar table.
	 * 
	 * @param ccarList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Ccar> ccarList) {
		for (Ccar ccarAux : ccarList) {
			this.ccarDao.remove(ccarAux);
		}
	}

}
