package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Ccar;

/**
 * CcarService  
 * 
 *  
 */

public interface CcarService {

	/**
	 * Inserts a single row in the Ccar table.
	 * 
	 * @param ccar
	 *            Ccar
	 * @return Ccar
	 */
	Ccar add(Ccar ccar);

	/**
	 * Updates a single row in the Ccar table.
	 * 
	 * @param ccar
	 *            Ccar
	 * @return Ccar
	 */
	Ccar update(Ccar ccar);

	/**
	 * Finds a single row in the Ccar table.
	 * 
	 * @param ccar
	 *            Ccar
	 * @return Ccar
	 */
	Ccar find(Ccar ccar);

	/**
	 * Finds a List of rows in the Ccar table.
	 * 
	 * @param ccar
	 *            Ccar
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Ccar> findAll(Ccar ccar, Pagination pagination);

	/**
	 * Counts rows in the Ccar table.
	 * 
	 * @param ccar
	 *            Ccar
	 * @return Long
	 */
	Long findAllCount(Ccar ccar);

	/**
	 * Finds rows in the Ccar table using like.
	 * 
	 * @param ccar
	 *            Ccar
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Ccar> findAllLike(Ccar ccar, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Ccar table using like.
	 * 
	 * @param ccar
	 *            Ccar
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Ccar ccar, Boolean startsWith);

	/**
	 * Deletes a single row in the Ccar table.
	 * 
	 * @param ccar
	 *            Ccar
	 * @return
	 */
	void remove(Ccar ccar);

	/**
	 * Deletes multiple rows in the Ccar table.
	 * 
	 * @param ccarList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Ccar> ccarList);

}
