package com.ejie.y41b.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.CargaTrabajoDao;
import com.ejie.y41b.model.CargaTrabajo;

/**
 * CargaTrabajoServiceImpl  
 * 
 *  
 */

@Service(value = "cargatrabajoremesaService")
public class CargaTrabajoServiceImpl implements CargaTrabajoService {

	private static final Logger logger = LoggerFactory.getLogger(CargaTrabajoServiceImpl.class);

	@Autowired
	private CargaTrabajoDao cargaTrabajoDao;

	/**
	 * Finds a List of rows in the CargaTrabajo table.
	 * 
	 * @param cargaTrabajo
	 *            CargaTrabajo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CargaTrabajo> findAll(CargaTrabajo cargaTrabajo, Pagination pagination) {
		if (pagination != null && pagination.getSidx() != null) {
			if (pagination.getSidx().equals("expedientesInspecciones")) {
				pagination.setSidx("EXPEDIENTESABIERTOSINS");
			} else if (pagination.getSidx().equals("expedientesDenuncias")) {
				pagination.setSidx("EXPEDIENTESABIERTOSDENUNCIAS");
			} else if (pagination.getSidx().equals("expedientesSolicitudes")) {
				pagination.setSidx("EXPEDIENTESABIERTOSSOLICITUDES");
			} else if (pagination.getSidx().equals("expedientesArbitraje")) {
				pagination.setSidx("EXPEDIENTESABIERTOSARBITRAJE");
			} else if (pagination.getSidx().equals("expedientesSancionador")) {
				pagination.setSidx("EXPEDIENTESABIERTOSSANCIONES");
			} else if (pagination.getSidx().equals("expedientesTotal")) {
				pagination.setSidx("TOTAL");
			}
		}

		return (List<CargaTrabajo>) this.cargaTrabajoDao.findAll(cargaTrabajo, pagination);
	}

	/**
	 * Counts rows in the CargaTrabajo table.
	 * 
	 * @param cargaTrabajo
	 *            CargaTrabajo
	 * @return Long
	 */
	public Long findAllCount(CargaTrabajo cargaTrabajo) {
		return this.cargaTrabajoDao.findAllCount(cargaTrabajo);
	}

}