package com.ejie.y41b.service;

import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.AdjuntarCampanhaproductoDao;
import com.ejie.y41b.dao.AdjuntarCampanhaprograDao;
import com.ejie.y41b.dao.AdjuntarCampanhatipoprotDao;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.BandejaCampanhaDao;
import com.ejie.y41b.dao.CampanhaCierreDao;
import com.ejie.y41b.dao.CampanhaComentariosDao;
import com.ejie.y41b.dao.CampanhaDao;
import com.ejie.y41b.dao.CampanhaProdDao;
import com.ejie.y41b.dao.CampanhaProgramacionDao;
import com.ejie.y41b.dao.CampanhaTipoprotocoloDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjuntarCampanhaproducto;
import com.ejie.y41b.model.AdjuntarCampanhaprogra;
import com.ejie.y41b.model.AdjuntarCampanhatipoprot;
import com.ejie.y41b.model.BandejaCampanha;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaCierre;
import com.ejie.y41b.model.CampanhaComentarios;
import com.ejie.y41b.model.CampanhaProgramacion;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.PlantillaControlMercadoDetalle;
import com.ejie.y41b.model.TipProtocolo;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * CampanhaServiceImpl  
 * 
 *  
 */

@Service(value = "campanhaService")
public class CampanhaServiceImpl implements CampanhaService {

	@Autowired
	private CampanhaDao campanhaDao;
	@Autowired
	private CampanhaTipoprotocoloDao campanhaTipoprotocoloDao;
	@Autowired
	private AdjuntarCampanhatipoprotDao adjuntarCampanhatipoprotDao;
	@Autowired
	private CampanhaProdDao campanhaProdDao;
	@Autowired
	private AdjuntarCampanhaproductoDao adjuntarCampanhaproductoDao;
	@Autowired
	private DocumentoHechoDao documentoHechoDao;
	@Autowired
	private AdjuntardocsDao adjuntardocsDao;
	@Autowired
	private AdjuntarCampanhaprograDao adjuntarCampanhaprograDao;
	@Autowired
	private CampanhaProgramacionDao campanhaProgramacionDao;
	@Autowired
	private CampanhaCierreDao campanhaCierreDao;
	@Autowired
	private CampanhaComentariosDao campanhaComentariosDao;
	@Autowired
	private BandejaCampanhaDao bandejaCampanhaDao;
	@Autowired
	private InspeccionService inspeccionService;
	@Autowired
	private ActuacionDao actuacionDao;
	@Autowired
	private TramiteInspeccionDao tramiteInspeccionDao;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Campanha add(Campanha campanha) {
		return this.campanhaDao.add(campanha);
	}

	/**
	 * Inserts a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param codCampanhaAlta
	 *            String
	 * @return Campanha
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Campanha addCampanha(Campanha campanha, String codCampanhaAlta) throws Exception {
		try {
			this.campanhaDao.add(campanha);

			CampanhaProgramacion campanhaProgramacionLimitesAux = new CampanhaProgramacion();
			Campanha campanhaAltaAux = new Campanha();
			campanhaAltaAux.setCmcodigo(codCampanhaAlta);
			campanhaProgramacionLimitesAux.setCampanha(campanhaAltaAux);
			campanhaProgramacionLimitesAux = this.adjuntarCampanhaprograDao
					.findLimitesCampanhaFase(campanhaProgramacionLimitesAux);
			if (campanhaProgramacionLimitesAux != null && campanhaProgramacionLimitesAux.getPgfehast() != null) {
				if ((campanha.getCmfecfinvalidacion().after(campanhaProgramacionLimitesAux.getPgfedesd())
						|| campanha.getCmfecfinvalidacion().equals(campanhaProgramacionLimitesAux.getPgfedesd()))) {
					throw new Y41bUDAException("error.campanha.FechasProgramacionException", true, new Exception());
				}
			}

			if (campanha != null && campanha.getCmtipo() != null
					&& (campanha.getCmtipo().equals(Y41bConstantes.CAMPANA_TIPO_CONTROLPRODUCTO)
							|| campanha.getCmtipo().equals(Y41bConstantes.CAMPANA_TIPO_MIXTAS))) {
				AdjuntarCampanhatipoprot adjuntarCampanhatipoprot = new AdjuntarCampanhatipoprot();
				adjuntarCampanhatipoprot.setCmcodigo(codCampanhaAlta);

				Long total = this.adjuntarCampanhatipoprotDao.findAllTipProtocoloCount(adjuntarCampanhatipoprot);

				// validar que haya al menos un protocolo
				if (total == 0) {
					throw new Y41bUDAException("error.campanha.ProtocoloException", true, new Exception());
				}

				adjuntarCampanhatipoprot.setTpestandar(Y41bConstantes.VALOR_SI);
				total = this.adjuntarCampanhatipoprotDao.findAllTipProtocoloCount(adjuntarCampanhatipoprot);

				// validar que haya solo un protocolo estandar como maximo
				if (total > 1) {
					throw new Y41bUDAException("error.campanha.ProtocoloEstandarException", true, new Exception());
				}

				adjuntarCampanhatipoprot.setTpestandar(Y41bConstantes.VALOR_NO);
				total = this.adjuntarCampanhatipoprotDao.findAllTipProtocoloCount(adjuntarCampanhatipoprot);

				// validar que haya solo un protocolo no estandar como maximo
				if (total > 1) {
					throw new Y41bUDAException("error.campanha.ProtocoloNoEstandarException", true, new Exception());
				}
			} else if (campanha != null && campanha.getCmtipo() != null
					&& (campanha.getCmtipo().equals(Y41bConstantes.CAMPANA_TIPO_MUESTRAS))) {
				AdjuntarCampanhatipoprot adjuntarCampanhatipoprot = new AdjuntarCampanhatipoprot();
				adjuntarCampanhatipoprot.setCmcodigo(codCampanhaAlta);

				adjuntarCampanhatipoprot.setTpestandar(Y41bConstantes.VALOR_SI);
				Long total = this.adjuntarCampanhatipoprotDao.findAllTipProtocoloCount(adjuntarCampanhatipoprot);

				// validar que haya solo un protocolo estandar como maximo
				if (total > 1) {
					throw new Y41bUDAException("error.campanha.ProtocoloEstandarException", true, new Exception());
				}

				adjuntarCampanhatipoprot.setTpestandar(Y41bConstantes.VALOR_NO);
				total = this.adjuntarCampanhatipoprotDao.findAllTipProtocoloCount(adjuntarCampanhatipoprot);

				// validar que no haya protocolo no estandar
				if (total > 0) {
					throw new Y41bUDAException("error.campanha.ProtocoloNoEstandarTomaMuestrasException", true,
							new Exception());
				}
			}

			this.campanhaProdDao.addAllCampanhaProd(campanha, codCampanhaAlta);

			AdjuntarCampanhaproducto adjuntarcampanhaproducto = new AdjuntarCampanhaproducto();
			adjuntarcampanhaproducto.setCpcocm(codCampanhaAlta);

			Long totalProds = this.campanhaProdDao.findAllProdCount(adjuntarcampanhaproducto);

			// validar que haya al menos un producto
			if (totalProds == 0) {
				throw new Y41bUDAException("error.campanha.ProductoException", true, new Exception());
			}

			String cpcops = null;
			String cpnops = null;

			if (totalProds == 1) {
				List<AdjuntarCampanhaproducto> listAdjuntarCampanhaproducto = this.adjuntarCampanhaproductoDao
						.findAll(adjuntarcampanhaproducto, null);
				if (listAdjuntarCampanhaproducto != null && listAdjuntarCampanhaproducto.size() > 0) {
					cpcops = listAdjuntarCampanhaproducto.get(0).getCpcops();
					cpnops = listAdjuntarCampanhaproducto.get(0).getCpnops();
				}
			}

			this.campanhaTipoprotocoloDao.addAllCampanhaTipoprotocolo(campanha, codCampanhaAlta);

			this.documentoHechoDao.addAllDocumentosAdjuntarDocs(campanha.getCmcodigo(), codCampanhaAlta);

			this.campanhaProgramacionDao.addAllCampanhaProgramacion(campanha, codCampanhaAlta);

			// buscar las programaciones de la campaa
			CampanhaProgramacion campanhaprogramacion = new CampanhaProgramacion();
			Campanha campanhaAux = new Campanha();
			campanhaAux.setCmcodigo(campanha.getCmcodigo());
			campanhaprogramacion.setCampanha(campanhaAux);
			List<CampanhaProgramacion> listCampanhaProgramacion = this.campanhaProgramacionDao
					.findAll(campanhaprogramacion, null);

			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

			if (listCampanhaProgramacion != null && listCampanhaProgramacion.size() > 0) {
				BandejaCampanha bandejaCampanha = null;
				Integer totalNumTomasMuestrasSol = 0;
				Integer totalNumControlesEstandarSol = 0;
				Integer totalNumControlesOtrosSol = 0;
				Integer totalNumInspecAdicionalesSol = 0;
				for (CampanhaProgramacion campanhaProgramacionAux : listCampanhaProgramacion) {
					// insertar la programacin en la bandeja de campaas
					bandejaCampanha = new BandejaCampanha();
					bandejaCampanha.setTzcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					bandejaCampanha.setCampanha(campanhaAux);
					bandejaCampanha.setCampanhaProgramacion(campanhaProgramacionAux);
					bandejaCampanha.setTzfedesd(campanhaProgramacionAux.getPgfedesd());
					bandejaCampanha.setTzfehast(campanhaProgramacionAux.getPgfehast());
					bandejaCampanha.setTzcoor(campanhaProgramacionAux.getPgcoor());
					bandejaCampanha.setTznumTomasMuestrasSol(campanhaProgramacionAux.getPgnumTomasMuestrasSol());
					bandejaCampanha
							.setTznumControlesEstandarSol(campanhaProgramacionAux.getPgnumControlesEstandarSol());
					bandejaCampanha.setTznumControlesOtrosSol(campanhaProgramacionAux.getPgnumControlesOtrosSol());
					bandejaCampanha
							.setTznumInspecAdicionalesSol(campanhaProgramacionAux.getPgnumInspecAdicionalesSol());

					this.bandejaCampanhaDao.add(bandejaCampanha);

					totalNumTomasMuestrasSol += campanhaProgramacionAux.getPgnumTomasMuestrasSol();
					totalNumControlesEstandarSol += campanhaProgramacionAux.getPgnumControlesEstandarSol();
					totalNumControlesOtrosSol += campanhaProgramacionAux.getPgnumControlesOtrosSol();
					totalNumInspecAdicionalesSol += campanhaProgramacionAux.getPgnumInspecAdicionalesSol();

					// Generar las inspecciones
					if (campanhaProgramacionAux.getPgnumTomasMuestrasSol() > 0) {
						for (int i = 0; i < campanhaProgramacionAux.getPgnumTomasMuestrasSol(); i++) {
							InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
							inspeccionDetalle.setAcfere(todayWithZeroTime);
							inspeccionDetalle.setAtcocm(campanhaProgramacionAux.getCampanha().getCmcodigo());
							inspeccionDetalle.setAtcopg(campanhaProgramacionAux.getPgcodigo());
							inspeccionDetalle.setAttipo(Y41bConstantes.TIPO_INSPECCION_TOMA_MUESTRAS);
							inspeccionDetalle.setAdcoor(campanhaProgramacionAux.getPgcoor());
							inspeccionDetalle.setAccoor(campanhaProgramacionAux.getPgcoor());

							inspeccionDetalle.setAtcops(cpcops);
							inspeccionDetalle.setAtnoprse(cpnops);

							this.inspeccionService.addInspeccionMasiva(inspeccionDetalle);
						}
					}

					if (campanhaProgramacionAux.getPgnumControlesEstandarSol() > 0) {
						for (int i = 0; i < campanhaProgramacionAux.getPgnumControlesEstandarSol(); i++) {
							InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
							inspeccionDetalle.setAcfere(todayWithZeroTime);
							inspeccionDetalle.setAtcocm(campanhaProgramacionAux.getCampanha().getCmcodigo());
							inspeccionDetalle.setAtcopg(campanhaProgramacionAux.getPgcodigo());
							inspeccionDetalle.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR);
							inspeccionDetalle.setAdcoor(campanhaProgramacionAux.getPgcoor());
							inspeccionDetalle.setAccoor(campanhaProgramacionAux.getPgcoor());

							inspeccionDetalle.setAtcops(cpcops);
							inspeccionDetalle.setAtnoprse(cpnops);

							this.inspeccionService.addInspeccionMasiva(inspeccionDetalle);
						}
					}

					if (campanhaProgramacionAux.getPgnumControlesOtrosSol() > 0) {
						for (int i = 0; i < campanhaProgramacionAux.getPgnumControlesOtrosSol(); i++) {
							InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
							inspeccionDetalle.setAcfere(todayWithZeroTime);
							inspeccionDetalle.setAtcocm(campanhaProgramacionAux.getCampanha().getCmcodigo());
							inspeccionDetalle.setAtcopg(campanhaProgramacionAux.getPgcodigo());
							inspeccionDetalle.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS);
							inspeccionDetalle.setAdcoor(campanhaProgramacionAux.getPgcoor());
							inspeccionDetalle.setAccoor(campanhaProgramacionAux.getPgcoor());

							inspeccionDetalle.setAtcops(cpcops);
							inspeccionDetalle.setAtnoprse(cpnops);

							this.inspeccionService.addInspeccionMasiva(inspeccionDetalle);
						}
					}
				}

				// Insertar la bandeja de campaas para SSCC
				CampanhaProgramacion campanhaProgramacion = new CampanhaProgramacion();
				campanhaProgramacion.setCampanha(campanhaAux);

				campanhaProgramacion = this.campanhaProgramacionDao.findLimitesCampanhaFase(campanhaProgramacion);

				bandejaCampanha = new BandejaCampanha();
				bandejaCampanha.setTzcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				bandejaCampanha.setCampanha(campanhaAux);
				bandejaCampanha.setCampanhaProgramacion(null);
				bandejaCampanha.setTzfedesd(campanhaProgramacion.getPgfedesd());
				bandejaCampanha.setTzfehast(campanhaProgramacion.getPgfehast());
				bandejaCampanha.setTzcoor(null);

				bandejaCampanha.setTznumTomasMuestrasSol(totalNumTomasMuestrasSol);
				bandejaCampanha.setTznumControlesEstandarSol(totalNumControlesEstandarSol);
				bandejaCampanha.setTznumControlesOtrosSol(totalNumControlesOtrosSol);
				bandejaCampanha.setTznumInspecAdicionalesSol(totalNumInspecAdicionalesSol);

				this.bandejaCampanhaDao.add(bandejaCampanha);
			}

			// crear registro de comentarios
			CampanhaComentarios campanhacomentarios = new CampanhaComentarios();
			campanhacomentarios.setTxcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			campanhacomentarios.setTxcmcodigo(campanha.getCmcodigo());
			this.campanhaComentariosDao.add(campanhacomentarios);

			// crear registro de cierre
			CampanhaCierre campanhacierre = new CampanhaCierre();
			campanhacierre.setTycodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			campanhacierre.setTycmcodigo(campanha.getCmcodigo());
			this.campanhaCierreDao.add(campanhacierre);

			campanhaAux = new Campanha();
			campanhaAux.setCmcodigo(codCampanhaAlta);

			this.adjuntarCampanhatipoprotDao.removeAllCampanhatipoprot(campanhaAux);
			this.adjuntarCampanhaproductoDao.removeAllCampanhaproducto(campanhaAux);
			this.adjuntardocsDao.removeAllDocsTableTemporal(codCampanhaAlta);
			this.adjuntarCampanhaprograDao.removeAllCampanhaprogra(campanhaAux);

			return campanha;
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException("error.campanha.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Updates a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Campanha update(Campanha campanha) {
		return this.campanhaDao.update(campanha);
	}

	/**
	 * Updates a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Campanha updateCampanha(Campanha campanha) throws Exception {
		try {
			this.campanhaDao.update(campanha);

			CampanhaProgramacion campanhaProgramacionLimitesAux = new CampanhaProgramacion();
			campanhaProgramacionLimitesAux.setCampanha(campanha);
			campanhaProgramacionLimitesAux = this.adjuntarCampanhaprograDao
					.findLimitesCampanhaFase(campanhaProgramacionLimitesAux);
			if (campanhaProgramacionLimitesAux != null && campanhaProgramacionLimitesAux.getPgfehast() != null) {
				if ((campanha.getCmfecfinvalidacion().after(campanhaProgramacionLimitesAux.getPgfedesd())
						|| campanha.getCmfecfinvalidacion().equals(campanhaProgramacionLimitesAux.getPgfedesd()))) {
					throw new Y41bUDAException("error.campanha.FechasProgramacionException", true, new Exception());
				}
			}

			if (campanha != null && campanha.getCmtipo() != null
					&& (campanha.getCmtipo().equals(Y41bConstantes.CAMPANA_TIPO_CONTROLPRODUCTO)
							|| campanha.getCmtipo().equals(Y41bConstantes.CAMPANA_TIPO_MIXTAS))) {
				AdjuntarCampanhatipoprot adjuntarCampanhatipoprot = new AdjuntarCampanhatipoprot();
				adjuntarCampanhatipoprot.setCmcodigo(campanha.getCmcodigo());

				Long total = this.adjuntarCampanhatipoprotDao.findAllTipProtocoloCount(adjuntarCampanhatipoprot);

				// validar que haya al menos un protocolo
				if (total == 0) {
					throw new Y41bUDAException("error.campanha.ProtocoloException", true, new Exception());
				}

				adjuntarCampanhatipoprot.setTpestandar(Y41bConstantes.VALOR_SI);
				total = this.adjuntarCampanhatipoprotDao.findAllTipProtocoloCount(adjuntarCampanhatipoprot);

				// validar que haya solo un protocolo estandar como maximo
				if (total > 1) {
					throw new Y41bUDAException("error.campanha.ProtocoloEstandarException", true, new Exception());
				}

				adjuntarCampanhatipoprot.setTpestandar(Y41bConstantes.VALOR_NO);
				total = this.adjuntarCampanhatipoprotDao.findAllTipProtocoloCount(adjuntarCampanhatipoprot);

				// validar que haya solo un protocolo no estandar como maximo
				if (total > 1) {
					throw new Y41bUDAException("error.campanha.ProtocoloNoEstandarException", true, new Exception());
				}
			} else if (campanha != null && campanha.getCmtipo() != null
					&& (campanha.getCmtipo().equals(Y41bConstantes.CAMPANA_TIPO_MUESTRAS))) {
				AdjuntarCampanhatipoprot adjuntarCampanhatipoprot = new AdjuntarCampanhatipoprot();
				adjuntarCampanhatipoprot.setCmcodigo(campanha.getCmcodigo());

				adjuntarCampanhatipoprot.setTpestandar(Y41bConstantes.VALOR_SI);
				Long total = this.adjuntarCampanhatipoprotDao.findAllTipProtocoloCount(adjuntarCampanhatipoprot);

				// validar que haya solo un protocolo estandar como maximo
				if (total > 1) {
					throw new Y41bUDAException("error.campanha.ProtocoloEstandarException", true, new Exception());
				}

				adjuntarCampanhatipoprot.setTpestandar(Y41bConstantes.VALOR_NO);
				total = this.adjuntarCampanhatipoprotDao.findAllTipProtocoloCount(adjuntarCampanhatipoprot);

				// validar que no haya protocolo no estandar
				if (total > 0) {
					throw new Y41bUDAException("error.campanha.ProtocoloNoEstandarTomaMuestrasException", true,
							new Exception());
				}
			}

			this.campanhaProdDao.removeAllCampanhaProd(campanha);

			this.campanhaProdDao.addAllCampanhaProd(campanha, campanha.getCmcodigo());

			AdjuntarCampanhaproducto adjuntarcampanhaproducto = new AdjuntarCampanhaproducto();
			adjuntarcampanhaproducto.setCpcocm(campanha.getCmcodigo());

			Long totalProds = this.campanhaProdDao.findAllProdCount(adjuntarcampanhaproducto);

			// validar que haya al menos un producto
			if (totalProds == 0) {
				throw new Y41bUDAException("error.campanha.ProductoException", true, new Exception());
			}

			String cpcops = null;
			String cpnops = null;

			if (totalProds == 1) {
				List<AdjuntarCampanhaproducto> listAdjuntarCampanhaproducto = this.adjuntarCampanhaproductoDao
						.findAll(adjuntarcampanhaproducto, null);
				if (listAdjuntarCampanhaproducto != null && listAdjuntarCampanhaproducto.size() > 0) {
					cpcops = listAdjuntarCampanhaproducto.get(0).getCpcops();
					cpnops = listAdjuntarCampanhaproducto.get(0).getCpnops();
				}
			}

			BandejaCampanha bandejacampanha = new BandejaCampanha();
			Campanha campanhaBandeja = new Campanha();
			campanhaBandeja.setCmcodigo(campanha.getCmcodigo());
			bandejacampanha.setCampanha(campanhaBandeja);
			CampanhaProgramacion campanhaProgramacionBandeja = new CampanhaProgramacion();
			bandejacampanha.setCampanhaProgramacion(campanhaProgramacionBandeja);

			this.campanhaTipoprotocoloDao.removeAllCampanhaTipoprotocolo(campanha);

			this.campanhaTipoprotocoloDao.addAllCampanhaTipoprotocolo(campanha, campanha.getCmcodigo());

			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5hdcodigo(campanha.getCmcodigo());
			this.documentoHechoDao.removeDocsExpediente(documentoHecho);

			this.documentoHechoDao.addAllDocumentosAdjuntarDocs(campanha.getCmcodigo(), campanha.getCmcodigo());

			// obtener las programaciones eliminadas
			List<CampanhaProgramacion> listCampanhaProgramacionEliminadas = this.campanhaProgramacionDao
					.findAllCampanhaProgramacionEliminadas(campanha, null);

			Actuacion actuacion = null;
			InspeccionDetalle inspeccionDetalleAux = null;
			BandejaCampanha bandejacampanhaAux = null;
			for (CampanhaProgramacion campanhaProgramacionAux : listCampanhaProgramacionEliminadas) {
				// buscar la programacion
				actuacion = new Actuacion();
				actuacion.setAtcopg(campanhaProgramacionAux.getPgcodigo());
				Long numInspeccionesIniciada = this.tramiteInspeccionDao
						.findAllTramiteAsignacionResponsableInspeccionTramitadoCount(actuacion);

				// Si tiene expedientes abiertos se lanza error
				if (numInspeccionesIniciada > 0) {
					throw new Y41bUDAException("error.campanha.InspeccionesAbiertasException", true, new Exception());
				}

				// eliminar las inspeccion si no est iniciada
				// buscar las inspecciones de la programacion
				List<Actuacion> listActuacion = this.actuacionDao.findAll(actuacion, null);

				for (Actuacion actuacionAux : listActuacion) {
					inspeccionDetalleAux = new InspeccionDetalle();
					inspeccionDetalleAux.setAtcodigo(actuacionAux.getAtcodigo());
					inspeccionDetalleAux.setAccodigo(actuacionAux.getActa().getAccodigo());
					this.inspeccionService.removeInspeccion(inspeccionDetalleAux);
				}

				// eliminar de la bandeja
				bandejacampanhaAux = new BandejaCampanha();
				bandejacampanhaAux.setCampanhaProgramacion(campanhaProgramacionAux);
				this.bandejaCampanhaDao.removeBandejaCampanhaProgramacion(bandejacampanhaAux);
			}

			// obtener las nuevas programaciones
			AdjuntarCampanhaprogra adjuntarCampanhaprogra = new AdjuntarCampanhaprogra();
			adjuntarCampanhaprogra.setPgcocm(campanha.getCmcodigo());
			List<AdjuntarCampanhaprogra> listAdjuntarCampanhaprograNuevas = this.adjuntarCampanhaprograDao
					.findAllCampanhaProgramacionNuevas(adjuntarCampanhaprogra, null);

			try {
				this.campanhaProgramacionDao.removeCampanhaProgramacion(campanha);
			} catch (DataIntegrityViolationException e) {
				throw new Y41bUDAException("error.campanha.ProgramacionDataIntegrityViolationExceptionMod", true, e);
			}

			this.campanhaProgramacionDao.addAllCampanhaProgramacion(campanha, campanha.getCmcodigo());

			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

			// insertar la nueva programacion
			CampanhaProgramacion campanhaprogramacion = null;
			for (AdjuntarCampanhaprogra adjuntarCampanhaprograAux : listAdjuntarCampanhaprograNuevas) {
				// buscar la programacion
				campanhaprogramacion = new CampanhaProgramacion();
				campanhaprogramacion.setPgcodigo(adjuntarCampanhaprograAux.getPgcodigo());
				campanhaprogramacion = this.campanhaProgramacionDao.find(campanhaprogramacion);

				// insertar la programacin en la bandeja de campaas
				bandejacampanha = new BandejaCampanha();
				bandejacampanha.setTzcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				bandejacampanha.setCampanha(campanha);
				bandejacampanha.setCampanhaProgramacion(campanhaprogramacion);
				bandejacampanha.setTzfedesd(campanhaprogramacion.getPgfedesd());
				bandejacampanha.setTzfehast(campanhaprogramacion.getPgfehast());
				bandejacampanha.setTzcoor(campanhaprogramacion.getPgcoor());
				bandejacampanha.setTznumTomasMuestrasSol(campanhaprogramacion.getPgnumTomasMuestrasSol());
				bandejacampanha.setTznumControlesEstandarSol(campanhaprogramacion.getPgnumControlesEstandarSol());
				bandejacampanha.setTznumControlesOtrosSol(campanhaprogramacion.getPgnumControlesOtrosSol());
				bandejacampanha.setTznumInspecAdicionalesSol(campanhaprogramacion.getPgnumInspecAdicionalesSol());

				this.bandejaCampanhaDao.add(bandejacampanha);

				// Generar las inspecciones
				if (campanhaprogramacion.getPgnumTomasMuestrasSol() > 0) {
					for (int i = 0; i < campanhaprogramacion.getPgnumTomasMuestrasSol(); i++) {
						InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
						inspeccionDetalle.setAcfere(todayWithZeroTime);
						inspeccionDetalle.setAtcocm(campanhaprogramacion.getCampanha().getCmcodigo());
						inspeccionDetalle.setAtcopg(campanhaprogramacion.getPgcodigo());
						inspeccionDetalle.setAttipo(Y41bConstantes.TIPO_INSPECCION_TOMA_MUESTRAS);
						inspeccionDetalle.setAdcoor(campanhaprogramacion.getPgcoor());
						inspeccionDetalle.setAccoor(campanhaprogramacion.getPgcoor());

						inspeccionDetalle.setAtcops(cpcops);
						inspeccionDetalle.setAtnoprse(cpnops);

						this.inspeccionService.addInspeccionMasiva(inspeccionDetalle);
					}
				}

				if (campanhaprogramacion.getPgnumControlesEstandarSol() > 0) {
					for (int i = 0; i < campanhaprogramacion.getPgnumControlesEstandarSol(); i++) {
						InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
						inspeccionDetalle.setAcfere(todayWithZeroTime);
						inspeccionDetalle.setAtcocm(campanhaprogramacion.getCampanha().getCmcodigo());
						inspeccionDetalle.setAtcopg(campanhaprogramacion.getPgcodigo());
						inspeccionDetalle.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR);
						inspeccionDetalle.setAdcoor(campanhaprogramacion.getPgcoor());
						inspeccionDetalle.setAccoor(campanhaprogramacion.getPgcoor());

						inspeccionDetalle.setAtcops(cpcops);
						inspeccionDetalle.setAtnoprse(cpnops);

						this.inspeccionService.addInspeccionMasiva(inspeccionDetalle);
					}
				}

				if (campanhaprogramacion.getPgnumControlesOtrosSol() > 0) {
					for (int i = 0; i < campanhaprogramacion.getPgnumControlesOtrosSol(); i++) {
						InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
						inspeccionDetalle.setAcfere(todayWithZeroTime);
						inspeccionDetalle.setAtcocm(campanhaprogramacion.getCampanha().getCmcodigo());
						inspeccionDetalle.setAtcopg(campanhaprogramacion.getPgcodigo());
						inspeccionDetalle.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS);
						inspeccionDetalle.setAdcoor(campanhaprogramacion.getPgcoor());
						inspeccionDetalle.setAccoor(campanhaprogramacion.getPgcoor());

						inspeccionDetalle.setAtcops(cpcops);
						inspeccionDetalle.setAtnoprse(cpnops);

						this.inspeccionService.addInspeccionMasiva(inspeccionDetalle);
					}
				}

			}

			if ((listAdjuntarCampanhaprograNuevas != null && listAdjuntarCampanhaprograNuevas.size() > 0)
					|| (listCampanhaProgramacionEliminadas != null && listCampanhaProgramacionEliminadas.size() > 0)) {

				// borrar la campaa de SSCC
				this.bandejaCampanhaDao.removeBandejaCampanhaSSCC(bandejacampanha);

				// Insertar la bandeja de campaas para SSCC
				// buscar las programaciones de la campaa
				campanhaprogramacion = new CampanhaProgramacion();
				Campanha campanhaAux = new Campanha();
				campanhaAux.setCmcodigo(campanha.getCmcodigo());
				campanhaprogramacion.setCampanha(campanhaAux);
				List<CampanhaProgramacion> listCampanhaProgramacion = this.campanhaProgramacionDao
						.findAll(campanhaprogramacion, null);

				BandejaCampanha bandejaCampanha = null;
				Integer totalNumTomasMuestrasSol = 0;
				Integer totalNumControlesEstandarSol = 0;
				Integer totalNumControlesOtrosSol = 0;
				Integer totalNumInspecAdicionalesSol = 0;
				for (CampanhaProgramacion campanhaProgramacionAux : listCampanhaProgramacion) {
					totalNumTomasMuestrasSol += campanhaProgramacionAux.getPgnumTomasMuestrasSol();
					totalNumControlesEstandarSol += campanhaProgramacionAux.getPgnumControlesEstandarSol();
					totalNumControlesOtrosSol += campanhaProgramacionAux.getPgnumControlesOtrosSol();
					totalNumInspecAdicionalesSol += campanhaProgramacionAux.getPgnumInspecAdicionalesSol();
				}

				if (listCampanhaProgramacion != null && listCampanhaProgramacion.size() > 0) {
					// Insertar la bandeja de campaas para SSCC
					CampanhaProgramacion campanhaProgramacion = new CampanhaProgramacion();
					campanhaProgramacion.setCampanha(campanhaAux);

					campanhaProgramacion = this.campanhaProgramacionDao.findLimitesCampanhaFase(campanhaProgramacion);

					bandejaCampanha = new BandejaCampanha();
					bandejaCampanha.setTzcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
					bandejaCampanha.setCampanha(campanhaAux);
					bandejaCampanha.setCampanhaProgramacion(null);
					bandejaCampanha.setTzfedesd(campanhaProgramacion.getPgfedesd());
					bandejaCampanha.setTzfehast(campanhaProgramacion.getPgfehast());
					bandejaCampanha.setTzcoor(null);

					bandejaCampanha.setTznumTomasMuestrasSol(totalNumTomasMuestrasSol);
					bandejaCampanha.setTznumControlesEstandarSol(totalNumControlesEstandarSol);
					bandejaCampanha.setTznumControlesOtrosSol(totalNumControlesOtrosSol);
					bandejaCampanha.setTznumInspecAdicionalesSol(totalNumInspecAdicionalesSol);

					this.bandejaCampanhaDao.add(bandejaCampanha);
				}
			}

			this.adjuntarCampanhatipoprotDao.removeAllCampanhatipoprot(campanha);
			this.adjuntarCampanhaproductoDao.removeAllCampanhaproducto(campanha);
			this.adjuntardocsDao.removeAllDocsTableTemporal(campanha.getCmcodigo());
			this.adjuntarCampanhaprograDao.removeAllCampanhaprogra(campanha);

			return campanha;
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException("error.campanha.DataIntegrityViolationExceptionMod", true, e);
		}
	}

	/**
	 * Finds a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	public Campanha find(Campanha campanha) {

		Campanha campanhaAux = this.campanhaDao.find(campanha);

		if (campanhaAux != null) {
			campanhaAux.setCmfase(this.obtenerFaseCampnha(campanhaAux));
		}

		return campanhaAux;
	}

	/**
	 * Obtiene la fase en la que se encuentra la campnha
	 * 
	 * @param campanha
	 *            Campanha
	 * @return String
	 */
	public String obtenerFaseCampnha(Campanha campanha) {
		try {
			if (campanha != null && campanha.getCmfechacierre() != null) {
				return Y41bConstantes.FASE_CAMPANHA_CIERRE;
			} else if (campanha != null && campanha.getCmactiva() != null
					&& campanha.getCmactiva().equals(Y41bConstantes.VALOR_NO)) {
				return Y41bConstantes.FASE_CAMPANHA_INACTIVA;
			} else {
				CampanhaProgramacion campanhaProgramacion = new CampanhaProgramacion();
				campanhaProgramacion.setCampanha(campanha);

				campanhaProgramacion = this.campanhaProgramacionDao.findLimitesCampanhaFase(campanhaProgramacion);

				Locale locale = LocaleContextHolder.getLocale();
				Date today = new Date();
				Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

				if (campanha.getCmfeciniborrador() != null && campanha.getCmfecfinborrador() != null
						&& (todayWithZeroTime.after(campanha.getCmfeciniborrador())
								|| todayWithZeroTime.equals(campanha.getCmfeciniborrador()))
						&& (todayWithZeroTime.before(campanha.getCmfecfinborrador())
								|| todayWithZeroTime.equals(campanha.getCmfecfinborrador()))) {
					return Y41bConstantes.FASE_CAMPANHA_BORRADOR;
				} else if (campanha.getCmfecinivalidacion() != null && campanha.getCmfecfinvalidacion() != null
						&& (todayWithZeroTime.after(campanha.getCmfecinivalidacion())
								|| todayWithZeroTime.equals(campanha.getCmfecinivalidacion()))
						&& (todayWithZeroTime.before(campanha.getCmfecfinvalidacion())
								|| todayWithZeroTime.equals(campanha.getCmfecfinvalidacion()))) {
					return Y41bConstantes.FASE_CAMPANHA_VALIDACION;
				} else if ((todayWithZeroTime.after(campanhaProgramacion.getPgfedesd())
						|| todayWithZeroTime.equals(campanhaProgramacion.getPgfedesd()))
						&& (todayWithZeroTime.before(campanhaProgramacion.getPgfehast())
								|| todayWithZeroTime.equals(campanhaProgramacion.getPgfehast()))) {
					return Y41bConstantes.FASE_CAMPANHA_EJECUCION;
				} else if (todayWithZeroTime.after(campanhaProgramacion.getPgfehast())) {
					return Y41bConstantes.FASE_CAMPANHA_ANALISIS;
				} else {
					return null;
				}
			}
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Finds a List of rows in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Campanha> findAll(Campanha campanha, Pagination pagination) {
		return (List<Campanha>) this.campanhaDao.findAll(campanha, pagination);
	}

	/**
	 * Counts rows in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Long
	 */
	public Long findAllCount(Campanha campanha) {
		return this.campanhaDao.findAllCount(campanha);
	}

	/**
	 * Finds rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Campanha> findAllLike(Campanha campanha, Pagination pagination, Boolean startsWith) {
		return (List<Campanha>) this.campanhaDao.findAllLike(campanha, pagination, startsWith);
	}

	/**
	 * Counts rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Campanha campanha, Boolean startsWith) {
		return this.campanhaDao.findAllLikeCount(campanha, startsWith);
	}

	/**
	 * Finds rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Campanha> findAllLikeCampanha(Campanha campanha, Pagination pagination, Boolean startsWith) {
		List<Campanha> listCampanha = this.campanhaDao.findAllLikeCampanha(campanha, pagination, startsWith);

		for (Campanha campanhaAux : listCampanha) {
			campanhaAux.setCmfase(this.obtenerFaseCampnha(campanhaAux));
		}

		return listCampanha;
	}

	/**
	 * Counts rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCampanhaCount(Campanha campanha, Boolean startsWith) {
		return this.campanhaDao.findAllLikeCampanhaCount(campanha, startsWith);
	}

	/**
	 * Deletes a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Campanha campanha) {
		this.campanhaDao.remove(campanha);
	}

	/**
	 * Deletes a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeCampanha(Campanha campanha) {
		try {
			this.adjuntarCampanhatipoprotDao.removeAllCampanhatipoprot(campanha);
			this.adjuntarCampanhaproductoDao.removeAllCampanhaproducto(campanha);
			this.adjuntardocsDao.removeAllDocsTableTemporal(campanha.getCmcodigo());
			this.adjuntarCampanhaprograDao.removeAllCampanhaprogra(campanha);

			// Buscar las programaciones de la campaa
			CampanhaProgramacion campanhaprogramacion = new CampanhaProgramacion();
			Campanha campanhaAux = new Campanha();
			campanhaAux.setCmcodigo(campanha.getCmcodigo());
			campanhaprogramacion.setCampanha(campanhaAux);
			List<CampanhaProgramacion> listCampanhaProgramacion = this.campanhaProgramacionDao
					.findAll(campanhaprogramacion, null);

			Actuacion actuacion = null;
			InspeccionDetalle inspeccionDetalleAux = null;
			BandejaCampanha bandejacampanhaAux = null;
			for (CampanhaProgramacion campanhaProgramacionAux : listCampanhaProgramacion) {
				// buscar la programacion
				actuacion = new Actuacion();
				actuacion.setAtcopg(campanhaProgramacionAux.getPgcodigo());
				Long numInspeccionesIniciada = this.tramiteInspeccionDao
						.findAllTramiteAsignacionResponsableInspeccionTramitadoCount(actuacion);

				// Si tiene expedientes abiertos se lanza error
				if (numInspeccionesIniciada > 0) {
					throw new Y41bUDAException("error.campanha.CampanhaInspeccionesAbiertasException", true,
							new Exception());
				}

				// eliminar las inspeccion si no est iniciada
				// buscar las inspecciones de la programacion
				List<Actuacion> listActuacion = this.actuacionDao.findAll(actuacion, null);

				for (Actuacion actuacionAux : listActuacion) {
					inspeccionDetalleAux = new InspeccionDetalle();
					inspeccionDetalleAux.setAtcodigo(actuacionAux.getAtcodigo());
					inspeccionDetalleAux.setAccodigo(actuacionAux.getActa().getAccodigo());
					this.inspeccionService.removeInspeccion(inspeccionDetalleAux);
				}
			}

			// eliminar de la bandeja
			bandejacampanhaAux = new BandejaCampanha();
			bandejacampanhaAux.setCampanha(campanha);
			this.bandejaCampanhaDao.removeBandejaCampanha(bandejacampanhaAux);

			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5hdcodigo(campanha.getCmcodigo());
			this.documentoHechoDao.removeDocsExpediente(documentoHecho);

			this.campanhaTipoprotocoloDao.removeAllCampanhaTipoprotocolo(campanha);

			this.campanhaProdDao.removeAllCampanhaProd(campanha);

			this.campanhaProgramacionDao.removeAllCampanhaProgramacion(campanha);

			// borrar comentarios
			CampanhaComentarios campanhacomentarios = new CampanhaComentarios();
			campanhacomentarios.setTxcmcodigo(campanha.getCmcodigo());

			this.campanhaComentariosDao.remove(campanhacomentarios);

			// borrar cierre
			CampanhaCierre campanhacierre = new CampanhaCierre();
			campanhacierre.setTycmcodigo(campanha.getCmcodigo());
			this.campanhaCierreDao.remove(campanhacierre);

			this.campanhaDao.remove(campanha);

		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException("error.campanha.DataIntegrityViolationException", true, e);
		}
	}

	/**
	 * Deletes multiple rows in the Campanha table.
	 * 
	 * @param campanhaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Campanha> campanhaList) {
		for (Campanha campanhaAux : campanhaList) {
			this.campanhaDao.remove(campanhaAux);
		}
	}

	/**
	 * Inserts a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Campanha addCampanhaTipoprotocolo(Campanha campanha) {
		return this.campanhaDao.addCampanhaTipoprotocolo(campanha);
	}

	/**
	 * Deletes a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeCampanhaTipoprotocolo(Campanha campanha) {
		this.campanhaDao.removeCampanhaTipoprotocolo(campanha);
	}

	/**
	 * Find a single row in the findCampanhaTipoprotocolo Many To Many
	 * relationship.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param pagination
	 *            Pagination
	 * @return Campanha
	 */
	public Campanha findCampanhaTipoprotocolo(Campanha campanha, TipProtocolo tipProtocolo, Pagination pagination) {
		return this.campanhaDao.findCampanhaTipoprotocolo(campanha, tipProtocolo, pagination);
	}

	/**
	 * Counts rows in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @return List
	 */
	public Long findCampanhaTipoprotocoloCount(Campanha campanha, TipProtocolo tipprotocolo) {
		return this.campanhaDao.findCampanhaTipoprotocoloCount(campanha, tipprotocolo);
	}

	/**
	 * Finds a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return PlantillaControlMercadoDetalle
	 */
	public PlantillaControlMercadoDetalle findPlantillaControlMercadoDetalle(Campanha campanha) {

		Campanha campanhaAux = this.campanhaDao.find(campanha);

		PlantillaControlMercadoDetalle plantillaControlMercadoDetalle = new PlantillaControlMercadoDetalle();

		plantillaControlMercadoDetalle.setTipoOrigen(
				this.appMessageSource.getMessage("excel.inspecciones.campanha", null, LocaleContextHolder.getLocale()));

		plantillaControlMercadoDetalle.setCodigoOrigen(campanhaAux.getCmcodigo());

		plantillaControlMercadoDetalle.setNombreOrigen(campanhaAux.getCmnombre());

		// Devolvemos el objeto
		return plantillaControlMercadoDetalle;

	}

	/**
	 * Reabrir una campaa
	 * 
	 * @param campanha
	 *            Campanha
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void reabrir(Campanha campanha) throws Exception {

		// quitar la marca del check de fin en Unidad Control en la tabla de
		// cierre
		CampanhaCierre campanhacierre = new CampanhaCierre();
		campanhacierre.setTycmcodigo(campanha.getCmcodigo());
		this.campanhaCierreDao.updateReabrirCampana(campanhacierre);

		// eliminar la fecha de cierre de la campaa
		campanha.setCmfechacierre(null);
		this.campanhaDao.updateFechacierre(campanha);

		// buscar las programaciones de la campaa
		CampanhaProgramacion campanhaprogramacion = new CampanhaProgramacion();
		Campanha campanhaAux = new Campanha();
		campanhaAux.setCmcodigo(campanha.getCmcodigo());
		campanhaprogramacion.setCampanha(campanhaAux);
		List<CampanhaProgramacion> listCampanhaProgramacion = this.campanhaProgramacionDao.findAll(campanhaprogramacion,
				null);

		if (listCampanhaProgramacion != null && listCampanhaProgramacion.size() > 0) {
			BandejaCampanha bandejaCampanha = null;
			Integer totalNumTomasMuestrasSol = 0;
			Integer totalNumControlesEstandarSol = 0;
			Integer totalNumControlesOtrosSol = 0;
			Integer totalNumInspecAdicionalesSol = 0;
			for (CampanhaProgramacion campanhaProgramacionAux : listCampanhaProgramacion) {
				// insertar la programacin en la bandeja de campaas
				bandejaCampanha = new BandejaCampanha();
				bandejaCampanha.setTzcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
				bandejaCampanha.setCampanha(campanhaAux);
				bandejaCampanha.setCampanhaProgramacion(campanhaProgramacionAux);
				bandejaCampanha.setTzfedesd(campanhaProgramacionAux.getPgfedesd());
				bandejaCampanha.setTzfehast(campanhaProgramacionAux.getPgfehast());
				bandejaCampanha.setTzcoor(campanhaProgramacionAux.getPgcoor());
				bandejaCampanha.setTznumTomasMuestrasSol(campanhaProgramacionAux.getPgnumTomasMuestrasSol());
				bandejaCampanha.setTznumControlesEstandarSol(campanhaProgramacionAux.getPgnumControlesEstandarSol());
				bandejaCampanha.setTznumControlesOtrosSol(campanhaProgramacionAux.getPgnumControlesOtrosSol());
				bandejaCampanha.setTznumInspecAdicionalesSol(campanhaProgramacionAux.getPgnumInspecAdicionalesSol());

				this.bandejaCampanhaDao.add(bandejaCampanha);

				totalNumTomasMuestrasSol += campanhaProgramacionAux.getPgnumTomasMuestrasSol();
				totalNumControlesEstandarSol += campanhaProgramacionAux.getPgnumControlesEstandarSol();
				totalNumControlesOtrosSol += campanhaProgramacionAux.getPgnumControlesOtrosSol();
				totalNumInspecAdicionalesSol += campanhaProgramacionAux.getPgnumInspecAdicionalesSol();
			}

			// Insertar la bandeja de campaas para SSCC
			CampanhaProgramacion campanhaProgramacion = new CampanhaProgramacion();
			campanhaProgramacion.setCampanha(campanhaAux);

			campanhaProgramacion = this.campanhaProgramacionDao.findLimitesCampanhaFase(campanhaProgramacion);

			bandejaCampanha = new BandejaCampanha();
			bandejaCampanha.setTzcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			bandejaCampanha.setCampanha(campanhaAux);
			bandejaCampanha.setCampanhaProgramacion(null);
			bandejaCampanha.setTzfedesd(campanhaProgramacion.getPgfedesd());
			bandejaCampanha.setTzfehast(campanhaProgramacion.getPgfehast());
			bandejaCampanha.setTzcoor(null);

			bandejaCampanha.setTznumTomasMuestrasSol(totalNumTomasMuestrasSol);
			bandejaCampanha.setTznumControlesEstandarSol(totalNumControlesEstandarSol);
			bandejaCampanha.setTznumControlesOtrosSol(totalNumControlesOtrosSol);
			bandejaCampanha.setTznumInspecAdicionalesSol(totalNumInspecAdicionalesSol);

			this.bandejaCampanhaDao.add(bandejaCampanha);
		}

	}
}
