package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.PlantillaControlMercadoDetalle;
import com.ejie.y41b.model.TipProtocolo;

/**
 * CampanhaService  
 * 
 *  
 */

public interface CampanhaService {

	/**
	 * Inserts a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	Campanha add(Campanha campanha);

	/**
	 * Inserts a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param codCampanhaAlta
	 *            String
	 * @return Campanha
	 * @throws Exception
	 *             Exception
	 */
	public Campanha addCampanha(Campanha campanha, String codCampanhaAlta)
			throws Exception;

	/**
	 * Updates a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	Campanha update(Campanha campanha);

	/**
	 * Updates a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 * @throws Exception
	 *             Exception
	 */
	public Campanha updateCampanha(Campanha campanha) throws Exception;

	/**
	 * Finds a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	Campanha find(Campanha campanha);

	/**
	 * Obtiene la fase en la que se encuentra la campnha
	 * 
	 * @param campanha
	 *            Campanha
	 * @return String
	 */
	public String obtenerFaseCampnha(Campanha campanha);

	/**
	 * Finds a List of rows in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Campanha> findAll(Campanha campanha, Pagination pagination);

	/**
	 * Counts rows in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Long
	 */
	Long findAllCount(Campanha campanha);

	/**
	 * Finds rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Campanha> findAllLike(Campanha campanha, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Campanha campanha, Boolean startsWith);

	/**
	 * Deletes a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return
	 */
	void remove(Campanha campanha);

	/**
	 * Deletes a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	public void removeCampanha(Campanha campanha);

	/**
	 * Deletes multiple rows in the Campanha table.
	 * 
	 * @param campanhaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Campanha> campanhaList);

	/**
	 * Inserts a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	Campanha addCampanhaTipoprotocolo(Campanha campanha);

	/**
	 * Deletes a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 */
	void removeCampanhaTipoprotocolo(Campanha campanha);

	/**
	 * Find a single row in the findCampanhaTipoprotocolo Many To Many
	 * relationship.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @param pagination
	 *            Pagination
	 * @return Campanha
	 */
	Campanha findCampanhaTipoprotocolo(Campanha campanha,
			TipProtocolo tipprotocolo, Pagination pagination);

	/**
	 * Counts rows in the CampanhaTipoprotocolo table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @return List
	 */
	Long findCampanhaTipoprotocoloCount(Campanha campanha,
			TipProtocolo tipprotocolo);

	/**
	 * Finds rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Campanha> findAllLikeCampanha(Campanha campanha,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Campanha table using like.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCampanhaCount(Campanha campanha, Boolean startsWith);

	/**
	 * Finds a single row in the Campanha table.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return PlantillaControlMercadoDetalle
	 */
	public PlantillaControlMercadoDetalle findPlantillaControlMercadoDetalle(
			Campanha campanha);

	/**
	 * Reabrir una campaa
	 * 
	 * @param campanha
	 *            Campanha
	 * @throws Exception
	 *             Exception
	 */
	public void reabrir(Campanha campanha) throws Exception;
}
