package com.ejie.y41b.service;

import java.text.ParseException;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.CampanhaProgramacionDao;
import com.ejie.y41b.model.CampanhaProgramacion;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * CampanhaProgramacionServiceImpl  
 * 
 *  
 */

@Service(value = "campanhaProgramacionService")
public class CampanhaProgramacionServiceImpl implements CampanhaProgramacionService {

	@Autowired
	private CampanhaProgramacionDao campanhaProgramacionDao;

	/**
	 * Inserts a single row in the CampanhaProgramacion table.
	 *
	 * @param campanhaProgramacion
	 *            CampanhaProgramacion
	 * @return CampanhaProgramacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CampanhaProgramacion add(CampanhaProgramacion campanhaProgramacion) {
		return this.campanhaProgramacionDao.add(campanhaProgramacion);
	}

	/**
	 * Updates a single row in the CampanhaProgramacion table.
	 *
	 * @param campanhaProgramacion
	 *            CampanhaProgramacion
	 * @return CampanhaProgramacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CampanhaProgramacion update(CampanhaProgramacion campanhaProgramacion) {
		return this.campanhaProgramacionDao.update(campanhaProgramacion);
	}

	/**
	 * Finds a single row in the CampanhaProgramacion table.
	 *
	 * @param campanhaProgramacion
	 *            CampanhaProgramacion
	 * @return CampanhaProgramacion
	 */
	public CampanhaProgramacion find(CampanhaProgramacion campanhaProgramacion) {
		return (CampanhaProgramacion) this.campanhaProgramacionDao.find(campanhaProgramacion);
	}

	/**
	 * Finds a List of rows in the CampanhaProgramacion table.
	 *
	 * @param campanhaProgramacion
	 *            CampanhaProgramacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CampanhaProgramacion> findAll(CampanhaProgramacion campanhaProgramacion, Pagination pagination) {
		List<CampanhaProgramacion> listCampanhaProgramacion = (List<CampanhaProgramacion>) this.campanhaProgramacionDao
				.findAll(campanhaProgramacion, pagination);

		StringBuffer programaciondesc = new StringBuffer();
		StringBuffer programaciondesce = new StringBuffer();
		for (CampanhaProgramacion campanhaProgramacionAux : listCampanhaProgramacion) {
			try {
				programaciondesc = new StringBuffer();
				programaciondesce = new StringBuffer();

				programaciondesc.append(campanhaProgramacionAux.getPgcoor()).append(" - ")
						.append(Y41bUtils.formatearDateToString(campanhaProgramacionAux.getPgfedesd(),
								Y41bConstantes.FORMATO_FECHA_ES, Y41bConstantes.CASTELLANO));

				if (campanhaProgramacionAux.getPgfehast() != null) {
					programaciondesc.append(" - ")
							.append(Y41bUtils.formatearDateToString(campanhaProgramacionAux.getPgfehast(),
									Y41bConstantes.FORMATO_FECHA_ES, Y41bConstantes.CASTELLANO));
				}

				programaciondesce.append(campanhaProgramacionAux.getPgcoor()).append(" - ")
						.append(Y41bUtils.formatearDateToString(campanhaProgramacionAux.getPgfedesd(),
								Y41bConstantes.FORMATO_FECHA_EU, Y41bConstantes.EUSKERA));

				if (campanhaProgramacionAux.getPgfehast() != null) {
					programaciondesce.append(" - ")
							.append(Y41bUtils.formatearDateToString(campanhaProgramacionAux.getPgfehast(),
									Y41bConstantes.FORMATO_FECHA_EU, Y41bConstantes.EUSKERA));
				}

			} catch (ParseException e) {
				programaciondesc = new StringBuffer();
				programaciondesce = new StringBuffer();
			}
			campanhaProgramacionAux.setPgprogramaciondesc(programaciondesc.toString());
			campanhaProgramacionAux.setPgprogramaciondesce(programaciondesce.toString());
		}

		return listCampanhaProgramacion;
	}

	/**
	 * Counts rows in the CampanhaProgramacion table.
	 *
	 * @param campanhaProgramacion
	 *            CampanhaProgramacion
	 * @return Long
	 */
	public Long findAllCount(CampanhaProgramacion campanhaProgramacion) {
		return this.campanhaProgramacionDao.findAllCount(campanhaProgramacion);
	}

	/**
	 * Finds rows in the CampanhaProgramacion table using like.
	 *
	 * @param campanhaProgramacion
	 *            CampanhaProgramacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<CampanhaProgramacion> findAllLike(CampanhaProgramacion campanhaProgramacion, Pagination pagination,
			Boolean startsWith) {
		return (List<CampanhaProgramacion>) this.campanhaProgramacionDao.findAllLike(campanhaProgramacion, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the CampanhaProgramacion table using like.
	 *
	 * @param campanhaProgramacion
	 *            CampanhaProgramacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(CampanhaProgramacion campanhaProgramacion, Boolean startsWith) {
		return this.campanhaProgramacionDao.findAllLikeCount(campanhaProgramacion, startsWith);
	}

	/**
	 * Deletes a single row in the CampanhaProgramacion table.
	 *
	 * @param campanhaProgramacion
	 *            CampanhaProgramacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(CampanhaProgramacion campanhaProgramacion) {
		this.campanhaProgramacionDao.remove(campanhaProgramacion);
	}

	/**
	 * Deletes multiple rows in the CampanhaProgramacion table.
	 *
	 * @param campanhaProgramacionList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<CampanhaProgramacion> campanhaProgramacionList) {
		for (CampanhaProgramacion campanhaProgramacionAux : campanhaProgramacionList) {
			this.campanhaProgramacionDao.remove(campanhaProgramacionAux);
		}
	}

}
