package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.CampanhaProdDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.CampanhaProd;

/**
 * CampanhaProdServiceImpl  
 *  
 */

@Service(value = "campanhaProdService")
public class CampanhaProdServiceImpl implements CampanhaProdService {

	@Autowired
	private CampanhaProdDao campanhaProdDao;

	/**
	 * Inserts a single row in the CampanhaProd table.
	 *
	 * @param campanhaProd CampanhaProd
	 * @return CampanhaProd
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CampanhaProd add(CampanhaProd campanhaProd) {
		return this.campanhaProdDao.add(campanhaProd);
	}

	/**
	 * Updates a single row in the CampanhaProd table.
	 *
	 * @param campanhaProd CampanhaProd
	 * @return CampanhaProd
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CampanhaProd update(CampanhaProd campanhaProd) {
		return this.campanhaProdDao.update(campanhaProd);
	 }

	/**
	 * Finds a single row in the CampanhaProd table.
	 *
	 * @param campanhaProd CampanhaProd
	 * @return CampanhaProd
	 */
	public CampanhaProd find(CampanhaProd campanhaProd) {
		return (CampanhaProd) this.campanhaProdDao.find(campanhaProd);
	}

	/**
	 * Finds a List of rows in the CampanhaProd table.
	 *
	 * @param campanhaProd CampanhaProd
	 * @param pagination Pagination
	 * @return List
	 */
	public List<CampanhaProd> findAll(CampanhaProd campanhaProd, Pagination pagination) {
		return (List<CampanhaProd>) this.campanhaProdDao.findAll(campanhaProd, pagination);
	}
    
	/**
	 * Counts rows in the CampanhaProd table.
	 *
	 * @param campanhaProd CampanhaProd
	 * @return Long
	 */
	public Long findAllCount(CampanhaProd campanhaProd) {        
		return  this.campanhaProdDao.findAllCount(campanhaProd);
	}

	/**
	 * Finds rows in the CampanhaProd table using like.
	 *
	 * @param campanhaProd CampanhaProd
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<CampanhaProd> findAllLike(CampanhaProd campanhaProd, Pagination pagination, Boolean startsWith) {
		return (List<CampanhaProd>) this.campanhaProdDao.findAllLike(campanhaProd, pagination, startsWith);
	}

	/**
	 * Counts rows in the CampanhaProd table using like.
	 *
	 * @param campanhaProd CampanhaProd
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(CampanhaProd campanhaProd, Boolean startsWith) {
		return this.campanhaProdDao.findAllLikeCount(campanhaProd, startsWith);
	}
	    
	/**
	 * Deletes a single row in the CampanhaProd table.
	 *
	 * @param campanhaProd CampanhaProd
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(CampanhaProd campanhaProd) {
		this.campanhaProdDao.remove(campanhaProd);
	}
	
	/**
	 * Deletes multiple rows in the CampanhaProd table.
	 *
	 * @param campanhaProdList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<CampanhaProd> campanhaProdList) {
		for (CampanhaProd  campanhaProdAux:campanhaProdList) {
			this.campanhaProdDao.remove(campanhaProdAux);
		}
	}
	
}

