package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.CampanhaComentariosDao;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaComentarios;

/**
 * CampanhaComentariosServiceImpl  
 * 
 *  
 */

@Service(value = "campanhaComentariosService")
public class CampanhaComentariosServiceImpl implements
		CampanhaComentariosService {

	@Autowired
	private CampanhaComentariosDao campanhaComentariosDao;
	@Autowired
	private CampanhaService campanhaService;

	/**
	 * Inserts a single row in the CampanhaComentarios table.
	 * 
	 * @param campanhaComentarios
	 *            CampanhaComentarios
	 * @return CampanhaComentarios
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CampanhaComentarios add(CampanhaComentarios campanhaComentarios) {
		return this.campanhaComentariosDao.add(campanhaComentarios);
	}

	/**
	 * Updates a single row in the CampanhaComentarios table.
	 * 
	 * @param campanhaComentarios
	 *            CampanhaComentarios
	 * @return CampanhaComentarios
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CampanhaComentarios update(CampanhaComentarios campanhaComentarios) {
		return this.campanhaComentariosDao.update(campanhaComentarios);
	}

	/**
	 * Finds a single row in the CampanhaComentarios table.
	 * 
	 * @param campanhaComentarios
	 *            CampanhaComentarios
	 * @return CampanhaComentarios
	 */
	public CampanhaComentarios find(CampanhaComentarios campanhaComentarios) {
		CampanhaComentarios campanhaComentariosAux = (CampanhaComentarios) this.campanhaComentariosDao
				.find(campanhaComentarios);

		Campanha campanha = new Campanha();
		campanha.setCmcodigo(campanhaComentarios.getTxcmcodigo());
		Campanha campanhaAux = this.campanhaService.find(campanha);

		campanhaComentariosAux.setCampanha(campanhaAux);

		return campanhaComentariosAux;
	}

	/**
	 * Finds a List of rows in the CampanhaComentarios table.
	 * 
	 * @param campanhaComentarios
	 *            CampanhaComentarios
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CampanhaComentarios> findAll(
			CampanhaComentarios campanhaComentarios, Pagination pagination) {
		return (List<CampanhaComentarios>) this.campanhaComentariosDao.findAll(
				campanhaComentarios, pagination);
	}

	/**
	 * Counts rows in the CampanhaComentarios table.
	 * 
	 * @param campanhaComentarios
	 *            CampanhaComentarios
	 * @return Long
	 */
	public Long findAllCount(CampanhaComentarios campanhaComentarios) {
		return this.campanhaComentariosDao.findAllCount(campanhaComentarios);
	}

	/**
	 * Finds rows in the CampanhaComentarios table using like.
	 * 
	 * @param campanhaComentarios
	 *            CampanhaComentarios
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<CampanhaComentarios> findAllLike(
			CampanhaComentarios campanhaComentarios, Pagination pagination,
			Boolean startsWith) {
		return (List<CampanhaComentarios>) this.campanhaComentariosDao
				.findAllLike(campanhaComentarios, pagination, startsWith);
	}

	/**
	 * Counts rows in the CampanhaComentarios table using like.
	 * 
	 * @param campanhaComentarios
	 *            CampanhaComentarios
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(CampanhaComentarios campanhaComentarios,
			Boolean startsWith) {
		return this.campanhaComentariosDao.findAllLikeCount(
				campanhaComentarios, startsWith);
	}

	/**
	 * Deletes a single row in the CampanhaComentarios table.
	 * 
	 * @param campanhaComentarios
	 *            CampanhaComentarios
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(CampanhaComentarios campanhaComentarios) {
		this.campanhaComentariosDao.remove(campanhaComentarios);
	}

	/**
	 * Deletes multiple rows in the CampanhaComentarios table.
	 * 
	 * @param campanhaComentariosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<CampanhaComentarios> campanhaComentariosList) {
		for (CampanhaComentarios campanhaComentariosAux : campanhaComentariosList) {
			this.campanhaComentariosDao.remove(campanhaComentariosAux);
		}
	}

}
