package com.ejie.y41b.service;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.BandejaCampanhaDao;
import com.ejie.y41b.dao.CampanhaCierreDao;
import com.ejie.y41b.dao.CampanhaDao;
import com.ejie.y41b.dao.PlantillaInformeCierreCampanhaDao;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.BandejaCampanha;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaCierre;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.PlantillaInformeCierreCampanha;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * CampanhaCierreServiceImpl  
 * 
 *  
 */

@Service(value = "campanhaCierreService")
public class CampanhaCierreServiceImpl implements CampanhaCierreService {

	@Autowired()
	private CampanhaCierreDao campanhaCierreDao;

	@Autowired()
	private CampanhaDao campanhaDao;

	@Autowired()
	private BandejaCampanhaDao bandejaCampanhaDao;

	@Autowired()
	private ActuacionDao actuacionDao;

	private static final Logger logger = LoggerFactory
			.getLogger(CampanhaCierreServiceImpl.class);

	@Autowired()
	private PlantillaInformeCierreCampanhaDao PlantillaInformeCierreCampanhaDao;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the CampanhaCierre table.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @return CampanhaCierre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CampanhaCierre add(CampanhaCierre campanhaCierre) {
		return this.campanhaCierreDao.add(campanhaCierre);
	}

	/**
	 * Updates a single row in the CampanhaCierre table.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @return CampanhaCierre
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CampanhaCierre update(CampanhaCierre campanhaCierre)
			throws Exception {

		this.campanhaCierreDao.update(campanhaCierre);

		if (campanhaCierre.getTyfinalizadosscc() != null
				&& campanhaCierre.getTyfinalizadosscc().equals(
						Y41bConstantes.VALOR_SI)) {
			// buscar todas las programaciones de la campaa
			// buscar las programaciones de la campaa
			// COMENTADO PORQUE EN SSCC NO QUIEREN ESPERAR A QUE UN SSTT CIERRE
			// SU PROGRAMACION PARA PODER CERRAR LA CAMPANHA.
			/*
			 * CampanhaProgramacion campanhaprogramacion = new
			 * CampanhaProgramacion(); Campanha campanhaAux = new Campanha();
			 * campanhaAux.setCmcodigo(campanhaCierre.getTycmcodigo());
			 * campanhaprogramacion.setCampanha(campanhaAux);
			 * List<CampanhaProgramacion> listCampanhaProgramacion =
			 * this.campanhaProgramacionDao .findAll(campanhaprogramacion,
			 * null);
			 * 
			 * if (listCampanhaProgramacion != null &&
			 * listCampanhaProgramacion.size() > 0) { Date fechaActual =
			 * Y41bUtils.obtenerFechaHoy(); for (CampanhaProgramacion
			 * campanhaProgramacionAux : listCampanhaProgramacion) { // Si no
			 * estan en fase de analisis, mandar un error if
			 * (!fechaActual.after(campanhaProgramacionAux .getPgfehast())) {
			 * throw new Y41bUDAException( "error.campanha.CierreException",
			 * true, new Exception()); } } }
			 */

			Campanha campanha = new Campanha();
			campanha.setCmcodigo(campanhaCierre.getTycmcodigo());
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);
			campanha.setCmfechacierre(todayWithZeroTime);

			this.campanhaDao.updateFechacierre(campanha);

			BandejaCampanha bandejacampanha = new BandejaCampanha();
			bandejacampanha.setCampanha(campanha);
			this.bandejaCampanhaDao.removeBandejaCampanha(bandejacampanha);
		}

		return campanhaCierre;
	}

	/**
	 * Finds a single row in the CampanhaCierre table.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @return CampanhaCierre
	 */
	public CampanhaCierre find(CampanhaCierre campanhaCierre) {
		CampanhaCierre campanhaCierreAux = (CampanhaCierre) this.campanhaCierreDao
				.find(campanhaCierre);

		Campanha campanha = new Campanha();
		campanha.setCmcodigo(campanhaCierreAux.getTycmcodigo());
		Campanha campanhaAux = this.campanhaDao.find(campanha);

		campanhaCierreAux.setCampanha(campanhaAux);

		// Campos calculados
		Actuacion actuacion = new Actuacion();
		actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_TOMA_MUESTRAS);
		actuacion.setAtcocm(campanhaAux.getCmcodigo());
		Long numInspeccionesRealizadas = this.actuacionDao
				.findAllInspeccionesRealizadasCount(actuacion);

		actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR);
		numInspeccionesRealizadas += this.actuacionDao
				.findAllInspeccionesRealizadasCount(actuacion);

		actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS);
		numInspeccionesRealizadas += this.actuacionDao
				.findAllInspeccionesRealizadasCount(actuacion);

		actuacion.setAttipo(null);
		actuacion.setAtadicional(Y41bConstantes.VALOR_SI);
		numInspeccionesRealizadas += this.actuacionDao
				.findAllInspeccionesRealizadasCount(actuacion);

		campanhaCierreAux
				.setNumInspeccionesRealizadas(numInspeccionesRealizadas
						.intValue());

		actuacion = new Actuacion();
		actuacion.setAtcocm(campanhaAux.getCmcodigo());
		actuacion.setAtpositivas(Y41bConstantes.VALOR_SI);
		numInspeccionesRealizadas = this.actuacionDao
				.findAllInspeccionesRealizadasResultadoCount(actuacion);
		campanhaCierreAux.setNumInspeccionesPositivas(numInspeccionesRealizadas
				.intValue());

		actuacion = new Actuacion();
		actuacion.setAtcocm(campanhaAux.getCmcodigo());
		actuacion.setAtpositivas(Y41bConstantes.VALOR_NO);
		numInspeccionesRealizadas = this.actuacionDao
				.findAllInspeccionesRealizadasResultadoCount(actuacion);
		campanhaCierreAux.setNumInspeccionesNegativas(numInspeccionesRealizadas
				.intValue());

		actuacion = new Actuacion();
		actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_TOMA_MUESTRAS);
		actuacion.setAtcocm(campanhaAux.getCmcodigo());
		actuacion.setAttodas(Y41bConstantes.VALOR_SI);
		numInspeccionesRealizadas = this.actuacionDao
				.findAllInspeccionesRealizadasCount(actuacion);
		campanhaCierreAux
				.setNumTomasMuestrasRealizadas(numInspeccionesRealizadas
						.intValue());

		actuacion = new Actuacion();
		actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR);
		actuacion.setAtcocm(campanhaAux.getCmcodigo());
		actuacion.setAttodas(Y41bConstantes.VALOR_SI);
		numInspeccionesRealizadas = this.actuacionDao
				.findAllInspeccionesRealizadasCount(actuacion);
		campanhaCierreAux
				.setNumControlesEstandarRealizados(numInspeccionesRealizadas
						.intValue());

		actuacion = new Actuacion();
		actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS);
		actuacion.setAtcocm(campanhaAux.getCmcodigo());
		actuacion.setAttodas(Y41bConstantes.VALOR_SI);
		numInspeccionesRealizadas = this.actuacionDao
				.findAllInspeccionesRealizadasCount(actuacion);
		campanhaCierreAux
				.setNumControlesOtrosRealizados(numInspeccionesRealizadas
						.intValue());

		return campanhaCierreAux;
	}

	/**
	 * Finds a List of rows in the CampanhaCierre table.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<CampanhaCierre> findAll(CampanhaCierre campanhaCierre,
			Pagination pagination) {
		return (List<CampanhaCierre>) this.campanhaCierreDao.findAll(
				campanhaCierre, pagination);
	}

	/**
	 * Counts rows in the CampanhaCierre table.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @return Long
	 */
	public Long findAllCount(CampanhaCierre campanhaCierre) {
		return this.campanhaCierreDao.findAllCount(campanhaCierre);
	}

	/**
	 * Finds rows in the CampanhaCierre table using like.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<CampanhaCierre> findAllLike(CampanhaCierre campanhaCierre,
			Pagination pagination, Boolean startsWith) {
		return (List<CampanhaCierre>) this.campanhaCierreDao.findAllLike(
				campanhaCierre, pagination, startsWith);
	}

	/**
	 * Counts rows in the CampanhaCierre table using like.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(CampanhaCierre campanhaCierre,
			Boolean startsWith) {
		return this.campanhaCierreDao.findAllLikeCount(campanhaCierre,
				startsWith);
	}

	/**
	 * Deletes a single row in the CampanhaCierre table.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(CampanhaCierre campanhaCierre) {
		this.campanhaCierreDao.remove(campanhaCierre);
	}

	/**
	 * Deletes multiple rows in the CampanhaCierre table.
	 * 
	 * @param campanhaCierreList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<CampanhaCierre> campanhaCierreList) {
		for (CampanhaCierre campanhaCierreAux : campanhaCierreList) {
			this.campanhaCierreDao.remove(campanhaCierreAux);
		}
	}

	/*
	 * *********************************************** *
	 * * GENERACION DE INFORME DE CIERRE DE CAMPANHA * *
	 * *********************************************** *
	 */

	/**
	 * Obtiene la plantilla de la decision
	 * 
	 * @param pICC
	 *            PlantillaInformeCierreCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return PlantillaInformeCierreCampanha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaInformeCierreCampanha generarInformeCierreCampanha(
			PlantillaInformeCierreCampanha pICC, CensoMonitor censoMonitor) {

		// 01. Cabecera de la plantilla de Informe de cierre de informe.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao.findCabecera(pICC));
		// 02. Actuaciones por protocolo y toma de muestras.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findActuacionesProtocoloMuestras(pICC));
		// 03. Productos de la campanha.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findProductosCampanha(pICC));
		// 04. Origen de las tomas de muestras.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao.findOrigenTomas(pICC));
		// 05. Suma de muestras indicativas y reglamentarias realizadas.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findSumaMuestrasIndicativasReglamentarias(pICC));
		// 06. Suma de protocolos estandar.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findSumaProtocolosEstandar(pICC));
		// 07. Suma de protocolos estandar con infraccion.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findSumaProtocolosEstandarInfraccion(pICC));
		// 08. Total de protocolos estandar.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findTotalProtocolosEstandar(pICC));
		// 08.5. Total de protocolos estandar.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findTotalInfracciones(pICC));
		// 09. Preguntas mas frecuentemente infringidas.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findPreguntasFrecuentementeInfringidas(pICC));
		// 09.4. Titulo pregunta1.
		if (pICC.getTrnrtipp1() != null) {
			pICC = this.unirDatosInforme(pICC,
					this.PlantillaInformeCierreCampanhaDao
							.findTituloPregunta1(pICC));
		}
		// 09.5. Titulo pregunta2.
		if (pICC.getTrnrtipp2() != null) {
			pICC = this.unirDatosInforme(pICC,
					this.PlantillaInformeCierreCampanhaDao
							.findTituloPregunta2(pICC));
		}
		// 09.6. Titulo pregunta3.
		if (pICC.getTrnrtipp3() != null) {
			pICC = this.unirDatosInforme(pICC,
					this.PlantillaInformeCierreCampanhaDao
							.findTituloPregunta3(pICC));
		}
		// 10. Actas con incumplimiento.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findActasIncumplimiento(pICC));
		// 11. Suma de actuaciones con toma de muestras.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao.findSumaMuestras(pICC));
		// 12. Suma de tomas de muestra con infraccion.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findSumaMuestrasInfraccion(pICC));
		// 13. Suma de incumplimientos detectados.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findSumaIncumplimientosDetectados(pICC));
		// 14. Texto de incumplimientos detectados.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findTextoIncumplimientosDetectados(pICC));
		// 15. Actas de toma de muestras relacionadas con incumplimientos.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findActasMuestrasIncumplimientos(pICC));
		// 16. Actuaciones propuestas por SSCC.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findActuacionesPropuestasSSCC(pICC));
		// 17. Establecimientos visitados durante las actuaciones.
		pICC = this.unirDatosInforme(pICC,
				this.PlantillaInformeCierreCampanhaDao
						.findEstablecimientosVisitados(pICC));

		pICC.setLocalidadFirma(censoMonitor.getOrganismo().getAdressMunicipio());

		pICC = this.rellenarCamposVacios(pICC);

		try {
			pICC.setFecha(Y41bUtils.formatearDateToString(new Date(),
					Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA,
					Y41bConstantes.CASTELLANO));
		} catch (ParseException e) {
			// Es un new Date(). Nunca deberia entrar aqui.
		}

		CampanhaCierreServiceImpl.logger
				.info("Informe de cierre de campanha generado correctamente.");

		return pICC;
	}

	/**
	 * Metodo encargado de juntar todo lo que entre por pICCAux en pICC.
	 * 
	 * @param pICC
	 *            PlantillaInformeCierreCampanha
	 * @param pICCAux
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	private PlantillaInformeCierreCampanha unirDatosInforme(
			PlantillaInformeCierreCampanha pICC,
			PlantillaInformeCierreCampanha pICCAux) {

		if (pICCAux.getCmNombre() != null) {
			pICC.setCmNombre(pICCAux.getCmNombre());
		}
		if (pICCAux.getCmAnio() > 0) {
			pICC.setCmAnio(pICCAux.getCmAnio());
		}
		if (pICCAux.getSumaProtocolosMuestras() > 0) {
			pICC.setSumaProtocolosMuestras(pICCAux.getSumaProtocolosMuestras());
		}
		if (pICCAux.getProtocolosAraba() > 0) {
			pICC.setProtocolosAraba(pICCAux.getProtocolosAraba());
		}
		if (pICCAux.getMuestrasAraba() > 0) {
			pICC.setMuestrasAraba(pICCAux.getMuestrasAraba());
		}
		if (pICCAux.getProtocolosGipuzkoa() > 0) {
			pICC.setProtocolosGipuzkoa(pICCAux.getProtocolosGipuzkoa());
		}
		if (pICCAux.getMuestrasGipuzkoa() > 0) {
			pICC.setMuestrasGipuzkoa(pICCAux.getMuestrasGipuzkoa());
		}
		if (pICCAux.getProtocolosBizkaia() > 0) {
			pICC.setProtocolosBizkaia(pICCAux.getProtocolosBizkaia());
		}
		if (pICCAux.getMuestrasBizkaia() > 0) {
			pICC.setMuestrasBizkaia(pICCAux.getMuestrasBizkaia());
		}
		if (pICCAux.getProtocolosTotal() > 0) {
			pICC.setProtocolosTotal(pICCAux.getProtocolosTotal());
			pICC.setSumaProtocolosMuestras(pICC.getProtocolosTotal()
					+ pICC.getMuestrasTotal());
		}
		if (pICCAux.getMuestrasTotal() > 0) {
			pICC.setMuestrasTotal(pICCAux.getMuestrasTotal());
			pICC.setSumaProtocolosMuestras(pICC.getProtocolosTotal()
					+ pICC.getMuestrasTotal());
		}
		if (pICCAux.getProductosCampanha() != null) {
			pICC.setProductosCampanha(pICCAux.getProductosCampanha());
		}
		if (pICCAux.getProvincias() != null) {
			pICC.setProvincias(pICCAux.getProvincias());
		}
		if (pICCAux.getSumaMuestrasIndicativas() > 0) {
			pICC.setSumaMuestrasIndicativas(pICCAux
					.getSumaMuestrasIndicativas());
		}
		if (pICCAux.getSumaMuestrasReglamentarias() > 0) {
			pICC.setSumaMuestrasReglamentarias(pICCAux
					.getSumaMuestrasReglamentarias());
		}
		if (pICCAux.getSumaProtocolosEstandar() > 0) {
			pICC.setSumaProtocolosEstandar(pICCAux.getSumaProtocolosEstandar());

			float porcentajeProtocolos = pICC
					.getSumaProtocolosEstandarInfraccion()
					* (float) Y41bConstantes.NUM_100
					/ pICC.getSumaProtocolosEstandar();
			pICC.setPorcentajeProtocolos(Y41bUtils
					.convertFloat2StringFormateado(porcentajeProtocolos) + "%");
		}
		if (pICCAux.getSumaProtocolosEstandarInfraccion() > 0) {
			pICC.setSumaProtocolosEstandarInfraccion(pICCAux
					.getSumaProtocolosEstandarInfraccion());

			float porcentajeProtocolos = pICC
					.getSumaProtocolosEstandarInfraccion()
					* (float) Y41bConstantes.NUM_100
					/ pICC.getSumaProtocolosEstandar();
			pICC.setPorcentajeProtocolos(Y41bUtils
					.convertFloat2StringFormateado(porcentajeProtocolos) + "%");
		}
		if (pICCAux.getTotalInfracciones() > 0) {
			pICC.setTotalInfracciones(pICCAux.getTotalInfracciones());

			if (pICC.getProtocolosTotal1() > 0) {
				float setProtocolosPorcentaje1 = pICC.getProtocolosTotal1()
						* (float) Y41bConstantes.NUM_100
						/ pICC.getTotalInfracciones();

				pICC.setProtocolosPorcentaje1(Y41bUtils
						.convertFloat2StringFormateado(setProtocolosPorcentaje1)
						+ "%");
			}
			if (pICC.getProtocolosTotal2() > 0) {
				float setProtocolosPorcentaje2 = pICC.getProtocolosTotal2()
						* (float) Y41bConstantes.NUM_100
						/ pICC.getTotalInfracciones();
				pICC.setProtocolosPorcentaje2(Y41bUtils
						.convertFloat2StringFormateado(setProtocolosPorcentaje2)
						+ "%");
			}
			if (pICC.getProtocolosTotal3() > 0) {
				float setProtocolosPorcentaje3 = pICC.getProtocolosTotal3()
						* (float) Y41bConstantes.NUM_100
						/ pICC.getTotalInfracciones();
				pICC.setProtocolosPorcentaje3(Y41bUtils
						.convertFloat2StringFormateado(setProtocolosPorcentaje3)
						+ "%");
			}
		}
		if (pICCAux.getTotalProtocolos() > 0) {
			pICC.setTotalProtocolos(pICCAux.getTotalProtocolos());
		}
		if (pICCAux.getTrcodigo1() != null) {
			pICC.setTrcodigo1(pICCAux.getTrcodigo1());
		}
		if (pICCAux.getTrnrtipp1() != null) {
			pICC.setTrnrtipp1(pICCAux.getTrnrtipp1());
		}
		if (pICCAux.getProtocolosPregunta1() != null) {
			pICC.setProtocolosPregunta1(pICCAux.getProtocolosPregunta1());
		}
		if (pICCAux.getProtocolosInfraccion1() != null) {
			pICC.setProtocolosInfraccion1(pICCAux.getProtocolosInfraccion1());
		}
		if (pICCAux.getProtocolosTotal1() > 0
				&& pICC.getTotalInfracciones() > 0) {
			pICC.setProtocolosTotal1(pICCAux.getProtocolosTotal1());

			float setProtocolosPorcentaje1 = pICC.getProtocolosTotal1()
					* (float) Y41bConstantes.NUM_100
					/ pICC.getTotalInfracciones();
			pICC.setProtocolosPorcentaje1(Y41bUtils
					.convertFloat2StringFormateado(setProtocolosPorcentaje1)
					+ "%");
		}
		if (pICCAux.getTrcodigo2() != null) {
			pICC.setTrcodigo2(pICCAux.getTrcodigo2());
		}
		if (pICCAux.getTrnrtipp2() != null) {
			pICC.setTrnrtipp2(pICCAux.getTrnrtipp2());
		}
		if (pICCAux.getProtocolosPregunta2() != null) {
			pICC.setProtocolosPregunta2(pICCAux.getProtocolosPregunta2());
		}
		if (pICCAux.getProtocolosInfraccion2() != null) {
			pICC.setProtocolosInfraccion2(pICCAux.getProtocolosInfraccion2());
		}
		if (pICCAux.getProtocolosTotal2() > 0
				&& pICC.getTotalInfracciones() > 0) {
			pICC.setProtocolosTotal2(pICCAux.getProtocolosTotal2());

			float setProtocolosPorcentaje2 = pICC.getProtocolosTotal2()
					* (float) Y41bConstantes.NUM_100
					/ pICC.getTotalInfracciones();
			pICC.setProtocolosPorcentaje2(Y41bUtils
					.convertFloat2StringFormateado(setProtocolosPorcentaje2)
					+ "%");
		}
		if (pICCAux.getTrcodigo3() != null) {
			pICC.setTrcodigo3(pICCAux.getTrcodigo3());
		}
		if (pICCAux.getTrnrtipp3() != null) {
			pICC.setTrnrtipp3(pICCAux.getTrnrtipp3());
		}
		if (pICCAux.getProtocolosPregunta3() != null) {
			pICC.setProtocolosPregunta3(pICCAux.getProtocolosPregunta3());
		}
		if (pICCAux.getProtocolosInfraccion3() != null) {
			pICC.setProtocolosInfraccion3(pICCAux.getProtocolosInfraccion3());
		}
		if (pICCAux.getProtocolosTotal3() > 0
				&& pICC.getTotalInfracciones() > 0) {
			pICC.setProtocolosTotal3(pICCAux.getProtocolosTotal3());

			float setProtocolosPorcentaje3 = pICC.getProtocolosTotal3()
					* (float) Y41bConstantes.NUM_100
					/ pICC.getTotalInfracciones();
			pICC.setProtocolosPorcentaje3(Y41bUtils
					.convertFloat2StringFormateado(setProtocolosPorcentaje3)
					+ "%");
		}

		if (pICCAux.getTitulo1() != null) {
			if (pICC.getProtocolosPregunta1() != null) {
				pICC.setProtocolosPregunta1(new StringBuffer()
						.append(pICCAux.getTitulo1()).append(" - ")
						.append(pICC.getProtocolosPregunta1()).toString());
			}

		}
		if (pICCAux.getTitulo2() != null) {
			if (pICC.getProtocolosPregunta2() != null) {
				pICC.setProtocolosPregunta2(new StringBuffer()
						.append(pICCAux.getTitulo2()).append(" - ")
						.append(pICC.getProtocolosPregunta2()).toString());
			}
		}
		if (pICCAux.getTitulo3() != null) {
			if (pICC.getProtocolosPregunta3() != null) {
				pICC.setProtocolosPregunta3(new StringBuffer()
						.append(pICCAux.getTitulo3()).append(" - ")
						.append(pICC.getProtocolosPregunta3()).toString());
			}
		}

		if (pICCAux.getProtocolosActas() != null) {
			pICC.setProtocolosActas(pICCAux.getProtocolosActas());
		}
		if (pICCAux.getSumaMuestras() > 0) {
			pICC.setSumaMuestras(pICCAux.getSumaMuestras());

			float porcentajeMuestrasInfraccion = pICC
					.getSumaMuestrasInfraccion()
					* (float) Y41bConstantes.NUM_100 / pICC.getSumaMuestras();
			pICC.setMuestrasPorcentajeInfraccion(Y41bUtils
					.convertFloat2StringFormateado(porcentajeMuestrasInfraccion)
					+ "%");
		}
		if (pICCAux.getSumaMuestrasInfraccion() > 0) {
			pICC.setSumaMuestrasInfraccion(pICCAux.getSumaMuestrasInfraccion());

			float porcentajeMuestrasInfraccion = pICC
					.getSumaMuestrasInfraccion()
					* (float) Y41bConstantes.NUM_100 / pICC.getSumaMuestras();
			pICC.setMuestrasPorcentajeInfraccion(Y41bUtils
					.convertFloat2StringFormateado(porcentajeMuestrasInfraccion)
					+ "%");
		}
		if (pICCAux.getSumaInfraccionesMuestras() > 0) {
			pICC.setSumaInfraccionesMuestras(pICCAux
					.getSumaInfraccionesMuestras());
		}
		if (pICCAux.getMuestrasTextoInfraccion() != null) {
			pICC.setMuestrasTextoInfraccion(pICCAux
					.getMuestrasTextoInfraccion());
		}
		if (pICCAux.getMuestrasActas() != null) {
			pICC.setMuestrasActas(pICCAux.getMuestrasActas());
		}
		if (pICCAux.getPropuestasSSCC() != null) {
			pICC.setPropuestasSSCC(pICCAux.getPropuestasSSCC());
		}
		if (pICCAux.getLocalidadFirma() != null) {
			pICC.setLocalidadFirma(pICCAux.getLocalidadFirma());
		}
		if (pICCAux.getFecha() != null) {
			pICC.setFecha(pICCAux.getFecha());
		}
		if (pICCAux.getEstablecimientosVisitados() != null) {
			pICC.setEstablecimientosVisitados(pICCAux
					.getEstablecimientosVisitados());
		}

		return pICC;
	}

	/**
	 * Metodo encargado de sustituir algunos textos que vienen vacos de la base
	 * de datos.
	 * 
	 * @param pICC
	 *            PlantillaInformeCierreCampanha
	 * @return PlantillaInformeCierreCampanha
	 */
	private PlantillaInformeCierreCampanha rellenarCamposVacios(
			PlantillaInformeCierreCampanha pICC) {
		Locale locale = LocaleContextHolder.getLocale();
		String ninguno = this.appMessageSource.getMessage(
				"plantilla.campanha.ninguno", null, locale);
		String ninguna = this.appMessageSource.getMessage(
				"plantilla.campanha.ninguna", null, locale);

		if (pICC.getProtocolosActas() == null
				|| "".equals(pICC.getProtocolosActas())) {
			pICC.setProtocolosActas(ninguna);
		}
		if (pICC.getEstablecimientosVisitados() == null
				|| "".equals(pICC.getEstablecimientosVisitados())) {
			pICC.setEstablecimientosVisitados(ninguno);
		}
		if (pICC.getMuestrasTextoInfraccion() == null
				|| "".equals(pICC.getMuestrasTextoInfraccion())) {
			pICC.setMuestrasTextoInfraccion(ninguno);
		}
		if (pICC.getMuestrasActas() == null
				|| "".equals(pICC.getMuestrasActas())) {
			pICC.setMuestrasActas(ninguna);
		}
		if (pICC.getPropuestasSSCC() == null
				|| "".equals(pICC.getPropuestasSSCC())) {
			pICC.setPropuestasSSCC(ninguna);
		}

		return pICC;
	}
}
