package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CampanhaCierre;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.PlantillaInformeCierreCampanha;

/**
 * CampanhaCierreService  
 * 
 *  
 */

public interface CampanhaCierreService {

	/**
	 * Inserts a single row in the CampanhaCierre table.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @return CampanhaCierre
	 */
	CampanhaCierre add(CampanhaCierre campanhaCierre);

	/**
	 * Updates a single row in the CampanhaCierre table.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @return CampanhaCierre
	 * @throws Exception
	 *             Exception
	 */
	public CampanhaCierre update(CampanhaCierre campanhaCierre)
			throws Exception;

	/**
	 * Finds a single row in the CampanhaCierre table.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @return CampanhaCierre
	 */
	CampanhaCierre find(CampanhaCierre campanhaCierre);

	/**
	 * Finds a List of rows in the CampanhaCierre table.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<CampanhaCierre> findAll(CampanhaCierre campanhaCierre,
			Pagination pagination);

	/**
	 * Counts rows in the CampanhaCierre table.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @return Long
	 */
	Long findAllCount(CampanhaCierre campanhaCierre);

	/**
	 * Finds rows in the CampanhaCierre table using like.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<CampanhaCierre> findAllLike(CampanhaCierre campanhaCierre,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the CampanhaCierre table using like.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(CampanhaCierre campanhaCierre, Boolean startsWith);

	/**
	 * Deletes a single row in the CampanhaCierre table.
	 * 
	 * @param campanhaCierre
	 *            CampanhaCierre
	 * @return
	 */
	void remove(CampanhaCierre campanhaCierre);

	/**
	 * Deletes multiple rows in the CampanhaCierre table.
	 * 
	 * @param campanhaCierreList
	 *            List
	 * @return
	 */
	void removeMultiple(List<CampanhaCierre> campanhaCierreList);

	/**
	 * Genera el Informe de cierre de campanha
	 * 
	 * @param plantillaInformeCierreCampanha
	 *            PlantillaInformeCierreCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return PlantillaInformeCierreCampanha
	 */
	PlantillaInformeCierreCampanha generarInformeCierreCampanha(
			PlantillaInformeCierreCampanha plantillaInformeCierreCampanha,
			CensoMonitor censoMonitor);
}
