package com.ejie.y41b.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.BandejaSolicitudesDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.TramiteDao;
import com.ejie.y41b.dao.TramiteHechoDao;
import com.ejie.y41b.model.BandejaSolicitudes;
import com.ejie.y41b.model.BandejaSolicitudesBusqueda;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteHechoDetalle;
import com.ejie.y41b.model.TramiteHechoModal;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * BandejaSolicitudesServiceImpl  
 * 
 *  
 */

@Service(value = "bandejaSolicitudesService")
public class BandejaSolicitudesServiceImpl implements BandejaSolicitudesService {

	@Autowired
	private BandejaSolicitudesDao bandejaSolicitudesDao;

	@Autowired
	private DocumentoHechoDao documentoHechoDao;

	@Autowired
	private ParametrosDao parametrosDao;

	@Autowired
	private TramiteHechoDao tramiteHechoDao;

	@Autowired
	private IntervinientesDao intervinientesDao;

	@Autowired
	private TramiteDao tramiteDao;

	@Autowired
	private DenunciaService denunciaService;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return BandejaSolicitudes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public BandejaSolicitudes add(BandejaSolicitudes bandejaSolicitudes) {
		return this.bandejaSolicitudesDao.add(bandejaSolicitudes);
	}

	/**
	 * Updates a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return BandejaSolicitudes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public BandejaSolicitudes update(BandejaSolicitudes bandejaSolicitudes) {
		return this.bandejaSolicitudesDao.update(bandejaSolicitudes);
	}

	/**
	 * Finds a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return BandejaSolicitudes
	 */
	public BandejaSolicitudes find(BandejaSolicitudes bandejaSolicitudes) {
		return (BandejaSolicitudes) this.bandejaSolicitudesDao.find(bandejaSolicitudes);
	}

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudes> findAll(BandejaSolicitudes bandejaSolicitudes, Pagination pagination) {
		return (List<BandejaSolicitudes>) this.bandejaSolicitudesDao.findAll(bandejaSolicitudes, pagination);
	}

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return Long
	 */
	public Long findAllCount(BandejaSolicitudes bandejaSolicitudes) {
		return this.bandejaSolicitudesDao.findAllCount(bandejaSolicitudes);
	}

	/**
	 * Finds rows in the BandejaSolicitudes table using like.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<BandejaSolicitudes> findAllLike(BandejaSolicitudes bandejaSolicitudes, Pagination pagination,
			Boolean startsWith) {
		return (List<BandejaSolicitudes>) this.bandejaSolicitudesDao.findAllLike(bandejaSolicitudes, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the BandejaSolicitudes table using like.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(BandejaSolicitudes bandejaSolicitudes, Boolean startsWith) {
		return this.bandejaSolicitudesDao.findAllLikeCount(bandejaSolicitudes, startsWith);
	}

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudes(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("numExpediente")) {

				pagination.setSort("DECOOR ASC, DENRAN ASC, LPAD(DENROR, 12) ASC,HDNROR ");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("numExpediente")) {

				pagination.setSort("DECOOR DESC, DENRAN DESC, LPAD(DENROR,12) DESC,HDNROR ");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("null")) {
				pagination.setSort("EHFECHA ASC, EHHORA");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("fechatramite")) {
				pagination.setSort("EHFECHA ASC, EHHORA");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("fechatramite")) {
				pagination.setSort("EHFECHA DESC, EHHORA");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}
		List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = this.bandejaSolicitudesDao
				.findAllBandejaSolicitudes(bandejaSolicitudes, censoMonitor, pagination);

		for (BandejaSolicitudesBusqueda bandeja : listBandejaSolicitudesBusqueda) {
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(bandeja.getDecoor()).append("-").append(bandeja.getDenror()).append("-")
					.append(bandeja.getDenran()).append("-").append(bandeja.getHdnror());

			bandeja.setNumExpediente(numeroExpediente.toString());

			// buscar los documentos del tramite
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(bandeja.getEhcodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			// si tiene un solo documento uno meterlo en el objeto
			if (listDocumentoHecho != null && listDocumentoHecho.size() == 1) {
				bandeja.setIndVariosDocumentos(Y41bConstantes.NO);

				bandeja.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
				bandeja.setQ5codocumento(listDocumentoHecho.get(0).getQ5codocumento());
				bandeja.setQ5nofile(listDocumentoHecho.get(0).getQ5nofile());
				bandeja.setQ5sizefile(listDocumentoHecho.get(0).getQ5sizefile());
				bandeja.setQ5contenttypefile(listDocumentoHecho.get(0).getQ5contenttypefile());
				bandeja.setQ5tedesfile(listDocumentoHecho.get(0).getQ5tedesfile());
			} else {
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 1) {
					bandeja.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
					// si tiene mas de un documento
					bandeja.setIndVariosDocumentos(Y41bConstantes.SI);
				}
			}

			if (listDocumentoHecho != null) {
				Parametros parametros = new Parametros();

				parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
				parametros = this.parametrosDao.find(parametros);

				for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
					if (documentoHechoAux.getQ5fechasollocalizador() != null) {
						if (documentoHechoAux != null && documentoHechoAux.getQ5nofile() != null
								&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(documentoHechoAux.getQ5nofile())
										.equalsIgnoreCase(Y41bConstantes.PDF)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {

							int minutos = 0;
							if (parametros != null && parametros.getValor() != null
									&& Y41bUtils.isNumeric(parametros.getValor())) {
								minutos = Integer.parseInt(parametros.getValor());
							}

							SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

							Date d1 = null;
							Date d2 = null;
							long diffMinutes = 0;
							try {
								d1 = format.parse(format.format(documentoHechoAux.getQ5fechasollocalizador()));

								d2 = format.parse(format.format(new Date()));

								long diff = d2.getTime() - d1.getTime();

								diffMinutes = diff / (60 * 1000);
							} catch (ParseException e) {
								diffMinutes = 0;
							}

							if (diffMinutes > minutos) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
							} else {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
							}
						} else {
							if (bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
							} else if (!bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
									&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
									&& !bandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
									&& !bandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
									&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
							}
						}
					}
				}
			}
			if (bandeja != null && bandeja.getNombre() != null && !bandeja.getNombre().equals("")) {
				bandeja.setQ5origen(bandeja.getNombre());
			}

			if (bandeja.getEhfechaEnvioBOPVBOE() != null) {
				if (!bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(bandeja.getTrnombre());
					sbTrnombre.append(" (");
					sbTrnombre.append(
							Y41bUtils.parseDateToString(bandeja.getEhfechaEnvioBOPVBOE(), Y41bConstantes.CASTELLANO));
					sbTrnombre.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(bandeja.getTrnombree());
					sbTrnombree.append(" (");
					sbTrnombree.append(
							Y41bUtils.parseDateToString(bandeja.getEhfechaEnvioBOPVBOE(), Y41bConstantes.EUSKERA));
					sbTrnombree.append(")");

					bandeja.setTrnombre(sbTrnombre.toString());
					bandeja.setTrnombree(sbTrnombree.toString());
				}
			}

		}

		return listBandejaSolicitudesBusqueda;
	}

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor) {
		return this.bandejaSolicitudesDao.findAllBandejaSolicitudesCount(bandejaSolicitudes, censoMonitor);
	}

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TramiteHechoModal> findAllTramitesPendientesSolicitudesBandejas(BandejaSolicitudes bandejaSolicitudes,
			Pagination pagination) {

		// Recupera la lista de tramites del expediente
		TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
		tramiteHechoDetalle.setHdcodigo(bandejaSolicitudes.getHdcodigo());

		List<TramiteHechoDetalle> listTramiteHechoDetalle = this.denunciaService
				.findAllTramiteHecho(tramiteHechoDetalle, null);

		// Guardar esa informacion en el Hashmap - idTramite + Tramite
		Map<String, TramiteHechoDetalle> mapaTramiteHechoDetalle = new HashMap<String, TramiteHechoDetalle>();

		ListIterator iter = listTramiteHechoDetalle.listIterator(listTramiteHechoDetalle.size());

		TramiteHechoDetalle tramiteHechoDetalleAux1 = null;

		while (iter.hasPrevious()) {
			tramiteHechoDetalleAux1 = (TramiteHechoDetalle) iter.previous();
			mapaTramiteHechoDetalle.put(tramiteHechoDetalleAux1.getEhcodigo(), tramiteHechoDetalleAux1);
		}

		// Recorrer la lista de tramites pendientes y completar con valor de
		// nbfase eu y es

		List<TramiteHechoModal> listBandejaTramitesPendientes = this.bandejaSolicitudesDao
				.findAllTramitesPendientesSolicitudesBandejas(bandejaSolicitudes, pagination);

		for (TramiteHechoModal tramitesModalBandeja : listBandejaTramitesPendientes) {

			tramiteHechoDetalleAux1 = mapaTramiteHechoDetalle.get(tramitesModalBandeja.getEhcodigo());

			tramitesModalBandeja.setFnombre(tramiteHechoDetalleAux1.getFnombre());
			tramitesModalBandeja.setFnombree(tramiteHechoDetalleAux1.getFnombree());

			// buscar los documentos del tramite
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(tramitesModalBandeja.getEhcodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			if (listDocumentoHecho != null) {
				Parametros parametros = new Parametros();

				parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
				parametros = this.parametrosDao.find(parametros);

				for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
					if (documentoHechoAux.getQ5fechasollocalizador() != null) {
						if (documentoHechoAux != null && documentoHechoAux.getQ5nofile() != null
								&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(documentoHechoAux.getQ5nofile())
										.equalsIgnoreCase(Y41bConstantes.PDF)
								&& !tramitesModalBandeja.getEstadotramite()
										.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
								&& !tramitesModalBandeja.getEstadotramite()
										.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
								&& !tramitesModalBandeja.getEstadotramite()
										.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {

							int minutos = 0;
							if (parametros != null && parametros.getValor() != null
									&& Y41bUtils.isNumeric(parametros.getValor())) {
								minutos = Integer.parseInt(parametros.getValor());
							}

							SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

							Date d1 = null;
							Date d2 = null;
							long diffMinutes = 0;
							try {
								d1 = format.parse(format.format(documentoHechoAux.getQ5fechasollocalizador()));

								d2 = format.parse(format.format(new Date()));

								long diff = d2.getTime() - d1.getTime();

								diffMinutes = diff / (60 * 1000);
							} catch (ParseException e) {
								diffMinutes = 0;
							}

							if (diffMinutes > minutos) {
								tramitesModalBandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
							} else {
								tramitesModalBandeja
										.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
							}
						} else {
							if (tramitesModalBandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
								tramitesModalBandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
							} else if (!tramitesModalBandeja.getEstadotramite()
									.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
									&& !tramitesModalBandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
									&& !tramitesModalBandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
									&& !tramitesModalBandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
									&& !tramitesModalBandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
								tramitesModalBandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
							}
						}
					}
				}
			}

			if (tramitesModalBandeja.getEhfechaEnvioBOPVBOE() != null) {
				if (!tramitesModalBandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(tramitesModalBandeja.getTrnombre());
					sbTrnombre.append(" (");
					sbTrnombre.append(Y41bUtils.parseDateToString(tramitesModalBandeja.getEhfechaEnvioBOPVBOE(),
							Y41bConstantes.CASTELLANO));
					sbTrnombre.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(tramitesModalBandeja.getTrnombree());
					sbTrnombree.append(" (");
					sbTrnombree.append(Y41bUtils.parseDateToString(tramitesModalBandeja.getEhfechaEnvioBOPVBOE(),
							Y41bConstantes.EUSKERA));
					sbTrnombree.append(")");

					tramitesModalBandeja.setTrnombre(sbTrnombre.toString());
					tramitesModalBandeja.setTrnombree(sbTrnombree.toString());
				}
			}

			if (tramitesModalBandeja.getEhistelematico() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(tramitesModalBandeja.getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.CASTELLANO)));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(tramitesModalBandeja.getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
				sbTrnombree.append(")");

				tramitesModalBandeja.setTrnombre(sbTrnombre.toString());
				tramitesModalBandeja.setTrnombree(sbTrnombree.toString());
			}

			// Mostrar una observacin que depende del tipo de tramite
			if (Y41bConstantes.TRAMITE_COMUNICACION.equals(tramitesModalBandeja.getTrcodigo())
					|| Y41bConstantes.TRAMITE_NOTIFICACION.equals(tramitesModalBandeja.getTrcodigo())
					|| Y41bConstantes.TRAMITE_ACUSE_RECIBO.equals(tramitesModalBandeja.getTrcodigo())
					|| Y41bConstantes.TRAMITE_ALEGACION.equals(tramitesModalBandeja.getTrcodigo())) {

				// Datos de tramite del hecho
				TramiteHecho tramiteHechoDetalleAux = new TramiteHecho();
				tramiteHechoDetalleAux.setEhcodigo(tramitesModalBandeja.getEhcodigo());
				tramiteHechoDetalleAux = this.tramiteHechoDao.find(tramiteHechoDetalleAux);

				// Datos de tramite (tabla basica)
				if (null != tramiteHechoDetalleAux.getTramiteHecho().getEhcodigo()
						&& !"".equals(tramiteHechoDetalleAux.getTramiteHecho().getEhcodigo())) {

					TramiteHecho tramiteOrigenYRelacionado = new TramiteHecho();
					tramiteOrigenYRelacionado.setEhcodigo(tramiteHechoDetalleAux.getTramiteHecho().getEhcodigo());
					tramiteOrigenYRelacionado = this.tramiteHechoDao.find(tramiteOrigenYRelacionado);

					// Datos de tramite (tabla basica)
					Tramite tramite = new Tramite();
					if (null != tramiteOrigenYRelacionado.getTramiteHecho().getEhcotee()
							&& !"".equals(tramiteOrigenYRelacionado.getTramiteHecho().getEhcotee())) {
						tramite.setTrcodigo(tramiteOrigenYRelacionado.getTramiteHecho().getEhcotee());

						tramitesModalBandeja
								.setObs_tramiteOrigenFecha(tramiteOrigenYRelacionado.getTramiteHecho().getEhfecha());
					} else {
						tramite.setTrcodigo(tramiteHechoDetalleAux.getTramiteHecho().getEhcotee());

						tramitesModalBandeja
								.setObs_tramiteOrigenFecha(tramiteHechoDetalleAux.getTramiteHecho().getEhfecha());
					}
					tramite = this.tramiteDao.find(tramite);

					tramitesModalBandeja.setObs_tramiteOrigenNombre(tramite.getTrnombre());
					tramitesModalBandeja.setObs_tramiteOrigenNombree(tramite.getTrnombree());
				}

				// notificaciones/comunicaciones: Nombre del destinatario
				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdinterviniente(tramiteHechoDetalleAux.getEhiddestinatario());
				intervinientes = this.intervinientesDao.find(intervinientes);
				if (null != intervinientes) {
					StringBuffer sbPerson = new StringBuffer();
					if (Y41bUtils.isFilled(intervinientes.getEsnoco())) {
						sbPerson.append(intervinientes.getEsnoco());
						sbPerson.append(" ");
					} else {
						if (Y41bUtils.isFilled(intervinientes.getNombre())) {
							sbPerson.append(intervinientes.getNombre());
							sbPerson.append(" ");
						}
						if (Y41bUtils.isFilled(intervinientes.getApellido1())) {
							sbPerson.append(intervinientes.getApellido1());
							sbPerson.append(" ");
						}
						if (Y41bUtils.isFilled(intervinientes.getApellido2())) {
							sbPerson.append(intervinientes.getApellido2());
							sbPerson.append(" ");
						}
					}
					tramitesModalBandeja.setObs_destinatarioNombre(sbPerson.toString());

					// notificaciones/comunicaciones: Tipo de destinatario
					tramitesModalBandeja.setObs_tipoDestinatario(intervinientes.getTipoInterviniente());
				}

				// registro alegaciones: origen
				tramitesModalBandeja.setObs_tipoOrigen(tramiteHechoDetalleAux.getEhorigenalegacion());

			}
		}

		return listBandejaTramitesPendientes;
	}

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllTramitesPendientesSolicitudesBandejasCount(BandejaSolicitudes bandejaSolicitudes) {
		return this.bandejaSolicitudesDao.findAllTramitesPendientesSolicitudesBandejasCount(bandejaSolicitudes);
	}

	/**
	 * Deletes a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(BandejaSolicitudes bandejaSolicitudes) {
		this.bandejaSolicitudesDao.remove(bandejaSolicitudes);
	}

	/**
	 * Deletes multiple rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudesList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<BandejaSolicitudes> bandejaSolicitudesList) {
		for (BandejaSolicitudes bandejaSolicitudesAux : bandejaSolicitudesList) {
			this.bandejaSolicitudesDao.remove(bandejaSolicitudesAux);
		}
	}

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesAdministrativo(
			BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta,
			String excluirAcuses, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("numExpediente")) {

				pagination.setSort("DECOOR ASC, DENRAN ASC, LPAD(DENROR, 12) ASC,HDNROR ");

			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("numExpediente")) {
				pagination.setSort("DECOOR DESC, DENRAN DESC, LPAD(DENROR,12) DESC,HDNROR ");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("null")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("fechatramite")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("fechatramite")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}

		if (pagination != null) {
			if (pagination.getSidx() != null && pagination.getSidx().startsWith("numTramitesPendientes")) {
				pagination.setSidx("num_pdtes");
			}
		}

		List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = this.bandejaSolicitudesDao
				.findAllBandejaSolicitudesAdministrativo(bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						excluirAcuses, pagination);

		for (BandejaSolicitudesBusqueda bandeja : listBandejaSolicitudesBusqueda) {
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(bandeja.getDecoor()).append("-").append(bandeja.getDenror()).append("-")
					.append(bandeja.getDenran()).append("-").append(bandeja.getHdnror());

			bandeja.setNumExpediente(numeroExpediente.toString());

			// buscar los documentos del tramite
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(bandeja.getEhcodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			// si tiene un solo documento uno meterlo en el objeto
			if (listDocumentoHecho != null && listDocumentoHecho.size() == 1) {
				bandeja.setIndVariosDocumentos(Y41bConstantes.NO);

				bandeja.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
				bandeja.setQ5codocumento(listDocumentoHecho.get(0).getQ5codocumento());
				bandeja.setQ5nofile(listDocumentoHecho.get(0).getQ5nofile());
				bandeja.setQ5sizefile(listDocumentoHecho.get(0).getQ5sizefile());
				bandeja.setQ5contenttypefile(listDocumentoHecho.get(0).getQ5contenttypefile());
				bandeja.setQ5tedesfile(listDocumentoHecho.get(0).getQ5tedesfile());
			} else {
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 1) {
					bandeja.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
					// si tiene mas de un documento
					bandeja.setIndVariosDocumentos(Y41bConstantes.SI);
				}
			}

			if (listDocumentoHecho != null) {
				Parametros parametros = new Parametros();

				parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
				parametros = this.parametrosDao.find(parametros);

				for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
					if (documentoHechoAux.getQ5fechasollocalizador() != null) {
						if (documentoHechoAux != null && documentoHechoAux.getQ5nofile() != null
								&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(documentoHechoAux.getQ5nofile())
										.equalsIgnoreCase(Y41bConstantes.PDF)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {

							int minutos = 0;
							if (parametros != null && parametros.getValor() != null
									&& Y41bUtils.isNumeric(parametros.getValor())) {
								minutos = Integer.parseInt(parametros.getValor());
							}

							SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

							Date d1 = null;
							Date d2 = null;
							long diffMinutes = 0;
							try {
								d1 = format.parse(format.format(documentoHechoAux.getQ5fechasollocalizador()));

								d2 = format.parse(format.format(new Date()));

								long diff = d2.getTime() - d1.getTime();

								diffMinutes = diff / (60 * 1000);
							} catch (ParseException e) {
								diffMinutes = 0;
							}

							if (diffMinutes > minutos) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
							} else {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
							}
						} else {
							if (bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
							} else if (!bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
									&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
									&& !bandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
									&& !bandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
									&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
							}
						}
					}
				}
			}
			if (bandeja != null && bandeja.getNombre() != null && !bandeja.getNombre().equals("")) {
				bandeja.setQ5origen(bandeja.getNombre());
			}

			if (bandeja.getEhfechaEnvioBOPVBOE() != null) {
				if (!bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(bandeja.getTrnombre());
					sbTrnombre.append(" (");
					sbTrnombre.append(
							Y41bUtils.parseDateToString(bandeja.getEhfechaEnvioBOPVBOE(), Y41bConstantes.CASTELLANO));
					sbTrnombre.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(bandeja.getTrnombree());
					sbTrnombree.append(" (");
					sbTrnombree.append(
							Y41bUtils.parseDateToString(bandeja.getEhfechaEnvioBOPVBOE(), Y41bConstantes.EUSKERA));
					sbTrnombree.append(")");

					bandeja.setTrnombre(sbTrnombre.toString());
					bandeja.setTrnombree(sbTrnombree.toString());
				}
			}

			if (bandeja.getEhistelematico() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(bandeja.getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.CASTELLANO)));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(bandeja.getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
				sbTrnombree.append(")");

				bandeja.setTrnombre(sbTrnombre.toString());
				bandeja.setTrnombree(sbTrnombree.toString());
			}
		}

		return listBandejaSolicitudesBusqueda;
	}

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesAdministrativoCount(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {
		return this.bandejaSolicitudesDao.findAllBandejaSolicitudesAdministrativoCount(bandejaSolicitudes, censoMonitor,
				trFechaDesde, trFechaHasta, excluirAcuses);
	}

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param conStandBy
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesENYPD(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp,
			Boolean conStandBy, String excluirAcuses, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("numExpediente")) {
				pagination.setSort("DECOOR ASC, DENRAN ASC, LPAD(DENROR, 12) ASC,HDNROR ");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("numExpediente")) {
				pagination.setSort("DECOOR DESC, DENRAN DESC, LPAD(DENROR,12) DESC,HDNROR ");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("null")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("fechatramite")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("fechatramite")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}

		if (pagination != null) {
			if (pagination.getSidx() != null && pagination.getSidx().startsWith("numTramitesPendientes")) {
				pagination.setSidx("num_pdtes");
			}
		}

		List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = this.bandejaSolicitudesDao
				.findAllBandejaSolicitudesENYPD(bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						conAsignacionResp, conStandBy, excluirAcuses, pagination);

		for (BandejaSolicitudesBusqueda bandeja : listBandejaSolicitudesBusqueda) {
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(bandeja.getDecoor()).append("-").append(bandeja.getDenror()).append("-")
					.append(bandeja.getDenran()).append("-").append(bandeja.getHdnror());

			bandeja.setNumExpediente(numeroExpediente.toString());

			// buscar los documentos del tramite
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(bandeja.getEhcodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			// si tiene un solo documento uno meterlo en el objeto
			if (listDocumentoHecho != null && listDocumentoHecho.size() == 1) {
				bandeja.setIndVariosDocumentos(Y41bConstantes.NO);

				bandeja.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
				bandeja.setQ5codocumento(listDocumentoHecho.get(0).getQ5codocumento());
				bandeja.setQ5nofile(listDocumentoHecho.get(0).getQ5nofile());
				bandeja.setQ5sizefile(listDocumentoHecho.get(0).getQ5sizefile());
				bandeja.setQ5contenttypefile(listDocumentoHecho.get(0).getQ5contenttypefile());
				bandeja.setQ5tedesfile(listDocumentoHecho.get(0).getQ5tedesfile());
			} else {
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 1) {
					bandeja.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
					// si tiene mas de un documento
					bandeja.setIndVariosDocumentos(Y41bConstantes.SI);
				}
			}

			if (listDocumentoHecho != null) {
				Parametros parametros = new Parametros();

				parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
				parametros = this.parametrosDao.find(parametros);

				for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
					if (documentoHechoAux.getQ5fechasollocalizador() != null) {
						if (documentoHechoAux != null && documentoHechoAux.getQ5nofile() != null
								&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(documentoHechoAux.getQ5nofile())
										.equalsIgnoreCase(Y41bConstantes.PDF)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {

							int minutos = 0;
							if (parametros != null && parametros.getValor() != null
									&& Y41bUtils.isNumeric(parametros.getValor())) {
								minutos = Integer.parseInt(parametros.getValor());
							}

							SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

							Date d1 = null;
							Date d2 = null;
							long diffMinutes = 0;
							try {
								d1 = format.parse(format.format(documentoHechoAux.getQ5fechasollocalizador()));

								d2 = format.parse(format.format(new Date()));

								long diff = d2.getTime() - d1.getTime();

								diffMinutes = diff / (60 * 1000);
							} catch (ParseException e) {
								diffMinutes = 0;
							}

							if (diffMinutes > minutos) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
							} else {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
							}
						} else {
							if (bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
							} else if (!bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
									&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
									&& !bandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
									&& !bandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
									&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
							}
						}
					}
				}
			}
			if (bandeja != null && bandeja.getNombre() != null && !bandeja.getNombre().equals("")) {
				bandeja.setQ5origen(bandeja.getNombre());
			}

			if (bandeja.getEhfechaEnvioBOPVBOE() != null) {
				if (!bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(bandeja.getTrnombre());
					sbTrnombre.append(" (");
					sbTrnombre.append(
							Y41bUtils.parseDateToString(bandeja.getEhfechaEnvioBOPVBOE(), Y41bConstantes.CASTELLANO));
					sbTrnombre.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(bandeja.getTrnombree());
					sbTrnombree.append(" (");
					sbTrnombree.append(
							Y41bUtils.parseDateToString(bandeja.getEhfechaEnvioBOPVBOE(), Y41bConstantes.EUSKERA));
					sbTrnombree.append(")");

					bandeja.setTrnombre(sbTrnombre.toString());
					bandeja.setTrnombree(sbTrnombree.toString());
				}
			}

			if (bandeja.getEhistelematico() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(bandeja.getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.CASTELLANO)));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(bandeja.getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
				sbTrnombree.append(")");

				bandeja.setTrnombre(sbTrnombre.toString());
				bandeja.setTrnombree(sbTrnombree.toString());
			}

		}

		return listBandejaSolicitudesBusqueda;
	}

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param conStandBy
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesENYPDCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp, Boolean conStandBy, String excluirAcuses) {
		return this.bandejaSolicitudesDao.findAllBandejaSolicitudesENYPDCount(bandejaSolicitudes, censoMonitor,
				trFechaDesde, trFechaHasta, conAsignacionResp, conStandBy, excluirAcuses);
	}

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesECTP(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("numExpediente")) {

				pagination.setSort("DECOOR ASC, DENRAN ASC, LPAD(DENROR, 12) ASC,HDNROR ");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("numExpediente")) {
				pagination.setSort("DECOOR DESC, DENRAN DESC, LPAD(DENROR,12) DESC,HDNROR ");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("null")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("fechatramite")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("fechatramite")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}

		if (pagination != null) {
			if (pagination.getSidx() != null && pagination.getSidx().startsWith("numTramitesPendientes")) {
				pagination.setSidx("num_pdtes");
			}
		}

		List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = this.bandejaSolicitudesDao
				.findAllBandejaSolicitudesECTP(bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						pagination);

		for (BandejaSolicitudesBusqueda bandeja : listBandejaSolicitudesBusqueda) {
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(bandeja.getDecoor()).append("-").append(bandeja.getDenror()).append("-")
					.append(bandeja.getDenran()).append("-").append(bandeja.getHdnror());

			bandeja.setNumExpediente(numeroExpediente.toString());

			// buscar los documentos del tramite
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(bandeja.getEhcodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			// si tiene un solo documento uno meterlo en el objeto
			if (listDocumentoHecho != null && listDocumentoHecho.size() == 1) {
				bandeja.setIndVariosDocumentos(Y41bConstantes.NO);

				bandeja.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
				bandeja.setQ5codocumento(listDocumentoHecho.get(0).getQ5codocumento());
				bandeja.setQ5nofile(listDocumentoHecho.get(0).getQ5nofile());
				bandeja.setQ5sizefile(listDocumentoHecho.get(0).getQ5sizefile());
				bandeja.setQ5contenttypefile(listDocumentoHecho.get(0).getQ5contenttypefile());
				bandeja.setQ5tedesfile(listDocumentoHecho.get(0).getQ5tedesfile());
			} else {
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 1) {
					bandeja.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
					// si tiene mas de un documento
					bandeja.setIndVariosDocumentos(Y41bConstantes.SI);
				}
			}

			if (listDocumentoHecho != null) {
				Parametros parametros = new Parametros();

				parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
				parametros = this.parametrosDao.find(parametros);

				for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
					if (documentoHechoAux.getQ5fechasollocalizador() != null) {
						if (documentoHechoAux != null && documentoHechoAux.getQ5nofile() != null
								&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(documentoHechoAux.getQ5nofile())
										.equalsIgnoreCase(Y41bConstantes.PDF)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {

							int minutos = 0;
							if (parametros != null && parametros.getValor() != null
									&& Y41bUtils.isNumeric(parametros.getValor())) {
								minutos = Integer.parseInt(parametros.getValor());
							}

							SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

							Date d1 = null;
							Date d2 = null;
							long diffMinutes = 0;
							try {
								d1 = format.parse(format.format(documentoHechoAux.getQ5fechasollocalizador()));

								d2 = format.parse(format.format(new Date()));

								long diff = d2.getTime() - d1.getTime();

								diffMinutes = diff / (60 * 1000);
							} catch (ParseException e) {
								diffMinutes = 0;
							}

							if (diffMinutes > minutos) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
							} else {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
							}
						} else {
							if (bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
							} else if (!bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
									&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
									&& !bandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
									&& !bandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
									&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
							}
						}
					}
				}
			}
			if (bandeja != null && bandeja.getNombre() != null && !bandeja.getNombre().equals("")) {
				bandeja.setQ5origen(bandeja.getNombre());
			}

			if (bandeja.getEhfechaEnvioBOPVBOE() != null) {
				if (!bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(bandeja.getTrnombre());
					sbTrnombre.append(" (");
					sbTrnombre.append(
							Y41bUtils.parseDateToString(bandeja.getEhfechaEnvioBOPVBOE(), Y41bConstantes.CASTELLANO));
					sbTrnombre.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(bandeja.getTrnombree());
					sbTrnombree.append(" (");
					sbTrnombree.append(
							Y41bUtils.parseDateToString(bandeja.getEhfechaEnvioBOPVBOE(), Y41bConstantes.EUSKERA));
					sbTrnombree.append(")");

					bandeja.setTrnombre(sbTrnombre.toString());
					bandeja.setTrnombree(sbTrnombree.toString());
				}
			}
			// TELEMATICA O APORTACIONES DE Y41R
			if ((bandeja.getEhistelematico() != null) || (bandeja.getEhIsWebSinCertificado() != null
					&& bandeja.getEhIsWebSinCertificado().equalsIgnoreCase(Y41bConstantes.VALOR_SI))) {

				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(bandeja.getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.CASTELLANO)));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(bandeja.getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
				sbTrnombree.append(")");

				bandeja.setTrnombre(sbTrnombre.toString());
				bandeja.setTrnombree(sbTrnombree.toString());
			}

			// Consulta si hay documentos pendiente de firma
			DocumentoHecho documentoHechoAux = new DocumentoHecho();
			documentoHechoAux.setQ5hdcodigo(bandeja.getHdcodigo());
			documentoHechoAux.setQ5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			Long numDocumentosPendienteFirma = this.documentoHechoDao.findAllCount(documentoHechoAux);
			if (numDocumentosPendienteFirma > 0) {
				bandeja.setEstadoFirma(Y41bConstantes.VALOR_SI);
			}
		}

		return listBandejaSolicitudesBusqueda;
	}

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * 
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesECTPCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta) {
		return this.bandejaSolicitudesDao.findAllBandejaSolicitudesECTPCount(bandejaSolicitudes, censoMonitor,
				trFechaDesde, trFechaHasta);
	}

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesECTPO(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses,
			Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("numExpediente")) {
				pagination.setSort("DECOOR ASC, DENRAN ASC, LPAD(DENROR, 12) ASC,HDNROR ");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("numExpediente")) {
				pagination.setSort("DECOOR DESC, DENRAN DESC, LPAD(DENROR,12) DESC,HDNROR ");

			}
		}

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("null")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("fechatramite")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("fechatramite")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}

		if (pagination != null) {
			if (pagination.getSidx() != null && pagination.getSidx().startsWith("numTramitesPendientes")) {
				pagination.setSidx("num_pdtes");
			}
		}

		List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = this.bandejaSolicitudesDao
				.findAllBandejaSolicitudesECTPO(bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						excluirAcuses, pagination);

		for (BandejaSolicitudesBusqueda bandeja : listBandejaSolicitudesBusqueda) {
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(bandeja.getDecoor()).append("-").append(bandeja.getDenror()).append("-")
					.append(bandeja.getDenran()).append("-").append(bandeja.getHdnror());

			bandeja.setNumExpediente(numeroExpediente.toString());

			// buscar los documentos del tramite
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(bandeja.getEhcodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			// si tiene un solo documento uno meterlo en el objeto
			if (listDocumentoHecho != null && listDocumentoHecho.size() == 1) {
				bandeja.setIndVariosDocumentos(Y41bConstantes.NO);

				bandeja.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
				bandeja.setQ5codocumento(listDocumentoHecho.get(0).getQ5codocumento());
				bandeja.setQ5nofile(listDocumentoHecho.get(0).getQ5nofile());
				bandeja.setQ5sizefile(listDocumentoHecho.get(0).getQ5sizefile());
				bandeja.setQ5contenttypefile(listDocumentoHecho.get(0).getQ5contenttypefile());
				bandeja.setQ5tedesfile(listDocumentoHecho.get(0).getQ5tedesfile());
			} else {
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 1) {
					bandeja.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
					// si tiene mas de un documento
					bandeja.setIndVariosDocumentos(Y41bConstantes.SI);
				}
			}

			if (listDocumentoHecho != null) {
				Parametros parametros = new Parametros();

				parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
				parametros = this.parametrosDao.find(parametros);

				for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
					if (documentoHechoAux.getQ5fechasollocalizador() != null) {
						if (documentoHechoAux != null && documentoHechoAux.getQ5nofile() != null
								&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(documentoHechoAux.getQ5nofile())
										.equalsIgnoreCase(Y41bConstantes.PDF)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {

							int minutos = 0;
							if (parametros != null && parametros.getValor() != null
									&& Y41bUtils.isNumeric(parametros.getValor())) {
								minutos = Integer.parseInt(parametros.getValor());
							}

							SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

							Date d1 = null;
							Date d2 = null;
							long diffMinutes = 0;
							try {
								d1 = format.parse(format.format(documentoHechoAux.getQ5fechasollocalizador()));

								d2 = format.parse(format.format(new Date()));

								long diff = d2.getTime() - d1.getTime();

								diffMinutes = diff / (60 * 1000);
							} catch (ParseException e) {
								diffMinutes = 0;
							}

							if (diffMinutes > minutos) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
							} else {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
							}
						} else {
							if (bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
							} else if (!bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
									&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
									&& !bandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
									&& !bandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
									&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
							}
						}
					}
				}
			}
			if (bandeja != null && bandeja.getNombre() != null && !bandeja.getNombre().equals("")) {
				bandeja.setQ5origen(bandeja.getNombre());
			}

			if (bandeja.getEhfechaEnvioBOPVBOE() != null) {
				if (!bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(bandeja.getTrnombre());
					sbTrnombre.append(" (");
					sbTrnombre.append(
							Y41bUtils.parseDateToString(bandeja.getEhfechaEnvioBOPVBOE(), Y41bConstantes.CASTELLANO));
					sbTrnombre.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(bandeja.getTrnombree());
					sbTrnombree.append(" (");
					sbTrnombree.append(
							Y41bUtils.parseDateToString(bandeja.getEhfechaEnvioBOPVBOE(), Y41bConstantes.EUSKERA));
					sbTrnombree.append(")");

					bandeja.setTrnombre(sbTrnombre.toString());
					bandeja.setTrnombree(sbTrnombree.toString());
				}
			}

			if (bandeja.getEhistelematico() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(bandeja.getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.CASTELLANO)));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(bandeja.getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
				sbTrnombree.append(")");

				bandeja.setTrnombre(sbTrnombre.toString());
				bandeja.setTrnombree(sbTrnombree.toString());
			}

			// Consulta si hay documentos pendiente de firma
			DocumentoHecho documentoHechoAux = new DocumentoHecho();
			documentoHechoAux.setQ5hdcodigo(bandeja.getHdcodigo());
			documentoHechoAux.setQ5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			Long numDocumentosPendienteFirma = this.documentoHechoDao.findAllCount(documentoHechoAux);
			if (numDocumentosPendienteFirma > 0) {
				bandeja.setEstadoFirma(Y41bConstantes.VALOR_SI);
			}
		}

		return listBandejaSolicitudesBusqueda;
	}

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesECTPOCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {
		return this.bandejaSolicitudesDao.findAllBandejaSolicitudesECTPOCount(bandejaSolicitudes, censoMonitor,
				trFechaDesde, trFechaHasta, excluirAcuses);
	}

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesEONYPD(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp,
			String excluirAcuses, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("numExpediente")) {
				pagination.setSort("DECOOR ASC, DENRAN ASC, LPAD(DENROR, 12) ASC,HDNROR ");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("numExpediente")) {
				pagination.setSort("DECOOR DESC, DENRAN DESC, LPAD(DENROR,12) DESC,HDNROR ");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("null")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("fechatramite")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("fechatramite")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}

		if (pagination != null) {
			if (pagination.getSidx() != null && pagination.getSidx().startsWith("numTramitesPendientes")) {
				pagination.setSidx("num_pdtes");
			}
		}

		List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = this.bandejaSolicitudesDao
				.findAllBandejaSolicitudesEONYPD(bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						conAsignacionResp, excluirAcuses, pagination);

		for (BandejaSolicitudesBusqueda bandeja : listBandejaSolicitudesBusqueda) {
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(bandeja.getDecoor()).append("-").append(bandeja.getDenror()).append("-")
					.append(bandeja.getDenran()).append("-").append(bandeja.getHdnror());

			bandeja.setNumExpediente(numeroExpediente.toString());

			// buscar los documentos del tramite
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(bandeja.getEhcodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			// si tiene un solo documento uno meterlo en el objeto
			if (listDocumentoHecho != null && listDocumentoHecho.size() == 1) {
				bandeja.setIndVariosDocumentos(Y41bConstantes.NO);

				bandeja.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
				bandeja.setQ5codocumento(listDocumentoHecho.get(0).getQ5codocumento());
				bandeja.setQ5nofile(listDocumentoHecho.get(0).getQ5nofile());
				bandeja.setQ5sizefile(listDocumentoHecho.get(0).getQ5sizefile());
				bandeja.setQ5contenttypefile(listDocumentoHecho.get(0).getQ5contenttypefile());
				bandeja.setQ5tedesfile(listDocumentoHecho.get(0).getQ5tedesfile());
			} else {
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 1) {
					bandeja.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
					// si tiene mas de un documento
					bandeja.setIndVariosDocumentos(Y41bConstantes.SI);
				}
			}

			if (listDocumentoHecho != null) {
				Parametros parametros = new Parametros();

				parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
				parametros = this.parametrosDao.find(parametros);

				for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
					if (documentoHechoAux.getQ5fechasollocalizador() != null) {
						if (documentoHechoAux != null && documentoHechoAux.getQ5nofile() != null
								&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(documentoHechoAux.getQ5nofile())
										.equalsIgnoreCase(Y41bConstantes.PDF)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {

							int minutos = 0;
							if (parametros != null && parametros.getValor() != null
									&& Y41bUtils.isNumeric(parametros.getValor())) {
								minutos = Integer.parseInt(parametros.getValor());
							}

							SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

							Date d1 = null;
							Date d2 = null;
							long diffMinutes = 0;
							try {
								d1 = format.parse(format.format(documentoHechoAux.getQ5fechasollocalizador()));

								d2 = format.parse(format.format(new Date()));

								long diff = d2.getTime() - d1.getTime();

								diffMinutes = diff / (60 * 1000);
							} catch (ParseException e) {
								diffMinutes = 0;
							}

							if (diffMinutes > minutos) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
							} else {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
							}
						} else {
							if (bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
							} else if (!bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
									&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
									&& !bandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
									&& !bandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
									&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
							}
						}
					}
				}
			}
			if (bandeja != null && bandeja.getNombre() != null && !bandeja.getNombre().equals("")) {
				bandeja.setQ5origen(bandeja.getNombre());
			}

			if (bandeja.getEhfechaEnvioBOPVBOE() != null) {
				if (!bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(bandeja.getTrnombre());
					sbTrnombre.append(" (");
					sbTrnombre.append(
							Y41bUtils.parseDateToString(bandeja.getEhfechaEnvioBOPVBOE(), Y41bConstantes.CASTELLANO));
					sbTrnombre.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(bandeja.getTrnombree());
					sbTrnombree.append(" (");
					sbTrnombree.append(
							Y41bUtils.parseDateToString(bandeja.getEhfechaEnvioBOPVBOE(), Y41bConstantes.EUSKERA));
					sbTrnombree.append(")");

					bandeja.setTrnombre(sbTrnombre.toString());
					bandeja.setTrnombree(sbTrnombree.toString());
				}
			}

			if (bandeja.getEhistelematico() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(bandeja.getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.CASTELLANO)));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(bandeja.getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
				sbTrnombree.append(")");

				bandeja.setTrnombre(sbTrnombre.toString());
				bandeja.setTrnombree(sbTrnombree.toString());
			}
		}

		return listBandejaSolicitudesBusqueda;
	}

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesEONYPDCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp, String excluirAcuses) {
		return this.bandejaSolicitudesDao.findAllBandejaSolicitudesEONYPDCount(bandejaSolicitudes, censoMonitor,
				trFechaDesde, trFechaHasta, conAsignacionResp, excluirAcuses);
	}

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesEOCTP(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses,
			Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("numExpediente")) {
				pagination.setSort("DECOOR ASC, DENRAN ASC, LPAD(DENROR, 12) ASC,HDNROR ");
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("numExpediente")) {
				pagination.setSort("DECOOR DESC, DENRAN DESC, LPAD(DENROR,12) DESC,HDNROR ");

			}
		}

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("null")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("fechatramite")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("fechatramite")) {
				pagination.setSort("FECHATRAMITE");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}

		if (pagination != null) {
			if (pagination.getSidx() != null && pagination.getSidx().startsWith("numTramitesPendientes")) {
				pagination.setSidx("num_pdtes");
			}
		}

		List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = this.bandejaSolicitudesDao
				.findAllBandejaSolicitudesEOCTP(bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						excluirAcuses, pagination);

		for (BandejaSolicitudesBusqueda bandeja : listBandejaSolicitudesBusqueda) {
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(bandeja.getDecoor()).append("-").append(bandeja.getDenror()).append("-")
					.append(bandeja.getDenran()).append("-").append(bandeja.getHdnror());

			bandeja.setNumExpediente(numeroExpediente.toString());

			// buscar los documentos del tramite
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(bandeja.getEhcodigo());

			List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun,
					null);

			// si tiene un solo documento uno meterlo en el objeto
			if (listDocumentoHecho != null && listDocumentoHecho.size() == 1) {
				bandeja.setIndVariosDocumentos(Y41bConstantes.NO);

				bandeja.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
				bandeja.setQ5codocumento(listDocumentoHecho.get(0).getQ5codocumento());
				bandeja.setQ5nofile(listDocumentoHecho.get(0).getQ5nofile());
				bandeja.setQ5sizefile(listDocumentoHecho.get(0).getQ5sizefile());
				bandeja.setQ5contenttypefile(listDocumentoHecho.get(0).getQ5contenttypefile());
				bandeja.setQ5tedesfile(listDocumentoHecho.get(0).getQ5tedesfile());
			} else {
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 1) {
					bandeja.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
					// si tiene mas de un documento
					bandeja.setIndVariosDocumentos(Y41bConstantes.SI);
				}
			}

			if (listDocumentoHecho != null) {
				Parametros parametros = new Parametros();

				parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
				parametros = this.parametrosDao.find(parametros);

				for (DocumentoHecho documentoHechoAux : listDocumentoHecho) {
					if (documentoHechoAux.getQ5fechasollocalizador() != null) {
						if (documentoHechoAux != null && documentoHechoAux.getQ5nofile() != null
								&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(documentoHechoAux.getQ5nofile())
										.equalsIgnoreCase(Y41bConstantes.PDF)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
								&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {

							int minutos = 0;
							if (parametros != null && parametros.getValor() != null
									&& Y41bUtils.isNumeric(parametros.getValor())) {
								minutos = Integer.parseInt(parametros.getValor());
							}

							SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

							Date d1 = null;
							Date d2 = null;
							long diffMinutes = 0;
							try {
								d1 = format.parse(format.format(documentoHechoAux.getQ5fechasollocalizador()));

								d2 = format.parse(format.format(new Date()));

								long diff = d2.getTime() - d1.getTime();

								diffMinutes = diff / (60 * 1000);
							} catch (ParseException e) {
								diffMinutes = 0;
							}

							if (diffMinutes > minutos) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
							} else {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
							}
						} else {
							if (bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
							} else if (!bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
									&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
									&& !bandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
									&& !bandeja.getEstadotramite()
											.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
									&& !bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
								bandeja.setEstadotramite(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
							}
						}
					}
				}
			}
			if (bandeja != null && bandeja.getNombre() != null && !bandeja.getNombre().equals("")) {
				bandeja.setQ5origen(bandeja.getNombre());
			}

			if (bandeja.getEhfechaEnvioBOPVBOE() != null) {
				if (!bandeja.getEstadotramite().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(bandeja.getTrnombre());
					sbTrnombre.append(" (");
					sbTrnombre.append(
							Y41bUtils.parseDateToString(bandeja.getEhfechaEnvioBOPVBOE(), Y41bConstantes.CASTELLANO));
					sbTrnombre.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(bandeja.getTrnombree());
					sbTrnombree.append(" (");
					sbTrnombree.append(
							Y41bUtils.parseDateToString(bandeja.getEhfechaEnvioBOPVBOE(), Y41bConstantes.EUSKERA));
					sbTrnombree.append(")");

					bandeja.setTrnombre(sbTrnombre.toString());
					bandeja.setTrnombree(sbTrnombree.toString());
				}
			}

			// TELEMATICA O APORTACIONES DE Y41R
			if ((bandeja.getEhistelematico() != null) || (bandeja.getEhIsWebSinCertificado() != null
					&& bandeja.getEhIsWebSinCertificado().equalsIgnoreCase(Y41bConstantes.VALOR_SI))) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(bandeja.getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.CASTELLANO)));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(bandeja.getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
				sbTrnombree.append(")");

				bandeja.setTrnombre(sbTrnombre.toString());
				bandeja.setTrnombree(sbTrnombree.toString());
			}

			// Consulta si hay documentos pendiente de firma
			DocumentoHecho documentoHechoAux = new DocumentoHecho();
			documentoHechoAux.setQ5hdcodigo(bandeja.getHdcodigo());
			documentoHechoAux.setQ5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			Long numDocumentosPendienteFirma = this.documentoHechoDao.findAllCount(documentoHechoAux);
			if (numDocumentosPendienteFirma > 0) {
				bandeja.setEstadoFirma(Y41bConstantes.VALOR_SI);
			}

		}

		return listBandejaSolicitudesBusqueda;
	}

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesEOCTPCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {
		return this.bandejaSolicitudesDao.findAllBandejaSolicitudesEOCTPCount(bandejaSolicitudes, censoMonitor,
				trFechaDesde, trFechaHasta, excluirAcuses);
	}

}
