package com.ejie.y41b.service;

import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.BandejaSolicitudes;
import com.ejie.y41b.model.BandejaSolicitudesBusqueda;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TramiteHechoModal;

/**
 * BandejaSolicitudesService  
 * 
 *  
 */

public interface BandejaSolicitudesService {

	/**
	 * Inserts a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return BandejaSolicitudes
	 */
	BandejaSolicitudes add(BandejaSolicitudes bandejaSolicitudes);

	/**
	 * Updates a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return BandejaSolicitudes
	 */
	BandejaSolicitudes update(BandejaSolicitudes bandejaSolicitudes);

	/**
	 * Finds a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return BandejaSolicitudes
	 */
	BandejaSolicitudes find(BandejaSolicitudes bandejaSolicitudes);

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<BandejaSolicitudes> findAll(BandejaSolicitudes bandejaSolicitudes, Pagination pagination);

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return Long
	 */
	Long findAllCount(BandejaSolicitudes bandejaSolicitudes);

	/**
	 * Finds rows in the BandejaSolicitudes table using like.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<BandejaSolicitudes> findAllLike(BandejaSolicitudes bandejaSolicitudes, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the BandejaSolicitudes table using like.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(BandejaSolicitudes bandejaSolicitudes, Boolean startsWith);

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudes(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor);

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TramiteHechoModal> findAllTramitesPendientesSolicitudesBandejas(BandejaSolicitudes bandejaSolicitudes,
			Pagination pagination);

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return Long
	 */
	public Long findAllTramitesPendientesSolicitudesBandejasCount(BandejaSolicitudes bandejaSolicitudes);

	/**
	 * Deletes a single row in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @return
	 */
	void remove(BandejaSolicitudes bandejaSolicitudes);

	/**
	 * Deletes multiple rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudesList
	 *            List
	 * @return
	 */
	void removeMultiple(List<BandejaSolicitudes> bandejaSolicitudesList);

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesAdministrativo(
			BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta,
			String excluirAcuses, Pagination pagination);

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesAdministrativoCount(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses);

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param conStandBy
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesENYPD(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp,
			Boolean conStandBy, String excluirAcuses, Pagination pagination);

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param conStandBy
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesENYPDCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp, Boolean conStandBy, String excluirAcuses);

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * 
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesECTP(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Pagination pagination);

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesECTPCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta);

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesECTPO(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses,
			Pagination pagination);

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesECTPOCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, String excluirAcuses);

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesEONYPD(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp,
			String excluirAcuses, Pagination pagination);

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesEONYPDCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp, String excluirAcuses);

	/**
	 * Finds a List of rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaSolicitudesBusqueda> findAllBandejaSolicitudesEOCTP(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses,
			Pagination pagination);

	/**
	 * Counts rows in the BandejaSolicitudes table.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return Long
	 */
	public Long findAllBandejaSolicitudesEOCTPCount(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, String excluirAcuses);
}
