package com.ejie.y41b.service;

import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.BandejaInspeccionesDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.BandejaInspecciones;
import com.ejie.y41b.model.BandejaInspeccionesFiltro;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.TramiteInspeccionDetalle;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * BandejaInspeccionesServiceImpl  
 * 
 *  
 */

@Service(value = "bandejaInspeccionesService")
public class BandejaInspeccionesServiceImpl implements BandejaInspeccionesService {

	@Autowired()
	private BandejaInspeccionesDao bandejaInspeccionesDao;

	@Autowired()
	private ActuacionDao actuacionDao;

	@Autowired()
	private TramiteInspeccionDao tramiteInspeccionDao;

	@Autowired()
	private DocumentoHechoDao documentoHechoDao;

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return BandejaInspecciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public BandejaInspecciones add(BandejaInspecciones bandejaInspecciones) {
		return this.bandejaInspeccionesDao.add(bandejaInspecciones);
	}

	/**
	 * Updates a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return BandejaInspecciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public BandejaInspecciones update(BandejaInspecciones bandejaInspecciones) {
		return this.bandejaInspeccionesDao.update(bandejaInspecciones);
	}

	/**
	 * Finds a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return BandejaInspecciones
	 */
	public BandejaInspecciones find(BandejaInspecciones bandejaInspecciones) {
		return (BandejaInspecciones) this.bandejaInspeccionesDao.find(bandejaInspecciones);
	}

	/**
	 * Finds a List of rows in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param bandejaInspeccionesFiltro
	 *            BandejaInspeccionesFiltro
	 * @return List
	 */
	public List<BandejaInspecciones> findAll(BandejaInspecciones bandejaInspecciones, Pagination pagination,
			CensoMonitor censoMonitor, BandejaInspeccionesFiltro bandejaInspeccionesFiltro) {

		// Num. expediente
		if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
				&& pagination.getSort().equals("accoor")) {
			pagination.setSort("ACCOOR ASC, ACNRAN ASC, LPAD(ACNROR, 12) ");
		}

		if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
				&& pagination.getSort().equals("accoor")) {
			pagination.setSort("ACCOOR DESC, ACNRAN DESC, LPAD(ACNROR, 12) ");
		}

		List<BandejaInspecciones> listBandejaInspecciones = (List<BandejaInspecciones>) this.bandejaInspeccionesDao
				.findAll(bandejaInspecciones, pagination, censoMonitor, bandejaInspeccionesFiltro);

		for (BandejaInspecciones bandejaInspeccionesAux : listBandejaInspecciones) {
			if (bandejaInspeccionesAux.getTiistelematico() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(bandejaInspeccionesAux.getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.CASTELLANO)));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(bandejaInspeccionesAux.getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
				sbTrnombree.append(")");

				bandejaInspeccionesAux.setTrnombre(sbTrnombre.toString());
				bandejaInspeccionesAux.setTrnombree(sbTrnombree.toString());
			}

			// Consulta si hay documentos pendiente de firma
			DocumentoHecho documentoHechoAux = new DocumentoHecho();
			documentoHechoAux.setQ5hdcodigo(bandejaInspeccionesAux.getAtcodigo());
			documentoHechoAux.setQ5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
			Long numDocumentosPendienteFirma = this.documentoHechoDao.findAllCount(documentoHechoAux);
			if (numDocumentosPendienteFirma > 0) {
				bandejaInspeccionesAux.setEstadoFirma(Y41bConstantes.VALOR_SI);
			}

		}

		return listBandejaInspecciones;
	}

	/**
	 * Counts rows in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param bandejaInspeccionesFiltro
	 *            BandejaInspeccionesFiltro
	 * @return Long
	 */
	public Long findAllCount(BandejaInspecciones bandejaInspecciones, CensoMonitor censoMonitor,
			BandejaInspeccionesFiltro bandejaInspeccionesFiltro) {
		return this.bandejaInspeccionesDao.findAllCount(bandejaInspecciones, censoMonitor, bandejaInspeccionesFiltro);
	}

	/**
	 * Finds rows in the BandejaInspecciones table using like.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<BandejaInspecciones> findAllLike(BandejaInspecciones bandejaInspecciones, Pagination pagination,
			Boolean startsWith) {
		return (List<BandejaInspecciones>) this.bandejaInspeccionesDao.findAllLike(bandejaInspecciones, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the BandejaInspecciones table using like.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(BandejaInspecciones bandejaInspecciones, Boolean startsWith) {
		return this.bandejaInspeccionesDao.findAllLikeCount(bandejaInspecciones, startsWith);
	}

	/**
	 * Deletes a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(BandejaInspecciones bandejaInspecciones) {
		this.bandejaInspeccionesDao.remove(bandejaInspecciones);
	}

	/**
	 * Deletes multiple rows in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspeccionesList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<BandejaInspecciones> bandejaInspeccionesList) {
		for (BandejaInspecciones bandejaInspeccionesAux : bandejaInspeccionesList) {
			this.bandejaInspeccionesDao.remove(bandejaInspeccionesAux);
		}
	}

	/**
	 * Finds a List of rows in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TramiteInspeccionDetalle> findAllTramitesPendientes(BandejaInspecciones bandejaInspecciones,
			Pagination pagination) {

		List<TramiteInspeccionDetalle> listTramiteInspeccionDetalle = (List<TramiteInspeccionDetalle>) this.bandejaInspeccionesDao
				.findAllTramitesPendientes(bandejaInspecciones, pagination);

		for (TramiteInspeccionDetalle tramiteInspeccionDetalle : listTramiteInspeccionDetalle) {
			if (tramiteInspeccionDetalle.getTiistelematico() != null) {
				StringBuffer sbTrnombre = new StringBuffer();
				sbTrnombre.append(tramiteInspeccionDetalle.getTrnombre());
				sbTrnombre.append(" (");
				sbTrnombre.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.CASTELLANO)));
				sbTrnombre.append(")");

				StringBuffer sbTrnombree = new StringBuffer();
				sbTrnombree.append(tramiteInspeccionDetalle.getTrnombree());
				sbTrnombree.append(" (");
				sbTrnombree.append(
						appMessageSource.getMessage("comun.telematico", null, new Locale(Y41bConstantes.EUSKERA)));
				sbTrnombree.append(")");

				tramiteInspeccionDetalle.setTrnombre(sbTrnombre.toString());
				tramiteInspeccionDetalle.setTrnombree(sbTrnombree.toString());
			}
		}

		return listTramiteInspeccionDetalle;
	}

	/**
	 * Counts rows in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return Long
	 */
	public Long findAllTramitesPendientesCount(BandejaInspecciones bandejaInspecciones) {
		return this.bandejaInspeccionesDao.findAllTramitesPendientesCount(bandejaInspecciones);
	}

	/**
	 * Updates a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return BandejaInspecciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public BandejaInspecciones updateUltimoTramite(BandejaInspecciones bandejaInspecciones) {
		this.bandejaInspeccionesDao.remove(bandejaInspecciones);
		return this.addInspeccion(bandejaInspecciones);
	}

	/**
	 * Updates a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return BandejaInspecciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public BandejaInspecciones addInspeccion(BandejaInspecciones bandejaInspecciones) {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(bandejaInspecciones.getAtcodigo());

		actuacion = this.actuacionDao.find(actuacion);

		BandejaInspecciones bandejaInspeccionesAux = new BandejaInspecciones();
		bandejaInspeccionesAux.setAtcodigo(actuacion.getAtcodigo());

		if (actuacion.getAtcocm() != null && !"".equals(actuacion.getAtcocm())) {
			bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_CAMPANHA);
			bandejaInspeccionesAux.setIdorigen(actuacion.getAtcocm());
		} else if (actuacion.getAtcoal() != null && !"".equals(actuacion.getAtcoal())) {
			bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_ALERTA);
			bandejaInspeccionesAux.setIdorigen(actuacion.getAtcoal());
		} else if (actuacion.getAtidcomunicacionsoivre() != null && !"".equals(actuacion.getAtidcomunicacionsoivre())) {
			bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_SOIVRE);
			bandejaInspeccionesAux.setIdorigen(actuacion.getAtidcomunicacionsoivre());
		} else if (actuacion.getAtcohd() != null && !"".equals(actuacion.getAtcohd())) {
			if (actuacion.getAtcohddenuncia() != null
					&& Y41bConstantes.VALOR_SI.equals(actuacion.getAtcohddenuncia())) {
				bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_DENUNCIA);
			} else {
				bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_SOLICITUD);
			}
			bandejaInspeccionesAux.setIdorigen(actuacion.getAtcohd());
		} else {
			if (actuacion.getActa() != null && actuacion.getActa().getActiororigen() != null
					&& Y41bConstantes.INSPECCION_ORIGEN_COMUNICACION_EXTERNA
							.equals(actuacion.getActa().getActiororigen())) {
				bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_COMUNICACION_EXTERNA);
			} else if (actuacion.getActa() != null && actuacion.getActa().getActiororigen() != null
					&& Y41bConstantes.INSPECCION_ORIGEN_NOTIFICACION_PRODUCTORES
							.equals(actuacion.getActa().getActiororigen())) {
				bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_NOTIFICACION_PRODUCTORES);
			} else {
				bandejaInspeccionesAux.setOrigen(Y41bConstantes.INSPECCIONES_ORIGEN_OFICIO);
			}
		}

		if (actuacion.getActa() != null && actuacion.getActa().getAccoor() != null) {
			bandejaInspeccionesAux.setAccoor(actuacion.getActa().getAccoor());
		}

		if (actuacion.getActa() != null && actuacion.getActa().getAcnror() != null) {
			bandejaInspeccionesAux.setAcnror(actuacion.getActa().getAcnror());
		}

		if (actuacion.getActa() != null && actuacion.getActa().getAcnran() != null) {
			bandejaInspeccionesAux.setAcnran(actuacion.getActa().getAcnran());
		}

		bandejaInspeccionesAux.setAtnror(actuacion.getAtnror());

		if (actuacion.getActa() != null && actuacion.getActa().getAccomo() != null) {
			bandejaInspeccionesAux.setAccomo(actuacion.getActa().getAccomo());
		}

		if (actuacion.getActdec() != null && actuacion.getActdec().getAdcoor() != null) {
			bandejaInspeccionesAux.setAdcoor(actuacion.getActdec().getAdcoor());
		}

		bandejaInspeccionesAux.setFcodigoactual(actuacion.getFcodigoactual());

		// ---------------------------

		TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
		tramiteInspeccionDetalle.setAtcodigo(actuacion.getAtcodigo());

		tramiteInspeccionDetalle = this.tramiteInspeccionDao
				.findTramitePendienteMasNuevoNoTramitado(tramiteInspeccionDetalle);

		if (tramiteInspeccionDetalle == null || !Y41bUtils.isFilled(tramiteInspeccionDetalle.getTicodigo())) {
			tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
			tramiteInspeccionDetalle.setAtcodigo(actuacion.getAtcodigo());

			tramiteInspeccionDetalle = this.tramiteInspeccionDao
					.findUltimoTramiteInspeccionTramitado(tramiteInspeccionDetalle);
		}

		bandejaInspeccionesAux.setTicodigo(tramiteInspeccionDetalle.getTicodigo());
		TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTicodigo(tramiteInspeccionDetalle.getTicodigo());
		tramiteInspeccionAux = this.tramiteInspeccionDao.find(tramiteInspeccionAux);

		bandejaInspeccionesAux.setTrcodigoactual(tramiteInspeccionAux.getTicotee());

		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5tramite(tramiteInspeccionDetalle.getTicodigo());

		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAll(documentoHecho, null);

		if (listDocumentoHecho.size() == 1) {
			bandejaInspeccionesAux.setQ5nofile(listDocumentoHecho.get(0).getQ5tedesfile());
			bandejaInspeccionesAux.setQ5origen(listDocumentoHecho.get(0).getQ5origen());
			bandejaInspeccionesAux.setQ5codocumento(listDocumentoHecho.get(0).getQ5codocumento());
		}

		if (listDocumentoHecho.size() > 1) {
			bandejaInspeccionesAux.setVariosDocumentos(Y41bConstantes.VALOR_SI);
		} else {
			bandejaInspeccionesAux.setVariosDocumentos(Y41bConstantes.VALOR_NO);
		}

		bandejaInspeccionesAux.setFechatramite(tramiteInspeccionAux.getTifechainicio());

		if (actuacion.getActa() != null && actuacion.getActa().getAccoes() != null) {
			bandejaInspeccionesAux.setEstvisitado(actuacion.getActa().getAccoes());
		}

		bandejaInspeccionesAux.setEstadotramite(tramiteInspeccionAux.getTiestadotramite());
		bandejaInspeccionesAux.setFechalimite(tramiteInspeccionAux.getTifechalimite());

		return this.bandejaInspeccionesDao.add(bandejaInspeccionesAux);
	}
}
