package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.BandejaInspecciones;
import com.ejie.y41b.model.BandejaInspeccionesFiltro;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TramiteInspeccionDetalle;

/**
 * BandejaInspeccionesService  
 * 
 *  
 */

public interface BandejaInspeccionesService {

	/**
	 * Inserts a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return BandejaInspecciones
	 */
	BandejaInspecciones add(BandejaInspecciones bandejaInspecciones);

	/**
	 * Updates a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return BandejaInspecciones
	 */
	BandejaInspecciones update(BandejaInspecciones bandejaInspecciones);

	/**
	 * Finds a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return BandejaInspecciones
	 */
	BandejaInspecciones find(BandejaInspecciones bandejaInspecciones);

	/**
	 * Finds a List of rows in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param bandejaInspeccionesFiltro
	 *            BandejaInspeccionesFiltro
	 * @return List
	 */
	public List<BandejaInspecciones> findAll(
			BandejaInspecciones bandejaInspecciones, Pagination pagination,
			CensoMonitor censoMonitor,
			BandejaInspeccionesFiltro bandejaInspeccionesFiltro);

	/**
	 * Counts rows in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param bandejaInspeccionesFiltro
	 *            BandejaInspeccionesFiltro
	 * @return Long
	 */
	Long findAllCount(BandejaInspecciones bandejaInspecciones,
			CensoMonitor censoMonitor,
			BandejaInspeccionesFiltro bandejaInspeccionesFiltro);

	/**
	 * Finds rows in the BandejaInspecciones table using like.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<BandejaInspecciones> findAllLike(
			BandejaInspecciones bandejaInspecciones, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the BandejaInspecciones table using like.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(BandejaInspecciones bandejaInspecciones,
			Boolean startsWith);

	/**
	 * Deletes a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return
	 */
	void remove(BandejaInspecciones bandejaInspecciones);

	/**
	 * Deletes multiple rows in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspeccionesList
	 *            List
	 * @return
	 */
	void removeMultiple(List<BandejaInspecciones> bandejaInspeccionesList);

	/**
	 * Finds a List of rows in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TramiteInspeccionDetalle> findAllTramitesPendientes(
			BandejaInspecciones bandejaInspecciones, Pagination pagination);

	/**
	 * Counts rows in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return Long
	 */
	Long findAllTramitesPendientesCount(BandejaInspecciones bandejaInspecciones);

	/**
	 * Updates a single row in the BandejaInspecciones table.
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @return BandejaInspecciones
	 */
	BandejaInspecciones updateUltimoTramite(
			BandejaInspecciones bandejaInspecciones);
}
