package com.ejie.y41b.service;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y31.vo.Y31AttachmentBean;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPifAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.adapter.services.NSHFServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbadhsolcomdocDao;
import com.ejie.y41b.dao.ArbdoctempDao;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.dao.BandejaFirmaArbitrajeDao;
import com.ejie.y41b.dao.BandejaFirmaDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.DocumentosFirmaArbitrosDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.SandoctempDao;
import com.ejie.y41b.dao.SantramexpDao;
import com.ejie.y41b.dao.TramiteHechoDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.model.Arbadhsolcomdoc;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.BandejaFirmaArbitraje;
import com.ejie.y41b.model.BandejaFirmaBusqueda;
import com.ejie.y41b.model.BandejaInspecciones;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentosFirmaArbitros;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.Firma;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.nshf.Body;
import com.ejie.y41b.nshf.EjgvDocument;
import com.ejie.y41b.nshf.EjgvDocumentType;
import com.ejie.y41b.nshf.Header;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.platea.Y41bFuncionesAuxiliaresPlatea;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * BandejaFirmaServiceImpl  
 * 
 *  
 */

@Service(value = "bandejaFirmaService")
public class BandejaFirmaServiceImpl implements BandejaFirmaService {

	private final static Logger logger = LoggerFactory.getLogger(BandejaFirmaServiceImpl.class);

	@Autowired
	private BandejaFirmaDao bandejaFirmaDao;

	@Autowired
	private DocumentoHechoDao documentoHechoDao;

	@Autowired
	private TramiteHechoDao tramiteHechoDao;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired()
	private Y41bPifAdapterService y41bPifAdapterService;

	@Autowired
	private SandoctempDao sandoctempDao;
	@Autowired
	private SantramexpDao santramexpDao;
	@Autowired
	private SantramexpService santramexpService;

	@Autowired
	private ArbdoctempDao arbdoctempDao;
	@Autowired
	private ArbtramexpDao arbtramexpDao;
	@Autowired
	private Arbtramexp2Service arbtramexp2Service;
	@Autowired
	private ArbtramexpService arbtramexpService;
	@Autowired
	private ArbadhsolcomdocDao arbadhsolcomdocDao;

	@Autowired
	private TramiteInspeccionDao tramiteInspeccionDao;

	@Autowired
	private BandejaInspeccionesService bandejaInspeccionesService;
	@Autowired
	private DocumentosFirmaArbitrosDao documentosFirmaArbitrosDao;
	@Autowired
	private BandejaFirmaArbitrajeDao bandejaFirmaArbitrajeDao;
	@Autowired
	private ArbitroService arbitroService;
	@Autowired
	private OrganismoDao organismoDao;
	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	@Transactional(rollbackFor = Throwable.class)
	public BandejaFirma add(BandejaFirma bandejaFirma) {
		return this.bandejaFirmaDao.add(bandejaFirma);
	}

	/**
	 * Updates a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	@Transactional(rollbackFor = Throwable.class)
	public BandejaFirma update(BandejaFirma bandejaFirma) {
		return this.bandejaFirmaDao.update(bandejaFirma);
	}

	/**
	 * Updates a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	@Transactional(rollbackFor = Throwable.class)
	public BandejaFirma updateHashFileBandejaFirma(BandejaFirma bandejaFirma) {
		return this.bandejaFirmaDao.updateHashFileBandejaFirma(bandejaFirma);
	}

	/**
	 * Updates a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	@Transactional(rollbackFor = Throwable.class)
	public BandejaFirma updateComoFirma(BandejaFirma bandejaFirma) {
		return this.bandejaFirmaDao.updateComoFirma(bandejaFirma);
	}

	/**
	 * Metodo que actualiza el firmante del documento en la Bandeja de Firma y
	 * que guarda en Dokusi la firma del documento.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void saveBandejaFirmaDocHashSol(BandejaFirma bandejaFirma) throws Exception {
		// 1. Actualizamos la BBDD (El monitor que ha firmado)
		this.bandejaFirmaDao.updateComoFirma(bandejaFirma);
		// 2. Actualizamos el estado del documento (L21Q5T00 ->
		// Q5ESTADODOCUMENTO, Q5FECHAFIRMA, Q5COMOFIRMA)
		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5codocumento(bandejaFirma.getCodocumento());
		documentoHecho.setQ5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO);
		documentoHecho.setQ5fechafirma(Calendar.getInstance().getTime());
		documentoHecho.setQ5comofirma(bandejaFirma.getComofirma());
		documentoHechoDao.updateDatosFirma(documentoHecho);
		// 3. Actualizamos tabla L2118T00 el campo EHESTADOTRAMITE a E si todos
		// los documentos del tramite estan firmados
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(bandejaFirma.getIdtramitehecho());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		boolean todosFirmados = true;
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				if (listDocumentoHecho.get(i).getQ5estadodocumento() != null && !listDocumentoHecho.get(i)
						.getQ5estadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO)) {
					todosFirmados = false;
					break;
				}
			}
		}
		if (todosFirmados) {
			// Actualizamos la L2118T00 - EHESTADOTRAMITE = 'E' apartir del
			// EHCODIGO
			TramiteHecho tramitehecho = new TramiteHecho();
			tramitehecho.setEhcodigo(bandejaFirma.getIdtramitehecho());
			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
			tramiteHechoDao.updateEstadoTramite(tramitehecho);

			// Tratar la bandeja de solicitudes
			// Busco el idExpediente del tramite
			tramitehecho = tramiteHechoDao.find(tramitehecho);
			HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
			hechodenunciadoAux.setHdcodigo(tramitehecho.getEhcohd());
			this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);
		}

		// 4. Actualizamos en Dokusi la firma
		Documento documento = new Documento();
		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
		documento.setProcedure(procedure);
		documento.setOidDokusi(bandejaFirma.getIddocumentum());
		if (bandejaFirma.getNofile() != null) {
			documento.setNombre(Y41bUtils.getNameFile(bandejaFirma.getNofile()));
			documento.setExtension(Y41bUtils.getExtensionFile(bandejaFirma.getNofile()));
		}

		documento = this.obtenerFirmaDocumento(documento, bandejaFirma);

		// ******************************************************

		y41bDokusiAdapterService.firmarDocumentosDokusi(documento);
	}

	/**
	 * Metodo que actualiza el motivo de rechazo de la firma
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void denegarBandejaFirmaDocSol(BandejaFirma bandejaFirma) throws Exception {
		// 1. Actualizamos la BBDD (El monitor que ha firmado)
		this.bandejaFirmaDao.updateComoFirma(bandejaFirma);
		// 2. Actualizamos el estado del documento (L21Q5T00 ->
		// Q5ESTADODOCUMENTO, Q5FECHAFIRMA, Q5COMOFIRMA)
		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5codocumento(bandejaFirma.getCodocumento());
		documentoHecho.setQ5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA);
		documentoHecho.setQ5fechafirma(null);
		documentoHecho.setQ5comofirma(bandejaFirma.getComofirma());
		documentoHechoDao.updateDatosFirma(documentoHecho);

		// Actualizamos la L2118T00 - EHESTADOTRAMITE = 'D' apartir del
		// EHCODIGO
		TramiteHecho tramitehecho = new TramiteHecho();
		tramitehecho.setEhcodigo(bandejaFirma.getIdtramitehecho());
		tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA);

		TramiteHecho tramitehechoAux = tramiteHechoDao.findLobTablaTemporal(tramitehecho);

		// Fecha - Documento que se deniega - Motivos de denegacin
		StringBuffer motivorechazo = new StringBuffer();
		if (!Y41bUtils.esNullOCadenaVacia(tramitehechoAux.getEhtexto())) {
			motivorechazo.append(tramitehechoAux.getEhtexto());
			motivorechazo.append("\n");
		}

		motivorechazo.append(Y41bUtils.parseDateToString(new Date(), Y41bConstantes.CASTELLANO)).append(" - ");
		;
		motivorechazo.append(StringEscapeUtils.unescapeHtml(bandejaFirma.getNofile())).append(" - ");
		motivorechazo.append(bandejaFirma.getMotivorechazo());
		tramitehecho.setEhtexto(motivorechazo.toString());

		tramiteHechoDao.updateDenegacionTramite(tramitehecho);

		// Tratar la bandeja de solicitudes
		// Busco el idExpediente del tramite
		tramitehecho = tramiteHechoDao.find(tramitehecho);
		HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
		hechodenunciadoAux.setHdcodigo(tramitehecho.getEhcohd());
		this.denunciaService.tratamientoBandejaSolicitudes(hechodenunciadoAux);

	}

	/**
	 * Metodo que actualiza el firmante del documento en la Bandeja de Firma y
	 * que guarda en Dokusi la firma del documento.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void saveBandejaFirmaDocHashIns(BandejaFirma bandejaFirma) throws Exception {
		// 1. Actualizamos la BBDD (El monitor que ha firmado)
		this.bandejaFirmaDao.updateComoFirma(bandejaFirma);
		// 2. Actualizamos el estado del documento (L21Q5T00 ->
		// Q5ESTADODOCUMENTO, Q5FECHAFIRMA, Q5COMOFIRMA)
		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5codocumento(bandejaFirma.getCodocumento());
		documentoHecho.setQ5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO);
		documentoHecho.setQ5fechafirma(Calendar.getInstance().getTime());
		documentoHecho.setQ5comofirma(bandejaFirma.getComofirma());
		documentoHechoDao.updateDatosFirma(documentoHecho);
		// 3. Actualizamos tabla L2118T00 el campo EHESTADOTRAMITE a E si todos
		// los documentos del tramite estan firmados
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(bandejaFirma.getIdtramitehecho());
		List<DocumentoHecho> listDocumentoHecho = this.documentoHechoDao.findAllDocumentosTramite(tramiteComun, null);

		boolean todosFirmados = true;
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				if (listDocumentoHecho.get(i).getQ5estadodocumento() != null && !listDocumentoHecho.get(i)
						.getQ5estadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO)) {
					todosFirmados = false;
					break;
				}
			}
		}
		if (todosFirmados) {
			// Actualizamos la L2118T00 - EHESTADOTRAMITE = 'E' apartir del
			// EHCODIGO
			TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
			tramiteInspeccion.setTicodigo(bandejaFirma.getIdtramitehecho());
			tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
			tramiteInspeccionDao.updateEstadoTramite(tramiteInspeccion);

			// Tratar la Bandeja de inspecciones
			tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

			BandejaInspecciones bandejaInspecciones = new BandejaInspecciones();
			bandejaInspecciones.setAtcodigo(tramiteInspeccion.getTiatcodigo());

			this.bandejaInspeccionesService.updateUltimoTramite(bandejaInspecciones);
		}

		// 4. Actualizamos en Dokusi la firma
		Documento documento = new Documento();
		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
		documento.setProcedure(procedure);
		documento.setOidDokusi(bandejaFirma.getIddocumentum());
		if (bandejaFirma.getNofile() != null) {
			documento.setNombre(Y41bUtils.getNameFile(bandejaFirma.getNofile()));
			documento.setExtension(Y41bUtils.getExtensionFile(bandejaFirma.getNofile()));
		}

		// ******************************************************

		documento = this.obtenerFirmaDocumento(documento, bandejaFirma);

		// ******************************************************

		y41bDokusiAdapterService.firmarDocumentosDokusi(documento);
	}

	/**
	 * Metodo que actualiza el motivo de rechazo de la firma
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void denegarBandejaFirmaDocIns(BandejaFirma bandejaFirma) throws Exception {
		// 1. Actualizamos la BBDD (El monitor que ha firmado)
		this.bandejaFirmaDao.updateComoFirma(bandejaFirma);
		// 2. Actualizamos el estado del documento (L21Q5T00 ->
		// Q5ESTADODOCUMENTO, Q5FECHAFIRMA, Q5COMOFIRMA)
		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5codocumento(bandejaFirma.getCodocumento());
		documentoHecho.setQ5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA);
		documentoHecho.setQ5fechafirma(null);
		documentoHecho.setQ5comofirma(bandejaFirma.getComofirma());
		documentoHechoDao.updateDatosFirma(documentoHecho);

		// Actualizamos la L2118T00 - EHESTADOTRAMITE = 'D' apartir del
		// EHCODIGO
		TramiteInspeccion tramiteInspeccion = new TramiteInspeccion();
		tramiteInspeccion.setTicodigo(bandejaFirma.getIdtramitehecho());
		tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA);

		TramiteInspeccion tramiteInspeccionAux = tramiteInspeccionDao.findLobTablaTemporal(tramiteInspeccion);

		// Fecha - Documento que se deniega - Motivos de denegacin
		StringBuffer motivorechazo = new StringBuffer();
		if (!Y41bUtils.esNullOCadenaVacia(tramiteInspeccionAux.getTicomentario())) {
			motivorechazo.append(tramiteInspeccionAux.getTicomentario());
			motivorechazo.append("\n");
		}

		motivorechazo.append(Y41bUtils.parseDateToString(new Date(), Y41bConstantes.CASTELLANO)).append(" - ");
		;
		motivorechazo.append(StringEscapeUtils.unescapeHtml(bandejaFirma.getNofile())).append(" - ");
		motivorechazo.append(bandejaFirma.getMotivorechazo());
		tramiteInspeccion.setTicomentario(motivorechazo.toString());

		tramiteInspeccionDao.updateDenegacionTramite(tramiteInspeccion);

		// Tratar la Bandeja de inspecciones
		tramiteInspeccion = this.tramiteInspeccionDao.find(tramiteInspeccion);

		BandejaInspecciones bandejaInspecciones = new BandejaInspecciones();
		bandejaInspecciones.setAtcodigo(tramiteInspeccion.getTiatcodigo());

		this.bandejaInspeccionesService.updateUltimoTramite(bandejaInspecciones);

	}

	/**
	 * Metodo que actualiza el motivo de rechazo de la firma
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void denegarBandejaFirmaDocSan(BandejaFirma bandejaFirma) throws Exception {
		// 1. Actualizamos la BBDD (El monitor que ha firmado)
		this.bandejaFirmaDao.updateComoFirma(bandejaFirma);
		// 2. Actualizamos el estado del documento (L21U5T00 ->
		// U5ESTADODOCUMENTO, U5FECHAFIRMA, U5COMOFIRMA)
		Sandoctemp sandoctemp = new Sandoctemp();
		sandoctemp.setU5codocumento(bandejaFirma.getCodocumento());
		sandoctemp.setU5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA);
		sandoctemp.setU5fechafirma(null);
		sandoctemp.setU5comofirma(bandejaFirma.getComofirma());
		sandoctempDao.updateDatosFirma(sandoctemp);

		// Actualizamos la L21U2T00 - TRESTADO = 'D' apartir del
		// EHCODIGO
		Santramexp santramexp = new Santramexp();
		santramexp.setTrid(bandejaFirma.getIdtramitehecho());
		santramexp = santramexpDao.find(santramexp);

		santramexp.setTrestado(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA);

		// Fecha - Documento que se deniega - Motivos de denegacin
		StringBuffer motivorechazo = new StringBuffer();

		if (!Y41bUtils.esNullOCadenaVacia(Y41bUtils.clobToString(santramexp.getTrobserves()))) {
			motivorechazo.append(santramexp.getTrobserves());
			motivorechazo.append("\n");
		}
		motivorechazo.append(Y41bUtils.parseDateToString(new Date(), Y41bConstantes.CASTELLANO)).append(" - ");
		;
		motivorechazo.append(StringEscapeUtils.unescapeHtml(bandejaFirma.getNofile())).append(" - ");
		motivorechazo.append(bandejaFirma.getMotivorechazo());

		santramexp.setTrobserves(Y41bUtils.stringToClob(motivorechazo.toString()));

		santramexpDao.updateDenegacionTramite(santramexp);

		// Tratar la bandeja de sanciones
		this.santramexpService.actualizaBandeja(santramexp);

	}

	/**
	 * Metodo que actualiza el motivo de rechazo de la firma
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void denegarBandejaFirmaDocArb(BandejaFirma bandejaFirma) throws Exception {
		// 1. Actualizamos la BBDD (El monitor que ha firmado)
		this.bandejaFirmaDao.updateComoFirma(bandejaFirma);
		// 2. Actualizamos el estado del documento (L21X5T00 ->
		// X5ESTADODOCUMENTO, X5FECHAFIRMA, X5COMOFIRMA)
		Arbdoctemp arbdoctemp = new Arbdoctemp();
		arbdoctemp.setX5codocumento(bandejaFirma.getCodocumento());
		arbdoctemp.setX5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA);
		arbdoctemp.setX5fechafirma(null);
		arbdoctemp.setX5comofirma(bandejaFirma.getComofirma());
		arbdoctempDao.updateDatosFirma(arbdoctemp);

		// Actualizamos la L21X2T00 - TRESTADO = 'D' apartir del
		// EHCODIGO
		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setTrid(bandejaFirma.getIdtramitehecho());
		arbtramexp = arbtramexpDao.find(arbtramexp);

		arbtramexp.setTrestado(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA);

		// Fecha - Documento que se deniega - Motivos de denegacin
		StringBuffer motivorechazo = new StringBuffer();

		if (!Y41bUtils.esNullOCadenaVacia(Y41bUtils.clobToString(arbtramexp.getTrobserves()))) {
			motivorechazo.append(arbtramexp.getTrobserves());
			motivorechazo.append("\n");
		}
		motivorechazo.append(Y41bUtils.parseDateToString(new Date(), Y41bConstantes.CASTELLANO)).append(" - ");
		;
		motivorechazo.append(StringEscapeUtils.unescapeHtml(bandejaFirma.getNofile())).append(" - ");
		motivorechazo.append(bandejaFirma.getMotivorechazo());

		arbtramexp.setTrobserves(Y41bUtils.stringToClob(motivorechazo.toString()));

		arbtramexpDao.updateDenegacionTramite(arbtramexp);

		// Tratar la bandeja de arbitraje
		this.arbtramexp2Service.actualizaBandeja(arbtramexp);

	}

	/**
	 * Metodo que actualiza el motivo de rechazo de la firma
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void denegarBandejaFirmaDocAdh(BandejaFirma bandejaFirma) throws Exception {
		// 1. Actualizamos la BBDD (El monitor que ha firmado)
		this.bandejaFirmaDao.updateComoFirma(bandejaFirma);
		// 2. Actualizamos el estado del documento (L21X5T00 ->
		// X5ESTADODOCUMENTO, X5FECHAFIRMA, X5COMOFIRMA)
		Arbadhsolcomdoc arbdoctemp = new Arbadhsolcomdoc();
		arbdoctemp.setXmcodocumento(bandejaFirma.getCodocumento());
		arbdoctemp.setXmestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA);
		arbdoctemp.setXmfechafirma(null);
		arbdoctemp.setXmcomofirma(bandejaFirma.getComofirma());
		arbadhsolcomdocDao.updateDatosFirma(arbdoctemp);

	}

	/**
	 * Metodo que actualiza el firmante del documento en la Bandeja de Firma y
	 * que guarda en Dokusi la firma del documento.(Para sanciones)
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void saveBandejaFirmaDocHashSan(BandejaFirma bandejaFirma) throws Exception {
		// 1. Actualizamos la BBDD (El monitor que ha firmado)
		logger.info("BandejaFirmaServiceImpl. - Firmar. Actualizar bandeja firma");
		this.bandejaFirmaDao.updateComoFirma(bandejaFirma);
		// 2. Actualizamos el estado del documento (L21Q5T00 ->
		// Q5ESTADODOCUMENTO, Q5FECHAFIRMA, Q5COMOFIRMA)
		logger.info("BandejaFirmaServiceImpl. - Firmar. Actualizar estado en sandoctemp");
		Sandoctemp sandoctemp = new Sandoctemp();
		sandoctemp.setU5codocumento(bandejaFirma.getCodocumento());
		sandoctemp.setU5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO);
		sandoctemp.setU5fechafirma(Calendar.getInstance().getTime());
		sandoctemp.setU5comofirma(bandejaFirma.getComofirma());
		sandoctempDao.updateDatosFirma(sandoctemp);
		// 3. Actualizamos tabla L2118T00 el campo EHESTADOTRAMITE a E si todos
		// los documentos del tramite estan firmados
		logger.info(
				"BandejaFirmaServiceImpl. - Firmar. Comprobar si todos los documentos del trámite están firmados");
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(bandejaFirma.getIdtramitehecho());
		List<Sandoctemp> listDocumentoHecho = this.sandoctempDao.findAllDocumentosTramite(tramiteComun, null);

		boolean todosFirmados = true;
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				if (listDocumentoHecho.get(i).getU5estadodocumento() != null && !Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO
						.equals(listDocumentoHecho.get(i).getU5estadodocumento())) {
					todosFirmados = false;
					break;
				}
			}
		}
		if (todosFirmados) {
			logger.info("BandejaFirmaServiceImpl. - Firmar. Actualizar bandeja sanciones");
			Santramexp santramexp = new Santramexp();
			santramexp.setTrid(bandejaFirma.getIdtramitehecho());
			santramexp = santramexpDao.find(santramexp);
			santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
			// SE HA COMPROBADO QUE ERA EL ULTIMO PDTE DE FIRMAR
			// santramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			santramexpDao.update(santramexp);

			// Tratar la bandeja de sanciones

			santramexpService.actualizaBandeja(santramexp);

		}

		// 4. Actualizamos en Dokusi la firma
		logger.info("BandejaFirmaServiceImpl. - Firmar. Aniadir firma");
		Documento documento = new Documento();
		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
		documento.setProcedure(procedure);
		documento.setOidDokusi(bandejaFirma.getIddocumentum());
		if (bandejaFirma.getNofile() != null) {
			documento.setNombre(Y41bUtils.getNameFile(bandejaFirma.getNofile()));
			documento.setExtension(Y41bUtils.getExtensionFile(bandejaFirma.getNofile()));
		}

		// ******************************************************

		documento = this.obtenerFirmaDocumento(documento, bandejaFirma);

		// ******************************************************

		logger.info("BandejaFirmaServiceImpl. - Firmar. Inicio Llamada a Platea" + bandejaFirma);
		y41bDokusiAdapterService.firmarDocumentosDokusi(documento);
		logger.info("BandejaFirmaServiceImpl. - Firmar. Fin Llamada a Platea" + bandejaFirma);
	}

	/**
	 * Metodo que actualiza el firmante del documento en la Bandeja de Firma y
	 * que guarda en Dokusi la firma del documento.(Para arbitraje)
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void saveBandejaFirmaDocHashArb(BandejaFirma bandejaFirma) throws Exception {
		// 1. Actualizamos la BBDD (El monitor que ha firmado)
		logger.info("BandejaFirmaServiceImpl. - Firmar. Actualizar bandeja firma");
		this.bandejaFirmaDao.updateComoFirma(bandejaFirma);
		// 2. Actualizamos el estado del documento (L21X5T00 ->
		// X5ESTADODOCUMENTO, X5FECHAFIRMA, X5COMOFIRMA)
		logger.info("BandejaFirmaServiceImpl. - Firmar. Actualizar estado en arbdoctemp");
		Arbdoctemp arbdoctemp = new Arbdoctemp();
		arbdoctemp.setX5codocumento(bandejaFirma.getCodocumento());

		// 0155021 si viene de arbitros y es laudo miramos si esta en la tabla
		// de documentos firma arbitros para ponerlo en pendiente o no
		Arbtramexp tramiteArb = new Arbtramexp();
		tramiteArb.setTrid(bandejaFirma.getIdtramitehecho());
		tramiteArb = this.arbtramexpService.find(tramiteArb);

		if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(tramiteArb.getTrcodigo())) {
			DocumentosFirmaArbitros documento = new DocumentosFirmaArbitros();
			documento.setIddocumentosfirmaarb(bandejaFirma.getCodocumento());
			documento = this.documentosFirmaArbitrosDao.find(documento);
			// si encontramos el documento es que pertenece a los arbirtros,
			// pero no loponemos todavia como firmado puesto que faltan las
			// firmas de los arbitros.
			// lo seguimos dejando como pendiente y actualizamod el estado en la
			// bandeja firma arbitros de null a pendiente para que salga en la
			// aplicacion ac85a
			if (null != documento) {
				arbdoctemp.setX5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
				BandejaFirmaArbitraje documentoBandejaFirmaArbitraje = new BandejaFirmaArbitraje();
				documentoBandejaFirmaArbitraje.setCodocumento(bandejaFirma.getCodocumento());
				documentoBandejaFirmaArbitraje.setIdtramitehecho(bandejaFirma.getIdtramitehecho());
				List<BandejaFirmaArbitraje> listaFirmas = this.bandejaFirmaArbitrajeDao
						.findAllLike(documentoBandejaFirmaArbitraje, null, false);

				if (!listaFirmas.isEmpty()) {
					documentoBandejaFirmaArbitraje = listaFirmas.get(0);

					if (documentoBandejaFirmaArbitraje != null) {
						documentoBandejaFirmaArbitraje.setEstado(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
						documentoBandejaFirmaArbitraje.setFechaenvio(new Date());
						documentoBandejaFirmaArbitraje.setFechalimfirma(new Date());
						documentoBandejaFirmaArbitraje.setHashfile(bandejaFirma.getHashfile());
						documentoBandejaFirmaArbitraje.setNofile(bandejaFirma.getNofile());
						documentoBandejaFirmaArbitraje.setIddocumentum(bandejaFirma.getIddocumentum());

						this.bandejaFirmaArbitrajeDao.updateEstado(documentoBandejaFirmaArbitraje);

						for (BandejaFirmaArbitraje registroBandeja : listaFirmas) {
							Arbitro arbitro = new Arbitro();
							arbitro.setArcodigo(registroBandeja.getArcodigo());
							arbitro = this.arbitroService.find(arbitro);
							if (null != arbitro) {
								this.enviarMailArbitros(arbitro);
							}

						}
					}
				}
			} else {
				arbdoctemp.setX5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO);
			}
		} else {
			arbdoctemp.setX5estadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO);
		}
		// 0155021

		arbdoctemp.setX5fechafirma(Calendar.getInstance().getTime());
		arbdoctemp.setX5comofirma(bandejaFirma.getComofirma());
		arbdoctempDao.updateDatosFirma(arbdoctemp);
		// 3. Actualizamos tabla L2118T00 el campo EHESTADOTRAMITE a E si todos
		// los documentos del tramite estan firmados
		logger.info("BandejaFirmaServiceImpl. - Firmar. Comprobar si todos los documentos del tramite estan firmados");
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(bandejaFirma.getIdtramitehecho());
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);

		boolean todosFirmados = true;
		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				if (listDocumentoHecho.get(i).getX5estadodocumento() != null && !Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO
						.equals(listDocumentoHecho.get(i).getX5estadodocumento())) {
					todosFirmados = false;
					break;
				}
			}
		}
		if (todosFirmados) {
			logger.info("BandejaFirmaServiceImpl. - Firmar. Actualizar bandeja arbitraje");
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(bandejaFirma.getIdtramitehecho());
			arbtramexp = arbtramexpDao.find(arbtramexp);
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
			// SE HA COMPROBADO QUE ERA EL ULTIMO PDTE DE FIRMAR
			// arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			arbtramexpDao.update(arbtramexp);

			// Tratar la bandeja de sanciones

			arbtramexp2Service.actualizaBandeja(arbtramexp);

		}

		// 4. Actualizamos en Dokusi la firma
		logger.info("BandejaFirmaServiceImpl. - Firmar. Aniadir firma");
		Documento documento = new Documento();
		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
		documento.setProcedure(procedure);
		documento.setOidDokusi(bandejaFirma.getIddocumentum());
		if (bandejaFirma.getNofile() != null) {
			documento.setNombre(Y41bUtils.getNameFile(bandejaFirma.getNofile()));
			documento.setExtension(Y41bUtils.getExtensionFile(bandejaFirma.getNofile()));
		}

		// ******************************************************

		documento = this.obtenerFirmaDocumento(documento, bandejaFirma);

		// ******************************************************

		logger.info("BandejaFirmaServiceImpl. - Firmar. Inicio Llamada a Platea" + bandejaFirma);
		y41bDokusiAdapterService.firmarDocumentosDokusi(documento);
		logger.info("BandejaFirmaServiceImpl. - Firmar. Fin Llamada a Platea" + bandejaFirma);
	}

	private void enviarMailArbitros(Arbitro arbitro) {

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

		StringBuffer asunto = new StringBuffer();

		asunto.append("").append(this.appMessageSource.getMessage("firmaArbitrosMail.asunto", null,
				new Locale(Y41bConstantes.CASTELLANO))).append("");

		asunto.append("/").append(
				this.appMessageSource.getMessage("firmaArbitrosMail.asunto", null, new Locale(Y41bConstantes.EUSKERA)))
				.append("");

		StringBuffer texto = new StringBuffer();
		texto.append("<p>")
				.append(this.appMessageSource.getMessage("firmaArbitrosMail.texto", null,
						new Locale(Y41bConstantes.CASTELLANO)))
				.append(" ").append("<a href='")
				.append((String) prop.getProperty("URL_PORTAFIRMASES")).append("'>").append(this.appMessageSource
						.getMessage("firmaArbitrosMail.enlace", null, new Locale(Y41bConstantes.CASTELLANO)))
				.append("</a></p>");

		texto.append("<BR/><BR/>").append("<p>")
				.append(this.appMessageSource.getMessage("firmaArbitrosMail.texto", null,
						new Locale(Y41bConstantes.EUSKERA)))
				.append(" ").append("<a href='")
				.append((String) prop.getProperty("URL_PORTAFIRMASEU")).append("'>").append(this.appMessageSource
						.getMessage("firmaArbitrosMail.enlace", null, new Locale(Y41bConstantes.EUSKERA)))
				.append("</a></p>");

		String from = "";
		String destinatario = "";
		String copiaoculta = "";
		ArrayList attachments = new ArrayList();

		Organismo organismo = new Organismo();
		organismo.setCodOrg("01J001");
		organismo = this.organismoDao.findOrganismoByCodOrg(organismo);
		from = organismo.getEmail();

		if ("C".equals(arbitro.getArindico())) {
			if (null != arbitro.getArteemc() && !"".equals(arbitro.getArteemc())) {
				destinatario = arbitro.getArteemc();
			}
		} else if ("D".equals(arbitro.getArindico())) {
			if (null != arbitro.getArteem() && !"".equals(arbitro.getArteem())) {
				destinatario = arbitro.getArteem();
			}
		}
		if ("" != destinatario) {
			Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from, destinatario, copiaoculta,
					attachments);
		}
	}

	/**
	 * Metodo que actualiza el firmante del documento en la Bandeja de Firma y
	 * que guarda en Dokusi la firma del documento.(Para arbitraje)
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void saveBandejaFirmaDocHashAdh(BandejaFirma bandejaFirma) throws Exception {
		// 1. Actualizamos la BBDD (El monitor que ha firmado)
		logger.info("BandejaFirmaServiceImpl. - Firmar. Actualizar bandeja firma");
		this.bandejaFirmaDao.updateComoFirma(bandejaFirma);
		// 2. Actualizamos el estado del documento (L21X5T00 ->
		// X5ESTADODOCUMENTO, X5FECHAFIRMA, X5COMOFIRMA)
		logger.info("BandejaFirmaServiceImpl. - Firmar. Actualizar estado en arbdoctemp");
		Arbadhsolcomdoc arbadhsolcomdoc = new Arbadhsolcomdoc();
		arbadhsolcomdoc.setXmcodocumento(bandejaFirma.getCodocumento());
		arbadhsolcomdoc.setXmestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO);
		arbadhsolcomdoc.setXmfechafirma(Calendar.getInstance().getTime());
		arbadhsolcomdoc.setXmcomofirma(bandejaFirma.getComofirma());
		arbadhsolcomdocDao.updateDatosFirma(arbadhsolcomdoc);

		// 4. Actualizamos en Dokusi la firma
		logger.info("BandejaFirmaServiceImpl. - Firmar. Aniadir firma");
		Documento documento = new Documento();
		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(
				Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(bandejaFirma.getPcodigo()));
		documento.setProcedure(procedure);
		documento.setOidDokusi(bandejaFirma.getIddocumentum());
		if (bandejaFirma.getNofile() != null) {
			documento.setNombre(Y41bUtils.getNameFile(bandejaFirma.getNofile()));
			documento.setExtension(Y41bUtils.getExtensionFile(bandejaFirma.getNofile()));
		}

		// ******************************************************

		documento = this.obtenerFirmaDocumento(documento, bandejaFirma);

		// ******************************************************

		logger.info("BandejaFirmaServiceImpl. - Firmar. Inicio Llamada a Platea" + bandejaFirma);
		y41bDokusiAdapterService.firmarDocumentosDokusi(documento);
		logger.info("BandejaFirmaServiceImpl. - Firmar. Fin Llamada a Platea" + bandejaFirma);
	}

	/**
	 * Finds a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	public BandejaFirma find(BandejaFirma bandejaFirma) {
		return (BandejaFirma) this.bandejaFirmaDao.find(bandejaFirma);
	}

	/**
	 * Finds a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	public BandejaFirma findByHash(BandejaFirma bandejaFirma) {
		return (BandejaFirma) this.bandejaFirmaDao.findByHash(bandejaFirma);
	}

	/**
	 * Finds a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return BandejaFirmaBusqueda
	 */
	public BandejaFirmaBusqueda findBandejaFirma(BandejaFirma bandejaFirma) {
		return (BandejaFirmaBusqueda) this.bandejaFirmaDao.findBandejaFirma(bandejaFirma);
	}

	/**
	 * Finds a List of rows in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaFirma> findAll(BandejaFirma bandejaFirma, Pagination pagination) {
		return (List<BandejaFirma>) this.bandejaFirmaDao.findAll(bandejaFirma, pagination);
	}

	/**
	 * Counts rows in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return Long
	 */
	public Long findAllCount(BandejaFirma bandejaFirma) {
		return this.bandejaFirmaDao.findAllCount(bandejaFirma);
	}

	/**
	 * Finds a List of rows in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 * @throws Exception
	 *             Exception
	 */
	public List<BandejaFirmaBusqueda> findAllBandejaFirma(BandejaFirma bandejaFirma, CensoMonitor censoMonitor,
			Pagination pagination) throws Exception {

		if (pagination.getSort() != null && pagination.getSort().equals("monombre")) {
			pagination.setSort("COMORESPONSABLE");
		}

		List<BandejaFirmaBusqueda> listBandejaFirmaBusqueda = (List<BandejaFirmaBusqueda>) this.bandejaFirmaDao
				.findAllBandejaFirma(bandejaFirma, censoMonitor, pagination);

		BandejaFirma bandejaFirmaAux = null;
		for (BandejaFirmaBusqueda bandejaFirmaBusqueda : listBandejaFirmaBusqueda) {
			// Solo si el hash no est generado, lo generamos
			if (bandejaFirmaBusqueda.getHashfile() == null || "".equals(bandejaFirmaBusqueda.getHashfile())) {
				Documento documento = new Documento();
				User user = new User();
				user.setNombre(Y41bConstantes.COD_APLICACION);
				user.setDni(Y41bConstantes.COD_APLICACION);
				documento.setUser(user);
				Procedure procedure = new Procedure();
				procedure.setIdProcedimiento(bandejaFirmaBusqueda.getPcodigo());
				documento.setProcedure(procedure);
				documento.setOidDokusi(bandejaFirmaBusqueda.getIddocumentum());

				Documento documentoRdo = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

				documento.setBytes(new String(Y41bUtilsWS.decode(documentoRdo.getBytes())));

				String hashDocumento = y41bPlateaAdapterService.generarHashDocumento(documento);
				bandejaFirmaBusqueda.setHashfile(hashDocumento);

				bandejaFirmaAux = new BandejaFirma();
				bandejaFirmaAux.setIddocumentum(bandejaFirmaBusqueda.getIddocumentum());
				bandejaFirmaAux.setHashfile(bandejaFirmaBusqueda.getHashfile());
				this.updateHashFileBandejaFirma(bandejaFirmaAux);
			}

			if (bandejaFirmaBusqueda.getPcodigo() != null && bandejaFirmaBusqueda.getExpediente() != null
					&& (bandejaFirmaBusqueda.getPcodigo().equals("ADA")
							|| bandejaFirmaBusqueda.getPcodigo().equals("ADM")
							|| bandejaFirmaBusqueda.getPcodigo().equals("ADB"))) {
				bandejaFirmaBusqueda.setExpediente(bandejaFirmaBusqueda.getExpediente()
						.substring(bandejaFirmaBusqueda.getExpediente().indexOf("-") + 1));
			}
		}

		return listBandejaFirmaBusqueda;
	}

	/**
	 * Counts rows in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllBandejaFirmaCount(BandejaFirma bandejaFirma, CensoMonitor censoMonitor) {
		return this.bandejaFirmaDao.findAllBandejaFirmaCount(bandejaFirma, censoMonitor);
	}

	/**
	 * Finds a list of rows in the BandejaFirma table.
	 * 
	 * @param List
	 *            <String> ids de la bandeja de firma
	 * @return List<BandejaFirmaBusqueda>
	 */
	public List<BandejaFirmaBusqueda> findAllByIds(List<String> ids) {
		List<BandejaFirmaBusqueda> listBandejaFirma = (List<BandejaFirmaBusqueda>) this.bandejaFirmaDao
				.findAllByIds(ids);

		return listBandejaFirma;
	}

	/**
	 * Counts rows in the BandejaFirma table.
	 * 
	 * @param List
	 *            <String> ids de la bandeja de firma
	 * @return Long
	 */
	public Long findAllByIdsCount(List<String> ids) {
		return (Long) this.bandejaFirmaDao.findAllByIdsCount(ids);
	}

	/**
	 * Finds rows in the BandejaFirma table using like.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<BandejaFirma> findAllLike(BandejaFirma bandejaFirma, Pagination pagination, Boolean startsWith) {
		return (List<BandejaFirma>) this.bandejaFirmaDao.findAllLike(bandejaFirma, pagination, startsWith);
	}

	/**
	 * Counts rows in the BandejaFirma table using like.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(BandejaFirma bandejaFirma, Boolean startsWith) {
		return this.bandejaFirmaDao.findAllLikeCount(bandejaFirma, startsWith);
	}

	/**
	 * Deletes a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(BandejaFirma bandejaFirma) {
		this.bandejaFirmaDao.remove(bandejaFirma);
	}

	/**
	 * Deletes multiple rows in the BandejaFirma table.
	 * 
	 * @param bandejaFirmaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<BandejaFirma> bandejaFirmaList) {
		for (BandejaFirma bandejaFirmaAux : bandejaFirmaList) {
			this.bandejaFirmaDao.remove(bandejaFirmaAux);
		}
	}

	@Override
	public String findObservacionesBandejaFirmaArbitraje(String codocumento, String idTramite) {
		// TODO Auto-generated method stub
		BandejaFirmaArbitraje bandejaFirmaArbitraje = new BandejaFirmaArbitraje();
		bandejaFirmaArbitraje.setCodocumento(codocumento);
		bandejaFirmaArbitraje.setIdtramitehecho(idTramite);
		bandejaFirmaArbitraje.setEstado(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA);
		List<BandejaFirmaArbitraje> lista = this.bandejaFirmaArbitrajeDao.findAllLike(bandejaFirmaArbitraje, null,
				false);

		String observaciones = "";
		if (!lista.isEmpty()) {
			for (BandejaFirmaArbitraje bandeja : lista) {
				observaciones = observaciones.concat(bandeja.getObservaciones().concat(" "));
			}
		}

		// return this.bandejaFirmaArbitrajeDao.findPorCodocumento(codocumento);
		return observaciones;
	}

	/**
	 * Obtiene la firma del documento para enviar a DOKUSI
	 * 
	 * @param documento
	 *            Documento
	 * @param bandejaFirma
	 *            BandejaFirma
	 * 
	 * @return Documento
	 * @throws Exception
	 *             Exception
	 */
	private Documento obtenerFirmaDocumento(Documento documento, BandejaFirma bandejaFirma) throws Exception {
		Documento docDokusi = y41bDokusiAdapterService.descargarPifDocumentoDokusi(documento);

		EjgvDocumentType signature = new EjgvDocumentType();
		signature.setEjgvDocument(new EjgvDocument());
		signature.getEjgvDocument().setHeader(new Header());
		signature.getEjgvDocument().getHeader().setType("xades");
		signature.getEjgvDocument().getHeader().setPlacement("detached");
		signature.getEjgvDocument().getHeader().setFormat("ES-T");
		signature.getEjgvDocument().getHeader().setVersion("2.0");
		signature.getEjgvDocument().getHeader().setFlags("0");

		signature.getEjgvDocument().setBody(new Body());
		signature.getEjgvDocument().getBody().setSign(bandejaFirma.getFirma());

		Date fechaHoy = new Date();
		String fechaActual = com.ejie.y41b.utils.Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

		StringBuffer nombreSignature = new StringBuffer().append("updateSignatureLocation")
				.append(documento.getOidDokusi()).append(fechaActual).append(".xml");

		// Create JAXB Context
		JAXBContext jaxbContext = JAXBContext.newInstance(EjgvDocumentType.class);

		// Create Marshaller
		Marshaller jaxbMarshaller = jaxbContext.createMarshaller();

		// Required formatting??
		jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

		QName qName = new QName("com.ejie.y41b.nshf.EjgvDocumentType", "ejgvDocumentType");
		JAXBElement<EjgvDocumentType> root = new JAXBElement<EjgvDocumentType>(qName, EjgvDocumentType.class,
				signature);

		// Print XML String to Console
		StringWriter swSignature = new StringWriter();

		// Write XML to StringWriter
		jaxbMarshaller.marshal(root, swSignature);

		InputStream myInputStream = new ByteArrayInputStream(Y41bUtils.removePrefixes(swSignature.toString())
				.replaceAll("<ejgvDocumentType >", "").replaceAll("</ejgvDocumentType>", "").getBytes());

		String idPifSignature = this.y41bPifAdapterService.putFileToPLATEA(myInputStream, nombreSignature.toString());

		Y31AttachmentBean y31AttachmentBeanDoc = this.y41bPifAdapterService.moveToPLATEA(docDokusi.getPifId(), true);

		NSHFServiceImpl nshfService = new NSHFServiceImpl();
		String signatureReturnPifId = nshfService.updateSignatureLocation(idPifSignature,
				y31AttachmentBeanDoc.getFilePath(), Y41bConstantes.COD_APLICACION);
		// *************************************************

		// DESCARGA EL DOCUMENTO DEL PIF
		BufferedInputStream bIS = this.y41bPifAdapterService.getFile(signatureReturnPifId);

		String signaturePifReturn = Y41bUtils.convertInputStreamToString(bIS);

		// Parseo del XML mediante JAXB
		com.ejie.y41b.model.nshf.EjgvDocument signatureReturn = null;

		jaxbContext = JAXBContext.newInstance(com.ejie.y41b.model.nshf.EjgvDocument.class);

		Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
		StringReader reader = new StringReader(signaturePifReturn);
		signatureReturn = (com.ejie.y41b.model.nshf.EjgvDocument) jaxbUnmarshaller.unmarshal(reader);
		// *************************************************

		List<Firma> listaFirma = new ArrayList<Firma>();
		Firma firma = new Firma();
		firma.setFirma(signatureReturn.getBody().getSign());
		listaFirma.add(firma);

		documento.setFirmas(listaFirma);

		documento.setTsaSerialNumber(signatureReturn.getHeader().getTsaSerialNumber());

		return documento;
	}

}
