package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.BandejaFirmaBusqueda;
import com.ejie.y41b.model.CensoMonitor;

/**
 * BandejaFirmaService  
 * 
 *  
 */

public interface BandejaFirmaService {

	/**
	 * Inserts a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	BandejaFirma add(BandejaFirma bandejaFirma);

	/**
	 * Updates a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	BandejaFirma update(BandejaFirma bandejaFirma);

	/**
	 * Updates a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	BandejaFirma updateComoFirma(BandejaFirma bandejaFirma);

	/**
	 * Metodo que actualiza el firmante del documento en la Bandeja de Firma y
	 * que guarda en Dokusi la firma del documento.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	void saveBandejaFirmaDocHashSol(BandejaFirma bandejaFirma) throws Exception;

	/**
	 * Metodo que actualiza el motivo de rechazo de la firma
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	public void denegarBandejaFirmaDocSol(BandejaFirma bandejaFirma)
			throws Exception;

	/**
	 * Metodo que actualiza el firmante del documento en la Bandeja de Firma y
	 * que guarda en Dokusi la firma del documento.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	public void saveBandejaFirmaDocHashIns(BandejaFirma bandejaFirma)
			throws Exception;

	/**
	 * Metodo que actualiza el motivo de rechazo de la firma
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	public void denegarBandejaFirmaDocIns(BandejaFirma bandejaFirma)
			throws Exception;

	/**
	 * Metodo que actualiza el motivo de rechazo de la firma
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	public void denegarBandejaFirmaDocArb(BandejaFirma bandejaFirma)
			throws Exception;

	/**
	 * Metodo que actualiza el motivo de rechazo de la firma
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	public void denegarBandejaFirmaDocSan(BandejaFirma bandejaFirma)
			throws Exception;

	/**
	 * Metodo que actualiza el firmante del documento en la Bandeja de Firma y
	 * que guarda en Dokusi la firma del documento.(Para sanciones)
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	void saveBandejaFirmaDocHashSan(BandejaFirma bandejaFirma) throws Exception;

	/**
	 * Metodo que actualiza el firmante del documento en la Bandeja de Firma y
	 * que guarda en Dokusi la firma del documento.(Para arbitraje)
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @throws Exception
	 */
	void saveBandejaFirmaDocHashArb(BandejaFirma bandejaFirma) throws Exception;

	/**
	 * Finds a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	BandejaFirma find(BandejaFirma bandejaFirma);

	/**
	 * Finds a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return BandejaFirma
	 */
	public BandejaFirma findByHash(BandejaFirma bandejaFirma);

	/**
	 * Finds a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return BandejaFirmaBusqueda
	 */
	public BandejaFirmaBusqueda findBandejaFirma(BandejaFirma bandejaFirma);

	/**
	 * Finds a List of rows in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<BandejaFirma> findAll(BandejaFirma bandejaFirma, Pagination pagination);

	/**
	 * Counts rows in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return Long
	 */
	Long findAllCount(BandejaFirma bandejaFirma);

	/**
	 * Finds a List of rows in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 * @throws Exception
	 *             Exception
	 */
	public List<BandejaFirmaBusqueda> findAllBandejaFirma(
			BandejaFirma bandejaFirma, CensoMonitor censoMonitor,
			Pagination pagination) throws Exception;

	/**
	 * Counts rows in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllBandejaFirmaCount(BandejaFirma bandejaFirma,
			CensoMonitor censoMonitor);

	/**
	 * Finds a list of rows in the BandejaFirma table.
	 * 
	 * @param List
	 *            <String> ids de la bandeja de firma
	 * @return List<BandejaFirmaBusqueda>
	 */
	public List<BandejaFirmaBusqueda> findAllByIds(List<String> ids);

	/**
	 * Counts rows in the BandejaFirma table.
	 * 
	 * @param List
	 *            <String> ids de la bandeja de firma
	 * @return Long
	 */
	public Long findAllByIdsCount(List<String> ids);

	/**
	 * Finds rows in the BandejaFirma table using like.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<BandejaFirma> findAllLike(BandejaFirma bandejaFirma,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the BandejaFirma table using like.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(BandejaFirma bandejaFirma, Boolean startsWith);

	/**
	 * Deletes a single row in the BandejaFirma table.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @return
	 */
	void remove(BandejaFirma bandejaFirma);

	/**
	 * Deletes multiple rows in the BandejaFirma table.
	 * 
	 * @param bandejaFirmaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<BandejaFirma> bandejaFirmaList);

	/**
	 * @param bandejaFirma
	 * @throws Exception
	 */
	void denegarBandejaFirmaDocAdh(BandejaFirma bandejaFirma) throws Exception;

	/**
	 * @param bandejaFirma
	 * @throws Exception
	 */
	void saveBandejaFirmaDocHashAdh(BandejaFirma bandejaFirma) throws Exception;

	/**
	 * @param codocumento
	 * @throws Exception
	 */
	String findObservacionesBandejaFirmaArbitraje(String codocumento,
			String idTramite);

}
