package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.BandejaCampanhaDao;
import com.ejie.y41b.dao.CampanhaCierreDao;
import com.ejie.y41b.dao.CampanhaComentariosDao;
import com.ejie.y41b.dao.CampanhaDao;
import com.ejie.y41b.dao.CampanhaProgramacionDao;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjuntarCampanhaprogra;
import com.ejie.y41b.model.BandejaCampanha;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaCierre;
import com.ejie.y41b.model.CampanhaComentarios;
import com.ejie.y41b.model.CampanhaProgramacion;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * BandejaCampanhaServiceImpl  
 * 
 *  
 */

@Service(value = "bandejaCampanhaService")
public class BandejaCampanhaServiceImpl implements BandejaCampanhaService {

	@Autowired
	private BandejaCampanhaDao bandejaCampanhaDao;
	@Autowired
	private CampanhaComentariosDao campanhaComentariosDao;
	@Autowired
	private CampanhaProgramacionDao campanhaProgramacionDao;
	@Autowired
	private CampanhaCierreDao campanhaCierreDao;
	@Autowired
	private ActuacionDao actuacionDao;
	@Autowired
	private CampanhaDao campanhaDao;
	@Autowired
	private CampanhaService campanhaService;

	/**
	 * Inserts a single row in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @return BandejaCampanha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public BandejaCampanha add(BandejaCampanha bandejaCampanha) {
		return this.bandejaCampanhaDao.add(bandejaCampanha);
	}

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @return BandejaCampanha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public BandejaCampanha update(BandejaCampanha bandejaCampanha) {
		return this.bandejaCampanhaDao.update(bandejaCampanha);
	}

	/**
	 * Finds a single row in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @return BandejaCampanha
	 */
	public BandejaCampanha find(BandejaCampanha bandejaCampanha) {
		return (BandejaCampanha) this.bandejaCampanhaDao.find(bandejaCampanha);
	}

	/**
	 * Finds a List of rows in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaCampanha> findAll(BandejaCampanha bandejaCampanha, CensoMonitor censoMonitor,
			Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("null")) {
				pagination.setSort("TZFEHAST");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		List<BandejaCampanha> listBandejaCampanha = (List<BandejaCampanha>) this.bandejaCampanhaDao
				.findAll(bandejaCampanha, censoMonitor, pagination);

		Campanha campanhaAux = null;
		for (BandejaCampanha bandejaCampanhaAux : listBandejaCampanha) {
			// Campos calculados
			Actuacion actuacion = new Actuacion();
			actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_TOMA_MUESTRAS);
			actuacion.setAtcocm(bandejaCampanhaAux.getCampanha().getCmcodigo());
			actuacion.setAtcopg(bandejaCampanhaAux.getCampanhaProgramacion().getPgcodigo());
			Long numInspeccionesRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			bandejaCampanhaAux.setTznumTomasMuestrasRealizadas(numInspeccionesRealizadas.intValue());

			actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR);
			numInspeccionesRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			bandejaCampanhaAux.setTznumControlesEstandarRealizados(numInspeccionesRealizadas.intValue());

			actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS);
			numInspeccionesRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			bandejaCampanhaAux.setTznumControlesOtrosRealizados(numInspeccionesRealizadas.intValue());

			Integer numInspecciones = 0;
			numInspecciones += bandejaCampanhaAux.getTznumTomasMuestrasSol();
			numInspecciones += bandejaCampanhaAux.getTznumControlesEstandarSol();
			numInspecciones += bandejaCampanhaAux.getTznumControlesOtrosSol();

			bandejaCampanhaAux.setTznumInspeccionesSol(numInspecciones);

			numInspeccionesRealizadas = new Long(0);
			numInspeccionesRealizadas += bandejaCampanhaAux.getTznumTomasMuestrasRealizadas();
			numInspeccionesRealizadas += bandejaCampanhaAux.getTznumControlesEstandarRealizados();
			numInspeccionesRealizadas += bandejaCampanhaAux.getTznumControlesOtrosRealizados();

			bandejaCampanhaAux.setTznumInspeccionesRealizadas(numInspeccionesRealizadas.intValue());

			actuacion.setAttipo(null);
			actuacion.setAtadicional(Y41bConstantes.VALOR_SI);
			Long numInspeccionesAdicionalesRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			bandejaCampanhaAux.setTznumInspecAdicionalesRealizadas(numInspeccionesAdicionalesRealizadas.intValue());

			Integer totalInspecciones = 0;
			totalInspecciones += numInspecciones;
			totalInspecciones += bandejaCampanhaAux.getTznumInspecAdicionalesSol();

			bandejaCampanhaAux.setTztotalInspeccionesSol(totalInspecciones);

			Integer totalInspeccionesRealizadas = 0;
			totalInspeccionesRealizadas += numInspeccionesRealizadas.intValue();
			totalInspeccionesRealizadas += bandejaCampanhaAux.getTznumInspecAdicionalesRealizadas();

			bandejaCampanhaAux.setTztotalInspeccionesRealizadas(totalInspeccionesRealizadas);

			actuacion = new Actuacion();
			actuacion.setAtcocmrelacionada(bandejaCampanhaAux.getCampanha().getCmcodigo());
			actuacion.setAtcopgrelacionada(bandejaCampanhaAux.getCampanhaProgramacion().getPgcodigo());
			Long numInspeccionesAsociadasRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			bandejaCampanhaAux.setTznumInspeccionesAsociadas(numInspeccionesAsociadasRealizadas.intValue());

			// Calcular la fase
			AdjuntarCampanhaprogra adjuntarCampanhaprogra = new AdjuntarCampanhaprogra();
			adjuntarCampanhaprogra.setPgcocm(bandejaCampanhaAux.getCampanha().getCmcodigo());
			adjuntarCampanhaprogra.setPgfedesd(bandejaCampanhaAux.getTzfedesd());
			adjuntarCampanhaprogra.setPgfehast(bandejaCampanhaAux.getTzfehast());

			campanhaAux = this.campanhaDao.find(bandejaCampanhaAux.getCampanha());
			bandejaCampanhaAux.setTzfase(this.campanhaService.obtenerFaseCampnha(campanhaAux));

			// si hay alguno de los comentarios metido poner S
			CampanhaComentarios campanhaComentarios = new CampanhaComentarios();
			campanhaComentarios.setTxcmcodigo(bandejaCampanhaAux.getCampanha().getCmcodigo());
			campanhaComentarios = (CampanhaComentarios) this.campanhaComentariosDao.find(campanhaComentarios);

			if (Y41bUtils.isFilled(campanhaComentarios.getTxcomentarioaraba())
					|| Y41bUtils.isFilled(campanhaComentarios.getTxcomentariobizkaia())
					|| Y41bUtils.isFilled(campanhaComentarios.getTxcomentariogipuzkoa())
					|| Y41bUtils.isFilled(campanhaComentarios.getTxcomentariosscc())) {
				bandejaCampanhaAux.setComentarios(Y41bConstantes.VALOR_SI);
			} else {
				bandejaCampanhaAux.setComentarios(Y41bConstantes.VALOR_NO);
			}

			// obtener numero de programaciones de la campaa
			CampanhaProgramacion campanhaprogramacion = new CampanhaProgramacion();
			campanhaprogramacion.setCampanha(bandejaCampanhaAux.getCampanha());
			Long numProgramacionesCampanha = this.campanhaProgramacionDao.findAllOrganismoCount(campanhaprogramacion);

			bandejaCampanhaAux.setNumProgramaciones(numProgramacionesCampanha.toString());

			// obtener informe final y revisar quien ha rellenado el check de
			// final
			CampanhaCierre campanhaCierre = new CampanhaCierre();
			campanhaCierre.setTycmcodigo(bandejaCampanhaAux.getCampanha().getCmcodigo());
			campanhaCierre = (CampanhaCierre) this.campanhaCierreDao.find(campanhaCierre);

			Long finalizado = new Long(0);

			if (campanhaCierre.getTyfinalizadoaraba() != null
					&& campanhaCierre.getTyfinalizadoaraba().equals(Y41bConstantes.VALOR_SI)) {
				finalizado++;
			}

			if (campanhaCierre.getTyfinalizadobizkaia() != null
					&& campanhaCierre.getTyfinalizadobizkaia().equals(Y41bConstantes.VALOR_SI)) {
				finalizado++;
			}

			if (campanhaCierre.getTyfinalizadogipuzkoa() != null
					&& campanhaCierre.getTyfinalizadogipuzkoa().equals(Y41bConstantes.VALOR_SI)) {
				finalizado++;
			}

			bandejaCampanhaAux.setNumFinalizados(finalizado.toString());

			if (finalizado.equals(numProgramacionesCampanha)) {
				bandejaCampanhaAux.setInformefinal(Y41bConstantes.CAMPANHA_INFORME_COMPLETO);
			} else if (finalizado == 0) {
				bandejaCampanhaAux.setInformefinal(Y41bConstantes.CAMPANHA_INFORME_VACIO);
			} else {
				bandejaCampanhaAux.setInformefinal(Y41bConstantes.CAMPANHA_INFORME_SEMICOMPLETO);
			}
		}

		return listBandejaCampanha;
	}

	/**
	 * Counts rows in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllCount(BandejaCampanha bandejaCampanha, CensoMonitor censoMonitor) {
		return this.bandejaCampanhaDao.findAllCount(bandejaCampanha, censoMonitor);
	}

	/**
	 * Finds a List of rows in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaCampanha> findAllSSCC(BandejaCampanha bandejaCampanha, CensoMonitor censoMonitor,
			Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() == null || pagination.getSort().equals("null")) {
				pagination.setSort("TZFEHAST");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		List<BandejaCampanha> listBandejaCampanha = (List<BandejaCampanha>) this.bandejaCampanhaDao
				.findAllSSCC(bandejaCampanha, censoMonitor, pagination);

		Campanha campanhaAux = null;
		for (BandejaCampanha bandejaCampanhaAux : listBandejaCampanha) {
			// Campos calculados
			Actuacion actuacion = new Actuacion();
			actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_TOMA_MUESTRAS);
			actuacion.setAtcocm(bandejaCampanhaAux.getCampanha().getCmcodigo());
			Long numInspeccionesRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			bandejaCampanhaAux.setTznumTomasMuestrasRealizadas(numInspeccionesRealizadas.intValue());

			actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR);
			numInspeccionesRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			bandejaCampanhaAux.setTznumControlesEstandarRealizados(numInspeccionesRealizadas.intValue());

			actuacion.setAttipo(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS);
			numInspeccionesRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			bandejaCampanhaAux.setTznumControlesOtrosRealizados(numInspeccionesRealizadas.intValue());

			Integer numInspecciones = 0;
			numInspecciones += bandejaCampanhaAux.getTznumTomasMuestrasSol();
			numInspecciones += bandejaCampanhaAux.getTznumControlesEstandarSol();
			numInspecciones += bandejaCampanhaAux.getTznumControlesOtrosSol();

			bandejaCampanhaAux.setTznumInspeccionesSol(numInspecciones);

			numInspeccionesRealizadas = new Long(0);
			numInspeccionesRealizadas += bandejaCampanhaAux.getTznumTomasMuestrasRealizadas();
			numInspeccionesRealizadas += bandejaCampanhaAux.getTznumControlesEstandarRealizados();
			numInspeccionesRealizadas += bandejaCampanhaAux.getTznumControlesOtrosRealizados();

			bandejaCampanhaAux.setTznumInspeccionesRealizadas(numInspeccionesRealizadas.intValue());

			actuacion.setAttipo(null);
			actuacion.setAtadicional(Y41bConstantes.VALOR_SI);
			Long numInspeccionesAdicionalesRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			bandejaCampanhaAux.setTznumInspecAdicionalesRealizadas(numInspeccionesAdicionalesRealizadas.intValue());

			Integer totalInspecciones = 0;
			totalInspecciones += numInspecciones;
			totalInspecciones += bandejaCampanhaAux.getTznumInspecAdicionalesSol();

			bandejaCampanhaAux.setTztotalInspeccionesSol(totalInspecciones);

			Integer totalInspeccionesRealizadas = 0;
			totalInspeccionesRealizadas += numInspeccionesRealizadas.intValue();
			totalInspeccionesRealizadas += bandejaCampanhaAux.getTznumInspecAdicionalesRealizadas();

			bandejaCampanhaAux.setTztotalInspeccionesRealizadas(totalInspeccionesRealizadas);

			actuacion = new Actuacion();
			actuacion.setAtcocmrelacionada(bandejaCampanhaAux.getCampanha().getCmcodigo());
			actuacion.setAtcopgrelacionada(bandejaCampanhaAux.getCampanhaProgramacion().getPgcodigo());
			Long numInspeccionesAsociadasRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);
			bandejaCampanhaAux.setTznumInspeccionesAsociadas(numInspeccionesAsociadasRealizadas.intValue());

			// Calcular la fase
			AdjuntarCampanhaprogra adjuntarCampanhaprogra = new AdjuntarCampanhaprogra();
			adjuntarCampanhaprogra.setPgcocm(bandejaCampanhaAux.getCampanha().getCmcodigo());
			adjuntarCampanhaprogra.setPgfedesd(bandejaCampanhaAux.getTzfedesd());
			adjuntarCampanhaprogra.setPgfehast(bandejaCampanhaAux.getTzfehast());

			campanhaAux = this.campanhaDao.find(bandejaCampanhaAux.getCampanha());
			bandejaCampanhaAux.setTzfase(this.campanhaService.obtenerFaseCampnha(campanhaAux));

			// si hay alguno de los comentarios metido poner S
			CampanhaComentarios campanhaComentarios = new CampanhaComentarios();
			campanhaComentarios.setTxcmcodigo(bandejaCampanhaAux.getCampanha().getCmcodigo());
			campanhaComentarios = (CampanhaComentarios) this.campanhaComentariosDao.find(campanhaComentarios);

			if (Y41bUtils.isFilled(campanhaComentarios.getTxcomentarioaraba())
					|| Y41bUtils.isFilled(campanhaComentarios.getTxcomentariobizkaia())
					|| Y41bUtils.isFilled(campanhaComentarios.getTxcomentariogipuzkoa())
					|| Y41bUtils.isFilled(campanhaComentarios.getTxcomentariosscc())) {
				bandejaCampanhaAux.setComentarios(Y41bConstantes.VALOR_SI);
			} else {
				bandejaCampanhaAux.setComentarios(Y41bConstantes.VALOR_NO);
			}

			// obtener numero de programaciones de la campaa
			CampanhaProgramacion campanhaprogramacion = new CampanhaProgramacion();
			campanhaprogramacion.setCampanha(bandejaCampanhaAux.getCampanha());
			Long numProgramacionesCampanha = this.campanhaProgramacionDao.findAllOrganismoCount(campanhaprogramacion);

			bandejaCampanhaAux.setNumProgramaciones(numProgramacionesCampanha.toString());

			// obtener informe final y revisar quien ha rellenado el check de
			// final
			CampanhaCierre campanhaCierre = new CampanhaCierre();
			campanhaCierre.setTycmcodigo(bandejaCampanhaAux.getCampanha().getCmcodigo());
			campanhaCierre = (CampanhaCierre) this.campanhaCierreDao.find(campanhaCierre);

			Long finalizado = new Long(0);

			if (campanhaCierre.getTyfinalizadoaraba() != null
					&& campanhaCierre.getTyfinalizadoaraba().equals(Y41bConstantes.VALOR_SI)) {
				finalizado++;
			}

			if (campanhaCierre.getTyfinalizadobizkaia() != null
					&& campanhaCierre.getTyfinalizadobizkaia().equals(Y41bConstantes.VALOR_SI)) {
				finalizado++;
			}

			if (campanhaCierre.getTyfinalizadogipuzkoa() != null
					&& campanhaCierre.getTyfinalizadogipuzkoa().equals(Y41bConstantes.VALOR_SI)) {
				finalizado++;
			}

			bandejaCampanhaAux.setNumFinalizados(finalizado.toString());

			if (finalizado.equals(numProgramacionesCampanha)) {
				bandejaCampanhaAux.setInformefinal(Y41bConstantes.CAMPANHA_INFORME_COMPLETO);
			} else if (finalizado == 0) {
				bandejaCampanhaAux.setInformefinal(Y41bConstantes.CAMPANHA_INFORME_VACIO);
			} else {
				bandejaCampanhaAux.setInformefinal(Y41bConstantes.CAMPANHA_INFORME_SEMICOMPLETO);
			}
		}

		return listBandejaCampanha;
	}

	/**
	 * Counts rows in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllSSCCCount(BandejaCampanha bandejaCampanha, CensoMonitor censoMonitor) {
		return this.bandejaCampanhaDao.findAllSSCCCount(bandejaCampanha, censoMonitor);
	}

	/**
	 * Finds rows in the BandejaCampanha table using like.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<BandejaCampanha> findAllLike(BandejaCampanha bandejaCampanha, Pagination pagination,
			Boolean startsWith) {
		return (List<BandejaCampanha>) this.bandejaCampanhaDao.findAllLike(bandejaCampanha, pagination, startsWith);
	}

	/**
	 * Counts rows in the BandejaCampanha table using like.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(BandejaCampanha bandejaCampanha, Boolean startsWith) {
		return this.bandejaCampanhaDao.findAllLikeCount(bandejaCampanha, startsWith);
	}

	/**
	 * Deletes a single row in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(BandejaCampanha bandejaCampanha) {
		this.bandejaCampanhaDao.remove(bandejaCampanha);
	}

	/**
	 * Deletes multiple rows in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanhaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<BandejaCampanha> bandejaCampanhaList) {
		for (BandejaCampanha bandejaCampanhaAux : bandejaCampanhaList) {
			this.bandejaCampanhaDao.remove(bandejaCampanhaAux);
		}
	}

}
