package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.BandejaCampanha;
import com.ejie.y41b.model.CensoMonitor;

/**
 * BandejaCampanhaService  
 * 
 *  
 */

public interface BandejaCampanhaService {

	/**
	 * Inserts a single row in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @return BandejaCampanha
	 */
	BandejaCampanha add(BandejaCampanha bandejaCampanha);

	/**
	 * Updates a single row in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @return BandejaCampanha
	 */
	BandejaCampanha update(BandejaCampanha bandejaCampanha);

	/**
	 * Finds a single row in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @return BandejaCampanha
	 */
	BandejaCampanha find(BandejaCampanha bandejaCampanha);

	/**
	 * Finds a List of rows in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaCampanha> findAll(BandejaCampanha bandejaCampanha,
			CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Counts rows in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllCount(BandejaCampanha bandejaCampanha,
			CensoMonitor censoMonitor);

	/**
	 * Finds rows in the BandejaCampanha table using like.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<BandejaCampanha> findAllLike(BandejaCampanha bandejaCampanha,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the BandejaCampanha table using like.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(BandejaCampanha bandejaCampanha, Boolean startsWith);

	/**
	 * Deletes a single row in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @return
	 */
	void remove(BandejaCampanha bandejaCampanha);

	/**
	 * Deletes multiple rows in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanhaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<BandejaCampanha> bandejaCampanhaList);

	/**
	 * Finds a List of rows in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaCampanha> findAllSSCC(BandejaCampanha bandejaCampanha,
			CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Counts rows in the BandejaCampanha table.
	 * 
	 * @param bandejaCampanha
	 *            BandejaCampanha
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllSSCCCount(BandejaCampanha bandejaCampanha,
			CensoMonitor censoMonitor);
}
