package com.ejie.y41b.service;

import java.util.List;
import java.util.Locale;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.AlertaProgramacionDao;
import com.ejie.y41b.dao.BandejaAlertaDao;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.AlertaProgramacion;
import com.ejie.y41b.model.BandejaAlerta;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * BandejaAlertaServiceImpl  
 * 
 *  
 */

@Service(value = "bandejaAlertaService")
public class BandejaAlertaServiceImpl implements BandejaAlertaService {

	@Autowired
	private BandejaAlertaDao bandejaAlertaDao;
	@Autowired
	private ActuacionDao actuacionDao;
	@Autowired
	private AlertaProgramacionDao alertaProgramacionDao;

	/**
	 * Inserts a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @return BandejaAlerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public BandejaAlerta add(BandejaAlerta bandejaAlerta) {
		return this.bandejaAlertaDao.add(bandejaAlerta);
	}

	/**
	 * Updates a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @return BandejaAlerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public BandejaAlerta update(BandejaAlerta bandejaAlerta) {
		return this.bandejaAlertaDao.update(bandejaAlerta);
	}

	/**
	 * Finds a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @return BandejaAlerta
	 */
	public BandejaAlerta find(BandejaAlerta bandejaAlerta) {
		return (BandejaAlerta) this.bandejaAlertaDao.find(bandejaAlerta);
	}

	/**
	 * Finds a List of rows in the BandejaAlerta table.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaAlerta> findAll(BandejaAlerta bandejaAlerta, CensoMonitor censoMonitor, Pagination pagination) {

		if ("alerta.alcoor".equals(pagination.getSidx())) {
			pagination.setSidx("alcoor");
		} else if ("alerta.alnror".equals(pagination.getSidx())) {
			pagination.setSidx("alnror");

		} else if ("alerta.alnran".equals(pagination.getSidx())) {
			pagination.setSidx("alnran");
		} else if ("intervinientes.nombre".equals(pagination.getSidx())) {
			pagination.setSidx("nombre");
		} else if ("alproducto".equals(pagination.getSidx())) {
			pagination.setSidx("Alnoprse");
		}

		List<BandejaAlerta> listBandejaAlerta = (List<BandejaAlerta>) this.bandejaAlertaDao.findAll(bandejaAlerta,
				censoMonitor, pagination);

		for (BandejaAlerta bandejaAlertaAux : listBandejaAlerta) {
			// Campos calculados
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcoal(bandejaAlertaAux.getAlcodigo());
			actuacion.setAtcocr(bandejaAlertaAux.getCrcodigo());
			Long numInspeccionesRealizadas = this.actuacionDao.findAllInspeccionesRealizadasCount(actuacion);

			bandejaAlertaAux.setNumInspeccionesRealizadas(numInspeccionesRealizadas.intValue());

			Long numInspeccionesEnCurso = this.actuacionDao.findAllInspeccionesEnCursoCount(actuacion);

			bandejaAlertaAux.setNumInspeccionesEnCurso(numInspeccionesEnCurso.intValue());

			Actuacion actuacionAux = this.actuacionDao.findNumProductosActuacion(actuacion);

			bandejaAlertaAux.setNumProductosInmovilizados(actuacionAux.getAtuinmovilizadas().intValue());
			bandejaAlertaAux.setNumProductosDestruidos(actuacionAux.getAtudestruidas().intValue());
			bandejaAlertaAux.setNumProductosDevueltosOrigen(actuacionAux.getAtudevolucionorigen().intValue());

			bandejaAlertaAux
					.setNumProductosLibreComercializacion(actuacionAux.getAtulibrecomercializacion().intValue());
			bandejaAlertaAux.setNumProductosOtros(actuacionAux.getAtuotros().intValue());
			bandejaAlertaAux.setNumProductosTomaMuestras(actuacionAux.getAtutomamuestras().intValue());

			bandejaAlertaAux.setNumProductosRecuperados(actuacionAux.getAturecuperadas().intValue());
			bandejaAlertaAux.setNumProductosPendientes(actuacionAux.getAtupendientes().intValue());

			if (Y41bUtils.isFilled(bandejaAlertaAux.getAlerta().getAlnoprse())
					|| Y41bUtils.isFilled(bandejaAlertaAux.getAlerta().getAlnomaps())
					|| Y41bUtils.isFilled(bandejaAlertaAux.getAlerta().getAlnomops())
					|| Y41bUtils.isFilled(bandejaAlertaAux.getAlerta().getAlnrlops())) {
				StringBuffer producto = new StringBuffer();
				producto.append(Y41bUtils.filtroDB(bandejaAlertaAux.getAlerta().getAlnoprse())).append(" ")
						.append(Y41bUtils.filtroDB(bandejaAlertaAux.getAlerta().getAlnomaps())).append(" ")
						.append(Y41bUtils.filtroDB(bandejaAlertaAux.getAlerta().getAlnomops())).append(" ")
						.append(Y41bUtils.filtroDB(bandejaAlertaAux.getAlerta().getAlnrlops()));
				bandejaAlertaAux.setAlproducto(producto.toString());
			} else {
				Locale locale = LocaleContextHolder.getLocale();
				if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
					bandejaAlertaAux.setAlproducto(bandejaAlertaAux.getAlerta().getPsnombre());
				} else if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
					bandejaAlertaAux.setAlproducto(bandejaAlertaAux.getAlerta().getPsnombree());
				}
			}

			if (censoMonitor != null && censoMonitor.getPerfilOrganizacion() != null && censoMonitor
					.getPerfilOrganizacion().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
				AlertaProgramacion alertaprogramacion = new AlertaProgramacion();
				Alerta alerta = new Alerta();
				alerta.setAlcodigo(bandejaAlertaAux.getAlcodigo());
				alertaprogramacion.setAlerta(alerta);

				alertaprogramacion = this.alertaProgramacionDao.findLimitesAlerta(alertaprogramacion);

				bandejaAlertaAux.setCrfechaplazo(alertaprogramacion.getCrfechaplazo());
			}
		}

		return listBandejaAlerta;
	}

	/**
	 * Counts rows in the BandejaAlerta table.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllCount(BandejaAlerta bandejaAlerta, CensoMonitor censoMonitor) {
		return this.bandejaAlertaDao.findAllCount(bandejaAlerta, censoMonitor);
	}

	/**
	 * Finds rows in the BandejaAlerta table using like.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<BandejaAlerta> findAllLike(BandejaAlerta bandejaAlerta, Pagination pagination, Boolean startsWith) {
		return (List<BandejaAlerta>) this.bandejaAlertaDao.findAllLike(bandejaAlerta, pagination, startsWith);
	}

	/**
	 * Counts rows in the BandejaAlerta table using like.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(BandejaAlerta bandejaAlerta, Boolean startsWith) {
		return this.bandejaAlertaDao.findAllLikeCount(bandejaAlerta, startsWith);
	}

	/**
	 * Deletes a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(BandejaAlerta bandejaAlerta) {
		this.bandejaAlertaDao.remove(bandejaAlerta);
	}

	/**
	 * Deletes multiple rows in the BandejaAlerta table.
	 * 
	 * @param bandejaAlertaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<BandejaAlerta> bandejaAlertaList) {
		for (BandejaAlerta bandejaAlertaAux : bandejaAlertaList) {
			this.bandejaAlertaDao.remove(bandejaAlertaAux);
		}
	}

	/**
	 * Se obtiene el numero de inspecciones pendientes
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	public Long findAllInspeccionesPendientesCount(Actuacion actuacion) {
		return this.actuacionDao.findAllInspeccionesPendientesCount(actuacion);
	}

}
