package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.BandejaAlerta;
import com.ejie.y41b.model.CensoMonitor;

/**
 * BandejaAlertaService  
 * 
 *  
 */

public interface BandejaAlertaService {

	/**
	 * Inserts a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @return BandejaAlerta
	 */
	BandejaAlerta add(BandejaAlerta bandejaAlerta);

	/**
	 * Updates a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @return BandejaAlerta
	 */
	BandejaAlerta update(BandejaAlerta bandejaAlerta);

	/**
	 * Finds a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @return BandejaAlerta
	 */
	BandejaAlerta find(BandejaAlerta bandejaAlerta);

	/**
	 * Finds a List of rows in the BandejaAlerta table.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<BandejaAlerta> findAll(BandejaAlerta bandejaAlerta,
			CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Counts rows in the BandejaAlerta table.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllCount(BandejaAlerta bandejaAlerta,
			CensoMonitor censoMonitor);

	/**
	 * Finds rows in the BandejaAlerta table using like.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<BandejaAlerta> findAllLike(BandejaAlerta bandejaAlerta,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the BandejaAlerta table using like.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(BandejaAlerta bandejaAlerta, Boolean startsWith);

	/**
	 * Deletes a single row in the BandejaAlerta table.
	 * 
	 * @param bandejaAlerta
	 *            BandejaAlerta
	 * @return
	 */
	void remove(BandejaAlerta bandejaAlerta);

	/**
	 * Deletes multiple rows in the BandejaAlerta table.
	 * 
	 * @param bandejaAlertaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<BandejaAlerta> bandejaAlertaList);

	/**
	 * Se obtiene el numero de inspecciones pendientes
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	public Long findAllInspeccionesPendientesCount(Actuacion actuacion);

}
