package com.ejie.y41b.service;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.helper.Y41bDokusiHelper;
import com.ejie.y41b.adapter.services.SirServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbdoctempDao;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.dao.AsientoRegistralDao;
import com.ejie.y41b.dao.BandejaSolicitudesDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.DocumentosAsientoRegistralDao;
import com.ejie.y41b.dao.ExpedienDao;
import com.ejie.y41b.dao.HechoDenunciadoDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.SandoctempDao;
import com.ejie.y41b.dao.SanintervDao;
import com.ejie.y41b.dao.SantramexpDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.dao.TramiteHechoDao;
import com.ejie.y41b.dao.TrasladoDao;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.AsientoRegistral;
import com.ejie.y41b.model.AsientoRegistralDetalle;
import com.ejie.y41b.model.BandejaInspecciones;
import com.ejie.y41b.model.BandejaSolicitudes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoAsientoRegistral;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoTramiteHecho;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Santipdoc;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteAdjuntarDocs;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteHechoDetalle;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.TrasladoBusqueda;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.Metadato;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.sir.rejectdistribution.Distribution;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * AsientoRegistralServiceImpl  
 * 
 *  
 */

@Service(value = "asientoRegistralService")
public class AsientoRegistralServiceImpl implements AsientoRegistralService {

	private static final Logger logger = LoggerFactory.getLogger(AsientoRegistralServiceImpl.class);

	@Autowired
	private AsientoRegistralDao asientoRegistralDao;

	@Autowired
	private DocumentosAsientoRegistralDao documentoAsientoRegistralDao;

	@Autowired
	private TramiteHechoService tramiteHechoService;

	@Autowired
	private IntervinientesDao intervinientesDao;

	@Autowired
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired
	private DocumentoHechoDao documentoHechoDao;

	@Autowired
	private HechoDenunciadoDao hechoDenunciadoDao;

	@Autowired
	private BandejaSolicitudesDao bandejaSolicitudesDao;

	@Autowired
	private TramiteHechoDao tramiteHechoDao;

	@Autowired
	private TrasladoDao trasladoDao;

	@Autowired
	private TramiteInspeccionService tramiteInspeccionService;

	@Autowired
	private BandejaInspeccionesService bandejaInspeccionesService;

	@Autowired
	private SolarbDao solarbDao;

	@Autowired
	private ArbtramexpDao arbtramexpDao;

	@Autowired
	private SantramexpDao santramexpDao;

	@Autowired
	private Arbtramexp2Service arbtramexp2Service;

	@Autowired
	private SantramexpService santramexpService;

	@Autowired
	private ArbtipdocService arbtipdocService;

	@Autowired
	private SantipdocService santipdocService;

	@Autowired
	private ArbintervDao arbintervDao;

	@Autowired
	private SanintervDao sanintervDao;

	@Autowired
	private SandoctempDao sandoctempDao;

	@Autowired
	private ArbdoctempDao arbdoctempDao;

	@Autowired
	private ExpedienDao expedienDao;

	@Autowired
	private InstramexpService instramexpService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Finds a List of rows in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * 
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AsientoRegistral> findAllBandejaAsientoRegistral(AsientoRegistral asientoRegistral,
			CensoMonitor censoMonitor, Pagination pagination) {

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("fechaRegistro")) {
				pagination.setSort("FECHA_REGISTRO");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("fechaRegistro")) {
				pagination.setSort("FECHA_REGISTRO");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("asc")
					&& pagination.getSort().equals("numRegistro")) {
				pagination.setSort("NUM_REGISTRO");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);
			}
		}

		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getAscDsc().equals("desc")
					&& pagination.getSort().equals("numRegistro")) {
				pagination.setSort("NUM_REGISTRO");
				pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
			}
		}

		return (List<AsientoRegistral>) this.asientoRegistralDao.findAllBandejaAsientoRegistral(asientoRegistral,
				censoMonitor, pagination);
	}

	/**
	 * Counts rows in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * 
	 * @return Long
	 */
	public Long findAllBandejaAsientoRegistralCount(AsientoRegistral asientoRegistral, CensoMonitor censoMonitor) {
		return this.asientoRegistralDao.findAllBandejaAsientoRegistralCount(asientoRegistral, censoMonitor);
	}

	/**
	 * Inserts a single row in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @return AsientoRegistral
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public AsientoRegistral addAsientoRegistral(AsientoRegistral asientoRegistral) {
		asientoRegistral.setIdAsiento(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		AsientoRegistralServiceImpl.logger
				.debug("AsientoRegistralServiceImpl.addAsientoRegistral - ANTES add:" + asientoRegistral.toString());

		asientoRegistral = this.asientoRegistralDao.add(asientoRegistral);

		AsientoRegistralServiceImpl.logger
				.debug("AsientoRegistralServiceImpl.addAsientoRegistral - DESPUES add:" + asientoRegistral.toString());

		for (DocumentoAsientoRegistral documentoAsientoRegistralAux : asientoRegistral.getDocumentoAsientoRegistral()) {

			documentoAsientoRegistralAux.setAsientoRegistral(asientoRegistral);
			this.documentoAsientoRegistralDao.add(documentoAsientoRegistralAux);

			AsientoRegistralServiceImpl.logger
					.debug("AsientoRegistralServiceImpl.addAsientoRegistral - DESPUES addDocuments:"
							+ documentoAsientoRegistralAux.toString());
		}

		return asientoRegistral;
	}

	/**
	 * Finds a single row in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * 
	 * @return AsientoRegistral
	 */
	public AsientoRegistral findAsientoRegistral(AsientoRegistral asientoRegistral) {

		asientoRegistral = this.asientoRegistralDao.findAsientoRegistral(asientoRegistral);

		return asientoRegistral;

	}

	/**
	 * Removes a single row in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeAsientoRegistral(AsientoRegistral asientoRegistral) {
		this.asientoRegistralDao.removeAsientoRegistral(asientoRegistral);
	}

	/**
	 * Tramitar documentos Asiento Registral
	 * 
	 * @param asientoRegistralDetalle
	 *            AsientoRegistralDetalle
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void tramitarDocumentosAsientoRegistral(AsientoRegistralDetalle asientoRegistralDetalle) {

		try {
			logger.info("tramitarDocumentosAsientoRegistral - Inicio");

			AsientoRegistral asientoRegistral = new AsientoRegistral();
			asientoRegistral.setIdAsiento(asientoRegistralDetalle.getIdAsiento());
			asientoRegistral = this.asientoRegistralDao.findAsientoRegistral(asientoRegistral);

			DocumentoAsientoRegistral filterDocumentoAsientoRegistral = new DocumentoAsientoRegistral();
			filterDocumentoAsientoRegistral.setAsientoRegistral(asientoRegistral);

			List<DocumentoAsientoRegistral> listaDocumentoAsientoRegistral = this.documentoAsientoRegistralDao
					.findAllDocumentosAR(filterDocumentoAsientoRegistral, null);

			for (DocumentoAsientoRegistral documentoAux : listaDocumentoAsientoRegistral) {
				if (Y41bUtils.isFilled(documentoAux.getOidDokusi())) {

					// documento.setTipoDocumental(documentoSIR.getTipoDocumental());
					/* tipo y desc del doc asiento a documento hecho */

					try {
						// descargar documentos dokusi
						Documento documento = new Documento();
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						if (asientoRegistralDetalle.getPcodigo()
								.equalsIgnoreCase(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
						} else if (asientoRegistralDetalle.getPcodigo()
								.equalsIgnoreCase(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
						} else if (asientoRegistralDetalle.getPcodigo()
								.equalsIgnoreCase(Y41bConstantes.TIPO_PROC_SANCIONES)) {
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
						} else if (asientoRegistralDetalle.getPcodigo()
								.equalsIgnoreCase(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
						}

						documento.setProcedure(procedure);
						documento.setOidDokusi(documentoAux.getOidDokusi());
						documento.setTipoDocumental(documentoAux.getTipoDoc());
						documento.setDescripcion(documentoAux.getDescDoc());
						Documento documentoSIR = y41bDokusiAdapterService.descargarDocumentoSIR(documento);

						documento.setNombre(documentoSIR.getNombre());
						documento.setNumeroExpediente(asientoRegistral.getNumRegistro());

						//
						// List<Metadato> metadatos = new ArrayList<Metadato>();
						//
						// if (documentoSIR != null &&
						// documentoSIR.getMetadatos()
						// != null
						// && documentoSIR.getMetadatos().size() > 0) {
						// for (Metadato metadatoAux :
						// documentoSIR.getMetadatos())
						// {
						// if (metadatoAux.getNombre() != null) {
						// if (metadatoAux.getNombre().equals("r_object_type"))
						// {
						// Metadato metadato = new Metadato();
						// metadato.setNombre(metadatoAux.getNombre());
						// metadato.setValor(metadatoAux.getValor());
						// metadatos.add(metadato);
						// }
						// }
						// }
						// }

						if (asientoRegistralDetalle.getPcodigo().equalsIgnoreCase(Y41bConstantes.TIPO_PROC_SANCIONES)) {
							if (null != documento.getTipoDocumental()) {
								Santipdoc santipdoc = new Santipdoc();
								santipdoc.setTdid(documento.getTipoDocumental());
								santipdoc = this.santipdocService.find(santipdoc);
								documento.setTipoDocumental(santipdoc.getIdTipodoc());
							} else {
								documento.setTipoDocumental(Y41bConstantes.TIPO_DOC_OTROS);
							}
						} else if (asientoRegistralDetalle.getPcodigo()
								.equalsIgnoreCase(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
							if (null != documento.getTipoDocumental()) {
								Arbtipdoc arbtipdoc = new Arbtipdoc();
								arbtipdoc.setTdid(documento.getTipoDocumental());
								arbtipdoc = this.arbtipdocService.find(arbtipdoc);
								documento.setTipoDocumental(arbtipdoc.getIdTipodoc());
							} else {
								documento.setTipoDocumental(Y41bConstantes.TIPO_DOC_ARB_APORTACIONDOCUMENTACION);
							}
						}

						/* Mikel */
						List<Metadato> metadatos = new ArrayList<Metadato>();
						Metadato metadato = new Metadato();
						// metadato.setNombre("r_object_type");
						// metadato.setValor(documentoAux.getTipoDoc());

						// metadato = new Metadato();
						metadato.setNombre("ejgv_serie");

						Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

						if (asientoRegistralDetalle.getPcodigo()
								.equalsIgnoreCase(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
							// Obtener el numero de expediente
							SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
							solicitudDetalle.setHdcodigo(asientoRegistralDetalle.getHdcodigo());

							SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

							StringBuffer numeroExpediente = new StringBuffer();

							numeroExpediente.append(Y41bConstantes.TIPO_PROC_SOLICITUDES).append("-")
									.append(solDetalle.getDecoor()).append("-").append(solDetalle.getDenror())
									.append("-").append(solDetalle.getDenran()).append("-")
									.append(solDetalle.getHdnror());

							metadato.setValor(prop.getProperty("Y41B_RECLAMACION.serie."
									+ Y41bDokusiHelper.getProvSerieFromNumExp(numeroExpediente.toString())));
						} else if (asientoRegistralDetalle.getPcodigo()
								.equalsIgnoreCase(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
							// Obtener el numero de expediente
							StringBuffer numeroExpediente = new StringBuffer();

							numeroExpediente.append(this.instramexpService
									.findNumExpedienteActuacion(asientoRegistralDetalle.getAtcodigo()));

							metadato.setValor(prop.getProperty("Y41B_INSPECCIONES.serie."
									+ Y41bDokusiHelper.getProvSerieFromNumExp(numeroExpediente.toString())));
						} else if (asientoRegistralDetalle.getPcodigo()
								.equalsIgnoreCase(Y41bConstantes.TIPO_PROC_SANCIONES)) {
							// Calculo el numero del expediente para Dokusi
							Expedien expediente = new Expedien();
							expediente.setExcodigo(asientoRegistralDetalle.getExcodigo());
							expediente = this.expedienDao.find(expediente);

							StringBuffer numeroExpediente = new StringBuffer();
							numeroExpediente.append(expediente.damecodCompletoPlatea());

							metadato.setValor(prop.getProperty("Y41B_SANCIONES.serie."
									+ Y41bDokusiHelper.getProvSerieFromNumExp(numeroExpediente.toString())));
						} else if (asientoRegistralDetalle.getPcodigo()
								.equalsIgnoreCase(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
							// Calculo el numero del expediente para Dokusi
							Solarb solarb = new Solarb();
							solarb.setSacodigo(asientoRegistralDetalle.getSacodigo());
							solarb = this.solarbDao.find(solarb);

							StringBuffer numeroExpediente = new StringBuffer();
							numeroExpediente.append(solarb.damecodCompletoPlatea());

							metadato.setValor(prop.getProperty("Y41B_ARBITRAJE.serie."
									+ Y41bDokusiHelper.getProvSerieFromNumExp(numeroExpediente.toString())));
						}

						metadatos.add(metadato);

						metadato = new Metadato();
						metadato.setNombre("ejgv_procedimiento");

						if (asientoRegistralDetalle.getPcodigo()
								.equalsIgnoreCase(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
							metadato.setValor(Y41bConstantes.COD_PROCEDIMIENTO_SOLICITUDES);
						} else if (asientoRegistralDetalle.getPcodigo()
								.equalsIgnoreCase(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
							metadato.setValor(Y41bConstantes.COD_PROCEDIMIENTO_INSPECCIONES);
						} else if (asientoRegistralDetalle.getPcodigo()
								.equalsIgnoreCase(Y41bConstantes.TIPO_PROC_SANCIONES)) {
							metadato.setValor(Y41bConstantes.COD_PROCEDIMIENTO_SANCIONES);
						} else if (asientoRegistralDetalle.getPcodigo()
								.equalsIgnoreCase(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
							metadato.setValor(Y41bConstantes.COD_PROCEDIMIENTO_ARBITRAJE);
						}

						metadatos.add(metadato);

						documento.setMetadatos(metadatos);

						y41bDokusiAdapterService.tramitarDocumentoDokusi(documento);
					} catch (Y41bUDAException ex) {
						if (ex.getException().getLocalizedMessage().contains("T65B -retrieveDocuments-20351")) {

						} else {
							throw ex;
						}
					}

				}
			}

		} catch (Y41bUDAException e) {
			logger.error("tramitarDocumentosAsientoRegistral ERROR ***** ", e);
			throw e;
		} catch (Exception e_tratamientoAportacionDocumentacion) {
			logger.error("tramitarDocumentosAsientoRegistral ERROR ***** ", e_tratamientoAportacionDocumentacion);
			throw new Y41bUDAException("error.sir.invocation", true, e_tratamientoAportacionDocumentacion);
		} finally {
			logger.info("tramitarDocumentosAsientoRegistral - Final");
		}

	}

	/**
	 * adds a new tramite aportacion SOL
	 * 
	 * @param asientoRegistralDetalle
	 *            AsientoRegistralDetalle
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void generarTramiteAportacionDocumentacionSol(AsientoRegistralDetalle asientoRegistralDetalle) {

		try {
			logger.info("generarTramiteAportacionDocumentacionSol - Inicio");

			TramiteHecho tramitehecho = new TramiteHecho();
			tramitehecho.setEhcodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			tramitehecho.setEhcohd(asientoRegistralDetalle.getHdcodigo());
			tramitehecho.setEhcotee(Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION);

			// Evita problemas con las fechas desde hasta
			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));
			tramitehecho.setEhfecha(todayWithZeroTime);

			// como calcular la hora
			String ehhora = null;

			try {
				ehhora = Y41bUtils.formatearDateToString(new Date(), Y41bConstantes.FORMATO_HORA);
			} catch (ParseException e) {
				ehhora = null;
			}

			tramitehecho.setEhhora(ehhora);
			tramitehecho.setEhfechainicio(todayWithZeroTime);
			tramitehecho.setEhissir(Y41bConstantes.VALOR_SI);

			AsientoRegistral asientoRegistral = new AsientoRegistral();
			asientoRegistral.setIdAsiento(asientoRegistralDetalle.getIdAsiento());
			asientoRegistral = this.asientoRegistralDao.findAsientoRegistral(asientoRegistral);

			if (asientoRegistral.getNumRegistroOrigen() != null
					&& !(asientoRegistral.getNumRegistroOrigen().equalsIgnoreCase(""))) {
				tramitehecho.setEhissirconnumregentori(Y41bConstantes.VALOR_SI);
			} else {
				tramitehecho.setEhissirconnumregentori(Y41bConstantes.VALOR_NO);
			}

			tramitehecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

			this.tramiteHechoService.addTramiteHecho(tramitehecho);

			// buscar el interviniente
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(asientoRegistralDetalle.getIdInterviniente());
			intervinientes.setIdExpediente(asientoRegistralDetalle.getHdcodigo());
			intervinientes = this.intervinientesDao.findIntervinienteById(intervinientes);

			DocumentoAsientoRegistral filterDocumentoAsientoRegistral = new DocumentoAsientoRegistral();
			filterDocumentoAsientoRegistral.setAsientoRegistral(asientoRegistral);

			List<DocumentoAsientoRegistral> listaDocumentoAsientoRegistral = this.documentoAsientoRegistralDao
					.findAllDocumentosAR(filterDocumentoAsientoRegistral, null);

			String tipodocumento = "";

			for (DocumentoAsientoRegistral documentoAux : listaDocumentoAsientoRegistral) {
				if (Y41bUtils.isFilled(documentoAux.getOidDokusi())) {
					// descargar documentos dokusi
					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoAux.getOidDokusi());

					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusiSinDocumento(documento);

					// insertar el documento
					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5codocumento(String.valueOf(this.documentoHechoDao.getNewPK().intValue()));
					documentoHecho.setQ5hdcodigo(asientoRegistralDetalle.getHdcodigo());
					documentoHecho.setQ5nofile(docDokusi.getNombre());

					/*
					 * if (docDokusi.getDescripcion() != null) {
					 * documentoHecho.setQ5tedesfile(docDokusi.getDescripcion())
					 * ; } else { documentoHecho.setQ5tedesfile(
					 * docDokusi.getNombre().substring(0,
					 * docDokusi.getNombre().lastIndexOf("."))); }
					 * documentoHecho.setQ5idTipodoc(docDokusi.getTipoDocumental
					 * ());
					 */
					documentoHecho.setQ5idTipodoc(documentoAux.getTipoDoc());
					documentoHecho.setQ5tedesfile(documentoAux.getDescDoc());

					documentoHecho.setQ5iddocumentum(documentoAux.getOidDokusi());
					documentoHecho.setQ5sizefile((int) docDokusi.getLength());
					// Blob blob = new
					// SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
					// documentoHecho.setQ5datafile(blob);
					documentoHecho.setQ5contenttypefile(docDokusi.getContentType());
					documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE);

					if (intervinientes != null && intervinientes.getTipoInterviniente() != null) {
						if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_INTERESADO)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMANTE);
						} else if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_DEMANDADO)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_RECLAMADO);
						} else if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMANTE);
						} else if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMADO)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_REPRESENTANTE_RECLAMADO);
						} else {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_SOL_APORTADO_OTROS);
						}
					}

					documentoHecho.setQ5idinterviniente(intervinientes.getIdinterviniente());

					// SimpleDateFormat formatterFechaRegistro = new
					// SimpleDateFormat(
					// Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT);
					// Date dateFechaRegistro = formatterFechaRegistro
					// .parse(mensajeAportacionDoc.getRegistro().getRegistryTimestamp());
					//
					Date dateFechaRegistro = asientoRegistral.getFechaRegistro();

					documentoHecho.setQ5fecha(dateFechaRegistro);
					documentoHecho.setQ5fechaaportacion(dateFechaRegistro);
					documentoHecho.setQ5tramite(tramitehecho.getEhcodigo());

					documentoHecho.setQ5fechaentrada(dateFechaRegistro);
					documentoHecho.setQ5numregistroentrada(asientoRegistral.getNumRegistro());

					// JAVI
					documentoHecho.setQ5FechaRegistroOrigen(asientoRegistral.getFechaRegistroOrigen());
					documentoHecho.setQ5NumRegistroOrigen(asientoRegistral.getNumRegistroOrigen());

					this.documentoHechoDao.add(documentoHecho);

					// insertar en la tabla de relacion
					DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
					documentoTramiteHecho.setEhcodigo(tramitehecho.getEhcodigo());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);

					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			}

			// borrar docs asiento
			this.documentoAsientoRegistralDao.removeDocumentosAsientoRegistral(asientoRegistral);

			// borrar asiento
			this.asientoRegistralDao.removeAsientoRegistral(asientoRegistral);

			// Actualizar ultimo tramite
			HechoDenunciado hechoDenunciado = new HechoDenunciado();
			hechoDenunciado.setHdcodigo(asientoRegistralDetalle.getHdcodigo());
			hechoDenunciado.setTrcodigoactual(Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION);

			this.hechoDenunciadoDao.updateUltimoTramiteGenerico(hechoDenunciado);

			// Tratar la bandeja
			HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
			hechodenunciadoAux.setHdcodigo(asientoRegistralDetalle.getHdcodigo());
			this.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		} catch (Y41bUDAException e) {
			logger.error("generarTramiteAportacionDocumentacionSol ERROR ***** ", e);
			throw e;
		} catch (Exception e_tratamientoAportacionDocumentacion) {
			logger.error("generarTramiteAportacionDocumentacionSol ERROR ***** ", e_tratamientoAportacionDocumentacion);
			throw new Y41bUDAException("error.sir.invocation", true, e_tratamientoAportacionDocumentacion);
		} finally {
			logger.info("generarTramiteAportacionDocumentacionSol - Final");
		}

	}

	/**
	 * Tratamiento para gestionar la bandeja de solicitudes.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void tratamientoBandejaSolicitudes(HechoDenunciado hechodenunciado) {
		// borrar los tramites del expediente en la bandeja
		BandejaSolicitudes bandejasolicitudes = new BandejaSolicitudes();
		bandejasolicitudes.setHdcodigo(hechodenunciado.getHdcodigo());

		this.bandejaSolicitudesDao.removeAllTramitesExpediente(bandejasolicitudes);

		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(hechodenunciado.getHdcodigo());

		SolicitudDetalle solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		// Miro si la solicitud esta cerrada
		if (solDetalle.getHdfechacierre() == null) {
			// consultar los tramites no tramitados
			List<BandejaSolicitudes> listBandejaSolicitudes = this.bandejaSolicitudesDao
					.findAllTramitesPendientesSolicitudes(bandejasolicitudes, null);

			if (listBandejaSolicitudes != null && listBandejaSolicitudes.size() > 0) {
				// insertar los tramites no tramitados en la bandeja
				for (BandejaSolicitudes bandejaSolicitudesAux : listBandejaSolicitudes) {

					// Si el tramite es una comunicacion, se mira si el tramite
					// de
					// comunicacion esta relacionado con un traslado,
					// Si pertenece a un traslado, se mete el organismo origen
					// en la
					// bandeja, para que aparezca en la bandeja
					// de los instructores del organismo origen para poder
					// realizar
					// la comunicacion
					if (bandejaSolicitudesAux != null && bandejaSolicitudesAux.getTrcodigo() != null
							&& bandejaSolicitudesAux.getTrcodigo().equals(Y41bConstantes.TRAMITE_COMUNICACION)) {
						TramiteHecho tramitehecho = new TramiteHecho();
						tramitehecho.setEhcodigo(bandejaSolicitudesAux.getEhcodigo());

						tramitehecho = this.tramiteHechoDao.find(tramitehecho);

						try {
							if (tramitehecho != null && tramitehecho.getTramiteHecho() != null
									&& tramitehecho.getTramiteHecho().getEhcodigo() != null) {
								TramiteHechoDetalle tramiteHechoDet = new TramiteHechoDetalle();
								tramiteHechoDet.setEhcodigo(tramitehecho.getTramiteHecho().getEhcodigo());
								TrasladoBusqueda trasladoBusqueda = this.trasladoDao
										.findTrasladoTramite(tramiteHechoDet);
								if (trasladoBusqueda != null && trasladoBusqueda.getIhcooror() != null) {
									bandejaSolicitudesAux.setHdcomo(tramitehecho.getEhcomoasignado());
									bandejaSolicitudesAux.setHccoor(trasladoBusqueda.getIhcooror());
								}
							}
						} catch (Throwable e) {
						}
					}

					// insertar el ultimo tramite realizado
					this.bandejaSolicitudesDao.add(bandejaSolicitudesAux);
				}

			} else {
				// si no hay tramites no tramitados
				listBandejaSolicitudes = this.bandejaSolicitudesDao
						.findAllTramitesFinalizadosSolicitudes(bandejasolicitudes, null);

				if (listBandejaSolicitudes != null && listBandejaSolicitudes.size() > 0) {
					if (!listBandejaSolicitudes.get(0).getTrcodigo().equals(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE)) {

						this.bandejaSolicitudesDao.add(listBandejaSolicitudes.get(0));
					}
				}
			}
		}
	}

	/**
	 * Inserts a single row in the Tramite Inspeccion table.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @param mensajeAportacionDoc
	 *            MensajeAportacionDocumentacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void generarTramiteAportacionDocumentacionIns(AsientoRegistralDetalle asientoRegistralDetalle)
			throws Exception {

		try {

			TramiteInspeccion tramiteinspeccion = new TramiteInspeccion();
			tramiteinspeccion.setTicodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			tramiteinspeccion.setTiatcodigo(asientoRegistralDetalle.getAtcodigo());
			tramiteinspeccion.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_APORTAR_DOCUMENTACION);

			tramiteinspeccion.setTifechainicio(new Date());

			tramiteinspeccion.setTiissir(Y41bConstantes.VALOR_SI);
			tramiteinspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			AsientoRegistral asientoRegistral = new AsientoRegistral();

			asientoRegistral.setIdAsiento(asientoRegistralDetalle.getIdAsiento());
			asientoRegistral = this.asientoRegistralDao.findAsientoRegistral(asientoRegistral);

			if (asientoRegistral.getNumRegistroOrigen() != null
					&& !(asientoRegistral.getNumRegistroOrigen().equalsIgnoreCase(""))) {
				tramiteinspeccion.setTiissirconnumregentori(Y41bConstantes.VALOR_SI);
			} else {
				tramiteinspeccion.setTiissirconnumregentori(Y41bConstantes.VALOR_NO);
			}
			this.tramiteInspeccionService.addTramiteInspeccion(tramiteinspeccion);

			// buscar el interviniente por el DNI
			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdinterviniente(asientoRegistralDetalle.getIdInterviniente());
			intervinientes.setIdExpediente(asientoRegistralDetalle.getAtcodigo());
			intervinientes = this.intervinientesDao.findIntervinienteById(intervinientes);

			DocumentoAsientoRegistral filterDocumentoAsientoRegistral = new DocumentoAsientoRegistral();
			filterDocumentoAsientoRegistral.setAsientoRegistral(asientoRegistral);

			List<DocumentoAsientoRegistral> listaDocumentoAsientoRegistral = this.documentoAsientoRegistralDao
					.findAllDocumentosAR(filterDocumentoAsientoRegistral, null);

			String tipodocumento = "";

			for (DocumentoAsientoRegistral documentoAux : listaDocumentoAsientoRegistral) {
				if (Y41bUtils.isFilled(documentoAux.getOidDokusi())) {
					// descargar documentos dokusi
					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoAux.getOidDokusi());

					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusiSinDocumento(documento);

					// insertar el documento
					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5codocumento(String.valueOf(this.documentoHechoDao.getNewPK().intValue()));
					documentoHecho.setQ5hdcodigo(asientoRegistralDetalle.getAtcodigo());
					documentoHecho.setQ5nofile(docDokusi.getNombre());
					/*
					 * if (docDokusi.getDescripcion() != null) {
					 * documentoHecho.setQ5tedesfile(docDokusi.getDescripcion())
					 * ; } else { documentoHecho.setQ5tedesfile(
					 * docDokusi.getNombre().substring(0,
					 * docDokusi.getNombre().lastIndexOf("."))); }
					 * documentoHecho.setQ5idTipodoc(docDokusi.getTipoDocumental
					 * ());
					 */
					documentoHecho.setQ5tedesfile(documentoAux.getDescDoc());
					documentoHecho.setQ5idTipodoc(documentoAux.getTipoDoc());

					documentoHecho.setQ5iddocumentum(documentoAux.getOidDokusi());
					documentoHecho.setQ5sizefile((int) docDokusi.getLength());
					// Blob blob = new
					// SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
					// documentoHecho.setQ5datafile(blob);
					documentoHecho.setQ5contenttypefile(docDokusi.getContentType());
					documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO);

					if (intervinientes != null && intervinientes.getTipoInterviniente() != null) {
						if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_INS_APORTADO_VISITADO);
						} else if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_VISITADO)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_VISITADO);
						} else if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_RESPONSABLE)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_INS_APORTADO_RESPONSABLE);
						} else if (intervinientes.getTipoInterviniente()
								.equals(Y41bConstantes.TIPO_INTERVINIENTE_REPRESENTANTE_ESTABLECIMIENT_RESPONSABLE)) {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_INS_APORTADO_REPRESENTANTE_RESPONSABLE);
						} else {
							documentoHecho.setQ5origen(Y41bConstantes.ORIGEN_INS_APORTADO_OTROS);
						}
					}

					documentoHecho.setQ5idinterviniente(intervinientes.getIdinterviniente());
					//
					// SimpleDateFormat formatterFechaRegistro = new
					// SimpleDateFormat(
					// Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT);
					// Date dateFechaRegistro = formatterFechaRegistro
					// .parse(mensajeAportacionDoc.getRegistro().getRegistryTimestamp());

					Date dateFechaRegistro = asientoRegistral.getFechaRegistro();

					documentoHecho.setQ5fecha(dateFechaRegistro);
					documentoHecho.setQ5fechaaportacion(dateFechaRegistro);
					documentoHecho.setQ5tramite(tramiteinspeccion.getTicodigo());

					documentoHecho.setQ5fechaentrada(dateFechaRegistro);
					documentoHecho.setQ5numregistroentrada(asientoRegistral.getNumRegistro());

					// JAVI
					documentoHecho.setQ5FechaRegistroOrigen(asientoRegistral.getFechaRegistroOrigen());
					documentoHecho.setQ5NumRegistroOrigen(asientoRegistral.getNumRegistroOrigen());

					this.documentoHechoDao.add(documentoHecho);

					// insertar en la tabla de relacion
					DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
					documentoTramiteHecho.setCodocumento(documentoHecho.getQ5codocumento());
					documentoTramiteHecho.setEhcodigo(tramiteinspeccion.getTicodigo());
					documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);

					this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			}

			// borrar docs asiento
			this.documentoAsientoRegistralDao.removeDocumentosAsientoRegistral(asientoRegistral);

			// borrar asiento
			this.asientoRegistralDao.removeAsientoRegistral(asientoRegistral);

			//// Tratar la bandeja inspecciones

			BandejaInspecciones bandejaInspecciones = new BandejaInspecciones();
			bandejaInspecciones.setAtcodigo(asientoRegistralDetalle.getAtcodigo());

			this.bandejaInspeccionesService.updateUltimoTramite(bandejaInspecciones);

		} catch (Y41bUDAException e) {
			logger.error("generarTramiteAportacionDocumentacionIns ERROR ***** ", e);
			throw e;
		} catch (Exception e_tratamientoAportacionDocumentacion) {
			logger.error("generarTramiteAportacionDocumentacionIns ERROR ***** ", e_tratamientoAportacionDocumentacion);
			throw new Y41bUDAException("error.sir.invocation", true, e_tratamientoAportacionDocumentacion);
		} finally {
			logger.info("generarTramiteAportacionDocumentacionIns - Final");
		}

	}

	/**
	 * adds a new tramite aportacion ARB
	 * 
	 * @param asientoRegistralDetalle
	 *            AsientoRegistralDetalle
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void generarTramiteAportacionDocumentacionArb(AsientoRegistralDetalle asientoRegistralDetalle) {

		try {
			logger.info("generarTramiteAportacionDocumentacionArb - Inicio");

			TramiteAdjuntarDocs tramite = new TramiteAdjuntarDocs();
			tramite.setFechaInicio(new Date());
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(asientoRegistralDetalle.getSacodigo());
			tramiteComun.setIdTramite(String.valueOf(this.arbtramexpDao.getNewPK().intValue()));
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_ARBITRAJE_APORTACIONDOCUMENTACION);
			tramiteComun.setTipoProcedimiento(new TipoProcedimiento("ARB"));
			tramite.setIsSIR(Y41bConstantes.VALOR_SI);

			AsientoRegistral asientoRegistral = new AsientoRegistral();
			asientoRegistral.setIdAsiento(asientoRegistralDetalle.getIdAsiento());
			asientoRegistral = this.asientoRegistralDao.findAsientoRegistral(asientoRegistral);

			if (asientoRegistral.getNumRegistroOrigen() != null
					&& !(asientoRegistral.getNumRegistroOrigen().equalsIgnoreCase(""))) {
				tramite.setIsSIRConNumRegEntOri(Y41bConstantes.VALOR_SI);
			} else {
				tramite.setIsSIRConNumRegEntOri(Y41bConstantes.VALOR_NO);
			}

			Arbtramexp arbtramexp = this.arbtramexp2Service.addTramiteAdjuntarDocs(tramite, tramiteComun, "", false,
					"AR");

			// buscar el interviniente
			Arbinterv intervinientes = new Arbinterv();
			intervinientes.setUaidinterv(new BigDecimal(asientoRegistralDetalle.getIdInterviniente()));
			// intervinientes.setUaexcodigo(asientoRegistralDetalle.getHdcodigo());
			intervinientes = this.arbintervDao.find(intervinientes);

			DocumentoAsientoRegistral filterDocumentoAsientoRegistral = new DocumentoAsientoRegistral();
			filterDocumentoAsientoRegistral.setAsientoRegistral(asientoRegistral);

			List<DocumentoAsientoRegistral> listaDocumentoAsientoRegistral = this.documentoAsientoRegistralDao
					.findAllDocumentosAR(filterDocumentoAsientoRegistral, null);

			String tipodocumento = "";

			for (DocumentoAsientoRegistral documentoAux : listaDocumentoAsientoRegistral) {
				if (Y41bUtils.isFilled(documentoAux.getOidDokusi())) {
					// descargar documentos dokusi
					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoAux.getOidDokusi());

					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

					// insertar el documento
					Arbdoctemp documentoHecho = new Arbdoctemp();
					documentoHecho.setX5codocumento(String.valueOf(this.arbdoctempDao.getNewPK().intValue()));
					documentoHecho.setX5excodigo(asientoRegistralDetalle.getSacodigo());
					documentoHecho.setX5nofile(docDokusi.getNombre());
					// if (docDokusi.getDescripcion() != null) {
					// documentoHecho.setX5tedesfile(docDokusi.getDescripcion());
					// } else {
					// documentoHecho.setX5tedesfile(
					// docDokusi.getNombre().substring(0,
					// docDokusi.getNombre().lastIndexOf(".")));
					// }
					documentoHecho.setX5iddocumentum(documentoAux.getOidDokusi());
					documentoHecho.setX5sizefile((int) docDokusi.getLength());
					// Blob blob = new
					// SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
					// documentoHecho.setX5datafile(blob);
					documentoHecho.setX5conttype(docDokusi.getContentType());
					documentoHecho.setX5origen(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE);

					if (intervinientes != null && intervinientes.getUatipointerv() != null) {
						if (intervinientes.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE)) {
							documentoHecho.setX5origen(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE);
						} else if (intervinientes.getUatipointerv()
								.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO)) {
							documentoHecho.setX5origen(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO);
						} else if (intervinientes.getUatipointerv()
								.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE)) {
							documentoHecho.setX5origen(Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE);
						} else if (intervinientes.getUatipointerv()
								.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO)) {
							documentoHecho.setX5origen(Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO);
						} else {
							documentoHecho.setX5origen(Y41bConstantes.ORIGEN_ARB_APORTADO_OTROS);
						}
					}

					documentoHecho.setX5idinterviniente(intervinientes.getUaidinterv().toString());

					// SimpleDateFormat formatterFechaRegistro = new
					// SimpleDateFormat(
					// Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT);
					// Date dateFechaRegistro = formatterFechaRegistro
					// .parse(mensajeAportacionDoc.getRegistro().getRegistryTimestamp());
					//
					Date dateFechaRegistro = asientoRegistral.getFechaRegistro();

					documentoHecho.setX5fecha(dateFechaRegistro);
					documentoHecho.setX5fechaaportacion(dateFechaRegistro);
					// documentoHecho.setX5tramite(arbtramexp.getTrid());
					documentoHecho.setArbtramexp(arbtramexp);

					documentoHecho.setX5fechaentrada(dateFechaRegistro);
					documentoHecho.setX5numregistroentrada(asientoRegistral.getNumRegistro());
					// documentoHecho.setX5tipodocumento(docDokusi.getTipoDocumental());
					// documentoHecho.setX5tipodocumento(Y41bConstantes.TIPO_DOC_ARB_APORTACIONDOCUMENTACION);
					// documentoHecho.setArbtipdoc(new
					// Arbtipdoc(Y41bConstantes.TIPO_DOC_ARB_APORTACIONDOCUMENTACION));
					documentoHecho.setX5numregistroorigen(asientoRegistral.getNumRegistroOrigen());
					documentoHecho.setX5fecharegistroorigen(asientoRegistral.getFechaRegistroOrigen());
					// Anyadir nuevos valores de asiento registral
					documentoHecho.setX5tedesfile(documentoAux.getDescDoc());
					documentoHecho.setX5tipodocumento(documentoAux.getTipoDoc());
					documentoHecho.setArbtipdoc(new Arbtipdoc(documentoAux.getTipoDoc()));

					this.arbdoctempDao.add(documentoHecho);

					// insertar en la tabla de relacion
					// DocumentoTramiteHecho documentoTramiteHecho = new
					// DocumentoTramiteHecho();
					// documentoTramiteHecho.setCodocumento(documentoHecho.getX5codocumento());
					// documentoTramiteHecho.setEhcodigo(arbtramexp.getTrid());
					// documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
					//
					// this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
					this.arbdoctempDao.insertArbDocTramite(arbtramexp.getTrid(), documentoHecho.getX5codocumento(),
							Y41bConstantes.TIPO_PROC_ARBITRAJE);
				}
			}

			// borrar docs asiento
			this.documentoAsientoRegistralDao.removeDocumentosAsientoRegistral(asientoRegistral);

			// borrar asiento
			this.asientoRegistralDao.removeAsientoRegistral(asientoRegistral);

			// Actualizar ultimo tramite

			// Tratar la bandeja

		} catch (Y41bUDAException e) {
			logger.error("generarTramiteAportacionDocumentacionArb ERROR ***** ", e);
			throw e;
		} catch (Exception e_tratamientoAportacionDocumentacion) {
			logger.error("generarTramiteAportacionDocumentacionArb ERROR ***** ", e_tratamientoAportacionDocumentacion);
			throw new Y41bUDAException("error.platea.invocation", true, e_tratamientoAportacionDocumentacion);
		} finally {
			logger.info("generarTramiteAportacionDocumentacionArb - Final");
		}

	}

	/**
	 * adds a new tramite aportacion san
	 * 
	 * @param asientoRegistralDetalle
	 *            AsientoRegistralDetalle
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void generarTramiteAportacionDocumentacionSan(AsientoRegistralDetalle asientoRegistralDetalle) {

		try {
			logger.info("generarTramiteAportacionDocumentacionSan - Inicio");

			TramiteAdjuntarDocs tramite = new TramiteAdjuntarDocs();
			tramite.setFechaInicio(new Date());
			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(asientoRegistralDetalle.getExcodigo());
			tramiteComun.setIdTipoTramite(Y41bConstantes.TRAMITE_SANCIONES_APORTACIONDOCUMENTACION);
			tramiteComun.setIdTramite(String.valueOf(this.santramexpDao.getNewPK().intValue()));
			tramiteComun.setTipoProcedimiento(new TipoProcedimiento("SAN"));
			tramite.setIsSIR(Y41bConstantes.VALOR_SI);
			AsientoRegistral asientoRegistral = new AsientoRegistral();
			asientoRegistral.setIdAsiento(asientoRegistralDetalle.getIdAsiento());
			asientoRegistral = this.asientoRegistralDao.findAsientoRegistral(asientoRegistral);

			if (asientoRegistral.getNumRegistroOrigen() != null
					&& !(asientoRegistral.getNumRegistroOrigen().equalsIgnoreCase(""))) {
				tramite.setIsSIRConNumRegEntOri(Y41bConstantes.VALOR_SI);
			} else {
				tramite.setIsSIRConNumRegEntOri(Y41bConstantes.VALOR_NO);
			}
			Santramexp santramexpAux = this.santramexpService.addTramiteAdjuntarDocs(tramite, tramiteComun, "", false,
					"AR");

			// buscar el interviniente
			Saninterv intervinientes = new Saninterv();
			intervinientes.setUaidinterv(new BigDecimal(asientoRegistralDetalle.getIdInterviniente()));
			intervinientes.setUaescodigo(asientoRegistralDetalle.getExcodigo());
			intervinientes = this.sanintervDao.find(intervinientes);

			DocumentoAsientoRegistral filterDocumentoAsientoRegistral = new DocumentoAsientoRegistral();
			filterDocumentoAsientoRegistral.setAsientoRegistral(asientoRegistral);

			List<DocumentoAsientoRegistral> listaDocumentoAsientoRegistral = this.documentoAsientoRegistralDao
					.findAllDocumentosAR(filterDocumentoAsientoRegistral, null);

			String tipodocumento = "";

			for (DocumentoAsientoRegistral documentoAux : listaDocumentoAsientoRegistral) {
				if (Y41bUtils.isFilled(documentoAux.getOidDokusi())) {
					// descargar documentos dokusi
					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
					documento.setProcedure(procedure);
					documento.setOidDokusi(documentoAux.getOidDokusi());

					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

					// insertar el documento
					Sandoctemp documentoHecho = new Sandoctemp();
					documentoHecho.setU5codocumento(String.valueOf(this.documentoHechoDao.getNewPK().intValue()));
					documentoHecho.setExpedien(new Expedien(asientoRegistralDetalle.getExcodigo()));
					documentoHecho.setU5nofile(docDokusi.getNombre());
					// if (docDokusi.getDescripcion() != null) {
					// documentoHecho.setU5tedesfile(docDokusi.getDescripcion());
					// } else {
					// documentoHecho.setU5tedesfile(
					// docDokusi.getNombre().substring(0,
					// docDokusi.getNombre().lastIndexOf(".")));
					// }
					documentoHecho.setU5iddocumentum(documentoAux.getOidDokusi());
					documentoHecho.setU5sizefile((int) docDokusi.getLength());
					// Blob blob = new
					// SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
					// documentoHecho.setU5datafile(blob);
					documentoHecho.setU5conttype(docDokusi.getContentType());
					documentoHecho.setU5origen(Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMANTE);

					if (intervinientes != null && intervinientes.getUatipointerv() != null) {
						if (intervinientes.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO)) {
							documentoHecho.setU5origen(Y41bConstantes.ORIGEN_SAN_APORTADO_RECLAMADO);
						} else if (intervinientes.getUatipointerv()
								.equals(Y41bConstantes.TIPO_INTERVINIENTESAN_REPRESENTANTE_SANCIONADO)) {
							documentoHecho.setU5origen(Y41bConstantes.ORIGEN_SAN_APORTADO_REPRESENTANTE_SANCIONADO);
						} else {
							documentoHecho.setU5origen(Y41bConstantes.ORIGEN_SAN_APORTADO_OTROS);
						}
					}

					documentoHecho.setU5idinterviniente(intervinientes.getUaidinterv().toString());

					// SimpleDateFormat formatterFechaRegistro = new
					// SimpleDateFormat(
					// Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT);
					// Date dateFechaRegistro = formatterFechaRegistro
					// .parse(mensajeAportacionDoc.getRegistro().getRegistryTimestamp());
					//
					Date dateFechaRegistro = asientoRegistral.getFechaRegistro();

					documentoHecho.setU5fecha(dateFechaRegistro);
					documentoHecho.setU5fechaaportacion(dateFechaRegistro);
					documentoHecho.setSantramexp(santramexpAux);

					documentoHecho.setU5fechaentrada(dateFechaRegistro);
					documentoHecho.setU5numregistroentrada(asientoRegistral.getNumRegistro());

					// documentoHecho.setU5tipodocumento(docDokusi.getTipoDocumental());
					// documentoHecho.setU5tipodocumento(Y41bConstantes.TIPO_DOC_OTROS);

					// Anyadir nuevos valores de asiento registral
					documentoHecho.setU5tedesfile(documentoAux.getDescDoc());
					documentoHecho.setU5tipodocumento(documentoAux.getTipoDoc());

					this.sandoctempDao.add(documentoHecho);

					this.sandoctempDao.updateSanDocTempRegistroOrigen(asientoRegistral.getNumRegistroOrigen(),
							asientoRegistral.getFechaRegistroOrigen(), documentoHecho.getU5codocumento());

					// insertar en la tabla de relacion
					// DocumentoTramiteHecho documentoTramiteHecho = new
					// DocumentoTramiteHecho();
					// documentoTramiteHecho.setCodocumento(documentoHecho.getU5codocumento());
					// documentoTramiteHecho.setEhcodigo(santramexpAux.getTrid());
					// documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_SOLICITUDES);

					this.sandoctempDao.insertSanDocTramite(santramexpAux.getTrid(), documentoHecho.getU5codocumento(),
							Y41bConstantes.TIPO_PROC_SANCIONES);

					// this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);
				}
			}

			// borrar docs asiento
			this.documentoAsientoRegistralDao.removeDocumentosAsientoRegistral(asientoRegistral);

			// borrar asiento
			this.asientoRegistralDao.removeAsientoRegistral(asientoRegistral);

			// Actualizar ultimo tramite?
			// HechoDenunciado hechoDenunciado = new HechoDenunciado();
			// hechoDenunciado.setHdcodigo(asientoRegistralDetalle.getHdcodigo());
			// hechoDenunciado.setTrcodigoactual(Y41bConstantes.TRAMITE_ADJUNTAR_DOCUMENTACION);
			//
			// this.hechoDenunciadoDao.updateUltimoTramiteGenerico(hechoDenunciado);

			// Tratar la bandeja?
			// HechoDenunciado hechodenunciadoAux = new HechoDenunciado();
			// hechodenunciadoAux.setHdcodigo(asientoRegistralDetalle.getHdcodigo());
			// this.tratamientoBandejaSolicitudes(hechodenunciadoAux);

		} catch (Y41bUDAException e) {
			logger.error("generarTramiteAportacionDocumentacionSan ERROR ***** ", e);
			throw e;
		} catch (Exception e_tratamientoAportacionDocumentacion) {
			logger.error("generarTramiteAportacionDocumentacionSan ERROR ***** ", e_tratamientoAportacionDocumentacion);
			throw new Y41bUDAException("error.platea.invocation", true, e_tratamientoAportacionDocumentacion);
		} finally {
			logger.info("generarTramiteAportacionDocumentacionSan - Final");
		}

	}

	/**
	 * REchaza asiento registral
	 * 
	 * @param asientoRegistralDetalle
	 *            AsientoRegistralDetalle
	 * 
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void rechazarAR(AsientoRegistralDetalle asientoRegistralDetalle) {

		try {
			// recuperar asiento completo
			AsientoRegistral asientoRegistral = new AsientoRegistral();
			asientoRegistral.setIdAsiento(asientoRegistralDetalle.getIdAsiento());
			asientoRegistral = this.findAsientoRegistral(asientoRegistral);

			// rechazar llamada al ws rejectDistribution

			String tokenSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getTokenAplicacion(
					Boolean.parseBoolean(this.appConfiguration.getProperty("xlnets.loginApp.isSimulated")));

			Distribution distribution = new Distribution();
			distribution.setCause(asientoRegistralDetalle.getMotivoRechazo());
			distribution.setRegistryNumber(asientoRegistral.getNumRegistro());

			JAXBContext jaxbContext = JAXBContext.newInstance(Distribution.class);
			StringWriter writer = new StringWriter();
			Marshaller m = jaxbContext.createMarshaller();
			m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

			jaxbContext.createMarshaller().marshal(distribution, writer);
			String distributionInfo = writer.toString().replaceAll("(<\\?xml.*?\\?>)", ""); // necesario

			SirServiceImpl sirServiceImpl = new SirServiceImpl();
			String resultado = sirServiceImpl.rejectDistribution(tokenSesion, distributionInfo);
			logger.info("RESULTADO: " + resultado);

			int index = resultado.indexOf("true");
			if (index == -1) {
				throw new Y41bUDAException("error.sir.invocation", true, null);
			}

			// borrar docs asiento
			this.documentoAsientoRegistralDao.removeDocumentosAsientoRegistral(asientoRegistral);

			// borrar asiento
			this.asientoRegistralDao.removeAsientoRegistral(asientoRegistral);

		} catch (Y41bUDAException e) {
			logger.error("rechazarAR ERROR ***** ", e);
			throw e;
		} catch (Exception e_tratamientoRechazarAR) {
			logger.error("rechazarAR ERROR ***** ", e_tratamientoRechazarAR);
			throw new Y41bUDAException("error.sir.invocation", true, e_tratamientoRechazarAR);
		} finally {
			logger.info("rechazarAR - Final");
		}

	}
}
