package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AsientoRegistral;
import com.ejie.y41b.model.AsientoRegistralDetalle;
import com.ejie.y41b.model.CensoMonitor;

/**
 * AsientoRegistralService  
 * 
 *  
 */

public interface AsientoRegistralService {

	/**
	 * Finds a List of rows in the ComunicacionSoivre table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AsientoRegistral> findAllBandejaAsientoRegistral(AsientoRegistral asientoRegistral,
			CensoMonitor censoMonitor, Pagination pagination);

	/**
	 * Counts rows in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Long
	 */
	public Long findAllBandejaAsientoRegistralCount(AsientoRegistral asientoRegistral, CensoMonitor censoMonitor);

	/**
	 * add row in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @return AsientoRegistral
	 */
	public AsientoRegistral addAsientoRegistral(AsientoRegistral asientoRegistral);

	/**
	 * Finds a single row in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * 
	 * @return AsientoRegistral
	 */
	public AsientoRegistral findAsientoRegistral(AsientoRegistral asientoRegistral);

	/**
	 * Removes a single row in the AsientoRegistral table.
	 * 
	 * @param asientoRegistral
	 *            AsientoRegistral
	 * @return
	 */
	public void removeAsientoRegistral(AsientoRegistral asientoRegistral);

	/**
	 * adds a new tramite aportacion SOL
	 * 
	 * @param asientoRegistralDetalle
	 *            AsientoRegistralDetalle
	 * @return
	 */
	public void generarTramiteAportacionDocumentacionSol(AsientoRegistralDetalle asientoRegistralDetalle);

	/**
	 * adds a new tramite aportacion INS
	 * 
	 * @param asientoRegistralDetalle
	 *            AsientoRegistralDetalle
	 * @return
	 */
	public void generarTramiteAportacionDocumentacionIns(AsientoRegistralDetalle asientoRegistralDetalle)
			throws Exception;

	/**
	 * adds a new tramite aportacion SAN
	 * 
	 * @param asientoRegistralDetalle
	 *            AsientoRegistralDetalle
	 * @return
	 */
	public void generarTramiteAportacionDocumentacionSan(AsientoRegistralDetalle asientoRegistralDetalle);

	/**
	 * adds a new tramite aportacion ARB
	 * 
	 * @param asientoRegistralDetalle
	 *            AsientoRegistralDetalle
	 * @return
	 */
	public void generarTramiteAportacionDocumentacionArb(AsientoRegistralDetalle asientoRegistralDetalle);

	/**
	 * adds a new tramite aportacion INS
	 * 
	 * @param asientoRegistralDetalle
	 *            AsientoRegistralDetalle
	 * @return
	 */
	public void rechazarAR(AsientoRegistralDetalle asientoRegistralDetalle);

	/**
	 * Tramitar documentos Asiento Registral
	 * 
	 * @param asientoRegistralDetalle
	 *            AsientoRegistralDetalle
	 * @return
	 */
	public void tramitarDocumentosAsientoRegistral(AsientoRegistralDetalle asientoRegistralDetalle);

}
