package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.Arta1Dao;
import com.ejie.y41b.model.Arta1;

/**
 * Arta1ServiceImpl  
 * 
 *  
 */

@Service(value = "arta1Service")
public class Arta1ServiceImpl implements Arta1Service {

	@Autowired()
	private Arta1Dao arta1Dao;

	/**
	 * Inserts a single row in the Arta1 table.
	 * 
	 * @param arta1
	 *            Arta1
	 * @return Arta1
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arta1 add(Arta1 arta1) {
		return this.arta1Dao.add(arta1);
	}

	/**
	 * Updates a single row in the Arta1 table.
	 * 
	 * @param arta1
	 *            Arta1
	 * @return Arta1
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arta1 update(Arta1 arta1) {
		return this.arta1Dao.update(arta1);
	}

	/**
	 * Finds a single row in the Arta1 table.
	 * 
	 * @param arta1
	 *            Arta1
	 * @return Arta1
	 */
	public Arta1 find(Arta1 arta1) {
		return (Arta1) this.arta1Dao.find(arta1);
	}

	/**
	 * Finds a List of rows in the Arta1 table.
	 * 
	 * @param arta1
	 *            Arta1
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arta1> findAll(Arta1 arta1, Pagination pagination) {
		return (List<Arta1>) this.arta1Dao.findAll(arta1, pagination);
	}

	/**
	 * Counts rows in the Arta1 table.
	 * 
	 * @param arta1
	 *            Arta1
	 * @return Long
	 */
	public Long findAllCount(Arta1 arta1) {
		return this.arta1Dao.findAllCount(arta1);
	}

	/**
	 * Finds rows in the Arta1 table using like.
	 * 
	 * @param arta1
	 *            Arta1
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arta1> findAllLike(Arta1 arta1, Pagination pagination,
			Boolean startsWith) {
		return (List<Arta1>) this.arta1Dao.findAllLike(arta1, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Arta1 table using like.
	 * 
	 * @param arta1
	 *            Arta1
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arta1 arta1, Boolean startsWith) {
		return this.arta1Dao.findAllLikeCount(arta1, startsWith);
	}

	/**
	 * Deletes a single row in the Arta1 table.
	 * 
	 * @param arta1
	 *            Arta1
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arta1 arta1) {
		this.arta1Dao.remove(arta1);
	}

	/**
	 * Deletes multiple rows in the Arta1 table.
	 * 
	 * @param arta1List
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arta1> arta1List) {
		for (Arta1 arta1Aux : arta1List) {
			this.arta1Dao.remove(arta1Aux);
		}
	}

}
