package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Arta1;

/**
 * Arta1Service  
 * 
 *  
 */

public interface Arta1Service {

	/**
	 * Inserts a single row in the Arta1 table.
	 * 
	 * @param arta1
	 *            Arta1
	 * @return Arta1
	 */
	Arta1 add(Arta1 arta1);

	/**
	 * Updates a single row in the Arta1 table.
	 * 
	 * @param arta1
	 *            Arta1
	 * @return Arta1
	 */
	Arta1 update(Arta1 arta1);

	/**
	 * Finds a single row in the Arta1 table.
	 * 
	 * @param arta1
	 *            Arta1
	 * @return Arta1
	 */
	Arta1 find(Arta1 arta1);

	/**
	 * Finds a List of rows in the Arta1 table.
	 * 
	 * @param arta1
	 *            Arta1
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arta1> findAll(Arta1 arta1, Pagination pagination);

	/**
	 * Counts rows in the Arta1 table.
	 * 
	 * @param arta1
	 *            Arta1
	 * @return Long
	 */
	Long findAllCount(Arta1 arta1);

	/**
	 * Finds rows in the Arta1 table using like.
	 * 
	 * @param arta1
	 *            Arta1
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arta1> findAllLike(Arta1 arta1, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arta1 table using like.
	 * 
	 * @param arta1
	 *            Arta1
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arta1 arta1, Boolean startsWith);

	/**
	 * Deletes a single row in the Arta1 table.
	 * 
	 * @param arta1
	 *            Arta1
	 * @return
	 */
	void remove(Arta1 arta1);

	/**
	 * Deletes multiple rows in the Arta1 table.
	 * 
	 * @param arta1List
	 *            List
	 * @return
	 */
	void removeMultiple(List<Arta1> arta1List);

}
