package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ArseDao;
import com.ejie.y41b.model.Arse;

/**
 * ArseServiceImpl  
 * 
 *  
 */

@Service(value = "arseService")
public class ArseServiceImpl implements ArseService {

	@Autowired()
	private ArseDao arseDao;

	/**
	 * Inserts a single row in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return Arse
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arse add(Arse arse) {
		return this.arseDao.add(arse);
	}

	/**
	 * Updates a single row in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return Arse
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arse update(Arse arse) {
		return this.arseDao.update(arse);
	}

	/**
	 * Finds a single row in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return Arse
	 */
	public Arse find(Arse arse) {
		return (Arse) this.arseDao.find(arse);
	}

	/**
	 * Finds a List of rows in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arse> findAll(Arse arse, Pagination pagination) {
		if (pagination.getSort() != null
				&& pagination.getSort().equals("sector.senombre")) {
			pagination.setSort("SectorSENOMBRE");
		}
		if (pagination.getSort() != null
				&& pagination.getSort().equals("sector.senombre")) {
			pagination.setSort("SectorSENOMBREE");
		}
		return (List<Arse>) this.arseDao.findAll(arse, pagination);
	}

	/**
	 * Counts rows in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return Long
	 */
	public Long findAllCount(Arse arse) {
		return this.arseDao.findAllCount(arse);
	}

	/**
	 * Finds rows in the Arse table using like.
	 * 
	 * @param arse
	 *            Arse
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arse> findAllLike(Arse arse, Pagination pagination,
			Boolean startsWith) {
		return (List<Arse>) this.arseDao.findAllLike(arse, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Arse table using like.
	 * 
	 * @param arse
	 *            Arse
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arse arse, Boolean startsWith) {
		return this.arseDao.findAllLikeCount(arse, startsWith);
	}

	/**
	 * Deletes a single row in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arse arse) {
		this.arseDao.remove(arse);
	}

	/**
	 * Deletes multiple rows in the Arse table.
	 * 
	 * @param arseList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arse> arseList) {
		for (Arse arseAux : arseList) {
			this.arseDao.remove(arseAux);
		}
	}

}
