package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Arse;

/**
 * ArseService  
 * 
 *  
 */

public interface ArseService {

	/**
	 * Inserts a single row in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return Arse
	 */
	Arse add(Arse arse);

	/**
	 * Updates a single row in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return Arse
	 */
	Arse update(Arse arse);

	/**
	 * Finds a single row in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return Arse
	 */
	Arse find(Arse arse);

	/**
	 * Finds a List of rows in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arse> findAll(Arse arse, Pagination pagination);

	/**
	 * Counts rows in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return Long
	 */
	Long findAllCount(Arse arse);

	/**
	 * Finds rows in the Arse table using like.
	 * 
	 * @param arse
	 *            Arse
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arse> findAllLike(Arse arse, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Arse table using like.
	 * 
	 * @param arse
	 *            Arse
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arse arse, Boolean startsWith);

	/**
	 * Deletes a single row in the Arse table.
	 * 
	 * @param arse
	 *            Arse
	 * @return
	 */
	void remove(Arse arse);

	/**
	 * Deletes multiple rows in the Arse table.
	 * 
	 * @param arseList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Arse> arseList);

}
