package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbbandejaDao;
import com.ejie.y41b.dao.ArbcolegioDao;
import com.ejie.y41b.dao.ArbdoctempDao;
import com.ejie.y41b.dao.ArbenvioDao;
import com.ejie.y41b.dao.ArbexpDao;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.dao.BandejaFirmaDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.EmpperDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.dao.TipsubsanaDao;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

import com.ejie.y41b.model.Arbbandeja;
import com.ejie.y41b.model.Arbcolegio;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbenvio;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.Empper;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Tipsubsana;
import com.ejie.y41b.model.TramiteARB2Audiencia;
import com.ejie.y41b.model.TramiteARBAceptacionArbitraje;
import com.ejie.y41b.model.TramiteARBAclaracion;
import com.ejie.y41b.model.TramiteARBAnalisisEmpresa;
import com.ejie.y41b.model.TramiteARBAsignacionResponsable;
import com.ejie.y41b.model.TramiteARBAudiencia;
import com.ejie.y41b.model.TramiteARBCitacion2Audiencia;
import com.ejie.y41b.model.TramiteARBCitacionAPrueba;
import com.ejie.y41b.model.TramiteARBCitacionAudiencia;
import com.ejie.y41b.model.TramiteARBConvenioArbitral;
import com.ejie.y41b.model.TramiteARBDesignacionColegio;
import com.ejie.y41b.model.TramiteARBPagoPericial;
import com.ejie.y41b.model.TramiteARBRecepcionInformePericial;
import com.ejie.y41b.model.TramiteARBRecepcionSubsanacion;
import com.ejie.y41b.model.TramiteARBResultadoAnalisisAdherida;
import com.ejie.y41b.model.TramiteARBResultadoAnalisisAdheridaLim;
import com.ejie.y41b.model.TramiteARBResultadoAnalisisNoAdherida;
import com.ejie.y41b.model.TramiteARBResultadoAnalisisNoAdheridaContrato;
import com.ejie.y41b.model.TramiteARBSubsanacion;
import com.ejie.y41b.model.TramiteARBSuspensionAudiencia;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.platea.SolicitudPresencial;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.modulos.Y41bModuloUtils;

/**
 * ArbtramexpServiceImpl  
 * 
 *  
 */

@Service(value = "arbtramexpService")
public class ArbtramexpServiceImpl implements ArbtramexpService {

	private static final Logger logger = LoggerFactory.getLogger(ArbtramexpServiceImpl.class);

	@Autowired()
	private ArbtramexpDao arbtramexpDao;
	@Autowired()
	private CensoMonitorDao censoMonitorDao;
	@Autowired()
	private SolarbDao solarbDao;
	@Autowired()
	private ArbintervDao arbintervDao;
	@Autowired()
	private ArbdoctempDao arbdoctempDao;
	@Autowired()
	private ParametrosDao parametrosDao;
	@Autowired()
	private BandejaFirmaDao bandejaFirmaDao;
	@Autowired()
	private Arbtramexp2Service arbtramexp2Service;
	@Autowired()
	private TipsubsanaDao tipsubsanaDao;
	@Autowired()
	private ArbcolegioDao arbcolegioDao;
	@Autowired()
	private ArbitroService arbitroService;
	@Autowired()
	private Arbtramexp4Service arbtramexp4Service;
	@Autowired()
	private EmpperDao empperDao;
	@Autowired()
	private ArbbandejaDao arbbandejaDao;
	@Autowired()
	private ArbenvioDao arbenvioDao;
	@Autowired()
	private Arbtramexp3Service arbtramexp3Service;
	@Autowired()
	private ArbexpDao arbexpDao;
	@Autowired()
	private ArbexpService arbexpService;
	@Autowired()
	private IntervinientesTramiteService intervinientesTramiteService;
	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp add(Arbtramexp arbtramexp) {
		return this.arbtramexpDao.add(arbtramexp);
	}

	/**
	 * Updates a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp update(Arbtramexp arbtramexp) {
		return this.arbtramexpDao.update(arbtramexp);
	}

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	public Arbtramexp find(Arbtramexp arbtramexp) {
		return (Arbtramexp) this.arbtramexpDao.find(arbtramexp);
	}

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	public Arbtramexp dameUltimaAudiencia(Arbtramexp arbtramexp) {
		return (Arbtramexp) this.arbtramexpDao.dameUltimaAudiencia(arbtramexp);
	}

	/**
	 * Finds a List of rows in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param pagination
	 *            Pagination
	 * @return List<Arbtramexp>
	 */
	public List<Arbtramexp> findAll(Arbtramexp arbtramexp, Pagination pagination) {
		if (pagination != null) {
			if ("trestado".equals(pagination.getSort())) {
				pagination.setSort("TRESTADO");
			} else if ("censoMonitorEj.monombre".equals(pagination.getSort())) {
				pagination.setSort("MONOMBRE");
			} else if ("trfecfin".equals(pagination.getSort())) {
				pagination.setSort("TRFECFIN");
			} else if ("trfecini".equals(pagination.getSort())) {
				if ("desc".equalsIgnoreCase(pagination.getSord())) {
					pagination.setSort("TRFECINI DESC, TRID");
				} else {
					pagination.setSort("TRFECINI ASC, TRID");
				}
			} else if ("trcodigo".equals(pagination.getSort())) {
				if ("desc".equalsIgnoreCase(pagination.getSord())) {
					pagination.setSort("TRFECINI DESC, TRID");
				} else {
					pagination.setSort("TRFECINI ASC, TRID");
				}
			} else if ("trnomtramCompletoes".equals(pagination.getSort())) {
				pagination.setSort("TRNOMBRE");
			} else if ("trnomtramCompletoeu".equals(pagination.getSort())) {
				pagination.setSort("TRNOMBREE");
			} else if ("fase.fnombre".equals(pagination.getSort())) {
				pagination.setSort("FNOMBRE");
			} else if ("fase.fnombree".equals(pagination.getSort())) {
				pagination.setSort("FNOMBREE");
			} else if ("trid".equals(pagination.getSort())) {
				pagination.setSort("TRID");
			}
		}

		List<Arbtramexp> listTramiteHechoDetalle = (List<Arbtramexp>) this.arbtramexpDao.findAll(arbtramexp,
				pagination);
		if (listTramiteHechoDetalle != null && listTramiteHechoDetalle.size() > 0) {

			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setSolarb(arbtramexp.getSolarb());
			List<Arbinterv> listArbinterv = (List<Arbinterv>) this.arbintervDao.findAll(arbinterv, null);

			TramiteComun tramiteComun = new TramiteComun();
			for (Arbtramexp tramiteHechoDetalle2 : listTramiteHechoDetalle) {
				// buscar los documentos del tramite
				tramiteComun.setIdTramite(tramiteHechoDetalle2.getTrid().toString());
				List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
				// si tiene un solo documento uno meterlo en el objeto
				if (listDocumentoHecho != null && listDocumentoHecho.size() == 1) {
					tramiteHechoDetalle2.setIndVariosDocumentos(Y41bConstantes.NO);

					tramiteHechoDetalle2.setX5codocumento(listDocumentoHecho.get(0).getX5codocumento());
					tramiteHechoDetalle2.setX5nofile(listDocumentoHecho.get(0).getX5nofile());
					tramiteHechoDetalle2.setX5sizefile(listDocumentoHecho.get(0).getX5sizefile());
					tramiteHechoDetalle2.setX5contenttypefile(listDocumentoHecho.get(0).getX5conttype());
					tramiteHechoDetalle2.setX5tedesfile(listDocumentoHecho.get(0).getX5tedesfile());
					tramiteHechoDetalle2.setX5origen(listDocumentoHecho.get(0).getX5origen());
				} else {
					if (listDocumentoHecho != null && listDocumentoHecho.size() > 1) {
						// si tiene mas de un documento
						tramiteHechoDetalle2.setIndVariosDocumentos(Y41bConstantes.SI);
					}

				}

				/* esta pendiente de localizador */
				int minutos = 0;
				Parametros parametros = new Parametros();

				parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
				parametros = this.parametrosDao.find(parametros);
				if (parametros != null && parametros.getValor() != null && Y41bUtils.isNumeric(parametros.getValor())) {
					minutos = Integer.parseInt(parametros.getValor());
				}

				if (listDocumentoHecho != null) {
					boolean error = false;
					boolean sinLocalizarPorTiempo = false;
					boolean localizado = false;
					boolean firmado = false;
					String origenDestino = "";
					for (Arbdoctemp arbdoctemp : listDocumentoHecho) {
						// Para el origen de la aportacion
						if (Y41bConstantes.TRAMITE_ARBITRAJE_APORTACIONDOCUMENTACION
								.equals(tramiteHechoDetalle2.getTrcodigo())) {
							if (!Y41bUtils.esNullOCadenaVacia(arbdoctemp.getX5origen())
									&& (Y41bUtils.esNullOCadenaVacia(origenDestino)
											|| arbdoctemp.getX5origen().equals(origenDestino))) {
								origenDestino = arbdoctemp.getX5origen();
							} else {
								origenDestino = Y41bConstantes.VALOR_NO;
							}
						}
						if (arbdoctemp.getX5fechasollocalizador() != null
								&& !tramiteHechoDetalle2.getTrestado().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)
								&& !tramiteHechoDetalle2.getTrestado()
										.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
								&& !tramiteHechoDetalle2.getTrestado()
										.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {
							if (arbdoctemp != null && arbdoctemp.getX5nofile() != null && !com.ejie.y41b.utils.Y41bUtils
									.getExtensionFile(arbdoctemp.getX5nofile()).equalsIgnoreCase(Y41bConstantes.PDF)) {

								SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
								// EVOLUTIVO 134898 2.4
								// Date d1 = null;
								// Date d2 = null;
								Date d1, d2 = null;
								// EVOLUTIVO 134898 2.4
								long diffMinutes = 0;
								try {
									d1 = format.parse(format.format(arbdoctemp.getX5fechasollocalizador()));

									d2 = format.parse(format.format(new Date()));

									long diff = d2.getTime() - d1.getTime();

									diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
								} catch (ParseException e) {
									diffMinutes = 0;
								}
								if (diffMinutes > minutos) {
									error = true;
								} else {
									sinLocalizarPorTiempo = true;
								}

							} else {
								if (tramiteHechoDetalle2.getTrestado().equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
									firmado = true;
								} else if (!tramiteHechoDetalle2.getTrestado()
										.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)
										&& !tramiteHechoDetalle2.getTrestado()
												.equals(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)
										&& !tramiteHechoDetalle2.getTrestado()
												.equals(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)
										&& !tramiteHechoDetalle2.getTrestado()
												.equals(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)
										&& !tramiteHechoDetalle2.getTrestado()
												.equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
									localizado = true;
								}
							}
						}

					}
					if (error) {
						tramiteHechoDetalle2.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION);
					} else if (sinLocalizarPorTiempo) {
						tramiteHechoDetalle2.setTrestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION);
					} else if (firmado) {
						tramiteHechoDetalle2.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
					} else if (localizado) {
						tramiteHechoDetalle2.setTrestado(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO);
					}
					tramiteHechoDetalle2.setNombreDestOrigen("");
					if (Y41bConstantes.TRAMITE_ARBITRAJE_APORTACIONDOCUMENTACION
							.equals(tramiteHechoDetalle2.getTrcodigo())) {
						tramiteHechoDetalle2.setTipoDestOrigen(origenDestino);
						if (listArbinterv != null) {
							for (Arbinterv arbintervAux : listArbinterv) {
								if ((Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO.equals(origenDestino) && arbintervAux
										.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO))
										|| (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE.equals(origenDestino)
												&& arbintervAux.getUatipointerv()
														.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE))
										|| (Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO
												.equals(origenDestino)
												&& (arbintervAux.getUatipointerv()
														.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO)
														|| arbintervAux.getUatipointerv()
																.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_ANTERIOR)
														|| arbintervAux.getUatipointerv()
																.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO)))
										|| (Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE
												.equals(origenDestino)
												&& (arbintervAux.getUatipointerv()
														.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE)
														|| arbintervAux.getUatipointerv()
																.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_ANTERIOR)
														|| arbintervAux.getUatipointerv().equals(
																Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO)))) {
									tramiteHechoDetalle2.setNombreDestOrigen(arbintervAux.getUanombre() == null ? ""
											: arbintervAux.getUanombre().concat(" ")
													.concat(arbintervAux.getUaapellido1() == null ? ""
															: arbintervAux.getUaapellido1())
													.concat(" ").concat(arbintervAux.getUaapellido2() == null ? ""
															: arbintervAux.getUaapellido2()));
								}
							}
						}
					}

				}
				// Para los tramites de Pub BOPVBOE
				if (tramiteHechoDetalle2.getTrfechaenviobopvboe() != null) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(tramiteHechoDetalle2.getTramite().getTrnombre()).append(" (")
							.append(Y41bUtils.parseDateToString(tramiteHechoDetalle2.getTrfechaenviobopvboe(),
									Y41bConstantes.CASTELLANO))
							.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(tramiteHechoDetalle2.getTramite().getTrnombree()).append(" (").append(Y41bUtils
							.parseDateToString(tramiteHechoDetalle2.getTrfechaenviobopvboe(), Y41bConstantes.EUSKERA))
							.append(")");

					tramiteHechoDetalle2.getTramite().setTrnombre(sbTrnombre.toString());
					tramiteHechoDetalle2.getTramite().setTrnombree(sbTrnombree.toString());
				}
				// Para comunicaciones/notificaciones/recepciones
				BigDecimal interviniente = null;
				if (Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION.equals(tramiteHechoDetalle2.getTrcodigo())
						|| Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION.equals(tramiteHechoDetalle2.getTrcodigo())) {
					interviniente = tramiteHechoDetalle2.getTruaidinterv();
				} else if (tramiteHechoDetalle2.getTrintervorigen() != null) {
					interviniente = tramiteHechoDetalle2.getTrintervorigen();
				}
				if (interviniente != null && listArbinterv != null) {
					for (Arbinterv arbinterv2 : listArbinterv) {
						if (arbinterv2.getUaidinterv().equals(interviniente)) {
							tramiteHechoDetalle2.setTipoDestOrigen(arbinterv2.getUatipointerv());
							tramiteHechoDetalle2.setNombreDestOrigen(arbinterv2.getUanombre() == null ? ""
									: arbinterv2.getUanombre().concat(" ")
											.concat(arbinterv2.getUaapellido1() == null ? ""
													: arbinterv2.getUaapellido1())
											.concat(" ").concat(arbinterv2.getUaapellido2() == null ? ""
													: arbinterv2.getUaapellido2()));
						}
					}
				}

				if (tramiteHechoDetalle2.getTristelematica() != null) {
					StringBuffer sbTrnombre = new StringBuffer();
					sbTrnombre.append(tramiteHechoDetalle2.getTramite().getTrnombre()).append(" (")
							.append(this.appMessageSource.getMessage("comun.telematico", null,
									new Locale(Y41bConstantes.CASTELLANO)))
							.append(")");

					StringBuffer sbTrnombree = new StringBuffer();
					sbTrnombree.append(tramiteHechoDetalle2.getTramite().getTrnombree()).append(" (")
							.append(this.appMessageSource.getMessage("comun.telematico", null,
									new Locale(Y41bConstantes.EUSKERA)))
							.append(")");

					tramiteHechoDetalle2.getTramite().setTrnombre(sbTrnombre.toString());
					tramiteHechoDetalle2.getTramite().setTrnombree(sbTrnombree.toString());
				}

				if (Y41bConstantes.TRAMITE_ARBITRAJE_APORTACIONDOCUMENTACION.equals(tramiteHechoDetalle2.getTrcodigo())
						&& Y41bConstantes.VALOR_SI.equals(tramiteHechoDetalle2.getTrIsSir())
						&& (tramiteHechoDetalle2.getTrIsSirConNumRegEntOri() == null
								|| Y41bConstantes.VALOR_SI.equals(tramiteHechoDetalle2.getTrIsSirConNumRegEntOri()))) {
					StringBuilder sbTrnombre = new StringBuilder();
					sbTrnombre.append(tramiteHechoDetalle2.getTramite().getTrnombre()).append(" (")
							// .append(this.appMessageSource.getMessage(
							// "comun.telematico", null, new Locale(
							// Y41bConstantes.CASTELLANO)))
							.append(this.appMessageSource.getMessage("comun.sir", null,
									new Locale(Y41bConstantes.CASTELLANO)))
							.append(")");

					StringBuilder sbTrnombree = new StringBuilder();
					sbTrnombree.append(tramiteHechoDetalle2.getTramite().getTrnombree()).append(" (")
							// .append(this.appMessageSource.getMessage(
							// "comun.telematico", null, new Locale(
							// Y41bConstantes.EUSKERA)))
							.append(this.appMessageSource.getMessage("comun.sir", null,
									new Locale(Y41bConstantes.EUSKERA)))
							.append(")");

					tramiteHechoDetalle2.getTramite().setTrnombre(sbTrnombre.toString());
					tramiteHechoDetalle2.getTramite().setTrnombree(sbTrnombree.toString());
				}
			}
		}
		return listTramiteHechoDetalle;
	}

	/**
	 * Counts rows in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Long
	 */
	public Long findAllCount(Arbtramexp arbtramexp) {
		return this.arbtramexpDao.findAllCount(arbtramexp);
	}

	/**
	 * Deletes multiple rows in the Arbtramexp table.
	 * 
	 * @param arbtramexpList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbtramexp> arbtramexpList) {
		for (Arbtramexp arbtramexpAux : arbtramexpList) {
			this.arbtramexpDao.remove(arbtramexpAux);
		}
	}

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param sacodigo
	 *            String
	 * @return Arbtramexp
	 */
	public Arbtramexp dameUltimoTramiteEnCurso(String sacodigo) {
		return this.arbtramexpDao.dameUltimoTramiteEnCurso(sacodigo);
	}

	/**
	 * Finds a single row in the ArbTramExp table.
	 * 
	 * @param tramite
	 *            TramiteARBAsignacionResponsable
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteARBAsignacionResponsable
	 */
	public TramiteARBAsignacionResponsable findTramiteAsignacionResponsable(TramiteARBAsignacionResponsable tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBAsignacionResponsable tramiteAux = new TramiteARBAsignacionResponsable();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			tramiteAux.setMonitor(arbtramexp.getTrmonitor());
			tramiteAux.setSiguientestramites(Y41bUtils.clobToString(arbtramexp.getTrsiguientestramites()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Inserts a single row in the Arbtramexp table.
	 * 
	 * @param tramite
	 *            tramite TramiteGenerico
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteAsignacionResponsable(TramiteARBAsignacionResponsable tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoEditar) throws Exception {

		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		solarb.setArbexp(this.arbexpDao.find(solarb.getArbexp()));

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_INICIO_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());

		arbtramexp.setTrmonitor(tramite.getMonitor());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrsiguientestramites(Y41bUtils.stringToClob(tramite.getSiguientestramites()));

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}
		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);

		if (!Y41bConstantes.VALOR_SI.equals(solarb.getArbexp().getPlatea()) && tramitar) {
			Arbinterv reclamanteArb = this.arbintervDao.dameInterviniente(solarb.getSacodigo(),
					Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
			if (reclamanteArb.getUanif() == null || reclamanteArb.getUanif() == "") {
				throw new Y41bUDAException("error.tramiteAsignResp.nonifreclamante", true, new Exception());
			}
			Arbinterv reclamadoArb = this.arbintervDao.dameInterviniente(solarb.getSacodigo(),
					Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
			if (reclamadoArb.getUanif() == null || reclamadoArb.getUanif() == "") {
				throw new Y41bUDAException("error.tramiteAsignResp.nonifreclamado", true, new Exception());
			}
			if (!Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB.equals(solarb.getArbexp().getExformapres())) {
				// abrir expediente en platea
				SolicitudPresencial solicitudPresencial = this.arbtramexp3Service.abrirSolicitudPresencialPlatea(
						reclamanteArb, solarb, tramiteComun, tramite.getInstructorEjecucion(), reclamadoArb);

				// Registar el estado de adhesion del establecimiento
				this.arbexpService.actualizarEstAdhEstablecimiento(tramiteComun.getIdExpediente());

				if (null != solicitudPresencial.getDocumentosAdjuntos()
						&& solicitudPresencial.getDocumentosAdjuntos().size() > 0) {
					for (Documento documentoAux : solicitudPresencial.getDocumentosAdjuntos()) {
						// Actualizo OID Dokusi en tabla documentos hecho
						Arbdoctemp documentoApertura = new Arbdoctemp();
						documentoApertura.setX5codocumento(documentoAux.getIdDocumento());
						documentoApertura.setX5iddocumentum(documentoAux.getOidDokusi());
						// Update oid de documentum
						this.arbdoctempDao.updateOIDDokusi(documentoApertura);
						this.arbdoctempDao.removeBlobFromOIDDokusi(documentoApertura);
					}
				}
			}
			// Hasta ahora, cuando se trataba de una solicitud telematica se
			// retrasaba hasta este momento la apertura del expediente en platea
			// A partir de ahora, la solicitud telemtica se hara al momento sin
			// este retraso.
			// else {
			// this.arbtramexp3Service.abrirSolicitudTelematicaPlatea(solarb,
			// tramiteComun, reclamanteArb, reclamadoArb);
			// }
			solarb.setArbexp(this.arbexpDao.find(solarb.getArbexp()));
			solarb.getArbexp().setPlatea(Y41bConstantes.VALOR_SI);
			this.arbexpDao.update(solarb.getArbexp());
		}
		return arbtramexp;
	}

	/**
	 * Finds a single row in the ArbTramExp table.
	 * 
	 * @param tramite
	 *            tramite TramiteARBSubsanacion
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteARBSubsanacion
	 */
	public TramiteARBSubsanacion findTramiteSubsanacion(TramiteARBSubsanacion tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBSubsanacion tramiteAux = new TramiteARBSubsanacion();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());
			tramiteAux.setNotComReclamante(arbtramexp.getTrnotcomreclamante());
			Tipsubsana tipsubsana = new Tipsubsana();
			tipsubsana.setTipsubsanaByTrid(arbtramexp.getTrid());
			tramiteAux.setlSubsana(this.tipsubsanaDao.findAllPorTramite(tipsubsana, null));

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Inserts a single row in the Arbtramexp table.
	 * 
	 * @param tramite
	 *            tramite TramiteGenerico
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteSubsanacion(TramiteARBSubsanacion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_INICIO_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrnotcomreclamante(tramite.getNotComReclamante());
		arbtramexp.setTrid(tramiteComun.getIdTramite());
		arbtramexp.setTrnotcomreclamante(tramite.getNotComReclamante());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		this.arbtramexpDao.addArbtramtsubs(arbtramexp.getTrid(), tramite.getlSubsana());

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				Arbinterv arbinterv = new Arbinterv();
				arbinterv.setSolarb(solarb);
				arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
				List<Arbinterv> listaIntervientes = this.arbintervDao.findAll(arbinterv, null);
				Arbtramexp arbtramexpNuevo = null;
				if (listaIntervientes != null && listaIntervientes.size() > 0) {
					arbinterv = (Arbinterv) listaIntervientes.get(0);
					// Solo habr un reclamante
					if (Y41bConstantes.NOTIFICACION.equals(tramite.getNotComReclamante())) {
						arbtramexpNuevo = this.arbtramexp2Service.sugiereTramiteNotificacionAutomaticamente(arbtramexp,
								arbinterv);
					} else {
						arbtramexpNuevo = this.arbtramexp2Service.sugiereTramiteComunicacionAutomaticamente(arbtramexp,
								arbinterv);
					}

					// para crear o no el trmite de recepcin de subsanacin
					// primero tenemos que comprobar que no haya uno tramitado.
					// en caso de haber alguno no tramitado no sugerimos trmite
					Arbtramexp recepcionSubsanacion = new Arbtramexp();
					recepcionSubsanacion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION);
					recepcionSubsanacion.setSolarb(new Solarb(solarb.getSacodigo()));
					Pagination pagination = new Pagination();
					pagination.setSidx("TRFECALTA");
					pagination.setSord("DESC");
					List<Arbtramexp> lrecepcionSubsanacion = this.arbtramexpDao.findAll(recepcionSubsanacion,
							pagination);
					boolean hayTramite = false;
					if (lrecepcionSubsanacion != null && lrecepcionSubsanacion.size() > 0) {
						for (int j = 0; j < lrecepcionSubsanacion.size(); j++) {
							recepcionSubsanacion = lrecepcionSubsanacion.get(j);
							if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(recepcionSubsanacion.getTrestado())) {
								hayTramite = true;
								break;
							}
						}
					}
					if (!hayTramite) {

						this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexpNuevo,
								Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION,
								Y41bConstantes.FASE_INICIO_ARBITRAJE, true);
					}

				}

				Arbbandeja aviso = new Arbbandeja();
				aviso.setSolarb(new Solarb(solarb.getSacodigo()));
				aviso.setAbtipo(Y41bConstantes.TIPO_AVISO_ARBITRAJE_ADMISION);
				List<Arbbandeja> lavisos = arbbandejaDao.findAll(aviso, null);
				if (lavisos != null) {
					for (int i = 0; i < lavisos.size(); i++) {
						this.arbbandejaDao.remove(lavisos.get(i));
					}
				}

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @return Long
	 */
	public Long getNewPK() {
		return this.arbtramexpDao.getNewPK();
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBRecepcionSubsanacion
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteRecepcionSubsanacion(TramiteARBRecepcionSubsanacion tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBRecepcionSubsanacion) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_INICIO_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrfecrecepcion(tramite.getFechaRecepcion());
		arbtramexp.setTrrespsubsana(tramite.getRespuesta());
		arbtramexp.setTrresumen(Y41bUtils.stringToClob(tramite.getResumen()));
		arbtramexp.setTrintervorigen(tramite.getIntervOrigen());
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				if (!Y41bConstantes.VALOR_RESPUESTA_NOSUBSANA.equals(tramite.getRespuesta())) {
					// Debe haber al menos un documento
					if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
						// Validacion: Debe haber almenos 1 documento
						throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
					}
				}
				if (Y41bConstantes.VALOR_RESPUESTA_SUBSANA.equals(tramite.getRespuesta())) {
					Arbbandeja aviso = new Arbbandeja();
					aviso.setSolarb(new Solarb(solarb.getSacodigo()));
					aviso.setAbtipo(Y41bConstantes.TIPO_AVISO_ARBITRAJE_REQ_SUBSANACION);
					List<Arbbandeja> lavisos = this.arbbandejaDao.findAll(aviso, null);
					if (lavisos != null) {
						for (int i = 0; i < lavisos.size(); i++) {
							this.arbbandejaDao.remove(lavisos.get(i));
						}
					}
				}
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}
		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteARBRecepcionSubsanacion findTramiteRecepcionSubsanacion(TramiteARBRecepcionSubsanacion tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBRecepcionSubsanacion tramiteAux = new TramiteARBRecepcionSubsanacion();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());
			tramiteAux.setRespuesta(arbtramexp.getTrrespsubsana());
			tramiteAux.setFechaRecepcion(arbtramexp.getTrfecrecepcion());
			tramiteAux.setIntervOrigen(arbtramexp.getTrintervorigen());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));
			tramiteAux.setResumen(Y41bUtils.clobToString(arbtramexp.getTrresumen()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBAnalisisEmpresa
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteAnalisisEmpresa(TramiteARBAnalisisEmpresa tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBAnalisisEmpresa) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_ANALISIS_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTranalisis(tramite.getAnalisis());
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				// Dependiente del analisis
				if (Y41bConstantes.RESULTADO_ANALISIS_EMPRESA_A.equals(tramite.getAnalisis())) {
					this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
							Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_ADHERIDA,
							Y41bConstantes.FASE_ANALISIS_ARBITRAJE, false);
				} else if (Y41bConstantes.RESULTADO_ANALISIS_EMPRESA_B.equals(tramite.getAnalisis())) {
					this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
							Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_ADHERIDA_LIM,
							Y41bConstantes.FASE_ANALISIS_ARBITRAJE, false);
				} else if (Y41bConstantes.RESULTADO_ANALISIS_EMPRESA_C.equals(tramite.getAnalisis())) {
					this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
							Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_NO_ADHERIDA_CONTRATO,
							Y41bConstantes.FASE_ANALISIS_ARBITRAJE, false);
				} else if (Y41bConstantes.RESULTADO_ANALISIS_EMPRESA_D.equals(tramite.getAnalisis())) {
					this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
							Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_NO_ADHERIDA,
							Y41bConstantes.FASE_ANALISIS_ARBITRAJE, false);
				}

				Arbbandeja aviso = new Arbbandeja();
				aviso.setSolarb(new Solarb(solarb.getSacodigo()));
				aviso.setAbtipo(Y41bConstantes.TIPO_AVISO_ARBITRAJE_ADMISION);
				List<Arbbandeja> lavisos = this.arbbandejaDao.findAll(aviso, null);
				if (lavisos != null) {
					for (int i = 0; i < lavisos.size(); i++) {
						this.arbbandejaDao.remove(lavisos.get(i));
					}
				}

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}
		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);

		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBAnalisisEmpresa findTramiteAnalisisEmpresa(TramiteARBAnalisisEmpresa tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBAnalisisEmpresa tramiteAux = new TramiteARBAnalisisEmpresa();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());
			tramiteAux.setAnalisis(arbtramexp.getTranalisis());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBResultadoAnalisisAdherida
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteResultadoAnalisisAdherida(TramiteARBResultadoAnalisisAdherida tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoARBResultadoAnalisisAdherida)
			throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_ANALISIS_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (isDocPendienteFirma) {
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
						Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL, Y41bConstantes.FASE_CONVENIO_ARBITRAJE,
						false);

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBResultadoAnalisisAdherida findTramiteResultadoAnalisisAdherida(
			TramiteARBResultadoAnalisisAdherida tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBResultadoAnalisisAdherida tramiteAux = new TramiteARBResultadoAnalisisAdherida();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBResultadoAnalisisAdheridaLim
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteResultadoAnalisisAdheridaLim(TramiteARBResultadoAnalisisAdheridaLim tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoARBResultadoAnalisisAdheridaLim)
			throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_ANALISIS_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrnotcomreclamante(tramite.getNotComReclamante());
		arbtramexp.setTrnotcomreclamado(tramite.getNotComReclamado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				Arbinterv arbinterv = new Arbinterv();
				arbinterv.setSolarb(solarb);
				arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				List<Arbinterv> listaIntervientes = this.arbintervDao.findAll(arbinterv, null);
				if (listaIntervientes != null) {
					for (int i = 0; i < listaIntervientes.size(); i++) {
						arbinterv = (Arbinterv) listaIntervientes.get(i);
						/*
						 * para cada interviniente sugiero una notificacion o
						 * una comunicacion
						 */
						if (Y41bConstantes.NOTIFICACION.equals(tramite.getNotComReclamado())) {
							this.arbtramexp2Service.sugiereTramiteNotificacionAutomaticamente(arbtramexp, arbinterv);
						} else {
							this.arbtramexp2Service.sugiereTramiteComunicacionAutomaticamente(arbtramexp, arbinterv);
						}
					}
				}
				arbinterv = new Arbinterv();
				arbinterv.setSolarb(solarb);
				arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
				listaIntervientes = this.arbintervDao.findAll(arbinterv, null);
				if (listaIntervientes != null) {
					for (int i = 0; i < listaIntervientes.size(); i++) {
						arbinterv = (Arbinterv) listaIntervientes.get(i);
						/*
						 * para cada interviniente sugiero una notificacion o
						 * una comunicacion
						 */
						if (Y41bConstantes.NOTIFICACION.equals(tramite.getNotComReclamante())) {
							this.arbtramexp2Service.sugiereTramiteNotificacionAutomaticamente(arbtramexp, arbinterv);
						} else {
							this.arbtramexp2Service.sugiereTramiteComunicacionAutomaticamente(arbtramexp, arbinterv);
						}
					}
				}
				this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
						Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE, Y41bConstantes.FASE_ANALISIS_ARBITRAJE,
						false);

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBResultadoAnalisisAdheridaLim findTramiteResultadoAnalisisAdheridaLim(
			TramiteARBResultadoAnalisisAdheridaLim tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBResultadoAnalisisAdheridaLim tramiteAux = new TramiteARBResultadoAnalisisAdheridaLim();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setNotComReclamante(arbtramexp.getTrnotcomreclamante());
			tramiteAux.setNotComReclamado(arbtramexp.getTrnotcomreclamado());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBResultadoAnalisisNoAdherida
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteResultadoAnalisisNoAdherida(TramiteARBResultadoAnalisisNoAdherida tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoARBResultadoAnalisisNoAdherida)
			throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_ANALISIS_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrnotcomreclamante(tramite.getNotComReclamante());
		arbtramexp.setTrnotcomreclamado(tramite.getNotComReclamado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				Arbinterv arbinterv = new Arbinterv();
				arbinterv.setSolarb(solarb);
				arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				List<Arbinterv> listaIntervientes = this.arbintervDao.findAll(arbinterv, null);
				if (listaIntervientes != null) {
					for (int i = 0; i < listaIntervientes.size(); i++) {
						arbinterv = (Arbinterv) listaIntervientes.get(i);
						/*
						 * para cada interviniente sugiero una notificacion o
						 * una comunicacion
						 */
						if (Y41bConstantes.NOTIFICACION.equals(tramite.getNotComReclamado())) {
							this.arbtramexp2Service.sugiereTramiteNotificacionAutomaticamente(arbtramexp, arbinterv);
						} else {
							this.arbtramexp2Service.sugiereTramiteComunicacionAutomaticamente(arbtramexp, arbinterv);
						}
					}
				}
				arbinterv = new Arbinterv();
				arbinterv.setSolarb(solarb);
				arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
				listaIntervientes = this.arbintervDao.findAll(arbinterv, null);
				if (listaIntervientes != null) {
					for (int i = 0; i < listaIntervientes.size(); i++) {
						arbinterv = (Arbinterv) listaIntervientes.get(i);
						/*
						 * para cada interviniente sugiero una notificacion o
						 * una comunicacion
						 */
						if (Y41bConstantes.NOTIFICACION.equals(tramite.getNotComReclamante())) {
							this.arbtramexp2Service.sugiereTramiteNotificacionAutomaticamente(arbtramexp, arbinterv);
						} else {
							this.arbtramexp2Service.sugiereTramiteComunicacionAutomaticamente(arbtramexp, arbinterv);
						}
					}
				}
				this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
						Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE, Y41bConstantes.FASE_ANALISIS_ARBITRAJE,
						false);

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBResultadoAnalisisNoAdherida findTramiteResultadoAnalisisNoAdherida(
			TramiteARBResultadoAnalisisNoAdherida tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBResultadoAnalisisNoAdherida tramiteAux = new TramiteARBResultadoAnalisisNoAdherida();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setNotComReclamante(arbtramexp.getTrnotcomreclamante());
			tramiteAux.setNotComReclamado(arbtramexp.getTrnotcomreclamado());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBResultadoAnalisisNoAdheridaContrato
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteResultadoAnalisisNoAdheridaContrato(
			TramiteARBResultadoAnalisisNoAdheridaContrato tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoARBResultadoAnalisisNoAdheridaContrato) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_ANALISIS_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (isDocPendienteFirma) {
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
						Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL, Y41bConstantes.FASE_CONVENIO_ARBITRAJE,
						false);

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBResultadoAnalisisNoAdheridaContrato findTramiteResultadoAnalisisNoAdheridaContrato(
			TramiteARBResultadoAnalisisNoAdheridaContrato tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBResultadoAnalisisNoAdheridaContrato tramiteAux = new TramiteARBResultadoAnalisisNoAdheridaContrato();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBAceptacionArbitraje
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteAceptacionArbitraje(TramiteARBAceptacionArbitraje tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBAceptacionArbitraje) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_ANALISIS_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrfecrecepcion(tramite.getFechaRecepcion());
		arbtramexp.setTrresparb(tramite.getRespArb());
		arbtramexp.setTrhaycontest(tramite.getHayContest());
		arbtramexp.setTrtipoarbitraje(tramite.getTipoArbitraje());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento si hay contestacion
			if (Y41bConstantes.VALOR_SI.equalsIgnoreCase(tramite.getHayContest())) {
				if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
					// Validacion: Debe haber almenos 1 documento
					throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
				}
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
				// Si se acepta el arbitraje
				if (Y41bConstantes.VALOR_SI.equals(arbtramexp.getTrresparb())) {
					this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
							Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL, Y41bConstantes.FASE_CONVENIO_ARBITRAJE,
							false);
					// EVOLUTIVO 134898 2.4
					// } else {// Si no se acepta el arbitraje
				} else if (Y41bConstantes.VALOR_NO.equals(arbtramexp.getTrresparb())) {// Si
																						// no
																						// se
																						// acepta
																						// el
																						// arbitraje

					// EVOLUTIVO 134898 2.4
					this.arbtramexp2Service.sugiereTramiteDecisionAutomaticamente(arbtramexp,
							Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION, Y41bConstantes.FASE_RESOLUCION_ARBITRAJE,
							Y41bConstantes.DECISION_ARBITRAJE_NOACEPTACION);
				} // EVOLUTIVO 134898 2.4 Si no procede no se autogenera nada

				Arbbandeja aviso = new Arbbandeja();
				aviso.setSolarb(new Solarb(solarb.getSacodigo()));
				aviso.setAbtipo(Y41bConstantes.TIPO_AVISO_ARBITRAJE_ACEPTACION_ARBITRAJE);
				List<Arbbandeja> lavisos = this.arbbandejaDao.findAll(aviso, null);
				if (lavisos != null) {
					for (int i = 0; i < lavisos.size(); i++) {
						this.arbbandejaDao.remove(lavisos.get(i));
					}
				}

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBAceptacionArbitraje findTramiteAceptacionArbitraje(TramiteARBAceptacionArbitraje tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBAceptacionArbitraje tramiteAux = new TramiteARBAceptacionArbitraje();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());
			tramiteAux.setFechaRecepcion(arbtramexp.getTrfecrecepcion());
			tramiteAux.setRespArb(arbtramexp.getTrresparb());
			tramiteAux.setHayContest(arbtramexp.getTrhaycontest());
			tramiteAux.setTipoArbitraje(arbtramexp.getTrtipoarbitraje());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBConvenioArbitral
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteConvenioArbitral(TramiteARBConvenioArbitral tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBConvenioArbitral) throws Exception {

		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_CONVENIO_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

		arbtramexp.setTrnotcomreclamante(tramite.getNotComReclamante());
		arbtramexp.setTrnotcomreclamado(tramite.getNotComReclamado());

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				Arbinterv arbinterv = new Arbinterv();
				arbinterv.setSolarb(solarb);
				arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				List<Arbinterv> listaIntervientes = this.arbintervDao.findAll(arbinterv, null);
				if (listaIntervientes != null) {
					for (int i = 0; i < listaIntervientes.size(); i++) {
						arbinterv = (Arbinterv) listaIntervientes.get(i);
						/*
						 * para cada interviniente sugiero una notificacion o
						 * una comunicacion
						 */
						if (Y41bConstantes.NOTIFICACION.equals(tramite.getNotComReclamado())) {
							this.arbtramexp2Service.sugiereTramiteNotificacionAutomaticamente(arbtramexp, arbinterv);
						} else {
							this.arbtramexp2Service.sugiereTramiteComunicacionAutomaticamente(arbtramexp, arbinterv);
						}
					}
				}
				arbinterv = new Arbinterv();
				arbinterv.setSolarb(solarb);
				arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
				listaIntervientes = this.arbintervDao.findAll(arbinterv, null);
				if (listaIntervientes != null) {
					for (int i = 0; i < listaIntervientes.size(); i++) {
						arbinterv = (Arbinterv) listaIntervientes.get(i);
						/*
						 * para cada interviniente sugiero una notificacion o
						 * una comunicacion
						 */
						if (Y41bConstantes.NOTIFICACION.equals(tramite.getNotComReclamante())) {
							this.arbtramexp2Service.sugiereTramiteNotificacionAutomaticamente(arbtramexp, arbinterv);
						} else {
							this.arbtramexp2Service.sugiereTramiteComunicacionAutomaticamente(arbtramexp, arbinterv);
						}
					}
				}
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBConvenioArbitral findTramiteConvenioArbitral(TramiteARBConvenioArbitral tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBConvenioArbitral tramiteAux = new TramiteARBConvenioArbitral();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setNotComReclamado(arbtramexp.getTrnotcomreclamado());
			tramiteAux.setNotComReclamante(arbtramexp.getTrnotcomreclamante());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBDesignacionColegio
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteDesignacionColegio(TramiteARBDesignacionColegio tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBDesignacionColegio) throws Exception {

		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_COLEGIO_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

		arbtramexp.setTrintica(tramite.getIntica());
		arbtramexp.setTrtipoaudiencia(tramite.getTipoAudiencia());
		arbtramexp.setTrfecdesigna(tramite.getFecDesigna());

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// Borramos el colegio existente
		Arbcolegio arbcolegio = new Arbcolegio();
		arbcolegio.setXjtrid(arbtramexp.getTrid());
		arbcolegio = this.arbcolegioDao.find(arbcolegio);
		if (arbcolegio != null) {
			// ArrayList<String> codigos = new ArrayList<String>();
			// codigos.add(arbcolegio.getConsumidorT().getArcodigo());
			// codigos.add(arbcolegio.getConsumidorS().getArcodigo());
			// codigos.add(arbcolegio.getEmpresarialT().getArcodigo());
			// codigos.add(arbcolegio.getEmpresarialS().getArcodigo());
			// codigos.add(arbcolegio.getPresidenteT().getArcodigo());
			// codigos.add(arbcolegio.getPresidenteS().getArcodigo());
			// // Borramos los arbitros aadidos como intervinientes
			// for (int j = 0; j < codigos.size(); j++) {
			// Arbinterv arbinterv = new Arbinterv();
			// arbinterv.setUaentidadId(codigos.get(j));
			// arbinterv
			// .setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO);
			// arbinterv.setUaexcodigo(arbtramexp.getSolarb().getArbexp()
			// .getExcodigo());
			// List<Arbinterv> larbinterv = this.arbintervDao.findAll(
			// arbinterv, null);
			// if (larbinterv != null) {
			// for (int i = 0; i < larbinterv.size(); i++) {
			// if (larbinterv.get(i) != null
			// && ((Arbinterv) larbinterv.get(i))
			// .getUaidinterv() != null) {
			// // Existe algun tramite con ese
			// // interviniente
			// Arbtramexp tramiteExp = new Arbtramexp();
			// tramiteExp.setSolarb(arbtramexp.getSolarb());
			// tramiteExp.setArbinterv(larbinterv.get(i));
			// Long numTramites = this.arbtramexpDao
			// .findAllCount(tramiteExp);
			// if (numTramites.longValue() == 0L) {
			// // Existe algun envio
			// Arbenvio arbenvio = new Arbenvio();
			// arbenvio.setSolarb(arbtramexp.getSolarb());
			// arbenvio.setArbinterv((Arbinterv) larbinterv
			// .get(i));
			// Long numEnvios = this.arbenvioDao
			// .findAllCount(arbenvio);
			// if (numEnvios.longValue() == 0L) {
			// this.arbintervDao.remove(larbinterv.get(i));
			// }
			// }
			// }
			// }
			// }
			// }
			this.arbcolegioDao.remove(arbcolegio);
		}
		if (tramite.getIntica() != null && tramite.getIntica().equals("1")) {
			arbcolegio = new Arbcolegio(arbtramexp.getTrid(), tramite.getArPresidenteT(), tramite.getArPresidenteS(),
					null, null, null, null, tramite.getSecretarioT(), tramite.getSecretarioS(), null, null, null, null);

			// Inicialmente el presidente titular se marca como activo
			arbcolegio.setXjactivop(Y41bConstantes.VALOR_SI);
			this.arbcolegioDao.add(arbcolegio);
		} else {
			arbcolegio = new Arbcolegio(arbtramexp.getTrid(), tramite.getArPresidenteT(), tramite.getArPresidenteS(),
					tramite.getArReclamanteT(), tramite.getArReclamanteS(), tramite.getArReclamadoT(),
					tramite.getArReclamadoS(), tramite.getSecretarioT(), tramite.getSecretarioS(), null, null, null,
					null);

			// Inicialmente los titulares se marcan como activos
			arbcolegio.setXjactivop(Y41bConstantes.VALOR_SI);
			arbcolegio.setXjactivoaacc(Y41bConstantes.VALOR_SI);
			arbcolegio.setXjactivoooee(Y41bConstantes.VALOR_SI);
			this.arbcolegioDao.add(arbcolegio);
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
						Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA, Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE,
						false);

				// Borrar los arbitros existentes que se puedan borrar
				// Sin mirar si estan o no en el nuevo colegio porque
				// se van a crear luego los del colegio actual
				// Borramos los arbitros aadidos como intervinientes
				Arbinterv arbinterv = new Arbinterv();
				arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO);
				arbinterv.setUaexcodigo(arbtramexp.getSolarb().getArbexp().getExcodigo());
				List<Arbinterv> larbinterv = this.arbintervDao.findAll(arbinterv, null);
				if (larbinterv != null) {
					for (int i = 0; i < larbinterv.size(); i++) {
						if (larbinterv.get(i) != null && ((Arbinterv) larbinterv.get(i)).getUaidinterv() != null) {
							// Existe algun tramite con ese
							// interviniente
							Arbtramexp tramiteExp = new Arbtramexp();
							tramiteExp.setSolarb(arbtramexp.getSolarb());
							tramiteExp.setArbinterv(larbinterv.get(i));
							Long numTramites = this.arbtramexpDao.findAllCount(tramiteExp);
							if (numTramites.longValue() == 0L) {
								// Existe algun envio
								Arbenvio arbenvio = new Arbenvio();
								arbenvio.setSolarb(arbtramexp.getSolarb());
								arbenvio.setArbinterv((Arbinterv) larbinterv.get(i));
								Long numEnvios = this.arbenvioDao.findAllCount(arbenvio);
								if (numEnvios.longValue() == 0L) {
									this.arbintervDao.remove(larbinterv.get(i));
								}
							}
						}
					}
				}

				// Aniadir el presidente
				if (arbcolegio.getXjarcodigop() != null) {
					this.aniadirIntervinientesColegio(tramiteComun.getIdExpediente(), arbcolegio.getXjarcodigop());
				}

				// Aniadir el presidente suplente
				if (arbcolegio.getXjarcodigopsup() != null) {
					this.aniadirIntervinientesColegio(tramiteComun.getIdExpediente(), arbcolegio.getXjarcodigopsup());
				}

				// Aniadir el arbitro consumidores AACC
				if (arbcolegio.getXjarcodigoaacc() != null) {
					this.aniadirIntervinientesColegio(tramiteComun.getIdExpediente(), arbcolegio.getXjarcodigoaacc());
				}

				// Aniadir el arbitro consumidores AACC suplente
				if (arbcolegio.getXjarcodigoaaccsup() != null) {
					this.aniadirIntervinientesColegio(tramiteComun.getIdExpediente(),
							arbcolegio.getXjarcodigoaaccsup());
				}

				// Aniadir el arbitro empresarial OOEE
				if (arbcolegio.getXjarcodigoooee() != null) {
					this.aniadirIntervinientesColegio(tramiteComun.getIdExpediente(), arbcolegio.getXjarcodigoooee());
				}

				// Aniadir el arbitro empresarial OOEE suplente
				if (arbcolegio.getXjarcodigoooeesup() != null) {
					this.aniadirIntervinientesColegio(tramiteComun.getIdExpediente(),
							arbcolegio.getXjarcodigoooeesup());
				}

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBDesignacionColegio findTramiteDesignacionColegio(TramiteARBDesignacionColegio tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBDesignacionColegio tramiteAux = new TramiteARBDesignacionColegio();
			tramiteAux.setIdExpediente(arbtramexp.getSolarb().getSacodigo());
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setFecDesigna(arbtramexp.getTrfecdesigna());
			tramiteAux.setIntica(arbtramexp.getTrintica());
			tramiteAux.setTipoAudiencia(arbtramexp.getTrtipoaudiencia());
			Arbcolegio arbcolegio = new Arbcolegio();
			arbcolegio.setXjtrid(tramite.getIdTramite());
			arbcolegio = this.arbcolegioDao.find(arbcolegio);
			tramiteAux.setArPresidenteT(arbcolegio.getPresidenteT().getArcodigo());
			tramiteAux.setArPresidenteTNombre(arbcolegio.getPresidenteT().getArnombre());
			tramiteAux.setArPresidenteS(arbcolegio.getPresidenteS().getArcodigo());
			tramiteAux.setArPresidenteSNombre(arbcolegio.getPresidenteS().getArnombre());
			tramiteAux.setArReclamanteT(arbcolegio.getConsumidorT().getArcodigo());
			tramiteAux.setArReclamanteTNombre(arbcolegio.getConsumidorT().getArnombre());
			tramiteAux.setArReclamanteS(arbcolegio.getConsumidorS().getArcodigo());
			tramiteAux.setArReclamanteSNombre(arbcolegio.getConsumidorS().getArnombre());
			tramiteAux.setArReclamadoT(arbcolegio.getEmpresarialT().getArcodigo());
			tramiteAux.setArReclamadoTNombre(arbcolegio.getEmpresarialT().getArnombre());
			tramiteAux.setArReclamadoS(arbcolegio.getEmpresarialS().getArcodigo());
			tramiteAux.setArReclamadoSNombre(arbcolegio.getEmpresarialS().getArnombre());
			tramiteAux.setSecretarioT(arbcolegio.getSecretarioT().getSrcodigo());
			tramiteAux.setSecretarioTNombre(arbcolegio.getSecretarioT().getSrnombre());
			tramiteAux.setSecretarioS(arbcolegio.getSecretarioS().getSrcodigo());
			tramiteAux.setSecretarioSNombre(arbcolegio.getSecretarioS().getSrnombre());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBCitacionAudiencia
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteCitacionAudiencia(TramiteARBCitacionAudiencia tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBCitacionAudiencia) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrnotcomreclamado(tramite.getNotComReclamado());
		arbtramexp.setTrnotcomreclamante(tramite.getNotComReclamante());
		arbtramexp.setTrfeccitacion(tramite.getFecCitacion());
		arbtramexp.setTrhoracitacion(tramite.getHoraCitacion());
		arbtramexp.setTrclugaud(tramite.getLugarAudiencia());
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);

				this.sugiereTramiteComunicacionArbitros(arbtramexp, solarb);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBCitacionAudiencia findTramiteCitacionAudiencia(TramiteARBCitacionAudiencia tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBCitacionAudiencia tramiteAux = new TramiteARBCitacionAudiencia();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setNotComReclamado(arbtramexp.getTrnotcomreclamado());
			tramiteAux.setNotComReclamante(arbtramexp.getTrnotcomreclamante());
			tramiteAux.setFecCitacion(arbtramexp.getTrfeccitacion());
			tramiteAux.setHoraCitacion(arbtramexp.getTrhoracitacion());
			tramiteAux.setLugarAudiencia(arbtramexp.getTrclugaud());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            TramiteARBCitacionAudiencia
	 * @param tramite2
	 *            TramiteARBCitacion2Audiencia
	 * @param primera
	 *            boolean
	 */
	public void actualizaTramiteCitacionAudiencia(TramiteARBCitacionAudiencia tramite,
			TramiteARBCitacion2Audiencia tramite2, boolean primera) {
		Arbtramexp arbtramexp = new Arbtramexp();
		String trid = primera ? tramite.getIdTramite() : tramite2.getIdTramite();
		arbtramexp.setTrid(trid);
		arbtramexp = this.arbtramexpDao.find(arbtramexp);

		if (arbtramexp != null) {
			if (primera) {
				arbtramexp.setTrfeccitacion(tramite.getFecCitacion());
				arbtramexp.setTrhoracitacion(tramite.getHoraCitacion());
			} else {
				arbtramexp.setTrfeccitacion(tramite2.getFecCitacion());
				arbtramexp.setTrhoracitacion(tramite2.getHoraCitacion());
			}
			arbtramexp = this.arbtramexpDao.update(arbtramexp);
		}
		this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBSuspensionAudiencia
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteSuspensionAudiencia(TramiteARBSuspensionAudiencia tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBSuspensionAudiencia) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		Arbtramexp citacion = new Arbtramexp();
		citacion.setSolarb(solarb);
		citacion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA);
		citacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		List<Arbtramexp> citaciones = this.arbtramexpDao.findAll(citacion, null);

		if (citaciones != null && citaciones.size() > 0) {
			arbtramexp.setTrtridrel(citaciones.get(0).getTrid());
		}

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

		arbtramexp.setTrnotcomreclamado(tramite.getNotComReclamado());
		arbtramexp.setTrnotcomreclamante(tramite.getNotComReclamante());
		arbtramexp.setTrfecsuspension(tramite.getFecSuspension());
		arbtramexp.setTrmotivo(tramite.getMotivo());

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);

				this.sugiereTramiteComunicacionArbitros(arbtramexp, solarb);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBSuspensionAudiencia findTramiteSuspensionAudiencia(TramiteARBSuspensionAudiencia tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBSuspensionAudiencia tramiteAux = new TramiteARBSuspensionAudiencia();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setNotComReclamante(arbtramexp.getTrnotcomreclamante());
			tramiteAux.setNotComReclamado(arbtramexp.getTrnotcomreclamado());
			tramiteAux.setMotivo(arbtramexp.getTrmotivo());
			tramiteAux.setFecSuspension(arbtramexp.getTrfecsuspension());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBAudiencia
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteAudiencia(TramiteARBAudiencia tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoARBAudiencia) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrfecaudiencia(tramite.getFecha());
		arbtramexp.setTrhoraaudiencia(tramite.getHora());
		arbtramexp.setTriddecision(tramite.getDecision());
		if (tramite.getDecision() != null) {
			if (Y41bConstantes.DECISION_ARB_2AUDIENCIA_PRUEBA.equals(tramite.getDecision().toString())) {
				arbtramexp.setTrsolprueba(Y41bConstantes.SI);
			} else {
				arbtramexp.setTrsolprueba(Y41bConstantes.NO);
			}
		}
		arbtramexp.setTridioma(tramite.getIdioma());
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (isDocPendienteFirma) {
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
				if (tramite.getDecision() != null) {
					if (Y41bConstantes.DECISION_ARB_2AUDIENCIA_PRUEBA.equals(tramite.getDecision().toString())) {
						this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
								Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA,
								Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE, false);
					} else if (Y41bConstantes.DECISION_ARB_2AUDIENCIA.equals(tramite.getDecision().toString())) {
						this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
								Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA,
								Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE, false);
					} else if (Y41bConstantes.DECISION_ARB_LAUDO.equals(tramite.getDecision().toString())) {
						this.arbtramexp2Service.sugiereTramiteDecisionAutomaticamente(arbtramexp,
								Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION, Y41bConstantes.FASE_RESOLUCION_ARBITRAJE,
								Y41bConstantes.DECISION_ARBITRAJE_LAUDO);
					} else {
						this.arbtramexp2Service.sugiereTramiteDecisionAutomaticamente(arbtramexp,
								Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION, Y41bConstantes.FASE_RESOLUCION_ARBITRAJE,
								"");
					}
				}
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}
		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);

		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBAudiencia findTramiteAudiencia(TramiteARBAudiencia tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBAudiencia tramiteAux = new TramiteARBAudiencia();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());
			tramiteAux.setDecision(arbtramexp.getTriddecision());
			tramiteAux.setIdioma(arbtramexp.getTridioma());
			tramiteAux.setFecha(arbtramexp.getTrfecaudiencia());
			tramiteAux.setHora(arbtramexp.getTrhoraaudiencia());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBCitacion2Audiencia
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteCitacion2Audiencia(TramiteARBCitacion2Audiencia tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBCitacion2Audiencia) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrnotcomreclamado(tramite.getNotComReclamado());
		arbtramexp.setTrnotcomreclamante(tramite.getNotComReclamante());
		arbtramexp.setTrfeccitacion(tramite.getFecCitacion());
		arbtramexp.setTrhoracitacion(tramite.getHoraCitacion());
		arbtramexp.setTrclugaud(tramite.getLugarAudiencia());
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);

				this.sugiereTramiteComunicacionArbitros(arbtramexp, solarb);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBCitacion2Audiencia findTramiteCitacion2Audiencia(TramiteARBCitacion2Audiencia tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBCitacion2Audiencia tramiteAux = new TramiteARBCitacion2Audiencia();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setNotComReclamado(arbtramexp.getTrnotcomreclamado());
			tramiteAux.setNotComReclamante(arbtramexp.getTrnotcomreclamante());
			tramiteAux.setFecCitacion(arbtramexp.getTrfeccitacion());
			tramiteAux.setHoraCitacion(arbtramexp.getTrhoracitacion());
			tramiteAux.setLugarAudiencia(arbtramexp.getTrclugaud());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARB2Audiencia
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramite2Audiencia(TramiteARB2Audiencia tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoARB2Audiencia) throws Exception {

		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrfecaudiencia(tramite.getFecha());
		arbtramexp.setTrhoraaudiencia(tramite.getHora());
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (isDocPendienteFirma) {
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				this.arbtramexp2Service.sugiereTramiteDecisionAutomaticamente(arbtramexp,
						Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION, Y41bConstantes.FASE_RESOLUCION_ARBITRAJE,
						Y41bConstantes.DECISION_ARBITRAJE_LAUDO);

				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}
		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);

		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARB2Audiencia findTramite2Audiencia(TramiteARB2Audiencia tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARB2Audiencia tramiteAux = new TramiteARB2Audiencia();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());
			tramiteAux.setFecha(arbtramexp.getTrfecaudiencia());
			tramiteAux.setHora(arbtramexp.getTrhoraaudiencia());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBCitacionAPrueba
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteCitacionAPrueba(TramiteARBCitacionAPrueba tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBCitacionAPrueba) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrrealizadapor(tramite.getRealizadoPor());
		arbtramexp.setTrfeccitacion(tramite.getFecCitacion());
		arbtramexp.setTrhoracitacion(tramite.getHoraCitacion());
		arbtramexp.setTrnoraProvinciaId(tramite.getProvinciaId());
		arbtramexp.setTrnoraMunicipioId(tramite.getMunicipioId());
		arbtramexp.setTrnoraLocalidadId(tramite.getLocalidadId());
		arbtramexp.setTrnoraCpId(tramite.getCpId());
		arbtramexp.setTrnoraCalleId(tramite.getCalleId());
		arbtramexp.setTrnoraPortalId(tramite.getPortalId());
		arbtramexp.setTrnombrePiso(tramite.getNombrePiso());
		arbtramexp.setTrnrtel(tramite.getTelefono());
		arbtramexp.setTrainstanciade(tramite.getAinstanciade());
		arbtramexp.setTrcope1(tramite.getPerito1());
		arbtramexp.setTrcope2(tramite.getPerito2());
		arbtramexp.setTrobjeto(Y41bUtils.stringToClob(tramite.getObjeto()));
		arbtramexp.setTrnotcomreclamado(tramite.getNotComReclamado());
		arbtramexp.setTrnotcomreclamante(tramite.getNotComReclamante());
		arbtramexp.setTrnotcomterceros(tramite.getNotComPeritos());

		solarb.setSaininpr(tramite.getAinstanciade());

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO.equals(tramite.getRealizadoPor())) {
					this.aniadirIntervinientesPerito(tramiteComun.getIdExpediente(), tramite.getPerito1());
					if (!Y41bUtils.esNullOCadenaVacia(tramite.getPerito2())) {
						this.aniadirIntervinientesPerito(tramiteComun.getIdExpediente(), tramite.getPerito2());
					}
					this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO);
				}

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);

				if (!Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO.equals(tramite.getRealizadoPor())) {
					if (Y41bModuloUtils.getInstance().mostrarPagoPericialColegio()) {
						// Borrar los rbitros asignados al trmite
						this.intervinientesTramiteService.borrarArbitros(tramiteComun.getIdTramite());
						// Guardar los nuevos arbitros seleccionados
						if (tramite.getArbitros() != null) {
							String[] larbitros = tramite.getArbitros().split(",");
							if (tramite.getArbitros().length() > 0) {
								this.intervinientesTramiteService.guardarArbitros(tramiteComun.getIdTramite(),
										tramite.getArbitros().split(","));
							}

							// Sugiere trmite de comunicacin para los rbitros
							// seleccionados
							Arbinterv arbinterv = new Arbinterv();
							if (larbitros != null && larbitros.length > 0) {
								for (int i = 0; i < larbitros.length; i++) {
									arbinterv.setUaidinterv(new BigDecimal(larbitros[i]));
									arbinterv = this.arbintervDao.find(arbinterv);
									this.arbtramexp2Service.sugiereTramiteComunicacionAutomaticamente(arbtramexp,
											arbinterv);
								}
							}
						}
					} else {
						this.sugiereTramiteComunicacionArbitros(arbtramexp, solarb);
					}
				}
			}
		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);

			// Borrar los rbitros asignados al trmite
			this.intervinientesTramiteService.borrarArbitros(tramiteComun.getIdTramite());
			// Guardar los nuevos arbitros seleccionados
			if (tramite.getArbitros() != null) {
				if (tramite.getArbitros().length() > 0) {
					this.intervinientesTramiteService.guardarArbitros(tramiteComun.getIdTramite(),
							tramite.getArbitros().split(","));
				}
			}
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBCitacionAPrueba findTramiteCitacionAPrueba(TramiteARBCitacionAPrueba tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBCitacionAPrueba tramiteAux = new TramiteARBCitacionAPrueba();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());
			tramiteAux.setRealizadoPor(arbtramexp.getTrrealizadapor());
			tramiteAux.setFecCitacion(arbtramexp.getTrfeccitacion());
			tramiteAux.setHoraCitacion(arbtramexp.getTrhoracitacion());
			tramiteAux.setProvinciaId(arbtramexp.getTrnoraProvinciaId());
			tramiteAux.setMunicipioId(arbtramexp.getTrnoraMunicipioId());
			tramiteAux.setLocalidadId(arbtramexp.getTrnoraLocalidadId());
			tramiteAux.setCpId(arbtramexp.getTrnoraCpId());
			tramiteAux.setCalleId(arbtramexp.getTrnoraCalleId());
			tramiteAux.setPortalId(arbtramexp.getTrnoraPortalId());
			tramiteAux.setNombrePiso(arbtramexp.getTrnombrePiso());
			tramiteAux.setTelefono(arbtramexp.getTrnrtel());
			tramiteAux.setAinstanciade(arbtramexp.getTrainstanciade());
			tramiteAux.setPerito1(arbtramexp.getTrcope1());
			tramiteAux.setPerito2(arbtramexp.getTrcope2());
			tramiteAux.setNotComReclamado(arbtramexp.getTrnotcomreclamado());
			tramiteAux.setNotComReclamante(arbtramexp.getTrnotcomreclamante());
			tramiteAux.setNotComPeritos(arbtramexp.getTrnotcomterceros());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));
			tramiteAux.setObjeto(Y41bUtils.clobToString(arbtramexp.getTrobjeto()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}

			// Coger los intervinientes del colegio
			tramiteAux.setArbitros(this.intervinientesTramiteService.cogerArbitros(tramiteAux.getIdTramite()));

			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBRecepcionInformePericial
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteRecepcionInformePericial(TramiteARBRecepcionInformePericial tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoARBRecepcionInformePericial)
			throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrfecrecepcion(tramite.getFechaRecepcion());
		arbtramexp.setTrnotcomreclamado(tramite.getNotComReclamado());
		arbtramexp.setTrnotcomreclamante(tramite.getNotComReclamante());

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			} else if (listDocumentoHecho != null) {
				boolean hayDoc = false;
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					if (Y41bConstantes.TIPO_DOC_ARB_INFORME_PERICIAL
							.equals(listDocumentoHecho.get(i).getX5tipodocumento())) {
						hayDoc = true;
						break;
					}
				}
				if (!hayDoc) {
					throw new Y41bUDAException("error.solicitud.documentoRecepcionException", true, new Exception());
				}
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);

				// Arbinterv arbinterv = new Arbinterv();
				// arbinterv.setUaidinterv(null);
				// arbinterv
				// .setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO);
				// this.arbtramexp2Service
				// .sugiereTramiteComunicacionAutomaticamente(arbtramexp,
				// arbinterv);

				if (Y41bModuloUtils.getInstance().mostrarPagoPericialColegio()) {
					// Coger el ultimo tramite de citacion a prueba para saber
					// si ha sido realizado por el colegio o peritos
					Arbtramexp arbtramexpAux = new Arbtramexp();
					arbtramexpAux.setSolarb(solarb);
					arbtramexpAux.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA);
					arbtramexpAux = this.arbtramexpDao
							.findUltimoTramiteTramitadoExpedientePorTipoTramite(arbtramexpAux);
					if (arbtramexpAux != null) {
						if (Y41bConstantes.ARB_PRUEBA_REALIZADOPOR_COLEGIO.equals(arbtramexpAux.getTrrealizadapor())) {
							this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
									Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL_COLEGIO,
									Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE, false);
						}
					}
				}

				arbtramexp.setTrresppagoper(solarb.getSaininpr());
				this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
						Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL, Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE, false);
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);

				this.sugiereTramiteComunicacionArbitros(arbtramexp, solarb);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBRecepcionInformePericial findTramiteRecepcionInformePericial(
			TramiteARBRecepcionInformePericial tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBRecepcionInformePericial tramiteAux = new TramiteARBRecepcionInformePericial();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());
			tramiteAux.setFechaRecepcion(arbtramexp.getTrfecrecepcion());
			tramiteAux.setNotComReclamado(arbtramexp.getTrnotcomreclamado());
			tramiteAux.setNotComReclamante(arbtramexp.getTrnotcomreclamante());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBPagoPericial
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramitePagoPericial(TramiteARBPagoPericial tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoARBPagoPericial) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrcope1(tramite.getPerito());
		arbtramexp.setTrresppagoper(tramite.getResponsable());
		arbtramexp.setTrimporte(Y41bUtils.esNullOCadenaVacia(tramite.getImporte()) ? null
				: new BigDecimal(tramite.getImporte().replace('\u002c', '\u002e')));
		arbtramexp.setTrreffactura(tramite.getRefFactura());
		arbtramexp.setTrfecemision(tramite.getFechaEmision());
		arbtramexp.setTrnotcomreclamado(tramite.getNotComReclamado());
		arbtramexp.setTrnotcomreclamante(tramite.getNotComReclamante());

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				if (Y41bConstantes.TIPO_ARBINSTANCIA_RECLAMADO.equals(tramite.getResponsable())
						|| Y41bConstantes.TIPO_ARBINSTANCIA_AMBOS.equals(tramite.getResponsable())) {
					this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				}
				if (Y41bConstantes.TIPO_ARBINSTANCIA_RECLAMANTE.equals(tramite.getResponsable())
						|| Y41bConstantes.TIPO_ARBINSTANCIA_AMBOS.equals(tramite.getResponsable())) {
					this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
				}

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBPagoPericial findTramitePagoPericial(TramiteARBPagoPericial tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBPagoPericial tramiteAux = new TramiteARBPagoPericial();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setPerito(arbtramexp.getTrcope1());
			tramiteAux.setResponsable(arbtramexp.getTrresppagoper());
			tramiteAux.setImporte(arbtramexp.getTrimporte() == null ? ""
					: Y41bUtils.formatDouble2decimalesYcoma(arbtramexp.getTrimporte().doubleValue()));
			tramiteAux.setRefFactura(arbtramexp.getTrreffactura());
			tramiteAux.setFechaEmision(arbtramexp.getTrfecemision());
			tramiteAux.setNotComReclamado(arbtramexp.getTrnotcomreclamado());
			tramiteAux.setNotComReclamante(arbtramexp.getTrnotcomreclamante());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * aniadirIntervinientesColegio
	 * 
	 * @param sacodigo
	 *            String
	 * @param arcodigo
	 *            String
	 */
	private void aniadirIntervinientesColegio(String sacodigo, String arcodigo) {
		Arbitro arbitro = new Arbitro();
		arbitro.setArcodigo(arcodigo);
		// llamamos al del service porque necesitamos el volcado que hace de
		// oears y aars
		arbitro = this.arbitroService.find(arbitro);
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUaentidadId(arbitro.getArcodigo());
		arbinterv.setUaexcodigo(sacodigo);
		arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO);
		List<Arbinterv> larbinterv = this.arbintervDao.findAll(arbinterv, null);
		// Cambio arbitros - Independientemente del tipo de arbitro, siempre
		// hay que coger los datos de direccin almacenados en arbitro
		// arbitro = this.arbitroService.tratarDireccionesCentro(arbitro);
		if (larbinterv != null && larbinterv.size() == 0) {
			if (Y41bConstantes.CENSO_ARB_ARBITRO_DIR_CEN.equalsIgnoreCase(arbitro.getArindico())) {
				arbinterv = new Arbinterv(null, arbitro.getArnombre(), arbitro.getArnif(), arbitro.getArnrtelc(),
						arbitro.getArnrtel2c(), arbitro.getArprovcId(), arbitro.getArmuncId(), arbitro.getArloccId(),
						arbitro.getArcallecId(), arbitro.getArnombrecCp(), arbitro.getArportalcId(),
						arbitro.getArnombrecPiso(),
						((!Y41bConstantes.ARABA.equals(arbitro.getArprovcId())
								&& !Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovcId())
								&& !Y41bConstantes.BIZKAIA.equals(arbitro.getArprovcId())) ? arbitro.getArnodirc()
										: null),
						"", Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO, sacodigo, null, null, null, null, null, null,
						null, null, null, null, arbitro.getArteemc(),
						((Y41bConstantes.ARABA.equals(arbitro.getArprovcId())
								|| Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovcId())
								|| Y41bConstantes.BIZKAIA.equals(arbitro.getArprovcId())) ? arbitro.getArnodirc()
										: null),
						null, null, Y41bConstantes.COD_PAIS_ESTADO, arbitro.getArcodigo(), null, null,
						arbitro.getArteurlc(), null, null, null, null, null, null, arbitro.getAridioma(), null, null,
						null);
			} else {
				arbinterv = new Arbinterv(null, arbitro.getArnombre(), arbitro.getArnif(), arbitro.getArnrtel(),
						arbitro.getArnrtel2(), arbitro.getArprovId(), arbitro.getArmunId(), arbitro.getArlocId(),
						arbitro.getArcalleId(), arbitro.getArnombreCp(), arbitro.getArportalId(),
						arbitro.getArnombrePiso(),
						((!Y41bConstantes.ARABA.equals(arbitro.getArprovId())
								&& !Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovId())
								&& !Y41bConstantes.BIZKAIA.equals(arbitro.getArprovId())) ? arbitro.getArnodir()
										: null),
						"", Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO, sacodigo, null, null, null, null, null, null,
						null, null, null, null, arbitro.getArteem(),
						((Y41bConstantes.ARABA.equals(arbitro.getArprovId())
								|| Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovId())
								|| Y41bConstantes.BIZKAIA.equals(arbitro.getArprovId())) ? arbitro.getArnodir() : null),
						null, null, Y41bConstantes.COD_PAIS_ESTADO, arbitro.getArcodigo(), null, null,
						arbitro.getArteurl(), null, null, null, null, null, null, arbitro.getAridioma(), null, null,
						null);
			}
			this.arbintervDao.add(arbinterv);
		} else {
			if (Y41bConstantes.CENSO_ARB_ARBITRO_DIR_CEN.equalsIgnoreCase(arbitro.getArindico())) {
				arbinterv = new Arbinterv(larbinterv.get(0).getUaidinterv(), arbitro.getArnombre(), arbitro.getArnif(),
						arbitro.getArnrtelc(), arbitro.getArnrtel2c(), arbitro.getArprovcId(), arbitro.getArmuncId(),
						arbitro.getArloccId(), arbitro.getArcallecId(), arbitro.getArnombrecCp(),
						arbitro.getArportalcId(), arbitro.getArnombrecPiso(),
						((!Y41bConstantes.ARABA.equals(arbitro.getArprovcId())
								&& !Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovcId())
								&& !Y41bConstantes.BIZKAIA.equals(arbitro.getArprovcId())) ? arbitro.getArnodirc()
										: null),
						"", Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO, sacodigo, null, null, null, null, null, null,
						null, null, null, null, arbitro.getArteemc(),
						((Y41bConstantes.ARABA.equals(arbitro.getArprovcId())
								|| Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovcId())
								|| Y41bConstantes.BIZKAIA.equals(arbitro.getArprovcId())) ? arbitro.getArnodirc()
										: null),
						null, null, Y41bConstantes.COD_PAIS_ESTADO, arbitro.getArcodigo(), null, null,
						arbitro.getArteurlc(), null, null, null, null, null, null, arbitro.getAridioma(), null, null,
						null);
			} else {
				arbinterv = new Arbinterv(larbinterv.get(0).getUaidinterv(), arbitro.getArnombre(), arbitro.getArnif(),
						arbitro.getArnrtel(), arbitro.getArnrtel2(), arbitro.getArprovId(), arbitro.getArmunId(),
						arbitro.getArlocId(), arbitro.getArcalleId(), arbitro.getArnombreCp(), arbitro.getArportalId(),
						arbitro.getArnombrePiso(),
						((!Y41bConstantes.ARABA.equals(arbitro.getArprovId())
								&& !Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovId())
								&& !Y41bConstantes.BIZKAIA.equals(arbitro.getArprovId())) ? arbitro.getArnodir()
										: null),
						"", Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO, sacodigo, null, null, null, null, null, null,
						null, null, null, null, arbitro.getArteem(),
						((Y41bConstantes.ARABA.equals(arbitro.getArprovId())
								|| Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovId())
								|| Y41bConstantes.BIZKAIA.equals(arbitro.getArprovId())) ? arbitro.getArnodir() : null),
						null, null, Y41bConstantes.COD_PAIS_ESTADO, arbitro.getArcodigo(), null, null,
						arbitro.getArteurl(), null, null, null, null, null, null, arbitro.getAridioma(), null, null,
						null);
			}
			this.arbintervDao.update(arbinterv);
		}
	}

	/**
	 * aniadirIntervinientesPerito
	 * 
	 * @param sacodigo
	 *            String
	 * @param pecodigo
	 *            String
	 */
	private void aniadirIntervinientesPerito(String sacodigo, String pecodigo) {
		Empper perito = new Empper();
		perito.setPecodigo(pecodigo);
		perito = this.empperDao.find(perito);
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUaentidadId(perito.getPecodigo());
		arbinterv.setUaexcodigo(sacodigo);
		arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO);
		List<Arbinterv> larbinterv = this.arbintervDao.findAll(arbinterv, null);
		if (larbinterv != null && larbinterv.size() == 0) {
			arbinterv = new Arbinterv(null, perito.getPenombre(), perito.getPecif(), perito.getPenrtel(),
					perito.getPenrtel2(), perito.getPeprovId(), perito.getPemunId(), perito.getPelocId(),
					perito.getPecalleId(), perito.getPenrcopo(), perito.getPeportalId(), perito.getPenombrePiso(),
					(!(Y41bConstantes.ARABA.equals(perito.getPeprovId())
							|| Y41bConstantes.GIPUZKOA.equals(perito.getPeprovId())
							|| Y41bConstantes.BIZKAIA.equals(perito.getPeprovId())) ? null : perito.getPenodir()),
					"", Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO, sacodigo, null, null, null, null, null, null, null,
					null, null, null, perito.getPeteem(),
					((Y41bConstantes.ARABA.equals(perito.getPeprovId())
							|| Y41bConstantes.GIPUZKOA.equals(perito.getPeprovId())
							|| Y41bConstantes.BIZKAIA.equals(perito.getPeprovId())) ? null : perito.getPenodir()),
					null, null, Y41bConstantes.COD_PAIS_ESTADO, perito.getPecodigo(), null, null, perito.getPeteurl(),
					null, null, null, null, null, null, null, null, null, null);
			this.arbintervDao.add(arbinterv);
		} else {
			arbinterv = new Arbinterv(larbinterv.get(0).getUaidinterv(), perito.getPenombre(), perito.getPecif(),
					perito.getPenrtel(), perito.getPenrtel2(), perito.getPeprovId(), perito.getPemunId(),
					perito.getPelocId(), perito.getPecalleId(), perito.getPenrcopo(), perito.getPeportalId(),
					perito.getPenombrePiso(),
					(!(Y41bConstantes.ARABA.equals(perito.getPeprovId())
							|| Y41bConstantes.GIPUZKOA.equals(perito.getPeprovId())
							|| Y41bConstantes.BIZKAIA.equals(perito.getPeprovId())) ? perito.getPenodir() : null),
					"", Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO, sacodigo, null, null, null, null, null, null, null,
					null, null, null, perito.getPeteem(),
					((Y41bConstantes.ARABA.equals(perito.getPeprovId())
							|| Y41bConstantes.GIPUZKOA.equals(perito.getPeprovId())
							|| Y41bConstantes.BIZKAIA.equals(perito.getPeprovId())) ? perito.getPenodir() : null),
					null, null, Y41bConstantes.COD_PAIS_ESTADO, perito.getPecodigo(), null, null, perito.getPeteurl(),
					null, null, null, null, null, null, null, null, null, null);
			this.arbintervDao.update(arbinterv);
		}
	}

	/**
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param solarb
	 *            Solarb
	 * @throws Exception
	 *             Exception
	 */
	public void sugiereTramiteComunicacionArbitros(Arbtramexp arbtramexp, Solarb solarb) throws Exception {
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setSolarb(solarb);
		arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO);
		arbinterv.setActivos(Y41bConstantes.VALOR_SI);
		List<Arbinterv> larbitros = this.arbintervDao.findAll(arbinterv, null);
		// Se manda la comunicacion a todos los activos ( ya no hay que mirar
		// cuales son titulares)
		if (larbitros != null && larbitros.size() > 0) {
			/*
			 * Arbcolegio arbcolegio = new Arbcolegio(); Arbtramexp
			 * designacionColegio = new Arbtramexp();
			 * designacionColegio.setSolarb(solarb); designacionColegio
			 * .setTrcodigo
			 * (Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			 * Pagination pagination = new Pagination();
			 * pagination.setSidx("TRID"); pagination.setSord("DESC");
			 * List<Arbtramexp> ldesignacionColegio = arbtramexpDao.findAll(
			 * designacionColegio, pagination); if (ldesignacionColegio != null
			 * && ldesignacionColegio.size() > 0) { designacionColegio =
			 * ldesignacionColegio.get(0);
			 * arbcolegio.setXjtrid(designacionColegio.getTrid()); arbcolegio =
			 * this.arbcolegioDao.find(arbcolegio); if (arbcolegio != null) {
			 */
			for (int i = 0; i < larbitros.size(); i++) {
				/*
				 * if ((arbcolegio.getConsumidorT() != null && larbitros .get(i)
				 * .getUaentidadId() .equals(arbcolegio.getConsumidorT()
				 * .getArcodigo())) || (arbcolegio.getEmpresarialT() != null &&
				 * larbitros .get(i) .getUaentidadId()
				 * .equals(arbcolegio.getEmpresarialT() .getArcodigo())) ||
				 * (arbcolegio.getPresidenteT() != null && larbitros .get(i)
				 * .getUaentidadId() .equals(arbcolegio.getPresidenteT()
				 * .getArcodigo()))) {
				 */
				this.arbtramexp2Service.sugiereTramiteComunicacionAutomaticamente(arbtramexp, larbitros.get(i));
			}
			/*
			 * } } }
			 */
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            censoMonitor
	 * @return tramite
	 */
	public TramiteARBAclaracion findTramiteAclaracion(TramiteARBAclaracion tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramite.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBAclaracion tramiteAux = new TramiteARBAclaracion();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());
			tramiteAux.setFechaRecepcion(arbtramexp.getTrfecrecepcion());
			tramiteAux.setValoracion(arbtramexp.getTrvalorac());
			tramiteAux.setTipo(arbtramexp.getTrtiposolac());
			tramiteAux.setNotComReclamado(arbtramexp.getTrnotcomreclamado());
			tramiteAux.setNotComReclamante(arbtramexp.getTrnotcomreclamante());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));
			tramiteAux.setResumen(Y41bUtils.clobToString(arbtramexp.getTrresumen()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			ArbtramexpServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}
}