package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.TramiteARB2Audiencia;
import com.ejie.y41b.model.TramiteARBAceptacionArbitraje;
import com.ejie.y41b.model.TramiteARBAclaracion;
import com.ejie.y41b.model.TramiteARBAnalisisEmpresa;
import com.ejie.y41b.model.TramiteARBAsignacionResponsable;
import com.ejie.y41b.model.TramiteARBAudiencia;
import com.ejie.y41b.model.TramiteARBCitacion2Audiencia;
import com.ejie.y41b.model.TramiteARBCitacionAPrueba;
import com.ejie.y41b.model.TramiteARBCitacionAudiencia;
import com.ejie.y41b.model.TramiteARBConvenioArbitral;
import com.ejie.y41b.model.TramiteARBDesignacionColegio;
import com.ejie.y41b.model.TramiteARBPagoPericial;
import com.ejie.y41b.model.TramiteARBRecepcionInformePericial;
import com.ejie.y41b.model.TramiteARBRecepcionSubsanacion;
import com.ejie.y41b.model.TramiteARBResultadoAnalisisAdherida;
import com.ejie.y41b.model.TramiteARBResultadoAnalisisAdheridaLim;
import com.ejie.y41b.model.TramiteARBResultadoAnalisisNoAdherida;
import com.ejie.y41b.model.TramiteARBResultadoAnalisisNoAdheridaContrato;
import com.ejie.y41b.model.TramiteARBSubsanacion;
import com.ejie.y41b.model.TramiteARBSuspensionAudiencia;
import com.ejie.y41b.model.TramiteComun;

/**
 * ArbtramexpService  
 * 
 *  
 */

public interface ArbtramexpService {

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp find(Arbtramexp arbtramexp);

	/**
	 * Finds a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp dameUltimaAudiencia(Arbtramexp arbtramexp);

	/**
	 * Finds a List of rows in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbtramexp> findAll(Arbtramexp arbtramexp, Pagination pagination);

	/**
	 * Counts rows in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Long
	 */
	Long findAllCount(Arbtramexp arbtramexp);

	/**
	 * Deletes multiple rows in the Arbtramexp table.
	 * 
	 * @param arbtramexpList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Arbtramexp> arbtramexpList);

	/**
	 * Finds a single row in the Santramexp table.
	 * 
	 * @param sacodigo
	 *            String
	 * @return Santramexp
	 */
	Arbtramexp dameUltimoTramiteEnCurso(String sacodigo);

	/**
	 * Finds a single row in the ArbTramExp table.
	 * 
	 * @param tramite
	 *            tramite TramiteARBAsignacionResponsable
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteARBAsignacionResponsable
	 */
	TramiteARBAsignacionResponsable findTramiteAsignacionResponsable(
			TramiteARBAsignacionResponsable tramite, CensoMonitor monitor);

	/**
	 * @param tramite
	 *            tramite TramiteARBAsignacionResponsable
	 * @param tramiteComun
	 *            tramiteComun TramiteComun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoARBAsignacionResponsable
	 *            String
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteAsignacionResponsable(
			TramiteARBAsignacionResponsable tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBAsignacionResponsable)
			throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBSubsanacion
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteSubsanacion(TramiteARBSubsanacion tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBSubsanacion) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBSubsanacion findTramiteSubsanacion(TramiteARBSubsanacion tramite,
			CensoMonitor censoMonitor);

	/**
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBRecepcionSubsanacion
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteRecepcionSubsanacion(
			TramiteARBRecepcionSubsanacion tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBRecepcionSubsanacion)
			throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBRecepcionSubsanacion findTramiteRecepcionSubsanacion(
			TramiteARBRecepcionSubsanacion tramite, CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBAnalisisEmpresa
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteAnalisisEmpresa(TramiteARBAnalisisEmpresa tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBAnalisisEmpresa) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBAnalisisEmpresa findTramiteAnalisisEmpresa(
			TramiteARBAnalisisEmpresa tramite, CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBResultadoAnalisisAdherida
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteResultadoAnalisisAdherida(
			TramiteARBResultadoAnalisisAdherida tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBResultadoAnalisisAdherida) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBResultadoAnalisisAdherida findTramiteResultadoAnalisisAdherida(
			TramiteARBResultadoAnalisisAdherida tramite,
			CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBResultadoAnalisisAdheridaLim
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteResultadoAnalisisAdheridaLim(
			TramiteARBResultadoAnalisisAdheridaLim tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBResultadoAnalisisAdheridaLim) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBResultadoAnalisisAdheridaLim findTramiteResultadoAnalisisAdheridaLim(
			TramiteARBResultadoAnalisisAdheridaLim tramite,
			CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBResultadoAnalisisNoAdherida
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteResultadoAnalisisNoAdherida(
			TramiteARBResultadoAnalisisNoAdherida tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBResultadoAnalisisNoAdherida) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBResultadoAnalisisNoAdherida findTramiteResultadoAnalisisNoAdherida(
			TramiteARBResultadoAnalisisNoAdherida tramite,
			CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBResultadoAnalisisNoAdheridaContrato
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteResultadoAnalisisNoAdheridaContrato(
			TramiteARBResultadoAnalisisNoAdheridaContrato tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBResultadoAnalisisNoAdheridaContrato) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBResultadoAnalisisNoAdheridaContrato findTramiteResultadoAnalisisNoAdheridaContrato(
			TramiteARBResultadoAnalisisNoAdheridaContrato tramite,
			CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBAceptacionArbitraje
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteAceptacionArbitraje(
			TramiteARBAceptacionArbitraje tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBAceptacionArbitraje)
			throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBAceptacionArbitraje findTramiteAceptacionArbitraje(
			TramiteARBAceptacionArbitraje tramite, CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBConvenioArbitral
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteConvenioArbitral(TramiteARBConvenioArbitral tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBConvenioArbitral) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBConvenioArbitral findTramiteConvenioArbitral(
			TramiteARBConvenioArbitral tramite, CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBDesignacionColegio
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteDesignacionColegio(
			TramiteARBDesignacionColegio tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBDesignacionColegio)
			throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBDesignacionColegio findTramiteDesignacionColegio(
			TramiteARBDesignacionColegio tramite, CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBCitacionAudiencia
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteCitacionAudiencia(TramiteARBCitacionAudiencia tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBCitacionAudiencia) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBCitacionAudiencia findTramiteCitacionAudiencia(
			TramiteARBCitacionAudiencia tramite, CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            TramiteARBCitacionAudiencia
	 * @param tramite2
	 *            TramiteARBCitacion2Audiencia
	 * @param primera
	 *            boolean
	 */
	void actualizaTramiteCitacionAudiencia(TramiteARBCitacionAudiencia tramite,
			TramiteARBCitacion2Audiencia tramite2, boolean primera);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBSuspensionAudiencia
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteSuspensionAudiencia(
			TramiteARBSuspensionAudiencia tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBSuspensionAudiencia)
			throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBSuspensionAudiencia findTramiteSuspensionAudiencia(
			TramiteARBSuspensionAudiencia tramite, CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBAudiencia
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteAudiencia(TramiteARBAudiencia tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBAudiencia) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBAudiencia findTramiteAudiencia(TramiteARBAudiencia tramite,
			CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBCitacion2Audiencia
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteCitacion2Audiencia(
			TramiteARBCitacion2Audiencia tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBCitacion2Audiencia)
			throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBCitacion2Audiencia findTramiteCitacion2Audiencia(
			TramiteARBCitacion2Audiencia tramite, CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARB2Audiencia
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramite2Audiencia(TramiteARB2Audiencia tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARB2Audiencia) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARB2Audiencia findTramite2Audiencia(TramiteARB2Audiencia tramite,
			CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBCitacionAPrueba
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteCitacionAPrueba(TramiteARBCitacionAPrueba tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBCitacionAPrueba) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBCitacionAPrueba findTramiteCitacionAPrueba(
			TramiteARBCitacionAPrueba tramite, CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBRecepcionInformePericial
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteRecepcionInformePericial(
			TramiteARBRecepcionInformePericial tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBRecepcionInformePericial) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBRecepcionInformePericial findTramiteRecepcionInformePericial(
			TramiteARBRecepcionInformePericial tramite,
			CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBPagoPericial
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramitePagoPericial(TramiteARBPagoPericial tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBPagoPericial) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBPagoPericial findTramitePagoPericial(
			TramiteARBPagoPericial tramite, CensoMonitor censoMonitor);

	/**
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param solarb
	 *            Solarb
	 * @throws Exception
	 *             Exception
	 */
	void sugiereTramiteComunicacionArbitros(Arbtramexp arbtramexp, Solarb solarb)
			throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return TramiteARBAclaracion
	 */
	TramiteARBAclaracion findTramiteAclaracion(TramiteARBAclaracion tramite,
			CensoMonitor censoMonitor);
}
