package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbexpDao;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.utils.Y41bUtils;

public class Arbtramexp5ServiceImpl {

	@Autowired()
	protected SolarbDao solarbDao;
	@Autowired()
	protected ArbexpDao arbexpDao;
	@Autowired()
	protected ArbintervDao arbintervDao;

	/**
	 * Calcula titular/representante segun participacion
	 * 
	 * @param solarb
	 *            Solarb
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param participacion
	 *            String
	 * @return String
	 */
	protected String calcularSegunParticipacion(Solarb solarb,
			Arbtramexp arbtramexp, String participacion) {
		String rep = "", repNV = "";
		rep = (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE
				.equals(participacion)) ? Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
				: Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO;
		repNV = (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE
				.equals(participacion)) ? Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO
				: Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO;

		// buscar el representante
		Arbinterv arbintervAux = new Arbinterv();
		List<Arbinterv> reps = null;
		reps = this.arbintervDao.findAllByTipo(solarb, rep);
		if (reps != null && reps.size() > 0) {
			arbintervAux = reps.get(0);
			String idInterviniente = new String(arbintervAux.getUaidinterv()
					+ "");
			return idInterviniente;
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_REQUERIMIENTOACREDITACIONREPRESENTACION
				.equals(arbtramexp.getTrcodigorel())) {
			reps = this.arbintervDao.findAllByTipo(solarb, repNV);
			if (reps != null && reps.size() > 0) {
				arbintervAux = reps.get(0);
			}

			String idInterviniente = "";
			if (arbintervAux.getUaidinterv() != null) {
				idInterviniente = new String(arbintervAux.getUaidinterv() + "");
			}
			if (arbintervAux != null && Y41bUtils.isFilled(idInterviniente)) {
				return idInterviniente;
			} else {
				// Si no existe se pone como destinatario el titular
				return arbtramexp.getTruaidinterv() + "";
			}
		} else {
			return arbtramexp.getTruaidinterv() + "";
		}
	}

	/**
	 * Metodo que actualiza el estado de los tramites generados
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return String
	 */
	protected String calcularDestinatarioComunicacionNotificacion(
			Arbtramexp arbtramexp) {

		// Calcular el destinatario
		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(arbtramexp
				.getTrestado())) {

			Solarb solarb = new Solarb();
			solarb = arbtramexp.getSolarb();
			solarb = this.solarbDao.find(solarb);

			Arbexp arbexp = new Arbexp();
			if (solarb != null && solarb.getSacodigo() != null) {
				arbexp.setExcodigo(solarb.getSacodigo());
			}
			arbexp = this.arbexpDao.find(arbexp);

			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setUaidinterv(arbtramexp.getTruaidinterv());
			arbinterv = this.arbintervDao.find(arbinterv);

			if (arbinterv != null
					&& arbinterv.getUatipointerv() != null
					&& arbinterv.getUatipointerv().equals(
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE)) {
				if (arbexp != null
						&& Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE
								.equals(arbexp.getExdestnotifreclamante())) {

					return this.calcularSegunParticipacion(solarb, arbtramexp,
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);

				} else {
					return arbtramexp.getTruaidinterv() + "";
				}

			} else if (arbinterv != null
					&& arbinterv.getUatipointerv() != null
					&& arbinterv.getUatipointerv().equals(
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO)) {
				if (arbexp != null
						&& Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE
								.equals(arbexp.getExdestnotifreclamado())) {

					return this.calcularSegunParticipacion(solarb, arbtramexp,
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);

				} else {
					return arbtramexp.getTruaidinterv() + "";
				}

			} else {
				return arbtramexp.getTruaidinterv() + "";
			}

		} else {
			return arbtramexp.getTruaidinterv() + "";
		}
	}
}
