// CHECKSTYLE:OFF
package com.ejie.y41b.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjunInfraccArbDao;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.ArbbandejaDao;
import com.ejie.y41b.dao.ArbcolegioDao;
import com.ejie.y41b.dao.ArbdoctempDao;
import com.ejie.y41b.dao.ArbenvioDao;
import com.ejie.y41b.dao.ArbexpDao;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.ArbtipdocDao;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.dao.BandejaFirmaArbitrajeDao;
import com.ejie.y41b.dao.BandejaFirmaDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.DecisionDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.DocumentosFirmaArbitrosDao;
import com.ejie.y41b.dao.DocumentosFirmaArbitrosTempDao;
import com.ejie.y41b.dao.InfraccArbDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.PosibleTramiteDao;
import com.ejie.y41b.dao.RemesaDao;
import com.ejie.y41b.dao.SantipdocDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbbandeja;
import com.ejie.y41b.model.Arbcolegio;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbenvio;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.BandejaFirmaArbitraje;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Decision;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoTramiteHecho;
import com.ejie.y41b.model.DocumentosFirmaArbitros;
import com.ejie.y41b.model.DocumentosFirmaArbitrosTemp;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.PosibleTramite;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.Sanpropbandeja;
import com.ejie.y41b.model.Santipdoc;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.Tcmotina;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteARBAclaracion;
import com.ejie.y41b.model.TramiteARBLaudo;
import com.ejie.y41b.model.TramiteARBPagoLaudo;
import com.ejie.y41b.model.TramiteARBPagoPericialColegio;
import com.ejie.y41b.model.TramiteARBPropuestaSancionador;
import com.ejie.y41b.model.TramiteARBRecepcionAlegaciones;
import com.ejie.y41b.model.TramiteARBResolucion;
import com.ejie.y41b.model.TramiteBOPVAyto;
import com.ejie.y41b.model.TramiteCierre;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteElaboracionBOPVAyto;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteNotificacion;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.ActualizarExpediente;
import com.ejie.y41b.model.platea.ActualizarMisGestiones;
import com.ejie.y41b.model.platea.CierreExpediente;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.DatosRegistro;
import com.ejie.y41b.model.platea.MensajeAportacionDocumentacion;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.platea.Proceedings;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.platea.Y41bFuncionesAuxiliaresPlatea;

/**
 * Arbtramexp4ServiceImpl  
 * 
 *  
 */

@Service(value = "arbtramexp4Service")
public class Arbtramexp4ServiceImpl implements Arbtramexp4Service {

	private static final Logger logger = LoggerFactory.getLogger(Arbtramexp4ServiceImpl.class);

	@Autowired()
	private ArbtramexpDao arbtramexpDao;
	@Autowired()
	private ArbexpDao arbexpDao;
	@Autowired()
	private ArbdoctempDao arbdoctempDao;
	@Autowired()
	private AdjuntardocsDao adjuntardocsDao;
	@Autowired()
	private BandejaFirmaDao bandejaFirmaDao;
	@Autowired()
	private ArbenvioDao arbenvioDao;
	@Autowired()
	private ArbbandejaDao arbbandejaDao;
	@Autowired()
	private Arbtramexp2Service arbtramexp2Service;
	@Autowired()
	private SolarbDao solarbDao;
	@Autowired()
	private PosibleTramiteDao posibleTramiteDao;
	@Autowired()
	private ArbcolegioDao arbcolegioDao;
	@Autowired()
	private CensoMonitorDao censoMonitorDao;
	@Autowired()
	private Arbtramexp3Service arbtramexp3Service;
	@Autowired()
	private ArbintervDao arbintervdao;
	@Autowired()
	private ArbtipdocDao arbtipdocDao;
	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;
	@Autowired()
	private DecisionDao decisionDao;
	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;
	@Autowired()
	private SanpropbandejaService sanpropbandejaService;
	@Autowired()
	private AdjunInfraccArbDao adjunInfraccArbDao;
	@Autowired()
	private ArbintervDao arbintervDao;
	@Autowired()
	private InfraccArbDao infraccArbDao;
	@Autowired()
	private ArbtramexpService arbtramexpService;
	@Autowired()
	private SantipdocDao santipdocDao;
	@Autowired()
	private OrganismoDao organismoDao;
	@Autowired()
	private RemesaDao remesaDao;
	@Autowired()
	private ArbdoctempService arbdoctempService;
	@Autowired()
	private DocumentoHechoDao documentoHechoDao;
	@Autowired()
	private ArbitroService arbitroService;
	@Autowired()
	private ArbintervService arbintervService;
	@Autowired()
	private IntervinientesTramiteService intervinientesTramiteService;
	@Autowired()
	private DocumentosFirmaArbitrosDao documentosFirmaArbitrosDao;
	@Autowired()
	private DocumentosFirmaArbitrosTempDao documentosFirmaArbitrosTempDao;
	@Autowired
	private DenunciaService denunciaService;
	@Autowired()
	private BandejaFirmaArbitrajeDao bandejaFirmaArbitrajeDao;

	/**
	 * Deletes a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexpAux
	 *            Arbtramexp
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbtramexp arbtramexp) {
		Arbtramexp4ServiceImpl.logger.info("Arbtramexp4ServiceImpl.remove Inicio:" + arbtramexp.getTrid() + ".");

		arbtramexp = this.arbtramexpDao.find(arbtramexp);

		// APERTURA
		if (Y41bConstantes.TRAMITE_ARBITRAJE_APERTURA.equals(arbtramexp.getTrcodigo())) {
			// No se permite eliminar el tramite de apertura, est o no
			// tramitado.
			throw new Y41bUDAException("error.eliminarTramite.isTramiteAperturaArbitrajeException", true,
					new Exception());
		}
		// APORTE TELEMATICO
		// No se permite eliminar el tramite de aportacin de documentacin
		// telematico
		if (Y41bConstantes.TRAMITE_ARBITRAJE_APORTACIONDOCUMENTACION.equals(arbtramexp.getTrcodigo())) {
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(arbtramexp.getTrid().toString());
			List<Arbdoctemp> listDocumentosAportados = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux,
					null);
			if (listDocumentosAportados != null && listDocumentosAportados.size() > 0) {
				Arbdoctemp arbdoctemp = null;
				boolean aportadoReclamado = false;
				for (int j = 0; j < listDocumentosAportados.size(); j++) {
					arbdoctemp = listDocumentosAportados.get(j);
					if (arbdoctemp.getX5origen() != null
							&& (arbdoctemp.getX5origen().equals(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO)
									|| arbdoctemp.getX5origen()
											.equals(Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO)
									|| arbdoctemp.getX5origen().equals(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE)
									|| arbdoctemp.getX5origen()
											.equals(Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE))
							&& !Y41bUtils.esNullOCadenaVacia(arbdoctemp.getX5iddocumentum())
							&& arbdoctemp.getX5numregistroentrada() != null
							&& arbdoctemp.getX5numregistroentrada().contains("RTE")) {
						aportadoReclamado = true;
						break;
					}
				}
				if (aportadoReclamado) {
					throw new Y41bUDAException("error.eliminarTramite.isTramiteAportacionTelematicaException", true,
							new Exception());
				}
			}
		}

		// COMUNICACION
		if (arbtramexp.getTrfecfin() != null
				&& Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION.equals(arbtramexp.getTrcodigo())) {
			if (Y41bConstantes.TIPO_COMUNICACION_TELEMATICA.equals(arbtramexp.getTrtipocom())) {
				// No se podr eliminar un tramite de comunicacion si esta
				// tramitado
				// telematicamente.
				throw new Y41bUDAException("error.eliminarTramite.isTramiteComunicacionTelematicaException", true,
						new Exception());

			} else if (Y41bConstantes.TIPO_COMUNICACION_CORREOELECTRONICO.equals(arbtramexp.getTrtipocom())) {
				// No se podr eliminar una comunicacion tramitada por mail
				throw new Y41bUDAException("error.eliminarTramite.isTramiteComunicacionMailException", true,
						new Exception());
			} else if (Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO.equals(arbtramexp.getTrtipocom())
					&& Y41bConstantes.SI.equals(arbtramexp.getTrenvrem()) && arbtramexp.getTrcodrem() != null
					&& !"".equals(arbtramexp.getTrcodrem())) {
				// No se podr eliminar una comunicacion ordinaria si es con
				// remesa y tiene la remesa generada
				throw new Y41bUDAException("error.eliminarTramite.isTramiteComunicacionOrdinariaRemesaException", true,
						new Exception());
			}

		}

		// NOTIFICACION
		if (Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION.equals(arbtramexp.getTrcodigo())) {
			if (arbtramexp.getTrfecfin() != null
					&& Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(arbtramexp.getTrtiponot())) {
				// No se podr eliminar un tramite de notificacin si esta
				// tramitado
				// telematicamente.
				throw new Y41bUDAException("error.eliminarTramite.isTramiteNotificacionTelematicaException", true,
						new Exception());
			} else if (arbtramexp.getTrfecfin() != null
					&& Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA.equals(arbtramexp.getTrtiponot())) {
				if (Y41bConstantes.SI.equals(arbtramexp.getTrenvrem()) && arbtramexp.getTrcodrem() != null
						&& !arbtramexp.getTrcodrem().equals("")) {
					// No se podr eliminar una comunicacion ordinaria si es con
					// remesa y tiene la remesa generada
					throw new Y41bUDAException("error.eliminarTramite.isTramiteNotificacionOrdinariaRemesaException",
							true, new Exception());
				} else {
					// No se podr eliminar un tramite notificacin ordinario
					// sin remesa si tiene acuse de recibo relacionado
					Arbtramexp arbtramexpRel = new Arbtramexp();
					// Acuse de recibo cuyo tramite relacionado es el tramite en
					// el que estamos
					arbtramexpRel.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO);
					arbtramexpRel.setTrtridrel(arbtramexp.getTrid());
					Long contador = this.arbtramexpDao.findAllCount(arbtramexpRel);
					if (contador.intValue() > 0) {
						throw new Y41bUDAException("error.eliminarTramite.isTramiteNotificacionOrdinariaAcuse", true,
								new Exception());
					}
				}
			}
		}

		// ACUSE
		if (Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO.equals(arbtramexp.getTrcodigo())) {
			if (arbtramexp.getTrfecfin() != null) {
				// No se permite eliminar el tramite de acuse de recibo si est
				// tramitado.
				throw new Y41bUDAException("error.eliminarTramite.isTramiteAcuseReciboTramitadoException", true,
						new Exception());
			}
			if (arbtramexp.getTrcodigorel() != null
					&& Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION.equals(arbtramexp.getTrcodigorel())) {
				// No se podr eliminar un tramite de acuse de recibo
				// relacionado con una notificacin telematica
				Arbtramexp arbtramexpRel = new Arbtramexp();
				// Notificacion telematica relacionada con el acuse en el que
				// estamos
				arbtramexpRel.setTrid(arbtramexp.getTrtridrel());
				arbtramexpRel = this.arbtramexpDao.find(arbtramexpRel);
				if (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(arbtramexpRel.getTrtiponot())) {
					throw new Y41bUDAException(
							"error.eliminarTramite.isTramiteAcuseReciboNotificacionTelematicaException", true,
							new Exception());
				}

				// No se podr eliminar un tramite de acuse de recibo
				// relacionado
				// con una notificacin ordinaria con remesa generada (por lo
				// que si se
				// elimina la remesa, se podr eliminar el acuse)
				if (Y41bConstantes.SI.equals(arbtramexpRel.getTrenvrem()) && arbtramexpRel.getTrcodrem() != null
						&& !arbtramexpRel.getTrcodrem().equals("")) {
					throw new Y41bUDAException(
							"error.eliminarTramite.isTramiteAcuseReciboNotificacionOrdinariaRemesaException", true,
							new Exception());
				}
				// Al elminar el acuse de recibo (en los casos que se pueda) el
				// tramite
				// notificacion asociado pasara a estar como pendiente.
				if (Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO.equals(arbtramexp.getTrcodigo())) {
					arbtramexpRel.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					this.reabrirTramite(arbtramexpRel);
					// Y se borra de arbenvio
					Arbenvio arbenvio = new Arbenvio();
					arbenvio.setArbtramexpByEntrid(new Arbtramexp(arbtramexp.getTrtridrel()));
					List<Arbenvio> envios = this.arbenvioDao.findAll(arbenvio, null);
					if (envios != null && envios.size() > 0) {
						for (int i = 0; i < envios.size(); i++) {
							arbenvio = envios.get(i);
							this.arbenvioDao.remove(arbenvio);
						}
					}
				}
			}

		}

		// CIERRE
		if (arbtramexp.getTrfecfin() != null
				&& Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE.equals(arbtramexp.getTrcodigo())) {
			// No permite eliminar el tramite de cierre de expediente si est
			// tramitado
			throw new Y41bUDAException("error.eliminarTramite.isTramiteCierreException", true, new Exception());
		}

		// PAGO LAUDO Y PAGO PERICIAL
		if (arbtramexp.getTrfecfin() != null
				&& (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO.equals(arbtramexp.getTrcodigo())
						|| Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL.equals(arbtramexp.getTrcodigo()))) {
			// No permite eliminar el tramite de pago laudo o pago pericial de
			// expediente si esta tramitado
			throw new Y41bUDAException("error.eliminarTramite.isTramitePagoException", true, new Exception());
		}

		// ELABORACION DOCUMENTACION
		if (Y41bConstantes.TRAMITE_ARBITRAJE_ELABORACION_BOPVBOE.equals(arbtramexp.getTrcodigo())) {
			if (arbtramexp.getTrfecfin() != null) {
				// No permite eliminar el tramite de elaboracin de
				// documentacin
				// para publicacin en BOE-BOPV si est tramitado
				throw new Y41bUDAException("error.eliminarTramite.isTramiteElaboracionDocException", true,
						new Exception());
			} else {
				// Se reabre el acuse de recibo relacionado
				// El tramite relacionado es la notificacion asi que tengo que
				// buscar el acuse de la notificacin
				Arbtramexp arbtramexpRel = new Arbtramexp();
				arbtramexpRel.setTrtridrel(arbtramexp.getTrtridrel());
				arbtramexpRel.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO);
				List<Arbtramexp> listaArbtramexpRel = this.arbtramexpDao.findAll(arbtramexpRel, null);
				if (listaArbtramexpRel != null && listaArbtramexpRel.size() > 0) {
					arbtramexpRel = listaArbtramexpRel.get(0);
					arbtramexpRel.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					this.reabrirTramite(arbtramexpRel);
				}
			}
		}
		// PUBLICACION BOE BOPV
		if (Y41bConstantes.TRAMITE_ARBITRAJE_PUBLICACION_BOPVBOE.equals(arbtramexp.getTrcodigo())) {
			if (arbtramexp.getTrfecfin() != null) {
				// No permite eliminar el tramite de publicacin en BOE-BOPV si
				// est
				// tramitado
				throw new Y41bUDAException("error.eliminarTramite.isTramitePublicacionBOEBOPVException", true,
						new Exception());
			} else {
				// Se reabre la elaboracin documentacin relacionada
				// El tramite relacionado es la notificacion asi que tengo que
				// buscar la elaboracin documentacin de la notificacin
				Arbtramexp arbtramexpRel = new Arbtramexp();
				arbtramexpRel.setTrtridrel(arbtramexp.getTrtridrel());
				arbtramexpRel.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ELABORACION_BOPVBOE);
				List<Arbtramexp> listaArbtramexpRel = this.arbtramexpDao.findAll(arbtramexpRel, null);
				if (listaArbtramexpRel != null && listaArbtramexpRel.size() > 0) {
					arbtramexpRel = listaArbtramexpRel.get(0);
					arbtramexpRel.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					this.reabrirTramite(arbtramexpRel);
				}
			}
		}

		// Al eliminar un tramite, el
		// tramite asociado pasara a estar como pendiente, si no hay otras
		// relaciones con este ultimo
		if (arbtramexp.getTrtridrel() != null) {
			// Buscamos si hay mas tramites con el mismo trtridrel
			Arbtramexp arbtramexpAux = new Arbtramexp();
			arbtramexpAux.setTrtridrel(arbtramexp.getTrtridrel());
			Long contador = this.arbtramexpDao.findAllCount(arbtramexpAux);
			if (contador.intValue() == 1) {
				Arbtramexp arbtramexpRel = new Arbtramexp();
				arbtramexpRel.setTrid(arbtramexp.getTrtridrel());
				arbtramexpRel = this.arbtramexpDao.find(arbtramexpRel);
				if (!Y41bConstantes.TRAMITE_ARBITRAJE_APERTURA.equals(arbtramexpRel.getTrcodigo())) {
					arbtramexpRel.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					this.reabrirTramite(arbtramexpRel);
					// Del mismo modo, eliminamos el aviso correspondiente
					this.removeAviso(arbtramexpRel);

				}
			}
		}

		// MEDIACION
		if (Y41bConstantes.TRAMITE_ARBITRAJE_MEDIACION.equals(arbtramexp.getTrcodigo())) {
			Arbtramexp recepAlegaciones = new Arbtramexp();
			recepAlegaciones.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_ALEGACIONES);
			recepAlegaciones.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			recepAlegaciones.setTrtipoalega("M");
			if (arbtramexp.getSolarb() != null && arbtramexp.getSolarb().getArbexp() != null
					&& arbtramexp.getSolarb().getArbexp().getExcodigo() != null) {
				recepAlegaciones.setTrexcodigo(arbtramexp.getSolarb().getArbexp().getExcodigo());
				// recepAlegaciones
				List<Arbtramexp> lrecepAlegaciones = this.arbtramexpDao.findAll(recepAlegaciones, null);
				for (int i = 0; i < lrecepAlegaciones.size(); i++) {
					recepAlegaciones = lrecepAlegaciones.get(i);
					recepAlegaciones.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					this.arbtramexpDao.updateReabrirTramite(recepAlegaciones);
				}
			}
		}

		// DESIGNACION COLEGIO
		if (Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO.equals(arbtramexp.getTrcodigo())) {
			// Borramos el colegio
			Arbcolegio arbcolegio = new Arbcolegio();
			arbcolegio.setXjtrid(arbtramexp.getTrid());
			arbcolegio = this.arbcolegioDao.find(arbcolegio);
			if (arbcolegio != null) {
				ArrayList<String> codigos = new ArrayList<String>();
				codigos.add(arbcolegio.getConsumidorT().getArcodigo());
				codigos.add(arbcolegio.getConsumidorS().getArcodigo());
				codigos.add(arbcolegio.getEmpresarialT().getArcodigo());
				codigos.add(arbcolegio.getEmpresarialS().getArcodigo());
				codigos.add(arbcolegio.getPresidenteT().getArcodigo());
				codigos.add(arbcolegio.getPresidenteS().getArcodigo());
				// Borramos los arbitros aadidos como intervinientes
				for (int j = 0; j < codigos.size(); j++) {
					Arbinterv arbinterv = new Arbinterv();
					arbinterv.setUaentidadId(codigos.get(j));
					arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO);
					arbinterv.setUaexcodigo(arbtramexp.getSolarb().getArbexp().getExcodigo());
					List<Arbinterv> larbinterv = this.arbintervDao.findAll(arbinterv, null);
					if (larbinterv != null) {
						for (int i = 0; i < larbinterv.size(); i++) {

							if (larbinterv.get(i) != null && ((Arbinterv) larbinterv.get(i)).getUaidinterv() != null) {
								// Existe algun tramite con ese
								// interviniente
								Arbtramexp tramite = new Arbtramexp();
								tramite.setSolarb(arbtramexp.getSolarb());
								tramite.setArbinterv(larbinterv.get(i));
								Long numTramites = this.arbtramexpDao.findAllCount(tramite);
								if (numTramites.longValue() == 0L) {
									// Existe algun envio
									Arbenvio arbenvio = new Arbenvio();
									arbenvio.setSolarb(arbtramexp.getSolarb());
									arbenvio.setArbinterv((Arbinterv) larbinterv.get(i));
									Long numEnvios = this.arbenvioDao.findAllCount(arbenvio);
									if (numEnvios.longValue() == 0L) {
										this.arbintervDao.remove(larbinterv.get(i));
									}
								}
							}
						}
					}
				}
				this.arbcolegioDao.remove(arbcolegio);
			}
		}

		// CITACION A PRUEBA
		if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA.equals(arbtramexp.getTrcodigo())) {
			ArrayList<String> codigos = new ArrayList<String>();
			if (arbtramexp.getTrcope1() != null) {
				codigos.add(arbtramexp.getTrcope1());
			}
			if (arbtramexp.getTrcope2() != null) {
				codigos.add(arbtramexp.getTrcope2());
			}
			// Borramos los rbitos seleccionados en la opcin "Colegio"
			this.intervinientesTramiteService.borrarArbitros(arbtramexp.getTrid());

			// Borramos los peritos aadidos como intervinientes
			for (int j = 0; j < codigos.size(); j++) {
				Arbinterv arbinterv = new Arbinterv();
				arbinterv.setUaentidadId(codigos.get(j));
				arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO);
				arbinterv.setUaexcodigo(arbtramexp.getSolarb().getArbexp().getExcodigo());
				List<Arbinterv> larbinterv = this.arbintervDao.findAll(arbinterv, null);
				if (larbinterv != null) {
					for (int i = 0; i < larbinterv.size(); i++) {

						if (larbinterv.get(i) != null && ((Arbinterv) larbinterv.get(i)).getUaidinterv() != null) {
							// Existe algun tramite con ese
							// interviniente
							Arbtramexp tramite = new Arbtramexp();
							tramite.setSolarb(arbtramexp.getSolarb());
							tramite.setArbinterv(larbinterv.get(i));
							Long numTramites = this.arbtramexpDao.findAllCount(tramite);
							if (numTramites.longValue() == 0L) {
								// Existe algun envio
								Arbenvio arbenvio = new Arbenvio();
								arbenvio.setSolarb(arbtramexp.getSolarb());
								arbenvio.setArbinterv((Arbinterv) larbinterv.get(i));
								Long numEnvios = this.arbenvioDao.findAllCount(arbenvio);
								if (numEnvios.longValue() == 0L) {
									this.arbintervDao.remove(larbinterv.get(i));
								}
							}
						}
					}
				}
			}
		}

		// ELIMINAMOS LOS TIPOS DE DOCUMENTO A SUBSANAR

		if (Y41bConstantes.TRAMITE_ARBITRAJE_SUBSANACION.equals(arbtramexp.getTrcodigo())) {
			// Borramos los tipos de documentos a subsanar del trmite
			this.arbtramexpDao.deleteArbtramtsubs(arbtramexp.getTrid());
		}

		// Eliminar bandeja de firma
		BandejaFirma bandejafirma = new BandejaFirma();
		bandejafirma.setIdtramitehecho(arbtramexp.getTrid().toString());
		bandejafirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
		bandejafirma.setIdexpediente(arbtramexp.getSolarb().getSacodigo());
		List<BandejaFirma> listaBandeja = this.bandejaFirmaDao.findAll(bandejafirma, null);
		if (listaBandeja != null) {
			for (int i = 0; i < listaBandeja.size(); i++) {
				BandejaFirma bandeja = listaBandeja.get(i);
				this.bandejaFirmaDao.remove(bandeja);
			}
		}

		// Eliminar documentos
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(arbtramexp.getTrid().toString());
		tramiteComun.setIdExpediente(arbtramexp.getSolarb().getArbexp().getExcodigo());
		tramiteComun.setTipoProcedimiento(new TipoProcedimiento(Y41bConstantes.TIPO_PROC_ARBITRAJE));
		this.arbdoctempDao.removeArbDocTramite(tramiteComun);

		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		try {
			// INICIO Codigo sustituido
			// this.arbdoctempDao.removeDocumentosHechoAdjuntarDocs(tramiteComun);
			// FIN Codigo sustituido
			// INICIO Se sustituye por
			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5tramite(tramiteComun.getIdTramite());
			documentoHecho.setQ5hdcodigo(tramiteComun.getIdExpediente());
			List<DocumentoHecho> listDocumentoHecho2 = this.documentoHechoDao.findAll(documentoHecho, null);

			for (DocumentoHecho documentoHechoAux : listDocumentoHecho2) {
				try {
					this.documentoHechoDao.remove(documentoHechoAux);
				} catch (DataIntegrityViolationException dataIntegrityViolationException) {
					throw new Y41bUDAException("error.solicitud.documentoAdjuntadoException", true, new Exception());
				}
			}
			// FIN Se sustituye por
			this.adjuntardocsDao.removeAdjuntarDocsTramite(tramiteComun);
		} catch (Exception e) {
			// Si tiene tramnite relacionado dara esta excepcion
			throw new Y41bUDAException("error.eliminarTramite.documentos.DataIntegrityViolationException", true, e);
		}
		try { // Borramos de Dokusi
			this.arbtramexp2Service.eliminarDocumentosDokusi(listDocumentoHecho);
		} catch (Exception e) {
			// Si tiene tramnite relacionado dara esta excepcion
			Arbtramexp4ServiceImpl.logger.error("Error al eliminar de documentos de Dokusi: " + e.getMessage());
			throw new Y41bUDAException("error.eliminarTramite.documentos.DataIntegrityViolationException", true, e);
		}

		// Envios
		Arbenvio arbenvio = new Arbenvio();
		if (Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION.equals(arbtramexp.getTrcodigo())) {
			arbenvio.setArbtramexpByEntrid(new Arbtramexp(arbtramexp.getTrid()));
			List<Arbenvio> envios = this.arbenvioDao.findAll(arbenvio, null);
			if (envios != null && envios.size() > 0) {
				for (int i = 0; i < envios.size(); i++) {
					arbenvio = envios.get(i);
					this.arbenvioDao.remove(arbenvio);
				}
			}
		}

		// Eliminar arbbandeja
		Arbbandeja arbbandeja = new Arbbandeja();
		arbbandeja.setAbtrid(arbtramexp.getTrid());
		List<Arbbandeja> listArbbandeja = this.arbbandejaDao.findAll(arbbandeja, null);
		if (listArbbandeja != null && listArbbandeja.size() > 0) {
			for (int i = 0; i < listArbbandeja.size(); i++) {
				arbbandeja = listArbbandeja.get(i);
				this.arbbandejaDao.remove(arbbandeja);
			}
		}

		Arbexp arbexp = this.arbexpDao.find(arbtramexp.getSolarb().getArbexp());
		arbexp.setArbtramexp(null);
		arbexp.setArbtramexpEntidad(null);

		/*
		 * Arbexp arbexpAux = this.arbexpDao.findLobTablaTemporal(arbexp); if
		 * (arbexpAux != null) { arbexp.setHdte(arbexpAux.getHdte()); }
		 */
		this.arbexpDao.update(arbexp);

		// Eliminar tramite
		try {
			this.arbtramexpDao.remove(arbtramexp);
			if (Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO.equals(arbtramexp.getTrcodigo())) {
				Arbtramexp organoColegioArbitral = new Arbtramexp();
				// sacar los datos del ltimo que est resuelto
				Solarb solarb = new Solarb();
				solarb.setSacodigo(tramiteComun.getIdExpediente());
				organoColegioArbitral.setSolarb(solarb);

				organoColegioArbitral.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
				organoColegioArbitral.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

				Pagination pagination = new Pagination();
				pagination.setSort("trfecfin");
				pagination.setAscDsc("desc");

				List<Arbtramexp> lista = this.arbtramexpDao.findAll(organoColegioArbitral, pagination);

				if (lista != null && lista.size() > 0) {
					organoColegioArbitral = lista.get(0);
					Arbcolegio arbcolegio = new Arbcolegio();
					arbcolegio.setXjtrid(organoColegioArbitral.getTrid());
					arbcolegio = this.arbcolegioDao.find(arbcolegio);
					if (arbcolegio != null) {
						// Aniadir el presidente
						if (arbcolegio.getPresidenteT() != null && arbcolegio.getPresidenteT().getArcodigo() != null) {
							this.aniadirIntervinientesColegio(tramiteComun.getIdExpediente(),
									arbcolegio.getPresidenteT().getArcodigo());
						}

						// Aniadir el presidente suplente
						if (arbcolegio.getPresidenteS() != null && arbcolegio.getPresidenteS().getArcodigo() != null) {
							this.aniadirIntervinientesColegio(tramiteComun.getIdExpediente(),
									arbcolegio.getPresidenteS().getArcodigo());
						}

						// Aniadir el arbitro consumidores AACC
						if (arbcolegio.getConsumidorT() != null && arbcolegio.getConsumidorT().getArcodigo() != null) {
							this.aniadirIntervinientesColegio(tramiteComun.getIdExpediente(),
									arbcolegio.getConsumidorT().getArcodigo());
						}

						// Aniadir el arbitro consumidores AACC suplente
						if (arbcolegio.getConsumidorS() != null && arbcolegio.getConsumidorS().getArcodigo() != null) {
							this.aniadirIntervinientesColegio(tramiteComun.getIdExpediente(),
									arbcolegio.getConsumidorS().getArcodigo());
						}

						// Aniadir el arbitro empresarial OOEE
						if (arbcolegio.getEmpresarialT() != null
								&& arbcolegio.getEmpresarialT().getArcodigo() != null) {
							this.aniadirIntervinientesColegio(tramiteComun.getIdExpediente(),
									arbcolegio.getEmpresarialT().getArcodigo());
						}

						// Aniadir el arbitro empresarial OOEE suplente
						if (arbcolegio.getEmpresarialS() != null
								&& arbcolegio.getEmpresarialS().getArcodigo() != null) {
							this.aniadirIntervinientesColegio(tramiteComun.getIdExpediente(),
									arbcolegio.getEmpresarialS().getArcodigo());
						}

						// actualizar solarb
						solarb = solarbDao.find(solarb);
						if (solarb != null) {
							solarb.setSacoarpt(arbcolegio.getPresidenteT().getArcodigo());
							solarb.setSacoarps(arbcolegio.getPresidenteS().getArcodigo());
							solarb.setSacoardt(arbcolegio.getEmpresarialT().getArcodigo());
							solarb.setSacoards(arbcolegio.getEmpresarialS().getArcodigo());
							solarb.setSacoartt(arbcolegio.getConsumidorT().getArcodigo());
							solarb.setSacoarts(arbcolegio.getConsumidorS().getArcodigo());
							solarb.setSacoset(arbcolegio.getSecretarioT().getSrcodigo());
							solarb.setSacoses(arbcolegio.getSecretarioS().getSrcodigo());
							solarbDao.update(solarb);
						}
					} else {
						// limpiar solarb
						solarb = solarbDao.find(solarb);
						if (solarb != null) {
							solarb.setSacoarpt(null);
							solarb.setSacoarps(null);
							solarb.setSacoardt(null);
							solarb.setSacoards(null);
							solarb.setSacoartt(null);
							solarb.setSacoarts(null);
							solarb.setSacoset(null);
							solarb.setSacoses(null);
							solarbDao.update(solarb);
						}
					}
				}
			}
		} catch (Exception e) {
			throw new Y41bUDAException("error.eliminarTramite.DataIntegrityViolationException", true, e);
		}
		try {

			// Actualizar expediente con el ultimo tramite
			Arbtramexp ultimoArbtramexp = this.calculaUltimoTramiteArbExp(arbexp);

			// Actualizar bandeja
			this.arbtramexp2Service.actualizaBandeja(ultimoArbtramexp);

			// Borrar datos del expediente referentes al ultimo tramite
			this.actualizaExpedienteTrasEliminar(arbtramexp);

			// Actualizar datos del expediente con los datos del ultimo
			// tramite del mismo tipo
			// Lo normal es que slo haya un tramite de cada

		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

		if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
			try {
				this.eliminarMisGestiones(arbtramexp);
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
		}

		Arbtramexp4ServiceImpl.logger.info("Arbtramexp4ServiceImpl.remove Fin:" + arbtramexp.getTrid() + ".");
	}

	private void aniadirIntervinientesColegio(String sacodigo, String arcodigo) {
		Arbitro arbitro = new Arbitro();
		arbitro.setArcodigo(arcodigo);
		// llamamos al del service porque necesitamos el volcado que hace de
		// oears y aars
		arbitro = this.arbitroService.find(arbitro);
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUaentidadId(arbitro.getArcodigo());
		arbinterv.setUaexcodigo(sacodigo);
		arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO);
		List<Arbinterv> larbinterv = this.arbintervDao.findAll(arbinterv, null);
		// Cambio arbitros - Independientemente del tipo de arbitro, siempre
		// hay que coger los datos de direccin almacenados en arbitro
		// arbitro = this.arbitroService.tratarDireccionesCentro(arbitro);
		if (larbinterv != null && larbinterv.size() == 0) {
			if (Y41bConstantes.CENSO_ARB_ARBITRO_DIR_CEN.equalsIgnoreCase(arbitro.getArindico())) {
				arbinterv = new Arbinterv(null, arbitro.getArnombre(), arbitro.getArnif(), arbitro.getArnrtelc(),
						arbitro.getArnrtel2c(), arbitro.getArprovcId(), arbitro.getArmuncId(), arbitro.getArloccId(),
						arbitro.getArcallecId(), arbitro.getArnombrecCp(), arbitro.getArportalcId(),
						arbitro.getArnombrecPiso(),
						((!Y41bConstantes.ARABA.equals(arbitro.getArprovcId())
								&& !Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovcId())
								&& !Y41bConstantes.BIZKAIA.equals(arbitro.getArprovcId())) ? arbitro.getArnodirc()
										: null),
						"", Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO, sacodigo, null, null, null, null, null, null,
						null, null, null, null, arbitro.getArteemc(),
						((Y41bConstantes.ARABA.equals(arbitro.getArprovcId())
								|| Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovcId())
								|| Y41bConstantes.BIZKAIA.equals(arbitro.getArprovcId())) ? arbitro.getArnodirc()
										: null),
						null, null, Y41bConstantes.COD_PAIS_ESTADO, arbitro.getArcodigo(), null, null,
						arbitro.getArteurlc(), null, null, null, null, null, null, arbitro.getAridioma(), null, null,
						null);
			} else {
				arbinterv = new Arbinterv(null, arbitro.getArnombre(), arbitro.getArnif(), arbitro.getArnrtel(),
						arbitro.getArnrtel2(), arbitro.getArprovId(), arbitro.getArmunId(), arbitro.getArlocId(),
						arbitro.getArcalleId(), arbitro.getArnombreCp(), arbitro.getArportalId(),
						arbitro.getArnombrePiso(),
						((!Y41bConstantes.ARABA.equals(arbitro.getArprovId())
								&& !Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovId())
								&& !Y41bConstantes.BIZKAIA.equals(arbitro.getArprovId())) ? arbitro.getArnodir()
										: null),
						"", Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO, sacodigo, null, null, null, null, null, null,
						null, null, null, null, arbitro.getArteem(),
						((Y41bConstantes.ARABA.equals(arbitro.getArprovId())
								|| Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovId())
								|| Y41bConstantes.BIZKAIA.equals(arbitro.getArprovId())) ? arbitro.getArnodir() : null),
						null, null, Y41bConstantes.COD_PAIS_ESTADO, arbitro.getArcodigo(), null, null,
						arbitro.getArteurl(), null, null, null, null, null, null, arbitro.getAridioma(), null, null,
						null);
			}
			this.arbintervDao.add(arbinterv);
		} else {
			if (Y41bConstantes.CENSO_ARB_ARBITRO_DIR_CEN.equalsIgnoreCase(arbitro.getArindico())) {
				arbinterv = new Arbinterv(larbinterv.get(0).getUaidinterv(), arbitro.getArnombre(), arbitro.getArnif(),
						arbitro.getArnrtelc(), arbitro.getArnrtel2c(), arbitro.getArprovcId(), arbitro.getArmuncId(),
						arbitro.getArloccId(), arbitro.getArcallecId(), arbitro.getArnombrecCp(),
						arbitro.getArportalcId(), arbitro.getArnombrecPiso(),
						((!Y41bConstantes.ARABA.equals(arbitro.getArprovcId())
								&& !Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovcId())
								&& !Y41bConstantes.BIZKAIA.equals(arbitro.getArprovcId())) ? arbitro.getArnodirc()
										: null),
						"", Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO, sacodigo, null, null, null, null, null, null,
						null, null, null, null, arbitro.getArteemc(),
						((Y41bConstantes.ARABA.equals(arbitro.getArprovcId())
								|| Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovcId())
								|| Y41bConstantes.BIZKAIA.equals(arbitro.getArprovcId())) ? arbitro.getArnodirc()
										: null),
						null, null, Y41bConstantes.COD_PAIS_ESTADO, arbitro.getArcodigo(), null, null,
						arbitro.getArteurlc(), null, null, null, null, null, null, arbitro.getAridioma(), null, null,
						null);
			} else {
				arbinterv = new Arbinterv(larbinterv.get(0).getUaidinterv(), arbitro.getArnombre(), arbitro.getArnif(),
						arbitro.getArnrtel(), arbitro.getArnrtel2(), arbitro.getArprovId(), arbitro.getArmunId(),
						arbitro.getArlocId(), arbitro.getArcalleId(), arbitro.getArnombreCp(), arbitro.getArportalId(),
						arbitro.getArnombrePiso(),
						((!Y41bConstantes.ARABA.equals(arbitro.getArprovId())
								&& !Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovId())
								&& !Y41bConstantes.BIZKAIA.equals(arbitro.getArprovId())) ? arbitro.getArnodir()
										: null),
						"", Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO, sacodigo, null, null, null, null, null, null,
						null, null, null, null, arbitro.getArteem(),
						((Y41bConstantes.ARABA.equals(arbitro.getArprovId())
								|| Y41bConstantes.GIPUZKOA.equals(arbitro.getArprovId())
								|| Y41bConstantes.BIZKAIA.equals(arbitro.getArprovId())) ? arbitro.getArnodir() : null),
						null, null, Y41bConstantes.COD_PAIS_ESTADO, arbitro.getArcodigo(), null, null,
						arbitro.getArteurl(), null, null, null, null, null, null, arbitro.getAridioma(), null, null,
						null);
			}
			this.arbintervDao.update(arbinterv);
		}
	}

	private void removeAviso(Arbtramexp arbtramexp) {
		Solarb solarb = new Solarb(arbtramexp.getSolarb().getSacodigo());
		String tipoTramite = arbtramexp.getTrcodigo();
		String parametroABuscar = "";
		String parametroABuscar2 = "";
		String parametroABuscar3 = "";
		if (Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL.equals(tipoTramite)) {
			parametroABuscar = Y41bConstantes.TIPO_AVISO_ARBITRAJE_CONVENIO;
			parametroABuscar2 = Y41bConstantes.TIPO_AVISO_ARBITRAJE_ALEGACIONES;
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_SUBSANACION.equals(tipoTramite)) {
			parametroABuscar = Y41bConstantes.TIPO_AVISO_ARBITRAJE_REQ_SUBSANACION;
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(tipoTramite)) {
			parametroABuscar = Y41bConstantes.TIPO_AVISO_ARBITRAJE_LAUDO_RESO;
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE.equals(tipoTramite)) {
			parametroABuscar = Y41bConstantes.TIPO_AVISO_ARBITRAJE_LAUDO_RESO;
			// } else if
			// (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(tipoTramite)) {
			// parametroABuscar =
			// Y41bConstantes.TIPO_AVISO_ARBITRAJE_LAUDO_RESO;
			// parametroABuscar2 =
			// Y41bConstantes.TIPO_AVISO_ARBITRAJE_ACLARACION;
			// parametroABuscar3 = Y41bConstantes.TIPO_AVISO_ARBITRAJE_NULIDAD;
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_NO_ADHERIDA.equals(tipoTramite)
				|| Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_ADHERIDA_LIM.equals(tipoTramite)) {
			parametroABuscar = Y41bConstantes.TIPO_AVISO_ARBITRAJE_ACEPTACION_ARBITRAJE;
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE.equals(tipoTramite)) {
			parametroABuscar = Y41bConstantes.TIPO_AVISO_ARBITRAJE_ACEPTACION_ARBITRAJE;
		}
		if (parametroABuscar != null) {
			Arbbandeja aviso = new Arbbandeja();
			aviso.setSolarb(solarb);
			aviso.setAbtipo(parametroABuscar);
			List<Arbbandeja> lavisos = arbbandejaDao.findAll(aviso, null);
			if (lavisos != null) {
				for (int i = 0; i < lavisos.size(); i++) {
					this.arbbandejaDao.remove(lavisos.get(i));
				}
			}
		}
		if (parametroABuscar2 != null) {
			Arbbandeja aviso = new Arbbandeja();
			aviso.setSolarb(solarb);
			aviso.setAbtipo(parametroABuscar2);
			List<Arbbandeja> lavisos = arbbandejaDao.findAll(aviso, null);
			if (lavisos != null) {
				for (int i = 0; i < lavisos.size(); i++) {
					this.arbbandejaDao.remove(lavisos.get(i));
				}
			}
		}

		if (parametroABuscar3 != null) {
			Arbbandeja aviso = new Arbbandeja();
			aviso.setSolarb(solarb);
			aviso.setAbtipo(parametroABuscar3);
			List<Arbbandeja> lavisos = arbbandejaDao.findAll(aviso, null);
			if (lavisos != null) {
				for (int i = 0; i < lavisos.size(); i++) {
					this.arbbandejaDao.remove(lavisos.get(i));
				}
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.Arbtramexp2Service#actualizaExpedienteTrasEliminar
	 * (com.ejie.y41b.model.Arbtramexp)
	 */
	@Override
	public void actualizaExpedienteTrasEliminar(Arbtramexp arbtramexp) {
		try {

			Solarb solarb = new Solarb();
			solarb.setSacodigo(arbtramexp.getSolarb().getSacodigo());
			solarb = this.solarbDao.find(solarb);

			Arbexp arbexp = new Arbexp();
			arbexp.setExcodigo(arbtramexp.getSolarb().getSacodigo());
			arbexp = this.arbexpDao.find(arbexp);
			if (Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO.equals(arbtramexp.getTrcodigo())) {
				solarb.setSaintica(null);
				solarb.setSafedeco(null);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
				solarb.setSafeciau(null);
				solarb.setSahrciau(null);
				// solarb.setSacoarpt(null);
				// solarb.setSacoarps(null);
				// solarb.setSacoardt(null);
				// solarb.setSacoards(null);
				// solarb.setSacoartt(null);
				// solarb.setSacoarts(null);
				solarb.setSacoset(null);
				solarb.setSacoses(null);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
				solarb.setSafeciau2(null);
				solarb.setSahrciau2(null);
				solarb.setSacoarpt2(null);
				solarb.setSacoarps2(null);
				solarb.setSacoardt2(null);
				solarb.setSacoards2(null);
				solarb.setSacoartt2(null);
				solarb.setSacoarts2(null);
				solarb.setSacoset2(null);
				solarb.setSacoses2(null);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA.equals(arbtramexp.getTrcodigo())) {
				solarb.setSaferepr(null);
				solarb.setSahrrepr(null);
				solarb.setSainsopr(null);
				solarb.setSaininpr(null);
				solarb.setSateobpr(null);
				solarb.setSainmenp1(null);
				solarb.setSainmenp2(null);
				solarb.setSainmenpt(null);
				solarb.setSacope1(null);
				solarb.setSacope2(null);
				solarb.setSanrtelp(null);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(arbtramexp.getTrcodigo())) {
				if (Y41bConstantes.DECISION_ARBITRAJE_DESISTIMIENTO.equals(arbtramexp.getTrresotipo())) {
					solarb.setSafedesi(null);
				} else if (Y41bConstantes.DECISION_ARBITRAJE_INADMISION.equals(arbtramexp.getTrresotipo())) {
					solarb.setSafeinad(null);
					solarb.setTcmotina(null);
				} else if (Y41bConstantes.DECISION_ARBITRAJE_TRASLADO.equals(arbtramexp.getTrresotipo())) {
					solarb.setSacoortr(null);
				} else if (Y41bConstantes.DECISION_ARBITRAJE_ACUERDO.equals(arbtramexp.getTrresotipo())) {
					solarb.setSainreme(null);
				}
				arbexp.setExfecreso(null);
				arbexp.setExtipres(null);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(arbtramexp.getTrcodigo())) {
				solarb.setSafelaud(null);
				solarb.setSainvola(null);
				solarb.setSainfdla(null);
				solarb.setSacneuil(null);
				arbexp.setEximporteOtor(null);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE.equals(arbtramexp.getTrcodigo())) {
				solarb.setSafear(null);
				arbexp.setExfecfin(null);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION
					.equals(arbtramexp.getTrcodigo())) {
				solarb.setSafesoac(null);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION.equals(arbtramexp.getTrcodigo())) {
				arbexp.setExfecsubs(null);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_ALEGACIONES.equals(arbtramexp.getTrcodigo())) {
				arbexp.setExfecalegc(null);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_COPIA_EXPE
					.equals(arbtramexp.getTrcodigo())) {
				if (Y41bConstantes.TRAMITE_ARB_COPIA_EXPEDIENTE_ANULACION.equals(arbtramexp.getTrcopexptipo())) {
					solarb.setSainrain(null);
					solarb.setSafepeex(null);
				} else if (Y41bConstantes.TRAMITE_ARB_COPIA_EXPEDIENTE_EJECUCION.equals(arbtramexp.getTrcopexptipo())) {
					solarb.setSainefin(null);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE.equals(arbtramexp.getTrcodigo())) {
				solarb.setSaintiso(
						this.arbintervService.dameTipoArbitrajeReclamadoCenso(arbtramexp.getSolarb().getSacodigo()));
			}
			this.arbexpDao.update(arbexp);
			this.solarbDao.update(solarb);
		} catch (Exception e) {
			Arbtramexp4ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.Arbtramexp2Service#calculaUltimoTramiteArbExp(com
	 * .ejie.y41b.model.Arbexp)
	 */
	@Override
	public Arbtramexp calculaUltimoTramiteArbExp(Arbexp arbexp) {
		try {
			Solarb solarb = this.solarbDao.find(new Solarb(arbexp.getExcodigo()));

			Arbtramexp arbtramexpAux = new Arbtramexp();
			arbtramexpAux.setSolarb(solarb);
			arbtramexpAux.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			Pagination pagination = new Pagination();
			pagination.setSort("TRFECFIN DESC, TRID");
			pagination.setSord("DESC");

			Arbtramexp ultimotramiteGeneral = this.arbtramexpDao.dameUltimoTramiteTramitado(arbexp.getExcodigo());
			ultimotramiteGeneral.setSolarb(new Solarb(arbexp.getExcodigo()));

			List<Arbtramexp> listaSanTramExp = this.arbtramexpDao.findAll(arbtramexpAux, pagination);
			Arbtramexp ultimotramiteEntidad = null;
			PosibleTramite posibletramite = new PosibleTramite();
			boolean tramiteEncontrado = false;
			if (listaSanTramExp != null) {
				for (int i = 0; i < listaSanTramExp.size() && !tramiteEncontrado; i++) {
					arbtramexpAux = listaSanTramExp.get(i);
					posibletramite = new PosibleTramite();
					posibletramite.setTrposiblecodigoorigen(arbtramexpAux.getTrcodigo());
					Long sugierePosibleTramite = this.posibleTramiteDao.findAllCount(posibletramite);
					if (sugierePosibleTramite != 0) {
						/* es de entidad */
						ultimotramiteEntidad = arbtramexpAux;
						tramiteEncontrado = true;
					}
				}
			}
			arbexp.setArbtramexp(ultimotramiteGeneral);

			if (ultimotramiteEntidad != null) {
				arbexp.setArbtramexpEntidad(ultimotramiteEntidad);
				arbexp.setFase(ultimotramiteEntidad.getFase());
			} else {
				if (ultimotramiteGeneral == null || ultimotramiteGeneral.getFase() == null
						|| Y41bUtils.esNullOCadenaVacia(ultimotramiteGeneral.getFase().getFcodigo())) {
					arbexp.setFase(new Fase(Y41bConstantes.FASE_REGISTRO_ARBITRAJE));
				} else {
					arbexp.setFase(ultimotramiteGeneral.getFase());
				}
			}

			/*
			 * Arbexp arbexpAux = this.arbexpDao.findLobTablaTemporal(arbexp);
			 * if (arbexpAux != null) { arbexp.setHdte(arbexpAux.getHdte()); }
			 */
			this.arbexpDao.update(arbexp);

			return ultimotramiteGeneral;
		} catch (Exception e) {
			e.printStackTrace();
			Arbtramexp4ServiceImpl.logger.error("Error producido en actualizaUltimoTramiteEnSanExp: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a single row in the arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            the arbtramexp
	 */
	public void actualizaExpedienteTrasTramitar(Arbtramexp arbtramexp) {

		Solarb solarb = new Solarb();
		solarb.setSacodigo(arbtramexp.getSolarb().getSacodigo());
		solarb = this.solarbDao.find(solarb);

		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(arbtramexp.getSolarb().getSacodigo());
		arbexp = this.arbexpDao.find(arbexp);

		arbtramexp = this.arbtramexpDao.find(arbtramexp);
		/*
		 * if (arbexp != null) { Arbexp arbexpAux =
		 * this.arbexpDao.findLobTablaTemporal(arbexp); if (arbexpAux != null) {
		 * arbexp.setHdte(arbexpAux.getHdte()); } }
		 */

		if (Y41bConstantes.TRAMITE_ARBITRAJE_ASIGNACION_RESPONSABLE.equals(arbtramexp.getTrcodigo())) {
			arbexp.setExcodigo(arbtramexp.getSolarb().getSacodigo());
			arbexp.setExmocodigo(arbtramexp.getTrmonitor());
			this.arbexpDao.updateResponsable(arbexp);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO.equals(arbtramexp.getTrcodigo())
				|| (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA.equals(arbtramexp.getTrcodigo())
						&& solarb.getSacoarpt() == null)) {
			solarb.setSaintica(arbtramexp.getTrintica());
			solarb.setSafedeco(arbtramexp.getTrfecdesigna());

			Arbcolegio arbcolegio = new Arbcolegio();
			if (Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO.equals(arbtramexp.getTrcodigo())) {
				arbcolegio.setXjtrid(arbtramexp.getTrid());
			} else {
				arbcolegio.setXjtrid(arbtramexp.getTrtridrel());
			}
			arbcolegio = this.arbcolegioDao.find(arbcolegio);
			if (arbcolegio != null) {
				solarb.setSacoarpt(arbcolegio.getPresidenteT().getArcodigo());
				solarb.setSacoarps(arbcolegio.getPresidenteS().getArcodigo());
				solarb.setSacoardt(arbcolegio.getEmpresarialT().getArcodigo());
				solarb.setSacoards(arbcolegio.getEmpresarialS().getArcodigo());
				solarb.setSacoartt(arbcolegio.getConsumidorT().getArcodigo());
				solarb.setSacoarts(arbcolegio.getConsumidorS().getArcodigo());
				solarb.setSacoset(arbcolegio.getSecretarioT().getSrcodigo());
				solarb.setSacoses(arbcolegio.getSecretarioS().getSrcodigo());
			}

			this.solarbDao.update(solarb);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
			solarb.setSafeciau(arbtramexp.getTrfeccitacion());
			solarb.setSahrciau(arbtramexp.getTrhoracitacion());
			this.solarbDao.update(solarb);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_SUSPENSION_AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
			if (solarb.getSafeciau2() != null) {
				solarb.setSafeciau2(null);
				solarb.setSahrciau2(null);
			} else {
				solarb.setSafeciau(null);
				solarb.setSahrciau(null);
			}
			this.solarbDao.update(solarb);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
			solarb.setSafeciau2(arbtramexp.getTrfeccitacion());
			solarb.setSahrciau2(arbtramexp.getTrhoracitacion());
			Arbtramexp designa = new Arbtramexp();
			designa.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			designa.setSolarb(new Solarb(arbtramexp.getSolarb().getSacodigo()));
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECFIN");
			pagination.setSord("desc");
			List<Arbtramexp> ldesigna = this.arbtramexpDao.findAll(designa, pagination);
			if (ldesigna != null && ldesigna.size() > 0) {
				Arbcolegio arbcolegio = new Arbcolegio();
				arbcolegio.setXjtrid(ldesigna.get(0).getTrid());
				arbcolegio = this.arbcolegioDao.find(arbcolegio);
				if (arbcolegio != null) {
					solarb.setSacoarpt2(arbcolegio.getPresidenteT().getArcodigo());
					solarb.setSacoarps2(arbcolegio.getPresidenteS().getArcodigo());
					solarb.setSacoardt2(arbcolegio.getEmpresarialT().getArcodigo());
					solarb.setSacoards2(arbcolegio.getEmpresarialS().getArcodigo());
					solarb.setSacoartt2(arbcolegio.getConsumidorT().getArcodigo());
					solarb.setSacoarts2(arbcolegio.getConsumidorS().getArcodigo());
					solarb.setSacoset2(arbcolegio.getSecretarioT().getSrcodigo());
					solarb.setSacoses2(arbcolegio.getSecretarioS().getSrcodigo());
				}
			}
			this.solarbDao.update(solarb);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA.equals(arbtramexp.getTrcodigo())) {

			solarb.setSaferepr(arbtramexp.getTrfeccitacion());
			solarb.setSahrrepr(arbtramexp.getTrhoracitacion());
			solarb.setSainsopr(arbtramexp.getTrrealizadapor());
			solarb.setSaininpr(arbtramexp.getTrainstanciade());
			solarb.setSateobpr(Y41bUtils.clobToString(arbtramexp.getTrobjeto()));
			solarb.setSainmenp1(arbtramexp.getTrnotcomterceros());
			solarb.setSainmenp2(arbtramexp.getTrnotcomterceros());
			solarb.setSainmenpt(arbtramexp.getTrnotcomreclamante());
			solarb.setSacope1(arbtramexp.getTrcope1());
			solarb.setSacope2(arbtramexp.getTrcope2());
			// solarb.setSanolup(arbtramexp.getTrnodir());
			// solarb.setSanodirp(arbtramexp.getTrnombrePiso());
			// solarb.setSacolop(arbtramexp.getTrnoraLocalidadId());
			// solarb.setSanrcopop(arbtramexp.getTrnoraCpId());
			solarb.setSanrtelp(arbtramexp.getTrnrtel());
			this.solarbDao.update(solarb);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(arbtramexp.getTrcodigo())) {
			if (Y41bConstantes.DECISION_ARBITRAJE_DESISTIMIENTO.equals(arbtramexp.getTrresotipo())) {
				solarb.setSafedesi(arbtramexp.getTrresofecha());
			} else if (Y41bConstantes.DECISION_ARBITRAJE_INADMISION.equals(arbtramexp.getTrresotipo())) {
				solarb.setSafeinad(arbtramexp.getTrresofecha());
				solarb.setTcmotina(new Tcmotina(arbtramexp.getTrcot5(), null, null));
			} else if (Y41bConstantes.DECISION_ARBITRAJE_TRASLADO.equals(arbtramexp.getTrresotipo())) {
				solarb.setSacoortr(arbtramexp.getTrcoortr());
			} else if (Y41bConstantes.DECISION_ARBITRAJE_ACUERDO.equals(arbtramexp.getTrresotipo())) {
				solarb.setSainreme(Y41bConstantes.VALOR_SI);
			}
			this.solarbDao.update(solarb);
			arbexp.setExfecreso(arbtramexp.getTrresofecha());
			arbexp.setExtipres(arbtramexp.getTrresotipo());
			this.arbexpDao.update(arbexp);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(arbtramexp.getTrcodigo())) {
			solarb.setSafelaud(arbtramexp.getTrresofecha());
			solarb.setSainvola(arbtramexp.getTrmodolaudo());
			solarb.setSainfdla(arbtramexp.getTrresultado());
			solarb.setSacneuil(arbtramexp.getTrresoimporte());
			this.solarbDao.update(solarb);
			arbexp.setEximporteOtor(arbtramexp.getTrimpreconv().toString());
			this.arbexpDao.update(arbexp);
			/*
			 * } else if (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO
			 * .equals(arbtramexp.getTrcodigo())) {
			 * solarb.setSafeopla(arbtramexp.getTrfeopla());
			 * this.solarbDao.update(solarb);
			 */
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE.equals(arbtramexp.getTrcodigo())) {
			solarb.setSafear(arbtramexp.getTrfeccierre());
			this.solarbDao.update(solarb);
			arbexp.setExfecfin(arbtramexp.getTrfeccierre());
			this.arbexpDao.update(arbexp);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION.equals(arbtramexp.getTrcodigo())) {
			solarb.setSafesoac(arbtramexp.getTrfecrecepcion());
			this.solarbDao.update(solarb);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION.equals(arbtramexp.getTrcodigo())) {
			arbexp.setExfecsubs(arbtramexp.getTrfecrecepcion());
			this.arbexpDao.update(arbexp);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_ALEGACIONES.equals(arbtramexp.getTrcodigo())) {
			arbexp.setExfecalegc(arbtramexp.getTrfecrecepcion());
			// Importe de reconvencion
			if ("R".equals(arbtramexp.getTrtipoalega())) {
				arbexp.setEximporteSol(arbtramexp.getTrimporte().toString());
			}
			this.arbexpDao.update(arbexp);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_COPIA_EXPE.equals(arbtramexp.getTrcodigo())) {
			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setUaidinterv(arbtramexp.getTrainstcopia());
			arbinterv = this.arbintervDao.find(arbinterv);
			String instanciaDe = "";
			if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
					|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
							.equals(arbinterv.getUatipointerv())) {
				instanciaDe = Y41bConstantes.SAINEFIN_T;
			} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
					|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
							.equals(arbinterv.getUatipointerv())) {
				instanciaDe = Y41bConstantes.SAINEFIN_D;
			}
			if (Y41bConstantes.TRAMITE_ARB_COPIA_EXPEDIENTE_ANULACION.equals(arbtramexp.getTrcopexptipo())) {
				solarb.setSainrain(instanciaDe);
				solarb.setSafepeex(arbtramexp.getTrfecrecepcion());
			} else if (Y41bConstantes.TRAMITE_ARB_COPIA_EXPEDIENTE_EJECUCION.equals(arbtramexp.getTrcopexptipo())) {
				solarb.setSainefin(instanciaDe);
			}
			this.solarbDao.update(solarb);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE.equals(arbtramexp.getTrcodigo())) {
			solarb.setSaintiso(arbtramexp.getTrtipoarbitraje());
			this.solarbDao.updateTipoArbitraje(solarb);
		}
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteBOPVAyto
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteBOPVAyto findTramiteBOPVAyto(TramiteBOPVAyto tramite, CensoMonitor monitor)
			throws SQLException, IOException {
		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Arbtramexp arbtramexp = new Arbtramexp();
		String trid = tramite.getIdTramite();
		arbtramexp.setTrid(trid);
		arbtramexp = this.arbtramexpDao.find(arbtramexp);

		TramiteBOPVAyto tramiteAux = new TramiteBOPVAyto();
		tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
		tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
		tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
			instructorAsignado = arbtramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = arbtramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);
		tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

		/*
		 * PROPIO DEL TRAMITE
		 */
		tramiteAux.setFechaPublicacionBOPV(arbtramexp.getTrfecbopv());
		tramiteAux.setFechaPublicacionAyto(arbtramexp.getTrfecinitabl());
		tramiteAux.setFechaEnvioBOPVBOE(arbtramexp.getTrfechaenviobopvboe());

		if (arbtramexp.getTrtridrel() != null) {
			TramiteNotificacion tramiteNotificacionWhere = new TramiteNotificacion();
			tramiteNotificacionWhere.setIdTramite(arbtramexp.getTrtridrel().toString());
			TramiteNotificacion tramiteNotificacionRelacionado = this.arbtramexp3Service
					.findTramiteNotificacion(tramiteNotificacionWhere, censoMonitor);

			tramiteAux.setTramiteNotificacion(tramiteNotificacionRelacionado);
		}

		if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteElaboracionBOPVAyto
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteElaboracionBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteElaboracionBOPVAyto findTramiteElaboracionBOPVAyto(TramiteElaboracionBOPVAyto tramite,
			CensoMonitor monitor) throws SQLException, IOException {
		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Arbtramexp arbtramexp = new Arbtramexp();
		String trid = tramite.getIdTramite();
		arbtramexp.setTrid(trid);
		arbtramexp = this.arbtramexpDao.find(arbtramexp);

		TramiteElaboracionBOPVAyto tramiteAux = new TramiteElaboracionBOPVAyto();
		tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
		tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
		tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
			instructorAsignado = arbtramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = arbtramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);
		tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

		/*
		 * PROPIO DEL TRAMITE
		 */
		tramiteAux.setFechaPublicacionBOPV(arbtramexp.getTrfecbopv());
		tramiteAux.setFechaPublicacionAyto(arbtramexp.getTrfecinitabl());

		if (arbtramexp.getTrtridrel() != null) {
			TramiteNotificacion tramiteNotificacionWhere = new TramiteNotificacion();
			tramiteNotificacionWhere.setIdTramite(arbtramexp.getTrtridrel().toString());
			TramiteNotificacion tramiteNotificacionRelacionado = this.arbtramexp3Service
					.findTramiteNotificacion(tramiteNotificacionWhere, censoMonitor);

			tramiteAux.setTramiteNotificacion(tramiteNotificacionRelacionado);
		}

		if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	/**
	 * Tramitar BOPVAyto
	 * 
	 * @param tramite
	 *            TramiteBOPVAyto
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteBOPVAyto(TramiteBOPVAyto tramite, TramiteComun tramiteComun, boolean tramitar,
			String modoEditar, CensoMonitor censoMonitor) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			arbtramexp.setTrid(tramiteComun.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);
		}

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_PUBLICACION_BOPVBOE);
		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		// Propio del tramite
		arbtramexp.setTrfecbopv(tramite.getFechaPublicacionBOPV());
		arbtramexp.setTrfecinitabl(tramite.getFechaPublicacionAyto());
		arbtramexp.setTrfechaenviobopvboe(tramite.getFechaEnvioBOPVBOE());
		/*************************************************************
		 * ESPECIAL DE ESTE TRAMITE
		 */
		/*
		 * Prevalece la fecha del BOE Date fechaMayorBOPVAyunta =
		 * (tramite.getFechaPublicacionBOPV()
		 * .after(tramite.getFechaPublicacionAyto())) ? tramite
		 * .getFechaPublicacionBOPV() : tramite.getFechaPublicacionAyto();
		 */
		// Prevalece la del BOE
		Date fechaMayorBOPVAyunta = tramite.getFechaPublicacionAyto();
		/*************************************************************
		 * ESPECIAL DE ESTE TRAMITE
		 */

		arbtramexp.setTrid(tramiteComun.getIdTramite());
		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {

				// trato la recepci�n del acuse
				String idTramiteNotificacion = arbtramexp.getTrtridrel();
				Arbtramexp tramiteNotificacionOriginal = this.arbtramexpDao.find(new Arbtramexp(idTramiteNotificacion));

				// ACTUALIZACI�N DE FECHAS ETC.
				this.arbtramexp3Service.tratarAcuseRecogido(tramiteNotificacionOriginal, fechaMayorBOPVAyunta);

				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);

				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);

				Arbinterv arbinterv = new Arbinterv();
				arbinterv.setUaidinterv(tramiteNotificacionOriginal.getTruaidinterv());
				arbinterv = this.arbintervdao.find(arbinterv);

				if (arbinterv != null && arbinterv.getUatipointerv() != null
						&& (arbinterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE)
								|| arbinterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO)
								|| arbinterv.getUatipointerv()
										.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO)
								|| arbinterv.getUatipointerv()
										.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO)
								|| arbinterv.getUatipointerv()
										.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE)
								|| arbinterv.getUatipointerv().equals(
										Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO))) {
					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdTramite(tramiteNotificacionOriginal.getTrid().toString());
					List<Arbdoctemp> listDocumentos = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux,
							null);
					this.actualizarMisGestionesNotificacion(arbtramexp, listDocumentos, censoMonitor);
				}
			}
		} else {
			if (isDocPendienteFirma) {
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				Arbexp arbexp = new Arbexp();
				arbexp.setExcodigo(tramiteComun.getIdExpediente());
				arbexp = this.arbexpDao.find(arbexp);
				String faseExp = arbexp.getFase().getFcodigo();
				this.arbtramexp2Service.actualizarBandejaFirma(listDocumentoHecho, tramiteComun, faseExp,
						Y41bConstantes.TRAMITE_ARBITRAJE_PUBLICACION_BOPVBOE);

			} else {
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
			}
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * Tramitar BOPVAyto
	 * 
	 * @param tramite
	 *            TramiteElaboracionBOPVAyto
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteElaboracionBOPVAyto(TramiteElaboracionBOPVAyto tramite, TramiteComun tramiteComun,
			boolean tramitar, String modoEditar) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			arbtramexp.setTrid(tramiteComun.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);
		}

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ELABORACION_BOPVBOE);
		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		// Propio del tramite
		// arbtramexp.setTrfecbopv(tramite.getFechaPublicacionBOPV());
		// arbtramexp.setTrfecinitabl(tramite.getFechaPublicacionAyto());

		arbtramexp.setTrid(tramiteComun.getIdTramite());
		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				arbtramexp = this.arbtramexpDao.find(arbtramexp);
				Arbtramexp tramiteRelacionado = new Arbtramexp();
				tramiteRelacionado.setTrid(arbtramexp.getTrtridrel());
				tramiteRelacionado = this.arbtramexpDao.find(tramiteRelacionado);
				this.arbtramexp2Service.sugiereTramiteAutomaticamente(tramiteRelacionado,
						Y41bConstantes.TRAMITE_ARBITRAJE_PUBLICACION_BOPVBOE, arbtramexp.getFase().getFcodigo(), false);

				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);

				/*
				 * actualizamos los campos de la ficha del expediente si
				 * corresponde
				 */
				// this.arbtramexp2Service.actualizaExpediente(arbtramexp); SE
				// HACE AL RECOGER EL
				// ACUSE

				// Date fechaPublicacionAyto = arbtramexp.getTrfecinitabl();
				/*
				 * GENERAMOS AVISO EN BANDEJA CORESPONDIENTE, RESPECTO A FECHA
				 * DE PUBLICACION EN TABLON BOEMIENTO
				 */
				/*
				 * Arbexp arbexp = new Arbexp();
				 * arbexp.setExcodigo(arbtramexp.getSolarb().getSacodigo());
				 * arbexp = this.arbexpDao.find(arbexp); String duenioExp =
				 * arbexp.getExmocodigo(); CensoMonitor censoMonitor = new
				 * CensoMonitor(); censoMonitor.setMocodigo(duenioExp);
				 * censoMonitor = this.censoMonitorDao.find(censoMonitor);
				 * 
				 * Parametros parametros = new Parametros(); parametros
				 * .setParametro
				 * (Y41bConstantes.TRAMITE_ARBITRAJE_ELABORACION_BOPVBOE);
				 * parametros = this.parametrosDao.find(parametros); if
				 * (parametros != null) { Long numeroDias = new
				 * Long(parametros.getValor()); this.arbbandejaDao
				 * .aniadeAvisoBandejaDias( solarb, censoMonitor, numeroDias,
				 * "", "", arbtramexp.getTrid(), fechaPublicacionAyto,
				 * Y41bConstantes.TRAMITE_ARBITRAJE_ELABORACION_BOPVBOE); }
				 */

			}
		} else {
			if (isDocPendienteFirma) {
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				Arbexp arbexp = new Arbexp();
				arbexp.setExcodigo(tramiteComun.getIdExpediente());
				arbexp = this.arbexpDao.find(arbexp);
				String faseExp = arbexp.getFase().getFcodigo();
				this.arbtramexp2Service.actualizarBandejaFirma(listDocumentoHecho, tramiteComun, faseExp,
						Y41bConstantes.TRAMITE_ARBITRAJE_ELABORACION_BOPVBOE);

			} else {
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
			}
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param listDocumentos
	 *            List<Arbdoctemp>
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarMisGestionesAportaciondocumentacion(Arbtramexp arbtramexp, List<Arbdoctemp> listDocumentos)
			throws Exception {
		ActualizarMisGestiones actualizarMisGestiones1 = new ActualizarMisGestiones();
		ActualizarMisGestiones actualizarMisGestiones2 = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);

		Arbexp arbexp = new Arbexp();
		if (arbtramexp != null && arbtramexp.getSolarb() != null && arbtramexp.getSolarb().getSacodigo() != null) {
			arbexp.setExcodigo(arbtramexp.getSolarb().getSacodigo());
			Arbtramexp4ServiceImpl.logger.debug("SACODIGO: " + arbtramexp.getSolarb().getSacodigo());
		} else {
			arbexp.setExcodigo(arbtramexp.getTrexcodigo());
			Arbtramexp4ServiceImpl.logger.debug("TREXCODIGO: " + arbtramexp.getTrexcodigo());
		}

		arbexp = this.arbexpDao.find(arbexp);

		actualizarMisGestiones1.setProcedure(procedure);
		actualizarMisGestiones2.setProcedure(procedure);

		actualizarMisGestiones1.setIdParticipacion(arbexp.getExidparticipacionreclamante());
		actualizarMisGestiones2.setIdParticipacion(arbexp.getExidparticipacionreclamado());

		DatosPersona datosPersona1 = new DatosPersona();
		Arbinterv arbinterv = this.arbintervdao.dameInterviniente(arbtramexp.getSolarb().getSacodigo(),
				Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
		datosPersona1.setDni(arbinterv.getUanif().trim().toUpperCase());
		datosPersona1.setNombre(arbinterv.getUanombre());
		if (Y41bUtils.isFilled(arbinterv.getUaapellido1())) {
			datosPersona1.setApellido1(new StringBuffer(arbinterv.getUaapellido1()).toString());

			if (Y41bUtils.isFilled(arbinterv.getUaapellido2())) {
				datosPersona1.setApellido1(new StringBuffer(arbinterv.getUaapellido1()).append(" ")
						.append(arbinterv.getUaapellido2()).toString());
			}
		}
		datosPersona1.setMail(arbinterv.getUacoem());
		datosPersona1.setTelefono(arbinterv.getUanrtel());

		DatosPersona datosPersona2 = new DatosPersona();
		arbinterv = this.arbintervdao.dameInterviniente(arbtramexp.getSolarb().getSacodigo(),
				Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
		datosPersona2.setDni(arbinterv.getUanif());
		datosPersona2.setNombre(arbinterv.getUanombre());
		if (Y41bUtils.isFilled(arbinterv.getUaapellido1())) {
			datosPersona2.setApellido1(new StringBuffer(arbinterv.getUaapellido1()).toString());
			if (Y41bUtils.isFilled(arbinterv.getUaapellido2())) {
				datosPersona2.setApellido1(new StringBuffer(arbinterv.getUaapellido1()).append(" ")
						.append(arbinterv.getUaapellido2()).toString());
			}
		}
		datosPersona2.setMail(arbinterv.getUacoem());
		datosPersona2.setTelefono(arbinterv.getUanrtel());

		StringBuffer numeroExpediente = new StringBuffer();
		numeroExpediente.append(arbtramexp.getSolarb().damecodCompletoPlatea());

		actualizarMisGestiones1.setEjercicio(arbtramexp.getSolarb().getSanran().toString());
		actualizarMisGestiones2.setEjercicio(arbtramexp.getSolarb().getSanran().toString());

		actualizarMisGestiones1.setNumeroExpediente(numeroExpediente.toString());
		actualizarMisGestiones2.setNumeroExpediente(numeroExpediente.toString());
		actualizarMisGestiones1.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
		actualizarMisGestiones2.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		String proceedingsId = arbtramexpDao.getNewPKProceedingsPlatea().toString();
		actualizarMisGestiones1.setProceedingsID(proceedingsId);
		actualizarMisGestiones1.setDescripcionTramiteCas(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
		actualizarMisGestiones1.setDescripcionTramiteEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);

		actualizarMisGestiones2.setProceedingsID(proceedingsId);
		actualizarMisGestiones2.setDescripcionTramiteCas(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
		actualizarMisGestiones2.setDescripcionTramiteEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);

		List<Documento> listaDocumentosRdo1 = new ArrayList<Documento>();
		List<Documento> listaDocumentosRdo2 = new ArrayList<Documento>();
		Date fechaAportacion1 = null;
		Date fechaAportacion2 = null;
		if (listDocumentos != null && listDocumentos.size() > 0) {
			Documento documento1 = null;
			Documento documento2 = null;
			for (Arbdoctemp documentoHecho : listDocumentos) {
				if (documentoHecho.getX5origen() != null
						&& (documentoHecho.getX5origen().equals(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE)
								|| documentoHecho.getX5origen()
										.equals(Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE))) {
					if (fechaAportacion1 == null) {
						fechaAportacion1 = documentoHecho.getX5fechaentrada();
					} else if (documentoHecho.getX5fechaentrada() != null
							&& documentoHecho.getX5fechaentrada().after(fechaAportacion1)) {
						fechaAportacion1 = documentoHecho.getX5fechaentrada();
					}
					documento1 = new Documento();
					documento1.setNombre(documentoHecho.getX5nofile());
					documento1.setDescripcion(documentoHecho.getX5tedesfile());
					documento1.setOidDokusi(documentoHecho.getX5iddocumentum());
					String tipoDocumental = "";
					if (Y41bUtils.isFilled(documentoHecho.getX5tipodocumento())) {
						if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(documentoHecho.getX5pcodigo())) {
							Santipdoc santipdoc = new Santipdoc();
							santipdoc.setTdid(documentoHecho.getX5tipodocumento());
							santipdoc = this.santipdocDao.find(santipdoc);
							tipoDocumental = santipdoc.getIdTipodoc();
						} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(documentoHecho.getX5pcodigo())) {
							Arbtipdoc arbtipdoc = new Arbtipdoc();
							arbtipdoc.setTdid(documentoHecho.getX5tipodocumento());
							arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
							tipoDocumental = arbtipdoc.getIdTipodoc();
						} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(documentoHecho.getX5pcodigo())) {
							tipoDocumental = documentoHecho.getX5tipodocumento();
						}
					} else {
						tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
					}
					documento1.setTipoDocumental(tipoDocumental);
					listaDocumentosRdo1.add(documento1);
				} else if (documentoHecho.getX5origen() != null
						&& (documentoHecho.getX5origen().equals(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO)
								|| documentoHecho.getX5origen()
										.equals(Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO))) {
					if (fechaAportacion2 == null) {
						fechaAportacion2 = documentoHecho.getX5fechaentrada();
					} else if (documentoHecho.getX5fechaentrada() != null
							&& documentoHecho.getX5fechaentrada().after(fechaAportacion2)) {
						fechaAportacion2 = documentoHecho.getX5fechaentrada();
					}
					documento2 = new Documento();
					documento2.setNombre(documentoHecho.getX5nofile());
					documento2.setDescripcion(documentoHecho.getX5tedesfile());
					documento2.setOidDokusi(documentoHecho.getX5iddocumentum());
					String tipoDocumental = "";
					if (Y41bUtils.isFilled(documentoHecho.getX5tipodocumento())) {
						if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(documentoHecho.getX5pcodigo())) {
							Santipdoc santipdoc = new Santipdoc();
							santipdoc.setTdid(documentoHecho.getX5tipodocumento());
							santipdoc = this.santipdocDao.find(santipdoc);
							tipoDocumental = santipdoc.getIdTipodoc();
						} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(documentoHecho.getX5pcodigo())) {
							Arbtipdoc arbtipdoc = new Arbtipdoc();
							arbtipdoc.setTdid(documentoHecho.getX5tipodocumento());
							arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
							tipoDocumental = arbtipdoc.getIdTipodoc();
						} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(documentoHecho.getX5pcodigo())) {
							tipoDocumental = documentoHecho.getX5tipodocumento();
						}
					} else {
						tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
					}
					documento2.setTipoDocumental(tipoDocumental);
					listaDocumentosRdo2.add(documento2);
				}
			}
		}

		Calendar aportacionTimestamp = Calendar.getInstance();

		DateFormat hourFormat = new SimpleDateFormat("HH:mm:ss");

		// Los documentos son de origen interesado
		if (listaDocumentosRdo1 != null && listaDocumentosRdo1.size() > 0) {
			if (fechaAportacion1 != null) {
				String fechaAportacionSinHoras1 = Y41bUtils.parseDateToString(fechaAportacion1,
						Y41bConstantes.CASTELLANO);
				String fechaAportacionConHoras1 = "";
				fechaAportacionConHoras1 = new StringBuffer().append(fechaAportacionSinHoras1).append(" ")
						.append(hourFormat.format(arbtramexp.getTrfecini())).toString();
				aportacionTimestamp.setTime(
						Y41bUtils.parseDateTime(fechaAportacionConHoras1, new Locale(Y41bConstantes.CASTELLANO)));
				actualizarMisGestiones1.setAportacionTimestamp(aportacionTimestamp);
			}
			actualizarMisGestiones1.setSolicitante(datosPersona1);
			actualizarMisGestiones1.setDocumentos(listaDocumentosRdo1);
			if (Y41bUtils.interactuarConDokusi()) {
				y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones1);
			}
			arbtramexp.setTrproceedingsidplatea(actualizarMisGestiones1.getProceedingsID());
			this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
		}
		if (listaDocumentosRdo2 != null && listaDocumentosRdo2.size() > 0) {
			if (fechaAportacion2 != null) {
				String fechaAportacionSinHoras2 = Y41bUtils.parseDateToString(fechaAportacion2,
						Y41bConstantes.CASTELLANO);
				String fechaAportacionConHoras2 = "";
				fechaAportacionConHoras2 = new StringBuffer().append(fechaAportacionSinHoras2).append(" ")
						.append(hourFormat.format(arbtramexp.getTrfecini())).toString();
				aportacionTimestamp.setTime(
						Y41bUtils.parseDateTime(fechaAportacionConHoras2, new Locale(Y41bConstantes.CASTELLANO)));
				actualizarMisGestiones2.setAportacionTimestamp(aportacionTimestamp);
			}
			actualizarMisGestiones2.setSolicitante(datosPersona2);
			actualizarMisGestiones2.setDocumentos(listaDocumentosRdo2);
			if (Y41bUtils.interactuarConDokusi()) {
				// ///////////////////////////////////////
				// Si el interviniente es un reclamado, hay que registrarlo en
				// Platea si no se ha registrado previamente
				if (arbexp.getExpartrecl() == null || Y41bConstantes.VALOR_NO.equals(arbexp.getExpartrecl())) {
					CensoMonitor censoMonitor = this.censoMonitorDao.findCoordinadorArbitraje();
					// Registrar el reclamado en Platea
					this.arbintervService.actualizarParticipantPlatea(arbtramexp.getSolarb(), arbinterv, censoMonitor,
							false);

					// Actualizar a SI el indicador que permite saber si el
					// reclamado esta o no en Platea
					arbexp.setExpartrecl(Y41bConstantes.VALOR_SI);
					this.arbexpDao.actualizarParticipacionReclamado(arbexp);
				}
				// ///////////////////////////////////////
				y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones2);
			}
			arbtramexp.setTrproceedingsidplatea(actualizarMisGestiones2.getProceedingsID());
			this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
		}

	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param listDocumentos
	 *            List<DocumentoExpediente>
	 * @throws SQLException
	 */
	public void actualizarMisGestionesComunicacion(Arbtramexp tramiteComunicacion, List<Arbdoctemp> listDocumentos,
			CensoMonitor censoMonitor) throws SQLException {

		Arbexp arbexp = new Arbexp();
		if (tramiteComunicacion != null && tramiteComunicacion.getSolarb() != null
				&& tramiteComunicacion.getSolarb().getSacodigo() != null) {
			arbexp.setExcodigo(tramiteComunicacion.getSolarb().getSacodigo());
			Arbtramexp4ServiceImpl.logger.debug("SACODIGO: " + tramiteComunicacion.getSolarb().getSacodigo());
		} else {
			arbexp.setExcodigo(tramiteComunicacion.getTrexcodigo());
			Arbtramexp4ServiceImpl.logger.debug("TREXCODIGO: " + tramiteComunicacion.getTrexcodigo());
		}

		arbexp = this.arbexpDao.find(arbexp);

		Arbinterv arbinterv = this.arbintervdao.find(new Arbinterv(tramiteComunicacion.getTruaidinterv()));
		Arbinterv arbintervReclamado = this.arbintervdao.dameInterviniente(
				tramiteComunicacion.getSolarb().getSacodigo(), Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);

		// Si el interviniente es un reclamado, hay que registrarlo en
		// Platea si no se ha registrado previamente
		if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
				|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO.equals(arbinterv.getUatipointerv())
				|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO
						.equals(arbinterv.getUatipointerv())) {
			if (arbexp.getExpartrecl() == null || Y41bConstantes.VALOR_NO.equals(arbexp.getExpartrecl())) {
				// Calcular el coordinador del expediente, en caso de que no
				// venga
				if (censoMonitor == null) {
					censoMonitor = this.censoMonitorDao.findCoordinadorArbitraje();
				}
				// Registrar el reclamado en Platea
				this.arbintervService.actualizarParticipantPlatea(tramiteComunicacion.getSolarb(), arbintervReclamado,
						censoMonitor, false);

				// Actualizar a SI el indicador que permite saber si el
				// reclamado esta o no en Platea
				arbexp.setExpartrecl(Y41bConstantes.VALOR_SI);
				this.arbexpDao.actualizarParticipacionReclamado(arbexp);
			}
		}

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);

		actualizarMisGestiones.setProcedure(procedure);

		Arbtramexp tramiteRelacionado = null;
		if (tramiteComunicacion.getTrtridrel() != null) {
			tramiteRelacionado = this.arbtramexpDao.find(new Arbtramexp(tramiteComunicacion.getTrtridrel()));
			if (tramiteRelacionado != null) {
				this.actualizarMisGestiones(tramiteRelacionado, tramiteComunicacion.getTruaidinterv());
			}
		}

		// Reclamado o reclamante
		if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())) {
			actualizarMisGestiones.setSolicitante(arbintervService.cargarDatosPersona(arbinterv));
			actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamado());
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO.equals(arbinterv.getUatipointerv())
				|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO
						.equals(arbinterv.getUatipointerv())) {
			actualizarMisGestiones.setSolicitante(arbintervService.cargarDatosPersona(arbintervReclamado));
			actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamado());
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())) {
			actualizarMisGestiones.setSolicitante(arbintervService.cargarDatosPersona(arbinterv));
			actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamante());
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE.equals(arbinterv.getUatipointerv())
				|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO
						.equals(arbinterv.getUatipointerv())) {
			Arbinterv arbintervReclamante = this.arbintervdao.dameInterviniente(
					tramiteComunicacion.getSolarb().getSacodigo(), Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
			actualizarMisGestiones.setSolicitante(arbintervService.cargarDatosPersona(arbintervReclamante));
			actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamante());
		}

		actualizarMisGestiones.setEjercicio(tramiteComunicacion.getSolarb().getSanran().toString());

		actualizarMisGestiones.setNumeroExpediente(tramiteComunicacion.getSolarb().damecodCompletoPlatea());

		if (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(tramiteComunicacion.getTrtipocom())) {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
		} else {
			actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);
		}

		actualizarMisGestiones.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

		actualizarMisGestiones.setIdnotificacionplatea(tramiteComunicacion.getTridnotifplatea());

		List<Documento> listaDocumentosRdo = null;
		if (listDocumentos != null && listDocumentos.size() > 0) {
			listaDocumentosRdo = new ArrayList<Documento>();
			Documento documento = null;
			for (Arbdoctemp documentoHecho : listDocumentos) {
				documento = new Documento();
				documento.setNombre(documentoHecho.getX5nofile());
				documento.setDescripcion(documentoHecho.getX5tedesfile());
				documento.setOidDokusi(documentoHecho.getX5iddocumentum());
				String tipoDocumental = "";
				if (Y41bUtils.isFilled(documentoHecho.getX5tipodocumento())) {
					if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(documentoHecho.getX5pcodigo())) {
						Santipdoc santipdoc = new Santipdoc();
						santipdoc.setTdid(documentoHecho.getX5tipodocumento());
						santipdoc = this.santipdocDao.find(santipdoc);
						tipoDocumental = santipdoc.getIdTipodoc();
					} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(documentoHecho.getX5pcodigo())) {
						Arbtipdoc arbtipdoc = new Arbtipdoc();
						arbtipdoc.setTdid(documentoHecho.getX5tipodocumento());
						arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
						tipoDocumental = arbtipdoc.getIdTipodoc();
					} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(documentoHecho.getX5pcodigo())) {
						tipoDocumental = documentoHecho.getX5tipodocumento();
					}
				} else {
					tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
				}
				documento.setTipoDocumental(tipoDocumental);
				listaDocumentosRdo.add(documento);
			}
		}

		actualizarMisGestiones.setDocumentos(listaDocumentosRdo);
		if (Y41bUtils.interactuarConDokusi()) {
			y41bPlateaAdapterService.actualizarMisGestionesComunicacion(actualizarMisGestiones);
		}

		tramiteComunicacion.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
		this.arbtramexpDao.updateProceedingsIdPlatea(tramiteComunicacion);
	}

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param listDocumentos
	 *            List<Arbdoctemp>
	 * @throws SQLException
	 * @throws ParseException
	 */
	public void actualizarMisGestionesNotificacion(Arbtramexp arbtramexp, List<Arbdoctemp> listDocumentos,
			CensoMonitor censoMonitor) throws SQLException, ParseException {

		Arbexp arbexp = new Arbexp();
		if (arbtramexp != null && arbtramexp.getSolarb() != null && arbtramexp.getSolarb().getSacodigo() != null) {
			arbexp.setExcodigo(arbtramexp.getSolarb().getSacodigo());
			Arbtramexp4ServiceImpl.logger.debug("SACODIGO: " + arbtramexp.getSolarb().getSacodigo());
		} else {
			arbexp.setExcodigo(arbtramexp.getTrexcodigo());
			Arbtramexp4ServiceImpl.logger.debug("TREXCODIGO: " + arbtramexp.getTrexcodigo());
		}

		arbexp = this.arbexpDao.find(arbexp);

		Arbtramexp acuseRelacionado = null;
		if (Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO.equals(arbtramexp.getTrcodigo())) {
			acuseRelacionado = arbtramexp;
		} else {
			// Buscamos un acuse con la misma notificacion relacionada
			Arbtramexp arbtramexpAux = new Arbtramexp();
			arbtramexpAux.setSolarb(new Solarb(arbtramexp.getSolarb().getSacodigo()));
			arbtramexpAux.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO);
			arbtramexpAux.setTrtridrel(arbtramexp.getTrtridrel());
			List<Arbtramexp> listaArbtramexp = this.arbtramexpDao.findAll(arbtramexpAux, null);
			if (listaArbtramexp != null && listaArbtramexp.size() > 0) {
				acuseRelacionado = listaArbtramexp.get(0);
			}
		}

		Arbtramexp tramiteNotificacion = null;
		if (acuseRelacionado.getTrtridrel() != null) {
			tramiteNotificacion = this.arbtramexpDao.find(new Arbtramexp(acuseRelacionado.getTrtridrel()));

			if (tramiteNotificacion != null) {

				Arbinterv arbinterv = this.arbintervdao.find(new Arbinterv(tramiteNotificacion.getTruaidinterv()));
				Arbinterv arbintervReclamado = this.arbintervdao.dameInterviniente(arbtramexp.getSolarb().getSacodigo(),
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);

				// Si el interviniente es un reclamado, hay que registrarlo en
				// Platea si no se ha registrado previamente
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO
								.equals(arbinterv.getUatipointerv())) {
					if (arbexp.getExpartrecl() == null || Y41bConstantes.VALOR_NO.equals(arbexp.getExpartrecl())) {
						// Registrar el reclamado en Platea
						this.arbintervService.actualizarParticipantPlatea(arbtramexp.getSolarb(), arbintervReclamado,
								censoMonitor, false);

						// Actualizar a SI el indicador que permite saber si el
						// reclamado esta o no en Platea
						arbexp.setExpartrecl(Y41bConstantes.VALOR_SI);
						this.arbexpDao.actualizarParticipacionReclamado(arbexp);
					}
				}

				Arbtramexp tramiteRelacionado = null;
				if (arbtramexp.getTrtridrel() != null) {
					tramiteRelacionado = this.arbtramexpDao.find(new Arbtramexp(tramiteNotificacion.getTrtridrel()));
					if (tramiteRelacionado != null) {
						this.actualizarMisGestiones(tramiteRelacionado, tramiteNotificacion.getTruaidinterv());
					}
				}

				ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

				Procedure procedure = new Procedure();
				procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);

				actualizarMisGestiones.setProcedure(procedure);

				// Reclamado o reclamante
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())) {
					actualizarMisGestiones.setSolicitante(arbintervService.cargarDatosPersona(arbinterv));
					actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamado());
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
						.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO
								.equals(arbinterv.getUatipointerv())) {
					actualizarMisGestiones.setSolicitante(arbintervService.cargarDatosPersona(arbintervReclamado));
					actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamado());
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())) {
					actualizarMisGestiones.setSolicitante(arbintervService.cargarDatosPersona(arbinterv));
					actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamante());
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
						.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO
								.equals(arbinterv.getUatipointerv())) {
					Arbinterv arbintervReclamante = this.arbintervdao.dameInterviniente(
							arbtramexp.getSolarb().getSacodigo(), Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
					actualizarMisGestiones.setSolicitante(arbintervService.cargarDatosPersona(arbintervReclamante));
					actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamante());
				}

				actualizarMisGestiones.setEjercicio(arbtramexp.getSolarb().getSanran().toString());

				actualizarMisGestiones.setNumeroExpediente(arbtramexp.getSolarb().damecodCompletoPlatea());

				actualizarMisGestiones.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				actualizarMisGestiones.setIdnotificacionplatea(tramiteNotificacion.getTridnotifplatea());
				actualizarMisGestiones.setIdTiponotificacionplatea(tramiteNotificacion.getTrtiponotplatea());

				Calendar notificacionPublicationTimestamp = Calendar.getInstance();
				notificacionPublicationTimestamp.setTime(tramiteNotificacion.getTrfecfin());
				actualizarMisGestiones.setNotificacionPublicationTimestamp(notificacionPublicationTimestamp);
				if (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(tramiteNotificacion.getTrtiponot())) {
					actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
				} else {
					actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.POSTAL);
				}

				Calendar notificacionDeliveryTimestamp = Calendar.getInstance();
				notificacionDeliveryTimestamp.setTime(acuseRelacionado.getTrfecacuse());
				actualizarMisGestiones.setNotificacionDeliveryTimestamp(notificacionDeliveryTimestamp);
				if (Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO.equals(arbtramexp.getTrcodigo())) {
					actualizarMisGestiones.setSituacionNotificacionAcuseRecibo(acuseRelacionado.getTrestadoacuse());
				} else {
					actualizarMisGestiones.setSituacionNotificacionAcuseRecibo(Y41bUtils
							.formatearDateToString(arbtramexp.getTrfecinitabl(), Y41bConstantes.FORMATO_FECHA_ES)
							.concat("@").concat(Y41bUtils.formatearDateToString(arbtramexp.getTrfecinitabl(),
									Y41bConstantes.FORMATO_FECHA_EU)));
				}

				List<Documento> listaDocumentosRdo = null;
				if (listDocumentos != null && listDocumentos.size() > 0) {
					listaDocumentosRdo = new ArrayList<Documento>();
					Documento documento = null;
					for (Arbdoctemp documentoHecho : listDocumentos) {
						documento = new Documento();
						documento.setNombre(documentoHecho.getX5nofile());
						documento.setDescripcion(documentoHecho.getX5tedesfile());
						documento.setOidDokusi(documentoHecho.getX5iddocumentum());
						String tipoDocumental = "";
						if (Y41bUtils.isFilled(documentoHecho.getX5tipodocumento())) {
							if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(documentoHecho.getX5pcodigo())) {
								Santipdoc santipdoc = new Santipdoc();
								santipdoc.setTdid(documentoHecho.getX5tipodocumento());
								santipdoc = this.santipdocDao.find(santipdoc);
								tipoDocumental = santipdoc.getIdTipodoc();
							} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(documentoHecho.getX5pcodigo())) {
								Arbtipdoc arbtipdoc = new Arbtipdoc();
								arbtipdoc.setTdid(documentoHecho.getX5tipodocumento());
								arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
								tipoDocumental = arbtipdoc.getIdTipodoc();
							} else if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(documentoHecho.getX5pcodigo())) {
								tipoDocumental = documentoHecho.getX5tipodocumento();
							}
						} else {
							tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
						}
						documento.setTipoDocumental(tipoDocumental);
						listaDocumentosRdo.add(documento);
					}
				}

				actualizarMisGestiones.setDocumentos(listaDocumentosRdo);
				if (Y41bUtils.interactuarConDokusi()) {
					y41bPlateaAdapterService.actualizarMisGestionesNotificacion(actualizarMisGestiones);
				}

				arbtramexp.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);

			}
		}
	}

	/**
	 * @param arbtramexp
	 *            Arbtramexp
	 * @throws SQLException
	 *             SQLException
	 */
	private void actualizarMisGestiones(Arbtramexp arbtramexp, BigDecimal truaidinterv) throws SQLException {
		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);

		actualizarMisGestiones.setProcedure(procedure);

		Arbexp arbexp = new Arbexp();
		if (arbtramexp != null && arbtramexp.getSolarb() != null && arbtramexp.getSolarb().getSacodigo() != null) {
			arbexp.setExcodigo(arbtramexp.getSolarb().getSacodigo());
			Arbtramexp4ServiceImpl.logger.debug("SACODIGO: " + arbtramexp.getSolarb().getSacodigo());
		} else {
			arbexp.setExcodigo(arbtramexp.getTrexcodigo());
			Arbtramexp4ServiceImpl.logger.debug("TREXCODIGO: " + arbtramexp.getTrexcodigo());
		}

		arbexp = this.arbexpDao.find(arbexp);

		DatosPersona datosPersona = new DatosPersona();
		Arbinterv arbinterv = this.arbintervdao.find(new Arbinterv(truaidinterv));

		// Sacamos al titular de la participacion
		if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())) {
			actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamado());
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO.equals(arbinterv.getUatipointerv())
				|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO
						.equals(arbinterv.getUatipointerv())) {
			arbinterv = this.arbintervDao.dameInterviniente(arbtramexp.getSolarb().getSacodigo(),
					Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
			actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamado());
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())) {
			actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamante());
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE.equals(arbinterv.getUatipointerv())
				|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO
						.equals(arbinterv.getUatipointerv())) {
			arbinterv = this.arbintervDao.dameInterviniente(arbtramexp.getSolarb().getSacodigo(),
					Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
			actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamante());
		}

		datosPersona.setDni(arbinterv.getUanif().trim().toUpperCase());
		datosPersona.setNombre(arbinterv.getUanombre());
		if (Y41bUtils.isFilled(arbinterv.getUaapellido1())) {
			datosPersona.setApellido1(new StringBuffer(arbinterv.getUaapellido1()).toString());

			if (Y41bUtils.isFilled(arbinterv.getUaapellido2())) {
				datosPersona.setApellido1(new StringBuffer(arbinterv.getUaapellido1()).append(" ")
						.append(arbinterv.getUaapellido2()).toString());
			}
		}
		datosPersona.setMail(arbinterv.getUacoem());
		datosPersona.setTelefono(arbinterv.getUanrtel());

		actualizarMisGestiones.setSolicitante(datosPersona);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(arbtramexp.getSolarb().damecodCompletoPlatea());

		actualizarMisGestiones.setEjercicio(arbtramexp.getSolarb().getSanran().toString());

		actualizarMisGestiones.setNumeroExpediente(numeroExpediente.toString());

		actualizarMisGestiones.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
			actualizarMisGestiones.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
		} else {
			actualizarMisGestiones.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());
		}
		boolean actualizar = false;
		boolean esResolucion = false;
		if (Y41bConstantes.TRAMITE_ARBITRAJE_SUBSANACION.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_SUBSANACION_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_SUBSANACION_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_NO_ADHERIDA.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_ADHERIDA_LIM.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_RESULTADO_ANALISIS_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_RESULTADO_ANALISIS_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_CONVENIO_ARBITRAL_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_CONVENIO_ARBITRAL_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_ALEGACIONES.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_RECEPCION_ALEGACIONES_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_RECEPCION_ALEGACIONES_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_DESIGNACION_COLEGIO_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_DESIGNACION_COLEGIO_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_CITACION_AUDIENCIA_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_CITACION_AUDIENCIA_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_SUSPENSION_AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_SUSPENSION_AUDIENCIA_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_SUSPENSION_AUDIENCIA_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_AUDIENCIA_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_AUDIENCIA_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_CITACION_A_PRUEBA_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_CITACION_A_PRUEBA_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_CITACION_2AUDIENCIA_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_CITACION_2AUDIENCIA_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_2AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_2AUDIENCIA_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_2AUDIENCIA_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_LAUDO_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_LAUDO_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_ACLARACION_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_ACLARACION_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_RECEPCION_SOLICITUD_ACLARACION_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_RECEPCION_SOLICITUD_ACLARACION_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_RECEPCION_INFORME_PERICIAL_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_RECEPCION_INFORME_PERICIAL_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_PAGO_PERICIAL_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_PAGO_PERICIAL_EU);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(arbtramexp.getTrcodigo())) {
			actualizar = true;
			esResolucion = true;
			actualizarMisGestiones.setDescripcionTramiteCas(Y41bConstantes.LITERAL_RESOLUCION_ES);
			actualizarMisGestiones.setDescripcionTramiteEus(Y41bConstantes.LITERAL_RESOLUCION_EU);
			Decision decision = new Decision();
			decision.setDecodigo(arbtramexp.getTrresotipo());
			decision = this.decisionDao.find(decision);
			actualizarMisGestiones.setDecisionCas(decision.getDenombre());
			actualizarMisGestiones.setDecisionEus(decision.getDenombree());
			Calendar decisionTimestamp = Calendar.getInstance();
			decisionTimestamp.setTime(arbtramexp.getTrresofecha());
			actualizarMisGestiones.setDecisionTimestamp(decisionTimestamp);
		}

		if (actualizar) {
			if (Y41bUtils.interactuarConDokusi()) {
				if (esResolucion) {
					this.y41bPlateaAdapterService.actualizarMisGestionesDecision(actualizarMisGestiones);
				} else {
					this.y41bPlateaAdapterService.actualizarMisGestiones(actualizarMisGestiones);
				}
			}
			arbtramexp.setTrproceedingsidplatea(actualizarMisGestiones.getProceedingsID());
			this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
		}
	}

	/**
	 * Metodo que elimina en Mis Gestiones
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @throws SQLException
	 */
	public void eliminarMisGestiones(Arbtramexp arbtramexp) throws SQLException {

		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(arbtramexp.getTrexcodigo());

		arbexp = this.arbexpDao.find(arbexp);

		ActualizarMisGestiones actualizarMisGestiones = new ActualizarMisGestiones();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);

		actualizarMisGestiones.setProcedure(procedure);

		Arbinterv arbinterv = null;
		DatosPersona datosPersona = new DatosPersona();
		if (arbtramexp.getTruaidinterv() != null) {
			arbinterv = this.arbintervdao.find(new Arbinterv(arbtramexp.getTruaidinterv()));

			// Sacamos al titular de la participacion para obtener el id de la
			// participacion
			if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO.equals(arbinterv.getUatipointerv())) {
				arbinterv = this.arbintervDao.dameInterviniente(arbtramexp.getSolarb().getSacodigo(),
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamado());
			} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
					.equals(arbinterv.getUatipointerv())) {
				arbinterv = this.arbintervDao.dameInterviniente(arbtramexp.getSolarb().getSacodigo(),
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
				actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamante());
			}

			datosPersona.setDni(arbinterv.getUanif().trim().toUpperCase());
			datosPersona.setNombre(arbinterv.getUanombre());
			actualizarMisGestiones.setSolicitante(datosPersona);
			actualizarMisGestiones.setEjercicio(arbtramexp.getSolarb().getSanran().toString());
			actualizarMisGestiones.setNumeroExpediente(arbtramexp.getSolarb().damecodCompletoPlatea());
			actualizarMisGestiones.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			if (Y41bUtils.interactuarConDokusi()) {
				y41bPlateaAdapterService.eliminarMisGestiones(actualizarMisGestiones);
			}
		} else {
			arbinterv = this.arbintervdao.dameInterviniente(arbtramexp.getSolarb().getSacodigo(),
					Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
			datosPersona.setDni(arbinterv.getUanif().trim().toUpperCase());
			datosPersona.setNombre(arbinterv.getUanombre());
			actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamante());
			actualizarMisGestiones.setSolicitante(datosPersona);
			actualizarMisGestiones.setEjercicio(arbtramexp.getSolarb().getSanran().toString());
			actualizarMisGestiones.setNumeroExpediente(arbtramexp.getSolarb().damecodCompletoPlatea());
			actualizarMisGestiones.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			if (Y41bUtils.interactuarConDokusi()) {
				y41bPlateaAdapterService.eliminarMisGestiones(actualizarMisGestiones);
			}
			arbinterv = this.arbintervdao.dameInterviniente(arbtramexp.getSolarb().getSacodigo(),
					Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
			datosPersona.setDni(arbinterv.getUanif());
			datosPersona.setNombre(arbinterv.getUanombre());
			actualizarMisGestiones.setIdParticipacion(arbexp.getExidparticipacionreclamado());
			actualizarMisGestiones.setSolicitante(datosPersona);
			actualizarMisGestiones.setEjercicio(arbtramexp.getSolarb().getSanran().toString());
			actualizarMisGestiones.setNumeroExpediente(arbtramexp.getSolarb().damecodCompletoPlatea());
			actualizarMisGestiones.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			if (Y41bUtils.interactuarConDokusi()) {
				y41bPlateaAdapterService.eliminarMisGestiones(actualizarMisGestiones);
			}
		}

	}

	/**
	 * Inserts a single row in the Arbtramexp table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteGenerico(TramiteGenerico tramiteGenerico, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		Arbtramexp arbtramexp = new Arbtramexp();
		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setTrfecini(tramiteGenerico.getFechaInicio());
		if (tramitar) {
			arbtramexp.setTrfecfin(tramiteGenerico.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramiteGenerico.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_GENERICO);
		arbtramexp.setFase(solarb.getArbexp().getFase());

		arbtramexp.setCensoMonitor(tramiteGenerico.getInstructorAsignado());
		arbtramexp.setTrnomtrames(tramiteGenerico.getNombreTramite());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramiteGenerico.getComentario()));

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		if (tramitar) {
			this.arbtramexp2Service.actualizaBandeja(arbtramexp);
			this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
		} else {
			this.arbtramexp2Service.actualizaBandeja(arbtramexp);
		}

		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param monitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteGenerico findTramiteGenerico(TramiteGenerico tramiteGenerico, CensoMonitor monitor) {

		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Arbtramexp arbtramexp = new Arbtramexp();
		String trid = tramiteGenerico.getIdTramite();
		arbtramexp.setTrid(trid);
		arbtramexp = this.arbtramexpDao.find(arbtramexp);

		TramiteGenerico tramiteGenericoAux = new TramiteGenerico();
		tramiteGenericoAux.setIdTramite(arbtramexp.getTrid().toString());
		tramiteGenericoAux.setFechaInicio(arbtramexp.getTrfecini());
		tramiteGenericoAux.setFechaFin(arbtramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
			instructorAsignado = arbtramexp.getCensoMonitor();
		}
		tramiteGenericoAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = arbtramexp.getCensoMonitorEj();
		}
		tramiteGenericoAux.setInstructorEjecucion(instructorEjecucion);

		tramiteGenericoAux.setEstadoTramite(arbtramexp.getTrestado());
		tramiteGenericoAux.setNombreTramite(arbtramexp.getTrnomtrames());

		tramiteGenericoAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

		if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
			tramiteGenericoAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteGenericoAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteGenericoAux;
	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	public TramiteCierre findTramiteCierre(TramiteCierre tramiteCierre, CensoMonitor monitor) {

		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Arbtramexp arbtramexp = new Arbtramexp();
		String trid = tramiteCierre.getIdTramite();
		arbtramexp.setTrid(trid);
		arbtramexp = this.arbtramexpDao.find(arbtramexp);

		TramiteCierre tramite = new TramiteCierre();
		tramite.setIdTramite(arbtramexp.getTrid().toString());
		tramite.setFechaInicio(arbtramexp.getTrfecini());
		tramite.setFechaFin(arbtramexp.getTrfecfin());
		// 0173623: Cierre de expedientes
		tramite.setExcluirCierre(arbtramexp.getTrExcluirCierre());
		// 0173623: Cierre de expedientes
		CensoMonitor instructorAsignado = new CensoMonitor();
		if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
			instructorAsignado = arbtramexp.getCensoMonitor();
		}
		tramite.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = arbtramexp.getCensoMonitorEj();
		}
		tramite.setInstructorEjecucion(instructorEjecucion);

		tramite.setEstadoTramite(arbtramexp.getTrestado());
		tramite.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));
		tramite.setFechaCierre(arbtramexp.getTrfeccierre());

		if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
			tramite.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramite.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramite;
	}

	/**
	 * Tramitar cierre.
	 * 
	 * @param tramiteCierre
	 *            the tramite cierre
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteCierre(TramiteCierre tramiteCierre, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		Arbtramexp4ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteCierre.EXPEIDENTE:"
				+ tramiteComun.getIdExpediente() + ".IDTRAMITE: " + tramiteComun.getIdTramite() + ".");

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE);

		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			arbtramexp = this.arbtramexpDao.find(arbtramexp);
		}

		String idExpediente = tramiteCierre.getIdExpediente();

		if (tramitar) {

			/* CANCELAMOS EL AVISO SOBRE EL PLAZO RECURSO DE ALZADA */
			Arbtramexp4ServiceImpl.logger.info(
					"ArbbandejaDaoImpl - addTramiteElaboracionInformeAsesoria - Elimino aviso sobre recurso de alzada ");
			Pagination pagination = new Pagination();
			pagination.setSort("ABFECLIMITE");
			pagination.setSord("ASC");

			Arbbandeja arbbandeja = new Arbbandeja();
			arbbandeja.setSolarb(new Solarb(tramiteComun.getIdExpediente()));
			// arbbandeja
			// .setBatipo(Y41bConstantes.TIPO_AVISO_ARBITRAJE_NOTIFICACION_RESOLUCION);
			List<Arbbandeja> listaAvisosCancelar = this.arbbandejaDao.findAll(arbbandeja, pagination);
			if ((listaAvisosCancelar != null) && (listaAvisosCancelar.size() > 0)) {
				// Borramos todos los avisos
				for (int i = 0; i < listaAvisosCancelar.size(); i++) {
					this.arbbandejaDao.remove(listaAvisosCancelar.get(i));
				}
			}

			arbtramexp.setTrfecfin(tramiteCierre.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramiteCierre.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(idExpediente);
		solarb = this.solarbDao.find(solarb);

		// no cambiamos la fase

		arbtramexp.setTrfecini(tramiteCierre.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE);
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_CIERRE_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramiteCierre.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramiteCierre.getComentario()));

		arbtramexp.setTrfeccierre(tramiteCierre.getFechaCierre());

		arbtramexp.setTrExcluirCierre(tramiteCierre.getExcluirCierre());

		this.arbtramexp2Service.setArbtramexp(arbtramexp);

		boolean isTramiteCierre = this.existenMasTramites(tramiteCierre.getIdExpediente(), tramiteCierre.getIdTramite(),
				Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE);
		if (isTramiteCierre) {
			throw new Y41bUDAException("error.tramiteCierre.existeCierre", true, null);
		}

		if (tramitar) {
			// if (!this.isAllTramitesTramitados(idExpediente)) {
			// throw new Y41bUDAException(
			// "error.tramiteCierre.tramitesPendientes", true, null);
			// }

			this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);

			/* Se vaca la bandeja, con lo que tambien se borra el aviso */
			this.arbbandejaDao.removeAllEntradas(tramiteCierre.getIdExpediente());

			this.actualizaExpedienteTrasTramitar(arbtramexp);

			this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteCierre.getIdExpediente(),
					Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE);

			// 5. Cerramos el expediente en PLATEA
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(solarb.damecodCompletoPlatea());
			CierreExpediente cierreExpediente = new CierreExpediente();
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
			cierreExpediente.setProcedure(procedure);
			cierreExpediente.setNumeroExpediente(numeroExpediente.toString());
			cierreExpediente.setEjercicio(solarb.getSanran().toString());
			Arbtramexp4ServiceImpl.logger.info("ArbtramexpServiceImpl. - cerrarExpediente. Inicio Llamada a Platea");
			if (Y41bUtils.interactuarConDokusi()) {
				this.y41bPlateaAdapterService.cerrarExpediente(cierreExpediente);
			}
			Arbtramexp4ServiceImpl.logger.info("ArbtramexpServiceImpl. - cerrarExpediente. Fin Llamada a Platea");
		} else {
			this.arbtramexp2Service.actualizaBandeja(arbtramexp);
		}

		return arbtramexp;
	}

	/**
	 * Busca en el expediente si existe para un tipo de tramite, algun tramite
	 * que no sea el tramite recibido por parametro.
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param idTipoTramite
	 *            String
	 * @return true si existe / false si no existe
	 */
	private boolean existenMasTramites(String idExpediente, String idTramite, String idTipoTramite) {
		Arbtramexp tramitehechoAux = new Arbtramexp();
		tramitehechoAux.setSolarb(new Solarb(idExpediente));
		tramitehechoAux.setTrcodigo(idTipoTramite);
		List<Arbtramexp> listaTramitesCierre = this.arbtramexpDao.findAll(tramitehechoAux, null);
		if (listaTramitesCierre != null && listaTramitesCierre.size() > 0) {
			for (Arbtramexp tramitehechoCierre : listaTramitesCierre) {
				if (!idTramite.equals(tramitehechoCierre.getTrid().toString())) {
					// En caso de que haya algun tramite que sea de cierre en el
					// expediente y no sea el recibido por parametro
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBLaudo
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteLaudo(TramiteARBLaudo tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoARBLaudo) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_RESOLUCION_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

		arbtramexp.setTrresofecha(tramite.getFecha());
		arbtramexp.setTrresoimporte(Y41bUtils.esNullOCadenaVacia(tramite.getImporte()) ? null
				: new BigDecimal(tramite.getImporte().replace('\u002c', '\u002e')));
		arbtramexp.setTrimpreconv(Y41bUtils.esNullOCadenaVacia(tramite.getImpReconv()) ? null
				: new BigDecimal(tramite.getImpReconv().replace('\u002c', '\u002e')));
		arbtramexp.setTrresultado(tramite.getResultado());
		arbtramexp.setTrmodolaudo(tramite.getModo());
		arbtramexp.setTrrespmotiv(tramite.getRespMotiv());
		arbtramexp.setTrdecision(Y41bUtils.stringToClob(tramite.getDecision()));

		arbtramexp.setTrnotcomreclamado(tramite.getNotComReclamado());
		arbtramexp.setTrnotcomreclamante(tramite.getNotComReclamante());
		arbtramexp.setTrnotcomterceros(tramite.getNotComOtros());

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// 0155021 tengo que coger todos los documentos que habia en la tabla
		// definitiva para este tramite,
		// con esa lista voy mirando uno por uno y los voy borrando de la tabla
		// DOcumentosFirmaArbitros
		// Cojo todos los registros de DocumentosFirmaArbitrosTemp y los inserto
		// en DocumentosFirmaArbitros

		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5tramite(tramiteComun.getIdTramite());
		documentoHecho.setQ5hdcodigo(tramiteComun.getIdExpediente());
		// borramos de la final todo lo que encontremos la final que sea de ese
		// tramite
		List<DocumentoHecho> listParaBorrarDocumentosFirmaArbitros = this.documentoHechoDao.findAll(documentoHecho,
				null);
		for (DocumentoHecho documentoParaBorrarDocumentosFirmaArbitrosTemp : listParaBorrarDocumentosFirmaArbitros) {
			DocumentosFirmaArbitros docuABorrar = new DocumentosFirmaArbitros();
			docuABorrar.setIddocumentosfirmaarb(documentoParaBorrarDocumentosFirmaArbitrosTemp.getQ5codocumento());
			this.documentosFirmaArbitrosDao.remove(docuABorrar);
		}
		Adjuntardocs ajuntardocsDocumentosFirmaArbitros = new Adjuntardocs();
		ajuntardocsDocumentosFirmaArbitros.setThidTramite(tramiteComun.getIdTramite());
		List<Adjuntardocs> listArbdoctempdocs = this.adjuntardocsDao.findAll(ajuntardocsDocumentosFirmaArbitros, null);
		// insertamos en la final todo lo que encontremos en la temporal y la
		// borramos de la temporal;
		for (Adjuntardocs documentoAInsertarDocumentosFirmaArbitros : listArbdoctempdocs) {
			DocumentosFirmaArbitros docuAInsertar = new DocumentosFirmaArbitros();
			docuAInsertar.setIddocumentosfirmaarb(documentoAInsertarDocumentosFirmaArbitros.getThcodocumento());
			DocumentosFirmaArbitrosTemp docuTemporal = new DocumentosFirmaArbitrosTemp();
			docuTemporal.setIddocumentosfirmaarbtemp(documentoAInsertarDocumentosFirmaArbitros.getThcodocumento());
			docuTemporal = this.documentosFirmaArbitrosTempDao.find(docuTemporal);
			if (docuTemporal != null) {
				this.documentosFirmaArbitrosDao.add(docuAInsertar);

				DocumentosFirmaArbitrosTemp docuTempABorrar = new DocumentosFirmaArbitrosTemp();
				docuTempABorrar
						.setIddocumentosfirmaarbtemp(documentoAInsertarDocumentosFirmaArbitros.getThcodocumento());
				this.documentosFirmaArbitrosTempDao.remove(docuTempABorrar);
			}

		}
		// 0155021

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);

		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		Arbtramexp4ServiceImpl.logger.info(
				"PORTAFIRMAS -Arbtramexp4ServiceImpl - addTramiteLuado.isDocPendienteFirma" + isDocPendienteFirma);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);

				// Aadimos el organismo que presenta la solicitud
				// como interviniente en caso de que se haya borrado
				// de intervinientes en la pestaa "OTROS DATOS"
				// aunque siga informado en la pestaa de
				// "ARBITRAJE" del expediente
				Arbexp arbexp = new Arbexp();
				arbexp.setExcodigo(solarb.getSacodigo());
				arbexp = this.arbexpDao.find(arbexp);

				if (arbexp != null && arbexp.getExcoorg() != null) {
					Organismo orgOrigen = new Organismo();
					orgOrigen.setCodOrg(arbexp.getExcoorg());
					orgOrigen = this.organismoDao.findOrganismoByCodOrg(orgOrigen);
					// buscar el interviniente interesado
					Arbinterv organismoOrigen = new Arbinterv();
					organismoOrigen.setUaexcodigo(solarb.getSacodigo());
					organismoOrigen.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS);
					organismoOrigen.setUaentidadId(orgOrigen.getEntidadId());
					List<Arbinterv> listIntervinientes = this.arbintervDao.findAll(organismoOrigen, null);
					organismoOrigen.setUaexcodigo(solarb.getSacodigo());
					organismoOrigen.setUanombre(orgOrigen.getNombreEs());
					// arbintervAux.setUacoem(establecimiento.getEscoem());
					organismoOrigen.setUanif(orgOrigen.getCif());
					organismoOrigen.setUanrtel(orgOrigen.getTelefono());
					organismoOrigen.setUanrtel2(null);
					organismoOrigen.setUaprovId(orgOrigen.getNoraProvinciaId());
					organismoOrigen.setUamunId(orgOrigen.getNoraMunicipioId());
					organismoOrigen.setUalocId(orgOrigen.getNoraLocalidadId());
					organismoOrigen.setUacalleId(orgOrigen.getNoraCalleId());
					// El campo noraCpId no se utiliza. Nora y no
					// nora guarda el cp en
					// nombrecp
					// arbintervAux.setUacpId(organismo.getNoraCpId());
					organismoOrigen.setUacpId(orgOrigen.getNombreCp());
					organismoOrigen.setUaportalId(orgOrigen.getNoraPortalId());
					organismoOrigen.setUanombrePiso(
							(orgOrigen.getCompleDirec() != null && orgOrigen.getCompleDirec().length() > 40)
									? orgOrigen.getCompleDirec().substring(0, 40) : orgOrigen.getCompleDirec());

					if (Y41bUtils.esNullOCadenaVacia(orgOrigen.getNoraProvinciaId())
							|| (!Y41bConstantes.ARABA.equals(orgOrigen.getNoraProvinciaId())
									&& !Y41bConstantes.BIZKAIA.equals(orgOrigen.getNoraProvinciaId())
									&& !Y41bConstantes.GIPUZKOA.equals(orgOrigen.getNoraProvinciaId()))) {
						organismoOrigen.setUadireNocapv(orgOrigen.getNombreCalle());
					}
					organismoOrigen.setUadireAnt(orgOrigen.getCompleDirec());
					boolean comNotOrgOrigen = true;
					if (Y41bConstantes.OFICINA_KONTSUMOBIDE_ALAVA.equals(orgOrigen.getEntidadId())
							|| Y41bConstantes.OFICINA_KONTSUMOBIDE_BIZKAIA.equals(orgOrigen.getEntidadId())
							|| Y41bConstantes.OFICINA_KONTSUMOBIDE_GIPUZKOA.equals(orgOrigen.getEntidadId())
							|| Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI.equals(orgOrigen.getCodOrg())
					// ||
					// Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO.equals(orgOrigen.getCodOrg())
					) {
						comNotOrgOrigen = false;
					}
					if (Y41bUtils.esNullOCadenaVacia(orgOrigen.getNoraPaisId())) {
						organismoOrigen.setUapaisId(Y41bConstantes.COD_PAIS_ESTADO);
					} else {
						organismoOrigen.setUapaisId(orgOrigen.getNoraPaisId());
					}
					organismoOrigen.setUaurl(orgOrigen.getUrl());
					organismoOrigen.setUacoem(orgOrigen.getEmail());
					if (listIntervinientes != null && listIntervinientes.size() > 0) {
						organismoOrigen.setUaidinterv(listIntervinientes.get(0).getUaidinterv());
						this.arbintervDao.update(organismoOrigen);
					} else if (comNotOrgOrigen) {
						this.arbintervDao.add(organismoOrigen);
					}

					// organismoOrigen = this.arbintervDao
					// .findOrganismoOrigen(organismoOrigen);

					// Si existe organismo origen y no es
					// territorial entonces le mandamos not/com
					if (organismoOrigen != null && comNotOrgOrigen) {
						this.arbtramexp2Service.generarNotificacionComunicacionInterviniente(arbtramexp, solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS, organismoOrigen);
					}
				}

				// Arbinterv organismoOrigen = new Arbinterv();
				// organismoOrigen.setUaexcodigo(solarb.getSacodigo());
				// organismoOrigen
				// .setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS);
				//
				// Arbexp arbexp = new Arbexp();
				// arbexp.setExcodigo(solarb.getSacodigo());
				// arbexp = this.arbexpDao.find(arbexp);
				//
				// Organismo orgOrigen = new Organismo();
				// if (arbexp != null && arbexp.getExcoorg() != null) {
				// orgOrigen.setCodOrg(arbexp.getExcoorg());
				//
				// orgOrigen = this.organismoDao
				// .findOrganismoByCodOrg(orgOrigen);
				//
				// if (orgOrigen != null) {
				// organismoOrigen
				// .setUaentidadId(orgOrigen.getEntidadId());
				// }
				//
				// organismoOrigen = this.arbintervDao
				// .findOrganismoOrigen(organismoOrigen);
				// }
				// this.arbtramexp2Service
				// .generarNotificacionComunicacionInterviniente(
				// arbtramexp, solarb,
				// Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS,
				// organismoOrigen);

				Arbtramexp pagoLaudo = new Arbtramexp();
				pagoLaudo.setSolarb(solarb);
				pagoLaudo.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO);
				if (this.arbtramexpDao.findAllCount(pagoLaudo) == 0L) {
					this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
							Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO, Y41bConstantes.FASE_RESOLUCION_ARBITRAJE,
							false);
				}

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.actualizaExpedienteTrasTramitar(arbtramexp);
			}

			// 0155021
			// BOrramos de la tabla Z6 (BandejaFirmaArbitros) todos los
			// registros que esten pendientes ya que se ha tramitado y no
			// debera haber ningn registro
			BandejaFirmaArbitraje bandejaFirmaArbitraje = new BandejaFirmaArbitraje();
			bandejaFirmaArbitraje.setIdtramitehecho(tramiteComun.getIdTramite());
			this.bandejaFirmaArbitrajeDao.removeBandejaFirmaExpedientePendientes(bandejaFirmaArbitraje);
			// 0155021

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return TramiteARBLaudo
	 */
	public TramiteARBLaudo findTramiteLaudo(TramiteARBLaudo tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			String trid = tramite.getIdTramite();
			arbtramexp.setTrid(trid);
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBLaudo tramiteAux = new TramiteARBLaudo();
			tramiteAux.setIdExpediente(arbtramexp.getSolarb().getSacodigo());
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());
			tramiteAux.setFecha(arbtramexp.getTrresofecha());
			if (arbtramexp.getTrresoimporte() == null) {
				tramiteAux.setImporte("");
			} else {
				tramiteAux.setImporte(arbtramexp.getTrresoimporte().doubleValue() == 0 ? "0,00"
						: Y41bUtils.formatDouble2decimalesYcoma(arbtramexp.getTrresoimporte().doubleValue()));
			}
			if (arbtramexp.getTrimpreconv() == null) {
				tramiteAux.setImpReconv("");
			} else {
				tramiteAux.setImpReconv(arbtramexp.getTrimpreconv().doubleValue() == 0 ? "0,00"
						: Y41bUtils.formatDouble2decimalesYcoma(arbtramexp.getTrimpreconv().doubleValue()));
			}
			tramiteAux.setResultado(arbtramexp.getTrresultado());
			tramiteAux.setModo(arbtramexp.getTrmodolaudo());
			tramiteAux.setRespMotiv(arbtramexp.getTrrespmotiv());

			tramiteAux.setNotComReclamado(arbtramexp.getTrnotcomreclamado());
			tramiteAux.setNotComReclamante(arbtramexp.getTrnotcomreclamante());
			tramiteAux.setNotComOtros(arbtramexp.getTrnotcomterceros());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));
			tramiteAux.setDecision(Y41bUtils.clobToString(arbtramexp.getTrdecision()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			Arbtramexp4ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBResolucion
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteResolucion(TramiteARBResolucion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoARBResolucion) throws Exception {

		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		boolean decisionError = Y41bConstantes.DECISION_ARBITRAJE_ERROR.equals(tramite.getDecision().toString());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_RESOLUCION_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

		arbtramexp.setTrresofecha(tramite.getFechaReso());
		arbtramexp.setTrfecdesis(tramite.getFechaDesistimiento());
		arbtramexp.setTrresotipo(tramite.getDecision());
		arbtramexp.setTrcot5(tramite.getMotivoInadmision());
		arbtramexp.setTrfecauerdo(tramite.getFechaAcuerdo());
		arbtramexp.setTrresumen(Y41bUtils.stringToClob(tramite.getDescAcuerdo()));
		arbtramexp.setTrimporte(Y41bUtils.esNullOCadenaVacia(tramite.getImporteAcuerdo()) ? null
				: new BigDecimal(tramite.getImporteAcuerdo().replace('\u002c', '\u002e')));
		arbtramexp.setTrcosaac(tramite.getSacodigoAcumula());
		arbtramexp.setTrcomotr(tramite.getMotivoTraslado());
		arbtramexp.setTrcoortr(tramite.getOrganismoTraslado());
		arbtramexp.setTrmonol(tramite.getMotivoNoLocalizado());
		arbtramexp.setTrnotcomreclamante(tramite.getNotComReclamante());
		arbtramexp.setTrnotcomreclamado(tramite.getNotComReclamado());
		arbtramexp.setTrnotcomterceros(tramite.getNotComOtros());

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento si la decision no es error ni
			// laudo
			// 0148096 se quita de la condicion que no se decision error
			if (!Y41bConstantes.DECISION_ARBITRAJE_LAUDO.equals(tramite.getDecision())) {
				// 0174011: Arbitraje - No requerir documento en archivo por
				// error si no se eligen trmites para las partes
				// si tramitesGenerar es 4 quiere decir que es archivo de error
				// con destinatario ninguno asiq se salta la validacion de
				// documento obligatorio
				if ((!"4".equals(tramite.getTramitesGenerar()))) {
					if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
						// Validacion: Debe haber almenos 1 documento
						throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
					}
				}
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
				if (Y41bConstantes.DECISION_ARBITRAJE_LAUDO.equals(tramite.getDecision())) {
					Arbtramexp tramiteLaudo = this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
							Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO, Y41bConstantes.FASE_RESOLUCION_ARBITRAJE, false);
					// 0150948
					// 2.3
					// coger el arbtramexp y todos los documentos de tipo de
					// laudo aadirselos a ese tramite

					this.adjuntarLaudosAUnTramiteAutomaticamente(tramiteLaudo.getTrid().toString(),
							tramiteComun.getIdExpediente());
					// 0150948
					// 2.3

				} else {
					Arbinterv arbintervAux = null;
					if (Y41bConstantes.DECISION_ARBITRAJE_TRASLADO.equals(tramite.getDecision())) {
						// Creamos el organismo de traslado como interviniente
						// para
						// poder comunicar/notificar
						if (!Y41bUtils.esNullOCadenaVacia(tramite.getOrganismoTraslado())) {
							Organismo organismo = new Organismo();
							organismo.setCodOrg(tramite.getOrganismoTraslado());
							organismo = this.organismoDao.findOrganismoByCodOrg(organismo);
							// buscar el interviniente interesado
							arbintervAux = new Arbinterv();
							arbintervAux.setUaexcodigo(solarb.getSacodigo());
							arbintervAux.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS);
							arbintervAux.setUaentidadId(organismo.getEntidadId());
							List<Arbinterv> listIntervinientes = this.arbintervDao.findAll(arbintervAux, null);
							arbintervAux.setUaexcodigo(solarb.getSacodigo());
							arbintervAux.setUanombre(organismo.getNombreEs());
							// arbintervAux.setUacoem(establecimiento.getEscoem());
							arbintervAux.setUanif(organismo.getCif());
							arbintervAux.setUanrtel(organismo.getTelefono());
							arbintervAux.setUanrtel2(null);
							arbintervAux.setUaprovId(organismo.getNoraProvinciaId());
							arbintervAux.setUamunId(organismo.getNoraMunicipioId());
							arbintervAux.setUalocId(organismo.getNoraLocalidadId());
							arbintervAux.setUacalleId(organismo.getNoraCalleId());
							// El campo noraCpId no se utiliza. Nora y no nora
							// guarda el cp en
							// nombrecp
							// arbintervAux.setUacpId(organismo.getNoraCpId());
							arbintervAux.setUacpId(organismo.getNombreCp());
							arbintervAux.setUaportalId(organismo.getNoraPortalId());
							arbintervAux.setUanombrePiso(organismo.getCompleDirec());
							if (Y41bUtils.esNullOCadenaVacia(organismo.getNoraProvinciaId())
									|| (!Y41bConstantes.ARABA.equals(organismo.getNoraProvinciaId())
											&& !Y41bConstantes.BIZKAIA.equals(organismo.getNoraProvinciaId())
											&& !Y41bConstantes.GIPUZKOA.equals(organismo.getNoraProvinciaId()))) {
								arbintervAux.setUadireNocapv(organismo.getNombreCalle());
							}
							arbintervAux.setUadireAnt(organismo.getCompleDirec());
							arbintervAux.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS);
							arbintervAux.setUaentidadId(organismo.getEntidadId());
							if (Y41bUtils.esNullOCadenaVacia(organismo.getNoraPaisId())) {
								arbintervAux.setUapaisId(Y41bConstantes.COD_PAIS_ESTADO);
							} else {
								arbintervAux.setUapaisId(organismo.getNoraPaisId());
							}
							arbintervAux.setUaurl(organismo.getUrl());
							arbintervAux.setUacoem(organismo.getEmail());
							if (listIntervinientes != null && listIntervinientes.size() > 0) {
								arbintervAux.setUaidinterv(listIntervinientes.get(0).getUaidinterv());
								arbintervAux = this.arbintervDao.update(arbintervAux);
							} else {
								arbintervAux = this.arbintervDao.add(arbintervAux);
							}
						}
					}
					// Si la decision es error no se genera ningun tramite
					// 0148096 aniadimos que si es decisionError y el combo es
					// ambos o alguno de los dos
					// puede generar notificacion reclamante y reclamado
					if (!decisionError || (decisionError && ("3".equals(tramite.getTramitesGenerar())
							|| "1".equals(tramite.getTramitesGenerar())))) {

						this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
					}
					// 0148096 aniadimos que si es decisionError puede entrar si
					// es reclamado o ambos
					if ((!decisionError || (decisionError
							&& ("3".equals(tramite.getTramitesGenerar()) || "2".equals(tramite.getTramitesGenerar()))))
							&& !Y41bConstantes.DECISION_ARBITRAJE_TRASLADO.equals(tramite.getDecision())
							&& !Y41bConstantes.DECISION_ARBITRAJE_NOACEPTACION.equals(tramite.getDecision())
							&& !Y41bConstantes.DECISION_ARBITRAJE_NOSUBSANA.equals(tramite.getDecision())
							&& !Y41bConstantes.DECISION_ARBITRAJE_NOLOCALIZADO.equals(tramite.getDecision())
							&& !Y41bConstantes.DECISION_ARBITRAJE_INADMISION.equals(tramite.getDecision())) {
						this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
					}
					if (!decisionError && !Y41bConstantes.DECISION_ARBITRAJE_CADUCIDAD.equals(tramite.getDecision())
					// 0150948: Evolutivo Arbitraje Marzo-2020
					// 2.2 que entre si es inadmision tambien
					// && !Y41bConstantes.DECISION_ARBITRAJE_INADMISION
					// .equals(tramite.getDecision())
					// 0150948: Evolutivo Arbitraje Marzo-2020
					// 2.2 que entre si es inadmision tambien
					) {
						if (Y41bConstantes.DECISION_ARBITRAJE_TRASLADO.equals(tramite.getDecision())) {
							this.arbtramexp2Service.generarNotificacionComunicacionInterviniente(arbtramexp, solarb,
									Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS, arbintervAux);
						} else {
							// Aadimos el organismo que presenta la solicitud
							// como interviniente en caso de que se haya borrado
							// de intervinientes en la pestaa "OTROS DATOS"
							// aunque siga informado en la pestaa de
							// "ARBITRAJE" del expediente
							Arbexp arbexp = new Arbexp();
							arbexp.setExcodigo(solarb.getSacodigo());
							arbexp = this.arbexpDao.find(arbexp);

							if (arbexp != null && arbexp.getExcoorg() != null) {
								Organismo orgOrigen = new Organismo();
								orgOrigen.setCodOrg(arbexp.getExcoorg());
								orgOrigen = this.organismoDao.findOrganismoByCodOrg(orgOrigen);
								// buscar el interviniente interesado
								Arbinterv organismoOrigen = new Arbinterv();
								organismoOrigen.setUaexcodigo(solarb.getSacodigo());
								organismoOrigen.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS);
								organismoOrigen.setUaentidadId(orgOrigen.getEntidadId());
								List<Arbinterv> listIntervinientes = this.arbintervDao.findAll(organismoOrigen, null);
								organismoOrigen.setUaexcodigo(solarb.getSacodigo());
								organismoOrigen.setUanombre(orgOrigen.getNombreEs());
								// arbintervAux.setUacoem(establecimiento.getEscoem());
								organismoOrigen.setUanif(orgOrigen.getCif());
								organismoOrigen.setUanrtel(orgOrigen.getTelefono());
								organismoOrigen.setUanrtel2(null);
								organismoOrigen.setUaprovId(orgOrigen.getNoraProvinciaId());
								organismoOrigen.setUamunId(orgOrigen.getNoraMunicipioId());
								organismoOrigen.setUalocId(orgOrigen.getNoraLocalidadId());
								organismoOrigen.setUacalleId(orgOrigen.getNoraCalleId());
								// El campo noraCpId no se utiliza. Nora y no
								// nora guarda el cp en
								// nombrecp
								// arbintervAux.setUacpId(organismo.getNoraCpId());
								organismoOrigen.setUacpId(orgOrigen.getNombreCp());
								organismoOrigen.setUaportalId(orgOrigen.getNoraPortalId());
								organismoOrigen.setUanombrePiso(
										(orgOrigen.getCompleDirec() != null && orgOrigen.getCompleDirec().length() > 40)
												? orgOrigen.getCompleDirec().substring(0, 40)
												: orgOrigen.getCompleDirec());

								if (Y41bUtils.esNullOCadenaVacia(orgOrigen.getNoraProvinciaId())
										|| (!Y41bConstantes.ARABA.equals(orgOrigen.getNoraProvinciaId())
												&& !Y41bConstantes.BIZKAIA.equals(orgOrigen.getNoraProvinciaId())
												&& !Y41bConstantes.GIPUZKOA.equals(orgOrigen.getNoraProvinciaId()))) {
									organismoOrigen.setUadireNocapv(orgOrigen.getNombreCalle());
								}
								organismoOrigen.setUadireAnt(orgOrigen.getCompleDirec());
								boolean comNotOrgOrigen = true;
								if (Y41bConstantes.OFICINA_KONTSUMOBIDE_ALAVA.equals(orgOrigen.getEntidadId())
										|| Y41bConstantes.OFICINA_KONTSUMOBIDE_BIZKAIA.equals(orgOrigen.getEntidadId())
										|| Y41bConstantes.OFICINA_KONTSUMOBIDE_GIPUZKOA.equals(orgOrigen.getEntidadId())
										|| Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI.equals(orgOrigen.getCodOrg())
								// ||
								// Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO
								// .equals(orgOrigen.getCodOrg())
								) {
									comNotOrgOrigen = false;
								}
								if (Y41bUtils.esNullOCadenaVacia(orgOrigen.getNoraPaisId())) {
									organismoOrigen.setUapaisId(Y41bConstantes.COD_PAIS_ESTADO);
								} else {
									organismoOrigen.setUapaisId(orgOrigen.getNoraPaisId());
								}
								organismoOrigen.setUaurl(orgOrigen.getUrl());
								organismoOrigen.setUacoem(orgOrigen.getEmail());
								if (listIntervinientes != null && listIntervinientes.size() > 0) {
									organismoOrigen.setUaidinterv(listIntervinientes.get(0).getUaidinterv());
									this.arbintervDao.update(organismoOrigen);
								} else if (comNotOrgOrigen) {
									this.arbintervDao.add(organismoOrigen);
								}

								// organismoOrigen = this.arbintervDao
								// .findOrganismoOrigen(organismoOrigen);

								// Si existe organismo origen y no es
								// territorial entonces le mandamos not/com
								if (organismoOrigen != null && comNotOrgOrigen) {
									this.arbtramexp2Service.generarNotificacionComunicacionInterviniente(arbtramexp,
											solarb, Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS, organismoOrigen);
								}
							}
						}
					}
				}

				Arbbandeja aviso = new Arbbandeja();
				aviso.setSolarb(new Solarb(solarb.getSacodigo()));
				aviso.setAbtipo(Y41bConstantes.TIPO_AVISO_ARBITRAJE_CONVENIO);
				List<Arbbandeja> lavisos = arbbandejaDao.findAll(aviso, null);
				if (lavisos != null) {
					for (int i = 0; i < lavisos.size(); i++) {
						this.arbbandejaDao.remove(lavisos.get(i));
					}
				}
				aviso.setAbtipo(Y41bConstantes.TIPO_AVISO_ARBITRAJE_ADMISION);
				lavisos = arbbandejaDao.findAll(aviso, null);
				if (lavisos != null) {
					for (int i = 0; i < lavisos.size(); i++) {
						this.arbbandejaDao.remove(lavisos.get(i));
					}
				}
				// Incidencia 114099: Aviso final de plazo de alegaciones, no
				// sacarlo si el expediente ya tiene resolucin
				aviso.setAbtipo(Y41bConstantes.TIPO_AVISO_ARBITRAJE_ALEGACIONES);
				lavisos = arbbandejaDao.findAll(aviso, null);
				if (lavisos != null) {
					for (int i = 0; i < lavisos.size(); i++) {
						this.arbbandejaDao.remove(lavisos.get(i));
					}
				}

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	// 0150948: Evolutivo Arbitraje Marzo-2020
	// 2.3
	/**
	 * adjuntarAlegacionesAUnTramiteAutomaticamente
	 * 
	 * @param tridDestino
	 *            String
	 */
	private void adjuntarLaudosAUnTramiteAutomaticamente(String tridDestino, String excodigo) {

		this.arbdoctempDao.copiaArbDocLaudo(tridDestino, excodigo);
	}
	// 0150948: Evolutivo Arbitraje Marzo-2020
	// 2.3

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBResolucion findTramiteResolucion(TramiteARBResolucion tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			String trid = tramite.getIdTramite();
			arbtramexp.setTrid(trid);
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBResolucion tramiteAux = new TramiteARBResolucion();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setFechaReso(arbtramexp.getTrresofecha());
			tramiteAux.setDecision(arbtramexp.getTrresotipo());
			tramiteAux.setMotivoInadmision(arbtramexp.getTrcot5());
			tramiteAux.setFechaDesistimiento(arbtramexp.getTrfecdesis());
			tramiteAux.setFechaAcuerdo(arbtramexp.getTrfecauerdo());
			tramiteAux.setImporteAcuerdo(arbtramexp.getTrimporte() == null ? ""
					: Y41bUtils.formatDouble2decimalesYcoma(arbtramexp.getTrimporte().doubleValue()));
			tramiteAux.setSacodigoAcumula(arbtramexp.getTrcosaac());
			if (!Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrcosaac())) {
				Solarb solarbAc = new Solarb(arbtramexp.getTrcosaac());
				solarbAc = this.solarbDao.find(solarbAc);
				tramiteAux.setSacojaAc(solarbAc.getSacoja());
				tramiteAux.setSanrorAc(solarbAc.getSanror().toString());
				tramiteAux.setSanranAc(solarbAc.getSanran().toString());
			} else {
				tramiteAux.setSacojaAc("");
				tramiteAux.setSanrorAc("");
				tramiteAux.setSanranAc("");
			}
			tramiteAux.setMotivoTraslado(arbtramexp.getTrcomotr());
			tramiteAux.setOrganismoTraslado(arbtramexp.getTrcoortr());
			tramiteAux.setMotivoNoLocalizado(arbtramexp.getTrmonol());
			tramiteAux.setNotComReclamante(arbtramexp.getTrnotcomreclamante());
			tramiteAux.setNotComReclamado(arbtramexp.getTrnotcomreclamado());
			tramiteAux.setNotComOtros(arbtramexp.getTrnotcomterceros());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));
			tramiteAux.setDescAcuerdo(Y41bUtils.clobToString(arbtramexp.getTrresumen()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}

			// buscar si existe un trmite de aceptacin arbitraje tramitado,
			// con no aceptacin
			Arbtramexp arbtramexpAux = new Arbtramexp();
			arbtramexpAux.setSolarb(new Solarb(arbtramexp.getSolarb().getSacodigo()));
			arbtramexpAux.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE);
			arbtramexpAux.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			arbtramexpAux.setTrresparbNot(Y41bConstantes.VALOR_SI);
			long numTramites = this.arbtramexpDao.findAllCount(arbtramexpAux);
			if (numTramites > 0) {
				tramiteAux.setOrigenAceptacionNegativa(Y41bConstantes.VALOR_SI);
			}

			return tramiteAux;
		} catch (Exception e) {
			Arbtramexp4ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	// Validacion: Los documentos deben tener la extension .pdf

	private void validarExtensionpdf(List<Arbdoctemp> listDocumentoHecho) {

		for (int i = 0; i < listDocumentoHecho.size(); i++) {
			Arbdoctemp documentoHecho = listDocumentoHecho.get(i);

			if (documentoHecho != null && (documentoHecho.getX5nofile() != null && !com.ejie.y41b.utils.Y41bUtils
					.getExtensionFile(documentoHecho.getX5nofile()).equalsIgnoreCase(Y41bConstantes.PDF))) {
				throw new Y41bUDAException("error.validacion.pagoLaudoPDF", true, new Exception());
			}
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBPagoLaudo
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramitePagoLaudo(TramiteARBPagoLaudo tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoARBPagoLaudo) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_RESOLUCION_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		// arbtramexp.setTrfeopla(tramite.getFecha());
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos dos documentos
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 2) {
				// Validacion: Debe haber al menos 2 documentos
				throw new Y41bUDAException("error.solicitud.documento2Exception", true, new Exception());
			}

			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				// Llamada a la funcion de validar la extension de PDF de los
				// documentos
				// de pagoLaudo
				this.validarExtensionpdf(listDocumentoHecho);

				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBPagoLaudo findTramitePagoLaudo(TramiteARBPagoLaudo tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			String trid = tramite.getIdTramite();
			arbtramexp.setTrid(trid);
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBPagoLaudo tramiteAux = new TramiteARBPagoLaudo();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());
			tramiteAux.setFecha(arbtramexp.getTrfeopla());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			Arbtramexp4ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param expedienAux
	 *            Solarb
	 * @param mensajeAportacionDoc
	 *            MensajeAportacionDocumentacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void generarTramiteAportacionDocumentacion(Solarb expedienAux,
			MensajeAportacionDocumentacion mensajeAportacionDoc) throws Exception {
		Arbdoctemp arbdoctemp = null;
		try {
			Arbtramexp4ServiceImpl.logger.info("generarTramiteAportacionDocumentacion - Inicio");

			Arbtramexp arbtramexp = new Arbtramexp();
			Solarb solarb = this.solarbDao.findArbitrajeByNumeroExpediente(expedienAux);

			Arbexp arbexp = new Arbexp();
			arbexp.setExcodigo(solarb.getSacodigo());
			arbexp = this.arbexpDao.find(arbexp);

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(Y41bConstantes.CASTELLANO));

			arbtramexp.setTrfecini(todayWithZeroTime);

			// arbtramexp.setTrfecfin(todayWithZeroTime);
			/*
			 * Se ha anulado la anulacion de la modificacion (misma incidencia)
			 * // Incidencia 106947 - Arbitraje - Estado en tramitacion (SE HA
			 * // ANULADO LA MODIFICACION)
			 * arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			 * // arbtramexp.setTrestado(Y41bConstantes.
			 * ESTADO_TRAMITE_ENTRAMITACION );
			 */
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

			arbtramexp.setSolarb(solarb);
			arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_APORTACIONDOCUMENTACION);
			arbtramexp.setFase(arbexp.getFase());

			arbtramexp.setTristelematica(Y41bConstantes.VALOR_SI);

			arbtramexp.setTrid(this.arbtramexpDao.getNewPK().toString());

			arbtramexp = this.arbtramexpDao.add(arbtramexp);

			// buscamos el Sender
			String tipoInterv = null;
			Arbinterv arbinterv = null;
			String origenDocumento = null;

			if (Y41bUtils.isFilled(mensajeAportacionDoc.getSender())) {
				Arbinterv arbintervFiltro = new Arbinterv();
				arbintervFiltro.setUanif(mensajeAportacionDoc.getSender());
				arbintervFiltro.setUaexcodigo(solarb.getSacodigo());
				List<Arbinterv> listIntervSender = this.arbintervDao.findAll(arbintervFiltro, null);
				if (listIntervSender != null) {
					arbinterv = listIntervSender.get(0);
					tipoInterv = arbinterv.getUatipointerv();

				}
			}
			if (tipoInterv != null) {

				if (tipoInterv.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO)) {
					origenDocumento = Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO;
				} else if (tipoInterv.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO)
						|| tipoInterv.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO)
						|| tipoInterv.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_ANTERIOR)) {
					origenDocumento = Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO;
				} else if (tipoInterv.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE)) {
					origenDocumento = Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE;
				} else if (tipoInterv.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE)
						|| tipoInterv.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO)
						|| tipoInterv.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_ANTERIOR)) {
					origenDocumento = Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE;
				}
			}

			List<Documento> listDocumentos = mensajeAportacionDoc.getDocumentosAportados();

			for (Documento documentoAux : listDocumentos) {
				if (Y41bUtils.isFilled(documentoAux.getOidDokusi())) {
					// descargar documentos dokusi
					if (Y41bUtils.interactuarConDokusi()) {
						Documento documento = new Documento();
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
						documento.setProcedure(procedure);
						documento.setOidDokusi(documentoAux.getOidDokusi());

						Documento docDokusi = this.y41bDokusiAdapterService
								.descargarDocumentoDokusiSinDocumento(documento);

						// # INICIO #
						// ADAPTACIONES LEY 39
						// Tratar el documento por si se trata de una solicitud
						// de
						// datos de aviso o datos de notificacion
						// this.tratarDocumentosSolicitudMisGestiones(docDokusi,
						// solarb, origenDocumento);
						// # FIN #

						Arbtramexp4ServiceImpl.logger.debug("generarTramiteAportacionDocumentacion-Paso 1");
						// insertar el documento
						arbdoctemp = new Arbdoctemp();
						arbdoctemp.setX5codocumento(this.arbdoctempDao.getNewPK().toString());
						arbdoctemp.setX5excodigo(solarb.getSacodigo());
						arbdoctemp.setX5nofile(docDokusi.getNombre());
						arbdoctemp.setX5sizefile((int) docDokusi.getLength());

						// tenemos que ver si el SENDER ID es el reclamante o el
						// reclamado

						arbdoctemp.setX5origen(origenDocumento);
						if (arbinterv != null) {
							arbdoctemp.setX5idinterviniente(arbinterv.getUaidinterv().toString());
						}

						arbdoctemp.setX5tedesfile(documentoAux.getDescripcion());
						arbdoctemp.setX5iddocumentum(documentoAux.getOidDokusi());
						arbdoctemp.setX5conttype(docDokusi.getContentType());
						SimpleDateFormat formatterFechaRegistro = new SimpleDateFormat(
								Y41bConstantes.FORMATO_FECHAHORA_TOOLKIT);
						Date dateFechaRegistro = formatterFechaRegistro
								.parse(mensajeAportacionDoc.getRegistro().getRegistryTimestamp());
						arbdoctemp.setX5fecha(dateFechaRegistro);
						arbdoctemp.setX5fechaaportacion(dateFechaRegistro);
						arbdoctemp.setArbtramexp(arbtramexp);
						if (documentoAux.getTipoDocumental() != null) {
							arbdoctemp.setArbtipdoc(
									new Arbtipdoc(this.getTipoDocumento(documentoAux.getTipoDocumental())));
							// String tipoDocumento = this
							// .getTipoDocumento(documentoAux
							// .getTipoDocumental());
							// if (Y41bConstantes.TIPO_DOC_SOLICITUD
							// .equalsIgnoreCase(tipoDocumento)) {
							// arbdoctemp.setArbtipdoc(new Arbtipdoc(
							// Y41bConstantes.TIPO_DOC_ARB_SOLICITUD));
							// } else {
							// arbdoctemp
							// .setArbtipdoc(new Arbtipdoc(
							// Y41bConstantes.TIPO_DOC_ARB_APORTACIONDOCUMENTACION));
							// }
						} else {
							arbdoctemp.setArbtipdoc(new Arbtipdoc(Y41bConstantes.TIPO_DOC_ARB_APORTACIONDOCUMENTACION));
						}
						arbdoctemp.setX5fechaentrada(dateFechaRegistro);
						arbdoctemp.setX5numregistroentrada(mensajeAportacionDoc.getRegistro().getRegistryNumber());
						// Blob blob = new
						// SerialBlob(Y41bUtilsWS.decode(docDokusi
						// .getBytes()));
						// arbdoctemp.setX5datafile(blob);
						this.arbdoctempDao.add(arbdoctemp);

						// insertar en la tabla de relacion
						this.arbdoctempDao.insertArbDocTramite(arbtramexp.getTrid(), arbdoctemp.getX5codocumento(),
								Y41bConstantes.TIPO_PROC_ARBITRAJE);

						// llamar a transformar docuumentos
						// Ya no se transforman los documentos aportados por
						// ciudadania
						// (INC 0097665 y 115908)
						// if (com.ejie.y41b.utils.Y41bUtils
						// .isDocumentoTransformable(docDokusi)) {
						// TransformarDocumento transformarDocumento = new
						// TransformarDocumento();
						// transformarDocumento.setProcedure(documento
						// .getProcedure());
						// transformarDocumento.setUser(documento.getUser());
						// transformarDocumento.setOidDocumento(documento
						// .getOidDokusi());
						//
						// this.y41bDokusiAdapterService
						// .transformarDocumentoDokusi(transformarDocumento);
						//
						// this.arbdoctempDao.updateFechaLocalizacion(arbdoctemp);
						// }
					}
				}
			}

			// Incidencia 106947 - Arbitraje - No actualizar mis gestiones (SE
			// HA ANULADO LA MODIFICACION)
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(arbtramexp.getTrid().toString());

			List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux, null);

			this.actualizarMisGestionesAportaciondocumentacion(arbtramexp, listDocumentoHecho);

			// Actualizar ultimo tramite
			this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);

			// Tratar la bandeja
			this.arbtramexp2Service.actualizaBandeja(arbtramexp);

		} catch (Y41bUDAException e) {
			Arbtramexp4ServiceImpl.logger.error("generarTramiteAportacionDocumentacion ERROR ***** ", e);
			Arbtramexp4ServiceImpl.logger
					.error("generarTramiteAportacionDocumentacion DATOS ***** " + arbdoctemp.toString());
			throw e;
		} catch (Exception e_tratamientoAportacionDocumentacion) {
			Arbtramexp4ServiceImpl.logger.error("generarTramiteAportacionDocumentacion ERROR ***** ",
					e_tratamientoAportacionDocumentacion);
			Arbtramexp4ServiceImpl.logger
					.error("generarTramiteAportacionDocumentacion DATOS ***** " + arbdoctemp.toString());
			throw new Y41bUDAException("error.platea.invocation", true, e_tratamientoAportacionDocumentacion);
		} finally {
			Arbtramexp4ServiceImpl.logger.info("generarTramiteAportacionDocumentacion - Final");
		}

	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBPropuestaSancionador
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramitePropuestaSancionador(TramiteARBPropuestaSancionador tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBPropuestaSancionador) throws Exception {

		if (tramitar) {
			// validacion infracciones una infraccion por materia y por articulo
			if (this.infraccArbDao.findAllMateriasSolicitudesCount(tramiteComun.getIdExpediente()) == 0) {
				throw new Y41bUDAException("error.tramitedecision.infraccionmateria", true, null);
			}
			if (this.infraccArbDao.findAllArticulosSolicitudesCount(tramiteComun.getIdExpediente()) == 0) {
				throw new Y41bUDAException("error.tramitedecision.infraccionarticulo", true, null);
			}
		}
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_CIERRE_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrjustificacion(Y41bUtils.stringToClob(tramite.getJustificacion()));

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		this.infraccArbDao.removeAllInfraccionesArb(tramiteComun);
		this.infraccArbDao.addAllInfraccionesArbAdjuntarInfracciones(tramiteComun);
		this.adjunInfraccArbDao.removeAllAdjuntarInfracciones(tramiteComun);

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (isDocPendienteFirma) {
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.actualizaExpedienteTrasTramitar(arbtramexp);

				this.tratamientoBandejaPropuestaSancion(arbtramexp, solarb);
			}
		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            censoMonitor
	 * @return tramite
	 */
	public TramiteARBPropuestaSancionador findTramitePropuestaSancionador(TramiteARBPropuestaSancionador tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			String trid = tramite.getIdTramite();
			arbtramexp.setTrid(trid);
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBPropuestaSancionador tramiteAux = new TramiteARBPropuestaSancionador();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));
			tramiteAux.setJustificacion(Y41bUtils.clobToString(arbtramexp.getTrjustificacion()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			Arbtramexp4ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Esta funcion actualiza la bandeja de propuesta de sancion con la
	 * informacion del tramitehecho recibido por parametro
	 * 
	 * @param tramitehecho
	 *            TramiteHecho
	 */
	public void tratamientoBandejaPropuestaSancion(Arbtramexp arbtramexp, Solarb solarb) {
		logger.info("TratamientoBandejaPropuestaSancion Ini");
		Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
		// Codigo del expediente de arbitraje
		sanpropbandeja.setBaprsanexcodigo(arbtramexp.getSolarb().getSacodigo());
		sanpropbandeja.setBaprsanexcodigocompleto(solarb.getcodCompleto());
		// Procedimiento
		sanpropbandeja.setBaprsanpcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
		// Fecha hecho
		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(solarb.getSacodigo());
		arbexp = this.arbexpDao.find(arbexp);

		sanpropbandeja.setBaprsanfec(arbexp.getHdfechd());
		// Buscamos el reclamado
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUaexcodigo(solarb.getSacodigo());
		arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
		List<Arbinterv> listArbinterv = this.arbintervdao.findAll(arbinterv, null);

		if (listArbinterv != null && listArbinterv.size() > 0) {
			sanpropbandeja.setBaprsansancionado(listArbinterv.get(0).getUaescodigo());
			sanpropbandeja.setBaprsanmunic(listArbinterv.get(0).getUamunId());
			sanpropbandeja.setBaprsanprov(listArbinterv.get(0).getUaprovId());
		}
		// Datos del establecimiento Fin
		// Responsable del expediente
		sanpropbandeja.setBaprsanrespexp(arbexp.getExmocodigo());

		this.sanpropbandejaService.add(sanpropbandeja);
		logger.info("TratamientoBandejaPropuestaSancion Fin");
	}

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addTramiteAdjuntarInfraccArbTableTemporal(TramiteComun tramiteComun) {
		this.adjunInfraccArbDao.removeAllAdjuntarInfracciones(tramiteComun);
		this.infraccArbDao.addAdjuntarInfracciones(tramiteComun);
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBRecepcionAlegaciones
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteRecepcionAlegaciones(TramiteARBRecepcionAlegaciones tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBRecepcionAlegaciones) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(solarb.getSacodigo());
		arbexp = this.arbexpDao.find(arbexp);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(arbexp.getFase());
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrfecrecepcion(tramite.getFechaRecepcion());
		arbtramexp.setTrintervorigen(tramite.getOrigen());
		arbtramexp.setTrtipoalega(tramite.getTipo());
		arbtramexp.setTrimporte(Y41bUtils.esNullOCadenaVacia(tramite.getImporte()) ? null
				: new BigDecimal(tramite.getImporte().replace('\u002c', '\u002e')));

		Arbinterv arbinterv = new Arbinterv();
		if (tramite.getOrigen() != null) {
			arbinterv.setUaidinterv(tramite.getOrigen());
			arbinterv = this.arbintervDao.find(arbinterv);
			// A la otra parte
			if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
					|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
							.equals(arbinterv.getUatipointerv())) {
				arbtramexp.setTrnotcomreclamado(tramite.getNotComOtraParte());
			} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
					|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
							.equals(arbinterv.getUatipointerv())) {
				arbtramexp.setTrnotcomreclamante(tramite.getNotComOtraParte());
			}
		}
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			} else if (listDocumentoHecho != null) {
				boolean hayDoc = false;
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					if (Y41bConstantes.TIPO_DOC_ARB_ALEGACIONES
							.equals(listDocumentoHecho.get(i).getX5tipodocumento())) {
						hayDoc = true;
						break;
					}
				}
				if (!hayDoc) {
					throw new Y41bUDAException("error.solicitud.documentoRecepcionException", true, new Exception());
				}
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
				if (!("M".equals(tramite.getTipo()))) {
					if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())) {
						this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
					} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())) {
						this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
					}
				} else {
					Arbtramexp arbtramexpReso = new Arbtramexp();
					arbtramexpReso.setSolarb(solarb);
					arbtramexpReso.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION);
					arbtramexpReso.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

					Arbtramexp arbtramexpAudi = new Arbtramexp();
					arbtramexpAudi.setSolarb(solarb);
					arbtramexpAudi.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA);
					arbtramexpAudi.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

					Arbtramexp arbtramexpMedi = new Arbtramexp();
					arbtramexpMedi.setSolarb(solarb);
					arbtramexpMedi.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_MEDIACION);
					arbtramexpMedi.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

					if (this.arbtramexpService.findAllCount(arbtramexpReso) == 0
							&& this.arbtramexpService.findAllCount(arbtramexpAudi) == 0) {
						if (this.arbtramexpService.findAllCount(arbtramexpMedi) == 0) {
							this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
									Y41bConstantes.TRAMITE_ARBITRAJE_MEDIACION, arbtramexp.getFase().getFnombre(),
									true);
						} else {
							this.arbtramexp2Service.sugiereTramiteAutomaticamente(arbtramexp,
									Y41bConstantes.TRAMITE_ARBITRAJE_MEDIACION, arbtramexp.getFase().getFnombre(),
									false);
						}
					} else {
						throw new Y41bUDAException("error.mediacion", true, new Exception());
					}
					this.arbtramexp2Service.actualizaBandeja(arbtramexp);
					this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
					this.actualizaExpedienteTrasTramitar(arbtramexp);
				}
				// 0171878: Evolutivo Arbitraje Febrero 2021
				Date ayer = Y41bUtils.addDays(Y41bUtils.obtenerFechaHoySinHora(), -1);
				if (null != tramite.getComArbitros() && "S".equals(tramite.getComArbitros())
						&& ((null != solarb.getSafeciau2() && solarb.getSafeciau2().after(ayer))
								|| (null != solarb.getSafeciau() && solarb.getSafeciau().after(ayer)))) {
					// sugerimos comunicaciones a los arbitros
					Arbinterv arbintervaux = new Arbinterv();
					arbintervaux.setSolarb(solarb);
					arbintervaux.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO);
					arbintervaux.setActivos(Y41bConstantes.VALOR_SI);

					List<Arbinterv> listaIntervientes = this.arbintervDao.findAll(arbintervaux, null);
					if (listaIntervientes != null) {
						for (int i = 0; i < listaIntervientes.size(); i++) {
							arbintervaux = (Arbinterv) listaIntervientes.get(i);
							this.arbtramexp2Service.sugiereTramiteComunicacionAutomaticamente(arbtramexp, arbintervaux);
						}
					}
				}
				// 0171878: Evolutivo Arbitraje Febrero 2021
			}
		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            censoMonitor
	 * @return tramite
	 */
	public TramiteARBRecepcionAlegaciones findTramiteRecepcionAlegaciones(TramiteARBRecepcionAlegaciones tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			String trid = tramite.getIdTramite();
			arbtramexp.setTrid(trid);
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBRecepcionAlegaciones tramiteAux = new TramiteARBRecepcionAlegaciones();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setFechaRecepcion(arbtramexp.getTrfecrecepcion());
			tramiteAux.setOrigen(arbtramexp.getTrintervorigen());
			tramiteAux.setTipo(arbtramexp.getTrtipoalega());
			tramiteAux.setImporte(arbtramexp.getTrimporte() == null ? ""
					: Y41bUtils.formatDouble2decimalesYcoma(arbtramexp.getTrimporte().doubleValue()));
			if (arbtramexp.getTrintervorigen() != null) {
				Arbinterv arbinterv = new Arbinterv();
				arbinterv.setUaidinterv(arbtramexp.getTrintervorigen());
				arbinterv = this.arbintervDao.find(arbinterv);
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					tramiteAux.setNotComOtraParte(arbtramexp.getTrnotcomreclamado());
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					tramiteAux.setNotComOtraParte(arbtramexp.getTrnotcomreclamante());
				}
			}
			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}

			if (arbtramexp.getTrtridrel() != null) {
				tramiteAux.setPermisoModificacionOrigenTipo(Y41bConstantes.NO);
			} else {
				tramiteAux.setPermisoModificacionOrigenTipo(Y41bConstantes.SI);
			}

			return tramiteAux;
		} catch (Exception e) {
			Arbtramexp4ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param arbenvio
	 *            Arbenvio
	 */
	public void actualizaExpedienteAlEnviarComNot(Arbtramexp arbtramexp, Arbenvio arbenvio) {
		Solarb solarb = new Solarb();
		solarb.setSacodigo(arbtramexp.getSolarb().getSacodigo());
		solarb = this.solarbDao.find(solarb);

		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(arbtramexp.getSolarb().getSacodigo());
		arbexp = this.arbexpDao.find(arbexp);

		Date fechaEnvio = arbenvio.getEnfecenvio();
		if (arbtramexp.getTrtridrel() != null) {
			Arbtramexp tramiteOriginal = new Arbtramexp();
			tramiteOriginal.setTrid(arbtramexp.getTrtridrel());
			tramiteOriginal = this.arbtramexpDao.find(tramiteOriginal);

			String codigoTipoTramite = tramiteOriginal.getTrcodigo();

			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setUaidinterv(arbtramexp.getTruaidinterv());
			arbinterv = this.arbintervdao.find(arbinterv);
			if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					solarb.setSafenola(fechaEnvio);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvlaud(fechaEnvio);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					solarb.setSafeenac(fechaEnvio);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvacla(fechaEnvio);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					solarb.setSafenoco(fechaEnvio);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvconv(fechaEnvio);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(codigoTipoTramite)) {
				if (Y41bConstantes.DECISION_ARBITRAJE_DESISTIMIENTO.equals(tramiteOriginal.getTrresotipo())) {
					if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
							|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
									.equals(arbinterv.getUatipointerv())) {
						solarb.setSafenode(fechaEnvio);
					}
				} else if (Y41bConstantes.DECISION_ARBITRAJE_TRASLADO.equals(tramiteOriginal.getTrresotipo())) {
					if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
							|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
									.equals(arbinterv.getUatipointerv())) {
						solarb.setSafetras(fechaEnvio);
					}
				}
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvresoc(fechaEnvio);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvresoe(fechaEnvio);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_MEDIACION.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					solarb.setSafemedi(fechaEnvio);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					solarb.setSafenoar(fechaEnvio);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_SUBSANACION.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvsubs(fechaEnvio);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					solarb.setSafenoca(fechaEnvio);
					arbexp.setExfecenvcitac(fechaEnvio);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvcitae(fechaEnvio);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO.equals(arbinterv.getUatipointerv())) {
					solarb.setSafenopr(fechaEnvio);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO.equals(arbinterv.getUatipointerv())) {
					solarb.setSafeenin(fechaEnvio);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvcitpc(fechaEnvio);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvcitpe(fechaEnvio);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					solarb.setSafenoca2(fechaEnvio);
					arbexp.setExfecenvcit2c(fechaEnvio);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvcit2e(fechaEnvio);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_SUSPENSION_AUDIENCIA.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvsuspc(fechaEnvio);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvsuspe(fechaEnvio);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvinfpc(fechaEnvio);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvinfpe(fechaEnvio);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL.equals(codigoTipoTramite)) {
				solarb.setSafeoppe(fechaEnvio);
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvpagpc(fechaEnvio);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecenvpagpe(fechaEnvio);
				}
			}
			this.solarbDao.update(solarb);
			this.arbexpDao.update(arbexp);
		}
	}

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosHechoComunicacion(TramiteComun tramiteComun,
			Pagination pagination) {
		if (pagination != null) {
			if (pagination.getSort() != null && pagination.getSort().equals("fecha")) {
				pagination.setSort("X5FECHA");
			}

			if (pagination.getSort() != null && pagination.getSort().equals("tedesfile")) {
				pagination.setSort("X5TEDESFILE");
			}

			if (pagination.getSort() != null && pagination.getSort().equals("nofile")) {
				pagination.setSort("X5NOFILE");
			}

			if (pagination.getSort() != null && pagination.getSort().equals("origen")) {
				pagination.setSort("X5ORIGEN");
			}
		}
		List<DocumentoExpediente> listDocumentoExpediente = (List<DocumentoExpediente>) this.arbdoctempDao
				.findAllDocumentosHechoComunicacion(tramiteComun, pagination);

		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);

		if (listDocumentoExpediente != null && listDocumentoExpediente.size() > 0) {
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				documentoExpediente.setIncluidoComunicacion(Y41bConstantes.NO);
				if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
					for (Arbdoctemp documentoHecho : listDocumentoHecho) {
						if (documentoExpediente.getCodocumento().equals(documentoHecho.getX5codocumento())) {
							documentoExpediente.setIncluidoComunicacion(Y41bConstantes.SI);
						}
					}
				}
			}
		}

		return listDocumentoExpediente;
	}

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun) {
		return this.arbdoctempDao.findAllDocumentosHechoComunicacionCount(tramiteComun);
	}

	/**
	 * 
	 * @param tramiteAux
	 *            TramiteARBLaudo
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return TramiteARBLaudo
	 */
	public Arbtramexp obtenerDatosPorDefectoLaudo(Arbtramexp arbtramexp) {
		// Fecha de la ltima audiencia
		if (arbtramexp.getTrresofecha() == null) {
			Arbtramexp audiencia = new Arbtramexp();
			Solarb solarb = arbtramexp.getSolarb();
			audiencia.setSolarb(new Solarb(solarb.getSacodigo()));
			audiencia.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_2AUDIENCIA);
			Pagination pagination = new Pagination();
			pagination.setSidx("TRFECAUDIENCIA");
			pagination.setSord("DESC");
			List<Arbtramexp> laudiencia = arbtramexpDao.findAll(audiencia, pagination);
			if (laudiencia != null && laudiencia.size() > 0) {
				arbtramexp.setTrresofecha(laudiencia.get(0).getTrfecaudiencia());
			} else {
				audiencia.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA);
				laudiencia = arbtramexpDao.findAll(audiencia, pagination);
				if (laudiencia != null && laudiencia.size() > 0) {
					arbtramexp.setTrresofecha(laudiencia.get(0).getTrfecaudiencia());
				}
			}
		}
		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(arbtramexp.getSolarb().getSacodigo());
		arbexp = arbexpDao.find(arbexp);
		if (arbexp != null) {
			if (arbtramexp.getTrresoimporte() == null) {
				arbtramexp.setTrresoimporte(arbexp.getHdcaptso());
			}
			// Importe de reconvencin, se carga con el valor del importe
			// solicitado si existe
			if (arbexp.getEximporteSol() != null) {
				arbtramexp.setTrimpreconv(new BigDecimal(arbexp.getEximporteSol()));
			}
		}
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBAclaracion
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteAclaracion(TramiteARBAclaracion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoARBAclaracion) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_RESOLUCION_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrid(tramiteComun.getIdTramite());
		arbtramexp.setTrfecrecepcion(tramite.getFechaRecepcion());
		arbtramexp.setTrvalorac(tramite.getValoracion());
		arbtramexp.setTrtiposolac(tramite.getTipo());
		arbtramexp.setTrresumen(Y41bUtils.stringToClob(tramite.getResumen()));
		arbtramexp.setTrnotcomreclamado(tramite.getNotComReclamado());
		arbtramexp.setTrnotcomreclamante(tramite.getNotComReclamante());
		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);

				this.arbtramexp2Service.generarNotificacionComunicacion(arbtramexp, solarb,
						Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);

				/*
				 * Arbinterv arbinterv = new Arbinterv();
				 * arbinterv.setSolarb(solarb); arbinterv
				 * .setUatipointerv(Y41bConstantes
				 * .TIPO_INTERVINIENTEARB_RECLAMANTE); List<Arbinterv>
				 * listaIntervientes = this.arbintervDao.findAll( arbinterv,
				 * null); if (listaIntervientes != null) { for (int i = 0; i <
				 * listaIntervientes.size(); i++) { arbinterv = (Arbinterv)
				 * listaIntervientes.get(i); this.arbtramexp2Service
				 * .sugiereTramiteNotificacionAutomaticamente( arbtramexp,
				 * arbinterv); } }
				 * this.arbtramexpService.sugiereTramiteComunicacionArbitros(
				 * arbtramexp, solarb);
				 */

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * 
	 * Reabrir expediente
	 * 
	 * @param excodigo
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void reabrirExpediente(String excodigo, CensoMonitor censoMonitor) throws Exception {

		Solarb solarb = new Solarb();
		solarb.setSacodigo(excodigo);

		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(excodigo);

		// buscar el tramite de cierre
		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE);
		try {
			arbtramexp = this.arbtramexpDao.findUltimoTramiteExpedientePorTipoTramite(arbtramexp);
		} catch (Exception e) {
		}

		// Eliminamos la fecha de cierre
		solarb = this.solarbDao.find(solarb);

		solarb.setSafear(null);
		this.solarbDao.update(solarb);

		arbexp = this.arbexpDao.find(arbexp);
		solarb.setArbexp(arbexp);

		arbexp.setExfecfin(null);
		arbexp.setArbtramexp(null);
		arbexp.setArbtramexpEntidad(null);
		this.arbexpDao.update(arbexp);

		// Eliminar cierre de arbbandeja
		Arbbandeja arbbandeja = new Arbbandeja();
		arbbandeja.setAbtrid(arbtramexp.getTrid());
		List<Arbbandeja> listArbbandeja = this.arbbandejaDao.findAll(arbbandeja, null);
		if (listArbbandeja != null && listArbbandeja.size() > 0) {
			for (int i = 0; i < listArbbandeja.size(); i++) {

				arbbandeja = listArbbandeja.get(i);
				this.arbbandejaDao.remove(arbbandeja);
			}
		}
		// eliminar tramite de cierre
		this.arbtramexpDao.remove(arbtramexp);

		// Actualizar solarbte con el ultimo tramite
		Arbtramexp ultimoArbtramexp = this.calculaUltimoTramiteArbExp(arbexp);

		// crear tramite generico con la fase del ltimo trmite que tengamos
		solarb.getArbexp().setFase(ultimoArbtramexp.getFase());
		this.generarTramiteGenericoReabrirExpediente(solarb, censoMonitor);

		// Actualizar bandeja
		this.arbtramexp2Service.actualizaBandeja(ultimoArbtramexp);

		this.arbtramexp2Service.actualizaUltimoTramiteArbexp(ultimoArbtramexp);

		// Reabrir solarbte
		ActualizarExpediente actualizarExpediente = new ActualizarExpediente();

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
		actualizarExpediente.setProcedure(procedure);

		// RECLAMANTE---------------------------------------------------------------
		Arbinterv reclamanteArb = this.arbintervService.dameInterviniente(excodigo,
				Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
		actualizarExpediente.setSolicitante(this.arbintervService.cargarDatosPersona(reclamanteArb));
		actualizarExpediente.setIdParticipacion(arbexp.getExidparticipacionreclamante());

		// REPRESENTANTE RECLAMANTE
		Arbinterv reclamanteRepr = this.arbintervDao.dameInterviniente(arbexp.getExcodigo(),
				Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE);
		if (reclamanteRepr != null) {
			DatosPersona datosReclamanteRepr = this.arbintervService.cargarDatosPersona(reclamanteRepr);
			// Le ponemos el idioma del titular
			datosReclamanteRepr.setIdioma(Y41bUtils.idiomaTwoChar(reclamanteArb.getUaidioma()));
			actualizarExpediente.setRepresentante(datosReclamanteRepr);
		}
		// --------------------------------------------------------------------------

		// RECLAMADO----------------------------------------------------------------
		// Si el reclamado ya existe en Platea, lo enviamos junto al expediente
		if (arbexp.getExpartrecl() == null || Y41bConstantes.VALOR_SI.equals(arbexp.getExpartrecl())) {

			Arbinterv reclamadoArb = this.arbintervdao.dameInterviniente(excodigo,
					Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
			actualizarExpediente.setInteresado(this.arbintervService.cargarDatosPersona(reclamadoArb));
			actualizarExpediente.setIdParticipacionInteresado(arbexp.getExidparticipacionreclamado());
			// REPRESENTANTE RECLAMADO
			Arbinterv reclamadoRepr = this.arbintervDao.dameInterviniente(arbexp.getExcodigo(),
					Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO);
			if (reclamadoRepr != null) {
				DatosPersona datosReclamadoRepr = this.arbintervService.cargarDatosPersona(reclamadoRepr);
				// Le ponemos el idioma del titular
				datosReclamadoRepr.setIdioma(Y41bUtils.idiomaTwoChar(reclamadoRepr.getUaidioma()));
				actualizarExpediente.setRepresentanteInteresado(datosReclamadoRepr);
			}
		}
		// --------------------------------------------------------------------------

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(Y41bConstantes.TIPO_PROC_ARBITRAJE).append("-").append(solarb.getSacoja()).append("-")
				.append(solarb.getSanror()).append("-").append(solarb.getSanran());

		actualizarExpediente.setEjercicio(solarb.getSanran().toString());

		actualizarExpediente.setNumeroExpediente(numeroExpediente.toString());

		actualizarExpediente.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		DatosPersona sender = new DatosPersona();
		sender.setDni(censoMonitor.getModni());
		sender.setNombre(censoMonitor.getMonombre());
		actualizarExpediente.setSender(sender);

		DatosRegistro datosRegistro = new DatosRegistro();
		try {
			datosRegistro.setRegistryNumber(solarb.getArbexp().getExregen());
			datosRegistro.setRegistryTimestamp(Y41bUtils.formatearDateToString(solarb.getArbexp().getExfecreg(),
					Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
		} catch (Exception e) {
		}

		actualizarExpediente.setDatosRegistro(datosRegistro);

		Calendar cal = Calendar.getInstance();
		try {
			if (solarb != null && solarb.getArbexp() != null && solarb.getArbexp().getExfecini() != null) {
				cal.setTime(solarb.getArbexp().getExfecini());
			} else {
				cal.setTime(new Date());
			}
			actualizarExpediente.setStartTimestamp(cal);
		} catch (Exception e) {
			e.printStackTrace();
			Arbtramexp4ServiceImpl.logger.error("Error producido al realizar el setTime sobre Calendar con valor: +"
					+ solarb.getArbexp().getExfecini() + e.getMessage(), e);
		}

		// Tramites Expediente
		// Buscar tramite de registro de apertura y sus documentos (en principio
		// no tiene)
		arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_APERTURA);
		try {
			arbtramexp = this.arbtramexpDao.findUltimoTramiteExpedientePorTipoTramite(arbtramexp);
		} catch (Exception e) {
		}

		List<Proceedings> listProceedingsReclamante = new ArrayList<Proceedings>();
		List<Proceedings> listProceedingsReclamado = new ArrayList<Proceedings>();
		Proceedings proceedings = new Proceedings();
		if (solarb.getArbexp().getExformapres() != null
				&& solarb.getArbexp().getExformapres().equals(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB)) {
			proceedings.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_TELEMATICO);
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_TELEMATICO_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_TELEMATICO_EU);
		} else {
			proceedings.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_PRESENCIAL);
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_PRESENTACION_SOLICITUD_PRESENCIAL_EU);
		}
		// buscamos los documentos de la apertura
		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(arbtramexp.getTrid());
		tramiteComun.setIdExpediente(solarb.getSacodigo());
		List<Arbdoctemp> listDocumentosApertura = this.arbdoctempDao.findAllDocumentosTramiteApertura(tramiteComun,
				null);

		if (listDocumentosApertura != null && listDocumentosApertura.size() > 0) {
			// 1.User
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);

			Documento documento = null;
			List<Documento> listDocumentos = new ArrayList<Documento>();

			for (Arbdoctemp documentoApertura : listDocumentosApertura) {
				if (!Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(documentoApertura.getX5pcodigo())) {
					documento = new Documento();

					documento.setUser(user);

					// 2.Tipo Documental
					documento.setTipoDocumental(Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO);

					documento.setIdDocumento(documentoApertura.getX5codocumento().toString());
					documento.setNombre(Y41bUtils.getNameFile(documentoApertura.getX5nofile()));
					documento.setDescripcion(documentoApertura.getX5tedesfile());
					documento.setExtension(Y41bUtils.getExtensionFile(documentoApertura.getX5nofile()));

					Arbdoctemp documentoAperturaAux = this.arbdoctempService.find(documentoApertura);

					Blob contenido = documentoAperturaAux.getX5datafile();
					byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

					documento.setBytes(Y41bUtilsDokusi.encode(bContenido));

					documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
					documento.setProcedure(procedure);

					documento.setRegistryNumber(solarb.getArbexp().getExregen());
					documento.setRegistryTimestamp(Y41bUtils.formatearDateToString(solarb.getArbexp().getExfecreg(),
							Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
					documento.setEntradaSalida(Y41bConstantes.DOCUMENTO_ENTRADA);

					listDocumentos.add(documento);
				}
			}
			proceedings.setDocumentos(listDocumentos);
		}

		cal = Calendar.getInstance();
		cal.setTime(solarb.getArbexp().getExfecreg());
		proceedings.setTimestamp(cal);
		listProceedingsReclamante.add(proceedings);

		proceedings = new Proceedings();
		proceedings.setProceedingsID(Y41bConstantes.LITERAL_PROCEEDINGSID_APERTURA);

		if (solarb.getArbexp().getExformapres() != null
				&& solarb.getArbexp().getExformapres().equals(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB)) {

			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APERTURA_TELEMATICO_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APERTURA_TELEMATICO_EU);
		} else {
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APERTURA_PRESENCIAL_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APERTURA_PRESENCIAL_EU);
		}

		cal = Calendar.getInstance();
		cal.setTime(arbtramexp.getTrfecfin());
		proceedings.setTimestamp(cal);
		listProceedingsReclamante.add(proceedings);
		listProceedingsReclamado.add(proceedings);

		// buscar los tramites
		arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(new Solarb(excodigo));
		Pagination pagination = new Pagination();
		pagination.setSort("TRID");
		pagination.setAscDsc("asc");
		List<Arbtramexp> listTramiteExpediente = this.arbtramexpDao.findAll(arbtramexp, pagination);
		if (listTramiteExpediente != null && listTramiteExpediente.size() > 0) {
			for (int i = 0; i < listTramiteExpediente.size(); i++) {
				arbtramexp = listTramiteExpediente.get(i);

				if (arbtramexp.getTrfecfin() != null && arbtramexp.getTrcodigo() != null
						&& arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_APORTACIONDOCUMENTACION)) {
					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdTramite(arbtramexp.getTrid().toString());
					List<Arbdoctemp> listDocumentosAporta = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux,
							null);
					if (listDocumentosAporta != null && listDocumentosAporta.size() > 0) {
						Arbdoctemp arbdoctemp = null;
						boolean aportadoReclamado = false;
						boolean aportadoReclamante = false;
						for (int j = 0; j < listDocumentosAporta.size(); j++) {
							arbdoctemp = listDocumentosAporta.get(j);
							if (arbdoctemp.getX5origen() != null
									&& (arbdoctemp.getX5origen().equals(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO)
											|| arbdoctemp.getX5origen()
													.equals(Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO))
									&& arbdoctemp.getX5iddocumentum() != null
									&& !arbdoctemp.getX5iddocumentum().equals("")) {
								aportadoReclamado = true;
							}
							if (arbdoctemp.getX5origen() != null
									&& (arbdoctemp.getX5origen().equals(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE)
											|| arbdoctemp.getX5origen()
													.equals(Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE))
									&& arbdoctemp.getX5iddocumentum() != null
									&& !arbdoctemp.getX5iddocumentum().equals("")) {
								aportadoReclamante = true;
							}
						}
						if (aportadoReclamado) {
							listProceedingsReclamado = this.reabrirExpedienteAportacionDocumentacion(arbtramexp,
									listProceedingsReclamado, Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO);
						}
						if (aportadoReclamante) {
							listProceedingsReclamante = this.reabrirExpedienteAportacionDocumentacion(arbtramexp,
									listProceedingsReclamante, Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE);
						}
					}
				} else if (arbtramexp.getTrfecfin() != null && arbtramexp.getTrcodigo() != null
						&& arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_PUBLICACION_BOPVBOE)) {
					Arbtramexp tramiteNotificacion = null;
					if (arbtramexp.getTrtridrel() != null) {
						tramiteNotificacion = this.arbtramexpDao.find(new Arbtramexp(arbtramexp.getTrtridrel()));
						Arbinterv intervinienteTramite = new Arbinterv();
						if (tramiteNotificacion != null && tramiteNotificacion.getTruaidinterv() != null) {
							intervinienteTramite.setUaidinterv(tramiteNotificacion.getTruaidinterv());
							intervinienteTramite = arbintervDao.find(intervinienteTramite);
						} else {
							intervinienteTramite = null;
						}
						if (intervinienteTramite != null) {
							if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO
									.equals(intervinienteTramite.getUatipointerv())
									|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
											.equals(intervinienteTramite.getUatipointerv())
									|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO
											.equals(intervinienteTramite.getUatipointerv())) {
								listProceedingsReclamado = this.reabrirExpedienteAcuseRecibo(arbtramexp,
										listProceedingsReclamado);
							} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE
									.equals(intervinienteTramite.getUatipointerv())
									|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
											.equals(intervinienteTramite.getUatipointerv())
									|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO
											.equals(intervinienteTramite.getUatipointerv())) {
								listProceedingsReclamante = this.reabrirExpedienteAcuseRecibo(arbtramexp,
										listProceedingsReclamante);
							}
						}
					}
				} else if (arbtramexp.getTrfecfin() != null && arbtramexp.getTrcodigo() != null
						&& arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO)
						&& !Y41bConstantes.SITUACION_ACUSERECIBO_NOENTREGADO.equals(arbtramexp.getTrestadoacuse())) {
					Arbtramexp tramiteNotificacion = null;
					if (arbtramexp.getTrtridrel() != null) {
						tramiteNotificacion = this.arbtramexpDao.find(new Arbtramexp(arbtramexp.getTrtridrel()));
						if (tramiteNotificacion != null && tramiteNotificacion.getTruaidinterv() != null) {
							Arbinterv intervinienteTramite = new Arbinterv();
							if (tramiteNotificacion.getTruaidinterv() != null) {
								intervinienteTramite.setUaidinterv(tramiteNotificacion.getTruaidinterv());
								intervinienteTramite = arbintervDao.find(intervinienteTramite);
							} else {
								intervinienteTramite = null;
							}
							if (intervinienteTramite != null) {
								if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO
										.equals(intervinienteTramite.getUatipointerv())
										|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
												.equals(intervinienteTramite.getUatipointerv())
										|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO
												.equals(intervinienteTramite.getUatipointerv())) {
									listProceedingsReclamado = this.reabrirExpedienteAcuseRecibo(arbtramexp,
											listProceedingsReclamado);
								} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE
										.equals(intervinienteTramite.getUatipointerv())
										|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
												.equals(intervinienteTramite.getUatipointerv())
										|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO
												.equals(intervinienteTramite.getUatipointerv())) {
									listProceedingsReclamante = this.reabrirExpedienteAcuseRecibo(arbtramexp,
											listProceedingsReclamante);
								}
							}
						}
					}
				} else if (arbtramexp.getTrfecfin() != null && arbtramexp.getTrcodigo() != null
						&& arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION)) {
					Arbinterv intervinienteTramite = new Arbinterv();
					if (arbtramexp.getTruaidinterv() != null) {
						intervinienteTramite.setUaidinterv(arbtramexp.getTruaidinterv());
						intervinienteTramite = arbintervDao.find(intervinienteTramite);
					} else {
						intervinienteTramite = null;
					}
					if (intervinienteTramite != null) {
						if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO
								.equals(intervinienteTramite.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
										.equals(intervinienteTramite.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO
										.equals(intervinienteTramite.getUatipointerv())) {
							listProceedingsReclamado = this.reabrirExpedienteComunicacion(arbtramexp,
									listProceedingsReclamado);
						} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE
								.equals(intervinienteTramite.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
										.equals(intervinienteTramite.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO
										.equals(intervinienteTramite.getUatipointerv())) {
							listProceedingsReclamante = this.reabrirExpedienteComunicacion(arbtramexp,
									listProceedingsReclamante);
						}
					}
				}
			}
		}
		actualizarExpediente
				.setProceedings(Y41bFuncionesAuxiliaresPlatea.eliminarDuplicadosProceedings(listProceedingsReclamante));
		actualizarExpediente.setProceedingsInteresado(
				Y41bFuncionesAuxiliaresPlatea.eliminarDuplicadosProceedings(listProceedingsReclamado));

		this.y41bPlateaAdapterService.actualizarExpediente(actualizarExpediente);

	}

	/**
	 * Metodo que genera el proceedings para aportacion de documentacion
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteAportacionDocumentacion(Arbtramexp arbtramexp,
			List<Proceedings> listProceedings, String tipo) {

		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(arbtramexp.getTrid().toString());
		List<Arbdoctemp> listDocumentosAporta = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux, null);
		if (listDocumentosAporta != null && listDocumentosAporta.size() > 0) {
			Arbdoctemp arbdoctemp = null;
			boolean aportado = false;
			for (int j = 0; j < listDocumentosAporta.size(); j++) {
				arbdoctemp = listDocumentosAporta.get(j);
				if (arbdoctemp.getX5origen() != null && arbdoctemp.getX5origen().equals(tipo)
						&& arbdoctemp.getX5iddocumentum() != null && !arbdoctemp.getX5iddocumentum().equals("")) {
					aportado = true;
					break;
				}
			}
			if (aportado) {
				Proceedings proceedings = new Proceedings();
				if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
					proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
				} else {
					proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());
				}

				proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
				proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_EU);
				Calendar cal = Calendar.getInstance();
				cal.setTime(arbtramexp.getTrfecfin());
				proceedings.setTimestamp(cal);

				ArrayList<Documento> documentos = new ArrayList<Documento>();
				if (listDocumentosAporta != null && listDocumentosAporta.size() > 0) {
					for (int k = 0; k < listDocumentosAporta.size(); k++) {
						arbdoctemp = listDocumentosAporta.get(k);
						Documento documento = new Documento();
						if (arbdoctemp.getX5origen() != null && arbdoctemp.getX5origen().equals(tipo)
								&& arbdoctemp.getX5iddocumentum() != null
								&& !arbdoctemp.getX5iddocumentum().equals("")) {
							documento.setOidDokusi(arbdoctemp.getX5iddocumentum());
							documento.setNombre(arbdoctemp.getX5nofile());
							documento.setDescripcion(arbdoctemp.getX5tedesfile());
							documentos.add(documento);
						}
					}
				}

				proceedings.setDocumentos(documentos);

				listProceedings.add(proceedings);

			}
		}
		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para comunicacion
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteComunicacion(Arbtramexp arbtramexp, List<Proceedings> listProceedings) {

		Arbtramexp arbtramexpAux = new Arbtramexp();
		arbtramexpAux.setTrid(arbtramexp.getTrid());
		arbtramexpAux = arbtramexpDao.find(arbtramexpAux);
		boolean remesaEmitida = true;
		if (arbtramexpAux.getTrenvrem() != null && arbtramexpAux.getTrenvrem().equals(Y41bConstantes.VALOR_SI)) {

			if (arbtramexpAux.getTrcodrem() != null && !arbtramexpAux.getTrcodrem().equals("")) {
				// buscar remesa
				Remesa remesa = new Remesa();
				remesa.setRmcodigo(arbtramexpAux.getTrcodrem());
				remesa = this.remesaDao.find(remesa);

				if (!remesa.getRmestado().equals(Y41bConstantes.ESTADO_REMESA_EMITIDA)) {
					remesaEmitida = false;
				}
			} else {
				remesaEmitida = false;
			}
		}

		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUaidinterv(arbtramexp.getTruaidinterv());
		arbinterv = this.arbintervdao.find(arbinterv);

		if (arbinterv != null && arbinterv.getUatipointerv() != null
				&& (arbtramexp.getTrtipocom() != null
						&& (arbtramexp.getTrtipocom().equals(Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO)
								|| arbtramexp.getTrtipocom().equals(Y41bConstantes.TIPO_COMUNICACION_TELEMATICA)))
				&& remesaEmitida) {
			Arbtramexp tramiteRelacionado = null;
			if (arbtramexp.getTrtridrel() != null) {
				tramiteRelacionado = this.arbtramexpDao.find(new Arbtramexp(arbtramexp.getTrtridrel()));
			}
			if (tramiteRelacionado != null) {
				if (!Y41bUtils.esNullOCadenaVacia(tramiteRelacionado.getTrproceedingsidplatea())
						&& !existeProceedingsID(tramiteRelacionado.getTrproceedingsidplatea(), listProceedings)) {
					listProceedings = this.reabrirExpedienteTramite(tramiteRelacionado, listProceedings);
				}
			}

			Proceedings proceedings = new Proceedings();

			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());
			}

			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_COMUNICACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_COMUNICACION_EU);
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);

			if (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(arbtramexp.getTrtipocom())) {
				proceedings.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
			} else {
				proceedings.setTipoNotificacion(Y41bConstantes.POSTAL);
			}

			proceedings.setOidnotification(arbtramexp.getTridnotifplatea());

			proceedings.setNotifiedActId(Y41bConstantes.NOTIFICACION_COMUNICACION);

			proceedings.setDesnotifiedActCast(Y41bConstantes.LITERAL_COMUNICACION_ES);
			proceedings.setDesnotifiedActEus(Y41bConstantes.LITERAL_COMUNICACION_EU);

			cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setNotifiedPublicationtimestamp(cal);

			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(arbtramexp.getTrid().toString());
			List<Arbdoctemp> listDocumentoComunicacion = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux,
					null);

			List<Documento> documentos = new ArrayList<Documento>();
			if (listDocumentoComunicacion != null && listDocumentoComunicacion.size() > 0) {
				Arbdoctemp arbdoctemp = null;
				for (int k = 0; k < listDocumentoComunicacion.size(); k++) {
					arbdoctemp = listDocumentoComunicacion.get(k);
					Documento documento = new Documento();
					if (arbdoctemp.getX5iddocumentum() != null && !arbdoctemp.getX5iddocumentum().equals("")) {
						documento.setOidDokusi(arbdoctemp.getX5iddocumentum());
						documento.setNombre(arbdoctemp.getX5nofile());
						documento.setDescripcion(arbdoctemp.getX5tedesfile());
						documentos.add(documento);
					}
				}
			}

			proceedings.setDocumentosNotificacionComunicacion(documentos);

			listProceedings.add(proceedings);
		}

		return listProceedings;
	}

	/**
	 * 
	 * @param id
	 *            String
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return boolean
	 */
	private boolean existeProceedingsID(String id, List<Proceedings> listProceedings) {
		boolean existe = false;
		Proceedings proceedings = new Proceedings();
		for (int i = 0; i < listProceedings.size(); i++) {
			proceedings = listProceedings.get(i);
			if (id.equals(proceedings.getProceedingsID())) {
				existe = true;
				break;
			}
		}
		return existe;
	}

	/**
	 * Metodo que genera el proceedings para acuse recibo
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 * @throws Exception
	 */
	private List<Proceedings> reabrirExpedienteAcuseRecibo(Arbtramexp arbtramexp, List<Proceedings> listProceedings)
			throws Exception {

		Arbtramexp acuseRelacionado = null;
		if (Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO.equals(arbtramexp.getTrcodigo())) {
			acuseRelacionado = arbtramexp;
		} else {
			// Buscamos un acuse con la misma notificacion relacionada
			Arbtramexp arbtramexpAux = new Arbtramexp();
			arbtramexpAux.setSolarb(new Solarb(arbtramexp.getSolarb().getSacodigo()));
			arbtramexpAux.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO);
			arbtramexpAux.setTrtridrel(arbtramexp.getTrtridrel());
			List<Arbtramexp> listaArbtramexp = this.arbtramexpDao.findAll(arbtramexpAux, null);
			if (listaArbtramexp != null && listaArbtramexp.size() > 0) {
				acuseRelacionado = listaArbtramexp.get(0);
			}
		}

		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUaidinterv(arbtramexp.getTruaidinterv());
		arbinterv = this.arbintervdao.find(arbinterv);
		Arbtramexp tramiteNotificacion = null;
		Arbtramexp tramiteRelacionado = null;

		if (arbtramexp.getTrtridrel() != null) {
			tramiteNotificacion = this.arbtramexpDao.find(new Arbtramexp(arbtramexp.getTrtridrel()));
			if (tramiteNotificacion != null) {
				if (tramiteNotificacion.getTrtridrel() != null) {
					tramiteRelacionado = this.arbtramexpDao.find(new Arbtramexp(tramiteNotificacion.getTrtridrel()));
				}
				if (tramiteRelacionado != null) {
					if (!Y41bUtils.esNullOCadenaVacia(tramiteRelacionado.getTrproceedingsidplatea())
							&& !existeProceedingsID(tramiteRelacionado.getTrproceedingsidplatea(), listProceedings)) {
						if (tramiteRelacionado.getTrfecfin() != null && tramiteRelacionado.getTrcodigo() != null) {
							listProceedings = this.reabrirExpedienteTramite(tramiteRelacionado, listProceedings);
						}
					}
				}

				Proceedings proceedings = new Proceedings();

				if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
					proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
				} else {
					proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());
				}

				proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_NOTIFICACION_ES);
				proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_NOTIFICACION_EU);
				Calendar cal = Calendar.getInstance();
				cal.setTime(arbtramexp.getTrfecfin());
				proceedings.setTimestamp(cal);

				if (tramiteNotificacion != null) {
					if (Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(tramiteNotificacion.getTrtiponot())) {
						proceedings.setTipoNotificacion(Y41bConstantes.ELECTRONICO);
					} else {
						proceedings.setTipoNotificacion(Y41bConstantes.POSTAL);
					}
					proceedings.setOidnotification(tramiteNotificacion.getTridnotifplatea());

					// El tipo de notificacion para PLATEA
					// En la JSP va "REQ_ACREDITA" para distinguirlo del
					// tipo de pago
					// pericial
					// Antes de enviar a Platea tenemos que tratarlo
					if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_REQUERIMIENTO_ACREDITACION
							.equals(tramiteNotificacion.getTrtiponotplatea())) {
						proceedings.setNotifiedActId(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_REQUERIMIENTO);
					} else {
						proceedings.setNotifiedActId(tramiteNotificacion.getTrtiponotplatea());
					}

					cal = Calendar.getInstance();
					cal.setTime(tramiteNotificacion.getTrfecfin());
					proceedings.setNotifiedPublicationtimestamp(cal);
				}

				if (Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO.equals(arbtramexp.getTrcodigo())) {
					cal = Calendar.getInstance();
					cal.setTime(acuseRelacionado.getTrfecacuse());
					proceedings.setNotifiedDeliverytimestamp(cal);
					proceedings.setNotifiedResult(acuseRelacionado.getTrestadoacuse());
				} else {
					// No entregado publicado en el BOE, no hay
					// NotifiedDeliverytimestamp
					proceedings.setNotifiedResult(Y41bUtils
							.formatearDateToString(arbtramexp.getTrfecinitabl(), Y41bConstantes.FORMATO_FECHA_ES)
							.concat("@").concat(Y41bUtils.formatearDateToString(arbtramexp.getTrfecinitabl(),
									Y41bConstantes.FORMATO_FECHA_EU)));
				}

				if (tramiteNotificacion != null) {
					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdTramite(tramiteNotificacion.getTrid().toString());
					List<Arbdoctemp> listDocumentoComunicacion = this.arbdoctempDao
							.findAllDocumentosTramite(tramiteComunAux, null);
					List<Documento> documentos = new ArrayList<Documento>();
					if (listDocumentoComunicacion != null && listDocumentoComunicacion.size() > 0) {
						Arbdoctemp arbdoctemp = null;

						for (int k = 0; k < listDocumentoComunicacion.size(); k++) {
							arbdoctemp = listDocumentoComunicacion.get(k);
							Documento documento = new Documento();
							if (arbdoctemp.getX5iddocumentum() != null && !arbdoctemp.getX5iddocumentum().equals("")) {
								documento.setOidDokusi(arbdoctemp.getX5iddocumentum());
								documento.setNombre(arbdoctemp.getX5nofile());
								documento.setDescripcion(arbdoctemp.getX5tedesfile());
								documentos.add(documento);
							}
						}
					}
					proceedings.setDocumentosNotificacionComunicacion(documentos);
					listProceedings.add(proceedings);
				}
			}
		}
		return listProceedings;
	}

	/**
	 * Metodo que genera el proceedings para comunicacion
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param listProceedings
	 *            List<Proceedings>
	 * @return List
	 */
	private List<Proceedings> reabrirExpedienteTramite(Arbtramexp arbtramexp, List<Proceedings> listProceedings) {

		if (Y41bConstantes.TRAMITE_ARBITRAJE_SUBSANACION.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_SUBSANACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_SUBSANACION_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_NO_ADHERIDA.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_ADHERIDA_LIM.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_RESULTADO_ANALISIS_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_RESULTADO_ANALISIS_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_CONVENIO_ARBITRAL_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_CONVENIO_ARBITRAL_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_ALEGACIONES.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_RECEPCION_ALEGACIONES_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_RECEPCION_ALEGACIONES_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_DESIGNACION_COLEGIO_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_DESIGNACION_COLEGIO_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_CITACION_AUDIENCIA_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_CITACION_AUDIENCIA_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_SUSPENSION_AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_SUSPENSION_AUDIENCIA_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_SUSPENSION_AUDIENCIA_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_AUDIENCIA_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_AUDIENCIA_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_CITACION_A_PRUEBA_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_CITACION_A_PRUEBA_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_CITACION_2AUDIENCIA_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_CITACION_2AUDIENCIA_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_2AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_2AUDIENCIA_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_2AUDIENCIA_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_LAUDO_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_LAUDO_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_ACLARACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_ACLARACION_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_RECEPCION_SOLICITUD_ACLARACION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_RECEPCION_SOLICITUD_ACLARACION_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_RECEPCION_INFORME_PERICIAL_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_RECEPCION_INFORME_PERICIAL_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_PAGO_PERICIAL_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_PAGO_PERICIAL_EU);
			listProceedings.add(proceedings);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(arbtramexp.getTrcodigo())) {
			Proceedings proceedings = new Proceedings();
			Calendar cal = Calendar.getInstance();
			cal.setTime(arbtramexp.getTrfecfin());
			proceedings.setTimestamp(cal);
			if (arbtramexp != null && !Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrproceedingsidplatea())) {
				proceedings.setProceedingsID(arbtramexp.getTrproceedingsidplatea());
			} else {
				proceedings.setProceedingsID(arbtramexpDao.getNewPKProceedingsPlatea().toString());

				arbtramexp.setTrproceedingsidplatea(proceedings.getProceedingsID());
				this.arbtramexpDao.updateProceedingsIdPlatea(arbtramexp);
			}
			proceedings.setProceedingsDescriptionCast(Y41bConstantes.LITERAL_RESOLUCION_ES);
			proceedings.setProceedingsDescriptionEus(Y41bConstantes.LITERAL_RESOLUCION_EU);
			Decision decision = new Decision();
			decision.setDecodigo(arbtramexp.getTrresotipo());
			decision = this.decisionDao.find(decision);
			proceedings.setDecisionCast(decision.getDenombre());
			proceedings.setDecisionEus(decision.getDenombree());
			Calendar decisionTimestamp = Calendar.getInstance();
			decisionTimestamp.setTime(arbtramexp.getTrresofecha());
			proceedings.setDecisiontimestamp(decisionTimestamp);
			listProceedings.add(proceedings);
		}

		return listProceedings;
	}

	/**
	 * Generar Tramite Generico de reapertura de expediente
	 * 
	 * @param expedien
	 *            Solarb
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private Arbtramexp generarTramiteGenericoReabrirExpediente(Solarb solarb, CensoMonitor censoMonitor)
			throws Exception {

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setTrfecini(todayWithZeroTime);
		arbtramexp.setTrfecfin(todayWithZeroTime);
		arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_GENERICO);
		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setCensoMonitor(censoMonitor);
		arbtramexp.setCensoMonitorEj(censoMonitor);
		arbtramexp.setTrid(arbtramexpDao.getNewPK().toString());
		arbtramexp.setTrnomtrames(Y41bConstantes.NOMBRE_TRAMITE_GENERICO_REAPERTURA);
		this.arbtramexpDao.add(arbtramexp);

		return arbtramexp;
	}

	/**
	 * Reabrir expediente
	 * 
	 * @param excodigo
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void reabrirExpedienteCancelClose(String excodigo, CensoMonitor censoMonitor) throws Exception {

	}

	/**
	 * reabrirTramite
	 * 
	 * @param arbtramexpRel
	 *            Arbtramexp
	 */
	private void reabrirTramite(Arbtramexp arbtramexpRel) {
		if (arbtramexpRel != null && !Y41bUtils.esNullOCadenaVacia(arbtramexpRel.getTrproceedingsidplatea())) {
			try {
				this.eliminarMisGestiones(arbtramexpRel);
			} catch (Exception e) {
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
		this.arbtramexpDao.updateReabrirTramite(arbtramexpRel);
	}

	/**
	 * getTipoDocumento
	 * 
	 * @param roleId
	 *            String
	 * @return String
	 */
	protected String getTipoDocumento(String roleId) {
		String resultado = null;
		StringTokenizer tokCadena = null;
		tokCadena = new StringTokenizer(roleId, ".");
		String tipo = tokCadena.nextToken();
		String subtipo = tokCadena.nextToken();
		if (subtipo != null && !subtipo.equals("0")) {
			tipo = subtipo;
		} else {
			String asuntodocumental = tokCadena.nextToken();
			if (asuntodocumental != null && !asuntodocumental.equals("0")) {
				tipo = roleId;
			}
		}
		Arbtipdoc arbtipdoc = new Arbtipdoc();
		arbtipdoc.setIdTipodoc(tipo);
		List<Arbtipdoc> listaArbtipdoc = this.arbtipdocDao.findAll(arbtipdoc, null);
		if (listaArbtipdoc == null || (listaArbtipdoc != null && listaArbtipdoc.size() != 1)) {
			resultado = Y41bConstantes.TIPO_DOC_ARB_APORTACIONDOCUMENTACION;
		} else {
			resultado = ((Arbtipdoc) listaArbtipdoc.get(0)).getTdid();
		}
		return resultado;
	}

	/*
	 * # INICIO # ADAPTACIONES LEY 39 private void
	 * tratarDocumentosSolicitudMisGestiones(Documento docDokusi, Solarb solarb,
	 * String origenDocumento) { if
	 * (Y41bConstantes.TIPO_DOC_SOLICITUD.equalsIgnoreCase(docDokusi
	 * .getTipoDocumental())) { if
	 * (Y41bConstantes.NOMBRE_DOCUMENTO_SOLICITUD_DATOS_AVISO_ES
	 * .equalsIgnoreCase(docDokusi.getNombre()) ||
	 * Y41bConstantes.NOMBRE_DOCUMENTO_SOLICITUD_DATOS_AVISO_EU
	 * .equalsIgnoreCase(docDokusi.getNombre())) {
	 * this.tratarDocumentoDatosAviso(docDokusi, solarb, origenDocumento); }
	 * else if (Y41bConstantes.NOMBRE_DOCUMENTO_SOLICITUD_DATOS_NOTIFICACION_ES
	 * .equalsIgnoreCase(docDokusi.getNombre()) ||
	 * Y41bConstantes.NOMBRE_DOCUMENTO_SOLICITUD_DATOS_NOTIFICACION_EU
	 * .equalsIgnoreCase(docDokusi.getNombre())) {
	 * this.tratarDocumentoDatosNotificacion(docDokusi, solarb,
	 * origenDocumento); } } }
	 * 
	 * private void tratarDocumentoDatosAviso(Documento docDokusi, Solarb
	 * solarb, String origenDocumento) { String fichero = docDokusi.getBytes();
	 * String mail = Y41bUtils.localizarMailEnXML(fichero); String telefono =
	 * Y41bUtils.localizarTelefonoEnXML(fichero); // guardar los datos de mail y
	 * telefono en interviniente // correspondiente y en platea Arbinterv
	 * arbinterv = null; Arbinterv arbintervRep = null; if
	 * (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO
	 * .equalsIgnoreCase(origenDocumento) ||
	 * Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO
	 * .equalsIgnoreCase(origenDocumento)) { arbinterv =
	 * arbintervdao.dameInterviniente(solarb.getSacodigo(),
	 * Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO); arbintervRep =
	 * arbintervdao.dameInterviniente(solarb.getSacodigo(),
	 * Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO); } else if
	 * (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE
	 * .equalsIgnoreCase(origenDocumento) ||
	 * Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE
	 * .equalsIgnoreCase(origenDocumento)) { arbinterv =
	 * arbintervdao.dameInterviniente(solarb.getSacodigo(),
	 * Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE); arbintervRep =
	 * arbintervdao.dameInterviniente(solarb.getSacodigo(),
	 * Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE); }
	 * 
	 * if (arbintervRep != null) {
	 * arbintervRep.setUanrtel(Y41bUtils.idiomaOneChar(telefono));
	 * arbintervRep.setUacoem(Y41bUtils.idiomaOneChar(mail));
	 * arbintervdao.update(arbintervRep); } else if (arbinterv != null) {
	 * arbinterv.setUanrtel(Y41bUtils.idiomaOneChar(telefono));
	 * arbinterv.setUacoem(Y41bUtils.idiomaOneChar(mail));
	 * arbintervdao.update(arbinterv); }
	 * 
	 * if (Y41bUtils.interactuarConDokusi()) { if
	 * (Y41bConstantes.VALOR_SI.equals(solarb.getArbexp().getPlatea())) { if
	 * (arbinterv != null && arbinterv.getUanif() != null) { CensoMonitor
	 * censoMonitor = new CensoMonitor();
	 * censoMonitor.setMocodigo(Y41bConstantes.COD_APLICACION);
	 * censoMonitor.setModni(Y41bConstantes.COD_APLICACION);
	 * censoMonitor.setMonombre(Y41bConstantes.COD_APLICACION);
	 * arbintervService.actualizarParticipantPlatea(solarb, arbinterv,
	 * censoMonitor, false); } } } }
	 * 
	 * private void tratarDocumentoDatosNotificacion(Documento docDokusi, Solarb
	 * solarb, String origenDocumento) { String fichero = docDokusi.getBytes();
	 * String idioma = Y41bUtils.localizarIdiomaEnXML(fichero); // guardar el
	 * dato de idioma en interviniente correspondiente y en // platea Arbinterv
	 * arbinterv = null; if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO
	 * .equalsIgnoreCase(origenDocumento) ||
	 * Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO
	 * .equalsIgnoreCase(origenDocumento)) { arbinterv =
	 * arbintervdao.dameInterviniente(solarb.getSacodigo(),
	 * Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO); } else if
	 * (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE
	 * .equalsIgnoreCase(origenDocumento) ||
	 * Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE
	 * .equalsIgnoreCase(origenDocumento)) { arbinterv =
	 * arbintervdao.dameInterviniente(solarb.getSacodigo(),
	 * Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE); }
	 * 
	 * if (arbinterv != null) {
	 * arbinterv.setUaidioma(Y41bUtils.idiomaOneChar(idioma));
	 * arbintervdao.update(arbinterv); if (Y41bUtils.interactuarConDokusi()) {
	 * if (Y41bConstantes.VALOR_SI.equals(solarb.getArbexp() .getPlatea())) { if
	 * (arbinterv != null && arbinterv.getUanif() != null) { CensoMonitor
	 * censoMonitor = new CensoMonitor();
	 * censoMonitor.setMocodigo(Y41bConstantes.COD_APLICACION);
	 * censoMonitor.setModni(Y41bConstantes.COD_APLICACION);
	 * censoMonitor.setMonombre(Y41bConstantes.COD_APLICACION);
	 * arbintervService.actualizarParticipantPlatea(solarb, arbinterv,
	 * censoMonitor, false); } } } } } # FIN #
	 */

	/**
	 * Generar Tramite Automatico de Requerimiento de Acreditacion de
	 * Representacion
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbtramexp
	 * @throws Exception
	 *             e
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp sugiereTramiteRequerimientoAcreditacionRepresentacion(Arbinterv arbinterv) throws Exception {

		Solarb solarb = new Solarb();
		solarb.setSacodigo(arbinterv.getSolarb().getSacodigo());
		solarb = this.solarbDao.find(solarb);

		Arbtramexp arbtramexpNuevo = new Arbtramexp();

		arbtramexpNuevo.setSolarb(solarb);
		arbtramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_REQUERIMIENTOACREDITACIONREPRESENTACION);
		arbtramexpNuevo.setTrfecini(Y41bUtils.obtenerFechaHoy());
		arbtramexpNuevo.setCensoMonitor(new CensoMonitor(solarb.getArbexp().getExmocodigo(), null));
		arbtramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		arbtramexpNuevo.setTruaidinterv(arbinterv.getUaidinterv());
		arbtramexpNuevo.setFase(solarb.getArbexp().getFase());

		arbtramexpNuevo.setTrid(arbtramexpDao.getNewPK().toString());

		if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO
				.equals(arbinterv.getUatipointerv())) {
			arbtramexpNuevo.setTipoDestOrigen(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO);
			arbtramexpNuevo.setTipoDestOrigen(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO
				.equals(arbinterv.getUatipointerv())) {
			arbtramexpNuevo.setTipoDestOrigen(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
		}
		// Se inserta el tramite
		this.arbtramexpDao.add(arbtramexpNuevo);

		return arbtramexpNuevo;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBPagoPericialColegio
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramitePagoPericialColegio(TramiteARBPagoPericialColegio tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBPagoPericialColegio) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_RESOLUCION_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		// arbtramexp.setTrfeopla(tramite.getFecha());
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 2) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documento2Exception", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            monitor
	 * @return tramite
	 */
	public TramiteARBPagoPericialColegio findTramitePagoPericialColegio(TramiteARBPagoPericialColegio tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			String trid = tramite.getIdTramite();
			arbtramexp.setTrid(trid);
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBPagoPericialColegio tramiteAux = new TramiteARBPagoPericialColegio();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());
			tramiteAux.setFecha(arbtramexp.getTrfeopla());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			Arbtramexp4ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Aporta el justificante del acuse telematico al tramite de acuse
	 * 
	 * @param tramiteAcuseArb
	 *            Arbtramexp
	 * @param justificanteAcuse
	 *            Documento
	 */
	public void aportarJustificanteAcuseRecibo(Arbtramexp tramiteAcuseArb, Documento justificanteAcuse) {

		DocumentoHecho docHechoJustificanteAcuse = new DocumentoHecho();
		docHechoJustificanteAcuse.setQ5codocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

		docHechoJustificanteAcuse.setQ5origen(Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION);
		docHechoJustificanteAcuse.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_ARB_ACUSE);
		docHechoJustificanteAcuse.setQ5iddocumentum(justificanteAcuse.getOidDokusi());
		docHechoJustificanteAcuse.setQ5contenttypefile(justificanteAcuse.getContentType());
		docHechoJustificanteAcuse.setQ5nofile(justificanteAcuse.getNombre());
		docHechoJustificanteAcuse.setQ5tedesfile(Y41bConstantes.JUSTIFICANTE_NOTIFICACION_ELECTRONICA);
		docHechoJustificanteAcuse.setQ5sizefile((int) justificanteAcuse.getLength());
		docHechoJustificanteAcuse.setQ5hdcodigo(tramiteAcuseArb.getTrexcodigo());
		docHechoJustificanteAcuse.setQ5tramite(tramiteAcuseArb.getTrid());
		docHechoJustificanteAcuse.setQ5fecha(new Date());

		this.documentoHechoDao.add(docHechoJustificanteAcuse);

		DocumentoTramiteHecho documentoTramiteHecho = new DocumentoTramiteHecho();
		documentoTramiteHecho.setEhcodigo(tramiteAcuseArb.getTrid());
		documentoTramiteHecho.setCodocumento(docHechoJustificanteAcuse.getQ5codocumento());
		documentoTramiteHecho.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
		this.documentoHechoDao.addDocsTramiteHecho(documentoTramiteHecho);

	}

}