package com.ejie.y41b.service;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbenvio;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.TramiteARBAclaracion;
import com.ejie.y41b.model.TramiteARBLaudo;
import com.ejie.y41b.model.TramiteARBPagoLaudo;
import com.ejie.y41b.model.TramiteARBPagoPericialColegio;
import com.ejie.y41b.model.TramiteARBPropuestaSancionador;
import com.ejie.y41b.model.TramiteARBRecepcionAlegaciones;
import com.ejie.y41b.model.TramiteARBResolucion;
import com.ejie.y41b.model.TramiteBOPVAyto;
import com.ejie.y41b.model.TramiteCierre;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteElaboracionBOPVAyto;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.platea.MensajeAportacionDocumentacion;

/**
 * ArbtramexpService  
 * 
 *  
 */

public interface Arbtramexp4Service {

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteBOPVAyto
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	TramiteBOPVAyto findTramiteBOPVAyto(TramiteBOPVAyto tramite,
			CensoMonitor monitor) throws SQLException, IOException;

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramite
	 *            TramiteElaboracionBOPVAyto
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteElaboracionBOPVAyto
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	TramiteElaboracionBOPVAyto findTramiteElaboracionBOPVAyto(
			TramiteElaboracionBOPVAyto tramite, CensoMonitor monitor)
			throws SQLException, IOException;

	/**
	 * Tramitar BOPVAyto
	 * 
	 * @param tramite
	 *            TramiteBOPVAyto
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteBOPVAyto(TramiteBOPVAyto tramite,
			TramiteComun tramiteComun, boolean tramitar, String modoEditar,
			CensoMonitor censoMonitor) throws Exception;

	/**
	 * Tramitar BOPVAyto
	 * 
	 * @param tramite
	 *            TramiteElaboracionBOPVAyto
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteElaboracionBOPVAyto(
			TramiteElaboracionBOPVAyto tramite, TramiteComun tramiteComun,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado
	 * 
	 * @param santramexp
	 *            Arbtramexp
	 * @param listDocumentos
	 *            List<Arbdoctemp>
	 * @throws SQLException
	 */
	void actualizarMisGestionesComunicacion(Arbtramexp santramexp,
			List<Arbdoctemp> listDocumentos, CensoMonitor censoMonitor)
			throws SQLException;

	/**
	 * Metodo que actualiza en Mis Gestiones el tramite de comunicacin
	 * realizado
	 * 
	 * @param santramexp
	 *            Arbtramexp
	 * @param listDocumentos
	 *            List<Arbdoctemp>
	 * @throws SQLException
	 * @throws ParseException
	 */
	void actualizarMisGestionesNotificacion(Arbtramexp santramexp,
			List<Arbdoctemp> listDocumentos, CensoMonitor censoMonitor)
			throws SQLException, ParseException;

	/**
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param listDocumentos
	 *            List<Arbdoctemp>
	 * @throws Exception
	 *             Exception
	 */
	void actualizarMisGestionesAportaciondocumentacion(Arbtramexp arbtramexp,
			List<Arbdoctemp> listDocumentos) throws Exception;

	/**
	 * @param arbtramexp
	 * @hrows SQLException
	 */
	void eliminarMisGestiones(Arbtramexp arbtramexp) throws SQLException;

	/**
	 * @param arbtramexp
	 */
	void actualizaExpedienteTrasEliminar(Arbtramexp arbtramexp);

	/**
	 * @param arbexp
	 * @return
	 */
	Arbtramexp calculaUltimoTramiteArbExp(Arbexp arbexp);

	/**
	 * @param arbtramexp
	 */
	void remove(Arbtramexp arbtramexp);

	/**
	 * Finds a single row in the arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            the arbtramexp
	 */
	void actualizaExpedienteTrasTramitar(Arbtramexp arbtramexp);

	/**
	 * Inserts a single row in the Arbtramexp table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteGenerico(TramiteGenerico tramiteGenerico,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoEditar) throws Exception;

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param monitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	TramiteGenerico findTramiteGenerico(TramiteGenerico tramiteGenerico,
			CensoMonitor monitor);

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteCierre
	 *            TramiteCierre
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteGenerico
	 */
	TramiteCierre findTramiteCierre(TramiteCierre tramiteCierre,
			CensoMonitor monitor);

	/**
	 * Tramitar cierre.
	 * 
	 * @param tramiteCierre
	 *            the tramite cierre
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteCierre(TramiteCierre tramiteCierre,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoEditar) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBLaudo
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteLaudo(TramiteARBLaudo tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBLaudo) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBLaudo findTramiteLaudo(TramiteARBLaudo tramite,
			CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBPagoLaudo
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramitePagoLaudo(TramiteARBPagoLaudo tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBPagoLaudo) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBPagoLaudo findTramitePagoLaudo(TramiteARBPagoLaudo tramite,
			CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBResolucion
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteResolucion(TramiteARBResolucion tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBResolucion) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBResolucion findTramiteResolucion(TramiteARBResolucion tramite,
			CensoMonitor censoMonitor);

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param expedienAux
	 *            Solarb
	 * @param mensajeAportacionDoc
	 *            MensajeAportacionDocumentacion
	 * @throws Exception
	 *             Exception
	 */
	void generarTramiteAportacionDocumentacion(Solarb expediente,
			MensajeAportacionDocumentacion mensajeAportacionDoc)
			throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBPropuestaSancionador
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramitePropuestaSancionador(
			TramiteARBPropuestaSancionador tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBPropuestaSancionador)
			throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBPropuestaSancionador findTramitePropuestaSancionador(
			TramiteARBPropuestaSancionador tramite, CensoMonitor monitor);

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addTramiteAdjuntarInfraccArbTableTemporal(TramiteComun tramiteComun);

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBRecepcionAlegaciones
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteRecepcionAlegaciones(
			TramiteARBRecepcionAlegaciones tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBRecepcionAlegaciones)
			throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBRecepcionAlegaciones findTramiteRecepcionAlegaciones(
			TramiteARBRecepcionAlegaciones tramite, CensoMonitor monitor);

	/**
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param arbenvio
	 *            Arbenvio
	 */
	void actualizaExpedienteAlEnviarComNot(Arbtramexp arbtramexp,
			Arbenvio arbenvio);

	/**
	 * Finds a List of rows in the Documentos Hecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoExpediente> findAllDocumentosHechoComunicacion(
			TramiteComun tramiteComun, Pagination pagination);

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun);

	/**
	 * 
	 * @param tramiteAux
	 *            TramiteARBLaudo
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return TramiteARBLaudo
	 */
	Arbtramexp obtenerDatosPorDefectoLaudo(Arbtramexp arbtramexp);

	/**
	 * 
	 * @param tramite
	 *            TramiteARBAclaracion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            tramitar
	 * @param modoARBAclaracion
	 *            String
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteAclaracion(TramiteARBAclaracion tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBAclaracion) throws Exception;

	/**
	 * reabrirExpediente
	 * 
	 * @param excodigo
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @throws Exception
	 *             e
	 */
	void reabrirExpediente(String excodigo, CensoMonitor censoMonitor)
			throws Exception;

	/**
	 * Generar Tramite Automatico de Requerimiento de Acreditacion de
	 * Representacion
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbtramexp
	 * @throws Exception
	 *             e
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp sugiereTramiteRequerimientoAcreditacionRepresentacion(
			Arbinterv arbinterv) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBPagoPericial
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramitePagoPericialColegio(
			TramiteARBPagoPericialColegio tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBPagoPericialColegio)
			throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBPagoPericialColegio findTramitePagoPericialColegio(
			TramiteARBPagoPericialColegio tramite, CensoMonitor censoMonitor);

	void aportarJustificanteAcuseRecibo(Arbtramexp tramiteAcuseArb,
			Documento justificanteAcuse);

}
