// CHECKSTYLE:OFF
package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.adapter.helper.Y41bDokusiHelper;
import com.ejie.y41b.adapter.services.N61ServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjunDatosAvisosEstablecDao;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.ArbbandejaDao;
import com.ejie.y41b.dao.ArbdoctempDao;
import com.ejie.y41b.dao.ArbenvioDao;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.dao.BandejaFirmaDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.PlantillaDecisionDao;
import com.ejie.y41b.dao.PlantillaTramiteDao;
import com.ejie.y41b.dao.RemesaDao;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.AdjunDatosAvisosEstablec;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbbandeja;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbenvio;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.AttachFile;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoTramiteHecho;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.PlantillaDecision;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteARBComunicaArbitros;
import com.ejie.y41b.model.TramiteAcuseRecibo;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TramiteComunicacion;
import com.ejie.y41b.model.TramiteNotificacion;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.Formato;
import com.ejie.y41b.model.dokusi.Metadato;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.CrearNotifEJGV;
import com.ejie.y41b.model.platea.DatosPersona;
import com.ejie.y41b.model.platea.DatosRegistro;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;
import com.ejie.y41b.model.platea.RespuestaNotificacion;
import com.ejie.y41b.model.platea.SolicitudPresencial;
import com.ejie.y41b.model.platea.SolicitudTelematica;
import com.ejie.y41b.n61.ArrayOfWSParamPerson;
import com.ejie.y41b.n61.WSOutputRegister;
import com.ejie.y41b.n61.WSParamOutputRegisterEx;
import com.ejie.y41b.n61.WSParamPerson;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.fichero.Y41bFicheroUtils;
import com.ejie.y41b.utils.platea.Y41bFuncionesAuxiliaresPlatea;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;
import com.ejie.y41b.ws.cliente.x43notificaciones.TNotification;
import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;

/**
 * ArbtramexpServiceImpl  
 * 
 *  
 */

@Service(value = "arbtramexp3Service")
public class Arbtramexp3ServiceImpl extends Arbtramexp5ServiceImpl implements Arbtramexp3Service {

	private static final Logger logger = LoggerFactory.getLogger(Arbtramexp3ServiceImpl.class);

	@Autowired()
	private ArbtramexpDao arbtramexpDao;

	@Autowired()
	private ArbexpService arbexpService;

	@Autowired()
	private CensoMonitorDao censoMonitorDao;

	@Autowired()
	private ArbdoctempDao arbdoctempDao;
	@Autowired()
	private AdjuntardocsDao adjuntardocsDao;
	@Autowired()
	private BandejaFirmaDao bandejaFirmaDao;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;
	@Autowired()
	private ArbintervDao arbintervdao;
	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;
	@Autowired()
	private PlantillaTramiteDao plantillaTramiteDao;
	@Autowired()
	private PlantillaDecisionDao plantillaDecisionDao;
	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired()
	private ArbenvioDao arbenvioDao;
	@Autowired()
	private ParametrosDao parametrosDao;
	@Autowired()
	private EstablecimientoService establecimientoService;
	@Autowired()
	private RemesaDao remesaDao;
	@Autowired()
	private ArbbandejaDao arbbandejaDao;
	@Autowired()
	private ArbtramexpService arbtramexpService;
	@Autowired()
	private Arbtramexp2Service arbtramexp2Service;
	@Autowired()
	private Arbtramexp4Service arbtramexp4Service;
	@Autowired()
	private ArbdoctempService arbdoctempService;
	@Autowired()
	private AdjuntardocsService adjuntardocsService;
	@Autowired()
	private SoltramexpService soltramexpService;
	@Autowired
	private AdjunDatosAvisosEstablecDao adjunDatosAvisosEstablecDao;

	/**
	 * Guardar tramite notificacion.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @param esNotificacionTipoElectronica
	 *            the electronica no ordinaria
	 * @param idZipFile
	 *            the id zip file
	 * @param CensoMonitor
	 *            censoMonitor
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteNotificacion(TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, boolean esNotificacionTipoElectronica, String idZipFile,
			CensoMonitor censoMonitor) throws Exception {

		if (tramitar && Y41bConstantes.VALOR_SI.equals(tramiteNotificacion.getSede())) {
			this.validarSiExisteSede(tramiteNotificacion.getDestinatario());
		}

		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteNotificacion: 1/14");

		// 1. Se genera el tramite de Notificacion
		Arbtramexp arbtramexp = new Arbtramexp();
		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);
		arbtramexp.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			arbtramexp = this.arbtramexpDao.find(arbtramexp);
		}
		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteNotificacion: 2/14");

		// Remesas Ini
		arbtramexp.setTrenvrem(tramiteNotificacion.getEnvRemesaNotificacion());
		arbtramexp.setTrcodrem(tramiteNotificacion.getIdRemesaNotificacion());
		// Remesas Fin

		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setTrfecini(tramiteNotificacion.getFechaInicio());
		if (tramitar) {
			arbtramexp.setTrfecfin(tramiteNotificacion.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramiteNotificacion.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION);
		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setCensoMonitor(tramiteNotificacion.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramiteNotificacion.getComentario()));

		arbtramexp.setTrtiponot(tramiteNotificacion.getTipoNotificacion());

		arbtramexp.setTrtiponotplatea(tramiteNotificacion.getTipoNotificacionPlatea());

		arbtramexp.setTrfecnotif(tramiteNotificacion.getFechaComunicacion());
		arbtramexp.setTruaidinterv(new BigDecimal((tramiteNotificacion.getDestinatario())));
		arbtramexp.setTrsede(tramiteNotificacion.getSede());
		arbtramexp.setTrtiponot((tramiteNotificacion.getTipoNotificacion()));

		arbtramexp.setTridnotifplatea((tramiteNotificacion.getTipoNotificacionPlatea()));
		arbtramexp.setTrfecregs(tramiteNotificacion.getFechasalida());
		arbtramexp.setTrnumregs(tramiteNotificacion.getNumregistrosalida());
		arbtramexp.setTrtexto(Y41bUtils.stringToClob(tramiteNotificacion.getTextoComunicacion()));

		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteNotificacion: 3/14");

		if (tramitar) {
			if (esNotificacionTipoElectronica) {
				arbtramexp.setTrtiponot(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA);
			} else {
				arbtramexp.setTrtiponot(Y41bConstantes.TIPO_NOTIFICACION_ORDINARIA);
			}
		}

		// Se inserta el tramite
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteNotificacion: 5/14" + tramitar);

		if (tramitar) {
			// sustituimos la fecha de notificacion
			if (arbtramexp.getTrtiponot().equals(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA)) {
				arbtramexp.setTrfecnotif(Y41bUtils.obtenerFechaHoy());
			}
		}

		// Obtener registro salida si no viene de pantalla
		if (tramitar && !esNotificacionTipoElectronica) {
			if (arbtramexp.getTrenvrem() == null || Y41bConstantes.NO.equals(arbtramexp.getTrenvrem())) {
				if (arbtramexp.getTrnumregs() == null || arbtramexp.getTrnumregs().equals("")) {
					RegistroSalida registroSalida = this.getRegistroSalida(tramiteComun,
							tramiteNotificacion.getDestinatario(), true);
					arbtramexp.setTrnumregs(registroSalida.getRegistryNumber());
					arbtramexp.setTrfecregs(registroSalida.getRegistryDate());
				}
			}
		}

		this.arbtramexp2Service.setArbtramexp(arbtramexp);

		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteNotificacion: 6/14");

		// Recupero de la tabla temporal la lista de documentos del
		// expediente
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
		List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAllTipoDocArb(adjuntardocs, null);

		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramiteNotificacion.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);
		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteNotificacion: 7/14");

		if (tramitar) {
			// Debe haber al menos un documento
			tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(tramiteComun.getIdExpediente());
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				if (Y41bUtils.interactuarConDokusi()) {
					throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
				}
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				// Eliminar de la bandeja de firma
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteNotificacion: 8/14");

				// Incidencias 72966 y 74108. Envo ordinario no genera
				// comunicacion en PLATEA
				// Se incluye este if que si no es ordinaria hace lo que se
				// hacia antes y en caso contrario un codigo que comprueba que
				// se pueda generar el zip por estar todo localizado
				/***
				 * COMPROBAMOS SI TODOS LOS DOCUMENTOS TIENE LOCALIZADOR PARA LA
				 * ORDINARIA
				 */
				if (!esNotificacionTipoElectronica) {
					this.procesarComunicacionNotificacionOrdinaria(listadjuntardocs, listDocumentoHecho, arbtramexp,
							tramiteComun, idZipFile);
					// Se genera el tramite de acuse de recibo vinculado al
					// tramite de
					// notificacion
					Arbtramexp3ServiceImpl.logger.info("SantramexpServiceImpl - addTramiteNotificacion: 9AB14");

					String idEspera = null;
					this.generarTramiteAcuseReciboAutomatico(idEspera, arbtramexp, tramiteComun);
				} else {
					this.procesarNotificacionElectronica(listDocumentoHecho, tramiteNotificacion, arbtramexp,
							tramiteComun, censoMonitor);
				}

				Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteNotificacion: 9/14");
				/* actualizamos la bandeja */
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				/* actualizamos el ultimo tramite */
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteNotificacion: 10/14");
				/* actualizo los envios del expediente */
				this.insertEnvios(arbtramexp);
			}
		} else {
			if (isDocPendienteFirma) {
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				// Llamamos a un metodo que recorrera la lista de documentos
				// del
				// tramite y actualizara la bandeja de firma
				// En este caso, al ser un tramite generico le metemos la
				// fase
				// del
				// expediente
				Arbexp arbexp = new Arbexp();
				arbexp.setExcodigo(tramiteComun.getIdExpediente());
				arbexp = this.arbexpDao.find(arbexp);
				String faseExp = arbexp.getFase().getFcodigo();
				this.arbtramexp2Service.actualizarBandejaFirma(listDocumentoHecho, tramiteComun, faseExp,
						Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION);

			} else {
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
			}
			// Subimos los documentos a dokusi
			this.guardarDocumentosDokusiTramiteComunicacionNotificacion(listDocumentoHecho, tramiteComun);

		}

		String duenioExp = solarb.getArbexp().getExmocodigo();
		CensoMonitor censoMonitor2 = new CensoMonitor();
		censoMonitor2.setMocodigo(duenioExp);
		if (!Y41bUtils.esNullOCadenaVacia(duenioExp)) {
			censoMonitor2 = this.censoMonitorDao.find(censoMonitor2);
		} else {
			Arbtramexp3ServiceImpl.logger.info("ERROR. arbexp no tiene mocodigo");
		}

		/*
		 * AVISOS DE LA BANDEJA
		 */
		if (tramitar) {
			if (!"S".equals(tramiteNotificacion.getEnvRemesaNotificacion())) {
				/*
				 * aniadimos aviso para recoger acuse independientemente del
				 * tipo de notificacion
				 */
				this.crearAvisoNotifiComuniRegistroSalida(arbtramexp);
			}
		}

		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteNotificacion: FIN.");

		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);

		return arbtramexp;
	}

	/**
	 * 
	 * @param idInterviniente
	 *            String
	 */
	private void validarSiExisteSede(String idInterviniente) {
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUaidinterv(new BigDecimal(idInterviniente));

		arbinterv = this.arbintervdao.find(arbinterv);

		if (Y41bUtils.isFilled(arbinterv.getUanif())) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEsnif(arbinterv.getUanif());

			establecimiento = this.establecimientoService.obtenerEstablecimientoSede(establecimiento);

			if (establecimiento == null) {
				throw new Y41bUDAException("error.establecimiento.sinsedeException", true, new Exception());
			}
		} else {
			throw new Y41bUDAException("error.establecimiento.sinsedeException", true, new Exception());
		}
	}

	/**
	 * Finds registro entrada document.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idInterviniente
	 *            String
	 * @param esNotificacion
	 *            boolean
	 * @return RegistroSalida
	 * @throws Exception
	 *             Exception
	 */
	public RegistroSalida getRegistroSalida(TramiteComun tramiteComun, String idInterviniente, boolean esNotificacion)
			throws Exception {

		WSParamOutputRegisterEx datas = new WSParamOutputRegisterEx();

		Solarb solarbVO = new Solarb();
		solarbVO.setSacodigo(tramiteComun.getIdExpediente());

		solarbVO = this.solarbDao.find(solarbVO);

		String excoor = solarbVO.getSacoja();

		if (excoor.substring(0, 2).equals(Y41bConstantes.BIZKAIA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_BIZKAIA);
		} else if (excoor.substring(0, 2).equals(Y41bConstantes.ARABA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_ARABA);
		} else if (excoor.substring(0, 2).equals(Y41bConstantes.GIPUZKOA)) {
			datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
			datas.setSender(Y41bConstantes.UNIDAD_ORGANICA_GIPUZKOA);
		}

		ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

		Arbinterv arbinterv = new Arbinterv();
		if (Y41bUtils.esNullOCadenaVacia(idInterviniente)) {

			arbinterv.setSolarb(new Solarb(tramiteComun.getIdExpediente()));
			arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
			List<Arbinterv> listaArbinterv = this.arbintervdao.findAll(arbinterv, null);
			if (listaArbinterv != null) {
				if (listaArbinterv.size() == 1) {
					arbinterv = (Arbinterv) listaArbinterv.get(0);
				}
			}
		} else {
			arbinterv.setSolarb(solarbVO);
			arbinterv.setUaidinterv(new BigDecimal(idInterviniente));
			arbinterv = this.arbintervdao.find(arbinterv);
		}

		WSParamPerson wSParamPerson = new WSParamPerson();
		StringBuffer sbPerson = new StringBuffer();
		if (Y41bUtils.isFilled(arbinterv.getUanif())) {
			sbPerson.append(arbinterv.getUanif()).append(" - ");
		}
		if (Y41bUtils.isFilled(arbinterv.getUanoco())) {
			sbPerson.append(arbinterv.getUanoco()).append(" ");
		} else {
			if (Y41bUtils.isFilled(arbinterv.getUanombre())) {
				sbPerson.append(arbinterv.getUanombre()).append(" ");
			}
			if (Y41bUtils.isFilled(arbinterv.getUaapellido1())) {
				sbPerson.append(arbinterv.getUaapellido1()).append(" ");
			}
			if (Y41bUtils.isFilled(arbinterv.getUaapellido2())) {
				sbPerson.append(arbinterv.getUaapellido2()).append(" ");
			}
		}

		wSParamPerson.setPersonName(sbPerson.toString());

		persons.getWSParamPerson().add(wSParamPerson);

		datas.setPersons(persons);

		StringBuffer sbMatter = new StringBuffer();
		sbMatter.append(
				esNotificacion ? Y41bConstantes.LITERAL_NOTIFICACION_ES : Y41bConstantes.LITERAL_COMUNICACION_ES)
				.append(" - [").append(Y41bConstantes.TIPO_PROC_ARBITRAJE).append("-").append(solarbVO.getSacoja())
				.append("-").append(solarbVO.getSanror()).append("-").append(solarbVO.getSanran()).append("]");
		datas.setMatter(sbMatter.toString());

		N61ServiceImpl n61Service = new N61ServiceImpl();
		WSOutputRegister wSOutputRegister = n61Service.wsNewOutputRegister(datas);

		RegistroSalida registroSalida = new RegistroSalida();
		registroSalida.setRegistryNumber(wSOutputRegister.getNumber());
		registroSalida.setRegistryDate(new Date());

		return registroSalida;
	}

	/**
	 * Metodo que crea un zip con nombre zipName, y comprime los documentos del
	 * tramite del expediente
	 * 
	 * @param zipName
	 *            String
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param tramiteComun
	 *            TramiteComun
	 * @return boolean true si hay ficheros en el zip / false si no hay ficheros
	 *         en el zip
	 */
	private boolean crearZipDocumentosExpediente(String zipName, List<Adjuntardocs> listadjuntardocs,
			TramiteComun tramiteComun) {

		Arbtramexp3ServiceImpl.logger
				.info("ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Inicio.");
		Arbdoctemp documentoHechoDetalle = null;
		boolean zipConFicheros = true;
		boolean zipSinFicheros = false;
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// Ej. /datos/y41b/tmp/zip/
		// Ej. /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147
		// Ej. /datos/y41b/tmp/zip/1383555971012_199906071034ESP10147.zip
		String strTmpZipDirectory = prop.getProperty("RUTA_TMP_ZIP"), strZipDirectory = strTmpZipDirectory + zipName,
				strZipFile = strTmpZipDirectory + zipName + Y41bConstantes.EXTENSION_ZIP;

		try {
			Arbtramexp3ServiceImpl.logger.info(
					"ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 1.");
			// 1. Validamos que exista el directorio TMP para los ZIP. Si no
			// existe, lo creo
			Y41bFicheroUtils.crearDirectorio(strTmpZipDirectory);
			Arbtramexp3ServiceImpl.logger.info(
					"ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 2.");
			// 2. Validamos que exista el directorio TMP para el ZIP actual. Si
			// no existe, lo creo
			Y41bFicheroUtils.crearDirectorio(strZipDirectory);
			Arbtramexp3ServiceImpl.logger.info(
					"ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 3.");
			// 3. Creamos el ZIP
			Y41bFicheroUtils.crearFichero(new File(strZipFile));
			Arbtramexp3ServiceImpl.logger.info(
					"ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 4.");
			// ******* Borramos historico de ficheros con mas de 1 minuto
			// (60000ms) de
			// diferencia en la fecha de creacion
			Y41bFicheroUtils.deleteFilesFromDate(new File(strTmpZipDirectory), Y41bConstantes.NUM_60000);
			Arbtramexp3ServiceImpl.logger.info(
					"ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 5.");
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				Arbtramexp3ServiceImpl.logger
						.info("ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 6."
								+ listadjuntardocs.size() + ".");
				String nombreFichero = null;
				InputStream ficheroStream = null;
				File fileFichero = null;
				int numDoc = 1;
				// 4. Recorremos la lista de documentos a zipear y los dejamos
				// en el directorio TMP para el ZIP actual
				for (Adjuntardocs adjuntardocs : listadjuntardocs) {
					Arbtramexp3ServiceImpl.logger
							.info("ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 7.Bucle"
									+ numDoc + ".");

					documentoHechoDetalle = new Arbdoctemp();
					documentoHechoDetalle.setX5codocumento(adjuntardocs.getThcodocumento());
					documentoHechoDetalle = this.arbdoctempService.find(documentoHechoDetalle);

					nombreFichero = StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getX5nofile());
					ficheroStream = documentoHechoDetalle.getX5datafile().getBinaryStream();

					String local = (String) prop.getProperty("y41bVistaWar.entorno.local");

					if ("true".equals(local)) {
						fileFichero = new File(strZipDirectory + "\\" + numDoc + "." + nombreFichero);
					} else {
						fileFichero = new File(strZipDirectory + "/" + numDoc + "." + nombreFichero);
					}

					Arbtramexp3ServiceImpl.logger
							.info("ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 7.Bucle"
									+ numDoc + "." + strZipDirectory + "\\" + numDoc + "." + nombreFichero + ".");
					Y41bFicheroUtils.escribirFichero(ficheroStream, fileFichero);
					ficheroStream.close();
					numDoc++;
				}

				Arbtramexp3ServiceImpl.logger.info(
						"ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 8.");

				// 5. Comprimimos el directorio del zip en el fichero zip que
				// hemos creado
				Y41bFicheroUtils.comprimirFichero(new File(strZipDirectory), strZipFile);
				Arbtramexp3ServiceImpl.logger.info(
						"ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 9.");
				// 8.1. Hay ficheros en el zip
				return zipConFicheros;
			} else {
				Arbtramexp3ServiceImpl.logger.info(
						"ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 5.B.");
				// 8.2.1. Eliminamos el zip vacio (no sirve de nada)
				Y41bFicheroUtils.deleteFile(new File(strZipFile));
				// 8.2.2. No hay ficheros en el zip
				return zipSinFicheros;
			}
		} catch (Exception e) {
			// Eliminamos el zip vacio si existe
			Arbtramexp3ServiceImpl.logger
					.error("ArbtramexpServiceImpl. - crearZipDocumentosExpediente. ERROR. EXCEPTION" + e.getMessage());
			Arbtramexp3ServiceImpl.logger
					.info("ArbtramexpServiceImpl. - crearZipDocumentosExpediente. ERROR. EXCEPTION" + e.getMessage());

			Y41bFicheroUtils.deleteFile(new File(strZipFile));
			throw new Y41bUDAException("error.zip.crearZipDocumentosExpediente", true, new Exception());
		} finally {
			// 6. Eliminamos de la zona temporal de BDDD para los LOB
			Arbtramexp3ServiceImpl.logger.info(
					"ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 10.FINALLY.");
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				for (Adjuntardocs adjuntardocs : listadjuntardocs) {
					documentoHechoDetalle = new Arbdoctemp();
					documentoHechoDetalle.setX5codocumento(adjuntardocs.getThcodocumento());
					Arbtramexp3ServiceImpl.logger
							.info("ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 11. FINALLY. bucle."
									+ adjuntardocs.getThcodocumento() + ".");

				}
			}
			Arbtramexp3ServiceImpl.logger.info(
					"ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 12.FINALLY.");
			// 7. Borramos el directorio temporal del ZIP y su contenido
			File directoryToDelete = new File(strZipDirectory);
			if (directoryToDelete.exists()) {
				Y41bFicheroUtils.deleteDirectory(directoryToDelete);
			}
			Arbtramexp3ServiceImpl.logger.info(
					"ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 13.FINALLY.");

			if (directoryToDelete.exists()) {
				directoryToDelete.delete();
			}
			Arbtramexp3ServiceImpl.logger
					.info("ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Fin.");
		}
	}

	/**
	 * Metodo que comprueba que los documentos enviados a remesa no tienen
	 * problemas para ser remesados
	 * 
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @throws Exception
	 */
	private void controlDocumentosProtegidosRemesa(List<Adjuntardocs> listadjuntardocs) throws Exception {
		Locale locale = LocaleContextHolder.getLocale();
		Arbdoctemp documentoHechoDetalle = null;
		for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {
			documentoHechoDetalle = new Arbdoctemp();
			documentoHechoDetalle.setX5codocumento(adjuntardocsAux.getThcodocumento());
			documentoHechoDetalle = this.arbdoctempService.find(documentoHechoDetalle);

			Blob contenido = documentoHechoDetalle.getX5datafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());
			try {
				Document document = new Document();
				int totalPages = 0;
				PdfReader pdfReader = new PdfReader(bContenido);
				totalPages = pdfReader.getNumberOfPages();

				ByteArrayOutputStream bos = new ByteArrayOutputStream();

				ObjectOutputStream os = new ObjectOutputStream(bos);

				// Create a writer for the outputstream
				PdfWriter writer = PdfWriter.getInstance(document, os);

				document.open();
				BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA, BaseFont.CP1252, BaseFont.NOT_EMBEDDED);
				PdfContentByte cb = writer.getDirectContent(); // Holds
																// the
																// PDF
				// data

				boolean paginate = false;
				int pageOfCurrentReaderPDF = 0;
				int currentPageNumber = 0;
				PdfImportedPage page;
				// Create a new page in the target for each source page.
				while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
					Rectangle r = pdfReader.getPageSize(pdfReader.getPageN(pageOfCurrentReaderPDF + 1));
					// if (r.getWidth() == 792.0 && r.getHeight() ==
					// 612.0)
					if (r.getWidth() > r.getHeight()) {
						document.setPageSize(PageSize.A4.rotate());
					} else {
						document.setPageSize(PageSize.A4);
					}
					document.newPage();
					pageOfCurrentReaderPDF++;
					currentPageNumber++;
					page = writer.getImportedPage(pdfReader, pageOfCurrentReaderPDF);
					cb.addTemplate(page, 0, 0);

					// Code for pagination.
					if (paginate) {
						cb.beginText();
						cb.setFontAndSize(bf, Y41bConstantes.NUM_9);
						cb.showTextAligned(PdfContentByte.ALIGN_CENTER, "" + currentPageNumber + " of " + totalPages,
								Y41bConstantes.NUM_520, Y41bConstantes.NUM_5, 0);
						cb.endText();
					}
				}
				pageOfCurrentReaderPDF = 0;
				pdfReader.close();

				if (document.isOpen()) {
					document.close();
				}
				writer.close();
				os.writeObject(new Date());
				os.close();
			} catch (Exception e) {
				StringBuffer errorPassword = new StringBuffer();
				errorPassword
						.append(this.appMessageSource.getMessage("error.documentos.passwordremesapdf", null, locale))
						.append(documentoHechoDetalle.getX5nofile());
				throw new Y41bUDAException(errorPassword.toString(), true, new Exception());
			}
		}
	}

	/**
	 * Generar Tramite automatico de Acuse de Recibo
	 * 
	 * @param idEspera
	 *            String
	 * @param tramiteNotificacion
	 *            Arbtramexp
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	private Arbtramexp generarTramiteAcuseReciboAutomatico(String idEspera, Arbtramexp tramiteNotificacion,
			TramiteComun tramiteComun) throws Exception {
		try {
			// Generar el tramite de acuse de recibo vinculado al tramite de
			// notificacion
			// Creacion de tramite de registro de solicitud tramitado
			Arbtramexp arbtramexpAcuse = new Arbtramexp();

			arbtramexpAcuse.setTrid((arbtramexpDao.getNewPK().toString()));
			arbtramexpAcuse.setSolarb(new Solarb(tramiteComun.getIdExpediente()));
			arbtramexpAcuse.setTrcodigo((Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO));
			// La fase del acuse es la fase del tramite de notificacion que lo
			// genera
			Fase fase = ((Arbtramexp) this.arbtramexpDao.find(tramiteNotificacion)).getFase();
			arbtramexpAcuse.setFase(fase);

			// Incidencia 74956 - Ponemos en la fecha de inicio la fecha del dia
			// de hoy, que coincide con la fecha de fin de la notificacion
			arbtramexpAcuse.setTrfecini(Y41bUtils.obtenerFechaHoy());

			arbtramexpAcuse.setCensoMonitor((tramiteNotificacion.getCensoMonitor()));
			arbtramexpAcuse.setTrcodigorel(tramiteNotificacion.getTrcodigo());
			arbtramexpAcuse.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			arbtramexpAcuse.setTrcodigorel(Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION);
			arbtramexpAcuse.setTrtridrel(tramiteNotificacion.getTrid());
			arbtramexpAcuse.setTruaidinterv(tramiteNotificacion.getTruaidinterv());
			// tratamos el idEspera pasado por parametro
			if (Y41bUtils.isFilled(idEspera)) {
				arbtramexpAcuse.setTridesperaplatea(idEspera);
				arbtramexpAcuse.setTrmatarespera(Y41bConstantes.NO);
			}

			// Se inserta el tramite
			this.arbtramexpDao.add(arbtramexpAcuse);
			return arbtramexpAcuse;
		} catch (Exception e) {
			e.printStackTrace();
			Arbtramexp3ServiceImpl.logger
					.error("Error producido en generarTramiteAcuseReciboAutomatico: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Actualizar el expediente
	 * 
	 * @param arbtramexp
	 *            Arbtramexp2
	 * @throws Exception
	 *             Exception
	 */

	private void insertEnvios(Arbtramexp arbtramexp) throws Exception {
		try {
			/*
			 * recibo como parámetro el tramite de notificacion que acaba deadd
			 * completarse
			 */
			Arbenvio arbenvio = new Arbenvio();
			if (arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION)) {
				arbenvio.setEnestado(Y41bConstantes.ARB_ESTADO_ENVIO_RECOGIDO);
				arbenvio.setEnfecenvio(new Date());
				arbenvio.setEntipoenvio(arbtramexp.getTrtipocom());
			} else {
				arbenvio.setEnestado(Y41bConstantes.ARB_ESTADO_ENVIO_ENVIADO);
				arbenvio.setEnfecenvio(arbtramexp.getTrfecnotif());
				arbenvio.setEntipoenvio(arbtramexp.getTrtiponot());
			}
			arbenvio.setArbtramexpByEntrid(arbtramexp);
			arbenvio.setSolarb(arbtramexp.getSolarb());
			BigDecimal idInterv = arbtramexp.getTruaidinterv();
			arbenvio.setArbinterv(new Arbinterv(idInterv));

			arbenvio = this.arbenvioDao.add(arbenvio);

			// Consolidacin expediente: Actualizar fechas de envio
			this.arbtramexp4Service.actualizaExpedienteAlEnviarComNot(arbtramexp, arbenvio);
		} catch (Exception e) {
			Arbtramexp3ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los registra en
	 * DOKUSI
	 * 
	 * @param listDocumentosTramite
	 *            List<Arbdoctemp>
	 * @param tramiteComun
	 *            TramiteComun
	 * @return List<Documento>
	 * @throws Exception
	 */
	public List<Documento> registrarDocumentosDokusi(List<Arbdoctemp> listDocumentosTramite, TramiteComun tramiteComun)
			throws Exception {
		List<Documento> listDocumentos = new ArrayList<Documento>();
		Documento documento = null;

		if (listDocumentosTramite != null && listDocumentosTramite.size() > 0) {

			// Recorro los documentos del tramite buscando aquel documento que
			// este pendiente de firma
			Arbdoctemp arbdoctemp = null;
			String pcodigo = "";
			for (int i = 0; i < listDocumentosTramite.size(); i++) {
				arbdoctemp = listDocumentosTramite.get(i);
				pcodigo = arbdoctemp.getX5pcodigo();
				arbdoctemp = this.arbdoctempService.find(arbdoctemp);
				arbdoctemp.setX5pcodigo(pcodigo);
				// if (!Y41bUtils.isFilled(arbdoctemp.getX5iddocumentum())) {
				if (arbdoctemp != null && arbdoctemp.getX5pcodigo() != null
						&& arbdoctemp.getX5pcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5iddocumentum(arbdoctemp.getX5iddocumentum());
					documentoHecho.setQ5idTipodoc(arbdoctemp.getX5tipodocumento());
					documentoHecho.setQ5codocumento(arbdoctemp.getX5codocumento());
					documentoHecho.setQ5nofile(arbdoctemp.getX5nofile());
					documentoHecho.setQ5origen(arbdoctemp.getX5origen());
					documentoHecho.setQ5ptcodigo(arbdoctemp.getX5ptcodigo());
					documentoHecho.setQ5datafile(arbdoctemp.getX5datafile());
					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(arbdoctemp.getX5excodigo());
					tramiteComunAux.setIdTramite(arbdoctemp.getArbtramexp().getTrid());

					documento = this.soltramexpService.registrarDocumentosDokusiSol(documentoHecho, tramiteComunAux);
				} else if (arbdoctemp != null && arbdoctemp.getX5pcodigo() != null
						&& arbdoctemp.getX5pcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					// crear el objeto arbdoctemp
					Sandoctemp sandocTemp = new Sandoctemp();
					sandocTemp.setU5iddocumentum(arbdoctemp.getX5iddocumentum());
					sandocTemp.setU5tipodocumento(arbdoctemp.getX5tipodocumento());
					sandocTemp.setU5codocumento(arbdoctemp.getX5codocumento());
					sandocTemp.setU5nofile(arbdoctemp.getX5nofile());
					sandocTemp.setU5origen(arbdoctemp.getX5origen());
					sandocTemp.setU5ptcodigo(arbdoctemp.getX5ptcodigo());
					sandocTemp.setU5datafile(arbdoctemp.getX5datafile());

					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(arbdoctemp.getX5excodigo());
					tramiteComunAux.setIdTramite(arbdoctemp.getArbtramexp().getTrid());

					documento = this.soltramexpService.registrarDocumentosDokusiSan(sandocTemp, tramiteComunAux);
				} else if (arbdoctemp != null && arbdoctemp.getX5pcodigo() != null
						&& arbdoctemp.getX5pcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					// crear el objeto Sandoctemp
					Arbdoctemp arbdocTemp = new Arbdoctemp();
					arbdocTemp.setX5iddocumentum(arbdoctemp.getX5iddocumentum());
					Arbtipdoc arbtipdoc = new Arbtipdoc();
					arbtipdoc.setTdid(arbdoctemp.getX5tipodocumento());
					arbdocTemp.setArbtipdoc(arbtipdoc);
					arbdocTemp.setX5codocumento(arbdoctemp.getX5codocumento());
					arbdocTemp.setX5nofile(arbdoctemp.getX5nofile());
					arbdocTemp.setX5origen(arbdoctemp.getX5origen());
					arbdocTemp.setX5ptcodigo(arbdoctemp.getX5ptcodigo());
					arbdocTemp.setX5datafile(arbdoctemp.getX5datafile());

					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(arbdoctemp.getX5excodigo());
					tramiteComunAux.setIdTramite(arbdoctemp.getArbtramexp().getTrid());

					documento = this.soltramexpService.registrarDocumentosDokusiArb(arbdocTemp, tramiteComunAux);
				} else if (arbdoctemp != null && arbdoctemp.getX5pcodigo() != null
						&& (arbdoctemp.getX5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
								|| arbdoctemp.getX5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
								|| arbdoctemp.getX5pcodigo().equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

				} else if (arbdoctemp != null && arbdoctemp.getX5pcodigo() != null
						&& arbdoctemp.getX5pcodigo().equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					DocumentoHecho documentoHecho = new DocumentoHecho();
					documentoHecho.setQ5iddocumentum(arbdoctemp.getX5iddocumentum());
					documentoHecho.setQ5idTipodoc(arbdoctemp.getX5tipodocumento());
					documentoHecho.setQ5codocumento(arbdoctemp.getX5codocumento());
					documentoHecho.setQ5nofile(arbdoctemp.getX5nofile());
					documentoHecho.setQ5origen(arbdoctemp.getX5origen());
					documentoHecho.setQ5ptcodigo(arbdoctemp.getX5ptcodigo());
					documentoHecho.setQ5datafile(arbdoctemp.getX5datafile());
					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdExpediente(arbdoctemp.getX5excodigo());
					tramiteComunAux.setIdTramite(arbdoctemp.getArbtramexp().getTrid());

					documento = this.soltramexpService.registrarDocumentosDokusiIns(documentoHecho, tramiteComunAux);
				}

				listDocumentos.add(documento);
			}
		}
		return listDocumentos;
	}

	/**
	 * @param tramite
	 *            Arbtramexp
	 */
	public void crearAvisoNotifiComuniRegistroSalida(Arbtramexp tramite) {

		Arbtramexp arbtramexp = this.arbtramexpDao.find(tramite);
		if (arbtramexp != null) {
			Arbexp arbexp = new Arbexp();
			arbexp.setExcodigo(arbtramexp.getSolarb().getSacodigo());
			arbexp = this.arbexpDao.find(arbexp);
			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(arbexp.getExmocodigo());
			censoMonitor = this.censoMonitorDao.find(censoMonitor);
			// TODO:Avisos
		}
	}

	/**
	 * Finds a single row in the ArbTramExp table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param tipoProcedimiento
	 *            String
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentNotificacion(
			TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun, CensoMonitor censoMonitor,
			String tipoProcedimiento) throws Exception {
		RespuestaCrearEJGVDocumentNotificacion respuestaEjgv = null;
		List<Adjuntardocs> listadjuntardocs = null;
		try {

			Arbtramexp3ServiceImpl.logger.info("Arbtramexp2ServiceImpl - createEJGVDocumentNotificacion: 1/8");

			CrearNotifEJGV crearNotifEJGV = new CrearNotifEJGV();
			Procedure procedure = new Procedure();

			procedure.setIdProcedimiento(
					Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(tipoProcedimiento));
			crearNotifEJGV.setProcedure(procedure);

			crearNotifEJGV.setTextoNotificacion(tramiteNotificacion.getTextoComunicacion());

			crearNotifEJGV.setEjercicio(Y41bUtils.fncObtenerAnnoSistema());
			crearNotifEJGV.setIdiomaNotificacion(Y41bConstantes.CASTELLANO);

			Arbtramexp3ServiceImpl.logger.info("Arbtramexp2ServiceImpl - createEJGVDocumentNotificacion: 2/8");

			Arbinterv interviniente = new Arbinterv();
			interviniente.setUaidinterv(new BigDecimal(tramiteNotificacion.getDestinatario()));
			interviniente = this.arbintervdao.find(interviniente);

			DatosPersona datosPersonaSolicitante = new DatosPersona();
			datosPersonaSolicitante.setDni(interviniente.getUanif().trim().toUpperCase());
			datosPersonaSolicitante.setNombre(interviniente.getUanombre() == null ? ""
					: interviniente.getUanombre().concat(" ")
							.concat(interviniente.getUaapellido1() == null ? "" : interviniente.getUaapellido1())
							.concat(" ")
							.concat(interviniente.getUaapellido2() == null ? "" : interviniente.getUaapellido2()));
			datosPersonaSolicitante.setMail(interviniente.getUacoem());
			datosPersonaSolicitante.setTelefono(interviniente.getUanrtel());

			crearNotifEJGV.setSolicitante(datosPersonaSolicitante);

			DatosPersona datosPersonaSender = new DatosPersona();
			datosPersonaSender.setDni(censoMonitor.getOrganismo().getCodOrg());
			datosPersonaSender.setNombre(censoMonitor.getOrganismo().getNombreEs());

			crearNotifEJGV.setSender(datosPersonaSender);

			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());

			solarb = this.solarbDao.find(solarb);

			Arbtramexp3ServiceImpl.logger.info(
					"Arbtramexp2ServiceImpl - createEJGVDocumentNotificacion: 3/8:" + tramiteComun.getIdExpediente());

			// Obtener tramite
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramiteComun.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(solarb.damecodCompletoPlatea());

			crearNotifEJGV.setNumeroExpediente(numeroExpediente.toString());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
			// Indicar la serie documental que corresponde al expediente

			Arbtramexp3ServiceImpl.logger.info(
					"Arbtramexp2ServiceImpl - createEJGVDocumentNotificacion: 3/8:" + tramiteComun.getIdExpediente());

			String serieDocumental = prop.getProperty(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE + ".serie."
					+ Y41bDokusiHelper.getProvSerieFromNumExp(numeroExpediente.toString()));

			crearNotifEJGV.setSerieDocumental(serieDocumental);

			// El tipo de notificacion para PLATEA
			// En la JSP va "REQ_ACREDITA" para distinguirlo de otros
			// requerimientos
			// Antes de enviar a Platea tenemos que tratarlo
			if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_REQUERIMIENTO_ACREDITACION
					.equals(tramiteNotificacion.getTipoNotificacionPlatea())) {
				crearNotifEJGV.setIdTipoNotificacion(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_REQUERIMIENTO);
			} else {
				crearNotifEJGV.setIdTipoNotificacion(tramiteNotificacion.getTipoNotificacionPlatea());
			}

			// Recupero de la tabla temporal la lista de documentos del
			// expediente

			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			listadjuntardocs = this.adjuntardocsDao.findAllTipoDocArb(adjuntardocs, null);
			Arbtramexp3ServiceImpl.logger.info(
					"Arbtramexp2ServiceImpl - createEJGVDocumentNotificacion: 4/8" + tramiteComun.getIdTramite() + ".");
			List<Documento> listDocumentos = new ArrayList<Documento>();
			Documento documento = null;

			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {

				Arbtramexp3ServiceImpl.logger.info(
						"Arbtramexp2ServiceImpl - createEJGVDocumentNotificacion: 5/8" + listadjuntardocs.size() + ".");
				for (Adjuntardocs adjuntardocsAuxAntiguo : listadjuntardocs) {

					// obtener los datos del documento
					Adjuntardocs adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAuxAntiguo);
					if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
									.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
						// crear el objeto DocumentoHecho
						DocumentoHecho documentoHecho = new DocumentoHecho();
						documentoHecho.setQ5iddocumentum(adjuntardocsAux.getThiddocumentum());
						documentoHecho.setQ5idTipodoc(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						documentoHecho.setQ5codocumento(adjuntardocsAux.getThcodocumento());
						documentoHecho.setQ5nofile(adjuntardocsAux.getThnofile());
						documentoHecho.setQ5origen(adjuntardocsAux.getThorigen());
						documentoHecho.setQ5ptcodigo(adjuntardocsAux.getPtcodigo());
						documentoHecho.setQ5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiSol(documentoHecho,
								tramiteComunAux);
					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
									.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
						// crear el objeto Sandoctemp
						Sandoctemp sandocTemp = new Sandoctemp();
						sandocTemp.setU5iddocumentum(adjuntardocsAux.getThiddocumentum());
						sandocTemp.setU5tipodocumento(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						sandocTemp.setU5codocumento(adjuntardocsAux.getThcodocumento());
						sandocTemp.setU5nofile(adjuntardocsAux.getThnofile());
						sandocTemp.setU5origen(adjuntardocsAux.getThorigen());
						sandocTemp.setU5ptcodigo(adjuntardocsAux.getPtcodigo());
						sandocTemp.setU5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiSan(sandocTemp, tramiteComunAux);
					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
									.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
						// crear el objeto Sandoctemp
						Arbdoctemp arbdocTemp = new Arbdoctemp();
						arbdocTemp.setX5iddocumentum(adjuntardocsAux.getThiddocumentum());
						Arbtipdoc arbtipdoc = new Arbtipdoc();
						arbtipdoc.setTdid(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						arbdocTemp.setArbtipdoc(arbtipdoc);
						arbdocTemp.setX5codocumento(adjuntardocsAux.getThcodocumento());
						arbdocTemp.setX5nofile(adjuntardocsAux.getThnofile());
						arbdocTemp.setX5origen(adjuntardocsAux.getThorigen());
						arbdocTemp.setX5ptcodigo(adjuntardocsAux.getPtcodigo());
						arbdocTemp.setX5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiArb(arbdocTemp, tramiteComunAux);
					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null
							&& (adjuntardocsAux.getTipoProcedimiento().getPcodigo()
									.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
									|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
											.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
									|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
											.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo()
									.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
						// crear el objeto DocumentoHecho
						DocumentoHecho documentoHecho = new DocumentoHecho();
						documentoHecho.setQ5iddocumentum(adjuntardocsAux.getThiddocumentum());
						documentoHecho.setQ5idTipodoc(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						documentoHecho.setQ5codocumento(adjuntardocsAux.getThcodocumento());
						documentoHecho.setQ5nofile(adjuntardocsAux.getThnofile());
						documentoHecho.setQ5origen(adjuntardocsAux.getThorigen());
						documentoHecho.setQ5ptcodigo(adjuntardocsAux.getPtcodigo());
						documentoHecho.setQ5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiIns(documentoHecho,
								tramiteComunAux);
					}

					listDocumentos.add(documento);
				}
			}

			if (listDocumentos != null) {
				Arbtramexp3ServiceImpl.logger.info(
						"Arbtramexp2ServiceImpl - createEJGVDocumentNotificacion: 6/8" + listDocumentos.size() + ".");
			}

			crearNotifEJGV.setDocumentosAdjuntos(listDocumentos);

			if (Y41bUtils.interactuarConDokusi()) {
				Arbtramexp3ServiceImpl.logger
						.info("Arbtramexp2ServiceImpl. - crearEJGVDocumentNotificacion. Inicio Llamada a Platea");
				respuestaEjgv = this.y41bPlateaAdapterService.crearEJGVDocumentNotificacion(crearNotifEJGV);
				Arbtramexp3ServiceImpl.logger
						.info("Arbtramexp2ServiceImpl. - crearEJGVDocumentNotificacion. Fin Llamada a Platea");

				// actualizar los oid document en bbdd
				List<Documento> listDocumento = respuestaEjgv.getDocumentosAdjuntos();

				if (listDocumento != null && listDocumento.size() > 0) {

					Arbtramexp3ServiceImpl.logger.info("Arbtramexp2ServiceImpl - createEJGVDocumentNotificacion: 7/8"
							+ listDocumento.size() + ".");

					for (Documento documentoAux : listDocumento) {
						// obtener los datos del documento
						Arbdoctemp documentoHecho = new Arbdoctemp();

						documentoHecho.setX5codocumento(documentoAux.getIdDocumento());
						Arbtramexp3ServiceImpl.logger
								.info("Arbtramexp2ServiceImpl - createEJGVDocumentNotificacion:OID.DOKUSI "
										+ documentoAux.getOidDokusi() + ".");
						documentoHecho.setX5iddocumentum(documentoAux.getOidDokusi());

						// Update oid de documentum
						this.arbdoctempDao.updateOIDDokusi(documentoHecho);
						this.arbdoctempDao.removeBlobFromOIDDokusi(documentoHecho);

						// Actualizo OID Dokusi en tabla documentos
						// intermedia
						Adjuntardocs adjuntardocsAuxUpdateOID = new Adjuntardocs();

						adjuntardocsAuxUpdateOID.setThcodocumento(documentoAux.getIdDocumento());
						adjuntardocsAuxUpdateOID.setThiddocumentum(documentoAux.getOidDokusi());
						this.adjuntardocsDao.updateOIDDokusi(adjuntardocsAuxUpdateOID);
						this.adjuntardocsDao.removeBlobFromOIDDokusi(adjuntardocsAuxUpdateOID);
					}
				}

			} else {
				// en odei
				Arbtramexp3ServiceImpl.logger.info(
						"Arbtramexp2ServiceImpl - createEJGVDocumentNotificacion: 7b/8. en odei no mandamos a platea");
				respuestaEjgv = new RespuestaCrearEJGVDocumentNotificacion();
				respuestaEjgv.setTextoPlano("Notificacion en local");
				respuestaEjgv.setEjgvDocument("EGJV. Notificacion en local");
			}

			Arbtramexp3ServiceImpl.logger.info("Arbtramexp2ServiceImpl - createEJGVDocumentNotificacion: 8/8.");

		} catch (Y41bUDAException e) {
			e.printStackTrace();
			Arbtramexp3ServiceImpl.logger.info("Error producido en createEJGVDocumentNotificacion: " + e.getMessage(),
					e);
			Arbtramexp3ServiceImpl.logger.error("Error producido en createEJGVDocumentNotificacion: " + e.getMessage(),
					e);
			throw e;
		} catch (Exception e) {

			Arbtramexp3ServiceImpl.logger.info("Error producido en createEJGVDocumentNotificacion: " + e.getMessage(),
					e);
			Arbtramexp3ServiceImpl.logger.error("Error producido en createEJGVDocumentNotificacion: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}

		return respuestaEjgv;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteNotificacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public TramiteNotificacion findTramiteNotificacion(TramiteNotificacion tramiteNotificacion, CensoMonitor monitor)
			throws SQLException, IOException {

		CensoMonitor censoMonitor = new CensoMonitor();
		if (monitor != null && !Y41bUtils.esNullOCadenaVacia(monitor.getMocodigo())) {
			censoMonitor = this.censoMonitorDao.find(monitor);
		}

		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setTrid(tramiteNotificacion.getIdTramite());

		arbtramexp = this.arbtramexpDao.find(arbtramexp);

		TramiteNotificacion tramiteNotificacionAux = new TramiteNotificacion();
		tramiteNotificacionAux.setIdTramite(arbtramexp.getTrid().toString());

		tramiteNotificacionAux.setFechaInicio(arbtramexp.getTrfecini());
		tramiteNotificacionAux.setFechaFin(arbtramexp.getTrfecfin());

		if (arbtramexp.getCensoMonitor() != null) {
			tramiteNotificacionAux.setInstructorAsignado(arbtramexp.getCensoMonitor());
		} else {
			tramiteNotificacionAux.setInstructorAsignado(null);
		}

		if (arbtramexp.getCensoMonitorEj() != null) {
			tramiteNotificacionAux.setInstructorEjecucion(arbtramexp.getCensoMonitorEj());
		} else {
			tramiteNotificacionAux.setInstructorEjecucion(null);
		}

		tramiteNotificacionAux.setEstadoTramite(arbtramexp.getTrestado());

		tramiteNotificacionAux.setFechaComunicacion(arbtramexp.getTrfecnotif());

		tramiteNotificacionAux.setDestinatario(this.calcularDestinatarioComunicacionNotificacion(arbtramexp));

		tramiteNotificacionAux.setSede(arbtramexp.getTrsede());

		tramiteNotificacionAux.setTipoNotificacion(arbtramexp.getTrtiponot());

		tramiteNotificacionAux.setTipoNotificacionPlatea(arbtramexp.getTrtiponotplatea());

		tramiteNotificacionAux.setFechasalida(arbtramexp.getTrfecregs());

		tramiteNotificacionAux.setNumregistrosalida(arbtramexp.getTrnumregs());

		if ((arbtramexp != null && arbtramexp.getTrtridrel() != null)
				|| Y41bConstantes.VALOR_SI.equals(arbtramexp.getTrautomatico())) {
			tramiteNotificacionAux.setPermisoModificacionDestinatario(Y41bConstantes.NO);
		} else {
			tramiteNotificacionAux.setPermisoModificacionDestinatario(Y41bConstantes.SI);
		}

		tramiteNotificacionAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));
		tramiteNotificacionAux.setTextoComunicacion(Y41bUtils.clobToString(arbtramexp.getTrtexto()));

		if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
			tramiteNotificacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteNotificacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		tramiteNotificacionAux.setIdnotificacionplatea(arbtramexp.getTridnotifplatea());

		// Remesas Ini
		tramiteNotificacionAux.setEnvRemesaNotificacion(arbtramexp.getTrenvrem());
		if (arbtramexp.getTrcodrem() != null && !"".equals(arbtramexp.getTrcodrem())) {
			// Si tiene remesa asociada, recupero datos de la remesa
			Remesa remesa = new Remesa();
			remesa.setRmcodigo(arbtramexp.getTrcodrem());
			remesa = this.remesaDao.find(remesa);
			tramiteNotificacionAux.setIdRemesaNotificacion(remesa.getRmcodigo());
			tramiteNotificacionAux.setFechaRemesaNotificacion(remesa.getRmfechageneracion());
		}

		// Remesas Fin

		return tramiteNotificacionAux;
	}

	/**
	 * Guardar el tramite acuse de recibo
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param reintento
	 *            boolean
	 * @return TramiteAcuseRecibo
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAcuseRecibo addTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, TramiteComun tramiteComun,
			String idioma, boolean tramitar, boolean reintento, CensoMonitor censoMonitor) throws Exception {
		return addTramiteAcuseRecibo0(tramiteAcuseRecibo, tramiteComun, idioma, tramitar, null, false, reintento,
				censoMonitor);
	}

	private TramiteAcuseRecibo addTramiteAcuseReciboDesdeRemesa(TramiteAcuseRecibo tramiteAcuseRecibo,
			TramiteComun tramiteComun, String idioma, boolean tramitar, Arbdoctemp docHechoPEE,
			CensoMonitor censoMonitor) throws Exception {
		return addTramiteAcuseRecibo0(tramiteAcuseRecibo, tramiteComun, idioma, tramitar, docHechoPEE, true, false,
				censoMonitor);
	}

	/**
	 * Metodo comun para realizar Tramitar acuse de recibo
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param docHechoPEE
	 *            DocumentoHecho
	 * @param esRemesa
	 *            boolean
	 * @param reintento
	 *            boolean
	 * @return TramiteAcuseRecibo
	 * @throws Exception
	 *             Exception
	 */
	private TramiteAcuseRecibo addTramiteAcuseRecibo0(TramiteAcuseRecibo tramiteAcuseRecibo, TramiteComun tramiteComun,
			String idioma, boolean tramitar, Arbdoctemp docHechoPEE, boolean esRemesa, boolean reintento,
			CensoMonitor censoMonitor) throws Exception {
		try {

			Arbtramexp3ServiceImpl.logger.info("ArbbandejaDaoImpl - addTramiteAcuseRecibo - Inicio.");

			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramiteComun.getIdTramite());

			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			if (arbtramexp.getTrestado() != null
					&& !arbtramexp.getTrestado().equals(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
				Solarb solarb = new Solarb();
				solarb.setSacodigo(tramiteComun.getIdExpediente());
				solarb = this.solarbDao.find(solarb);

				arbtramexp.setFase(solarb.getArbexp().getFase());
				arbtramexp.setTrfecini(tramiteAcuseRecibo.getFechaInicio());
				if (tramitar) {
					arbtramexp.setTrfecfin(tramiteAcuseRecibo.getFechaFin());
					arbtramexp.setCensoMonitorEj(tramiteAcuseRecibo.getInstructorEjecucion());
					// llamnar a platea
					// cambiar fase
					arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

				} else {
					arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				}
				arbtramexp.setSolarb(solarb);
				arbtramexp.setFase(solarb.getArbexp().getFase());
				arbtramexp.setCensoMonitor(tramiteAcuseRecibo.getInstructorAsignado());
				arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramiteAcuseRecibo.getComentario()));

				// Info de Acuse recibo ini
				arbtramexp.setTrfecacuse(tramiteAcuseRecibo.getFechaacuse());
				arbtramexp.setTrestadoacuse(tramiteAcuseRecibo.getSituacionacuse());
				// Info de Acuse recibo fin

				// Se actualiza el tramite, nunca se inserta porque ya existe
				arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

				// buscar los documentos que no estan en la tabla de trabajo de
				// documentos y que pertenecen al Tramite
				List<Arbdoctemp> listArbdoctempEliminados = null;
				if (esRemesa) {
					if (docHechoPEE != null) {

						this.arbdoctempDao.add(docHechoPEE);
						this.arbdoctempDao.insertArbDocTramite(tramiteComun.getIdTramite(),
								docHechoPEE.getX5codocumento(), Y41bConstantes.TIPO_PROC_ARBITRAJE);

					}
				} else {
					listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
							tramiteAcuseRecibo.getAnyadirPlantilla());

				}

				// Se actualiza el origen de la lista de documentos del tramite
				// dependiendo del destinatario de la notificacion
				this.actualizarOrigenDocsTramiteAcuseRecibo(tramiteComun,
						tramiteAcuseRecibo.getTramiteNotificacion().getDestinatario());

				/* actualizamos el ultimo tramite */
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);

				/* actualizamos la bandeja */
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);

				if (tramitar) {
					if (!reintento) {
						if (!this.tratarTramitacionAcuse(arbtramexp, censoMonitor)) {
							tramiteAcuseRecibo.getTramiteNotificacion().setTramiteRelacionado(Y41bConstantes.VALOR_NO);
						}
					}
				}

				if (listArbdoctempEliminados != null) {
					this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
				}

				tramiteAcuseRecibo.setAcuseSinNotificacion(arbtramexp.getAcuseSinNotificacion());

				if (reintento) {
					// actualizar el campo del tramite de acuse a
					// TRACUSEREINTENTADO
					// a S
					arbtramexp.setTracusereintentado(Y41bConstantes.SI);
					this.arbtramexpDao.updateAcuseReintentado(arbtramexp);

					// generar la notificacin
					this.generarReintentoTramiteNotificacion(arbtramexp.getTrtridrel());
				}

				return tramiteAcuseRecibo;
			} else {

				if (reintento) {
					// actualizar el campo del tramite de acuse a
					// TRACUSEREINTENTADO
					// a S
					arbtramexp.setTracusereintentado(Y41bConstantes.SI);
					this.arbtramexpDao.updateAcuseReintentado(arbtramexp);

					// generar la notificacin
					this.generarReintentoTramiteNotificacion(arbtramexp.getTrtridrel());

					// Cuando se trata de un reintento se actualiza el
					// expediente con fecha de acuse nula
					String idTramitenotificacion = arbtramexp.getTrtridrel();
					Arbtramexp arbtramexpTramiteNotificacion = new Arbtramexp();
					arbtramexpTramiteNotificacion.setTrid(idTramitenotificacion);
					arbtramexpTramiteNotificacion = this.arbtramexpDao.find(arbtramexpTramiteNotificacion);
					this.actualizaExpedienteTrasAcusar(arbtramexp.getSolarb().getSacodigo(),
							arbtramexpTramiteNotificacion, null);
				}
				return tramiteAcuseRecibo;
			}

		} catch (Exception e) {
			Arbtramexp3ServiceImpl.logger
					.error("ArbbandejaDaoImpl - addTramiteAcuseRecibo - EXCEPTION. " + e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Generar Reintento Tramite de Notificacion
	 * 
	 * @param trtridrel
	 *            String
	 */
	@Transactional(rollbackFor = Throwable.class)
	private void generarReintentoTramiteNotificacion(String trtridrel) throws Exception {

		// Coger la notificacin relacionada con el arbitraje
		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setTrid(trtridrel);
		arbtramexp = this.arbtramexpDao.find(arbtramexp);

		// Crear la nueva notificacin en base a los campos de la ltima
		Arbtramexp arbtramexpNuevo = new Arbtramexp();
		arbtramexpNuevo.setSolarb(arbtramexp.getSolarb());
		arbtramexpNuevo.setTrcodigo(arbtramexp.getTrcodigo());
		arbtramexpNuevo.setTrfecini(Y41bUtils.obtenerFechaHoy());
		arbtramexpNuevo.setCensoMonitor(arbtramexp.getCensoMonitor());
		arbtramexpNuevo.setTrcodigorel(arbtramexp.getTrcodigorel());
		arbtramexpNuevo.setTrtridrel(arbtramexp.getTrtridrel());
		arbtramexpNuevo.setFase(arbtramexp.getFase());
		arbtramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		arbtramexpNuevo.setTrasuntocomunicacion(arbtramexp.getTrasuntocomunicacion());
		arbtramexpNuevo.setTruaidinterv(arbtramexp.getTruaidinterv());
		arbtramexpNuevo.setTrfecnotif(Y41bUtils.obtenerFechaHoy());
		arbtramexpNuevo.setTrenvrem(arbtramexp.getTrenvrem());
		arbtramexpNuevo.setTrtiponotplatea(arbtramexp.getTrtiponotplatea());
		arbtramexpNuevo.setTridnotifplatea(arbtramexp.getTridnotifplatea());
		arbtramexpNuevo.setTrtexto(arbtramexp.getTrtexto());
		arbtramexpNuevo.setTrautomatico(Y41bConstantes.VALOR_SI);

		arbtramexpNuevo = this.arbtramexp2Service.add(arbtramexpNuevo);

		// Asignar los documentos a la nueva notificacin
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(arbtramexp.getTrid().toString());
		List<Arbdoctemp> documentos = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux, null);

		// Relaciono tramite - documento - destino
		if (documentos != null && documentos.size() > 0) {
			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setUaidinterv(arbtramexp.getTruaidinterv());
			arbinterv = this.arbintervdao.find(arbinterv);
			for (Arbdoctemp documento : documentos) {
				if (Y41bUtils.esNullOCadenaVacia(documento.getX5destino())
						|| documento.getX5destino().equals(arbinterv.getUatipointerv())) {
					this.arbdoctempDao.insertArbDocTramite(arbtramexpNuevo.getTrid(), documento.getX5codocumento(),
							documento.getX5pcodigo());
				}
			}
		}

		// Calcular el estado del trmite generado
		this.arbtramexp2Service.calcularEstadoTramiteGenerado(arbtramexpNuevo);

		// Actualizar la bandeja de arbitraje
		this.arbtramexp2Service.actualizaBandeja(arbtramexpNuevo);

	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteAcuseRecibo
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteAcuseRecibo findTramiteAcuseRecibo(TramiteAcuseRecibo tramiteAcuseRecibo, CensoMonitor monitor)
			throws SQLException, IOException {
		CensoMonitor censoMonitor = new CensoMonitor();
		if (monitor != null && !Y41bUtils.esNullOCadenaVacia(monitor.getMocodigo())) {
			censoMonitor = this.censoMonitorDao.find(monitor);
		}
		Arbtramexp arbtramexp = new Arbtramexp();
		Arbtramexp3ServiceImpl.logger.info("Id del tramite:" + tramiteAcuseRecibo.getIdTramite() + "-");
		arbtramexp.setTrid(tramiteAcuseRecibo.getIdTramite());

		arbtramexp = this.arbtramexpDao.find(arbtramexp);

		TramiteAcuseRecibo tramiteAcuserRecibo = new TramiteAcuseRecibo();
		tramiteAcuserRecibo.setIdTramite(arbtramexp.getTrid().toString());

		tramiteAcuserRecibo.setFechaInicio(arbtramexp.getTrfecini());
		tramiteAcuserRecibo.setFechaFin(arbtramexp.getTrfecfin());

		if (arbtramexp.getCensoMonitor() != null) {
			tramiteAcuserRecibo.setInstructorAsignado(arbtramexp.getCensoMonitor());
		} else {
			tramiteAcuserRecibo.setInstructorAsignado(null);
		}

		if (arbtramexp.getCensoMonitorEj() != null) {
			tramiteAcuserRecibo.setInstructorEjecucion(arbtramexp.getCensoMonitorEj());
		} else {
			tramiteAcuserRecibo.setInstructorEjecucion(null);
		}

		tramiteAcuserRecibo.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

		tramiteAcuserRecibo.setEstadoTramite(arbtramexp.getTrestado());

		tramiteAcuserRecibo.setAcusereintentado(arbtramexp.getTracusereintentado());

		// Info de Acuse recibo ini
		tramiteAcuserRecibo.setFechaacuse(arbtramexp.getTrfecacuse());
		tramiteAcuserRecibo.setSituacionacuse(arbtramexp.getTrestadoacuse());

		// Info de Acuse recibo fin

		TramiteNotificacion tramiteNotificacionWhere = new TramiteNotificacion();
		tramiteNotificacionWhere.setIdTramite(arbtramexp.getTrtridrel().toString());
		TramiteNotificacion tramiteNotificacionRelacionado = this.findTramiteNotificacion(tramiteNotificacionWhere,
				censoMonitor);

		// Recupero el tramite de notificacion relacionado ini
		tramiteAcuserRecibo.setTramiteNotificacion(tramiteNotificacionRelacionado);
		// Recupero el tramite de notificacion relacionado fin

		if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
			tramiteAcuserRecibo.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAcuserRecibo.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAcuserRecibo;
	}

	/**
	 * Metodo que actualiza el origen de todos los documentos de un tramite
	 * acuse de recibo con el parametro recibido
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param destinatario
	 *            String
	 */
	private void actualizarOrigenDocsTramiteAcuseRecibo(TramiteComun tramiteComun, String destinatario) {
		String origen_doc = "";
		// Calculamos el origen del documento adjunto en el acuse a
		// partir del destinatario del tramite de notificacion
		Arbinterv intervinientes = new Arbinterv();
		intervinientes.setUaidinterv(new BigDecimal(destinatario));
		intervinientes = this.arbintervdao.find(intervinientes);
		String tipo_interviniente = intervinientes.getUatipointerv();
		if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(tipo_interviniente)
				|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO.equals(tipo_interviniente)) {
			origen_doc = Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO;
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(tipo_interviniente)
				|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE.equals(tipo_interviniente)) {

			origen_doc = Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE;
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_CONSUMIDOR.equals(tipo_interviniente)) {

			origen_doc = Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE2;
		} else {
			origen_doc = Y41bConstantes.ORIGEN_ARB_APORTADO_OTROS;
		}

		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux, null);

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			Arbdoctemp documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				documentoHecho.setX5origen(origen_doc);
				this.arbdoctempDao.updateOrigen(documentoHecho);
			}
		}
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return boolean
	 * @throws Exception
	 *             Exception
	 */
	public boolean tratarTramitacionAcuse(Arbtramexp arbtramexp, CensoMonitor censoMonitor) throws Exception {
		try {

			if (arbtramexp.getTrestadoacuse().equals(Y41bConstantes.SITUACION_ACUSERECIBO_NOENTREGADO)) {
				// 20180417 - Kontsumobide no quiere que en ningun caso se
				// genere el tramite de publicacion en BOPV si una notificacion
				// es "No entregada" en la tramitacion de Arbitraje.
				return false;
				// if (arbtramexp.getTrtridrel() != null) {
				// // tiene tramite relacionado
				// String tridrel = arbtramexp.getTrtridrel();
				//
				// Arbtramexp tramiteRelacionado = this.arbtramexpDao
				// .find(new Arbtramexp(tridrel));
				//
				// if (tramiteRelacionado != null
				// && tramiteRelacionado.getTrcodigo() != null) {
				// if (tramiteRelacionado.getTrcodigo().equals(
				// Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION)) {
				//
				// /*
				// * this.arbtramexp2Service
				// * .sugiereTramiteAutomaticamente(
				// * tramiteRelacionado,
				// * Y41bConstantes.TRAMITE_ARBITRAJE_ELABORACION_BOPVBOE
				// * , Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE);
				// */
				// this.arbtramexp2Service
				// .sugiereTramiteAutomaticamente(
				// tramiteRelacionado,
				// Y41bConstantes.TRAMITE_ARBITRAJE_ELABORACION_BOPVBOE,
				// arbtramexp.getFase().getFcodigo(),
				// false);
				// } else {
				// // Si el tramite relacionado no es una notificacion,
				// // no podemos hacer nada. No debiera darse el caso
				// return false;
				// }
				// } else {
				// // Si no tenemos el codigo del tramite relacionado, no
				// // podemos hacer nada. No debiera darse el caso
				// return false;
				// }
				// } else {
				// // Si no tenemos tramite relacionado, no podemos hacer nada.
				// // No debiera darse el caso
				// return false;
				// }

			} else {
				String idTramitenotificacion = arbtramexp.getTrtridrel();
				Arbtramexp arbtramexpTramiteNotificacion = new Arbtramexp();
				arbtramexpTramiteNotificacion.setTrid(idTramitenotificacion);
				arbtramexpTramiteNotificacion = this.arbtramexpDao.find(arbtramexpTramiteNotificacion);

				Date fechaAcuse = arbtramexp.getTrfecacuse();
				this.tratarAcuseRecogido(arbtramexpTramiteNotificacion, fechaAcuse);
				Arbinterv arbinterv = new Arbinterv();
				arbinterv.setUaidinterv(arbtramexp.getTruaidinterv());
				arbinterv = this.arbintervdao.find(arbinterv);

				if (arbinterv != null && arbinterv.getUatipointerv() != null
						&& (arbinterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE)
								|| arbinterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO)
								|| arbinterv.getUatipointerv()
										.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO)
								|| arbinterv.getUatipointerv()
										.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO)
								|| arbinterv.getUatipointerv()
										.equals(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE)
								|| arbinterv.getUatipointerv().equals(
										Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO))) {
					TramiteComun tramiteComunAux = new TramiteComun();
					tramiteComunAux.setIdTramite(arbtramexpTramiteNotificacion.getTrid().toString());
					List<Arbdoctemp> listDocumentos = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux,
							null);
					this.arbtramexp4Service.actualizarMisGestionesNotificacion(arbtramexp, listDocumentos,
							censoMonitor);
				}

			}
			return true;
		} catch (Exception e) {
			Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - tratarTramitacionAcuse - ExceptionException .");
			Arbtramexp3ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * 
	 * @param arbtramexpNotificacion
	 *            Arbtramexp
	 * @param fechaAcuse
	 *            Date
	 * @throws Exception
	 *             Exception
	 */
	public void tratarAcuseRecogido(Arbtramexp arbtramexpNotificacion, Date fechaAcuse) throws Exception {

		this.actualizaExpedienteTrasAcusar(arbtramexpNotificacion.getSolarb().getSacodigo(), arbtramexpNotificacion,
				fechaAcuse);

		Solarb solarb = arbtramexpNotificacion.getSolarb();
		solarb = this.solarbDao.find(solarb);

		/* AVISOS DE LA BANDEJA SOBRE PLAZO DE ALEGACIONES */
		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - tratarTramitacionAcuse - Busco el tramite origen.");

		Arbtramexp3ServiceImpl.logger
				.info("ArbtramexpServiceImpl - tratarTramitacionAcuse - Busco el tramite origen. ENCONTRADO "
						+ arbtramexpNotificacion.getTrtridrel());

		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - tratarTramitacionAcuse - Actualizo envios. "
				+ arbtramexpNotificacion.getTrtridrel());
		this.actualizaEnvios(arbtramexpNotificacion, fechaAcuse);

		Arbtramexp3ServiceImpl.logger.info(
				"ArbtramexpServiceImpl - tratarTramitacionAcuse - Elimino espera del acuse en bandeja de avisos. Si existe.. ");

		// this.borrarAvisoEsperaAcuse(expedien, arbtramexpNotificacion);

		// tratamos las fechas del acuse respecto al tramite de
		// notificacion asociado
		if (arbtramexpNotificacion.getTrtridrel() != null) {
			this.crearAviso(arbtramexpNotificacion, solarb, fechaAcuse);
		}

	}

	/**
	 * @param arbtramexpNotificacion
	 * @param fechaAcuse
	 */
	private void actualizaEnvios(Arbtramexp arbtramexpTramiteNotificacion, Date fechaAcuse) {
		try {
			// Siempre que hay un acuse se debe actualizar el envio
			// if (arbtramexpTramiteNotificacion.getTrtridrel() != null) {
			Arbtramexp tramiteOriginal = new Arbtramexp();
			tramiteOriginal.setTrid(arbtramexpTramiteNotificacion.getTrtridrel());
			tramiteOriginal = this.arbtramexpDao.find(tramiteOriginal);

			Arbenvio arbenvio = new Arbenvio();
			arbenvio.setArbtramexpByEntrid(new Arbtramexp(arbtramexpTramiteNotificacion.getTrid()));
			Long numeroEnvios = this.arbenvioDao.findAllCount(arbenvio);
			List<Arbenvio> enviosNotificacion = this.arbenvioDao.findAll(arbenvio, null);
			if (enviosNotificacion != null) {
				if (numeroEnvios.intValue() > 1) {
					// Borramos todos menos 1
					for (int i = 1; i < enviosNotificacion.size(); i++) {
						arbenvio = enviosNotificacion.get(i);
						this.arbenvioDao.remove(arbenvio);
					}
				}
				if (enviosNotificacion.size() > 0) {
					// Actualizamos el primero de la lista
					arbenvio = enviosNotificacion.get(0);
					arbenvio = this.arbenvioDao.find(arbenvio);
					if (tramiteOriginal != null) {
						arbenvio.setArbtramexpByEntridacuse(new Arbtramexp(tramiteOriginal.getTrid()));
					}
					arbenvio.setEnfecacuse(fechaAcuse);
					arbenvio.setEnestado(Y41bConstantes.ARB_ESTADO_ENVIO_RECOGIDO);
					arbenvio = this.arbenvioDao.update(arbenvio);
				}
			}
			// }
		} catch (Exception e) {
			Arbtramexp3ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param sacodigo
	 * @param arbtramexpNotificacion
	 * @param fechaAcuse
	 */
	private void actualizaExpedienteTrasAcusar(String sacodigo, Arbtramexp arbtramexpNotificacion, Date fechaAcuse) {

		Solarb solarb = new Solarb();
		solarb.setSacodigo(arbtramexpNotificacion.getSolarb().getSacodigo());
		solarb = this.solarbDao.find(solarb);

		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(arbtramexpNotificacion.getSolarb().getSacodigo());
		arbexp = this.arbexpDao.find(arbexp);

		if (arbtramexpNotificacion.getTrtridrel() != null) {
			Arbtramexp tramiteOriginal = new Arbtramexp();
			tramiteOriginal.setTrid(arbtramexpNotificacion.getTrtridrel());
			tramiteOriginal = this.arbtramexpDao.find(tramiteOriginal);

			String codigoTipoTramite = tramiteOriginal.getTrcodigo();

			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setUaidinterv(arbtramexpNotificacion.getTruaidinterv());
			arbinterv = this.arbintervdao.find(arbinterv);
			if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					solarb.setSaferelt(fechaAcuse);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotlaud(fechaAcuse);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					solarb.setSafenoac(fechaAcuse);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotacla(fechaAcuse);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					solarb.setSafereco(fechaAcuse);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotconv(fechaAcuse);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(codigoTipoTramite)) {
				if (Y41bConstantes.DECISION_ARBITRAJE_DESISTIMIENTO.equals(tramiteOriginal.getTrresotipo())) {
					if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
							|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
									.equals(arbinterv.getUatipointerv())) {
						solarb.setSaferedt(fechaAcuse);
					}
				} else if (Y41bConstantes.DECISION_ARBITRAJE_INADMISION.equals(tramiteOriginal.getTrresotipo())) {
					if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
							|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
									.equals(arbinterv.getUatipointerv())) {
						solarb.setSafereit(fechaAcuse);
					}
				} else if (Y41bConstantes.DECISION_ARBITRAJE_TRASLADO.equals(tramiteOriginal.getTrresotipo())) {
					if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
							|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
									.equals(arbinterv.getUatipointerv())) {
						solarb.setSaferett(fechaAcuse);
					} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS.equals(arbinterv.getUatipointerv())) {
						solarb.setSaferets(fechaAcuse);
					}
				}
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotresoc(fechaAcuse);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotresoe(fechaAcuse);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_MEDIACION.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					solarb.setSaferemt(fechaAcuse);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					solarb.setSaferear(fechaAcuse);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_SUBSANACION.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotsubs(fechaAcuse);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotcitac(fechaAcuse);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotcitae(fechaAcuse);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotcitpc(fechaAcuse);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotcitpe(fechaAcuse);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotcit2c(fechaAcuse);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotcit2e(fechaAcuse);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_SUSPENSION_AUDIENCIA.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotsuspc(fechaAcuse);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotsuspe(fechaAcuse);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotinfpc(fechaAcuse);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotinfpe(fechaAcuse);
				}
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL.equals(codigoTipoTramite)) {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotpagpc(fechaAcuse);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					arbexp.setExfecnotpagpe(fechaAcuse);
				}
			}

			this.solarbDao.update(solarb);
			this.arbexpDao.update(arbexp);
		}

	}

	/**
	 * 
	 * @param arbtramexpTramite
	 *            Arbtramexp
	 * @param solarb
	 *            Solarb
	 * @param fechaAcuse
	 *            Date
	 */
	public void crearAviso(Arbtramexp arbtramexpTramite, Solarb solarb, Date fechaAcuse) {

		String idTramiteOriginal = arbtramexpTramite.getTrtridrel();

		Arbtramexp arbtramexpOriginal = new Arbtramexp();
		arbtramexpOriginal.setTrid(idTramiteOriginal);
		arbtramexpOriginal = this.arbtramexpDao.find(arbtramexpOriginal);

		String duenioExp = solarb.getArbexp().getExmocodigo();
		CensoMonitor censoMonitor = new CensoMonitor();
		censoMonitor.setMocodigo(duenioExp);
		censoMonitor = this.censoMonitorDao.find(censoMonitor);

		String parametroABuscar = null;
		String parametroABuscar2 = null;
		String parametroABuscar3 = null;
		if (arbtramexpTramite.getTrtridrel() != null) {
			Arbtramexp tramiteOriginal = new Arbtramexp();
			tramiteOriginal.setTrid(arbtramexpTramite.getTrtridrel());
			tramiteOriginal = this.arbtramexpDao.find(tramiteOriginal);

			Arbtramexp3ServiceImpl.logger
					.info("ArbtramexpServiceImpl - tratarTramitacionAcuse - Genero aviso sobre el tipo de notificacion especifica, si procede. "
							+ tramiteOriginal.getTrtiponot());

			String tipoTramite = tramiteOriginal.getTrcodigo();

			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setUaidinterv(arbtramexpTramite.getTruaidinterv());
			arbinterv = this.arbintervdao.find(arbinterv);

			if (Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL.equals(tipoTramite)) {
				parametroABuscar = Y41bConstantes.TIPO_AVISO_ARBITRAJE_CONVENIO;
				parametroABuscar2 = Y41bConstantes.TIPO_AVISO_ARBITRAJE_ALEGACIONES;
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_SUBSANACION.equals(tipoTramite)) {
				parametroABuscar = Y41bConstantes.TIPO_AVISO_ARBITRAJE_REQ_SUBSANACION;
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(tipoTramite)) {
				parametroABuscar = Y41bConstantes.TIPO_AVISO_ARBITRAJE_LAUDO_RESO;
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(tipoTramite)) {
				parametroABuscar = Y41bConstantes.TIPO_AVISO_ARBITRAJE_LAUDO_RESO;
				parametroABuscar2 = Y41bConstantes.TIPO_AVISO_ARBITRAJE_ACLARACION;
				parametroABuscar3 = Y41bConstantes.TIPO_AVISO_ARBITRAJE_NULIDAD;
			} else if (arbinterv != null && arbinterv.getUatipointerv() != null
					&& arbinterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO)
					&& (Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_NO_ADHERIDA.equals(tipoTramite)
							|| Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_ADHERIDA_LIM.equals(tipoTramite))) {
				parametroABuscar = Y41bConstantes.TIPO_AVISO_ARBITRAJE_ACEPTACION_ARBITRAJE;
			}

			if (parametroABuscar != null) {
				Parametros parametros = new Parametros();
				parametros.setParametro(parametroABuscar);
				parametros = this.parametrosDao.find(parametros);
				if (parametros != null) {
					Long numero = new Long(parametros.getValor());
					Arbtramexp3ServiceImpl.logger
							.info("ArbtramexpServiceImpl - tratarTramitacionAcuse - Generado para:  "
									+ arbtramexpTramite.getTrtiponot());
					this.arbbandejaDao.aniadeAvisoBandejaDias(solarb, censoMonitor, numero, "", "",
							arbtramexpOriginal.getTrid(), fechaAcuse, parametroABuscar);
				}
			}
			if (parametroABuscar2 != null) {
				Parametros parametros = new Parametros();
				parametros.setParametro(parametroABuscar2);
				parametros = this.parametrosDao.find(parametros);
				if (parametros != null) {
					Long numero = new Long(parametros.getValor());
					Arbtramexp3ServiceImpl.logger
							.info("ArbtramexpServiceImpl - tratarTramitacionAcuse - Generado para:  "
									+ arbtramexpTramite.getTrtiponot());
					this.arbbandejaDao.aniadeAvisoBandejaDias(solarb, censoMonitor, numero, "", "",
							arbtramexpOriginal.getTrid(), fechaAcuse, parametroABuscar2);
				}
			}

			if (parametroABuscar3 != null) {
				Arbbandeja aviso = new Arbbandeja();
				aviso.setSolarb(solarb);
				aviso.setAbtipo(parametroABuscar3);
				List<Arbbandeja> lavisos = arbbandejaDao.findAll(aviso, null);
				if (lavisos != null) {
					for (int i = 0; i < lavisos.size(); i++) {
						this.arbbandejaDao.remove(lavisos.get(i));
					}
				}
				Parametros parametros = new Parametros();
				parametros.setParametro(parametroABuscar3);
				parametros = this.parametrosDao.find(parametros);
				if (parametros != null) {
					Long numero = new Long(parametros.getValor());
					Arbtramexp3ServiceImpl.logger
							.info("ArbtramexpServiceImpl - tratarTramitacionAcuse - Generado para:  "
									+ arbtramexpTramite.getTrtiponot());
					this.arbbandejaDao.aniadeAvisoBandejaDias(solarb, censoMonitor, numero, "", "",
							arbtramexpOriginal.getTrid(), fechaAcuse, parametroABuscar3);
				}
			}
		}
	}

	/**
	 * Para actualizar el tramite de acuse de recibo correspondiente al envio de
	 * una remesa.
	 * 
	 * @param censoMonitor
	 * @param remesaEmitida
	 * @param envio
	 * @param fechaSituacion
	 * @param situacionCorreos
	 * @param envcestado
	 * @param documentoZipByte
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public void actualizarTramiteDeAcuseReciboDesdeRemesa(CensoMonitor censoMonitor, Remesa remesaEmitida,
			NotificacionesComunicacionesBusqueda envio, String fechaSituacion, String situacionCorreos,
			String estadoDelEnvio, byte[] documentoZipByte, String filename) {

		// "Salir si no est respondido por Correos"
		if (!Y41bConstantes.AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS.equals(estadoDelEnvio)
				&& !Y41bConstantes.AA66_ENVIO_SITUACION_ERROR.equals(estadoDelEnvio)) {
			return;
		}

		TramiteComun tramiteComun = null;
		TramiteAcuseRecibo tramiteAcuseRecibo = null;

		if (envio.getIdTramiteAcuseRelacionado() != null) {
			try {
				// Buscar el trmite de Acuse relacionado con el envio
				tramiteAcuseRecibo = new TramiteAcuseRecibo();
				tramiteAcuseRecibo.setIdTramite(envio.getIdTramiteAcuseRelacionado());
				tramiteAcuseRecibo = this.findTramiteAcuseRecibo(tramiteAcuseRecibo, censoMonitor);

				tramiteComun = new TramiteComun();
				tramiteComun.setIdExpediente(envio.getHdcodigo());
				tramiteComun.setIdTramite(envio.getIdTramiteAcuseRelacionado());
				TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
				tipoProcedimiento.setPcodigo(remesaEmitida.getRmtipoproc());
				tramiteComun.setTipoProcedimiento(tipoProcedimiento);

				// "Crear el documento hecho del PEE para asociar al tramite"
				Arbdoctemp docHechoPEE_Aux = new Arbdoctemp();
				docHechoPEE_Aux.setX5codocumento(this.arbdoctempDao.getNewPK().toString());

				docHechoPEE_Aux.setX5origen(Y41bConstantes.ORIGEN_ARB_APORTADO_OTROS);
				docHechoPEE_Aux.setArbtipdoc(new Arbtipdoc(Y41bConstantes.TIPO_DOC_ARB_ACUSE));

				Blob blob = new SerialBlob(documentoZipByte);
				docHechoPEE_Aux.setX5datafile(blob);
				docHechoPEE_Aux.setX5conttype(Y41bConstantes.CONTENT_TYPE_PDF);
				docHechoPEE_Aux.setX5nofile(filename);
				docHechoPEE_Aux.setX5tedesfile(Y41bConstantes.PRUEBA_ENTREGA_ENVIO);
				docHechoPEE_Aux.setX5sizefile((int) documentoZipByte.length);

				Solarb expAux = new Solarb();
				expAux.setSacodigo(tramiteComun.getIdExpediente());
				docHechoPEE_Aux.setX5excodigo(tramiteComun.getIdExpediente());

				Arbtramexp tramiteAux = new Arbtramexp();
				tramiteAux.setTrid(tramiteComun.getIdTramite());
				docHechoPEE_Aux.setArbtramexp(tramiteAux);

				docHechoPEE_Aux.setX5fecha(new Date());

				// "Actualizar tramite de acuse de recibo asociado al envio"
				Date fecha;
				fecha = Y41bUtils.convertFromSQLDateToJAVADate(
						Y41bUtils.formatearStringToDateFormato(fechaSituacion, Y41bConstantes.FORMATO_FECHA_ES));
				tramiteAcuseRecibo.setFechaacuse(fecha);

				if (situacionCorreos != null) {
					tramiteAcuseRecibo.setSituacionacuse(situacionCorreos);
				}

				// "Si el trmite ya estaba TRAMITADO, entonces SOLO se aade el
				// documeto PEE al trmite"
				if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteAcuseRecibo.getEstadoTramite())) {

					// "Solo si ha sido respondido por Correos"
					if (Y41bConstantes.AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS.equals(estadoDelEnvio)) {

						this.arbdoctempDao.add(docHechoPEE_Aux);
						this.arbdoctempDao.insertArbDocTramite(tramiteComun.getIdTramite(),
								docHechoPEE_Aux.getX5codocumento(), Y41bConstantes.TIPO_PROC_ARBITRAJE);
					}
					// "ELSE: Si el envo viene erroneo; entonces NO se hace
					// nada, se queda a la espera de que venga el documento PEE"

				} else {

					// "Si la situacin devuelta por Correos es convertida a
					// ACUSE ACEPTADO, entonces hay que tramitar el trmite de
					// Acuese e informar al responsable."
					// "Aunque solo en el caso de que NO se haya producido un
					// error (el de no existe PEE, ya que el resto lanzan
					// excepcin y no pasan por aqu)"
					String idioma = LocaleContextHolder.getLocale().getLanguage();
					if (situacionCorreos != null
							&& situacionCorreos.equals(Y41bConstantes.SITUACION_ACUSERECIBO_ACEPTADO)
							&& !Y41bConstantes.AA66_ENVIO_SITUACION_ERROR.equals(estadoDelEnvio)) {

						// "Aceptado y NO erroneo >>> Tramita acuse y envia
						// email al responsable."
						this.addTramiteAcuseReciboDesdeRemesa(tramiteAcuseRecibo, tramiteComun, idioma, true,
								docHechoPEE_Aux, censoMonitor);
						this.envioMailAcuseRecibo(tramiteComun, fecha);

					} else {
						// "Guarda acuse."
						this.addTramiteAcuseReciboDesdeRemesa(tramiteAcuseRecibo, tramiteComun, idioma, false,
								docHechoPEE_Aux, censoMonitor);
					}
				}
			} catch (ParseException e) {
				logger.error("error ParseException", e);
				throw new Y41bUDAException("error.generico", true, e);
			} catch (Exception e) {
				logger.error("error genrico", e);
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
	}

	/**
	 * Envio mail acuse de recibo aceptado
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param fecha
	 *            Date
	 */
	private void envioMailAcuseRecibo(TramiteComun tramiteComun, Date fecha) {
		// Enviar mail
		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = solarbDao.find(solarb);

		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(tramiteComun.getIdExpediente());

		arbexp = this.arbexpDao.find(arbexp);

		CensoMonitor responsableExpediente = new CensoMonitor();
		responsableExpediente.setMocodigo(arbexp.getExmocodigo());

		if (responsableExpediente.getMocodigo() != null && !responsableExpediente.getMocodigo().equals("")) {
			responsableExpediente = this.censoMonitorDao.find(responsableExpediente);
		}

		String from = "";
		if (responsableExpediente != null && responsableExpediente.getOrganismo() != null) {
			from = responsableExpediente.getOrganismo().getEmail();
		}

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

		StringBuffer asunto = new StringBuffer();
		asunto.append(
				appMessageSource.getMessage("acuserecibido.mail.asunto", null, new Locale(Y41bConstantes.CASTELLANO)))
				.append(" ")
				.append(solarb.getCodCompletoConPrefijo()).append(" / ").append(appMessageSource
						.getMessage("acuserecibido.mail.asunto", null, new Locale(Y41bConstantes.EUSKERA)))
				.append(" ").append(solarb.getCodCompletoConPrefijo());

		StringBuffer texto = new StringBuffer();
		texto.append("<B>")
				.append(appMessageSource.getMessage("acuserecibido.mail.texto", null,
						new Locale(Y41bConstantes.CASTELLANO)))
				.append("</B>").append(" ").append(solarb.getCodCompletoConPrefijo()).append("<BR>").append("<B>")
				.append(appMessageSource.getMessage("acuserecibido.mail.textofecha", null,
						new Locale(Y41bConstantes.CASTELLANO)))
				.append("</B>").append(" ").append(Y41bUtils.parseDateToString(fecha, Y41bConstantes.CASTELLANO))
				.append("<BR><BR>").append("<B>")
				.append(appMessageSource.getMessage("acuserecibido.mail.texto", null,
						new Locale(Y41bConstantes.EUSKERA)))
				.append("</B>").append(" ").append(solarb.getCodCompletoConPrefijo()).append("<BR>").append("<B>")
				.append(appMessageSource.getMessage("acuserecibido.mail.textofecha", null,
						new Locale(Y41bConstantes.EUSKERA)))
				.append("</B>").append(" ").append(Y41bUtils.parseDateToString(fecha, Y41bConstantes.EUSKERA))
				.append("<BR><BR>");
		String destinatariosMail = responsableExpediente.getMocoem();

		ArrayList attachments = new ArrayList();

		// Envio mail
		Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from, destinatariosMail, "", attachments);
	}

	/**
	 * Counts rows in the Tramites table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findAllNotifiComuniCount(NotificacionesComunicacionesBusqueda filterNotifComuni) {
		return this.arbtramexpDao.findAllNotifiComuniCount(filterNotifComuni);
	}

	/**
	 * Busca los documentos de notificacion o comunicacion que componen la
	 * remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return List
	 * @throws Exception
	 * @throws SQLException
	 * @throws SerialException
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifiComuni) throws Exception {

		List<NotificacionesComunicacionesBusqueda> listaClobsNotifiComuni = this.arbtramexpDao
				.findBlobTablaDocumentosHecho(filterNotifiComuni);
		if (listaClobsNotifiComuni != null) {

			for (NotificacionesComunicacionesBusqueda notificacionesComunicacionesBusquedaAux : listaClobsNotifiComuni) {

				// si est en dokusi, descargar de dokusi
				if (notificacionesComunicacionesBusquedaAux != null
						&& notificacionesComunicacionesBusquedaAux.getQ5iddocumentum() != null
						&& !notificacionesComunicacionesBusquedaAux.getQ5iddocumentum().equals("")) {
					// descargar de dokusi
					// descargar documentos dokusi
					Documento documento = new Documento();
					User user = new User();
					user.setNombre(Y41bConstantes.COD_APLICACION);
					user.setDni(Y41bConstantes.COD_APLICACION);
					documento.setUser(user);
					Procedure procedure = new Procedure();
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
					documento.setProcedure(procedure);
					documento.setOidDokusi(notificacionesComunicacionesBusquedaAux.getQ5iddocumentum());

					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

					Blob blob = new SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
					notificacionesComunicacionesBusquedaAux.setQ5datafile(blob);
				} else {
					// si no est en dokusi descargar de base de datos
				}
			}
		}
		return listaClobsNotifiComuni;
	}

	/**
	 * Finds a List of rows in the Remesa table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifComuni, Pagination pagination) {

		filterNotifComuni.setCompatibleAA66(this.compatibleConAA66(filterNotifComuni));

		List<NotificacionesComunicacionesBusqueda> listNotifiComuniBusqueda = this.arbtramexpDao
				.findAllNotifiComuni(filterNotifComuni, pagination);

		for (NotificacionesComunicacionesBusqueda notifcomun : listNotifiComuniBusqueda) {
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(Y41bConstantes.TIPO_PROC_ARBITRAJE).append(" ").append(notifcomun.getDecoor())
					.append("-").append(notifcomun.getDenror()).append("-").append(notifcomun.getDenran());

			notifcomun.setRmtipoExpediente(filterNotifComuni.getRmtipoExpediente());

			notifcomun.setNumExpediente(numeroExpediente.toString());

			// En caso de que sea el destino Sede fijar la direcci�n de la
			// misma
			if (notifcomun.getEhsede() != null && notifcomun.getEhsede().equals("S")) {

				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEsnif(notifcomun.getNif());

				establecimiento = this.establecimientoService.obtenerEstablecimientoSede(establecimiento);

				if (establecimiento != null) {
					Sede sede = new Sede();
					sede.setEscodigo(establecimiento.getEscodigo());
					sede.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);

					sede = this.establecimientoService.findEstablecimientoSede(sede);
					if (sede != null) {
						notifcomun.setNombre_CP(sede.getNombreCp());
						if (sede.getNombreMunicipio() != null) {
							notifcomun.setNombre_Municipio(sede.getNombreMunicipio());
						}
						if (sede.getNombreLocalidad() != null) {
							notifcomun.setNombre_Localidad(sede.getNombreLocalidad());
						}
						if (sede.getNombreProvincia() != null) {
							notifcomun.setNombre_Provincia(sede.getNombreProvincia());
						}

						if (sede.getNombreCalle() != null) {
							notifcomun.setNombre_Calle(sede.getNombreCalle());

							notifcomun.setNombre_Portal(sede.getNombrePortal());
							notifcomun.setNombre_Piso(sede.getNombrePiso());

						} else if (sede.getDireccionNocapv() != null) {
							notifcomun.setNombre_Calle("");
							notifcomun.setNombre_Portal("");
							notifcomun.setNombre_Piso("");
							if (sede.getNoraPaisNombre() != null && !sede.getNoraPaisNombre().equals("")) {
								notifcomun.setNombre_Pais(sede.getNoraPaisNombre());
							}
							notifcomun.setExtranjero(sede.getExtranjero());
							notifcomun.setDireccionNocapv(sede.getDireccionNocapv());
						}
					} else {
						this.ponerVaciaLaSedeEnLaNotificaComunica(notifcomun);
					}
				} else {
					this.ponerVaciaLaSedeEnLaNotificaComunica(notifcomun);
				}
			}
			// PREPARO LAS DIRECCIONES DESTINO
			StringBuffer direccion2 = new StringBuffer();
			if (notifcomun.getNombre_CP() != null && !notifcomun.getNombre_CP().equals("")) {
				direccion2.append(notifcomun.getNombre_CP());
			} else {
				direccion2.append("");
				notifcomun.setNombre_CP("");
			}
			if (notifcomun.getExtranjero() != null && notifcomun.getExtranjero().equals("S")) {
				notifcomun.setDireccion1(notifcomun.getDireccionNocapv());
				direccion2.append(" ").append(notifcomun.getNombre_Pais());
				notifcomun.setDireccion2(direccion2.toString());

			} else {
				if (notifcomun.getNombre_Calle() != null && !notifcomun.getNombre_Calle().equals("")) {
					StringBuffer direccionCapv = new StringBuffer();
					direccionCapv.append(notifcomun.getNombre_Calle());
					if (notifcomun.getNombre_Portal() != null && !notifcomun.getNombre_Portal().equals("")) {
						direccionCapv.append(" ").append(notifcomun.getNombre_Portal());
					}
					if (notifcomun.getNombre_Piso() != null && !notifcomun.getNombre_Piso().equals("")) {
						direccionCapv.append(" ").append(notifcomun.getNombre_Piso());
					}
					notifcomun.setDireccion1(direccionCapv.toString());
				} else {
					notifcomun.setDireccion1(notifcomun.getDireccionNocapv());
				}

				direccion2.append(" ").append(notifcomun.getNombre_Municipio());
				notifcomun.setDireccion2(direccion2.toString());

			}

			// Creamos el campo direccion del organismo conectado
			StringBuffer direccionCompleta = new StringBuffer();

			if (notifcomun.getNombreCalle() != null && !notifcomun.getNombreCalle().equals("")) {
				direccionCompleta.append(notifcomun.getNombreCalle());

				if (notifcomun.getNombrePortal() != null && !notifcomun.getNombrePortal().equals("")) {
					direccionCompleta.append(", ").append(notifcomun.getNombrePortal());
				}
			}

			notifcomun.setDireccionOrganismo(direccionCompleta.toString());

			// Creamos el campo codigo postal y municipio del organismo
			// conectado
			StringBuffer cpMunicipio = new StringBuffer();

			if (notifcomun.getNombreCp() != null && !notifcomun.getNombreCp().equals("")) {
				cpMunicipio.append(notifcomun.getNombreCp());

				if (notifcomun.getNombreMunicipio() != null && !notifcomun.getNombreMunicipio().equals("")) {
					cpMunicipio.append(" ").append(notifcomun.getNombreMunicipio());
				}
			} else if (notifcomun.getNombreMunicipio() != null && !notifcomun.getNombreMunicipio().equals("")) {
				cpMunicipio.append(notifcomun.getNombreMunicipio());
			}

			notifcomun.setCpMunicipioOrganismo(cpMunicipio.toString());

			// Creamos el campo pie pagina linea1
			StringBuffer piepagina_linea1 = new StringBuffer(Y41bConstantes.NUM_20);

			piepagina_linea1.append(notifcomun.getDireccionOrganismo()).append(" - ")
					.append(notifcomun.getCpMunicipioOrganismo()).append(" / ").append(" Tl. ")
					.append(notifcomun.getTelefonoOrganismo());

			notifcomun.setPiePaginaLinea1(piepagina_linea1.toString());

			// Creamos el campo pie pagina linea1
			StringBuffer piepagina_linea2 = new StringBuffer();

			piepagina_linea2.append("e-mail: ").append(notifcomun.getEmailOrganismo()).append(" / ")
					.append(notifcomun.getWebOrganismo());

			notifcomun.setPiePaginaLinea2(piepagina_linea2.toString());
		}

		return listNotifiComuniBusqueda;
	}

	/**
	 * 
	 * @param notifcomun
	 *            NotificacionesComunicacionesBusqueda
	 */
	private void ponerVaciaLaSedeEnLaNotificaComunica(NotificacionesComunicacionesBusqueda notifcomun) {
		notifcomun.setNombre_CP("");
		notifcomun.setNombre_Municipio("");
		notifcomun.setNombre_Provincia("");
		notifcomun.setNombre_Calle("");
		notifcomun.setNombre_Portal("");
		notifcomun.setNombre_Piso("");
		notifcomun.setNombre_Pais("");
		notifcomun.setExtranjero("");
		notifcomun.setDireccionNocapv("");
	}

	/**
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @return boolean
	 */
	private boolean compatibleConAA66(NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle) {
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.INTEGRACION_CON_AA66);
		parametros = this.parametrosDao.find(parametros);
		if (null != parametros && null != parametros.getValor()) {
			String integracion = parametros.getValor();
			return integracion.equalsIgnoreCase(Y41bConstantes.VALOR_SI);
		}
		return false;
	}

	/**
	 * @param arbtramexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp updateRegistroSalidaPlatea(Arbtramexp arbtramexp) {
		return this.arbtramexpDao.updateRegistroSalidaPlatea(arbtramexp);
	}

	/**
	 * Guardar tramite comunicacion.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitar
	 *            the tramitar
	 * @param modoEditar
	 *            the modo editar
	 * @param esComunicacionOrdinaria
	 *            the es notificacion ordinaria
	 * @param esComunicacionElectronica
	 *            the es notificacion tipo electronica
	 * @param idZipFile
	 *            the id zip file
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteComunicacion(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoEditar, boolean esComunicacionOrdinaria,
			boolean esComunicacionElectronica, String idZipFile, CensoMonitor censoMonitor) throws Exception {

		if (tramitar && Y41bConstantes.VALOR_SI.equals(tramiteComunicacion.getSede())) {
			this.validarSiExisteSede(tramiteComunicacion.getDestinatario());
		}

		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteComunicacion: 1/14.\ntramitar:" + tramitar
				+ ".\nmodoEditar" + modoEditar + ".\nesNotificacionTipoElectronica" + esComunicacionElectronica + ".");
		Arbtramexp arbtramexp = new Arbtramexp();

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);
		arbtramexp.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			arbtramexp = this.arbtramexpDao.find(arbtramexp);
		}

		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION);
		arbtramexp.setTrfecini(tramiteComunicacion.getFechaInicio());

		arbtramexp.setTrfecfin(tramiteComunicacion.getFechaFin());
		arbtramexp.setCensoMonitorEj(tramiteComunicacion.getInstructorEjecucion());

		// Remesas Ini
		arbtramexp.setTrenvrem(tramiteComunicacion.getEnvRemesaComunicacion());
		arbtramexp.setTrcodrem(tramiteComunicacion.getIdRemesaComunicacion());
		// Remesas Fin

		if (tramitar) {
			arbtramexp.setTrfecfin(tramiteComunicacion.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramiteComunicacion.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}
		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteComunicacion: 2/14.");

		arbtramexp.setSolarb(solarb);
		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setCensoMonitor(tramiteComunicacion.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramiteComunicacion.getComentario()));

		arbtramexp.setTrfecnotif(tramiteComunicacion.getFechaComunicacion());
		arbtramexp.setTruaidinterv(new BigDecimal(tramiteComunicacion.getDestinatario()));
		arbtramexp.setTrsede(tramiteComunicacion.getSede());
		arbtramexp.setTrtipocom(esComunicacionElectronica ? Y41bConstantes.TIPO_COMUNICACION_TELEMATICA
				: Y41bConstantes.TIPO_COMUNICACION_CORREOORDINARIO);
		arbtramexp.setTrfecregs(tramiteComunicacion.getFechasalida());
		arbtramexp.setTrnumregs(tramiteComunicacion.getNumregistrosalida());
		arbtramexp.setTrasuntocomunicacion(tramiteComunicacion.getAsuntoComunicacion());
		arbtramexp.setTrtexto(Y41bUtils.stringToClob(tramiteComunicacion.getTextoComunicacion()));
		arbtramexp.setTridmailorigen(tramiteComunicacion.getIdmailorigen());
		arbtramexp.setTrmailorigen(tramiteComunicacion.getMailorigen());
		arbtramexp.setTridmaildestino(tramiteComunicacion.getIdmaildestino());
		arbtramexp.setTrmaildestino(tramiteComunicacion.getMaildestino());

		// Se inserta el tramite
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		Arbtramexp3ServiceImpl.logger.info(
				"ArbtramexpServiceImpl - addTramiteComunicacion: 3/14." + new BigDecimal(tramiteComun.getIdTramite()));

		// Obtener registro salida si no viene de pantalla
		if (tramitar && esComunicacionOrdinaria) {
			if (arbtramexp.getTrenvrem() == null || Y41bConstantes.NO.equals(arbtramexp.getTrenvrem())) {
				if (arbtramexp.getTrnumregs() == null || arbtramexp.getTrnumregs().equals("")) {
					RegistroSalida registroSalida = this.getRegistroSalida(tramiteComun,
							tramiteComunicacion.getDestinatario(), false);
					arbtramexp.setTrnumregs(registroSalida.getRegistryNumber());
					arbtramexp.setTrfecregs(registroSalida.getRegistryDate());
				}
			}
		}
		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteComunicacion: 4/14.");

		this.arbtramexp2Service.setArbtramexp(arbtramexp);
		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteComunicacion: 5/14.");
		// / Recupero de la tabla temporal la lista de documentos del
		// expediente
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
		List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAllTipoDocArb(adjuntardocs, null);

		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramiteComunicacion.getAnyadirPlantilla());

		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteComunicacion: 8/14.");

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				if (Y41bUtils.interactuarConDokusi()) {
					throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
				}
			}
			Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteComunicacion: 9/14.");

			if (esComunicacionOrdinaria) {
				this.procesarComunicacionNotificacionOrdinaria(listadjuntardocs, listDocumentoHecho, arbtramexp,
						tramiteComunAux, idZipFile);
			} else {
				this.procesarComunicacionElectronica(listDocumentoHecho, tramiteComunicacion, arbtramexp, censoMonitor);
			}

			Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteComunicacion: 10/14.");
			/* actualizamos la bandeja */
			this.arbtramexp2Service.actualizaBandeja(arbtramexp);
			Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteComunicacion: 11/14.");

			/* actualizamos el ultimo tramite */
			this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
			Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteComunicacion: 12/14.");

			/* actualizo los envios del expediente */
			this.insertEnvios(arbtramexp);
			Arbtramexp3ServiceImpl.logger.info(
					"ArbtramexpServiceImpl - addTramiteComunicacion: 13/14." + tramiteComunicacion.getEjgvDocument());

			if (tramiteComunicacion.getEjgvDocument() != null) {
				Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteComunicacion: 13/14."
						+ tramiteComunicacion.getEjgvDocument().length());
			}

			Arbtramexp3ServiceImpl.logger.info(
					"ArbtramexpServiceImpl - addTramiteComunicacion - Genero el aviso para la orden del consejero si procede. ");
			// Si se envia a remesa se generarn los avisos en remesas
			if (!"S".equals(tramiteComunicacion.getEnvRemesaComunicacion())) {
				this.crearAvisoNotifiComuniRegistroSalida(arbtramexp);
			}

			// Para las comunicaciones que no van por remesa, informamos a mis
			// gestiones
			if (!"S".equals(tramiteComunicacion.getEnvRemesaComunicacion())) {
				if (arbtramexp.getTrtridrel() != null) {
					this.crearAviso(arbtramexp, solarb, Y41bUtils.hoy());
				}
				Arbinterv arbinterv = new Arbinterv();
				arbinterv.setUaidinterv(arbtramexp.getTruaidinterv());
				arbinterv = this.arbintervdao.find(arbinterv);
				if (arbinterv != null && arbinterv.getUatipointerv() != null
						&& (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
										.equals(arbinterv.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
										.equals(arbinterv.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO
										.equals(arbinterv.getUatipointerv())
								|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO
										.equals(arbinterv.getUatipointerv()))) {
					// volvemos a recuperar los documentos por si en este
					// intervalo de tiempo se ha convertido a pdf
					listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
					this.arbtramexp4Service.actualizarMisGestionesComunicacion(arbtramexp, listDocumentoHecho,
							censoMonitor);
				}
			}

		} else {
			this.arbtramexp2Service.actualizaBandeja(arbtramexp);
			/******************************************/
			Arbtramexp3ServiceImpl.logger
					.info("SantramexpServiceImpl - addTramiteComunicacion: INICIO SUBIDA DE DOCUMENTOS A DOKUSI.");
			this.guardarDocumentosDokusiTramiteComunicacionNotificacion(listDocumentoHecho, tramiteComun);
		}

		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteComunicacion: FIN.");

		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);

		return arbtramexp;

	}

	/**
	 * Tramitar tramite comunicacion.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoEditar
	 *            the modo editar
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteComunicacionMail(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String modoEditar, CensoMonitor censoMonitor) throws Exception {

		if (Y41bConstantes.VALOR_SI.equals(tramiteComunicacion.getSede())) {
			this.validarSiExisteSede(tramiteComunicacion.getDestinatario());
		}
		if (censoMonitor != null && (censoMonitor.getMocoem() == null || censoMonitor.getMocoem().equals(""))) {
			throw new Y41bUDAException("error.comunicacion.emailusuarioconectado", true, new Exception());
		}

		Arbtramexp arbtramexp = new Arbtramexp();

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);
		arbtramexp.setTrid(tramiteComun.getIdTramite());
		if (Y41bConstantes.MODO_POPUP_MODIFICACION.equals(modoEditar)) {
			arbtramexp = this.arbtramexpDao.find(arbtramexp);
		}
		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION);
		arbtramexp.setTrfecini(tramiteComunicacion.getFechaInicio());

		arbtramexp.setTrfecfin(tramiteComunicacion.getFechaFin());
		arbtramexp.setCensoMonitorEj(tramiteComunicacion.getInstructorEjecucion());
		// Remesas Ini
		arbtramexp.setTrenvrem(tramiteComunicacion.getEnvRemesaComunicacion());
		arbtramexp.setTrcodrem(tramiteComunicacion.getIdRemesaComunicacion());
		// Remesas Fin
		arbtramexp.setTrfecfin(tramiteComunicacion.getFechaFin());
		arbtramexp.setCensoMonitorEj(tramiteComunicacion.getInstructorEjecucion());
		// llamnar a platea
		// cambiar fase
		arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteComunicacion: 2/14.");

		arbtramexp.setSolarb(solarb);
		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setCensoMonitor(tramiteComunicacion.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramiteComunicacion.getComentario()));
		arbtramexp.setTrfecnotif(tramiteComunicacion.getFechaComunicacion());
		arbtramexp.setTruaidinterv(new BigDecimal(tramiteComunicacion.getDestinatario()));
		arbtramexp.setTrsede(tramiteComunicacion.getSede());
		arbtramexp.setTrtipocom(Y41bConstantes.TIPO_COMUNICACION_CORREOELECTRONICO);
		arbtramexp.setTrfecregs(tramiteComunicacion.getFechasalida());
		arbtramexp.setTrnumregs(tramiteComunicacion.getNumregistrosalida());
		arbtramexp.setTrasuntocomunicacion(tramiteComunicacion.getAsuntoComunicacion());
		arbtramexp.setTrtexto(Y41bUtils.stringToClob(tramiteComunicacion.getTextoComunicacion()));
		arbtramexp.setTridmailorigen(tramiteComunicacion.getIdmailorigen());
		arbtramexp.setTrmailorigen(tramiteComunicacion.getMailorigen());
		arbtramexp.setTridmaildestino(tramiteComunicacion.getIdmaildestino());
		arbtramexp.setTrmaildestino(tramiteComunicacion.getMaildestino());

		// Se inserta el tramite
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		this.arbtramexp2Service.setArbtramexp(arbtramexp);

		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteComunicacion: 5/14.");

		// / Recupero de la tabla temporal la lista de documentos del
		// expediente
		Adjuntardocs adjuntardocs = new Adjuntardocs();
		adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
		adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
		List<Adjuntardocs> listadjuntardocs = this.adjuntardocsDao.findAllTipoDocArb(adjuntardocs, null);

		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl - addTramiteComunicacion: 8/14.");

		// Mando el email
		boolean enviadoOk = this.envioEmailComunicacion(tramiteComunicacion, tramiteComun, listadjuntardocs,
				censoMonitor);
		if (!enviadoOk) {
			throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
		}

		// Actualizar ultimo tramite
		this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);

		this.insertEnvios(arbtramexp);

		// Tratar la bandeja, le mandamos el estado a tramitado porque es como
		// si le hubiera dado a tramitar
		this.arbtramexp2Service.actualizaBandeja(arbtramexp);

		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);

		return arbtramexp;
	}

	/**
	 * Metodo que manda un email con la información de comunicacion recibida
	 * por parámetro.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return boolean
	 * @throws Exception
	 */
	private boolean envioEmailComunicacion(TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			List<Adjuntardocs> listadjuntardocs, CensoMonitor censoMonitor) throws Exception {

		try {
			// 1. Calculo FROM + TO del email

			String from = tramiteComunicacion.getMailorigen();
			String destinatariosMail = "";
			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setUaidinterv(new BigDecimal(tramiteComunicacion.getDestinatario()));

			arbinterv = this.arbintervdao.find(arbinterv);

			if (arbinterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_ESTABLECIMIENTO)
					|| arbinterv.getUatipointerv().equals(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO)) {
				destinatariosMail = tramiteComunicacion.getMaildestino();
			} else {
				destinatariosMail = arbinterv.getUacoem();
			}

			if (!Y41bUtils.isFilled(destinatariosMail) || !Y41bUtils.isFilled(from)) {
				throw new Y41bUDAException("error.comunicacion.email", true, new Exception());
			}
			StringBuffer destinatarios = new StringBuffer();
			destinatarios.append(destinatariosMail);

			StringBuffer copiaoculta = new StringBuffer();
			copiaoculta.append(censoMonitor.getMocoem());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

			String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");

			// 2. Creo el asunto
			// Calculo el numero de expediente
			// Obtener el numero de expediente
			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());
			solarb = this.solarbDao.find(solarb);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(solarb.damecodCompletoPlatea());

			StringBuffer asunto = new StringBuffer();
			if (Y41bUtils.isFilled(tramiteComunicacion.getAsuntoComunicacion())) {
				asunto.append(tramiteComunicacion.getAsuntoComunicacion());
			} else {
				// Castellano + Euskera
				asunto.append(this.appMessageSource.getMessage("comunicacion.mail.asunto", null,
						new Locale(Y41bConstantes.CASTELLANO)))
						.append(" ")
						.append(numeroExpediente).append(" / ").append(this.appMessageSource
								.getMessage("comunicacion.mail.asunto", null, new Locale(Y41bConstantes.EUSKERA)))
						.append(" ").append(numeroExpediente);
			}

			// 3. Creo el contenido del mail
			StringBuffer texto = new StringBuffer();
			texto.append("<B>")
					.append(this.appMessageSource.getMessage("comunicacion.mail.texto", null,
							new Locale(Y41bConstantes.CASTELLANO)))
					.append(" / ")
					.append(this.appMessageSource.getMessage("comunicacion.mail.texto", null,
							new Locale(Y41bConstantes.EUSKERA)))
					.append("</B><BR><BR>").append(tramiteComunicacion.getTextoComunicacion().replaceAll("\n", "<BR>"));

			// 4. Creo attachments del mail
			List<AttachFile> attachments = new ArrayList<AttachFile>();

			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				for (Adjuntardocs adjuntardocs : listadjuntardocs) {
					Documento documento = new Documento();
					if (adjuntardocs != null && adjuntardocs.getPtcodigo() != null
							&& !adjuntardocs.getPtcodigo().equals("")) {
						PlantillaTramite plantillaTramite = new PlantillaTramite();
						plantillaTramite.setPtcodigo(adjuntardocs.getPtcodigo());
						// Obtener la plantilla del tramite
						// Obtener la plantilla del tramite
						List<PlantillaTramite> lplantillaTramite = this.plantillaTramiteDao.findAll(plantillaTramite,
								null);
						if (lplantillaTramite != null && lplantillaTramite.size() > 0) {
							documento.setNolocalizable(lplantillaTramite.get(0).getNolocalizable());
						} else {// No existe la
								// plantilla_tramite,
								// miramos en plantilla_decision
							PlantillaDecision plantillaDecision = new PlantillaDecision();
							plantillaDecision.setPdcodigo(adjuntardocs.getPtcodigo());
							// Obtener la plantilla decision
							long cont = this.plantillaDecisionDao.findAllCount(plantillaDecision);
							if (cont > 0) {// En esta tabla las
											// plantillas son
											// localizables
											// siempre
								documento.setNolocalizable(Y41bConstantes.VALOR_NO);
							}
						}
					}

					if (Y41bUtils.isDocumentoLocalizable(adjuntardocs) && (documento.getNolocalizable() == null
							|| !documento.getNolocalizable().equals(Y41bConstantes.VALOR_SI))) {
						if (Y41bUtils.interactuarConDokusi()) {
							if (!StringUtils.isBlank(adjuntardocs.getThiddocumentum())) {
								// 1.User
								User user = new User();
								user.setNombre(Y41bConstantes.COD_APLICACION);
								user.setDni(Y41bConstantes.COD_APLICACION);
								documento.setUser(user);
								Procedure procedure = new Procedure();
								procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
								documento.setProcedure(procedure);
								documento.setOidDokusi(adjuntardocs.getThiddocumentum());
								Formato formato = this.y41bDokusiAdapterService
										.recuperarFormatosDocumentosDokusi(documento);

								if (formato != null && formato.getName().equalsIgnoreCase(Y41bConstantes.PDFA)) {
									if (adjuntardocs != null && adjuntardocs.getThnofile() != null
											&& !com.ejie.y41b.utils.Y41bUtils
													.getExtensionFile(adjuntardocs.getThnofile())
													.equalsIgnoreCase(Y41bConstantes.PDF)) {
										throw new Y41bUDAException("error.documentos.sinlocalizador", true,
												new Exception());
									}
								} else {
									throw new Y41bUDAException("error.documentos.sinlocalizador", true,
											new Exception());
								}
							} else {
								throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
							}
						}
					}
					AttachFile fileattach = new AttachFile();
					Arbdoctemp arbdoctempObj = new Arbdoctemp();
					arbdoctempObj.setX5codocumento(adjuntardocs.getThcodocumento());

					Arbdoctemp documentoHechoAux = (Arbdoctemp) this.arbdoctempService.find(arbdoctempObj);

					fileattach.setContentType(adjuntardocs.getThcontenttypefile());
					fileattach.setNombre(adjuntardocs.getThnofile());
					fileattach.setAdjunto(documentoHechoAux.getX5datafile());

					attachments.add(fileattach);

				}
			}

			// 5. Envio mail
			boolean envio = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from,
					destinatarios.toString(), copiaoculta.toString(), attachments);

			return envio;
		} finally {
			// 6. Borro de tablas LOB los documentos
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				Arbdoctemp documentoHechoDetalle = null;
				for (Adjuntardocs adjuntardocs : listadjuntardocs) {
					documentoHechoDetalle = new Arbdoctemp();
					documentoHechoDetalle.setX5codocumento(adjuntardocs.getThcodocumento());
					Arbtramexp3ServiceImpl.logger
							.info("ArbtramexpServiceImpl. - crearZipDocumentosExpediente. crearZipDocumentosExpediente. Paso 11. FINALLY. bucle."
									+ adjuntardocs.getThcodocumento() + ".");

				}
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.Arbtramexp3Service#findTramiteComunicacion(com.
	 * ejie.y41b.model.TramiteComunicacion, com.ejie.y41b.model.CensoMonitor)
	 */
	@Override
	public TramiteComunicacion findTramiteComunicacion(TramiteComunicacion tramiteComunicacion, CensoMonitor monitor)
			throws SQLException, IOException {
		CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setTrid(tramiteComunicacion.getIdTramite());

		arbtramexp = this.arbtramexpDao.find(arbtramexp);

		TramiteComunicacion tramiteComunicacionAux = new TramiteComunicacion();
		tramiteComunicacionAux.setIdTramite(arbtramexp.getTrid().toString());

		tramiteComunicacionAux.setFechaInicio(arbtramexp.getTrfecini());
		tramiteComunicacionAux.setFechaFin(arbtramexp.getTrfecfin());

		if (arbtramexp.getCensoMonitor() != null) {
			tramiteComunicacionAux.setInstructorAsignado(arbtramexp.getCensoMonitor());
		} else {
			tramiteComunicacionAux.setInstructorAsignado(null);
		}

		if (arbtramexp.getCensoMonitorEj() != null) {
			tramiteComunicacionAux.setInstructorEjecucion(arbtramexp.getCensoMonitorEj());
		} else {
			tramiteComunicacionAux.setInstructorEjecucion(null);
		}

		tramiteComunicacionAux.setEstadoTramite(arbtramexp.getTrestado());

		tramiteComunicacionAux.setFechaComunicacion(arbtramexp.getTrfecnotif());

		tramiteComunicacionAux.setDestinatario(this.calcularDestinatarioComunicacionNotificacion(arbtramexp));

		tramiteComunicacionAux.setSede(arbtramexp.getTrsede());

		tramiteComunicacionAux.setTipoComunicacion(arbtramexp.getTrtipocom());

		tramiteComunicacionAux.setAsuntoComunicacion(arbtramexp.getTrasuntocomunicacion());

		tramiteComunicacionAux.setFechasalida(arbtramexp.getTrfecregs());

		tramiteComunicacionAux.setNumregistrosalida(arbtramexp.getTrnumregs());

		tramiteComunicacionAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));
		tramiteComunicacionAux.setTextoComunicacion(Y41bUtils.clobToString(arbtramexp.getTrtexto()));

		if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
			tramiteComunicacionAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteComunicacionAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		if (arbtramexp.getTrtridrel() != null) {
			tramiteComunicacionAux.setPermisoModificacionDestinatario(Y41bConstantes.NO);
		} else {
			tramiteComunicacionAux.setPermisoModificacionDestinatario(Y41bConstantes.SI);
		}

		// Remesas Ini
		Solarb solarbAux = new Solarb();
		solarbAux = this.solarbDao.find(arbtramexp.getSolarb());

		Arbinterv arbintervAux = new Arbinterv();
		arbintervAux.setSolarb(solarbAux);
		arbintervAux.setUaidinterv(arbtramexp.getTruaidinterv());
		arbintervAux = this.arbintervdao.find(arbintervAux);

		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(arbtramexp.getTrestado())) {
			tramiteComunicacionAux.setEnvRemesaComunicacion(arbtramexp.getTrenvrem());
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbintervAux.getUatipointerv())) {
			tramiteComunicacionAux.setEnvRemesaComunicacion(
					Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(arbintervAux.getUaformanotificacion())
							? Y41bConstantes.NO : Y41bConstantes.SI);
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
				.equals(arbintervAux.getUatipointerv())) {
			Arbinterv arbintervReclamado = this.arbintervdao.dameInterviniente(solarbAux.getSacodigo(),
					Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
			tramiteComunicacionAux.setEnvRemesaComunicacion(
					Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(arbintervReclamado.getUaformanotificacion())
							? Y41bConstantes.NO : Y41bConstantes.SI);
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbintervAux.getUatipointerv())) {
			tramiteComunicacionAux.setEnvRemesaComunicacion(
					Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(arbintervAux.getUaformanotificacion())
							? Y41bConstantes.NO : Y41bConstantes.SI);
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
				.equals(arbintervAux.getUatipointerv())) {
			Arbinterv arbintervReclamante = this.arbintervdao.dameInterviniente(solarbAux.getSacodigo(),
					Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
			tramiteComunicacionAux.setEnvRemesaComunicacion(
					Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA.equals(arbintervReclamante.getUaformanotificacion())
							? Y41bConstantes.NO : Y41bConstantes.SI);
		}

		if (arbtramexp.getTrcodrem() != null && !"".equals(arbtramexp.getTrcodrem())) {
			// Si tiene remesa asociada, recupero datos de la remesa
			Remesa remesa = new Remesa();
			remesa.setRmcodigo(arbtramexp.getTrcodrem());
			remesa = this.remesaDao.find(remesa);
			tramiteComunicacionAux.setIdRemesaComunicacion(remesa.getRmcodigo());
			tramiteComunicacionAux.setFechaRemesaComunicacion(remesa.getRmfechageneracion());
		}
		// Remesas Fin

		tramiteComunicacionAux.setIdmailorigen(arbtramexp.getTridmailorigen());
		tramiteComunicacionAux.setMailorigen(arbtramexp.getTrmailorigen());
		tramiteComunicacionAux.setIdmaildestino(arbtramexp.getTridmaildestino());
		tramiteComunicacionAux.setMaildestino(arbtramexp.getTrmaildestino());

		return tramiteComunicacionAux;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.Arbtramexp3Service#createEJGVDocumentComunicacion
	 * (com.ejie.y41b.model.TramiteComunicacion,
	 * com.ejie.y41b.model.TramiteComun, com.ejie.y41b.model.CensoMonitor,
	 * java.lang.String)
	 */
	@Override
	public RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentComunicacion(
			TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun, CensoMonitor censoMonitor,
			String pcodigo) throws Exception {
		RespuestaCrearEJGVDocumentNotificacion respuestaEjgv = null;
		List<Adjuntardocs> listadjuntardocs = null;
		try {
			Arbtramexp3ServiceImpl.logger.info("ArbtramexpServiceImpl. - Inicio createEJGVDocumentComunicacion");

			CrearNotifEJGV crearNotifEJGV = new CrearNotifEJGV();
			Procedure procedure = new Procedure();
			procedure.setIdProcedimiento(Y41bFuncionesAuxiliaresPlatea.devuelveCodigoProcedimientoPlatea(pcodigo));
			crearNotifEJGV.setProcedure(procedure);

			crearNotifEJGV.setTextoNotificacion(tramiteComunicacion.getTextoComunicacion());

			crearNotifEJGV.setEjercicio(Y41bUtils.fncObtenerAnnoSistema());
			crearNotifEJGV.setIdiomaNotificacion(Y41bConstantes.CASTELLANO);
			Arbtramexp3ServiceImpl.logger
					.info("ArbtramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 1/8");
			// buscar el interviniente
			Arbinterv interviniente = new Arbinterv();
			interviniente.setUaidinterv(new BigDecimal(tramiteComunicacion.getDestinatario()));
			interviniente = this.arbintervdao.find(interviniente);
			Arbtramexp3ServiceImpl.logger
					.info("ArbtramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 2/8");
			DatosPersona datosPersonaSolicitante = new DatosPersona();
			datosPersonaSolicitante.setDni(interviniente.getUanif().trim().toUpperCase());
			datosPersonaSolicitante.setNombre(interviniente.getUanombre() == null ? ""
					: interviniente.getUanombre().concat(" ")
							.concat(interviniente.getUaapellido1() == null ? "" : interviniente.getUaapellido1())
							.concat(" ")
							.concat(interviniente.getUaapellido2() == null ? "" : interviniente.getUaapellido2()));
			Arbtramexp3ServiceImpl.logger
					.info("ArbtramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 3/8");
			datosPersonaSolicitante.setMail(interviniente.getUacoem());
			datosPersonaSolicitante.setTelefono(interviniente.getUanrtel());

			crearNotifEJGV.setSolicitante(datosPersonaSolicitante);

			DatosPersona datosPersonaSender = new DatosPersona();
			datosPersonaSender.setDni(censoMonitor.getOrganismo().getCodOrg());
			datosPersonaSender.setNombre(censoMonitor.getOrganismo().getNombreEs());
			Arbtramexp3ServiceImpl.logger
					.info("ArbtramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 4/8");
			crearNotifEJGV.setSender(datosPersonaSender);
			// Obtener tramite
			Arbtramexp arbtramexp = new Arbtramexp();
			arbtramexp.setTrid(tramiteComun.getIdTramite());
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			// Obtener el numero de expediente
			Solarb solarb = new Solarb();
			solarb.setSacodigo(tramiteComun.getIdExpediente());

			solarb = this.solarbDao.find(solarb);

			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(solarb.damecodCompletoPlatea());
			Arbtramexp3ServiceImpl.logger
					.info("ArbtramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 5/8");
			crearNotifEJGV.setNumeroExpediente(numeroExpediente.toString());

			Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
			// Indicar la serie documental que corresponde al expediente
			crearNotifEJGV.setSerieDocumental(prop.getProperty(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE + ".serie."
					+ Y41bDokusiHelper.getProvSerieFromNumExp(numeroExpediente.toString())));
			Arbtramexp3ServiceImpl.logger
					.info("ArbtramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 6/8");
			// Recupero de la tabla temporal la lista de documentos del
			// expediente
			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(tramiteComun.getIdTramite());
			adjuntardocs.setTrpcodigo(tramiteComun.getTipoProcedimiento().getPcodigo());
			listadjuntardocs = this.adjuntardocsDao.findAllTipoDocArb(adjuntardocs, null);

			List<Documento> listDocumentos = new ArrayList<Documento>();
			Documento documento = null;
			Arbtramexp3ServiceImpl.logger
					.info("ArbtramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 7/8");
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {
					// obtener los datos del documento
					adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

					if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
									.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
						// crear el objeto DocumentoHecho
						DocumentoHecho documentoHecho = new DocumentoHecho();
						documentoHecho.setQ5iddocumentum(adjuntardocsAux.getThiddocumentum());
						documentoHecho.setQ5idTipodoc(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						documentoHecho.setQ5codocumento(adjuntardocsAux.getThcodocumento());
						documentoHecho.setQ5nofile(adjuntardocsAux.getThnofile());
						documentoHecho.setQ5origen(adjuntardocsAux.getThorigen());
						documentoHecho.setQ5ptcodigo(adjuntardocsAux.getPtcodigo());
						documentoHecho.setQ5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiSol(documentoHecho,
								tramiteComunAux);
					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
									.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {
						// crear el objeto Sandoctemp
						Sandoctemp sandocTemp = new Sandoctemp();
						sandocTemp.setU5iddocumentum(adjuntardocsAux.getThiddocumentum());
						sandocTemp.setU5tipodocumento(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						sandocTemp.setU5codocumento(adjuntardocsAux.getThcodocumento());
						sandocTemp.setU5nofile(adjuntardocsAux.getThnofile());
						sandocTemp.setU5origen(adjuntardocsAux.getThorigen());
						sandocTemp.setU5ptcodigo(adjuntardocsAux.getPtcodigo());
						sandocTemp.setU5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiSan(sandocTemp, tramiteComunAux);
					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null && adjuntardocsAux
									.getTipoProcedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
						// crear el objeto Sandoctemp
						Arbdoctemp arbdocTemp = new Arbdoctemp();
						arbdocTemp.setX5iddocumentum(adjuntardocsAux.getThiddocumentum());
						Arbtipdoc arbtipdoc = new Arbtipdoc();
						arbtipdoc.setTdid(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						arbdocTemp.setArbtipdoc(arbtipdoc);
						arbdocTemp.setX5codocumento(adjuntardocsAux.getThcodocumento());
						arbdocTemp.setX5nofile(adjuntardocsAux.getThnofile());
						arbdocTemp.setX5origen(adjuntardocsAux.getThorigen());
						arbdocTemp.setX5ptcodigo(adjuntardocsAux.getPtcodigo());
						arbdocTemp.setX5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiArb(arbdocTemp, tramiteComunAux);
					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null
							&& (adjuntardocsAux.getTipoProcedimiento().getPcodigo()
									.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA)
									|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
											.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_MOD)
									|| adjuntardocsAux.getTipoProcedimiento().getPcodigo()
											.equals(Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA))) {

					} else if (adjuntardocsAux != null && adjuntardocsAux.getTipoProcedimiento() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo() != null
							&& adjuntardocsAux.getTipoProcedimiento().getPcodigo()
									.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
						// crear el objeto DocumentoHecho
						DocumentoHecho documentoHecho = new DocumentoHecho();
						documentoHecho.setQ5iddocumentum(adjuntardocsAux.getThiddocumentum());
						documentoHecho.setQ5idTipodoc(adjuntardocsAux.getTipoDocumento().getIdTipodoc());
						documentoHecho.setQ5codocumento(adjuntardocsAux.getThcodocumento());
						documentoHecho.setQ5nofile(adjuntardocsAux.getThnofile());
						documentoHecho.setQ5origen(adjuntardocsAux.getThorigen());
						documentoHecho.setQ5ptcodigo(adjuntardocsAux.getPtcodigo());
						documentoHecho.setQ5datafile(adjuntardocsAux.getThdatafile());

						TramiteComun tramiteComunAux = new TramiteComun();
						tramiteComunAux.setIdExpediente(adjuntardocsAux.getThidExpediente());
						tramiteComunAux.setIdTramite(adjuntardocsAux.getThidTramite());

						documento = this.soltramexpService.registrarDocumentosDokusiIns(documentoHecho,
								tramiteComunAux);
					}

					listDocumentos.add(documento);
				}
			}

			Arbtramexp3ServiceImpl.logger
					.info("ArbtramexpServiceImpl. - Inicio createEJGVDocumentComunicacion. PASO 8/8");

			crearNotifEJGV.setDocumentosAdjuntos(listDocumentos);
			Arbtramexp3ServiceImpl.logger
					.info("ArbtramexpServiceImpl. - createEJGVDocumentComunicacion. Inicio Llamada a Platea");
			if (Y41bUtils.interactuarConDokusi()) {
				respuestaEjgv = this.y41bPlateaAdapterService.crearEJGVDocumentComunicacion(crearNotifEJGV);
			} else {
				// en odei
				Arbtramexp3ServiceImpl.logger.info(
						"ArbtramexpServiceImpl - createEJGVDocumentComunicacion: 8/8. en odei no mandamos a platea");
				respuestaEjgv = new RespuestaCrearEJGVDocumentNotificacion();
				respuestaEjgv.setTextoPlano("Notificacion en local");
				respuestaEjgv.setEjgvDocument("EGJV. Notificacion en local");
			}
			Arbtramexp3ServiceImpl.logger
					.info("ArbtramexpServiceImpl. - createEJGVDocumentComunicacion. Fin Llamada a Platea");

		} catch (Y41bUDAException e) {
			e.printStackTrace();
			Arbtramexp3ServiceImpl.logger.info("Error producido en createEJGVDocumentComunicacion: " + e.getMessage(),
					e);
			Arbtramexp3ServiceImpl.logger.error("Error producido en createEJGVDocumentComunicacion: " + e.getMessage(),
					e);
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			Arbtramexp3ServiceImpl.logger.info("Error producido en createEJGVDocumentComunicacion: " + e.getMessage(),
					e);
			Arbtramexp3ServiceImpl.logger.error("Error producido en createEJGVDocumentComunicacion: " + e.getMessage(),
					e);
			throw e;
		} finally {
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {
					// obtener los datos del documento
					Arbdoctemp documentoHecho = new Arbdoctemp();

					documentoHecho.setX5codocumento(adjuntardocsAux.getThcodocumento());

				}
			}
		}
		return respuestaEjgv;
	}

	/**
	 * Metodo que procesa el envio de una comunicacin electronica
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramitehecho
	 *            TramiteHecho
	 * @throws Exception
	 */
	private void procesarComunicacionElectronica(List<Arbdoctemp> listDocumentoHecho,
			TramiteComunicacion tramiteComunicacion, Arbtramexp tramitehecho, CensoMonitor censoMonitor)
			throws Exception {
		if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		String textoNotificacionComunicacion = tramiteComunicacion.getTextoComunicacion();
		String destinatario = tramiteComunicacion.getDestinatario();
		String envRemesa = tramiteComunicacion.getEnvRemesaComunicacion();

		CrearNotifEJGV crearNotifEJGV = this.crearObjetoCrearNotifEJGV(tramitehecho.getSolarb().getSacodigo(),
				tramitehecho.getTrid(), Y41bConstantes.NOTIFICACION_COMUNICACION, textoNotificacionComunicacion,
				destinatario, envRemesa, listDocumentoHecho, censoMonitor);

		RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService.procesarEnviarNotificacionX43(crearNotifEJGV);

		// EnvioNotifEJGV envioNotifEJGV = new EnvioNotifEJGV();
		// envioNotifEJGV.setEjgvDocument(tramiteComunicacion.getEjgvDocument());
		//
		// // ******************* Anadimos FIRMA SERVIDOR ********************
		// // ****************************************************************
		// // envioNotifEJGV.setFirma(tramiteComunicacion.getFirma());
		//
		// Properties prop =
		// Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// NSHFServiceImpl nshf = new NSHFServiceImpl();
		// EjgvDocumentType EjgvDocumentFirma = nshf.createAdESSignature(
		// prop.getProperty("CERTIFICADO_SERVIDOR"),
		// tramiteComunicacion.getEjgvDocument(),
		// Y41bConstantes.TIPO_FIRMA_ENVELOPED);
		// envioNotifEJGV.setFirma(EjgvDocumentFirma.getEjgvDocument().getBody()
		// .getSign());
		//
		// RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService
		// .procesarEnviarNotificacion(envioNotifEJGV);

		// update tramite campo idnotificacionplatea
		tramitehecho.setTridnotifplatea(respuestaNotif.getNumeroRegistro());
		this.arbtramexpDao.updateIdNotificacionPlatea(tramitehecho);

		// recuperar segistro salida de notificacion y actualizar tabla
		// tramite hecho con el registro de salida y su fecha de registro
		TNotification tNotification = this.y41bPlateaAdapterService
				.getJustificanteNotificacion(respuestaNotif.getNumeroRegistro());

		tramitehecho.setTrnumregs(tNotification.getRegistryID().getRegistryNumber());
		tramitehecho.setTrfecregs(Y41bUtils.parseRegistrytimestamp(tNotification.getRegistryID().getRegistryDate()));

		// RegistroSalida registroSalida = y41bPlateaAdapterService
		// .getRegistroSalidaFromIdNotificacion(respuestaNotif
		// .getNumeroRegistro());
		// tramitehecho.setTrnumregs(registroSalida.getRegistryNumber());
		// tramitehecho.setTrfecregs(Y41bUtils
		// .parseNotificationRegistrytimestamp(registroSalida
		// .getRegistryTimestamp()));
		this.arbtramexpDao.updateRegistroSalidaPlatea(tramitehecho);
	}

	/**
	 * Metodo que crea el objeto CrearNotifEJGV para envio de
	 * notificacin/comunicacin electrnica
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param idTipoNotificacion
	 *            String
	 * @param textoNotificacionComunicacion
	 *            String
	 * @param destinatario
	 *            String
	 * @param envRemesa
	 *            String
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CrearNotifEJGV
	 * @throws Exception
	 */
	private CrearNotifEJGV crearObjetoCrearNotifEJGV(String idExpediente, String idTramite, String idTipoNotificacion,
			String textoNotificacionComunicacion, String destinatario, String envRemesa,
			List<Arbdoctemp> listDocumentoHecho, CensoMonitor censoMonitor) throws Exception {

		CrearNotifEJGV crearNotifEJGV = new CrearNotifEJGV();
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
		crearNotifEJGV.setProcedure(procedure);

		crearNotifEJGV.setTextoNotificacion(textoNotificacionComunicacion);

		crearNotifEJGV.setEjercicio(Y41bUtils.fncObtenerAnnoSistema());
		crearNotifEJGV.setIdiomaNotificacion(Y41bConstantes.CASTELLANO);

		// buscar el interviniente
		Arbinterv interviniente = new Arbinterv();
		interviniente.setUaidinterv(new BigDecimal(destinatario));
		interviniente = this.arbintervdao.find(interviniente);

		DatosPersona datosPersonaSolicitante = new DatosPersona();
		datosPersonaSolicitante.setDni(interviniente.getUanif().trim().toUpperCase());

		datosPersonaSolicitante.setNombre(interviniente.getUanombre() == null ? ""
				: interviniente.getUanombre().concat(" ")
						.concat(interviniente.getUaapellido1() == null ? "" : interviniente.getUaapellido1())
						.concat(" ")
						.concat(interviniente.getUaapellido2() == null ? "" : interviniente.getUaapellido2()));

		if (Y41bUtils.isFilled(interviniente.getUaapellido1())) {
			datosPersonaSolicitante.setApellido1(interviniente.getUaapellido1());
		}
		datosPersonaSolicitante.setMail(interviniente.getUacoem());

		// 0173496: Mail de aviso en notificaciones/comunicaciones Platea
		if (Y41bUtils.isFilled(interviniente.getUaescodigo())) {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(interviniente.getUaescodigo());
			establecimiento = this.establecimientoService.find(establecimiento);

			AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();
			adjunDatosAvisosEstablec.setYiescif(establecimiento.getEsnif());
			adjunDatosAvisosEstablec.setYipcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			adjunDatosAvisosEstablec = this.adjunDatosAvisosEstablecDao.findByCifProc(adjunDatosAvisosEstablec);

			if (adjunDatosAvisosEstablec != null && Y41bUtils.isFilled(adjunDatosAvisosEstablec.getYiemail())) {
				datosPersonaSolicitante.setMail(adjunDatosAvisosEstablec.getYiemail());
			} else if (establecimiento != null && Y41bUtils.isFilled(establecimiento.getEsmailnotificacion())) {
				datosPersonaSolicitante.setMail(establecimiento.getEsmailnotificacion());
			}
		}
		// 0173496: Mail de aviso en notificaciones/comunicaciones Platea

		datosPersonaSolicitante.setTelefono(interviniente.getUanrtel());

		crearNotifEJGV.setSolicitante(datosPersonaSolicitante);

		DatosPersona datosPersonaSender = new DatosPersona();
		datosPersonaSender.setDni(censoMonitor.getOrganismo().getCodOrg());
		datosPersonaSender.setNombre(censoMonitor.getOrganismo().getNombreEs());

		crearNotifEJGV.setSender(datosPersonaSender);

		// Obtener el numero de expediente
		Solarb solarb = new Solarb();
		solarb.setSacodigo(idExpediente);

		solarb = this.solarbDao.find(solarb);

		StringBuffer numeroExpediente = new StringBuffer();

		numeroExpediente.append(solarb.damecodCompletoPlatea());

		crearNotifEJGV.setNumeroExpediente(numeroExpediente.toString());

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// Indicar la serie documental que corresponde al expediente
		crearNotifEJGV.setSerieDocumental(prop.getProperty(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE + ".serie."
				+ Y41bDokusiHelper.getProvSerieFromNumExp(numeroExpediente.toString())));

		// El tipo de notificacion para PLATEA
		// En la JSP va "REQ_ACREDITA" para distinguirlo de otros
		// requerimientos
		// Antes de enviar a Platea tenemos que tratarlo
		if (Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_REQUERIMIENTO_ACREDITACION.equals(idTipoNotificacion)) {
			crearNotifEJGV.setIdTipoNotificacion(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_REQUERIMIENTO);
		} else {
			crearNotifEJGV.setIdTipoNotificacion(idTipoNotificacion);
		}

		List<Documento> listDocumentos = this.registrarDocumentosDokusi(listDocumentoHecho, null);

		crearNotifEJGV.setDocumentosAdjuntos(listDocumentos);

		if (null != crearNotifEJGV.getDocumentosAdjuntos() && crearNotifEJGV.getDocumentosAdjuntos().size() > 0) {

			for (Documento documentoAux : crearNotifEJGV.getDocumentosAdjuntos()) {
				if (!com.ejie.y41b.utils.Y41bUtils.isDocumentoLocalizable(documentoAux)) {
					if (envRemesa != null && Y41bConstantes.SI.equals(envRemesa)) {
						if (documentoAux != null && documentoAux.getNombre() != null && !com.ejie.y41b.utils.Y41bUtils
								.getExtensionFile(documentoAux.getNombre()).equalsIgnoreCase(Y41bConstantes.PDF)) {
							throw new Y41bUDAException("error.documentos.remesapdf", true, new Exception());
						}
					}
				}
			}
		}

		return crearNotifEJGV;
	}

	/**
	 * Metodo que procesa el envio de una notificacin electronica
	 * 
	 * @param listDocumentoHecho
	 *            List<Arbdoctemp>
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramitehecho
	 *            Arbtramexp
	 * @throws Exception
	 */
	private void procesarNotificacionElectronica(List<Arbdoctemp> listDocumentoHecho,
			TramiteNotificacion tramiteNotificacion, Arbtramexp tramitehecho, TramiteComun tramiteComun,
			CensoMonitor censoMonitor) throws Exception {

		// 2. Se genera el tramite de acuse de recibo vinculado al tramite de
		// notificacion
		String idEspera = this.solarbDao.getNewEsperaPK() + "";
		Arbtramexp tramiteAcuse = this.generarTramiteAcuseReciboAutomatico(idEspera, tramitehecho, tramiteComun);

		// 3. Enviamos telematicamente la solicitud
		String textoNotificacionComunicacion = tramiteNotificacion.getTextoComunicacion();
		String destinatario = tramiteNotificacion.getDestinatario();
		String envRemesa = tramiteNotificacion.getEnvRemesaNotificacion();

		CrearNotifEJGV crearNotifEJGV = this.crearObjetoCrearNotifEJGV(tramitehecho.getSolarb().getSacodigo(),
				tramitehecho.getTrid(), tramiteNotificacion.getTipoNotificacionPlatea(), textoNotificacionComunicacion,
				destinatario, envRemesa, listDocumentoHecho, censoMonitor);

		RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService.procesarEnviarNotificacionX43(crearNotifEJGV);

		// EnvioNotifEJGV envioNotifEJGV = new EnvioNotifEJGV();
		// envioNotifEJGV.setEjgvDocument(tramiteNotificacion.getEjgvDocument());
		//
		// // ******************* Anadimos FIRMA SERVIDOR ********************
		// // ****************************************************************
		// // envioNotifEJGV.setFirma(tramiteNotificacion.getFirma());
		//
		// Properties prop =
		// Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		// NSHFServiceImpl nshf = new NSHFServiceImpl();
		// EjgvDocumentType EjgvDocumentFirma = nshf.createAdESSignature(
		// prop.getProperty("CERTIFICADO_SERVIDOR"),
		// tramiteNotificacion.getEjgvDocument(),
		// Y41bConstantes.TIPO_FIRMA_ENVELOPED);
		// envioNotifEJGV.setFirma(EjgvDocumentFirma.getEjgvDocument().getBody()
		// .getSign());
		//
		// RespuestaNotificacion respuestaNotif = y41bPlateaAdapterService
		// .procesarEnviarNotificacion(envioNotifEJGV);

		// 4.1 Update tramite notificacion (campo idnotificacionplatea)
		tramitehecho.setTridnotifplatea(respuestaNotif.getNumeroRegistro());
		this.arbtramexpDao.updateIdNotificacionPlatea(tramitehecho);

		// 4.2 Recuperar segistro salida de notificacion y actualizar tabla
		// tramite hecho con el registro de salida y su fecha de registro
		TNotification tNotification = this.y41bPlateaAdapterService
				.getJustificanteNotificacion(respuestaNotif.getNumeroRegistro());

		tramitehecho.setTrnumregs(tNotification.getRegistryID().getRegistryNumber());
		tramitehecho.setTrfecregs(Y41bUtils.parseRegistrytimestamp(tNotification.getRegistryID().getRegistryDate()));

		// RegistroSalida registroSalida = y41bPlateaAdapterService
		// .getRegistroSalidaFromIdNotificacion(respuestaNotif
		// .getNumeroRegistro());
		// tramitehecho.setTrnumregs(registroSalida.getRegistryNumber());
		// tramitehecho.setTrfecregs(Y41bUtils
		// .parseNotificationRegistrytimestamp(registroSalida
		// .getRegistryTimestamp()));
		this.arbtramexpDao.updateRegistroSalidaPlatea(tramitehecho);
		// 4.3 Add notificacion / acuse recibo (tabla)
		NotificacionAcuseRecibo notificacionAcuseRecibo = new NotificacionAcuseRecibo();
		notificacionAcuseRecibo.setEhidnotificacionplatea(respuestaNotif.getNumeroRegistro());
		notificacionAcuseRecibo.setEhcodigoacuse(tramiteAcuse.getTrid());
		notificacionAcuseRecibo.setEhpcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
		this.arbtramexpDao.addNotificacionAcuseRecibo(notificacionAcuseRecibo);
	}

	/**
	 * Metodo que procesa el envio de una comunicacin o notificacion ordinaria
	 * 
	 * @param listadjuntardocs
	 *            List<Adjuntardocs>
	 * @param listDocumentoHecho
	 *            List<Arbdoctemp>
	 * @param tramitehecho
	 *            Arbtramexp
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idZipFile
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	private void procesarComunicacionNotificacionOrdinaria(List<Adjuntardocs> listadjuntardocs,
			List<Arbdoctemp> listDocumentoHecho, Arbtramexp tramitehecho, TramiteComun tramiteComun, String idZipFile)
			throws Exception {
		// Validacion: Debe haber almenos 1 documento
		if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
			for (Adjuntardocs adjuntardocsAux : listadjuntardocs) {
				PlantillaTramite plantillaTramite = null;
				if (adjuntardocsAux != null && adjuntardocsAux.getPtcodigo() != null
						&& !adjuntardocsAux.getPtcodigo().equals("")) {
					plantillaTramite = new PlantillaTramite();
					plantillaTramite.setPtcodigo(adjuntardocsAux.getPtcodigo());
					// Obtener la plantilla del tramite
					plantillaTramite = this.plantillaTramiteDao.find(plantillaTramite);
				}

				if (Y41bUtils.isDocumentoLocalizable(adjuntardocsAux)) {
					if ((tramitehecho.getTrenvrem() == null || Y41bConstantes.NO.equals(tramitehecho.getTrenvrem()))
							&& (plantillaTramite != null && plantillaTramite.getNolocalizable() != null
									&& plantillaTramite.getNolocalizable().equals(Y41bConstantes.VALOR_SI))) {

					} else {
						if (!StringUtils.isBlank(adjuntardocsAux.getThiddocumentum())) {
							Documento documento = new Documento();
							// 1.User
							User user = new User();
							user.setNombre(Y41bConstantes.COD_APLICACION);
							user.setDni(Y41bConstantes.COD_APLICACION);
							documento.setUser(user);
							Procedure procedure = new Procedure();
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
							documento.setProcedure(procedure);
							documento.setOidDokusi(adjuntardocsAux.getThiddocumentum());
							Formato formato = y41bDokusiAdapterService.recuperarFormatosDocumentosDokusi(documento);

							if (formato != null && formato.getName().equals(Y41bConstantes.PDFA)) {
								if (adjuntardocsAux != null && adjuntardocsAux.getThnofile() != null
										&& !com.ejie.y41b.utils.Y41bUtils
												.getExtensionFile(adjuntardocsAux.getThnofile())
												.equalsIgnoreCase(Y41bConstantes.PDF)) {
									throw new Y41bUDAException("error.documentos.sinlocalizador", true,
											new Exception());
								}
							} else {
								throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
							}
						} else {
							throw new Y41bUDAException("error.documentos.sinlocalizador", true, new Exception());
						}
					}
				} else {
					if (tramitehecho.getTrenvrem() != null && Y41bConstantes.SI.equals(tramitehecho.getTrenvrem())) {
						if (adjuntardocsAux != null && adjuntardocsAux.getThnofile() != null
								&& !com.ejie.y41b.utils.Y41bUtils.getExtensionFile(adjuntardocsAux.getThnofile())
										.equalsIgnoreCase(Y41bConstantes.PDF)) {
							throw new Y41bUDAException("error.documentos.remesapdf", true, new Exception());
						}
					}
				}
			}
		}

		if (tramitehecho.getTrenvrem() != null && Y41bConstantes.SI.equals(tramitehecho.getTrenvrem())) {
			if (listadjuntardocs != null && listadjuntardocs.size() > 0) {
				this.controlDocumentosProtegidosRemesa(listadjuntardocs);
			}
		}

		if (tramitehecho.getTrenvrem() == null || Y41bConstantes.NO.equals(tramitehecho.getTrenvrem())) {
			this.crearZipDocumentosExpediente(idZipFile, listadjuntardocs, tramiteComun);
		}

		// Subimos los documentos a dokusi
		this.registrarDocumentosDokusi(listDocumentoHecho, tramiteComun);

	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los registra en
	 * DOKUSI, previamente comprueba si se ha localizado y si no se ha
	 * localizado se elimina de DOKUSI y se vuelve a registrar en DOKUSI
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @throws Exception
	 *             Exception
	 */
	private void guardarDocumentosDokusiTramiteComunicacionNotificacion(List<Arbdoctemp> listDocumentoHechoAux,
			TramiteComun tramiteComun) throws Exception {
		Parametros parametros = new Parametros();

		parametros.setParametro(Y41bConstantes.CONTROL_LOCALIZACION_DOCUMENTOS);
		parametros = this.parametrosDao.find(parametros);

		Arbdoctemp documentoHecho = null;
		for (int i = 0; i < listDocumentoHechoAux.size(); i++) {
			documentoHecho = listDocumentoHechoAux.get(i);
			if (documentoHecho.getX5fechasollocalizador() != null) {
				if (documentoHecho != null && documentoHecho.getX5nofile() != null && !com.ejie.y41b.utils.Y41bUtils
						.getExtensionFile(documentoHecho.getX5nofile()).equalsIgnoreCase(Y41bConstantes.PDF)) {

					int minutos = 0;
					if (parametros != null && parametros.getValor() != null
							&& Y41bUtils.isNumeric(parametros.getValor())) {
						minutos = Integer.parseInt(parametros.getValor());
					}

					SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

					Date d1 = null;
					Date d2 = null;
					long diffMinutes = 0;
					try {
						d1 = format.parse(format.format(documentoHecho.getX5fechasollocalizador()));

						d2 = format.parse(format.format(new Date()));

						long diff = d2.getTime() - d1.getTime();

						diffMinutes = diff / (Y41bConstantes.NUM_60 * Y41bConstantes.NUM_1000);
					} catch (ParseException e) {
						diffMinutes = 0;
					}

					if (diffMinutes > minutos) {
						Documento documento = new Documento();
						// 1.User
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
						documento.setProcedure(procedure);
						documento.setOidDokusi(documentoHecho.getX5iddocumentum());
						documento.setBoolAllVersions("true");

						try {
							this.y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
						} catch (Exception e) {
						}

						documentoHecho.setX5fechasollocalizador(null);
						documentoHecho.setX5iddocumentum(null);
					}
				}
			}
		}
		// Subimos los documentos a dokusi
		this.registrarDocumentosDokusi(listDocumentoHechoAux, tramiteComun);
	}

	/**
	 * 
	 * @param reclamanteArb
	 * @param solarb
	 * @param tramiteComun
	 * @param censoMonitor
	 * @param reclamadoArb
	 * @return
	 * @throws Exception
	 */
	public SolicitudPresencial abrirSolicitudPresencialPlatea(Arbinterv reclamanteArb, Solarb solarb,
			TramiteComun tramiteComun, CensoMonitor censoMonitor, Arbinterv reclamadoArb) throws Exception {

		Arbtramexp3ServiceImpl.logger.debug("INICIO abrirSolicitudPresencialPlatea");

		// Abrir el expediente presencial
		SolicitudPresencial solicitudPresencial = new SolicitudPresencial();

		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(solarb.getSacodigo());
		arbexp = this.arbexpDao.find(arbexp);
		solicitudPresencial.setIdParticipacion(arbexp.getExidparticipacionreclamante());

		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);

		solicitudPresencial.setProcedure(procedure);

		DatosPersona datosPersona = new DatosPersona();
		datosPersona.setDni(reclamanteArb.getUanif().trim().toUpperCase());
		datosPersona.setNombre(StringEscapeUtils.escapeHtml(reclamanteArb.getUanombre()));
		if (Y41bUtils.isFilled(reclamanteArb.getUaapellido1())) {
			datosPersona.setApellido1(StringEscapeUtils.escapeHtml(reclamanteArb.getUaapellido1()));
		}
		datosPersona.setMail(reclamanteArb.getUacoem());

		if (Y41bUtils.isFilled(reclamanteArb.getUanrtel())) {
			datosPersona.setTelefono(reclamanteArb.getUanrtel());
		}

		// el idioma del reclamante ser el que escoja en la solicitud. Luego se
		// podr cambiar.
		datosPersona.setIdioma(Y41bUtils.idiomaTwoChar(reclamanteArb.getUaidioma()));
		// es sancionado pero nos referimos al reclamante en arbitraje -
		// reutilizacin de cdigo.
		solicitudPresencial.setSolicitante(datosPersona);

		// datos de un interesado

		/*
		 * El interesado no se manda a Platea en la asignacin del Responsable;
		 * se hace ms tarde, cuando se le enva la primera
		 * comunicacion/notificacion
		 * 
		 * DatosPersona datosInteresado = new DatosPersona();
		 * datosInteresado.setDni(reclamadoArb.getUanif());
		 * datosInteresado.setNombre(StringEscapeUtils.escapeHtml(reclamadoArb
		 * .getUanombre())); if
		 * (Y41bUtils.isFilled(reclamadoArb.getUaapellido1())) {
		 * datosInteresado.setApellido1(StringEscapeUtils
		 * .escapeHtml(reclamadoArb.getUaapellido1())); }
		 * datosInteresado.setMail(reclamadoArb.getUacoem());
		 * 
		 * if (Y41bUtils.isFilled(reclamadoArb.getUanrtel())) {
		 * datosInteresado.setTelefono(reclamadoArb.getUanrtel()); }
		 * 
		 * datosInteresado.setIdioma(Y41bUtils.idiomaTwoChar(reclamadoArb
		 * .getUaidioma())); // es sancionado pero nos referimos al reclamante
		 * en arbitraje - // reutilizacin de cdigo.
		 * solicitudPresencial.setInteresado(datosInteresado);
		 * ------------------
		 * ----------------------------------------------------
		 * ------------------
		 * -----------------------------------------------------
		 */

		// DatosPersona datosPersonaSender = new DatosPersona();
		// // CensoMonitor censoMonitorSender = new CensoMonitor();
		// // censoMonitorSender.setMocodigo(s.getSanexp().getExmocodigo());
		// // censoMonitorSender = censoMonitorDao.find(censoMonitorSender);
		// datosPersonaSender.setDni(censoMonitor.getModni());
		// datosPersonaSender.setNombre(censoMonitor.getMonombre());
		// solicitudPresencial.setSender(datosPersonaSender);

		String numeroExpediente = solarb.damecodCompletoPlatea();
		solicitudPresencial.setNumeroExpediente(numeroExpediente.toString());

		DatosRegistro datosRegistro = new DatosRegistro();
		datosRegistro.setRegistryNumber(solarb.getArbexp().getExregen());
		datosRegistro.setRegistryTimestamp(Y41bUtils.formatearDateToString(solarb.getArbexp().getExfecreg(),
				Y41bConstantes.FORMATO_FECHAHORALARGA_ES));

		solicitudPresencial.setDatosRegistro(datosRegistro);

		solicitudPresencial.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		// el idioma est ligado de momento a la solicitud.
		if (Y41bUtils.isFilled(solarb.getArbexp().getExidisol())) {
			solicitudPresencial.setIdiomaNotificacion(solarb.getArbexp().getExidisol().toLowerCase());
		}

		// buscamos los documentos de la apertura
		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_APERTURA);
		try {
			arbtramexp = this.arbtramexpDao.findUltimoTramiteExpedientePorTipoTramite(arbtramexp);
		} catch (Exception e) {
		}

		tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(arbtramexp.getTrid());
		tramiteComun.setIdExpediente(solarb.getSacodigo());
		List<Arbdoctemp> listDocumentosApertura = this.arbdoctempDao.findAllDocumentosTramiteApertura(tramiteComun,
				null);

		if (listDocumentosApertura != null && listDocumentosApertura.size() > 0) {

			// 1.User
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);

			Documento documento = null;
			List<Documento> listDocumentos = new ArrayList<Documento>();

			for (Arbdoctemp documentoApertura : listDocumentosApertura) {
				if (Y41bUtils.esNullOCadenaVacia(documentoApertura.getX5iddocumentum())) {
					Arbtramexp3ServiceImpl.logger.debug("Es un documento aportado en la solicitud presencial");
					documento = new Documento();

					documento.setUser(user);

					// 2.Tipo Documental
					documento.setTipoDocumental(Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO);

					documento.setIdDocumento(documentoApertura.getX5codocumento().toString());
					documento.setNombre(Y41bUtils.getNameFile(documentoApertura.getX5nofile()));
					documento.setExtension(Y41bUtils.getExtensionFile(documentoApertura.getX5nofile()));
					documento.setDescripcion(documentoApertura.getX5tedesfile());

					Arbdoctemp documentoAperturaAux = this.arbdoctempService.find(documentoApertura);

					Blob contenido = documentoAperturaAux.getX5datafile();
					byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

					documento.setBytes(Y41bUtilsDokusi.encode(bContenido));

					documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
					documento.setProcedure(procedure);

					documento.setRegistryNumber(solarb.getArbexp().getExregen());
					documento.setRegistryTimestamp(Y41bUtils.formatearDateToString(solarb.getArbexp().getExfecreg(),
							Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
					documento.setEntradaSalida(Y41bConstantes.DOCUMENTO_ENTRADA);

					listDocumentos.add(documento);
				} else {
					Arbtramexp3ServiceImpl.logger.debug("Es un documento de la solicitud previa");
					documento = new Documento();

					documento.setUser(user);

					// 2.Tipo Documental
					documento.setTipoDocumental(Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO);

					documento.setIdDocumento(documentoApertura.getX5codocumento().toString());
					documento.setNombre(Y41bUtils.getNameFile(documentoApertura.getX5nofile()));
					documento.setExtension(Y41bUtils.getExtensionFile(documentoApertura.getX5nofile()));
					documento.setDescripcion(documentoApertura.getX5tedesfile());

					// 0184482: Error outofmemory en solicitudes de arbitraje
					// telematicas por documentos grandes en reclamacion

					documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
					documento.setProcedure(procedure);

					documento.setRegistryNumber(solarb.getArbexp().getExregen());
					documento.setRegistryTimestamp(Y41bUtils.formatearDateToString(solarb.getArbexp().getExfecreg(),
							Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
					documento.setEntradaSalida(Y41bConstantes.DOCUMENTO_ENTRADA);
					documento.setNumeroExpediente(numeroExpediente);

					Documento documentoAux = new Documento();
					documentoAux.setUser(user);
					documentoAux.setProcedure(procedure);
					documentoAux.setOidDokusi(documentoApertura.getX5iddocumentum());
					// Recuperar datos del documento de dokusi
					if (!Y41bUtils.esNullOCadenaVacia(documentoAux.getOidDokusi())) {
						Documento docDokusi = y41bDokusiAdapterService
								.descargarDocumentoDokusiSinDocumento(documentoAux);
						if (docDokusi != null && !this.isDocumentoArbitraje(docDokusi)) {
							Arbtramexp3ServiceImpl.logger.debug("No es un documento de arbitraje");
							// this.arbdoctempDao.insertArbDocTramite(arbtramexp.getTrid(),
							// documentoApertura.getX5codocumento(),
							// Y41bConstantes.TIPO_PROC_ARBITRAJE,
							// Y41bConstantes.TIPO_PROC_SOLICITUDES);
							/*
							 * // copiar. Es un documento recuperado del
							 * expediente // relacionado
							 * documento.setOidDokusi(documentoApertura.
							 * getX5iddocumentum()); // Hacemos uso del origen
							 * del documento que se esta // copiando
							 * documento.setOrigenDocumento(docDokusi.
							 * getOrigenDocumento()); // Se crea un nuevo
							 * documento en BD con el mismo OID //
							 * shareDocumentContents no permitia transformar //
							 * documentos por estar compartidos // Van a existir
							 * dos documentos en la tabla con el // mismo oid
							 * documento.setOidDokusi(docDokusi.getOidDokusi());
							 * 
							 * // Actualizo OID Dokusi en tabla documentos //
							 * intermedia Adjuntardocs adjuntardocsAuxUpdateOID
							 * = new Adjuntardocs();
							 * 
							 * adjuntardocsAuxUpdateOID.setThcodocumento(
							 * documento.getIdDocumento());
							 * adjuntardocsAuxUpdateOID.setThiddocumentum(
							 * documento.getOidDokusi());
							 * this.adjuntardocsDao.updateOIDDokusi(
							 * adjuntardocsAuxUpdateOID);
							 * 
							 * Arbdoctemp arbdoctemp = new Arbdoctemp();
							 * arbdoctemp.setX5iddocumentum(documento.
							 * getOidDokusi());
							 * arbdoctemp.setX5codocumento(documento.
							 * getIdDocumento());
							 * 
							 * // Actualizo OID Dokusi en tabla documentos hecho
							 * // Update oid de documentum
							 * this.arbdoctempDao.updateOIDDokusi(arbdoctemp);
							 */
						} else {
							// no copiar. Es un documento entregado con la
							// solicitud
							documento.setOidDokusi(documentoApertura.getX5iddocumentum());
							Arbtramexp3ServiceImpl.logger.debug("OID original (no copia)",
									documentoApertura.getX5iddocumentum());
							listDocumentos.add(documento);
						}
						// listDocumentos.add(documento);
					}
				}
			}
			solicitudPresencial.setDocumentosAdjuntos(listDocumentos);
		}
		logger.info("ExpedienteServiceImpl. - Add. Inicio Llamada a Platea");
		if (Y41bUtils.interactuarConDokusi()) {
			this.y41bPlateaAdapterService.crearSolicitudPresencial(solicitudPresencial);
		}

		logger.info("ExpedienteServiceImpl. - Add. Fin Llamada a Platea");

		Arbtramexp3ServiceImpl.logger.debug("FIN abrirSolicitudPresencialPlatea");

		return solicitudPresencial;

	}

	/**
	 * 
	 * @param solarb
	 * @param tramiteComun
	 * @param reclamente
	 * @param reclamado
	 * @return
	 * @throws Exception
	 */
	public SolicitudTelematica abrirSolicitudTelematicaPlatea(Solarb solarb, TramiteComun tramiteComun,
			Arbinterv reclamente, Arbinterv reclamado) throws Exception {
		SolicitudTelematica solicitudTelematica = new SolicitudTelematica();

		// DATOS PROCEDIMIENTO/EXPEDIENTE INICIO
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
		solicitudTelematica.setProcedure(procedure);
		String numeroExpediente = solarb.damecodCompletoPlatea();
		solicitudTelematica.setNumeroExpediente(numeroExpediente.toString());

		solicitudTelematica.setTipoNotificacion(Y41bConstantes.ELECTRONICO);

		DatosRegistro datosRegistro = new DatosRegistro();
		datosRegistro.setRegistryNumber(solarb.getArbexp().getExregen());
		datosRegistro.setRegistryTimestamp(Y41bUtils.formatearDateToString(solarb.getArbexp().getExfecreg(),
				Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
		solicitudTelematica.setDatosRegistro(datosRegistro);

		// el idioma de notificacin vamos a darle prioridad a la de
		// la solicitud.
		if (Y41bUtils.isFilled(solarb.getArbexp().getExidisol())) {
			solicitudTelematica.setIdiomaNotificacion(solarb.getArbexp().getExidisol().toLowerCase());
		} else {
			solicitudTelematica.setIdiomaNotificacion("");
		}

		// DATOS PROCEDIMIENTO/EXPEDIENTE FIN
		// TERCEROS SOLICITUD INICIO
		DatosPersona solicitante = new DatosPersona();
		solicitante.setDni(reclamente.getUanif());
		solicitante.setNombre(reclamente.getUanombre());
		if (Y41bUtils.isFilled(reclamente.getUaapellido1())) {
			solicitante.setApellido1(new StringBuffer(reclamente.getUaapellido1()).toString());

			if (Y41bUtils.isFilled(reclamente.getUaapellido2())) {
				solicitante.setApellido1(new StringBuffer(reclamente.getUaapellido1()).append(" ")
						.append(reclamente.getUaapellido2()).toString());
			}
		}
		if (Y41bUtils.esNullOCadenaVacia(reclamente.getUacoem())) {
			solicitante.setMail(reclamente.getUacoem());
		}
		if (Y41bUtils.esNullOCadenaVacia(reclamente.getUanrtel())) {
			solicitante.setTelefono(reclamente.getUanrtel());
		}
		solicitudTelematica.setSolicitante(solicitante);

		// No se informa a Platea del reclamado hasta la primera not/com
		// DatosPersona interesado = new DatosPersona();
		// interesado.setDni(reclamado.getUanif().trim().toUpperCase());
		// interesado.setNombre(reclamado.getUanombre());
		// if (Y41bUtils.isFilled(reclamado.getUanrtel())) {
		// interesado.setTelefono(reclamado.getUanrtel());
		// }
		// if (Y41bUtils.isFilled(reclamado.getUacoem())) {
		// interesado.setMail(reclamado.getUacoem());
		// }
		// interesado.setIdioma(Y41bUtils.idiomaTwoChar(reclamado
		// .getUaidioma()));
		//
		// solicitudTelematica.setInteresado(interesado);

		// DATOS AVISO FIN
		// DOCUMENTOS INICIO
		Arbtramexp arbtramexp = new Arbtramexp();
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_APERTURA);
		try {
			arbtramexp = this.arbtramexpDao.findUltimoTramiteExpedientePorTipoTramite(arbtramexp);
		} catch (Exception e) {
		}

		tramiteComun = new TramiteComun();
		tramiteComun.setIdTramite(arbtramexp.getTrid());
		tramiteComun.setIdExpediente(solarb.getSacodigo());
		List<Arbdoctemp> listDocumentosApertura = this.arbdoctempDao.findAllDocumentosTramiteApertura(tramiteComun,
				null);
		Arbtramexp3ServiceImpl.logger.info("Num. documentos apertura: " + listDocumentosApertura.size());
		if (listDocumentosApertura != null && listDocumentosApertura.size() > 0) {

			// 1.User
			User user = new User();
			user.setNombre(Y41bConstantes.COD_APLICACION);
			user.setDni(Y41bConstantes.COD_APLICACION);

			Documento documento;
			List<Documento> listDocumentos = new ArrayList<Documento>();
			for (Arbdoctemp documentoApertura : listDocumentosApertura) {
				Arbtramexp3ServiceImpl.logger.debug("Documento Apertura", documentoApertura.toString());
				documento = new Documento();

				documento.setUser(user);

				// 2.Tipo Documental
				documento.setTipoDocumental(Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO);

				documento.setIdDocumento(documentoApertura.getX5codocumento().toString());
				documento.setNombre(Y41bUtils.getNameFile(documentoApertura.getX5nofile()));
				documento.setDescripcion(documentoApertura.getX5tedesfile());
				documento.setExtension(Y41bUtils.getExtensionFile(documentoApertura.getX5nofile()));

				// 0184482: Error outofmemory en solicitudes de arbitraje
				// telematicas por documentos grandes en reclamacion

				documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
				documento.setProcedure(procedure);

				documento.setRegistryNumber(solarb.getArbexp().getExregen());
				documento.setRegistryTimestamp(Y41bUtils.formatearDateToString(solarb.getArbexp().getExfecreg(),
						Y41bConstantes.FORMATO_FECHAHORALARGA_ES));
				documento.setEntradaSalida(Y41bConstantes.DOCUMENTO_ENTRADA);
				documento.setNumeroExpediente(numeroExpediente);

				Documento documentoAux = new Documento();
				documentoAux.setUser(user);
				documentoAux.setProcedure(procedure);
				documentoAux.setOidDokusi(documentoApertura.getX5iddocumentum());
				// Recuperar datos del documento de dokusi
				if (!Y41bUtils.esNullOCadenaVacia(documentoAux.getOidDokusi())) {
					Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusiSinDocumento(documentoAux);
					if (docDokusi != null && !this.isDocumentoArbitraje(docDokusi)) {
						Arbtramexp3ServiceImpl.logger.debug("No es un documento de arbitraje");
						// this.arbdoctempDao.insertArbDocTramite(arbtramexp.getTrid(),
						// documentoApertura.getX5codocumento(),
						// Y41bConstantes.TIPO_PROC_ARBITRAJE,
						// Y41bConstantes.TIPO_PROC_SOLICITUDES);
						/*
						 * // copiar. Es un documento recuperado del expediente
						 * // relacionado
						 * documento.setOidDokusi(documentoApertura.
						 * getX5iddocumentum()); // Hacemos uso del origen del
						 * documento que se esta // copiando
						 * documento.setOrigenDocumento(docDokusi.
						 * getOrigenDocumento()); // Se crea un nuevo documento
						 * en BD con el mismo OID // shareDocumentContents no
						 * permitia transformar // documentos por estar
						 * compartidos // Van a existir dos documentos en la
						 * tabla con el // mismo oid
						 * documento.setOidDokusi(docDokusi.getOidDokusi());
						 * 
						 * // Actualizo OID Dokusi en tabla documentos
						 * intermedia Adjuntardocs adjuntardocsAuxUpdateOID =
						 * new Adjuntardocs();
						 * 
						 * adjuntardocsAuxUpdateOID.setThcodocumento(documento.
						 * getIdDocumento());
						 * adjuntardocsAuxUpdateOID.setThiddocumentum(documento.
						 * getOidDokusi());
						 * this.adjuntardocsDao.updateOIDDokusi(
						 * adjuntardocsAuxUpdateOID);
						 * 
						 * Arbdoctemp arbdoctemp = new Arbdoctemp();
						 * arbdoctemp.setX5iddocumentum(documento.getOidDokusi()
						 * );
						 * arbdoctemp.setX5codocumento(documento.getIdDocumento(
						 * ));
						 * 
						 * // Actualizo OID Dokusi en tabla documentos hecho //
						 * Update oid de documentum
						 * this.arbdoctempDao.updateOIDDokusi(arbdoctemp);
						 */
					} else {
						// no copiar. Es un documento entregado con la solicitud
						documento.setOidDokusi(documentoApertura.getX5iddocumentum());
						Arbtramexp3ServiceImpl.logger.debug("OID original (no copia)",
								documentoApertura.getX5iddocumentum());
						listDocumentos.add(documento);
					}
					// listDocumentos.add(documento);
				}
			}
			solicitudTelematica.setDocumentosAdjuntos(listDocumentos);
			Arbtramexp3ServiceImpl.logger
					.info("Num. documentos que se mandan a la solicitud telematica: " + listDocumentos.size());
		}
		// DOCUMENTOS FIN

		y41bPlateaAdapterService.crearSolicitudTelematica(solicitudTelematica);

		// Registar el estado de adhesion del establecimiento
		this.arbexpService.actualizarEstAdhEstablecimiento(solicitudTelematica.getIdExpediente());

		return solicitudTelematica;
	}

	/**
	 * isDocumentoArbitraje
	 * 
	 * @param documento
	 *            Documento
	 * @return boolean
	 */
	private boolean isDocumentoArbitraje(Documento documento) {
		Arbtramexp3ServiceImpl.logger.debug("isDocumentoArbitraje - INICIO ");
		boolean resultado = false;
		if (documento != null && documento.getMetadatos() != null && documento.getMetadatos().size() > 0) {
			for (Metadato metadato : documento.getMetadatos()) {
				if (Y41bConstantes.METADATO_PROCEDIMIENTO_INFRAESTRUCTURA.equalsIgnoreCase(metadato.getNombre())) {
					Arbtramexp3ServiceImpl.logger.debug("PROCEDIMIENTO: " + metadato.getValor());
					resultado = Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE.equalsIgnoreCase(metadato.getValor());
					break;
				}
			}

		}
		Arbtramexp3ServiceImpl.logger.debug("isDocumentoArbitraje - RESULTADO: " + resultado);
		Arbtramexp3ServiceImpl.logger.debug("isDocumentoArbitraje - FIN ");
		return resultado;
	}

	/**
	 * Devuelve el tamao de la remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(NotificacionesComunicacionesBusqueda filterNotifiComuni) {

		return this.arbtramexpDao.findSumSizeBlobNotifiComuni(filterNotifiComuni);
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            censoMonitor
	 * @return tramite
	 */
	public TramiteARBComunicaArbitros findTramiteComunicaArbitros(TramiteARBComunicaArbitros tramite,
			CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			String trid = new String(tramite.getIdTramite());
			arbtramexp.setTrid(trid);
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBComunicaArbitros tramiteAux = new TramiteARBComunicaArbitros();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());
			// tramiteAux.setFechaRecepcion(arbtramexp.getTrfecrecepcion());
			// tramiteAux.setValoracion(arbtramexp.getTrvalorac());
			// tramiteAux.setTipo(arbtramexp.getTrtiposolac());
			// tramiteAux.setNotComReclamado(arbtramexp.getTrnotcomreclamado());
			// tramiteAux.setNotComReclamante(arbtramexp.getTrnotcomreclamante());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));
			// tramiteAux.setResumen(Y41bUtils.clobToString(arbtramexp
			// .getTrresumen()));

			if (this.arbtramexp2Service.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			Arbtramexp3ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBComunicaArbitros
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteComunicaArbitros(TramiteARBComunicaArbitros tramite, TramiteComun tramiteComun,
			String idioma, boolean tramitar, String modoARBComunicaArbitros) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.arbtramexp2Service.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(),
				tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		solarb.setArbexp(this.arbexpDao.find(solarb.getArbexp()));

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_INICIO_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());

		// arbtramexp.setTrmonitor(tramite.getMonitor());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		// arbtramexp.setTrsiguientestramites(Y41bUtils.stringToClob(tramite
		// .getSiguientestramites()));

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.arbtramexp2Service.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbtramexp2Service.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.arbtramexp2Service.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);

				this.arbtramexp2Service.actualizaBandeja(arbtramexp);
				this.arbtramexp2Service.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);

				// enviarComunicaciones a todos los arbitros
				// esto por cada uno de los arbitros?
				// envioEmailComunicacion(tramiteComunicacion, tramiteComun,
				// listadjuntardocs, censoMonitor);
				this.arbtramexpService.sugiereTramiteComunicacionArbitros(arbtramexp, solarb);

			}

		} else {
			this.arbtramexp2Service.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.arbtramexp2Service.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}
}
