package com.ejie.y41b.service;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.TramiteARBComunicaArbitros;
import com.ejie.y41b.model.TramiteAcuseRecibo;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteComunicacion;
import com.ejie.y41b.model.TramiteNotificacion;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.platea.RegistroSalida;
import com.ejie.y41b.model.platea.RespuestaCrearEJGVDocumentNotificacion;
import com.ejie.y41b.model.platea.SolicitudPresencial;
import com.ejie.y41b.model.platea.SolicitudTelematica;

/**
 * ArbtramexpService  
 * 
 *  
 */

public interface Arbtramexp3Service {

	/**
	 * 
	 * @param tramiteNotificacion
	 *            tramiteNotificacion
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoEditar
	 *            modoEditar
	 * @param esNotificacionTipoElectronica
	 *            esNotificacionTipoElectronica
	 * @param idZipFile
	 *            idZipFile
	 * @param CensoMonitor
	 *            censoMonitor
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteNotificacion(TramiteNotificacion tramiteNotificacion,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoEditar, boolean esNotificacionTipoElectronica,
			String idZipFile, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param tipoProcedimiento
	 *            String
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentNotificacion(
			TramiteNotificacion tramiteNotificacion, TramiteComun tramiteComun,
			CensoMonitor censoMonitor, String tipoProcedimiento)
			throws Exception;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteNotificacion
	 *            TramiteNotificacion
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteNotificacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	TramiteNotificacion findTramiteNotificacion(
			TramiteNotificacion tramiteNotificacion, CensoMonitor monitor)
			throws SQLException, IOException;

	/**
	 * Guardar el tramite acuse de recibo
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param reintento
	 *            boolean
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAcuseRecibo
	 * @throws Exception
	 *             Exception
	 * 
	 */
	public TramiteAcuseRecibo addTramiteAcuseRecibo(
			TramiteAcuseRecibo tramiteAcuseRecibo, TramiteComun tramiteComun,
			String idioma, boolean tramitar, boolean reintento,
			CensoMonitor censoMonitor) throws Exception;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteAcuseRecibo
	 *            TramiteAcuseRecibo
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteAcuseRecibo
	 * @throws IOException
	 *             IOException
	 * @throws SQLException
	 *             SQLException
	 */
	public TramiteAcuseRecibo findTramiteAcuseRecibo(
			TramiteAcuseRecibo tramiteAcuseRecibo, CensoMonitor monitor)
			throws SQLException, IOException;

	/**
	 * Metodo que recibe una lista de documentos del tramite y los registra en
	 * DOKUSI
	 * 
	 * @param listDocumentosTramite
	 *            List<Arbdoctemp>
	 * @param tramiteComun
	 *            TramiteComun
	 * @return List<Documento>
	 * @throws SQLException
	 *             SQLException
	 * @throws Exception
	 *             excepcion
	 */
	public List<Documento> registrarDocumentosDokusi(
			List<Arbdoctemp> listDocumentosTramite, TramiteComun tramiteComun)
			throws SQLException, Exception;

	/**
	 * Finds a List of rows in the Remesa table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifComuni,
			Pagination pagination);

	/**
	 * Counts rows in the Remesa table.
	 * 
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findAllNotifiComuniCount(
			NotificacionesComunicacionesBusqueda filterNotifComuni);

	/**
	 * Busca los documentos de notificacion o comunicacion que componen la
	 * remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return List
	 * @throws Exception
	 *             excepcion
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifiComuni)
			throws Exception;

	/**
	 * getRegistroSalida
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idInterviniente
	 *            String
	 * @param b
	 *            boolean
	 * @return RegistroSalida
	 * @throws Exception
	 *             excepcion
	 */
	RegistroSalida getRegistroSalida(TramiteComun tramiteComun,
			String idInterviniente, boolean b) throws Exception;

	/**
	 * updateRegistroSalidaPlatea
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp updateRegistroSalidaPlatea(Arbtramexp arbtramexp);

	/**
	 * @param arbtramexp
	 *            Arbtramexp
	 */
	void crearAvisoNotifiComuniRegistroSalida(Arbtramexp arbtramexp);

	/**
	 * actualizarTramiteDeAcuseReciboDesdeRemesa
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param remesaEmitida
	 *            Remesa
	 * @param envio
	 *            NotificacionesComunicacionesBusqueda
	 * @param fechaSituacion
	 *            String
	 * @param situacionCorreos
	 *            String
	 * @param envcestado
	 *            String
	 * @param documentoZipByte
	 *            byte[]
	 * @param filename
	 *            String
	 */
	void actualizarTramiteDeAcuseReciboDesdeRemesa(CensoMonitor censoMonitor,
			Remesa remesaEmitida, NotificacionesComunicacionesBusqueda envio,
			String fechaSituacion, String situacionCorreos, String envcestado,
			byte[] documentoZipByte, String filename);

	/**
	 * addTramiteComunicacion
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param b
	 *            boolean
	 * @param modoComunicacion
	 *            String
	 * @param c
	 *            boolean
	 * @param d
	 *            boolean
	 * @param string
	 *            String
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return Arbtramexp Arbtramexp
	 * @throws Exception
	 *             excepcion
	 */
	Arbtramexp addTramiteComunicacion(TramiteComunicacion tramiteComunicacion,
			TramiteComun tramiteComun, String idioma, boolean b,
			String modoComunicacion, boolean c, boolean d, String string,
			CensoMonitor censoMonitor) throws Exception;

	/**
	 * Tramitar tramite comunicacion.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param modoEditar
	 *            the modo editar
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteHecho
	 * @throws Exception
	 *             Exception
	 */
	public Arbtramexp addTramiteComunicacionMail(
			TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			String modoEditar, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteComunicacion
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	TramiteComunicacion findTramiteComunicacion(
			TramiteComunicacion tramiteComunicacion, CensoMonitor monitor)
			throws SQLException, IOException;

	/**
	 * @param tramiteComunicacion
	 *            TramiteComunicacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param pcodigo
	 *            String
	 * @return RespuestaCrearEJGVDocumentNotificacion
	 * @throws Exception
	 *             Exception
	 */
	RespuestaCrearEJGVDocumentNotificacion createEJGVDocumentComunicacion(
			TramiteComunicacion tramiteComunicacion, TramiteComun tramiteComun,
			CensoMonitor censoMonitor, String pcodigo) throws Exception;

	/**
	 * 
	 * @param arbtramexpNotificacion
	 *            Arbtramexp
	 * @param fechaAcuse
	 *            Date
	 * @throws Exception
	 *             Exception
	 */
	void tratarAcuseRecogido(Arbtramexp arbtramexpNotificacion, Date fechaAcuse)
			throws Exception;

	/**
	 * Actualizar el expediente.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return boolean
	 * @throws Exception
	 *             Exception
	 */
	boolean tratarTramitacionAcuse(Arbtramexp arbtramexp,
			CensoMonitor censoMonitor) throws Exception;

	/**
	 * 
	 * @param arbtramexpTramite
	 *            Arbtramexp
	 * @param solarb
	 *            Solarb
	 * @param fechaAcuse
	 *            Date
	 */
	void crearAviso(Arbtramexp arbtramexpTramite, Solarb solarb, Date fechaAcuse);

	/**
	 * abrirSolicitudTelematicaPlatea
	 * 
	 * @param solarb
	 *            Solarb
	 * @param tramiteComun
	 *            TramiteComun
	 * @param reclamente
	 *            Arbinterv
	 * @param reclamado
	 *            Arbinterv
	 * @return SolicitudTelematica
	 * @throws Exception
	 *             excepcion
	 */
	SolicitudTelematica abrirSolicitudTelematicaPlatea(Solarb solarb,
			TramiteComun tramiteComun, Arbinterv reclamente, Arbinterv reclamado)
			throws Exception;

	/**
	 * abrirSolicitudPresencialPlatea
	 * 
	 * @param reclamanteArb
	 *            Arbinterv
	 * @param solarb
	 *            Solarb
	 * @param tramiteComun
	 *            TramiteComun
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param reclamadoArb
	 *            Arbinterv
	 * @return SolicitudPresencial
	 * @throws Exception
	 *             excepcion
	 */
	SolicitudPresencial abrirSolicitudPresencialPlatea(Arbinterv reclamanteArb,
			Solarb solarb, TramiteComun tramiteComun,
			CensoMonitor censoMonitor, Arbinterv reclamadoArb) throws Exception;

	/**
	 * Devuelve el tamao de la remesa
	 * 
	 * @param filterNotifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifiComuni);

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return tramite
	 */
	TramiteARBComunicaArbitros findTramiteComunicaArbitros(
			TramiteARBComunicaArbitros tramite, CensoMonitor censoMonitor);

	/**
	 * @param tramite
	 *            TramiteARBComunicaArbitros
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoARBComunicaArbitros
	 *            String
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteComunicaArbitros(TramiteARBComunicaArbitros tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar,
			String modoARBComunicaArbitros) throws Exception;
}
