// CHECKSTYLE:OFF
package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.adapter.services.N61ServiceImpl;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.ArbbandejaDao;
import com.ejie.y41b.dao.ArbcolegioDao;
import com.ejie.y41b.dao.ArbdoctempDao;
import com.ejie.y41b.dao.ArbexpDao;
import com.ejie.y41b.dao.ArbintervDao;
import com.ejie.y41b.dao.ArbtipdocDao;
import com.ejie.y41b.dao.ArbtramexpDao;
import com.ejie.y41b.dao.BandejaFirmaDao;
import com.ejie.y41b.dao.BandejaFirmaArbitrajeDao;
import com.ejie.y41b.dao.CensoMonitorDao;
import com.ejie.y41b.dao.DecisionDao;
import com.ejie.y41b.dao.DocumentoHechoDao;
import com.ejie.y41b.dao.DocumentosFirmaArbitrosDao;
import com.ejie.y41b.dao.DocumentosFirmaArbitrosTempDao;
import com.ejie.y41b.dao.EmpperDao;
import com.ejie.y41b.dao.HistoricofasesDao;
import com.ejie.y41b.dao.LaudosAdoptadoDao;
import com.ejie.y41b.dao.LaudosTipoDao;
import com.ejie.y41b.dao.OrganismoDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.PosibleTramiteDao;
import com.ejie.y41b.dao.SolarbDao;
import com.ejie.y41b.dao.T17CalleDao;
import com.ejie.y41b.dao.T17MunicipioDao;
import com.ejie.y41b.dao.T17PortalDao;
import com.ejie.y41b.dao.T17ProvinciaDao;
import com.ejie.y41b.dao.TclugaudDao;
import com.ejie.y41b.dao.TramiteDao;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

import javax.annotation.Resource;
import javax.sql.rowset.serial.SerialBlob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbcolegio;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.AsientoRegistral;
import com.ejie.y41b.model.AsientoRegistralDetalle;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.BandejaFirmaArbitraje;
import com.ejie.y41b.model.BandejaFirmaBusqueda;
import com.ejie.y41b.model.Decision;
import com.ejie.y41b.model.DocumentoAsientoRegistral;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.DocumentoTramiteHecho;
import com.ejie.y41b.model.DocumentosFirmaArbitros;
import com.ejie.y41b.model.DocumentosFirmaArbitrosTemp;
import com.ejie.y41b.model.Empper;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.Historicofases;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.LaudosAdoptado;
import com.ejie.y41b.model.LaudosTipo;
import com.ejie.y41b.model.T17Calle;
import com.ejie.y41b.model.T17Municipio;
import com.ejie.y41b.model.T17Portal;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.model.Tclugaud;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.PosibleTramite;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Santramexp;
import com.ejie.y41b.model.Arbbandeja;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteARBMediacion;
import com.ejie.y41b.model.TramiteARBRecepcionSolicitudAclaracion;
import com.ejie.y41b.model.TramiteARBRecepcionSolicitudCopiaExpe;
import com.ejie.y41b.model.TramiteAdjuntarDocs;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.TramiteARBApertura;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.TramiteRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.model.platea.RegistroEntrada;
import com.ejie.y41b.n61.ArrayOfWSParamPerson;
import com.ejie.y41b.n61.WSInputRegister;
import com.ejie.y41b.n61.WSParamInputRegisterEx;
import com.ejie.y41b.n61.WSParamPerson;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.ws.Y41bUtilsWS;

/**
 * Arbtramexp2ServiceImpl  
 * 
 *  
 */

@Service(value = "arbtramexp2Service")
public class Arbtramexp2ServiceImpl implements Arbtramexp2Service {

	private static final Logger logger = LoggerFactory.getLogger(Arbtramexp2ServiceImpl.class);

	@Autowired()
	private ArbtramexpDao arbtramexpDao;
	@Autowired()
	private CensoMonitorDao censoMonitorDao;
	@Autowired()
	private SolarbDao solarbDao;
	@Autowired()
	private TramiteDao tramiteDao;
	@Autowired()
	private ArbexpDao arbexpDao;
	@Autowired()
	private ArbintervDao arbintervDao;
	@Autowired()
	private ArbtipdocService arbtipdocService;
	@Autowired()
	private ArbdoctempDao arbdoctempDao;
	@Autowired()
	private AdjuntardocsDao adjuntardocsDao;
	@Autowired()
	private PosibleTramiteDao posibleTramiteDao;
	@Autowired()
	private ArbbandejaDao arbBandejaDao;
	@Autowired()
	private BandejaFirmaDao bandejaFirmaDao;
	@Autowired
	private EmpperDao empperDao;
	@Autowired
	private DecisionDao decisionDao;
	@Autowired
	private LaudosAdoptadoDao laudosAdoptadoDao;
	@Autowired
	private LaudosTipoDao laudosTipoDao;
	@Autowired()
	private T17CalleDao t17CalleDao;
	@Autowired()
	private T17PortalDao t17PortalDao;
	@Autowired()
	private T17MunicipioDao t17MunicipioDao;
	@Autowired()
	private T17ProvinciaDao t17ProvinciaDao;
	@Autowired()
	private T17PortalService t17PortalService;
	@Autowired()
	private TclugaudDao tclugaudDao;
	@Autowired()
	private ParametrosDao parametrosDao;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;
	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired()
	private ArbtipdocDao arbtipdocDao;
	@Autowired()
	private Arbtramexp3Service arbtramexp3Service;
	@Autowired()
	private Arbtramexp4Service arbtramexp4Service;
	@Autowired()
	private HistoricofasesDao historicoFasesDao;
	@Autowired()
	private ArbcolegioDao arbcolegioDao;
	@Autowired()
	private ArbdoctempService arbdoctempService;
	@Autowired()
	private OrganismoDao organismoDao;
	@Autowired()
	private DocumentoHechoDao documentoHechoDao;
	@Autowired()
	private ArbintervService arbintervService;

	@Autowired()
	private BandejaFirmaArbitrajeDao bandejaFirmaArbitrajeDao;

	@Autowired()
	private DocumentosFirmaArbitrosDao documentosFirmaArbitrosDao;

	@Autowired()
	private DocumentosFirmaArbitrosTempDao documentosFirmaArbitrosTempDao;

	@Autowired()
	private DocumentosFirmaArbitrosTempService documentosFirmaArbitrosTempService;

	@Autowired()
	private DocumentosFirmaArbitrosService documentosFirmaArbitrosService;

	@Autowired
	private AsientoRegistralService asientoRegistralService;

	@Autowired
	private DocumentosAsientoRegistralService documentosAsientoRegistralService;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Inserts a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp add(Arbtramexp arbtramexp) {
		return this.arbtramexpDao.add(arbtramexp);
	}

	/**
	 * Updates a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp update(Arbtramexp arbtramexp) {
		return this.arbtramexpDao.update(arbtramexp);
	}

	/**
	 * Metodo que devuelve S si tiene permiso de modificacion, N si no tiene
	 * permiso de modificacion.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param censoMonitor
	 *            censoMonitor CensoMonitor
	 * @return boolean
	 */
	public boolean tratamientoSeguridad(Arbtramexp arbtramexp, CensoMonitor censoMonitor) {
		// obtener la solicitud

		Arbtramexp2ServiceImpl.logger.info("ARBITRAJE.tratamientoSeguridad. INICIO ." + arbtramexp.getTrid() + ".");

		if (censoMonitor == null || censoMonitor.getPerfilArbitraje() == null
				|| censoMonitor.getPerfilArbitraje().getIdPerfil() == null) {
			return false;
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(arbtramexp.getSolarb().getSacodigo());

		solarb = this.solarbDao.find(solarb);

		// Si el expediente esta cerrado
		if (solarb.getSafear() != null) {
			return false;
		}

		Tramite tramite = new Tramite();
		tramite.setTrcodigo(arbtramexp.getTrcodigo());
		tramite = this.tramiteDao.find(tramite);

		// comprobar si el organismo propietario del expediente es igual al
		// organismo del usuario conectado
		Arbtramexp2ServiceImpl.logger.info("ARBITRAJE.tratamientoSeguridad. PERFIL USUARIO CONECTADO:"
				+ censoMonitor.getPerfilArbitraje().getIdPerfil() + ".");
		Arbtramexp2ServiceImpl.logger
				.info("ARBITRAJE.tratamientoSeguridad. TIPO DE TRAMITE:" + arbtramexp.getTrcodigo() + ".");
		if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_CONSULTAS)) {
			return false;
		}
		if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return false;
		}
		if (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return false;

		}
		// Si tiene marca BOPV puede tramitar
		if (tramite.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_PUBLICACION_BOPVBOE)) {
			if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
				return true;
			}
		}

		// Si tiene marca Pago Laudo puede tramitar
		// Si no tiene marca Pago Laudo puede tramitar en caso de ser Supervisor
		if (tramite.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO)) {
			return (Y41bConstantes.SI.equals(censoMonitor.getMopagolaudo())
					|| Y41bConstantes.PERFIL_SUPERVISOR.equals(censoMonitor.getPerfilArbitraje().getIdPerfil()));
		}

		// Solo hay una oficina
		Arbtramexp2ServiceImpl.logger
				.info("ARBITRAJE.tratamientoSeguridad. expediente.getExcoor():" + solarb.getSacoja() + ".");

		// Los instructores solo pueden modificar sus tramites
		Arbexp arbexp = new Arbexp();
		arbexp.setExcodigo(solarb.getSacodigo());
		arbexp = this.arbexpDao.dameDetallesExpediente(arbexp);

		String responsable = arbexp.getExmocodigo();

		if (tramite != null && tramite.getIdPerfil() != null) {
			Arbtramexp2ServiceImpl.logger
					.info("ARBITRAJE.tratamientoSeguridad. ID PERFIL DEL TRAMITE:" + tramite.getIdPerfil() + ".");
			if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)
					&& (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_ADMINISTRATIVO)
							|| (censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
									&& responsable != null && responsable.equals(censoMonitor.getMocodigo()))
							|| censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
							|| censoMonitor.getPerfilArbitraje().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_SUPERVISOR))) {
				Arbtramexp2ServiceImpl.logger.info("ARBITRAJE.tratamientoSeguridad.123.RETURN TRUE");
				return true;
			} else if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
					&& ((censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)
							&& responsable != null && responsable.equals(censoMonitor.getMocodigo()))
							|| censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
							|| censoMonitor.getPerfilArbitraje().getIdPerfil()
									.equals(Y41bConstantes.PERFIL_SUPERVISOR))) {
				Arbtramexp2ServiceImpl.logger.info("ARBITRAJE.tratamientoSeguridad.124.RETURN TRUE");
				return true;
			} else if (tramite.getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR) && (censoMonitor
					.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_COORDINADOR)
					|| censoMonitor.getPerfilArbitraje().getIdPerfil().equals(Y41bConstantes.PERFIL_SUPERVISOR))) {
				Arbtramexp2ServiceImpl.logger.info("ARBITRAJE.tratamientoSeguridad.125.RETURN TRUE");
				return true;
			} else {
				Arbtramexp2ServiceImpl.logger.info("ARBITRAJE.tratamientoSeguridad. RETURN FALSE1.");
				return false;
			}
		} else {
			Arbtramexp2ServiceImpl.logger.info("ARBITRAJE.tratamientoSeguridad. RETURN FALSE2.");
			return false;
		}

	}

	/**
	 * 
	 * @param excodigo
	 *            String
	 * @param tipoDeTramite
	 *            String
	 */
	public void actualizaFaseArbexpDesdeTramite(String excodigo, String tipoDeTramite) {

		String expediente = excodigo;
		String tipoTramite = tipoDeTramite;
		Fase faseActualExpediente = new Fase();
		Fase fase = null;
		if (Y41bConstantes.TRAMITE_ARBITRAJE_APERTURA.equals(tipoTramite)) {
			fase = new Fase(Y41bConstantes.FASE_REGISTRO_ARBITRAJE);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ASIGNACION_RESPONSABLE.equals(tipoTramite)) {
			fase = new Fase(Y41bConstantes.FASE_INICIO_ARBITRAJE);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ANALISIS_EMPRESA.equals(tipoTramite)) {
			fase = new Fase(Y41bConstantes.FASE_ANALISIS_ARBITRAJE);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL.equals(tipoTramite)) {
			fase = new Fase(Y41bConstantes.FASE_CONVENIO_ARBITRAJE);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO.equals(tipoTramite)) {
			fase = new Fase(Y41bConstantes.FASE_COLEGIO_ARBITRAJE);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA.equals(tipoTramite)) {
			fase = new Fase(Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(tipoTramite)) {
			fase = new Fase(Y41bConstantes.FASE_RESOLUCION);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE.equals(tipoTramite)
				|| Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_COPIA_EXPE.equals(tipoTramite)
				|| Y41bConstantes.TRAMITE_ARBITRAJE_PROPUESTA_SANCIONADOR.equals(tipoTramite)) {
			fase = new Fase(Y41bConstantes.FASE_CIERRE_ARBITRAJE);
		}
		if (fase != null) {

			/* actualizamos arbexp */
			Arbexp arbexp = new Arbexp();
			arbexp.setExcodigo(expediente);
			arbexp = this.arbexpDao.find(arbexp);

			faseActualExpediente = arbexp.getFase();

			if ((faseActualExpediente == null || faseActualExpediente.getFcodigo() == null)
					|| (faseActualExpediente.getFcodigo() != null
							&& !faseActualExpediente.getFcodigo().equals(fase.getFcodigo()))) {
				arbexp.setFase(fase);
				this.arbexpDao.update(arbexp);

				/* actualizo la salida de la fase, cojo la última */
				Historicofases historicoFases = new Historicofases();
				historicoFases.setHfsacodigo(excodigo);
				List<Historicofases> historicoFasesLista = this.historicoFasesDao
						.findAllFasesHistoricoAbiertas(historicoFases);
				if (historicoFasesLista != null) {
					if (historicoFasesLista.size() > 0) {
						Historicofases entradaACerrar = historicoFasesLista.get(0);
						entradaACerrar.setHfffin(new Date());
						this.historicoFasesDao.updateFechaFin(entradaACerrar);
					}
				}
				/* doy de alta la entrada en la nueva fase */
				historicoFases = new Historicofases();
				historicoFases.setHffcodigo(fase.getFcodigo());
				historicoFases.setHfsacodigo(excodigo);
				historicoFases.setHffinicio(new Date());
				this.historicoFasesDao.add(historicoFases);

			}
		}
	}

	/**
	 * Updates a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	public Arbtramexp setArbtramexp(Arbtramexp arbtramexp) {

		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(arbtramexp.getTrestado())) {

			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(arbtramexp.getTrid().toString());
			adjuntardocs.setTrpcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			List<Adjuntardocs> listAdjuntardocs = this.adjuntardocsDao.findAll(adjuntardocs, null);

			boolean denegado = false;

			if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
				for (int i = 0; i < listAdjuntardocs.size(); i++) {
					if (listAdjuntardocs.get(i).getThestadodocumento() != null && listAdjuntardocs.get(i)
							.getThestadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA)) {
						denegado = true;
						break;
					}
				}
			}

			if (denegado) {
				arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA);
			} else {
				boolean todosFirmados = true;
				if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
					for (int i = 0; i < listAdjuntardocs.size(); i++) {
						if (listAdjuntardocs.get(i).getThestadodocumento() != null && !listAdjuntardocs.get(i)
								.getThestadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO)) {
							todosFirmados = false;
							break;
						}
					}
				}
				if (todosFirmados) {
					boolean firmado = false;
					if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
						for (int i = 0; i < listAdjuntardocs.size(); i++) {
							if (listAdjuntardocs.get(i).getThestadodocumento() != null) {
								firmado = true;
								break;
							}
						}
					}

					if (firmado) {
						arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
					} else {
						arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					}

				} else {
					boolean pendienteFirma = false;
					if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
						for (int i = 0; i < listAdjuntardocs.size(); i++) {
							if (listAdjuntardocs.get(i).getThestadodocumento() != null) {
								pendienteFirma = true;
								break;
							}
						}
					}

					if (pendienteFirma) {
						arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
					} else {
						arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					}
				}
			}
		}
		if (this.arbtramexpDao.exists(arbtramexp)) {
			Arbtramexp arbtramexpBD = this.arbtramexpDao.find(arbtramexp);
			if (arbtramexpBD != null && arbtramexpBD.getFase() != null && arbtramexpBD.getFase().getFcodigo() != null
					&& !arbtramexpBD.getFase().getFcodigo().equals("")) {
				// Tramite con fase
				arbtramexp.setFase(arbtramexpBD.getFase());
			} else {
				arbtramexpBD = this.arbtramexpDao.findUltimoTramiteConFase(arbtramexp);
				if (arbtramexpBD != null) {
					arbtramexp.setFase(arbtramexpBD.getFase());
				}
			}
			return this.arbtramexpDao.update(arbtramexp);
		} else {
			Tramite tramite = new Tramite(arbtramexp.getTrcodigo());
			tramite = this.tramiteDao.find(tramite);
			if (tramite != null && tramite.getFase() != null && tramite.getFase().getFcodigo() != null
					&& !"".equals(tramite.getFase().getFcodigo())) {
				// Si se crea el tramite en un expediente cerrado correo al
				// responsable del expediente
				this.enviarMailInstructorAportacionCerrado(arbtramexp);
				return this.arbtramexpDao.add(arbtramexp);
			} else {
				Arbtramexp arbtramexpBD = this.arbtramexpDao.findUltimoTramiteConFase(arbtramexp);
				if (arbtramexpBD != null) {
					arbtramexp.setFase(arbtramexpBD.getFase());
				}
				// Si se crea el tramite en un expediente cerrado correo al
				// responsable del expediente
				this.enviarMailInstructorAportacionCerrado(arbtramexp);
				return this.arbtramexpDao.add(arbtramexp);
			}
		}
	}

	private void enviarMailInstructorAportacionCerrado(Arbtramexp arbtramexp) {
		if (!(arbtramexp.getSolarb() != null && arbtramexp.getSolarb().getSacodigo() != null)) {
			// salimos sin enviar correo - no hay codigo de expediente
			Arbtramexp2ServiceImpl.logger
					.info("enviarMailInstructorAportacionCerrado - Correo no enviado - no hay codigo de expediente");
			return;
		}
		if (!Y41bConstantes.TRAMITE_ARBITRAJE_APORTACIONDOCUMENTACION.equals(arbtramexp.getTrcodigo())) {
			// salimos sin enviar correo - no es una aportacion
			Arbtramexp2ServiceImpl.logger
					.info("enviarMailInstructorAportacionCerrado - Correo no enviado - no es una aportacion");
			return;
		}
		Solarb solarb = new Solarb(arbtramexp.getSolarb().getSacodigo());
		solarb = this.solarbDao.find(solarb);
		Arbexp arbexp = new Arbexp(solarb.getSacodigo());
		arbexp = this.arbexpDao.find(arbexp);
		if (arbexp.getExfecfin() == null) {
			// salimos sin enviar correo - no es un expediente cerrado
			Arbtramexp2ServiceImpl.logger
					.info("enviarMailInstructorAportacionCerrado - Correo no enviado - no es un expediente cerrado");
			return;
		}
		// obtener instructor
		CensoMonitor instructor = new CensoMonitor();
		instructor.setMocodigo(arbexp.getExmocodigo());
		instructor = this.censoMonitorDao.find(instructor);
		if (!(instructor != null && !Y41bUtils.esNullOCadenaVacia(instructor.getMocoem()))) {
			// salimos sin enviar correo - el instructor no existe o no tiene
			// mail
			Arbtramexp2ServiceImpl.logger.info(
					"enviarMailInstructorAportacionCerrado - Correo no enviado - el instructor no existe o no tiene mail");
			return;
		}
		// obtener servidor smtp
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		String smtpMail = (String) prop.getProperty("y41bVistaWar.mail.ejie.smtp");
		// 0. From
		String from = "";
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.PARAMETRO_GENERAL_FROMGENERICO);
		parametros = this.parametrosDao.find(parametros);
		if (parametros == null
				|| (parametros != null && (parametros.getValor() == null || parametros.getValor().equals("")))) {
			// salimos sin enviar correo - no esta definido el from en
			// parametros
			Arbtramexp2ServiceImpl.logger.info(
					"enviarMailInstructorAportacionCerrado - Correo no enviado - no esta definido el from en parametros");
			return;
		}
		from = parametros.getValor();
		// 1. Destinatario
		String destinatario = instructor.getMocoem();
		// 2. Creo el asunto
		// Obtener el numero de expediente
		StringBuilder numeroExpediente = new StringBuilder();
		numeroExpediente.append(solarb.damecodCompletoPlatea());
		StringBuilder asunto = new StringBuilder();
		// Castellano
		asunto.append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.asunto", null,
				new Locale(Y41bConstantes.CASTELLANO)));
		asunto.append(" ").append(numeroExpediente).append(" / ");
		// Euskera
		asunto.append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.asunto", null,
				new Locale(Y41bConstantes.EUSKERA)));
		asunto.append(" ").append(numeroExpediente);
		// 3. Creo el contenido del mail
		StringBuilder texto = new StringBuilder();
		String[] params = new String[1];
		params[0] = numeroExpediente.toString();
		texto.append("<B>").append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.texto", params,
				new Locale(Y41bConstantes.CASTELLANO)));
		texto.append(" / ").append(this.appMessageSource.getMessage("aportacionExpedienteCerrado.mail.texto", params,
				new Locale(Y41bConstantes.EUSKERA))).append("</B><BR>");
		boolean enviadoOK = Y41bUtils.sendMail(smtpMail, asunto.toString(), texto.toString(), from, destinatario, "",
				null);
		if (!enviadoOK) {
			Arbtramexp2ServiceImpl.logger
					.trace("enviarMailInstructorAportacionCerrado - Correo no enviado - sendMail resultado false");
		}
	}

	/**
	 * Finds a single row in the ArbTramExp table.
	 * 
	 * @param tramite
	 *            tramite TramiteARBApertura
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteARBApertura
	 */
	public TramiteARBApertura findTramiteApertura(TramiteARBApertura tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			String trid = tramite.getIdTramite();
			arbtramexp.setTrid(trid);
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBApertura tramiteAux = new TramiteARBApertura();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			Arbtramexp2ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}

	}

	/**
	 * Inserts a single row in the Arbtramexp table.
	 * 
	 * @param tramite
	 *            tramite TramiteGenerico
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteApertura(TramiteARBApertura tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar, List<Documento> listDocumento) throws Exception {

		Arbtramexp arbtramexp = new Arbtramexp();

		this.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		solarb.setArbexp(this.arbexpDao.find(solarb.getArbexp()));

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_REGISTRO_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbdoctempDao.findAllDocumentosEliminados(tramiteComun, null);

		// Tratamiento especifico para la apertura
		this.arbdoctempDao.removeArbDocTramite(tramiteComun);
		// INICIO Codigo sustituido
		// this.arbdoctempDao.removeDocumentosHechoAdjuntarDocs(tramiteComun);
		// FIN Codigo sustituido
		// INICIO Se sustituye por
		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5tramite(tramiteComun.getIdTramite());
		documentoHecho.setQ5hdcodigo(tramiteComun.getIdExpediente());
		List<DocumentoHecho> listDocumentoHecho2 = this.documentoHechoDao.findAll(documentoHecho, null);

		for (DocumentoHecho documentoHechoAux : listDocumentoHecho2) {
			try {
				this.documentoHechoDao.remove(documentoHechoAux);
			} catch (DataIntegrityViolationException dataIntegrityViolationException) {
				throw new Y41bUDAException("error.solicitud.documentoAdjuntadoException", true, new Exception());
			}
		}
		// FIN Se sustituye por
		// Si se crea desde SIR no se cogen los documentos de la tabla de
		// adjuntardocs
		// if (!(null != tramite.getIsSIR() && "" != tramite.getIsSIR())) {
		this.arbdoctempDao.addDocumentosHechoAdjuntarDocsApertura(tramiteComun);
		// }
		this.adjuntardocsDao.removeAdjuntarDocsTramite(tramiteComun);

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (isDocPendienteFirma) {
				this.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
				this.sugiereTramiteAutomaticamente(arbtramexp, Y41bConstantes.TRAMITE_ARBITRAJE_ASIGNACION_RESPONSABLE,
						Y41bConstantes.FASE_INICIO_ARBITRAJE, false);

				this.actualizaBandeja(arbtramexp);
				this.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}
		} else {
			this.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.eliminarDocumentosDokusi(listArbdoctempEliminados);

		if (!Y41bConstantes.VALOR_SI.equals(solarb.getArbexp().getPlatea()) && tramitar) {
			Arbinterv reclamanteArb = this.arbintervDao.dameInterviniente(solarb.getSacodigo(),
					Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
			if (reclamanteArb.getUanif() == null || reclamanteArb.getUanif() == "") {
				throw new Y41bUDAException("error.tramiteAsignResp.nonifreclamante", true, new Exception());
			}
			Arbinterv reclamadoArb = this.arbintervDao.dameInterviniente(solarb.getSacodigo(),
					Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
			if (reclamadoArb.getUanif() == null || reclamadoArb.getUanif() == "") {
				throw new Y41bUDAException("error.tramiteAsignResp.nonifreclamado", true, new Exception());
			}
			if (Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB.equals(solarb.getArbexp().getExformapres())) {
				if (listDocumento != null && listDocumento.size() > 0) {
					// tenemos que descargar los bytes de cada documento de la
					// solicitud
					// telematica e insertarlos
					// en la tabla de documentos.

					Arbdoctemp arbdoctemp;
					for (Documento documentoAux : listDocumento) {

						if (!Y41bUtils.esNullOCadenaVacia(documentoAux.getOidDokusi())) {
							Documento documento = new Documento();
							User user = new User();
							user.setNombre(Y41bConstantes.COD_APLICACION);
							user.setDni(Y41bConstantes.COD_APLICACION);
							documento.setUser(user);
							Procedure procedure = new Procedure();
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
							documento.setProcedure(procedure);
							documento.setOidDokusi(documentoAux.getOidDokusi());

							Documento docDokusi = this.y41bDokusiAdapterService
									.descargarDocumentoDokusiSinDocumento(documento);

							arbdoctemp = new Arbdoctemp();

							arbdoctemp.setX5codocumento(this.arbdoctempDao.getNewPK().toString());
							arbdoctemp.setX5excodigo(solarb.getSacodigo());
							arbdoctemp.setX5nofile(docDokusi.getNombre());
							arbdoctemp.setX5sizefile((int) docDokusi.getLength());
							arbdoctemp.setX5origen(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE);
							arbdoctemp.setX5tedesfile(documentoAux.getDescripcion());
							arbdoctemp.setX5iddocumentum(documentoAux.getOidDokusi());
							arbdoctemp.setX5conttype(docDokusi.getContentType());
							arbdoctemp.setX5fecha(new Date());
							arbdoctemp.setX5fechaaportacion(solarb.getArbexp().getExfecreg());
							arbdoctemp.setArbtramexp(arbtramexp);

							arbdoctemp.setArbtipdoc(
									new Arbtipdoc(this.getTipoDocumento(documentoAux.getTipoDocumental())));

							arbdoctemp.setX5fechaentrada(new Date());
							arbdoctemp.setX5numregistroentrada(solarb.getArbexp().getExregen());
							// Blob blob = new
							// SerialBlob(Y41bUtilsWS.decode(docDokusi.getBytes()));
							// arbdoctemp.setX5datafile(blob);
							this.arbdoctempDao.add(arbdoctemp);

							// Si el tipo de documento es una acreditacion de
							// representacion, hay que abrir el tramite de
							// acreditacion
							// representante
							if (documentoAux.getTipoDocumental()
									.contains(Y41bConstantes.TIPO_DOC_ACREDITACION_REPRESENTACION)) {
								Arbtramexp acreditacionRepresentacion = this.sugiereTramiteAutomaticamente(arbtramexp,
										Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION,
										Y41bConstantes.FASE_INICIO_ARBITRAJE, false);
								// Asignar el documento de acreditacion al
								// tramite de
								// recepcion de representacion creado
								this.arbdoctempDao.insertArbDocTramite(acreditacionRepresentacion.getTrid(),
										arbdoctemp.getX5codocumento(), Y41bConstantes.TIPO_PROC_ARBITRAJE);

								this.actualizaBandeja(arbtramexp);
								this.actualizaUltimoTramiteArbexp(arbtramexp);
								this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
							} else {
								// insertar en la tabla de relacion
								this.arbdoctempDao.insertArbDocTramite(tramiteComun.getIdTramite(),
										arbdoctemp.getX5codocumento(), Y41bConstantes.TIPO_PROC_ARBITRAJE);
							}
						}
					}
				}
				this.arbtramexp3Service.abrirSolicitudTelematicaPlatea(solarb, tramiteComun, reclamanteArb,
						reclamadoArb);
			}
		}
		// 0169289: Estudio de la Integracin SIR
		if (tramitar) {
			//////////////////
			// si viene de asiento registral
			if (null != tramite.getIsSIR() && "" != tramite.getIsSIR()) {
				// documentos - DOKUSI

				// Recuperar documentos del asiento registral
				AsientoRegistral asientoRegistral = new AsientoRegistral();
				asientoRegistral.setIdAsiento(tramite.getIsSIR());
				asientoRegistral = this.asientoRegistralService.findAsientoRegistral(asientoRegistral);

				AsientoRegistralDetalle asientoRegistralDetalle = new AsientoRegistralDetalle();
				asientoRegistralDetalle.setIdAsiento(tramite.getIsSIR());
				asientoRegistralDetalle.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				asientoRegistralDetalle.setSacodigo(tramiteComun.getIdExpediente());
				this.asientoRegistralService.tramitarDocumentosAsientoRegistral(asientoRegistralDetalle);

				DocumentoAsientoRegistral docAsientoRegistral = new DocumentoAsientoRegistral();
				docAsientoRegistral.setAsientoRegistral(asientoRegistral);

				// Recuperar docs asociados
				List<DocumentoAsientoRegistral> listaDocumentoAsientoRegistral = null;

				listaDocumentoAsientoRegistral = this.documentosAsientoRegistralService
						.findAllDocumentosAR(docAsientoRegistral, null);

				for (DocumentoAsientoRegistral documentoAsientoRegistralAux : listaDocumentoAsientoRegistral) {
					if (Y41bUtils.isFilled(documentoAsientoRegistralAux.getOidDokusi())) {
						// descargar documentos dokusi
						Documento documento = new Documento();
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
						documento.setProcedure(procedure);
						documento.setOidDokusi(documentoAsientoRegistralAux.getOidDokusi());

						// INICIO 0201405: Duplicado de documentos en nuevo
						// arbitraje sin reclamacin previa desde bandeja SIR.
						// Buscamos el documento en la lista y si lo encontramos
						// no lo volvemos a dar de alta para evitar duplicados.
						// Los documentos de SIR se leen ahora de SIR pero
						// estaban en la lista de documentos de la creacion del
						// expediente
						Arbdoctemp arbdoctemp = new Arbdoctemp();
						arbdoctemp.setX5excodigo(tramiteComun.getIdExpediente());
						arbdoctemp.setX5idinterviniente(documentoAsientoRegistralAux.getOidDokusi());
						List<Arbdoctemp> lista = this.arbdoctempDao.findAll(arbdoctemp, null);
						boolean dadoDeAlta = false;
						Arbdoctemp documentoHechoAR = new Arbdoctemp();
						Documento docDokusi = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);
						if (!(lista != null && !lista.isEmpty())) {
							// No se ha localizado. Se da de alta
							// insertar el documento

							documentoHechoAR
									.setX5codocumento(String.valueOf(this.documentoHechoDao.getNewPK().intValue()));
							documentoHechoAR.setX5excodigo(tramiteComun.getIdExpediente());
							documentoHechoAR.setX5nofile(docDokusi.getNombre());

							documentoHechoAR.setX5iddocumentum(documentoAsientoRegistralAux.getOidDokusi());
							documentoHechoAR.setX5sizefile((int) docDokusi.getLength());
							documentoHechoAR.setX5conttype(docDokusi.getContentType());
							documentoHechoAR.setX5origen(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE);

							Date dateFechaRegistro = asientoRegistral.getFechaRegistro();

							documentoHechoAR.setX5fecha(dateFechaRegistro);
							documentoHechoAR.setX5fechaaportacion(dateFechaRegistro);
							documentoHechoAR.setArbtramexp(arbtramexp);

							documentoHechoAR.setX5fechaentrada(dateFechaRegistro);
							documentoHechoAR.setX5numregistroentrada(asientoRegistral.getNumRegistro());
							documentoHechoAR.setX5fecharegistroorigen(asientoRegistral.getFechaRegistroOrigen());
							documentoHechoAR.setX5numregistroorigen(asientoRegistral.getNumRegistroOrigen());
							// Anyadir nuevos valores de asiento registral
							documentoHechoAR.setX5tedesfile(documentoAsientoRegistralAux.getDescDoc());
							documentoHechoAR.setX5tipodocumento(documentoAsientoRegistralAux.getTipoDoc());
							documentoHechoAR.setArbtipdoc(new Arbtipdoc(documentoAsientoRegistralAux.getTipoDoc()));
							this.arbdoctempDao.add(documentoHechoAR);
							dadoDeAlta = true;
						} else {
							// Se ha localizado. Quitar oid de idinterviniente y
							// ponerlo en iddocumentum
							documentoHechoAR = lista.get(0);
							documentoHechoAR.setX5idinterviniente(null);
							documentoHechoAR.setX5iddocumentum(documentoAsientoRegistralAux.getOidDokusi());
							documentoHechoAR.setArbtipdoc(new Arbtipdoc(documentoAsientoRegistralAux.getTipoDoc()));
							documentoHechoAR.setX5datafile(null);
							this.arbdoctempDao.update(documentoHechoAR);
						}
						// FIN 0201405: Duplicado de documentos en nuevo
						// arbitraje sin reclamacin previa desde bandeja SIR.

						if (null != documentoAsientoRegistralAux.getTipoDoc()) {
							Arbtipdoc arbtipdoc = new Arbtipdoc();
							arbtipdoc.setTdid(documentoAsientoRegistralAux.getTipoDoc());
							arbtipdoc = this.arbtipdocService.find(arbtipdoc);
							documento.setTipoDocumental(arbtipdoc.getIdTipodoc());
						} else {
							documento.setTipoDocumental(Y41bConstantes.TIPO_DOC_SOLICITUD);
						}

						if (documento.getTipoDocumental()
								.contains(Y41bConstantes.TIPO_DOC_ACREDITACION_REPRESENTACION)) {
							Arbtramexp acreditacionRepresentacion = this.sugiereTramiteAutomaticamente(arbtramexp,
									Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION,
									Y41bConstantes.FASE_INICIO_ARBITRAJE, false);
							// Asignar el documento de acreditacion al
							// tramite de
							// recepcion de representacion creado
							if (dadoDeAlta) {
								this.arbdoctempDao.insertArbDocTramite(acreditacionRepresentacion.getTrid(),
										documentoHechoAR.getX5codocumento(), Y41bConstantes.TIPO_PROC_ARBITRAJE);
							}
							this.actualizaBandeja(arbtramexp);
							this.actualizaUltimoTramiteArbexp(arbtramexp);
							this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
						} else {
							if (dadoDeAlta) {
								// insertar en la tabla de relacion
								this.arbdoctempDao.insertArbDocTramite(arbtramexp.getTrid(),
										documentoHechoAR.getX5codocumento(), Y41bConstantes.TIPO_PROC_ARBITRAJE);
							}
						}

						documento.setDescripcion(documentoAsientoRegistralAux.getDescDoc());
						// retramitar - registro solicitud
						y41bDokusiAdapterService.retramitarDocumentoDokusi(documento); // OID
																						// y
																						// Tipo
																						// documental

					}
				}
				// borrar docs asiento
				this.documentosAsientoRegistralService.removeDocumentosAsientoRegistral(asientoRegistral);

				// borrar asiento
				this.asientoRegistralService.removeAsientoRegistral(asientoRegistral);
			}
			/////////////////
		}
		// 0169289: Estudio de la Integracin SIR

		return arbtramexp;
	}

	/**
	 * Finds a single row in the arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            the arbtramexp
	 * @return Arbexp
	 */
	public Arbexp actualizaUltimoTramiteArbexp(Arbtramexp arbtramexp) {
		try {
			Solarb solarb = arbtramexp.getSolarb();

			Arbexp arbexp = new Arbexp();
			arbexp.setExcodigo(solarb.getSacodigo());
			arbexp = this.arbexpDao.dameDetallesExpediente(arbexp);
			arbexp.setArbtramexp(arbtramexp);
			PosibleTramite posibletramite = new PosibleTramite();
			posibletramite.setTrposiblecodigoorigen(arbtramexp.getTrcodigo());
			Long sugierePosibleTramite = this.posibleTramiteDao.findAllCount(posibletramite);
			/* es de entidad */
			if (sugierePosibleTramite != 0) {
				arbexp.setArbtramexpEntidad(arbtramexp);
			}
			/*
			 * Arbexp arbexpAux = this.arbexpDao.findLobTablaTemporal(arbexp);
			 * if (arbexpAux != null) { arbexp.setHdte(arbexpAux.getHdte()); }
			 */

			/* actualizamos arbexp */
			this.arbexpDao.update(arbexp);

			return arbexp;
		} catch (Exception e) {
			e.printStackTrace();
			Arbtramexp2ServiceImpl.logger.error("Error producido en actualizaUltimoTramiteEnArbExp: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a single row in the arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            the arbtramexp
	 * @throws Exception
	 *             the exception
	 */
	public void actualizaBandeja(Arbtramexp arbtramexp) throws Exception {
		/*
		 * codigo muerto porque se borra por expediente Arbbandeja arbbandeja =
		 * rellenaArbBandeja(arbtramexp,estado);
		 */
		boolean hayEnTramitacion = false;
		/* elimino todas las entradas del expediente si las tuviera */
		Arbbandeja arbbandejaVO = new Arbbandeja();
		arbbandejaVO.setSolarb(arbtramexp.getSolarb());
		this.arbBandejaDao.deleteBandejaPorExpediente(arbbandejaVO);

		Arbtramexp cierre = new Arbtramexp();
		cierre.setSolarb(new Solarb(arbtramexp.getSolarb().getSacodigo()));
		cierre.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CIERRE);
		cierre.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		if (this.arbtramexpDao.findAllCount(cierre).longValue() == 0L) {
			/* por cada arbtramexp que tenga pendiente aniado un registro */
			Arbtramexp arbtramexpVO = new Arbtramexp();
			arbtramexpVO.setSolarb(new Solarb(arbtramexp.getSolarb().getSacodigo()));
			arbtramexpVO.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			List<Arbtramexp> listaEntTramitacion = this.arbtramexpDao.findAll(arbtramexpVO, null);
			if ((listaEntTramitacion != null) && (listaEntTramitacion.size() > 0)) {
				hayEnTramitacion = true;
				Arbbandeja arbbandejaAux = null;
				for (int i = 0; i < listaEntTramitacion.size(); i++) {
					arbbandejaAux = this.rellenaArbBandeja((Arbtramexp) listaEntTramitacion.get(i),
							Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					this.arbBandejaDao.add(arbbandejaAux);
				}
			}

			/* por cada arbtramexp que tenga firmado aniado un registro */
			arbtramexpVO = new Arbtramexp();
			arbtramexpVO.setSolarb(new Solarb(arbtramexp.getSolarb().getSacodigo()));
			arbtramexpVO.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
			List<Arbtramexp> listaFirmado = this.arbtramexpDao.findAll(arbtramexpVO, null);
			if ((listaFirmado != null) && (listaFirmado.size() > 0)) {
				hayEnTramitacion = true;
				Arbbandeja arbbandejaAux = null;
				for (int i = 0; i < listaFirmado.size(); i++) {
					arbbandejaAux = this.rellenaArbBandeja((Arbtramexp) listaFirmado.get(i),
							Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
					this.arbBandejaDao.add(arbbandejaAux);
				}
			}

			arbtramexpVO = new Arbtramexp();
			arbtramexpVO.setSolarb(new Solarb(arbtramexp.getSolarb().getSacodigo()));
			arbtramexpVO.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA);
			List<Arbtramexp> listaDenegadaFirma = this.arbtramexpDao.findAll(arbtramexpVO, null);
			if ((listaDenegadaFirma != null) && (listaDenegadaFirma.size() > 0)) {
				hayEnTramitacion = true;
				Arbbandeja arbbandejaAux = null;
				for (int i = 0; i < listaDenegadaFirma.size(); i++) {
					arbbandejaAux = this.rellenaArbBandeja((Arbtramexp) listaDenegadaFirma.get(i),
							Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA);
					this.arbBandejaDao.add(arbbandejaAux);
				}
			}

			arbtramexpVO = new Arbtramexp();
			arbtramexpVO.setSolarb(new Solarb(arbtramexp.getSolarb().getSacodigo()));
			arbtramexpVO.setTrestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
			List<Arbtramexp> listaPdteFirma = this.arbtramexpDao.findAll(arbtramexpVO, null);
			if ((listaPdteFirma != null) && (listaPdteFirma.size() > 0)) {
				hayEnTramitacion = true;
				Arbbandeja arbbandejaAux = null;
				for (int i = 0; i < listaPdteFirma.size(); i++) {
					arbbandejaAux = this.rellenaArbBandeja((Arbtramexp) listaPdteFirma.get(i),
							Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
					this.arbBandejaDao.add(arbbandejaAux);
				}
			}
			/* si no he añadido a la bandeja nada despues de lo anterior */
			if (!hayEnTramitacion) {
				/*
				 * sino habia pendientes aniado el último de los tramitados
				 */
				arbtramexpVO = new Arbtramexp();
				arbtramexpVO.setSolarb(new Solarb(arbtramexp.getSolarb().getSacodigo()));
				arbtramexpVO.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				Pagination pagination = new Pagination();
				pagination.setSort("trfecalta desc, trid");
				pagination.setSord("desc");
				List<Arbtramexp> listaTramitado = this.arbtramexpDao.findAll(arbtramexpVO, pagination);
				Arbtramexp arbtramexpAux = new Arbtramexp();
				if ((listaTramitado != null) && (listaTramitado.size() > 0)) {
					Arbbandeja arbbandejaAux = null;
					arbtramexpAux = (Arbtramexp) listaTramitado.get(0);
					arbbandejaAux = this.rellenaArbBandeja(arbtramexpAux, Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
					this.arbBandejaDao.add(arbbandejaAux);

				}
			}
		}
	}

	/**
	 * Rellena arb bandeja.
	 * 
	 * @param arbtramexp
	 *            the arbtramexp
	 * @param estado
	 *            the estado
	 * @return the arbbandeja
	 */
	public Arbbandeja rellenaArbBandeja(Arbtramexp arbtramexp, String estado) {
		Arbbandeja arbbandeja = new Arbbandeja();
		arbbandeja.setSolarb(arbtramexp.getSolarb());
		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(estado)) {
			arbbandeja.setMonitor(arbtramexp.getCensoMonitorEj());

		} else if (Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION.equals(estado)) {
			arbbandeja.setMonitor(arbtramexp.getCensoMonitor());

		} else if (Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA.equals(estado)) {
			arbbandeja.setMonitor(arbtramexp.getCensoMonitor());

		} else if (Y41bConstantes.ESTADO_TRAMITE_FIRMADO.equals(estado)) {
			arbbandeja.setMonitor(arbtramexp.getCensoMonitor());
		}
		if (Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION.equals(arbtramexp.getTrcodigo())
				|| Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO.equals(arbtramexp.getTrcodigo())) {
			/* rellenamos el campo destino/origen */
			arbbandeja.setArbinterv(new Arbinterv(arbtramexp.getTruaidinterv()));
		}
		arbbandeja.setAbtrid(arbtramexp.getTrid());
		arbbandeja.setAbestado(estado);
		arbbandeja.setAbfec(arbtramexp.getTrfecini());
		arbbandeja.setAbfase(arbtramexp.getFase().getFcodigo());

		return arbbandeja;

	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y los elimina en
	 * DOKUSI
	 * 
	 * @param listArbdoctemp
	 *            List<Arbdoctemp>
	 * @throws SQLException
	 *             SQLException
	 */
	public void eliminarDocumentosDokusi(List<Arbdoctemp> listArbdoctemp) throws SQLException {
		// Eliminamos los documentos de dokusi
		if (listArbdoctemp != null && listArbdoctemp.size() > 0) {
			for (Arbdoctemp arbdoctemp : listArbdoctemp) {
				if (arbdoctemp != null && arbdoctemp.getX5iddocumentum() != null
						&& !arbdoctemp.getX5iddocumentum().equals("")) {

					Long numTramitesUtilizado = this.arbdoctempDao.findAllDocTramiteHechoCount(arbdoctemp);

					if (numTramitesUtilizado == 0) {
						Documento documento = new Documento();
						// 1.User
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
						documento.setProcedure(procedure);
						documento.setOidDokusi(arbdoctemp.getX5iddocumentum());
						documento.setBoolAllVersions("true");

						this.y41bDokusiAdapterService.eliminarDocumentoDokusi(documento);
					}
				}
			}
		}
	}

	/**
	 * Metodo que recibe una lista de documentos del tramite y actualiza la
	 * BANDEJA DE FIRMA con los documentos pendientes de firmar Cuando un
	 * documento se inserte en la bandeja de firma, se inserta en Dokusi el
	 * documento si no tiene oidDokusi
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @param faseTramite
	 *            String
	 * @param tipoTramite
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarBandejaFirma(List<Arbdoctemp> listDocumentoHecho, TramiteComun tramiteComun,
			String faseTramite, String tipoTramite) throws Exception {
		try {
			if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
				// Elimino de la Bandeja de Firma los documentos del tramite
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(tipoTramite)) {
					List<BandejaFirma> lista = this.bandejaFirmaDao.findAllLike(bandejaFirma, null, false);
					if (!lista.isEmpty()) {
						for (BandejaFirma b : lista) {
							if (null == b.getComofirma()) {
								this.bandejaFirmaDao.remove(b);
							} else {
								boolean encontrado = false;
								for (int i = 0; i < listDocumentoHecho.size(); i++) {
									Arbdoctemp d = listDocumentoHecho.get(i);
									if (d.getX5codocumento().equals(b.getCodocumento())) {
										encontrado = true;
									}
								}
								if (encontrado == false) {
									this.bandejaFirmaDao.remove(b);
								}
							}
						}
					}

				} else {
					this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);
				}

				// Calculo el numero del expediente para Dokusi
				Solarb expDetalle = new Solarb();
				expDetalle.setSacodigo(tramiteComun.getIdExpediente());

				expDetalle = this.solarbDao.find(expDetalle);

				StringBuffer numeroExpediente = new StringBuffer();

				numeroExpediente.append(expDetalle.getSacoja()).append("-").append(expDetalle.getSanror()).append("-")
						.append(expDetalle.getSanran());

				// Recorro los documentos del tramite buscando aquel documento
				// que
				// este pendiente de firma
				Arbdoctemp documentoHecho = null;
				Arbdoctemp documentoHechoDetalleAux = null;
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					documentoHecho = listDocumentoHecho.get(i);
					if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getX5estadodocumento())) {
						// Si esta pendiente de firma, lo primero lo meto en
						// Dokusi
						// si NO esta dado de alta ya
						if (!Y41bUtils.isFilled(documentoHecho.getX5iddocumentum())) {
							Documento documento = new Documento();
							// 1.User
							User user = new User();
							user.setNombre(Y41bConstantes.COD_APLICACION);
							user.setDni(Y41bConstantes.COD_APLICACION);
							documento.setUser(user);
							Procedure procedure = new Procedure();
							procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
							documento.setProcedure(procedure);
							String tipoDocumental = "";
							if (Y41bUtils.isFilled(documentoHecho.getX5tipodocumento())) {
								Arbtipdoc arbtipdoc = new Arbtipdoc();
								arbtipdoc.setTdid(documentoHecho.getX5tipodocumento());
								arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
								tipoDocumental = arbtipdoc.getIdTipodoc();

							} else {
								tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
							}
							documento.setTipoDocumental(tipoDocumental);

							documento.setIdDocumento(documentoHecho.getX5codocumento().toString());

							documento.setNombre(Y41bUtils.getNameFile(documentoHecho.getX5nofile()));
							documento.setDescripcion(documentoHecho.getX5tedesfile());
							documento.setExtension(Y41bUtils.getExtensionFile(documentoHecho.getX5nofile()));
							// Recupero el [] byte
							documentoHechoDetalleAux = new Arbdoctemp();
							documentoHechoDetalleAux.setX5codocumento(documentoHecho.getX5codocumento());

							documentoHechoDetalleAux = this.arbdoctempService.find(documentoHechoDetalleAux);
							Blob contenido = documentoHechoDetalleAux.getX5datafile();

							byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

							documento.setBytes(Y41bUtilsDokusi.encode(bContenido));
							if (Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION
									.equals(documentoHecho.getX5origen())) {
								documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
							} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE
									.equals(documentoHecho.getX5origen())
									|| Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE2
											.equals(documentoHecho.getX5origen())
									|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE
											.equals(documentoHecho.getX5origen())) {
								documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
							} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO.equals(documentoHecho.getX5origen())
									|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO
											.equals(documentoHecho.getX5origen())) {
								documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
							} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_OTROS.equals(documentoHecho.getX5origen())) {
								documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
							} else {
								documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
							}

							StringBuffer numeroExpedienteDokusi = new StringBuffer();
							numeroExpedienteDokusi.append(Y41bConstantes.TIPO_PROC_ARBITRAJE).append("-")
									.append(numeroExpediente);
							documento.setNumeroExpediente(numeroExpedienteDokusi.toString());

							if (Y41bUtils.interactuarConDokusi()) {
								Documento documentoRdo = this.y41bDokusiAdapterService
										.registrarDocumentoDokusi(documento);
								documentoHecho.setX5iddocumentum(documentoRdo.getOidDokusi());

								/**
								 * no tiene sentido actualizar lo del
								 * localizador en adjuntardocs porque para
								 * cuando se llama a esto ya se ha hecho el
								 * remove de todos los elementos de la tabla
								 * adjuntardocs
								 */
							}

							// Update oid de documentum
							this.arbdoctempDao.updateOIDDokusi(documentoHecho);

							if (Y41bUtils.isDocumentoTransformable(documento)) {
								this.arbdoctempDao.updateFechaLocalizacion(documentoHecho);
							} else {
								this.arbdoctempDao.removeBlobFromOIDDokusi(documentoHecho);
							}
						}
						// Lo segundo lo meto en la Bandeja de Firma
						bandejaFirma = new BandejaFirma();

						bandejaFirma
								.setIdbandejafirma(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
						bandejaFirma.setIdexpediente(tramiteComun.getIdExpediente());
						bandejaFirma.setExpediente(numeroExpediente.toString());
						bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
						bandejaFirma.setHccoor(expDetalle.getSacoja());
						bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
						bandejaFirma.setTrcodigo(tipoTramite);

						Fase fase = new Fase();
						fase.setFcodigo(faseTramite);
						bandejaFirma.setFase(fase);

						bandejaFirma.setCodocumento(documentoHecho.getX5codocumento());
						bandejaFirma.setIddocumentum(documentoHecho.getX5iddocumentum());
						bandejaFirma.setNofile(documentoHecho.getX5nofile());
						bandejaFirma.setFechalimfirma(new Date());
						bandejaFirma.setIdperfilfirma(documentoHecho.getX5idPerfilfirma());
						bandejaFirma.setDesfile(documentoHecho.getX5tedesfile());

						Documento documento = new Documento();
						User user = new User();
						user.setNombre(Y41bConstantes.COD_APLICACION);
						user.setDni(Y41bConstantes.COD_APLICACION);
						documento.setUser(user);
						Procedure procedure = new Procedure();
						procedure.setIdProcedimiento(Y41bConstantes.TIPO_PROC_ARBITRAJE);
						documento.setProcedure(procedure);
						documento.setOidDokusi(documentoHecho.getX5iddocumentum());

						Documento documentoRdo = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

						documento.setBytes(new String(Y41bUtilsWS.decode(documentoRdo.getBytes())));

						String hashDocumento = y41bPlateaAdapterService.generarHashDocumento(documento);
						bandejaFirma.setHashfile(hashDocumento);

						if (bandejaFirma.getIdperfilfirma() != null
								&& bandejaFirma.getIdperfilfirma().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
							Arbexp arbexp = new Arbexp();
							arbexp.setExcodigo(expDetalle.getArbexp().getExcodigo());
							arbexp = this.arbexpDao.dameDetallesExpediente(arbexp);

							bandejaFirma.setComoasigfirma(arbexp.getExmocodigo());
						}

						// buscar de la listadochecho los documetnos si
						// esta, no lo vuelvo a meter
						if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(tipoTramite)) {
							BandejaFirma registroInsertar = new BandejaFirma();
							registroInsertar.setIdtramitehecho(bandejaFirma.getIdtramitehecho());
							registroInsertar.setCodocumento(bandejaFirma.getCodocumento());
							List<BandejaFirma> listaRepetidos = this.bandejaFirmaDao.findAllLike(registroInsertar, null,
									false);

							if (listaRepetidos.isEmpty()) {
								this.bandejaFirmaDao.add(bandejaFirma);
							}
						} else {
							this.bandejaFirmaDao.add(bandejaFirma);
						}

					}
				}
			}
		} catch (Exception e) {
			throw e;
		}

	}

	// 0155021
	/**
	 * Metodo que recibe una lista de documentos del tramite y actualiza la
	 * BANDEJA DE FIRMA con los documentos pendientes de firmar Cuando un
	 * documento se inserte en la bandeja de firma, se inserta en Dokusi el
	 * documento si no tiene oidDokusi
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @param faseTramite
	 *            String
	 * @param tipoTramite
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	public void actualizarBandejaFirmaArbitraje(List<Arbdoctemp> listDocumentoHecho, TramiteComun tramiteComun,
			String faseTramite, String tipoTramite) throws Exception {
		try {
			if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {

				String idioma = LocaleContextHolder.getLocale().getLanguage();
				Map<String, Object> mapaOrganoColegioArbitral = new HashMap<String, Object>();
				String dateFormat = "";

				// Elimino de la Bandeja de Firma los documentos del tramite
				BandejaFirmaArbitraje bandejaFirmaArbitraje = new BandejaFirmaArbitraje();
				bandejaFirmaArbitraje.setIdtramitehecho(tramiteComun.getIdTramite());
				// Borramos solo los registros que ya no esten en el tramite de
				// laudo (que ya no salgan en el gris )

				Arbtramexp2ServiceImpl.logger
						.info("PORTAFIRMAS -Arbtramexp2ServiceImpl - actualizarBandejaFirmaArbitraje. actuliazos la bandeja con los siguientes documentos que nos han entrado"
								+ listDocumentoHecho);
				List<BandejaFirmaArbitraje> listaParaBorrar = this.bandejaFirmaArbitrajeDao
						.findAllLike(bandejaFirmaArbitraje, null, false);
				for (BandejaFirmaArbitraje registro : listaParaBorrar) {
					DocumentosFirmaArbitros doc1 = new DocumentosFirmaArbitros();
					doc1.setIddocumentosfirmaarb(registro.getCodocumento());
					List<DocumentosFirmaArbitros> listaDoc = this.documentosFirmaArbitrosService.findAll(doc1, null);
					if (listaDoc.isEmpty()
							&& (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(registro.getEstado())
									|| null == registro.getEstado())) {
						// this.bandejaFirmaArbitrajeDao
						// .removeBandejaFirmaExpediente(registro);
						this.bandejaFirmaArbitrajeDao.remove(registro);
						Arbtramexp2ServiceImpl.logger
								.info(" PORTAFIRMAS- Arbtramexp2ServiceImpl - actualizarBandejaFirmaArbitraje. borro de la bandeja de firmas de arbitraje el siguiente documento por que ya no est en el grid"
										+ registro);
					} else if (listaDoc.isEmpty()
							&& (Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO.equals(registro.getEstado())
									|| Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA.equals(registro.getEstado()))) {
						registro.setIddocumentum(null);
						this.bandejaFirmaArbitrajeDao.update(registro);
					}
				}

				// Calculo el numero del expediente para Dokusi
				Solarb expDetalle = new Solarb();
				expDetalle.setSacodigo(tramiteComun.getIdExpediente());

				expDetalle = this.solarbDao.find(expDetalle);

				StringBuffer numeroExpediente = new StringBuffer();

				numeroExpediente.append(expDetalle.getSacoja()).append("-").append(expDetalle.getSanror()).append("-")
						.append(expDetalle.getSanran());

				// Recorro los documentos del tramite buscando aquel documento
				// que
				// este pendiente de firma
				Arbdoctemp documentoHecho = null;
				Arbdoctemp documentoHechoDetalleAux = null;
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					documentoHecho = listDocumentoHecho.get(i);
					if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getX5estadodocumento())
					// MIRAR SI EL DOCUMENTO TIENE PERFIL FIRMA PARA ARBITRAJE
					) {
						DocumentosFirmaArbitros doc1 = new DocumentosFirmaArbitros();
						doc1.setIddocumentosfirmaarb(documentoHecho.getX5codocumento());
						doc1 = this.documentosFirmaArbitrosService.find(doc1);
						DocumentosFirmaArbitrosTemp doc2 = new DocumentosFirmaArbitrosTemp();
						doc2.setIddocumentosfirmaarbtemp(documentoHecho.getX5codocumento());
						doc2 = this.documentosFirmaArbitrosTempService.find(doc2);

						if (null != doc1 || null != doc2) {
							// Si esta pendiente de firma, lo primero lo meto en
							// Dokusi
							// si NO esta dado de alta ya
							if (!Y41bUtils.isFilled(documentoHecho.getX5iddocumentum())) {
								Documento documento = new Documento();
								// 1.User
								User user = new User();
								user.setNombre(Y41bConstantes.COD_APLICACION);
								user.setDni(Y41bConstantes.COD_APLICACION);
								documento.setUser(user);
								Procedure procedure = new Procedure();
								procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
								documento.setProcedure(procedure);
								String tipoDocumental = "";
								if (Y41bUtils.isFilled(documentoHecho.getX5tipodocumento())) {
									Arbtipdoc arbtipdoc = new Arbtipdoc();
									arbtipdoc.setTdid(documentoHecho.getX5tipodocumento());
									arbtipdoc = this.arbtipdocDao.find(arbtipdoc);
									tipoDocumental = arbtipdoc.getIdTipodoc();

								} else {
									tipoDocumental = Y41bConstantes.TIPO_DOC_ARCHIVO_GENERICO;
								}
								documento.setTipoDocumental(tipoDocumental);

								documento.setIdDocumento(documentoHecho.getX5codocumento().toString());

								documento.setNombre(Y41bUtils.getNameFile(documentoHecho.getX5nofile()));
								documento.setDescripcion(documentoHecho.getX5tedesfile());
								documento.setExtension(Y41bUtils.getExtensionFile(documentoHecho.getX5nofile()));
								// Recupero el [] byte
								documentoHechoDetalleAux = new Arbdoctemp();
								documentoHechoDetalleAux.setX5codocumento(documentoHecho.getX5codocumento());

								documentoHechoDetalleAux = this.arbdoctempService.find(documentoHechoDetalleAux);
								Blob contenido = documentoHechoDetalleAux.getX5datafile();

								byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

								documento.setBytes(Y41bUtilsDokusi.encode(bContenido));
								if (Y41bConstantes.ORIGEN_ARB_APORTADO_ADMINISTRACION
										.equals(documentoHecho.getX5origen())) {
									documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
								} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE
										.equals(documentoHecho.getX5origen())
										|| Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE2
												.equals(documentoHecho.getX5origen())
										|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE
												.equals(documentoHecho.getX5origen())) {
									documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
								} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO
										.equals(documentoHecho.getX5origen())
										|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO
												.equals(documentoHecho.getX5origen())) {
									documento.setOrigenDocumento(Y41bConstantes.ORIGEN_CIUDADANIA);
								} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_OTROS
										.equals(documentoHecho.getX5origen())) {
									documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
								} else {
									documento.setOrigenDocumento(Y41bConstantes.ORIGEN_ADMINISTRACION);
								}

								StringBuffer numeroExpedienteDokusi = new StringBuffer();
								numeroExpedienteDokusi.append(Y41bConstantes.TIPO_PROC_ARBITRAJE).append("-")
										.append(numeroExpediente);
								documento.setNumeroExpediente(numeroExpedienteDokusi.toString());

								if (Y41bUtils.interactuarConDokusi()) {
									Documento documentoRdo = this.y41bDokusiAdapterService
											.registrarDocumentoDokusi(documento);
									documentoHecho.setX5iddocumentum(documentoRdo.getOidDokusi());

									/**
									 * no tiene sentido actualizar lo del
									 * localizador en adjuntardocs porque para
									 * cuando se llama a esto ya se ha hecho el
									 * remove de todos los elementos de la tabla
									 * adjuntardocs
									 */
								}

								// Update oid de documentum
								this.arbdoctempDao.updateOIDDokusi(documentoHecho);

								if (Y41bUtils.isDocumentoTransformable(documento)) {
									this.arbdoctempDao.updateFechaLocalizacion(documentoHecho);
								} else {
									this.arbdoctempDao.removeBlobFromOIDDokusi(documentoHecho);
								}
							}
							// Lo segundo lo meto en la Bandeja de Firma
							bandejaFirmaArbitraje = new BandejaFirmaArbitraje();

							bandejaFirmaArbitraje.setIdbandejafirma(
									Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
							bandejaFirmaArbitraje.setIdexpediente(tramiteComun.getIdExpediente());
							bandejaFirmaArbitraje.setExpediente(numeroExpediente.toString());
							// bandejaFirmaArbitraje
							// .setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
							// bandejaFirmaArbitraje.setHccoor(expDetalle.getSacoja());
							bandejaFirmaArbitraje.setIdtramitehecho(tramiteComun.getIdTramite());
							// bandejaFirmaArbitraje.setTrcodigo(tipoTramite);

							Fase fase = new Fase();
							fase.setFcodigo(faseTramite);
							// bandejaFirmaArbitraje.setFase(fase);

							bandejaFirmaArbitraje.setCodocumento(documentoHecho.getX5codocumento());
							bandejaFirmaArbitraje.setIddocumentum(documentoHecho.getX5iddocumentum());
							bandejaFirmaArbitraje.setNofile(documentoHecho.getX5nofile());
							bandejaFirmaArbitraje.setFechalimfirma(new Date());
							bandejaFirmaArbitraje.setDesfile(documentoHecho.getX5tedesfile());
							// bandejaFirmaArbitraje.setIdperfilfirma(documentoHecho
							// .getX5idPerfilfirma());
							// bandejaFirmaArbitraje
							// .setDesfile(documentoHecho.getX5tedesfile());

							Documento documento = new Documento();
							User user = new User();
							user.setNombre(Y41bConstantes.COD_APLICACION);
							user.setDni(Y41bConstantes.COD_APLICACION);
							documento.setUser(user);
							Procedure procedure = new Procedure();
							procedure.setIdProcedimiento(Y41bConstantes.TIPO_PROC_ARBITRAJE);
							documento.setProcedure(procedure);
							documento.setOidDokusi(documentoHecho.getX5iddocumentum());

							Documento documentoRdo = y41bDokusiAdapterService.descargarDocumentoDokusi(documento);

							documento.setBytes(new String(Y41bUtilsWS.decode(documentoRdo.getBytes())));

							BandejaFirma bandeja = new BandejaFirma();
							bandeja.setCodocumento(documentoHecho.getX5codocumento());
							BandejaFirmaBusqueda bandejaBusqueda = this.bandejaFirmaDao
									.findBandejaFirmaPorCodocumento(bandeja);

							if (null != bandejaBusqueda && null != bandejaBusqueda.getHashfile()) {
								bandejaFirmaArbitraje.setHashfile(bandejaBusqueda.getHashfile());
							}

							// List<BandejaFirmaBusqueda> listBandeja =
							// this.bandejaFirmaDao
							// .findAllBandejaFirma(bandeja, null, null);
							// if (null != listBandeja.get(0)) {
							// String hashfile =
							// listBandeja.get(0).getHashfile();
							// if (null != hashfile) {
							// bandejaFirmaArbitraje.setHashfile(hashfile);
							// }
							// }
							//
							// if (null != bandejaFirmaArbitraje.getHashfile())
							// {
							//
							// String hashDocumento = y41bPlateaAdapterService
							// .generarHashDocumento(documento);
							//
							// bandejaFirmaArbitraje.setHashfile(hashDocumento);
							// }

							// if (bandejaFirmaArbitraje.getIdperfilfirma() !=
							// null
							// && bandejaFirma.getIdperfilfirma().equals(
							// Y41bConstantes.PERFIL_INSTRUCTOR)) {
							// Arbexp arbexp = new Arbexp();
							// arbexp.setExcodigo(expDetalle.getArbexp()
							// .getExcodigo());
							// arbexp = this.arbexpDao
							// .dameDetallesExpediente(arbexp);
							//
							// bandejaFirma.setComoasigfirma(arbexp
							// .getExmocodigo());
							// }

							// sacamos arbitro/arbitros para asignarles las
							// firmas

							Arbtramexp organoColegioArbitral = new Arbtramexp();
							if (Y41bConstantes.EUSKERA.equals(idioma)) {
								dateFormat = Y41bConstantes.FORMATO_FECHA_EU;
							} else {
								dateFormat = Y41bConstantes.FORMATO_FECHA_ES;
							}
							// sacar los datos del ltimo que est resuelto
							organoColegioArbitral.setSolarb(expDetalle);

							organoColegioArbitral.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
							organoColegioArbitral.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

							Pagination pagination = new Pagination();
							pagination.setSort("trfecfin");
							pagination.setAscDsc("desc");

							List<Arbtramexp> lista = this.arbtramexpDao.findAll(organoColegioArbitral, pagination);

							if (lista != null && lista.size() > 0) {
								mapaOrganoColegioArbitral = this.cargaDatosColegioArbitral(expDetalle,
										organoColegioArbitral, lista, mapaOrganoColegioArbitral, dateFormat);
							}
							String trintica = "";
							String activo = "";
							for (Map.Entry<String, Object> entry : mapaOrganoColegioArbitral.entrySet()) {
								if ("trintica".equals(entry.getKey())) {
									trintica = entry.getValue().toString();
								}
							}
							// dependiendo de si es 1 arbitro o 3
							// si es 3 cojo el presi el consumidor y el
							// empresarial
							// si es 1 solo cojo el presi
							// hay que mirar a ver si esta activo o no oara
							// cojer el
							// titular o el suplente
							if ("3".equals(trintica)) {
								for (Map.Entry<String, Object> entry : mapaOrganoColegioArbitral.entrySet()) {
									if ("activopresi".equals(entry.getKey())) {
										activo = entry.getValue().toString();
										if ("S".equals(activo)) {
											for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral
													.entrySet()) {
												if ("codpresi".equals(entry2.getKey())) {
													bandejaFirmaArbitraje.setArcodigo(entry2.getValue().toString());
												}
											}
										} else {
											for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral
													.entrySet()) {
												if ("codpresisupl".equals(entry2.getKey())) {
													bandejaFirmaArbitraje.setArcodigo(entry2.getValue().toString());
												}
											}
										}
									}
								}
								BandejaFirmaArbitraje registroInsertar = new BandejaFirmaArbitraje();
								registroInsertar.setIdtramitehecho(bandejaFirmaArbitraje.getIdtramitehecho());
								registroInsertar.setCodocumento(bandejaFirmaArbitraje.getCodocumento());
								registroInsertar.setArcodigo(bandejaFirmaArbitraje.getArcodigo());
								List<BandejaFirmaArbitraje> listaRepetidos = this.bandejaFirmaArbitrajeDao
										.findAllLike(registroInsertar, null, false);

								if (listaRepetidos.isEmpty()) {
									this.bandejaFirmaArbitrajeDao.add(bandejaFirmaArbitraje);
									Arbtramexp2ServiceImpl.logger
											.info("PORTAFIRMAS -Arbtramexp2ServiceImpl - actualizarBandejaFirmaArbitraje. inserto en la bandeja de firmas de arbitraje el siguiente registro por que est en el grid"
													+ bandejaFirmaArbitraje);
								}
								bandejaFirmaArbitraje.setIdbandejafirma(
										Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
								for (Map.Entry<String, Object> entry : mapaOrganoColegioArbitral.entrySet()) {
									if ("activoarbcons".equals(entry.getKey())) {
										activo = entry.getValue().toString();
										if ("S".equals(activo)) {
											for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral
													.entrySet()) {
												if ("codcons".equals(entry2.getKey())) {
													bandejaFirmaArbitraje.setArcodigo(entry2.getValue().toString());
												}
											}
										} else {
											for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral
													.entrySet()) {
												if ("codarbconssupl".equals(entry2.getKey())) {
													bandejaFirmaArbitraje.setArcodigo(entry2.getValue().toString());
												}
											}
										}
									}
								}
								registroInsertar = new BandejaFirmaArbitraje();
								registroInsertar.setIdtramitehecho(bandejaFirmaArbitraje.getIdtramitehecho());
								registroInsertar.setCodocumento(bandejaFirmaArbitraje.getCodocumento());
								registroInsertar.setArcodigo(bandejaFirmaArbitraje.getArcodigo());
								listaRepetidos = this.bandejaFirmaArbitrajeDao.findAllLike(registroInsertar, null,
										false);

								if (listaRepetidos.isEmpty()) {
									this.bandejaFirmaArbitrajeDao.add(bandejaFirmaArbitraje);
									Arbtramexp2ServiceImpl.logger
											.info("PORTAFIRMAS -Arbtramexp2ServiceImpl - actualizarBandejaFirmaArbitraje. inserto en la bandeja de firmas de arbitraje el siguiente registro por que est en el grid"
													+ bandejaFirmaArbitraje);
								}
								bandejaFirmaArbitraje.setIdbandejafirma(
										Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
								for (Map.Entry<String, Object> entry : mapaOrganoColegioArbitral.entrySet()) {
									if ("activoarbemp".equals(entry.getKey())) {
										activo = entry.getValue().toString();
										if ("S".equals(activo)) {
											for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral
													.entrySet()) {
												if ("codarbemp".equals(entry2.getKey())) {
													bandejaFirmaArbitraje.setArcodigo(entry2.getValue().toString());
												}
											}
										} else {
											for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral
													.entrySet()) {
												if ("codarbempsupl".equals(entry2.getKey())) {
													bandejaFirmaArbitraje.setArcodigo(entry2.getValue().toString());
												}
											}
										}
									}
								}
								registroInsertar = new BandejaFirmaArbitraje();
								registroInsertar.setIdtramitehecho(bandejaFirmaArbitraje.getIdtramitehecho());
								registroInsertar.setCodocumento(bandejaFirmaArbitraje.getCodocumento());
								registroInsertar.setArcodigo(bandejaFirmaArbitraje.getArcodigo());
								listaRepetidos = this.bandejaFirmaArbitrajeDao.findAllLike(registroInsertar, null,
										false);

								if (listaRepetidos.isEmpty()) {
									this.bandejaFirmaArbitrajeDao.add(bandejaFirmaArbitraje);
									Arbtramexp2ServiceImpl.logger
											.info("PORTAFIRMAS -Arbtramexp2ServiceImpl - actualizarBandejaFirmaArbitraje. inserto en la bandeja de firmas de arbitraje el siguiente registro por que est en el grid"
													+ bandejaFirmaArbitraje);
								}
							} else {
								for (Map.Entry<String, Object> entry : mapaOrganoColegioArbitral.entrySet()) {
									if ("activopresi".equals(entry.getKey())) {
										activo = entry.getValue().toString();
										if ("S".equals(activo)) {
											for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral
													.entrySet()) {
												if ("codpresi".equals(entry2.getKey())) {
													bandejaFirmaArbitraje.setArcodigo(entry2.getValue().toString());
												}
											}
										} else {
											for (Map.Entry<String, Object> entry2 : mapaOrganoColegioArbitral
													.entrySet()) {
												if ("codpresisupl".equals(entry2.getKey())) {
													bandejaFirmaArbitraje.setArcodigo(entry2.getValue().toString());
												}
											}
										}
									}
								}

								// buscar de la listadochecho los documetnos si
								// esta, no lo vuelvo a meter
								BandejaFirmaArbitraje registroInsertar = new BandejaFirmaArbitraje();
								registroInsertar.setIdtramitehecho(bandejaFirmaArbitraje.getIdtramitehecho());
								registroInsertar.setCodocumento(bandejaFirmaArbitraje.getCodocumento());
								registroInsertar.setArcodigo(bandejaFirmaArbitraje.getArcodigo());
								List<BandejaFirmaArbitraje> listaRepetidos = this.bandejaFirmaArbitrajeDao
										.findAllLike(registroInsertar, null, false);

								if (listaRepetidos.isEmpty()) {
									this.bandejaFirmaArbitrajeDao.add(bandejaFirmaArbitraje);
									Arbtramexp2ServiceImpl.logger
											.info("PORTAFIRMAS -Arbtramexp2ServiceImpl - actualizarBandejaFirmaArbitraje. inserto en la bandeja de firmas de arbitraje el siguiente registro por que est en el grid"
													+ bandejaFirmaArbitraje);
								}

							}
						}
					}
				}
			}
		} catch (Exception e) {
			throw e;
		}

	}

	// 0155021

	/**
	 * Actualizar el expediente.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param idInterviniente
	 *            idInterviniente
	 * @param tipoInterviniente
	 *            tipoInterviniente
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	public Arbtramexp sugiereTramiteComunicacionAutomaticamente(Arbtramexp arbtramexp, Arbinterv arbinterv)
			throws Exception {

		try {

			Solarb solarb = new Solarb();
			solarb.setSacodigo(arbtramexp.getSolarb().getSacodigo());
			solarb = this.solarbDao.find(solarb);

			Arbtramexp arbtramexpNuevo = new Arbtramexp();
			arbtramexpNuevo.setSolarb(solarb);
			arbtramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION);
			arbtramexpNuevo.setTrfecini(arbtramexp.getTrfecini());

			// La comunicacin automatica tiene que ir al responsable del
			// expediente siempre como en arbcionadores
			Arbexp arbexp = new Arbexp();
			arbexp.setExcodigo(arbtramexp.getSolarb().getSacodigo());
			arbexp = this.arbexpDao.find(arbexp);
			arbtramexpNuevo.setCensoMonitor(new CensoMonitor(arbexp.getExmocodigo(), null));

			arbtramexpNuevo.setTrcodigorel(arbtramexp.getTrcodigo());
			arbtramexpNuevo.setTrtridrel(arbtramexp.getTrid());

			arbtramexpNuevo.setFase(arbtramexp.getFase());
			arbtramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			arbtramexpNuevo.setTrasuntocomunicacion(solarb.damecodCompletoPlatea());
			arbtramexpNuevo.setTruaidinterv(arbinterv.getUaidinterv());

			arbtramexpNuevo.setTrfecnotif(Y41bUtils.obtenerFechaHoy());

			arbtramexpNuevo.setTrenvrem(Y41bConstantes.VALOR_SI);

			arbtramexpNuevo = this.add(arbtramexpNuevo);

			// 1.2 Hay que relacionar los documentos de la decision con
			// el tramite de notificacion al reclamado
			// Recupero los documentos al reclamado
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(arbtramexp.getTrid().toString());
			List<Arbdoctemp> documentos = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux, null);

			// Relaciono tramite - documento
			if (documentos != null && documentos.size() > 0) {
				for (Arbdoctemp documento : documentos) {
					if (Y41bUtils.esNullOCadenaVacia(documento.getX5destino())
							|| documento.getX5destino().equals(arbinterv.getUatipointerv())) {
						this.arbdoctempDao.insertArbDocTramite(arbtramexpNuevo.getTrid(), documento.getX5codocumento(),
								Y41bConstantes.TIPO_PROC_ARBITRAJE);
					}
				}
			}

			// Si el tramite es de citacion, a parte de adjuntar los documentos
			// propios del tramite hay que anyadir los del tramite de
			// designacion
			if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
				Arbtramexp tramiteDesignacion = new Arbtramexp();
				tramiteDesignacion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
				Pagination pagination = new Pagination();
				pagination.setSidx("TRID");
				pagination.setSord("DESC");
				List<Arbtramexp> ltramiteDesignacion = arbtramexpDao.findAll(tramiteDesignacion, pagination);
				if (ltramiteDesignacion != null && ltramiteDesignacion.size() > 0) {
					for (Arbtramexp trdesignacion : ltramiteDesignacion) {
						if (arbtramexpNuevo.getSolarb().getArbexp().getExcodigo()
								.equals(trdesignacion.getSolarb().getArbexp().getExcodigo())) {
							tramiteDesignacion = trdesignacion;
							break;
						}
					}
					if (tramiteDesignacion != null && tramiteDesignacion.getTrid() != null) {
						this.adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(tramiteDesignacion.getTrid().toString(),
								arbtramexpNuevo.getTrid().toString());
					}

				}
				// 0150948: Evolutivo Arbitraje Marzo-2020
				// 2.4
				// aadir todo documento de la parte reclamente y reclamado para
				// destinatario arbitro
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO.equalsIgnoreCase(arbinterv.getUatipointerv())) {
					this.adjuntarDocumentosDeUnOrigenAUnTramiteAutomaticamente(
							Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE, arbtramexpNuevo.getTrid().toString(),
							arbtramexp.getSolarb().getSacodigo());
					this.adjuntarDocumentosDeUnOrigenAUnTramiteAutomaticamente(
							Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO, arbtramexpNuevo.getTrid().toString(),
							arbtramexp.getSolarb().getSacodigo());
				}
				// 0150948: Evolutivo Arbitraje Marzo-2020
				// 2.4
			}

			if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
				Arbtramexp tramiteRecepcionInformePericial = new Arbtramexp();
				tramiteRecepcionInformePericial
						.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL);
				Pagination pagination = new Pagination();
				pagination.setSidx("TRID");
				pagination.setSord("DESC");
				List<Arbtramexp> ltramiteRecepcionInformePericial = arbtramexpDao
						.findAll(tramiteRecepcionInformePericial, pagination);
				if (ltramiteRecepcionInformePericial != null && ltramiteRecepcionInformePericial.size() > 0) {
					tramiteRecepcionInformePericial = ltramiteRecepcionInformePericial.get(0);
					if (tramiteRecepcionInformePericial != null && tramiteRecepcionInformePericial.getTrid() != null) {
						this.adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(
								tramiteRecepcionInformePericial.getTrid().toString(),
								arbtramexpNuevo.getTrid().toString());
					}
				}
			}

			// Si el tramite es de convenio arbitral y el destinatario es
			// reclamante, aparte de adjuntar los documentos propios del tramite
			// hay que anyadir los del tramite de aceptacion de arbitraje
			// 0155673: anyadimos que si es una resolucion tmb haga esto
			if ((Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL.equals(arbtramexp.getTrcodigo())
					|| Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(arbtramexp.getTrcodigo()))
					&& (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
							|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
									.equals(arbinterv.getUatipointerv()))) {
				Arbtramexp tramiteAceptacion = new Arbtramexp();
				tramiteAceptacion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE);
				Pagination pagination = new Pagination();
				pagination.setSidx("TRID");
				pagination.setSord("DESC");
				List<Arbtramexp> ltramiteAceptacion = arbtramexpDao.findAll(tramiteAceptacion, pagination);
				if (ltramiteAceptacion != null && ltramiteAceptacion.size() > 0) {
					for (Arbtramexp traceptacion : ltramiteAceptacion) {
						if (arbtramexpNuevo.getSolarb().getArbexp().getExcodigo()
								.equals(traceptacion.getSolarb().getArbexp().getExcodigo())) {
							tramiteAceptacion = traceptacion;
							break;
						}
					}
					// 0151153: Convenio arbitral - Error al tramitar
					// Se controla que si no encuentra tramite de aceptacion no
					// haga la copia de documentos de un tramite a otro
					if (tramiteAceptacion != null && tramiteAceptacion.getTrid() != null) {
						this.adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(tramiteAceptacion.getTrid().toString(),
								arbtramexpNuevo.getTrid().toString());
					}
				}
			}

			// 0150948: Evolutivo Arbitraje Marzo-2020
			// 2.1. Nuevo tipo de alegacin que no genere comunicacin a la otra
			// parte
			// Si el trmite es de resolucion, a parte de adjuntar los
			// documentos
			// propios del trmite hay que aadir las alegaciones de un tramite
			// de aporte de documentacion
			if (Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(arbtramexp.getTrcodigo())
					|| Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL.equals(arbtramexp.getTrcodigo())) {

				this.adjuntarAlegacionesAUnTramiteAutomaticamente(arbtramexpNuevo.getTrid().toString(),
						arbtramexp.getSolarb().getSacodigo());

				this.adjuntarRechazosAUnTramiteAutomaticamente(arbtramexpNuevo.getTrid().toString(),
						arbtramexp.getSolarb().getSacodigo());

			}
			// 0150948: Evolutivo Arbitraje Marzo-2020
			// 2.1. Nuevo tipo de alegacin que no genere comunicacin a la otra
			// parte

			this.calcularEstadoTramiteGenerado(arbtramexpNuevo);

			return arbtramexpNuevo;

		} catch (Exception e) {
			Arbtramexp2ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	public Arbtramexp sugiereTramiteNotificacionAutomaticamente(Arbtramexp arbtramexp, Arbinterv arbinterv)
			throws Exception {

		try {

			Solarb solarb = new Solarb();
			solarb.setSacodigo(arbtramexp.getSolarb().getSacodigo());
			solarb = this.solarbDao.find(solarb);

			Arbtramexp arbtramexpNuevo = new Arbtramexp();
			arbtramexpNuevo.setSolarb(solarb);
			arbtramexpNuevo.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION);
			arbtramexpNuevo.setTrfecini(arbtramexp.getTrfecini());

			// La notificacin automatica tiene que ir al responsable del
			// expediente siempre como en arbcionadores
			Arbexp arbexp = new Arbexp();
			arbexp.setExcodigo(arbtramexp.getSolarb().getSacodigo());
			arbexp = this.arbexpDao.find(arbexp);
			arbtramexpNuevo.setCensoMonitor(new CensoMonitor(arbexp.getExmocodigo(), null));

			arbtramexpNuevo.setTrcodigorel(arbtramexp.getTrcodigo());
			arbtramexpNuevo.setTrtridrel(arbtramexp.getTrid());

			arbtramexpNuevo.setFase(arbtramexp.getFase());
			arbtramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			arbtramexpNuevo.setTrasuntocomunicacion(solarb.damecodCompletoPlatea());

			arbtramexpNuevo.setTrfecnotif(Y41bUtils.obtenerFechaHoy());

			arbtramexpNuevo.setTrenvrem(Y41bConstantes.VALOR_SI);

			String tipoNotificacion = "";
			if (arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_SUBSANACION)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_SUBSANACION;
			} else if (arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_NO_ADHERIDA)
					|| arbtramexp.getTrcodigo()
							.equals(Y41bConstantes.TRAMITE_ARBITRAJE_RESULTADO_ANALISIS_ADHERIDA_LIM)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RESULTADO_ANALISIS;
			} else if (arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_ALEGACIONES)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RECEPCION_ALEGACIONES;
			} else if (arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_CONVENIO_ARBITRAL;
			} else if (arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_CITACION_AUDIENCIA;
			} else if (arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_CITACION_2AUDIENCIA;
			} else if (arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_SUSPENSION_AUDIENCIA)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_SUSPENSION_AUDIENCIA;
			} else if (arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_CITACION_A_PRUEBA;
			} else if (arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RECEPCION_INFORME_PERICIAL;
			} else if (arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_PAGO_PERICIAL;
			} else if (arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RESOLUCION;
			} else if (arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_LAUDO;
			} else if (arbtramexp.getTrcodigo()
					.equals(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION;
			} else if (arbtramexp.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_ACLARACION;
			} else if (arbtramexp.getTrcodigo()
					.equals(Y41bConstantes.TRAMITE_ARBITRAJE_REQUERIMIENTOACREDITACIONREPRESENTACION)
					|| arbtramexp.getTrcodigo().equals(
							Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_REQUERIMIENTO_ACREDITACION;
			} else if (arbtramexp.getTrcodigo()
					.equals(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_COPIA_EXPE)) {
				tipoNotificacion = Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_RESOLUCION;
			}

			arbtramexpNuevo.setTrtiponotplatea(tipoNotificacion);
			arbtramexpNuevo.setTridnotifplatea(tipoNotificacion);
			arbtramexpNuevo.setTruaidinterv(arbinterv.getUaidinterv());
			arbtramexpNuevo = this.add(arbtramexpNuevo);

			// 1.2 Hay que relacionar los documentos de la decision con
			// el tramite de notificacion
			// Recupero los documentos
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(arbtramexp.getTrid().toString());
			List<Arbdoctemp> documentos = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux, null);

			// Relaciono tramite - documento
			if (documentos != null && documentos.size() > 0) {
				for (Arbdoctemp documento : documentos) {
					if (Y41bUtils.esNullOCadenaVacia(documento.getX5destino())
							|| documento.getX5destino().equals(arbinterv.getUatipointerv())) {
						this.arbdoctempDao.insertArbDocTramite(arbtramexpNuevo.getTrid(), documento.getX5codocumento(),
								Y41bConstantes.TIPO_PROC_ARBITRAJE);
					}
				}
			}

			// Si el trmite es de citacin, a parte de adjuntar los
			// documentos
			// propios del trmite hay que aadir los del trmite de
			// designacin
			if (Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA.equals(arbtramexp.getTrcodigo())) {
				Arbtramexp tramiteDesignacion = new Arbtramexp();
				tramiteDesignacion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
				Pagination pagination = new Pagination();
				pagination.setSidx("TRID");
				pagination.setSord("DESC");
				List<Arbtramexp> ltramiteDesignacion = arbtramexpDao.findAll(tramiteDesignacion, pagination);
				if (ltramiteDesignacion != null && ltramiteDesignacion.size() > 0) {
					for (Arbtramexp trdesignacion : ltramiteDesignacion) {
						if (arbtramexpNuevo.getSolarb().getArbexp().getExcodigo()
								.equals(trdesignacion.getSolarb().getArbexp().getExcodigo())) {
							tramiteDesignacion = trdesignacion;
							break;
						}
					}
					if (tramiteDesignacion != null && tramiteDesignacion.getTrid() != null) {
						this.adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(tramiteDesignacion.getTrid().toString(),
								arbtramexpNuevo.getTrid().toString());
					}
				}
				// 0150948: Evolutivo Arbitraje Marzo-2020
				// 2.4
				// aadir todo documento de la parte reclamente y reclamado para
				// destinatario arbitro
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO.equalsIgnoreCase(arbinterv.getUatipointerv())) {
					this.adjuntarDocumentosDeUnOrigenAUnTramiteAutomaticamente(
							Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE, arbtramexpNuevo.getTrid().toString(),
							arbtramexp.getSolarb().getSacodigo());
					this.adjuntarDocumentosDeUnOrigenAUnTramiteAutomaticamente(
							Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO, arbtramexpNuevo.getTrid().toString(),
							arbtramexp.getSolarb().getSacodigo());
				}
				// 0150948: Evolutivo Arbitraje Marzo-2020
				// 2.4
			}

			// Si el tramite es de convenio arbitral y el destinatario es
			// reclamante, aparte de adjuntar los documentos propios del tramite
			// hay que anyadir los del tramite de aceptacion de arbitraje
			// 0155673: anyadimos que si es una resolucion tmb haga esto
			if ((Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL.equals(arbtramexp.getTrcodigo())
					|| Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(arbtramexp.getTrcodigo()))
					&& (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
							|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
									.equals(arbinterv.getUatipointerv()))) {
				Arbtramexp tramiteAceptacion = new Arbtramexp();
				tramiteAceptacion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE);
				Pagination pagination = new Pagination();
				pagination.setSidx("TRID");
				pagination.setSord("DESC");
				List<Arbtramexp> ltramiteAceptacion = arbtramexpDao.findAll(tramiteAceptacion, pagination);
				if (ltramiteAceptacion != null && ltramiteAceptacion.size() > 0) {
					for (Arbtramexp traceptacion : ltramiteAceptacion) {
						if (arbtramexpNuevo.getSolarb().getArbexp().getExcodigo()
								.equals(traceptacion.getSolarb().getArbexp().getExcodigo())) {
							tramiteAceptacion = traceptacion;
							break;
						}
					}
					// 0151153: Convenio arbitral - Error al tramitar
					// Se controla que si no encuentra tramite de aceptacion no
					// haga la copia de documentos de un tramite a otro
					if (tramiteAceptacion != null && tramiteAceptacion.getTrid() != null) {
						this.adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(tramiteAceptacion.getTrid().toString(),
								arbtramexpNuevo.getTrid().toString());
					}
				}
			}

			// 0150948: Evolutivo Arbitraje Marzo-2020
			// 2.1. Nuevo tipo de alegacin que no genere comunicacin a la otra
			// parte
			// Si el trmite es de resolucion, a parte de adjuntar los
			// documentos
			// propios del trmite hay que aadir las alegaciones de un tramite
			// de aporte de documentacion
			if (Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(arbtramexp.getTrcodigo())
					|| Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL.equals(arbtramexp.getTrcodigo())) {

				this.adjuntarAlegacionesAUnTramiteAutomaticamente(arbtramexpNuevo.getTrid().toString(),
						arbtramexp.getSolarb().getSacodigo());

				this.adjuntarRechazosAUnTramiteAutomaticamente(arbtramexpNuevo.getTrid().toString(),
						arbtramexp.getSolarb().getSacodigo());

			}
			// 0150948: Evolutivo Arbitraje Marzo-2020
			// 2.1. Nuevo tipo de alegacin que no genere comunicacin a la otra
			// parte

			this.calcularEstadoTramiteGenerado(arbtramexpNuevo);

			return arbtramexpNuevo;

		} catch (Exception e) {
			Arbtramexp2ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	// 0150948: Evolutivo Arbitraje Marzo-2020
	// 2.1. Nuevo tipo de alegacin que no genere comunicacin a la otra parte
	/**
	 * adjuntarAlegacionesAUnTramiteAutomaticamente
	 * 
	 * @param tridDestino
	 *            String
	 */
	private void adjuntarAlegacionesAUnTramiteAutomaticamente(String tridDestino, String excodigo) {

		this.arbdoctempDao.copiaArbDocAlegacion(tridDestino, excodigo);
	}

	/**
	 * adjuntarRechazosAUnTramiteAutomaticamente
	 * 
	 * @param tridDestino
	 *            String
	 */
	private void adjuntarRechazosAUnTramiteAutomaticamente(String tridDestino, String excodigo) {

		this.arbdoctempDao.copiaArbDocRechazo(tridDestino, excodigo);
	}

	/**
	 * adjuntarRechazosAUnTramiteAutomaticamente
	 * 
	 * @param origen
	 *            String
	 * @param tridDestino
	 *            String
	 */
	private void adjuntarDocumentosDeUnOrigenAUnTramiteAutomaticamente(String origen, String tridDestino,
			String excodigo) {
		this.arbdoctempDao.copiaArbDocOrigen(origen, tridDestino, excodigo);
	}

	// 0150948: Evolutivo Arbitraje Marzo-2020
	// 2.1. Nuevo tipo de alegacin que no genere comunicacin a la otra parte

	/**
	 * adjuntarDocumentosDeUnTramiteAOtroAutomaticamente
	 * 
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 */
	public void adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(String tridOrigen, String tridDestino) {

		this.arbdoctempDao.copiaArbDocTramite(tridOrigen, tridDestino);
	}

	/**
	 * adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente
	 * 
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 * @param tipo
	 *            String
	 */
	public void adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente(String tridOrigen, String tridDestino,
			String tipo) {

		this.arbdoctempDao.copiaArbDocTramiteDeUnTipo(tridOrigen, tridDestino, tipo);
	}

	/**
	 * Metodo que actualiza el estado de los tramites generados
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @throws SQLException
	 *             SQLException
	 */
	public void calcularEstadoTramiteGenerado(Arbtramexp arbtramexp) throws SQLException {
		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(arbtramexp.getTrestado())) {

			// Validacion: Debe haber almenos 1 documento
			TramiteComun tramiteComunAux = new TramiteComun();
			tramiteComunAux.setIdTramite(arbtramexp.getTrid().toString());

			List<Arbdoctemp> listDocumentosTramite = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux, null);

			boolean todosFirmados = true;
			if (listDocumentosTramite != null && listDocumentosTramite.size() > 0) {
				for (int i = 0; i < listDocumentosTramite.size(); i++) {
					if (listDocumentosTramite.get(i).getX5estadodocumento() != null && !listDocumentosTramite.get(i)
							.getX5estadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO)) {
						todosFirmados = false;
						break;
					}
				}
			}
			if (todosFirmados) {
				boolean firmado = false;
				if (listDocumentosTramite != null && listDocumentosTramite.size() > 0) {
					for (int i = 0; i < listDocumentosTramite.size(); i++) {
						if (listDocumentosTramite.get(i).getX5estadodocumento() != null) {
							firmado = true;
							break;
						}
					}
				}

				if (firmado) {
					arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
				} else {
					arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				}

			} else {
				boolean pendienteFirma = false;
				if (listDocumentosTramite != null && listDocumentosTramite.size() > 0) {
					for (int i = 0; i < listDocumentosTramite.size(); i++) {
						if (listDocumentosTramite.get(i).getX5estadodocumento() != null) {
							pendienteFirma = true;
							break;
						}
					}
				}

				if (pendienteFirma) {
					arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
				} else {
					arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				}
			}
		}

		this.arbtramexpDao.update(arbtramexp);
	}

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addTramiteAdjuntarDocsTableTemporal(TramiteComun tramiteComun) {
		this.adjuntardocsDao.removeAdjuntarDocsTramite(tramiteComun);
		this.arbdoctempDao.addArbAdjuntarDocs(tramiteComun);
	}

	// 0155021
	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addTramiteAdjuntarDocsFirmaArbitrosTemporal(TramiteComun tramiteComun) {

		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5tramite(tramiteComun.getIdTramite());
		documentoHecho.setQ5hdcodigo(tramiteComun.getIdExpediente());
		// borramos de la temporal todo lo que encontremos la final que sea de
		// ese
		// tramite
		List<DocumentoHecho> listParaBorrarDocumentosFirmaArbitros = this.documentoHechoDao.findAll(documentoHecho,
				null);
		for (DocumentoHecho documentoParaBorrarDocumentosFirmaArbitrosTemp : listParaBorrarDocumentosFirmaArbitros) {
			DocumentosFirmaArbitrosTemp docuABorrar = new DocumentosFirmaArbitrosTemp();
			docuABorrar.setIddocumentosfirmaarbtemp(documentoParaBorrarDocumentosFirmaArbitrosTemp.getQ5codocumento());
			this.documentosFirmaArbitrosTempDao.remove(docuABorrar);
		}
		Arbdoctemp ajuntardocsDocumentosFirmaArbitros = new Arbdoctemp();

		ajuntardocsDocumentosFirmaArbitros.setArbtramexp(new Arbtramexp(tramiteComun.getIdTramite()));
		List<Arbdoctemp> listArbdoctempdocs = this.arbdoctempDao.findAll(ajuntardocsDocumentosFirmaArbitros, null);
		// insertamos en la temporal todo lo que encontremos en la final
		for (Arbdoctemp documentoAInsertarDocumentosFirmaArbitros : listArbdoctempdocs) {
			DocumentosFirmaArbitrosTemp docuAInsertar = new DocumentosFirmaArbitrosTemp();
			docuAInsertar.setIddocumentosfirmaarbtemp(documentoAInsertarDocumentosFirmaArbitros.getX5codocumento());
			DocumentosFirmaArbitros docuBuscar = new DocumentosFirmaArbitros();
			docuBuscar.setIddocumentosfirmaarb(documentoAInsertarDocumentosFirmaArbitros.getX5codocumento());
			docuBuscar = this.documentosFirmaArbitrosDao.find(docuBuscar);
			if (docuBuscar != null) {
				this.documentosFirmaArbitrosTempDao.add(docuAInsertar);

			}

		}
	}

	// 0155021
	/**
	 * Actualizar el expediente.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param tipo
	 *            tipo
	 * @param fase
	 *            fase
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	public Arbtramexp sugiereTramiteAutomaticamente(Arbtramexp arbtramexp, String tipo, String fase, boolean forzar)
			throws Exception {

		try {

			Solarb solarb = new Solarb();
			solarb.setSacodigo(arbtramexp.getSolarb().getSacodigo());
			Arbtramexp arbtramexpNuevo = new Arbtramexp();

			// Controlamos que si ya existe un trmite de ese tipo, no se vuelva
			// a generar a excepcin del BOPV
			Arbtramexp arbtramexpAux = new Arbtramexp();
			arbtramexpAux.setSolarb(solarb);
			arbtramexpAux.setTrcodigo(tipo);
			Long cont = this.arbtramexpDao.findAllCount(arbtramexpAux);
			if (forzar || cont.longValue() == 0L || tipo.equals(Y41bConstantes.TRAMITE_ARBITRAJE_ELABORACION_BOPVBOE)
					|| tipo.equals(Y41bConstantes.TRAMITE_ARBITRAJE_PUBLICACION_BOPVBOE)) {
				solarb = this.solarbDao.find(solarb);
				arbtramexpNuevo.setSolarb(solarb);
				arbtramexpNuevo.setTrcodigo(tipo);
				arbtramexpNuevo.setTrfecini(arbtramexp.getTrfecini());
				arbtramexpNuevo.setCensoMonitor(arbtramexp.getCensoMonitorEj());
				arbtramexpNuevo.setTrcodigorel(arbtramexp.getTrcodigo());
				if (!(Y41bConstantes.TRAMITE_ARBITRAJE_MEDIACION).equals(tipo)) {
					arbtramexpNuevo.setTrtridrel(arbtramexp.getTrid());
				}
				arbtramexpNuevo.setFase(arbtramexp.getFase());
				arbtramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
				if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(tipo)) {
					arbtramexpNuevo = this.arbtramexp4Service.obtenerDatosPorDefectoLaudo(arbtramexpNuevo);
				}
				if (Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION.equals(tipo)) {
					arbtramexpNuevo.setTrfecrecepcion(arbtramexp.getTrfecrecepcion());
					arbtramexpNuevo.setTrtiposolac(arbtramexp.getTrtiposolac());
				}
				if (Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL.equals(tipo)) {
					arbtramexpNuevo.setTrresppagoper(arbtramexp.getTrresppagoper());
					arbtramexpNuevo.setTrainstanciade(arbtramexp.getTrainstanciade());
				}
				if (Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE.equals(tipo)) {
					arbtramexpNuevo.setTrtipoarbitraje(this.arbintervService
							.dameTipoArbitrajeReclamadoCenso(arbtramexp.getSolarb().getSacodigo()));
				}
				arbtramexpNuevo = this.add(arbtramexpNuevo);

				this.actualizaFaseArbexpDesdeTramite(arbtramexpNuevo.getSolarb().getSacodigo(),
						arbtramexpNuevo.getTrcodigo());
			}

			return arbtramexpNuevo;

		} catch (Exception e) {
			Arbtramexp2ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param tipo
	 *            tipo
	 * @param fase
	 *            fase
	 * @param decision
	 *            decision
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	public Arbtramexp sugiereTramiteDecisionAutomaticamente(Arbtramexp arbtramexp, String tipo, String fase,
			String decision) throws Exception {

		try {

			Solarb solarb = new Solarb();
			solarb.setSacodigo(arbtramexp.getSolarb().getSacodigo());
			solarb = this.solarbDao.find(solarb);

			Arbtramexp arbtramexpNuevo = new Arbtramexp();
			arbtramexpNuevo.setSolarb(solarb);
			arbtramexpNuevo.setTrcodigo(tipo);
			arbtramexpNuevo.setTrfecini(arbtramexp.getTrfecini());
			arbtramexpNuevo.setCensoMonitor(arbtramexp.getCensoMonitorEj());
			arbtramexpNuevo.setTrcodigorel(arbtramexp.getTrcodigo());
			arbtramexpNuevo.setTrtridrel(arbtramexp.getTrid());
			arbtramexpNuevo.setFase(new Fase(fase));
			arbtramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
			arbtramexpNuevo.setTrresotipo(decision);
			arbtramexpNuevo.setTrresofecha(arbtramexp.getTrfecaudiencia());
			arbtramexpNuevo = this.add(arbtramexpNuevo);

			this.actualizaFaseArbexpDesdeTramite(arbtramexpNuevo.getSolarb().getSacodigo(),
					arbtramexpNuevo.getTrcodigo());

			return arbtramexpNuevo;

		} catch (Exception e) {
			Arbtramexp2ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * 
	 * @param arbtramexp
	 *            arbtramexp
	 * @param solarb
	 *            solarb
	 * @param tipo
	 *            tipo
	 * @throws Exception
	 *             Exception
	 */
	public void generarNotificacionComunicacion(Arbtramexp arbtramexp, Solarb solarb, String tipo) throws Exception {

		boolean not = false;
		boolean continuar = false;
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setSolarb(solarb);
		if (!Y41bUtils.esNullOCadenaVacia(tipo)) {
			arbinterv.setUatipointerv(tipo);
		}
		List<Arbinterv> listaIntervientes = this.arbintervDao.findAll(arbinterv, null);
		if (listaIntervientes != null) {
			for (int i = 0; i < listaIntervientes.size(); i++) {
				arbinterv = (Arbinterv) listaIntervientes.get(i);
				/*
				 * 
				 * para cada interviniente sugiero una notificacion o una
				 * comunicacion
				 */
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())) {
					continuar = true;
					if (Y41bConstantes.NOTIFICACION.equals(arbtramexp.getTrnotcomreclamado())) {
						not = true;
					} else {
						not = false;
					}
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())) {
					continuar = true;
					if (Y41bConstantes.NOTIFICACION.equals(arbtramexp.getTrnotcomreclamante())) {
						not = true;
					} else {
						not = false;
					}
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO.equals(arbinterv.getUatipointerv())) {
					continuar = true;
					if (Y41bConstantes.NOTIFICACION.equals(arbtramexp.getTrnotcomterceros())) {
						not = true;
					} else {
						not = false;
					}
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS.equals(arbinterv.getUatipointerv())) {
					Organismo organismo = new Organismo();
					organismo.setEntidadId(arbinterv.getUaentidadId());
					organismo = this.organismoDao.findOrganismoById(organismo);
					if (Y41bConstantes.OFICINA_KONTSUMOBIDE_ALAVA.equals(organismo.getEntidadId())
							|| Y41bConstantes.OFICINA_KONTSUMOBIDE_BIZKAIA.equals(organismo.getEntidadId())
							|| Y41bConstantes.OFICINA_KONTSUMOBIDE_GIPUZKOA.equals(organismo.getEntidadId())
							|| Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI.equals(organismo.getCodOrg())
					// ||
					// Y41bConstantes.CODIGO_ORGANISMO_SSCC_CONTROLMERCADO.equals(organismo.getCodOrg())
					) {
						continuar = false;
					} else {
						continuar = true;
					}
					if (Y41bConstantes.NOTIFICACION.equals(arbtramexp.getTrnotcomterceros())) {
						not = true;
					} else {
						not = false;
					}
				}
				if (continuar) {
					if (not) {
						this.sugiereTramiteNotificacionAutomaticamente(arbtramexp, arbinterv);
					} else {
						this.sugiereTramiteComunicacionAutomaticamente(arbtramexp, arbinterv);
					}
				}
			}
		}
	}

	/**
	 * 
	 * @param arbtramexp
	 *            arbtramexp
	 * @param solarb
	 *            solarb
	 * @param tipo
	 *            tipo
	 * @throws Exception
	 *             Exception
	 */
	public void generarNotificacionComunicacionInterviniente(Arbtramexp arbtramexp, Solarb solarb, String tipo,
			Arbinterv arbinterv) throws Exception {

		boolean not = false;
		if (arbinterv != null) {
			/*
			 * para cada interviniente sugiero una notificacion o una
			 * comunicacion
			 */
			if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())) {
				if (Y41bConstantes.NOTIFICACION.equals(arbtramexp.getTrnotcomreclamado())) {
					not = true;
				} else {
					not = false;
				}
			} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())) {
				if (Y41bConstantes.NOTIFICACION.equals(arbtramexp.getTrnotcomreclamante())) {
					not = true;
				} else {
					not = false;
				}
			} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_PERITO.equals(arbinterv.getUatipointerv())) {
				if (Y41bConstantes.NOTIFICACION.equals(arbtramexp.getTrnotcomterceros())) {
					not = true;
				} else {
					not = false;
				}
			} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS.equals(arbinterv.getUatipointerv())) {
				if (Y41bConstantes.NOTIFICACION.equals(arbtramexp.getTrnotcomterceros())) {
					not = true;
				} else {
					not = false;
				}
			}
			if (not) {
				this.sugiereTramiteNotificacionAutomaticamente(arbtramexp, arbinterv);
			} else {
				this.sugiereTramiteComunicacionAutomaticamente(arbtramexp, arbinterv);
			}
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBRecepcionSolicitudCopiaExpe
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteRecepcionSolicitudCopiaExpe(TramiteARBRecepcionSolicitudCopiaExpe tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoARBRecepcionSolicitudCopiaExpe)
			throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_CIERRE_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrfecrecepcion(tramite.getFechaRecepcion());
		arbtramexp.setTrainstcopia(tramite.getOrigen());
		arbtramexp.setTrcopexptipo(tramite.getTipo());

		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUaidinterv(tramite.getOrigen());
		arbinterv = this.arbintervDao.find(arbinterv);
		if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
				|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE.equals(arbinterv.getUatipointerv())) {
			arbtramexp.setTrnotcomreclamante(tramite.getNotComSolicitante());
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
				|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO.equals(arbinterv.getUatipointerv())) {
			arbtramexp.setTrnotcomreclamado(tramite.getNotComSolicitante());
		} else {
			arbtramexp.setTrnotcomterceros(tramite.getNotComSolicitante());
		}

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			} else if (listDocumentoHecho != null) {
				boolean hayDoc = false;
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					if (Y41bConstantes.TIPO_DOC_ARB_RECEPCION_SOLICITUD_COPIA_EXPE
							.equals(listDocumentoHecho.get(i).getX5tipodocumento())) {
						hayDoc = true;
						break;
					}
				}
				if (!hayDoc) {
					throw new Y41bUDAException("error.solicitud.documentoRecepcionException", true, new Exception());
				}
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					this.generarNotificacionComunicacion(arbtramexp, solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					this.generarNotificacionComunicacion(arbtramexp, solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				} else {
					this.generarNotificacionComunicacionInterviniente(arbtramexp, solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_OTROS, arbinterv);
				}

				this.actualizaBandeja(arbtramexp);
				this.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            censoMonitor
	 * @return TramiteARBRecepcionSolicitudCopiaExpe
	 */
	public TramiteARBRecepcionSolicitudCopiaExpe findTramiteRecepcionSolicitudCopiaExpe(
			TramiteARBRecepcionSolicitudCopiaExpe tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			String trid = tramite.getIdTramite();
			arbtramexp.setTrid(trid);
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBRecepcionSolicitudCopiaExpe tramiteAux = new TramiteARBRecepcionSolicitudCopiaExpe();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setFechaRecepcion(arbtramexp.getTrfecrecepcion());
			tramiteAux.setOrigen(arbtramexp.getTrainstcopia());
			tramiteAux.setTipo(arbtramexp.getTrcopexptipo());

			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setUaidinterv(arbtramexp.getTrainstcopia());
			arbinterv = this.arbintervDao.find(arbinterv);
			if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
					|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
							.equals(arbinterv.getUatipointerv())) {
				tramiteAux.setNotComSolicitante(arbtramexp.getTrnotcomreclamado());
			} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
					|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
							.equals(arbinterv.getUatipointerv())) {
				tramiteAux.setNotComSolicitante(arbtramexp.getTrnotcomreclamante());
			} else {
				tramiteAux.setNotComSolicitante(arbtramexp.getTrnotcomterceros());
			}

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

			if (this.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			Arbtramexp2ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * 
	 * @param tramiteComun
	 *            tramiteComun TramiteComun
	 * @param anyadirPlantilla
	 *            String
	 * @return List<Arbdoctemp>
	 */
	public List<Arbdoctemp> tratarDocumentosTemporal(TramiteComun tramiteComun, String anyadirPlantilla) {
		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.arbdoctempDao.findAllDocumentosEliminados(tramiteComun, null);

		this.arbdoctempDao.removeArbDocTramite(tramiteComun);
		// INICIO Codigo sustituido
		// this.arbdoctempDao.removeDocumentosHechoAdjuntarDocs(tramiteComun);
		// FIN Codigo sustituido
		// INICIO Se sustituye por
		DocumentoHecho documentoHecho = new DocumentoHecho();
		documentoHecho.setQ5tramite(tramiteComun.getIdTramite());
		documentoHecho.setQ5hdcodigo(tramiteComun.getIdExpediente());
		List<DocumentoHecho> listDocumentoHecho2 = this.documentoHechoDao.findAll(documentoHecho, null);

		for (DocumentoHecho documentoHechoAux : listDocumentoHecho2) {
			try {
				this.documentoHechoDao.remove(documentoHechoAux);
			} catch (DataIntegrityViolationException dataIntegrityViolationException) {
				throw new Y41bUDAException("error.solicitud.documentoAdjuntadoException", true, new Exception());
			}
		}
		// FIN Se sustituye por
		this.arbdoctempDao.addDocumentosHechoAdjuntarDocs(tramiteComun);
		this.arbdoctempDao.addAdjuntarDocsArbDocTramite(tramiteComun);

		// borrar temporal
		if (!Y41bConstantes.VALOR_SI.equals(anyadirPlantilla)) {
			this.adjuntardocsDao.removeAdjuntarDocsTramite(tramiteComun);
		}

		return listArbdoctempEliminados;

	}

	/**
	 * 
	 * @param arbtramexp
	 *            arbtramexp
	 * @param tramiteComun
	 *            tramiteComun
	 * @param listDocumentoHecho
	 *            listDocumentoHecho
	 * @param isDocPendienteFirma
	 *            isDocPendienteFirma
	 * @throws Exception
	 *             Exception
	 */
	public void guardarTramite(Arbtramexp arbtramexp, TramiteComun tramiteComun, List<Arbdoctemp> listDocumentoHecho,
			boolean isDocPendienteFirma) throws Exception {

		this.actualizaBandeja(arbtramexp);

		if (isDocPendienteFirma) {

			this.actualizarBandejaFirma(listDocumentoHecho, tramiteComun, arbtramexp.getFase().getFcodigo(),
					arbtramexp.getTrcodigo());

			// 0155021 actualizamos la bandeja de los arbitros || comentamos
			// esto para que no haga nada con el portafirmas deshabilitado
			if (Y41bConstantes.PORTAFIRMAS_ARBITROS_HABILITADO) {
				if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(arbtramexp.getTrcodigo())) {
					Arbtramexp2ServiceImpl.logger
							.info("PORTAFIRMAS -Arbtramexp4ServiceImpl -guardarTramite. he entrado por donde SI hay doc pendiente de firma"
									+ listDocumentoHecho);
					this.actualizarBandejaFirmaArbitraje(listDocumentoHecho, tramiteComun,
							arbtramexp.getFase().getFcodigo(), arbtramexp.getTrcodigo());
				}
			}
			// 0155021 actualizamos la bandeja de los arbitros

		} else {
			this.actualizaBandeja(arbtramexp);
			BandejaFirma bandejaFirma = new BandejaFirma();
			bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
			bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

			// 0155021 quitamos los registros de la bandeja de arbitros
			if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(arbtramexp.getTrcodigo())) {
				Arbtramexp2ServiceImpl.logger
						.info("PORTAFIRMAS -Arbtramexp2ServiceImpl - guardarTramite. he entrado por donde NO hay doc pendiente de firma"
								+ listDocumentoHecho);
				BandejaFirmaArbitraje bandejaFirmaArbitraje = new BandejaFirmaArbitraje();
				bandejaFirmaArbitraje.setIdtramitehecho(tramiteComun.getIdTramite());
				// bandejaFirmaArbitraje.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaArbitrajeDao.removeBandejaFirmaExpedientePendientes(bandejaFirmaArbitraje);
			}

			// 0155021 quitamos los registros de la bandeja de arbitros

		}
	}

	/**
	 * 
	 * @param listDocumentoHecho
	 *            List<Arbdoctemp>
	 * @return tramite
	 */
	public boolean hayDocsPendienteFirma(List<Arbdoctemp> listDocumentoHecho) {

		// Miramos si hay algun documento pendiente de firma o denegada
		boolean isDocPendienteFirma = false;

		if (listDocumentoHecho != null && listDocumentoHecho.size() > 0) {
			Arbdoctemp documentoHecho = null;
			for (int i = 0; i < listDocumentoHecho.size(); i++) {
				documentoHecho = listDocumentoHecho.get(i);
				if (Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA.equals(documentoHecho.getX5estadodocumento())
						|| Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA
								.equals(documentoHecho.getX5estadodocumento())) {
					isDocPendienteFirma = true;
					break;
				}
			}
		}
		// Miramos si hay algun documento pendiente de firma
		return isDocPendienteFirma;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBRecepcionSolicitudAclaracion
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteRecepcionSolicitudAclaracion(TramiteARBRecepcionSolicitudAclaracion tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoARBRecepcionSolicitudAclaracion)
			throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(new Fase(Y41bConstantes.FASE_RESOLUCION_ARBITRAJE));
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrfecrecepcion(tramite.getFechaRecepcion());
		arbtramexp.setTrintervorigen(tramite.getOrigen());
		arbtramexp.setTrtiposolac(tramite.getTipo());
		arbtramexp.setTrresumen(Y41bUtils.stringToClob(tramite.getResumen()));

		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setUaidinterv(tramite.getOrigen());
		arbinterv = this.arbintervDao.find(arbinterv);
		// A la otra parte
		if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
				|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE.equals(arbinterv.getUatipointerv())) {
			arbtramexp.setTrnotcomreclamado(tramite.getNotComOtraParte());
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
				|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO.equals(arbinterv.getUatipointerv())) {
			arbtramexp.setTrnotcomreclamante(tramite.getNotComOtraParte());
		}

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			// Debe haber al menos un documento
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			} else if (listDocumentoHecho != null) {
				boolean hayDoc = false;
				for (int i = 0; i < listDocumentoHecho.size(); i++) {
					if (Y41bConstantes.TIPO_DOC_ARB_SOLICITUD_ACLARACION
							.equals(listDocumentoHecho.get(i).getX5tipodocumento())) {
						hayDoc = true;
						break;
					}
				}
				if (!hayDoc) {
					throw new Y41bUDAException("error.solicitud.documentoRecepcionException", true, new Exception());
				}
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
								.equals(arbinterv.getUatipointerv())) {
					this.generarNotificacionComunicacion(arbtramexp, solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
						|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
								.equals(arbinterv.getUatipointerv())) {
					this.generarNotificacionComunicacion(arbtramexp, solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
				}
				Arbtramexp laudo = new Arbtramexp();
				laudo.setSolarb(solarb);
				laudo.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO);
				List<Arbtramexp> lLaudo = this.arbtramexpDao.findAll(laudo, null);
				if (lLaudo != null && lLaudo.size() > 0) {
					if (lLaudo.get(0).getTrrespmotiv() != null) {
						BigDecimal idInterv = new BigDecimal(lLaudo.get(0).getTrrespmotiv());
						Arbinterv responsable = new Arbinterv(idInterv);
						responsable.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO);
						this.sugiereTramiteComunicacionAutomaticamente(arbtramexp, responsable);
					}
				}

				this.sugiereTramiteAutomaticamente(arbtramexp, Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION,
						Y41bConstantes.FASE_RESOLUCION_ARBITRAJE, false);
				this.actualizaBandeja(arbtramexp);
				this.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}

		} else {
			this.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}
		this.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            censoMonitor
	 * @return tramite
	 */
	public TramiteARBRecepcionSolicitudAclaracion findTramiteRecepcionSolicitudAclaracion(
			TramiteARBRecepcionSolicitudAclaracion tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			String trid = tramite.getIdTramite();
			arbtramexp.setTrid(trid);
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBRecepcionSolicitudAclaracion tramiteAux = new TramiteARBRecepcionSolicitudAclaracion();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setFechaRecepcion(arbtramexp.getTrfecrecepcion());
			tramiteAux.setOrigen(arbtramexp.getTrintervorigen());
			tramiteAux.setTipo(arbtramexp.getTrtiposolac());

			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setUaidinterv(arbtramexp.getTrintervorigen());
			arbinterv = this.arbintervDao.find(arbinterv);
			if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbinterv.getUatipointerv())
					|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
							.equals(arbinterv.getUatipointerv())) {
				tramiteAux.setNotComOtraParte(arbtramexp.getTrnotcomreclamado());
			} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbinterv.getUatipointerv())
					|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
							.equals(arbinterv.getUatipointerv())) {
				tramiteAux.setNotComOtraParte(arbtramexp.getTrnotcomreclamante());
			}

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));
			tramiteAux.setResumen(Y41bUtils.clobToString(arbtramexp.getTrresumen()));

			if (this.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			Arbtramexp2ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBMediacion
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteMediacion(TramiteARBMediacion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoARBMediacion) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp.setTrfeccitacion(tramite.getFecha());
		arbtramexp.setTrhoramediacioninicio(tramite.getHorainicio());
		arbtramexp.setTrhoramediacionfin(tramite.getHorafin());
		arbtramexp.setTrinterlocutor(Y41bUtils.stringToClob(tramite.getInterlocutor()));
		arbtramexp.setTrtel1mediacion(tramite.getTelefono1());
		arbtramexp.setTrtel2mediacion(tramite.getTelefono2());
		arbtramexp.setTrtel3mediacion(tramite.getTelefono3());
		arbtramexp.setTrresumen(Y41bUtils.stringToClob(tramite.getResumen()));
		arbtramexp = this.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		// Miramos si hay algun documento pendiente de firma o denegada
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.actualizaBandeja(arbtramexp);
				this.actualizaUltimoTramiteArbexp(arbtramexp);
				this.arbtramexp4Service.actualizaExpedienteTrasTramitar(arbtramexp);
			}
		} else {
			this.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.eliminarDocumentosDokusi(listArbdoctempEliminados);

		return arbtramexp;
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            censoMonitor
	 * @return TramiteARBMediacion
	 */
	public TramiteARBMediacion findTramiteMediacion(TramiteARBMediacion tramite, CensoMonitor monitor) {
		try {
			CensoMonitor censoMonitor = this.censoMonitorDao.find(monitor);
			Arbtramexp arbtramexp = new Arbtramexp();
			String trid = tramite.getIdTramite();
			arbtramexp.setTrid(trid);
			arbtramexp = this.arbtramexpDao.find(arbtramexp);

			TramiteARBMediacion tramiteAux = new TramiteARBMediacion();
			tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
			tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
			tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

			CensoMonitor instructorAsignado = new CensoMonitor();
			if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
				instructorAsignado = arbtramexp.getCensoMonitor();
			}
			tramiteAux.setInstructorAsignado(instructorAsignado);

			CensoMonitor instructorEjecucion = new CensoMonitor();
			if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
				instructorEjecucion = arbtramexp.getCensoMonitorEj();
			}
			tramiteAux.setInstructorEjecucion(instructorEjecucion);
			tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

			tramiteAux.setFecha(arbtramexp.getTrfeccitacion());
			tramiteAux.setHorainicio(arbtramexp.getTrhoramediacioninicio());
			tramiteAux.setHorafin(arbtramexp.getTrhoramediacionfin());

			tramiteAux.setTelefono1(arbtramexp.getTrtel1mediacion());
			tramiteAux.setTelefono2(arbtramexp.getTrtel2mediacion());
			tramiteAux.setTelefono3(arbtramexp.getTrtel3mediacion());

			tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));
			tramiteAux.setResumen(Y41bUtils.clobToString(arbtramexp.getTrresumen()));
			tramiteAux.setInterlocutor(Y41bUtils.clobToString(arbtramexp.getTrinterlocutor()));

			if (this.tratamientoSeguridad(arbtramexp, censoMonitor)) {
				tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
			} else {
				tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
			}
			return tramiteAux;
		} catch (Exception e) {
			Arbtramexp2ServiceImpl.logger.info(e.getMessage());
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoEditar
	 *            modo
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteGenerico(TramiteGenerico tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		this.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp = this.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		if (tramitar) {
			this.actualizaBandeja(arbtramexp);
			this.actualizaUltimoTramiteArbexp(arbtramexp);
		} else {
			this.actualizaBandeja(arbtramexp);
		}
		this.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * Inserta el documento recibido por parametro en la tabla temporal de
	 * adjuntar documentacion
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @param tramiteComun
	 *            TramiteComun
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void addDocumentosTableTemporal(List<DocumentoExpediente> listDocumentoExpediente,
			TramiteComun tramiteComun) {
		if (listDocumentoExpediente != null && listDocumentoExpediente.size() > 0) {
			Arbdoctemp documentoHechoAux = null;
			for (DocumentoExpediente documentoExpediente : listDocumentoExpediente) {
				documentoHechoAux = new Arbdoctemp();
				documentoHechoAux.setX5codocumento(documentoExpediente.getCodocumento());
				documentoHechoAux.setX5pcodigo(documentoExpediente.getPcodigo());
				try {
					this.arbdoctempDao.addAdjuntarDoc(documentoHechoAux, tramiteComun);
				} catch (DuplicateKeyException duplicateKeyException) {
					throw new Y41bUDAException("error.adjuntardocstramite.duplicateException", true, new Exception());
				}
			}
		}
	}

	/**
	 * Finds registro entrada document
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idInterviniente
	 *            String
	 * @return RegistroEntrada
	 * @throws Exception
	 *             Exception
	 */
	public RegistroEntrada getRegistroEntrada(TramiteComun tramiteComun, String idInterviniente) throws Exception {

		RegistroEntrada registroEntrada = new RegistroEntrada();

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		WSParamInputRegisterEx datas = new WSParamInputRegisterEx();

		Solarb solarbVO = new Solarb();
		solarbVO.setSacodigo(tramiteComun.getIdExpediente());

		solarbVO = this.solarbDao.find(solarbVO);

		datas.setUnitCode(Y41bConstantes.UNIDAD_ORGANICA_ARBITRAJE);
		datas.setDestination(Y41bConstantes.UNIDAD_ORGANICA_ARBITRAJE);

		ArrayOfWSParamPerson persons = new ArrayOfWSParamPerson();

		Arbinterv arbinterv = new Arbinterv();
		if (Y41bUtils.esNullOCadenaVacia(idInterviniente)) {

			arbinterv.setSolarb(new Solarb(tramiteComun.getIdExpediente()));
			arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
			List<Arbinterv> listaArbinterv = this.arbintervDao.findAll(arbinterv, null);
			if (listaArbinterv != null) {
				if (listaArbinterv.size() == 1) {
					arbinterv = (Arbinterv) listaArbinterv.get(0);
				}
			}
		} else {
			arbinterv.setSolarb(solarbVO);
			arbinterv.setUaidinterv(new BigDecimal(idInterviniente));
			arbinterv = this.arbintervDao.find(arbinterv);
		}

		WSParamPerson wSParamPerson = new WSParamPerson();
		StringBuffer sbPerson = new StringBuffer();
		if (Y41bUtils.isFilled(arbinterv.getUanif())) {
			sbPerson.append(arbinterv.getUanif());
			sbPerson.append(" - ");
		}
		if (Y41bUtils.isFilled(arbinterv.getUanoco())) {
			sbPerson.append(arbinterv.getUanoco());
			sbPerson.append(" ");
		} else {
			if (Y41bUtils.isFilled(arbinterv.getUanombre())) {
				sbPerson.append(arbinterv.getUanombre());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(arbinterv.getUaapellido1())) {
				sbPerson.append(arbinterv.getUaapellido1());
				sbPerson.append(" ");
			}
			if (Y41bUtils.isFilled(arbinterv.getUaapellido2())) {
				sbPerson.append(arbinterv.getUaapellido2());
				sbPerson.append(" ");
			}
		}

		wSParamPerson.setPersonName(sbPerson.toString());

		persons.getWSParamPerson().add(wSParamPerson);

		datas.setPersons(persons);

		StringBuffer sbMatter = new StringBuffer();
		sbMatter.append(Y41bConstantes.LITERAL_APORTACION_DOCUMENTACION_ES);
		sbMatter.append(" - [");
		sbMatter.append(Y41bConstantes.TIPO_PROC_ARBITRAJE);
		sbMatter.append("-");
		sbMatter.append(solarb.getSacoja()).append("-").append(solarb.getSanror()).append("-")
				.append(solarb.getSanran());
		sbMatter.append("]");
		datas.setMatter(sbMatter.toString());

		N61ServiceImpl n61Service = new N61ServiceImpl();
		WSInputRegister wSInputRegister = n61Service.wsNewInputRegister(datas);

		registroEntrada.setRegistryNumber(wSInputRegister.getNumber());
		registroEntrada.setRegistryDate(wSInputRegister.getDate().toGregorianCalendar().getTime());

		return registroEntrada;
	}

	/**
	 * Inserts a single row in the Arbtramexp table.
	 * 
	 * @param idioma
	 *            String
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteAdjuntarDocs(TramiteAdjuntarDocs tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {
		Arbtramexp arbtramexp = new Arbtramexp();

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		Arbtramexp arbtramexpAux = this.arbtramexpDao.find(arbtramexp);
		if (arbtramexpAux != null) {
			arbtramexp = arbtramexpAux;
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setFase(solarb.getArbexp().getFase());

		Arbexp arbexp = this.arbexpDao.find(new Arbexp(solarb.getSacodigo()));

		arbtramexp.setTrfecini(tramite.getFechaInicio());
		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(tramiteComun.getIdTipoTramite());
		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));

		// 0169289: Estudio de la Integracin SIR
		if (null != tramite.getIsSIR() && "" != tramite.getIsSIR()) {
			arbtramexp.setTrIsSir(tramite.getIsSIR());
		}
		// 0169289: Estudio de la Integracin SIR
		if (null != tramite.getIsSIRConNumRegEntOri() && "" != tramite.getIsSIRConNumRegEntOri()) {
			arbtramexp.setTrIsSirConNumRegEntOri(tramite.getIsSIRConNumRegEntOri());
		}

		arbtramexp = this.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				Y41bConstantes.VALOR_NO);

		/*
		 * PROPIO DEL TRAMITE
		 */
		// Validacion: Debe haber almenos 1 documento
		TramiteComun tramiteComunAux = new TramiteComun();
		tramiteComunAux.setIdTramite(tramiteComun.getIdTramite());

		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux, null);

		if (modoEditar != "AR" && listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
			throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
		}

		/* los avisos se tratan aqui */
		if (tramitar) {

			// Ya no se controla si esta o no dado de alta en Platea el
			// reclamado ya que se da de alta al actualizar mis gestiones
			if (Y41bConstantes.SI.equals(arbexp.getPlatea())) {

				this.actualizaExpedienteTrasAportacionDocumentacion(tramiteComunAux, arbexp, arbtramexp);

				// Subimos los documentos a dokusi
				this.arbtramexp3Service.registrarDocumentosDokusi(listDocumentoHecho, tramiteComun);
				/*
				 * al reves porque se puede haber sugerido el tramite de
				 * recepcion de recurso de alzada
				 */

				this.actualizaBandeja(arbtramexp);
				arbexp = this.actualizaUltimoTramiteArbexp(arbtramexp);

				listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux, null);

				if (arbtramexp.getTristelematica() == null) {
					this.arbtramexp4Service.actualizarMisGestionesAportaciondocumentacion(arbtramexp,
							listDocumentoHecho);
				}
			} else {
				throw new Y41bUDAException("error.notramitable", true, new Exception());
			}

		} else {
			this.actualizaBandeja(arbtramexp);
		}

		this.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;

	}

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAdjuntarDocs
	 */
	public TramiteAdjuntarDocs findTramiteAdjuntarDocs(TramiteAdjuntarDocs tramiteAdjuntarDocs,
			CensoMonitor censoMonitor) {
		Arbtramexp arbtramexp = new Arbtramexp();
		String trid = tramiteAdjuntarDocs.getIdTramite();
		arbtramexp.setTrid(trid);
		arbtramexp = this.arbtramexpDao.find(arbtramexp);

		TramiteAdjuntarDocs tramiteAux = new TramiteAdjuntarDocs();
		tramiteAux.setIdTramite(arbtramexp.getTrcodigo());
		tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
		tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
			instructorAsignado = arbtramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = arbtramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);
		tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

		tramiteAux.setIstelematico(arbtramexp.getTristelematica());

		tramiteAux.setIsSIR(arbtramexp.getTrIsSir());

		if (this.tratamientoSeguridad(arbtramexp, censoMonitor)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	/**
	 * Actualizar el expediente.
	 * 
	 * @param tramiteComunAux
	 *            the tramite comun aux
	 * @param arbexp
	 *            the arbexp Arbexp
	 * @param arbtramexp
	 *            the arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	private void actualizaExpedienteTrasAportacionDocumentacion(TramiteComun tramiteComunAux, Arbexp arbexp,
			Arbtramexp arbtramexp) throws Exception {

		List<Arbdoctemp> documentosAportados = this.arbdoctempDao.findAllDocumentosTramite(tramiteComunAux, null);
		if (documentosAportados != null) {
			for (int i = 0; i < documentosAportados.size(); i++) {
				Arbdoctemp arbdoc = (Arbdoctemp) documentosAportados.get(i);
				String tipoDocumento = arbdoc.getX5tipodocumento();
				if (Y41bConstantes.TIPO_DOC_ARB_DOCUMENTACION_SUBSANADA.equals(tipoDocumento)
						&& (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE.equals(arbdoc.getX5origen())
								|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE
										.equals(arbdoc.getX5origen()))) {
					// Documentos
					Arbtramexp recepcionSubsanacion = new Arbtramexp();
					recepcionSubsanacion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION);
					recepcionSubsanacion.setSolarb(new Solarb(arbexp.getExcodigo()));
					Pagination pagination = new Pagination();
					pagination.setSidx("TRFECALTA");
					pagination.setSord("DESC");
					List<Arbtramexp> lrecepcionSubsanacion = this.arbtramexpDao.findAll(recepcionSubsanacion,
							pagination);
					boolean hayTramite = false;
					if (lrecepcionSubsanacion != null && lrecepcionSubsanacion.size() > 0) {
						for (int j = 0; j < lrecepcionSubsanacion.size(); j++) {
							recepcionSubsanacion = lrecepcionSubsanacion.get(j);
							if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(recepcionSubsanacion.getTrestado())) {
								hayTramite = true;
								break;
							}
						}
					}
					if (!hayTramite) {
						recepcionSubsanacion = this.sugiereTramiteAutomaticamente(arbtramexp,
								Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION,
								Y41bConstantes.FASE_INICIO_ARBITRAJE, true);

					}
					// Datos del trmite
					recepcionSubsanacion.setTrfecrecepcion(arbdoc.getX5fecharegistroorigen() == null
							? arbdoc.getX5fechaentrada() : arbdoc.getX5fecharegistroorigen());
					Arbinterv arbinterv = new Arbinterv();
					arbinterv = this.arbintervDao.dameInterviniente(arbexp.getExcodigo(),
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
					recepcionSubsanacion.setTrintervorigen(arbinterv.getUaidinterv());
					this.arbtramexpDao.update(recepcionSubsanacion);
					this.arbdoctempDao.insertArbDocTramite(recepcionSubsanacion.getTrid(), arbdoc.getX5codocumento(),
							Y41bConstantes.TIPO_PROC_ARBITRAJE);
				} else if (Y41bConstantes.TIPO_DOC_ARB_ACEPTACION_ARBITRAJE.equals(tipoDocumento)
						&& (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO.equals(arbdoc.getX5origen())
								|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO
										.equals(arbdoc.getX5origen()))) {
					// Documentos
					Arbtramexp aceptacionArbitraje = new Arbtramexp();
					aceptacionArbitraje.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE);
					aceptacionArbitraje.setSolarb(new Solarb(arbexp.getExcodigo()));
					Pagination pagination = new Pagination();
					pagination.setSidx("TRFECALTA");
					pagination.setSord("DESC");
					List<Arbtramexp> laceptacionArbitraje = this.arbtramexpDao.findAll(aceptacionArbitraje, pagination);
					boolean hayTramite = false;
					if (laceptacionArbitraje != null && laceptacionArbitraje.size() > 0) {
						for (int j = 0; j < laceptacionArbitraje.size(); j++) {
							aceptacionArbitraje = laceptacionArbitraje.get(j);
							if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(aceptacionArbitraje.getTrestado())) {
								hayTramite = true;
								break;
							}
						}
					}
					if (!hayTramite) {
						aceptacionArbitraje = this.sugiereTramiteAutomaticamente(arbtramexp,
								Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE,
								Y41bConstantes.FASE_ANALISIS_ARBITRAJE, true);
					}
					aceptacionArbitraje.setTrfecrecepcion(arbdoc.getX5fecharegistroorigen() == null
							? arbdoc.getX5fechaentrada() : arbdoc.getX5fecharegistroorigen());
					this.arbtramexpDao.update(aceptacionArbitraje);
					this.arbdoctempDao.insertArbDocTramite(aceptacionArbitraje.getTrid(), arbdoc.getX5codocumento(),
							Y41bConstantes.TIPO_PROC_ARBITRAJE);
				} else if (Y41bConstantes.TIPO_DOC_ARB_INFORME_PERICIAL.equals(tipoDocumento)
						&& (Y41bConstantes.ORIGEN_ARB_APORTADO_PERITO.equals(arbdoc.getX5origen())
								|| Y41bConstantes.ORIGEN_ARB_APORTADO_ARBITRO.equals(arbdoc.getX5origen()))) {
					// Documentos
					Arbtramexp recepcionInformePericial = new Arbtramexp();
					recepcionInformePericial.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL);
					recepcionInformePericial.setSolarb(new Solarb(arbexp.getExcodigo()));
					Pagination pagination = new Pagination();
					pagination.setSidx("TRFECALTA");
					pagination.setSord("DESC");
					List<Arbtramexp> lrecepcionInformePericial = this.arbtramexpDao.findAll(recepcionInformePericial,
							pagination);
					boolean hayTramite = false;
					if (lrecepcionInformePericial != null && lrecepcionInformePericial.size() > 0) {
						for (int j = 0; j < lrecepcionInformePericial.size(); j++) {
							recepcionInformePericial = lrecepcionInformePericial.get(j);
							if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO
									.equals(recepcionInformePericial.getTrestado())) {
								hayTramite = true;
								break;
							}
						}
					}
					if (!hayTramite) {
						recepcionInformePericial = this.sugiereTramiteAutomaticamente(arbtramexp,
								Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL,
								Y41bConstantes.FASE_AUDIENCIA_ARBITRAJE, true);
					}
					// Datos del trmite
					recepcionInformePericial.setTrfecrecepcion(arbdoc.getX5fecharegistroorigen() == null
							? arbdoc.getX5fechaentrada() : arbdoc.getX5fecharegistroorigen());
					this.arbtramexpDao.update(recepcionInformePericial);
					this.arbdoctempDao.insertArbDocTramite(recepcionInformePericial.getTrid(),
							arbdoc.getX5codocumento(), Y41bConstantes.TIPO_PROC_ARBITRAJE);
				} else if (Y41bConstantes.TIPO_DOC_ARB_SOLICITUD_ACLARACION.equals(tipoDocumento)
						&& (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO.equals(arbdoc.getX5origen())
								|| Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE.equals(arbdoc.getX5origen())
								|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO
										.equals(arbdoc.getX5origen())
								|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE
										.equals(arbdoc.getX5origen()))) {
					// Documentos
					Arbtramexp recepcionSolicitudAclaracion = new Arbtramexp();
					recepcionSolicitudAclaracion
							.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION);
					recepcionSolicitudAclaracion.setSolarb(new Solarb(arbexp.getExcodigo()));
					Pagination pagination = new Pagination();
					pagination.setSidx("TRFECALTA");
					pagination.setSord("DESC");
					List<Arbtramexp> lrecepcionSolicitudAclaracion = this.arbtramexpDao
							.findAll(recepcionSolicitudAclaracion, pagination);
					boolean hayTramite = false;
					if (lrecepcionSolicitudAclaracion != null && lrecepcionSolicitudAclaracion.size() > 0) {
						for (int j = 0; j < lrecepcionSolicitudAclaracion.size(); j++) {
							recepcionSolicitudAclaracion = lrecepcionSolicitudAclaracion.get(j);

							if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO
									.equals(recepcionSolicitudAclaracion.getTrestado())) {
								Arbinterv arbinterv = new Arbinterv();
								arbinterv.setUaidinterv(recepcionSolicitudAclaracion.getTrintervorigen());
								arbinterv = this.arbintervDao.find(arbinterv);
								if (arbinterv != null) {
									String tipoInterv = null;
									if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE
											.equals(arbinterv.getUatipointerv())
											|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
													.equals(arbinterv.getUatipointerv())) {
										tipoInterv = Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE;
									} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO
											.equals(arbinterv.getUatipointerv())
											|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
													.equals(arbinterv.getUatipointerv())) {
										tipoInterv = Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO;
									}

									if (tipoInterv.equals(arbdoc.getX5origen())) {
										hayTramite = true;
										break;
									}
								}
							}
						}
					}
					if (!hayTramite) {
						recepcionSolicitudAclaracion = this.sugiereTramiteAutomaticamente(arbtramexp,
								Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION,
								Y41bConstantes.FASE_RESOLUCION_ARBITRAJE, true);
					}
					// Datos del trmite
					recepcionSolicitudAclaracion.setTrfecrecepcion(arbdoc.getX5fecharegistroorigen() == null
							? arbdoc.getX5fechaentrada() : arbdoc.getX5fecharegistroorigen());
					String tipoInterv = "";
					if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO.equals(arbdoc.getX5origen())
							|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO.equals(arbdoc.getX5origen())) {
						tipoInterv = Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO;
					} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE.equals(arbdoc.getX5origen())
							|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE
									.equals(arbdoc.getX5origen())) {
						tipoInterv = Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE;
					} else {
						tipoInterv = arbdoc.getX5origen();
					}
					Arbinterv arbinterv = new Arbinterv();
					arbinterv = this.arbintervDao.dameInterviniente(arbexp.getExcodigo(), tipoInterv);
					if (arbinterv != null) {
						recepcionSolicitudAclaracion.setTrintervorigen(arbinterv.getUaidinterv());
					}

					this.arbtramexpDao.update(recepcionSolicitudAclaracion);
					this.arbdoctempDao.insertArbDocTramite(recepcionSolicitudAclaracion.getTrid(),
							arbdoc.getX5codocumento(), Y41bConstantes.TIPO_PROC_ARBITRAJE);
				} else if (Y41bConstantes.TIPO_DOC_ARB_RECEPCION_ACLARACION.equals(tipoDocumento)
						&& Y41bConstantes.ORIGEN_ARB_APORTADO_ARBITRO.equals(arbdoc.getX5origen())) {
					// Documentos
					Arbtramexp recepcionAclaracion = new Arbtramexp();
					recepcionAclaracion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION);
					recepcionAclaracion.setSolarb(new Solarb(arbexp.getExcodigo()));
					Pagination pagination = new Pagination();
					pagination.setSidx("TRFECALTA");
					pagination.setSord("DESC");
					List<Arbtramexp> lrecepcionAclaracion = this.arbtramexpDao.findAll(recepcionAclaracion, pagination);
					boolean hayTramite = false;
					if (lrecepcionAclaracion != null && lrecepcionAclaracion.size() > 0) {
						for (int j = 0; j < lrecepcionAclaracion.size(); j++) {
							recepcionAclaracion = lrecepcionAclaracion.get(j);
							if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(recepcionAclaracion.getTrestado())) {
								hayTramite = true;
								break;
							}
						}
					}
					if (!hayTramite) {
						recepcionAclaracion = this.sugiereTramiteAutomaticamente(arbtramexp,
								Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION, Y41bConstantes.FASE_RESOLUCION_ARBITRAJE,
								true);
					}
					// Datos del trmite
					recepcionAclaracion.setTrfecrecepcion(arbdoc.getX5fecharegistroorigen() == null
							? arbdoc.getX5fechaentrada() : arbdoc.getX5fecharegistroorigen());
					this.arbtramexpDao.update(recepcionAclaracion);
					this.arbdoctempDao.insertArbDocTramite(recepcionAclaracion.getTrid(), arbdoc.getX5codocumento(),
							Y41bConstantes.TIPO_PROC_ARBITRAJE);
				} else if (Y41bConstantes.TIPO_DOC_ARB_ALEGACIONES.equals(tipoDocumento)
						&& (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO.equals(arbdoc.getX5origen())
								|| Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE.equals(arbdoc.getX5origen())
								|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE
										.equals(arbdoc.getX5origen())
								|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO
										.equals(arbdoc.getX5origen()))) {
					// Obtener fase del expediente
					// Documentos
					Arbtramexp recepcionAlegaciones = new Arbtramexp();
					recepcionAlegaciones.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_ALEGACIONES);
					recepcionAlegaciones.setSolarb(new Solarb(arbexp.getExcodigo()));
					Pagination pagination = new Pagination();
					pagination.setSidx("TRFECALTA");
					pagination.setSord("DESC");
					List<Arbtramexp> lrecepcionAlegaciones = this.arbtramexpDao.findAll(recepcionAlegaciones,
							pagination);
					boolean hayTramite = false;
					if (lrecepcionAlegaciones != null && lrecepcionAlegaciones.size() > 0) {
						for (int j = 0; j < lrecepcionAlegaciones.size(); j++) {
							recepcionAlegaciones = lrecepcionAlegaciones.get(j);
							if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(recepcionAlegaciones.getTrestado())) {
								Arbinterv arbinterv = new Arbinterv();
								arbinterv.setUaidinterv(recepcionAlegaciones.getTrintervorigen());
								arbinterv = this.arbintervDao.find(arbinterv);
								if (arbinterv != null) {
									String tipoInterv = null;
									if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE
											.equals(arbinterv.getUatipointerv())
											|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE
													.equals(arbinterv.getUatipointerv())) {
										tipoInterv = Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE;
									} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO
											.equals(arbinterv.getUatipointerv())
											|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO
													.equals(arbinterv.getUatipointerv())) {
										tipoInterv = Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO;
									}

									if (tipoInterv.equals(arbdoc.getX5origen())) {
										hayTramite = true;
										break;
									}
								}
							}
						}
					}
					if (!hayTramite) {
						recepcionAlegaciones = this.sugiereTramiteAutomaticamente(arbtramexp,
								Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_ALEGACIONES,
								arbtramexp.getFase().getFcodigo(), true);
					}
					// Datos del trmite
					recepcionAlegaciones.setTrfecrecepcion(arbdoc.getX5fecharegistroorigen() == null
							? arbdoc.getX5fechaentrada() : arbdoc.getX5fecharegistroorigen());
					String tipoInterv = "";
					String tipoAlega = "";
					if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO.equals(arbdoc.getX5origen())
							|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO.equals(arbdoc.getX5origen())) {
						tipoInterv = Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO;
						tipoAlega = Y41bConstantes.ARB_TIPO_ALEGACION_RECONVENCION;
					} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE.equals(arbdoc.getX5origen())
							|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE
									.equals(arbdoc.getX5origen())) {
						tipoInterv = Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE;
						tipoAlega = Y41bConstantes.ARB_TIPO_ALEGACION_PRETENSION;
					} else {
						tipoInterv = arbdoc.getX5origen();
					}
					Arbinterv arbinterv = new Arbinterv();
					arbinterv = this.arbintervDao.dameInterviniente(arbexp.getExcodigo(), tipoInterv);
					if (arbinterv != null) {
						recepcionAlegaciones.setTrintervorigen(arbinterv.getUaidinterv());
					}
					recepcionAlegaciones.setTrtipoalega(tipoAlega);
					this.arbtramexpDao.update(recepcionAlegaciones);
					this.arbdoctempDao.insertArbDocTramite(recepcionAlegaciones.getTrid(), arbdoc.getX5codocumento(),
							Y41bConstantes.TIPO_PROC_ARBITRAJE);
				} else if (Y41bConstantes.TIPO_DOC_ARB_RECEPCION_SOLICITUD_COPIA_EXPE.equals(tipoDocumento)) {
					// Obtener fase del expediente
					// Documentos
					Arbtramexp recepcionCopiaExpe = new Arbtramexp();
					recepcionCopiaExpe.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_COPIA_EXPE);
					recepcionCopiaExpe.setSolarb(new Solarb(arbexp.getExcodigo()));
					Pagination pagination = new Pagination();
					pagination.setSidx("TRFECALTA");
					pagination.setSord("DESC");
					List<Arbtramexp> lrecepcionCopiaExpe = this.arbtramexpDao.findAll(recepcionCopiaExpe, pagination);
					boolean hayTramite = false;
					if (lrecepcionCopiaExpe != null && lrecepcionCopiaExpe.size() > 0) {
						for (int j = 0; j < lrecepcionCopiaExpe.size(); j++) {
							recepcionCopiaExpe = lrecepcionCopiaExpe.get(j);
							if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(recepcionCopiaExpe.getTrestado())) {
								hayTramite = true;
								break;
							}
						}
					}
					if (!hayTramite) {
						recepcionCopiaExpe = this.sugiereTramiteAutomaticamente(arbtramexp,
								Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_COPIA_EXPE,
								Y41bConstantes.FASE_CIERRE_ARBITRAJE, true);
					}
					// Datos del trmite
					recepcionCopiaExpe.setTrfecrecepcion(arbdoc.getX5fecharegistroorigen() == null
							? arbdoc.getX5fechaentrada() : arbdoc.getX5fecharegistroorigen());
					String tipoInterv = "";
					if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO.equals(arbdoc.getX5origen())
							|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO.equals(arbdoc.getX5origen())) {
						tipoInterv = Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO;
					} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE.equals(arbdoc.getX5origen())
							|| Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE
									.equals(arbdoc.getX5origen())) {
						tipoInterv = Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE;
					} else {
						tipoInterv = arbdoc.getX5origen();
					}
					Arbinterv arbinterv = new Arbinterv();
					if (arbdoc.getX5idinterviniente() != null) {
						arbinterv.setUaidinterv(new BigDecimal(arbdoc.getX5idinterviniente()));
						arbinterv = this.arbintervDao.find(arbinterv);
					} else {
						arbinterv = this.arbintervDao.dameInterviniente(arbexp.getExcodigo(), tipoInterv);
					}
					if (arbinterv != null) {
						recepcionCopiaExpe.setTrainstcopia(arbinterv.getUaidinterv());
					}
					this.arbtramexpDao.update(recepcionCopiaExpe);
					this.arbdoctempDao.insertArbDocTramite(recepcionCopiaExpe.getTrid(), arbdoc.getX5codocumento(),
							Y41bConstantes.TIPO_PROC_ARBITRAJE);
				} else if (Y41bConstantes.TIPO_DOC_ARB_ACREDITACION_REPRESENTACION.equals(tipoDocumento)) {
					Solarb solarb = new Solarb();
					solarb.setSacodigo(arbtramexp.getSolarb().getSacodigo());
					solarb = this.solarbDao.find(solarb);

					String participacion = null;

					if (Y41bConstantes.TIPO_DOC_ARB_ACREDITACION_REPRESENTACION.equals(arbdoc.getX5tipodocumento())) {
						if (Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMADO.equals(arbdoc.getX5origen())) {
							arbtramexp.setTipoDestOrigen(
									Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO);
							participacion = "RADO";
						} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO.equals(arbdoc.getX5origen())) {
							arbtramexp.setTipoDestOrigen(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
							participacion = "RADO";
						} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_REPRESENTADO_RECLAMANTE
								.equals(arbdoc.getX5origen())) {
							arbtramexp.setTipoDestOrigen(
									Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);
							participacion = "RNTE";
						} else if (Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE.equals(arbdoc.getX5origen())) {
							arbtramexp.setTipoDestOrigen(Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
							participacion = "RNTE";
						}

					}

					Arbtramexp arbtramexpNuevo = new Arbtramexp();
					arbtramexpNuevo.setSolarb(solarb);
					arbtramexpNuevo.setTrcodigo(
							Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION);
					arbtramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

					Pagination pagination = new Pagination();
					pagination.setSidx("TRFECALTA");
					pagination.setSord("DESC");
					List<Arbtramexp> lrecepcionRequerimientoAcreditacion = this.arbtramexpDao.findAll(arbtramexpNuevo,
							pagination);
					boolean generarNuevaRecepcion = true;
					for (Arbtramexp recepReqAcredita : lrecepcionRequerimientoAcreditacion) {
						if (recepReqAcredita != null) {
							if (participacion == "RADO"
									&& (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO)
											.equals(recepReqAcredita.getTipoDestOrigen())
									|| (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO)
											.equals(recepReqAcredita.getTipoDestOrigen())) {
								this.adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente(
										arbtramexp.getTrid().toString(), recepReqAcredita.getTrid().toString(),
										Y41bConstantes.TIPO_DOC_ARB_ACREDITACION_REPRESENTACION);
								generarNuevaRecepcion = false;
								break;
							} else if (participacion == "RNTE"
									&& (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE)
											.equals(recepReqAcredita.getTipoDestOrigen())
									|| (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO)
											.equals(recepReqAcredita.getTipoDestOrigen())) {
								generarNuevaRecepcion = false;
								this.adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente(
										arbtramexp.getTrid().toString(), recepReqAcredita.getTrid().toString(),
										Y41bConstantes.TIPO_DOC_ARB_ACREDITACION_REPRESENTACION);
								break;
							}
						}
					}

					if (generarNuevaRecepcion) {

						arbtramexpNuevo = new Arbtramexp();
						// santramexpNuevo.setTrid(Y41bUIDGenerator.getInstance().generateId(
						// Y41bConstantes.PK_SIZE));
						arbtramexpNuevo.setSolarb(new Solarb(arbtramexp.getSolarb().getSacodigo()));
						arbtramexpNuevo.setTrcodigo(
								Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION);
						arbtramexpNuevo.setTrfecini(arbtramexp.getTrfecini());
						arbtramexpNuevo.setCensoMonitor(arbtramexp.getCensoMonitorEj());
						arbtramexpNuevo.setTrcodigorel(arbtramexp.getTrcodigo());
						arbtramexpNuevo.setTrtridrel(arbtramexp.getTrid());
						arbtramexpNuevo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
						arbtramexpNuevo.setTruaidinterv(arbtramexp.getTruaidinterv());
						arbtramexpNuevo.setFase(arbtramexp.getFase());
						arbtramexpNuevo.setTipoDestOrigen(arbtramexp.getTipoDestOrigen());

						// Se inserta el tramite
						this.arbtramexpDao.add(arbtramexpNuevo);

						this.adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente(arbtramexp.getTrid().toString(),
								arbtramexpNuevo.getTrid().toString(),
								Y41bConstantes.TIPO_DOC_ARB_ACREDITACION_REPRESENTACION);

						this.calcularEstadoTramiteGenerado(arbtramexpNuevo);
					}
				}
				// 0150948: Evolutivo Arbitraje Marzo-2020
				// 2.3
				// Cuando se tramita la aportacin si existe tramite de ltaudo
				// pendiente se adjuntara el documento aportado
				else if (Y41bConstantes.TIPO_DOC_ARB_LAUDO.equals(tipoDocumento)) {
					// Documentos
					Arbtramexp laudoArbitraje = new Arbtramexp();
					laudoArbitraje.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO);
					laudoArbitraje.setSolarb(new Solarb(arbexp.getExcodigo()));
					Pagination pagination = new Pagination();
					pagination.setSidx("TRFECALTA");
					pagination.setSord("DESC");
					List<Arbtramexp> lLaudoArbitraje = this.arbtramexpDao.findAll(laudoArbitraje, pagination);
					boolean hayTramite = false;
					if (lLaudoArbitraje != null && lLaudoArbitraje.size() > 0) {
						for (int j = 0; j < lLaudoArbitraje.size(); j++) {
							laudoArbitraje = lLaudoArbitraje.get(j);
							if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(laudoArbitraje.getTrestado())) {
								hayTramite = true;
								break;
							}
						}
					}
					if (hayTramite) {
						this.arbdoctempDao.insertArbDocTramite(laudoArbitraje.getTrid(), arbdoc.getX5codocumento(),
								Y41bConstantes.TIPO_PROC_ARBITRAJE);
					}

				}
				// 0150948: Evolutivo Arbitraje Marzo-2020
				// 2.3

			}
		}
	}

	/**
	 * @param arbtramexpAcuse
	 *            Arbtramexp
	 * @param arbtramexp2
	 *            Arbtramexp
	 * @param notificacion
	 *            Arbtramexp
	 * @return Date
	 */
	private Date getFechaNotificacionAcuse(Arbtramexp arbtramexpAcuse, Arbtramexp arbtramexp2,
			Arbtramexp notificacion) {
		Date fecha = null;
		Arbtramexp acuse = null;
		List<Arbtramexp> listaAcuses = this.arbtramexpDao.findAll(arbtramexpAcuse, null);
		if (listaAcuses != null && listaAcuses.size() > 0) {
			acuse = listaAcuses.get(0);
			if (notificacion.getTrid().equals(acuse.getTrtridrel()) && acuse.getTrestadoacuse() != null) {
				if (acuse.getTrestadoacuse().equals(Y41bConstantes.ESTADO_ACUSE_ACEPTADO)
						|| acuse.getTrestadoacuse().equals(Y41bConstantes.ESTADO_ACUSE_RECHAZADO)) {
					fecha = acuse.getTrfecacuse();
				} else if (acuse.getTrestadoacuse().equals(Y41bConstantes.ESTADO_ACUSE_NO_ENTREGADO)) {

					Arbtramexp arbtramexpBOPV = new Arbtramexp();
					arbtramexpBOPV.setTrtridrel(notificacion.getTrid());
					arbtramexpBOPV.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_PUBLICACION_BOPVBOE);
					arbtramexpBOPV.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
					arbtramexpBOPV.setSolarb(arbtramexp2.getSolarb());
					arbtramexpBOPV.setTrtridrel(notificacion.getTrid());
					arbtramexpBOPV.setTruaidinterv(arbtramexpAcuse.getTruaidinterv());
					List<Arbtramexp> listaBOPV = this.arbtramexpDao.findAll(arbtramexpBOPV, null);
					if (listaBOPV != null && listaBOPV.size() > 0) {
						arbtramexpBOPV = listaBOPV.get(0);
						fecha = arbtramexpBOPV.getTrfecinitabl();
					}
				}
			}
			if (Y41bConstantes.SI.equals(acuse.getTracusereintentado())) {
				fecha = null;
			}
		}
		return fecha;
	}

	/**
	 * Obtiene las fecha de notificacion de ese trmite para el reclamante y el
	 * reclamado
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	private Arbtramexp getFechasNotificacion(Arbtramexp arbtramexp) {
		boolean bReclamado = false, bReclamante = false;
		Date fecnot = null;
		Arbtramexp arbtramexpNotificacion = new Arbtramexp();
		arbtramexpNotificacion.setTrtridrel(arbtramexp.getTrid());
		arbtramexpNotificacion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION);
		arbtramexpNotificacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		arbtramexpNotificacion.setSolarb(arbtramexp.getSolarb());

		Arbinterv reclamante = this.arbintervDao.dameInterviniente(arbtramexp.getSolarb().getSacodigo(),
				Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
		Arbinterv reclamado = this.arbintervDao.dameInterviniente(arbtramexp.getSolarb().getSacodigo(),
				Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);

		List<Arbtramexp> listaNotificaciones = this.arbtramexpDao.findAll(arbtramexpNotificacion, null);
		for (Arbtramexp notificacion : listaNotificaciones) {
			if (arbtramexp.getTrid().equals(notificacion.getTrtridrel())) {
				Arbtramexp arbtramexpAcuse = new Arbtramexp();
				arbtramexpAcuse.setTrtridrel(notificacion.getTrid());
				arbtramexpAcuse.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO);
				arbtramexpAcuse.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
				arbtramexpAcuse.setSolarb(arbtramexp.getSolarb());

				fecnot = this.getFechaNotificacionAcuse(arbtramexpAcuse, arbtramexp, notificacion);
				if (fecnot != null) {
					if (reclamante != null && notificacion.getTruaidinterv() != null
							&& notificacion.getTruaidinterv().equals(reclamante.getUaidinterv())) {
						arbtramexp.setFecnotreclamante(fecnot);
						bReclamante = true;
					} else if (reclamado != null && notificacion.getTruaidinterv() != null
							&& notificacion.getTruaidinterv().equals(reclamado.getUaidinterv())) {
						arbtramexp.setFecnotreclamado(fecnot);
						bReclamado = true;
					}
				}
			}
		}

		// Si no hay notificacin revisar si hay comunicacin
		if (!bReclamante || !bReclamado) {
			Arbtramexp arbtramexpComunicacion = new Arbtramexp();
			arbtramexpComunicacion.setTrtridrel(arbtramexp.getTrid());
			arbtramexpComunicacion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION);
			arbtramexpComunicacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			arbtramexpComunicacion.setSolarb(arbtramexp.getSolarb());
			List<Arbtramexp> listaComunicaciones = this.arbtramexpDao.findAll(arbtramexpComunicacion, null);

			for (Arbtramexp comunicacion : listaComunicaciones) {
				if (arbtramexp.getTrid().equals(comunicacion.getTrtridrel())) {
					if (!bReclamante && reclamante != null
							&& comunicacion.getTruaidinterv().equals(reclamante.getUaidinterv())) {
						arbtramexp.setFecnotreclamante(comunicacion.getTrfecnotif());
					} else if (!bReclamado && reclamado != null
							&& comunicacion.getTruaidinterv().equals(reclamado.getUaidinterv())) {
						arbtramexp.setFecnotreclamado(comunicacion.getTrfecnotif());
					}
				}
			}
		}
		return arbtramexp;
	}

	/**
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param pagination
	 *            Pagination
	 * @return List<Arbtramexp>
	 */
	public List<Arbtramexp> findTramitesAclaracion(Arbtramexp arbtramexp, Pagination pagination) {
		// bReclamado y bReclamante indican si se han encontrado las fechas de
		// notificacin para el
		// reclamante y el reclamado respectivamente
		List<Arbtramexp> lista = this.arbtramexpDao.findAll(arbtramexp, pagination);

		for (Arbtramexp arbtramexp2 : lista) {
			Arbtramexp arbtramexp3 = (Arbtramexp) this.arbtramexpDao.find(arbtramexp2);
			arbtramexp2.setResumen(Y41bUtils.clobToString(arbtramexp3.getTrresumen()));
			if (arbtramexp2.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION)) {

				// para saber el origen, buscamos el origen del interviniente.
				Arbinterv arbintervorigen = new Arbinterv(arbtramexp2.getTrintervorigen());
				arbintervorigen = this.arbintervDao.find(arbintervorigen);

				if (arbintervorigen != null) {
					arbtramexp2.setX5origen(arbintervorigen.getUatipointerv());
				}
			} else if (arbtramexp2.getTrcodigo().equals(Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION)) {
				this.getFechasNotificacion(arbtramexp2);
			}
		}
		return lista;
	}

	/**
	 * Carga los datos del Colegio Arbitral
	 * 
	 * @param solarb
	 *            Solarb
	 * @param organoColegioArbitral
	 *            Arbtramexp
	 * @param lista
	 *            List
	 * @param mapaOrganoColegioArbitral
	 *            Map
	 * @param dateFormat
	 *            String
	 * @return Map<String, Object>
	 * @throws Exception
	 *             e
	 */
	public Map<String, Object> cargaDatosColegioArbitral(Solarb solarb, Arbtramexp organoColegioArbitral,
			List<Arbtramexp> lista, Map<String, Object> mapaOrganoColegioArbitral, String dateFormat) throws Exception {
		organoColegioArbitral = lista.get(0);
		mapaOrganoColegioArbitral.put("mostrar", Y41bConstantes.VALOR_SI);
		mapaOrganoColegioArbitral.put("trfecdesigna",
				Y41bUtils.formatearDateToString(organoColegioArbitral.getTrfecdesigna(), dateFormat));
		mapaOrganoColegioArbitral.put("trintica", organoColegioArbitral.getTrintica());
		mapaOrganoColegioArbitral.put("trtipoaudiencia", organoColegioArbitral.getTrtipoaudiencia());
		Arbcolegio arbcolegio = new Arbcolegio();
		arbcolegio.setXjtrid(organoColegioArbitral.getTrid());
		arbcolegio = this.arbcolegioDao.find(arbcolegio);
		if (arbcolegio != null) {
			if (arbcolegio.getPresidenteT() != null
					&& !Y41bUtils.esNullOCadenaVacia(arbcolegio.getPresidenteT().getArcodigo())) {
				mapaOrganoColegioArbitral.put("presi", arbcolegio.getPresidenteT().getArnombre());
				mapaOrganoColegioArbitral.put("codpresi", arbcolegio.getPresidenteT().getArcodigo());
				mapaOrganoColegioArbitral.put("activopresi", arbcolegio.getXjactivop());
			} else {
				mapaOrganoColegioArbitral.put("presi", "");
				mapaOrganoColegioArbitral.put("codpresi", "");
				mapaOrganoColegioArbitral.put("activopresi", "");
			}
			if (arbcolegio.getPresidenteS() != null
					&& !Y41bUtils.esNullOCadenaVacia(arbcolegio.getPresidenteS().getArcodigo())) {
				mapaOrganoColegioArbitral.put("presisupl", arbcolegio.getPresidenteS().getArnombre());
				mapaOrganoColegioArbitral.put("codpresisupl", arbcolegio.getPresidenteS().getArcodigo());
				mapaOrganoColegioArbitral.put("activopresisupl", arbcolegio.getXjactivopsup());
			} else {
				mapaOrganoColegioArbitral.put("presisupl", "");
				mapaOrganoColegioArbitral.put("codpresisupl", "");
				mapaOrganoColegioArbitral.put("activopresisupl", "");
			}
			if (arbcolegio.getConsumidorT() != null
					&& !Y41bUtils.esNullOCadenaVacia(arbcolegio.getConsumidorT().getArcodigo())) {
				mapaOrganoColegioArbitral.put("arbcons", arbcolegio.getConsumidorT().getArnombre());
				mapaOrganoColegioArbitral.put("codcons", arbcolegio.getConsumidorT().getArcodigo());
				mapaOrganoColegioArbitral.put("activoarbcons", arbcolegio.getXjactivoaacc());
			} else {
				mapaOrganoColegioArbitral.put("arbcons", "");
				mapaOrganoColegioArbitral.put("codcons", "");
				mapaOrganoColegioArbitral.put("activoarbcons", "");
			}
			if (arbcolegio.getConsumidorS() != null
					&& !Y41bUtils.esNullOCadenaVacia(arbcolegio.getConsumidorS().getArcodigo())) {
				mapaOrganoColegioArbitral.put("arbconssupl", arbcolegio.getConsumidorS().getArnombre());
				mapaOrganoColegioArbitral.put("codarbconssupl", arbcolegio.getConsumidorS().getArcodigo());
				mapaOrganoColegioArbitral.put("activoarbconssupl", arbcolegio.getXjactivoaaccsup());
			} else {
				mapaOrganoColegioArbitral.put("arbconssupl", "");
				mapaOrganoColegioArbitral.put("codarbconssupl", "");
				mapaOrganoColegioArbitral.put("activoarbconssupl", "");
			}
			if (arbcolegio.getEmpresarialT() != null
					&& !Y41bUtils.esNullOCadenaVacia(arbcolegio.getEmpresarialT().getArcodigo())) {
				mapaOrganoColegioArbitral.put("arbemp", arbcolegio.getEmpresarialT().getArnombre());
				mapaOrganoColegioArbitral.put("codarbemp", arbcolegio.getEmpresarialT().getArcodigo());
				mapaOrganoColegioArbitral.put("activoarbemp", arbcolegio.getXjactivoooee());
			} else {
				mapaOrganoColegioArbitral.put("arbemp", "");
				mapaOrganoColegioArbitral.put("codarbemp", "");
				mapaOrganoColegioArbitral.put("activoarbemp", "");
			}
			if (arbcolegio.getEmpresarialS() != null
					&& !Y41bUtils.esNullOCadenaVacia(arbcolegio.getEmpresarialS().getArcodigo())) {
				mapaOrganoColegioArbitral.put("arbempsupl", arbcolegio.getEmpresarialS().getArnombre());
				mapaOrganoColegioArbitral.put("codarbempsupl", arbcolegio.getEmpresarialS().getArcodigo());
				mapaOrganoColegioArbitral.put("activoarbempsupl", arbcolegio.getXjactivoooeesup());
			} else {
				mapaOrganoColegioArbitral.put("arbempsupl", "");
				mapaOrganoColegioArbitral.put("codarbempsupl", "");
				mapaOrganoColegioArbitral.put("activoarbempsupl", "");
			}

			if (arbcolegio.getSecretarioT() != null
					&& !Y41bUtils.esNullOCadenaVacia(arbcolegio.getSecretarioT().getSrcodigo())) {
				mapaOrganoColegioArbitral.put("sacoset", arbcolegio.getSecretarioT().getSrnombre());
				mapaOrganoColegioArbitral.put("codsacoset", arbcolegio.getSecretarioT().getSrcodigo());
			} else {
				mapaOrganoColegioArbitral.put("sacoset", "");
				mapaOrganoColegioArbitral.put("codsacoset", "");
			}

			if (arbcolegio.getSecretarioS() != null
					&& !Y41bUtils.esNullOCadenaVacia(arbcolegio.getSecretarioS().getSrcodigo())) {
				mapaOrganoColegioArbitral.put("sacoses", arbcolegio.getSecretarioS().getSrnombre());
				mapaOrganoColegioArbitral.put("codsacoses", arbcolegio.getSecretarioS().getSrcodigo());
			} else {
				mapaOrganoColegioArbitral.put("sacoses", "");
				mapaOrganoColegioArbitral.put("codsacoses", "");
			}
		}
		return mapaOrganoColegioArbitral;
	}

	/**
	 * Carga los datos de la Resolucion
	 * 
	 * @param resolucion
	 *            Arbtramexp
	 * @param lista
	 *            List
	 * @param mapaResolucion
	 *            Map
	 * @param dateFormat
	 *            String
	 * @return Map<String, Object>
	 * @throws Exception
	 *             e
	 */
	private Map<String, Object> cargaDatosResolucion(List<Arbtramexp> lista, Map<String, Object> mapaResolucion,
			String dateFormat) throws Exception {
		Arbtramexp resolucion = lista.get(0);
		mapaResolucion.put("mostrar", Y41bConstantes.VALOR_SI);
		mapaResolucion.put("trresotipo", resolucion.getTrresotipo());
		mapaResolucion.put("trresofecha", Y41bUtils.formatearDateToString(resolucion.getTrresofecha(), dateFormat));

		Decision decision = new Decision();
		decision.setDecodigo(resolucion.getTrresotipo());
		decision = this.decisionDao.find(decision);
		mapaResolucion.put("trdecision_es", decision.getDenombre());
		mapaResolucion.put("trdecision_eu", decision.getDenombree());

		if (Y41bConstantes.DECISION_ARBITRAJE_LAUDO.equals(resolucion.getTrresotipo())) {
			Pagination pagination = new Pagination();
			pagination.setSort("trfecfin");
			pagination.setAscDsc("desc");
			Arbtramexp laudo = new Arbtramexp();
			laudo.setSolarb(resolucion.getSolarb());
			laudo.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO);
			laudo.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			List<Arbtramexp> lista2 = this.arbtramexpDao.findAll(laudo, pagination);
			if (lista2 != null && lista2.size() > 0) {
				laudo = lista2.get(0);
				laudo = this.getFechasNotificacion(laudo);
				if (laudo.getFecnotreclamado() != null) {
					mapaResolucion.put("fecnotReclamado",
							Y41bUtils.formatearDateToString(laudo.getFecnotreclamado(), dateFormat));
				} else {
					mapaResolucion.put("fecnotReclamado", "");
				}
				if (laudo.getFecnotreclamante() != null) {
					mapaResolucion.put("fecnotReclamante",
							Y41bUtils.formatearDateToString(laudo.getFecnotreclamante(), dateFormat));
				} else {
					mapaResolucion.put("fecnotReclamante", "");
				}
				if (laudo.getTrresoimporte() != null) {
					mapaResolucion.put("trresoimporte",
							Y41bUtils.formatDouble2decimalesYcomaYpuntoMiles(laudo.getTrresoimporte().doubleValue()));
				} else {
					mapaResolucion.put("trresoimporte", "");
				}
				if (laudo.getTrimpreconv() != null) {
					mapaResolucion.put("trimpreconv",
							Y41bUtils.formatDouble2decimalesYcomaYpuntoMiles(laudo.getTrimpreconv().doubleValue()));
				} else {
					mapaResolucion.put("trimpreconv", "");
				}
				if (!Y41bUtils.esNullOCadenaVacia(laudo.getTrrespmotiv())) {
					Arbinterv arbinterv = this.arbintervDao.find(new Arbinterv(new BigDecimal(laudo.getTrrespmotiv())));
					if (arbinterv != null) {
						mapaResolucion.put("trrespmotiv", arbinterv.getUanombre());
					} else {
						mapaResolucion.put("trrespmotiv", "");
					}
				} else {
					mapaResolucion.put("trrespmotiv", "");
				}
				//
				mapaResolucion.put("trmodolaudo", laudo.getTrmodolaudo());
				mapaResolucion.put("trresultado", laudo.getTrresultado());
				//

				String trdecisionStr = Y41bUtils.clobToString(laudo.getTrdecision());
				mapaResolucion.put("trdecision", trdecisionStr);

				/*
				 * Decision decision = new Decision();
				 * decision.setDecodigo(resolucion.getTrresotipo()); decision =
				 * this.decisionDao.find(decision);
				 * mapaResolucion.put("trdecision_es", decision.getDenombre());
				 * mapaResolucion.put("trdecision_eu", decision.getDenombree());
				 */

				mapaResolucion.put("eslaudo", Y41bConstantes.VALOR_SI);

				if (laudo.getTrmodolaudo() != null && !laudo.getTrmodolaudo().equals("")) {
					LaudosAdoptado adoptado = new LaudosAdoptado();
					adoptado.setL21r4codigo(laudo.getTrmodolaudo());
					adoptado = this.laudosAdoptadoDao.find(adoptado);
					mapaResolucion.put("trmodo_es", adoptado.getL21r4adoptadoc());
					mapaResolucion.put("trmodo_eu", adoptado.getL21r4adoptadoe());
				} else {
					mapaResolucion.put("trmodo_es", "");
					mapaResolucion.put("trmodo_eu", "");
				}

				if (laudo.getTrresultado() != null && !laudo.getTrresultado().equals("")) {
					LaudosTipo ltipo = new LaudosTipo();
					ltipo.setL21r3codigo(laudo.getTrresultado());
					ltipo = this.laudosTipoDao.find(ltipo);
					mapaResolucion.put("trresultado_es", ltipo.getL21r3tipoc());
					mapaResolucion.put("trresultado_eu", ltipo.getL21r3tipoe());
				} else {
					mapaResolucion.put("trresultado_es", "");
					mapaResolucion.put("trresultado_eu", "");
				}
			}
		} else {
			mapaResolucion.put("eslaudo", Y41bConstantes.VALOR_NO);
			resolucion = this.getFechasNotificacion(resolucion);
			mapaResolucion.put("fecnotReclamado",
					Y41bUtils.formatearDateToString(resolucion.getFecnotreclamado(), dateFormat));
			mapaResolucion.put("fecnotReclamante",
					Y41bUtils.formatearDateToString(resolucion.getFecnotreclamante(), dateFormat));

			/*
			 * mapaResolucion.put("trmodo_es", "");
			 * mapaResolucion.put("trmodo_eu", "");
			 * mapaResolucion.put("trresultado_es", "");
			 * mapaResolucion.put("trresultado_eu", "");
			 */
		}
		return mapaResolucion;
	}

	/**
	 * Carga los datos de la Audiencia
	 * 
	 * @param citacion
	 *            Arbtramexp
	 * @param lista
	 *            List
	 * @param mapaAudiencia1
	 *            Map
	 * @param dateFormat
	 *            String
	 * @return Map<String, Object>
	 * @throws Exception
	 *             e
	 */
	private Map<String, Object> cargaDatosAudiencia(Arbtramexp citacion, List<Arbtramexp> lista,
			Map<String, Object> mapaAudiencia1, String dateFormat) throws Exception {

		mapaAudiencia1.put("mostrar", Y41bConstantes.VALOR_SI);
		mapaAudiencia1.put("trhoracitacion", citacion.getTrhoracitacion());
		citacion = this.getFechasNotificacion(citacion);
		mapaAudiencia1.put("trfeccitacion", Y41bUtils.formatearDateToString(citacion.getTrfeccitacion(), dateFormat));
		mapaAudiencia1.put("fecnotReclamado",
				Y41bUtils.formatearDateToString(citacion.getFecnotreclamado(), dateFormat));
		mapaAudiencia1.put("fecnotReclamante",
				Y41bUtils.formatearDateToString(citacion.getFecnotreclamante(), dateFormat));

		if (citacion.getTrclugaud() != null && !citacion.getTrclugaud().equals("")) {
			Tclugaud lugaud = new Tclugaud();
			lugaud.setT4codigo(citacion.getTrclugaud());
			lugaud = this.tclugaudDao.find(lugaud);
			if (lugaud != null) {
				mapaAudiencia1.put("lugarAudiencia", lugaud.getT4nombre());
			} else {
				mapaAudiencia1.put("lugarAudiencia", "");
			}
		} else {
			mapaAudiencia1.put("lugarAudiencia", "");
		}

		if (lista != null && lista.size() > 0) {
			Arbtramexp audiencia1 = lista.get(0);
			mapaAudiencia1.put("trfecaudiencia",
					Y41bUtils.formatearDateToString(audiencia1.getTrfecaudiencia(), dateFormat));
			mapaAudiencia1.put("trhoraaudiencia", audiencia1.getTrhoraaudiencia());
			mapaAudiencia1.put("trdecision", audiencia1.getTrdecision());
			mapaAudiencia1.put("trnodir", audiencia1.getTrnodir());
			mapaAudiencia1.put("trsolprueba", audiencia1.getTrsolprueba());
			if (audiencia1.getTriddecision() != null && audiencia1.getTriddecision().intValue() != 0) {
				mapaAudiencia1.put("triddecision", audiencia1.getTriddecision());
			} else {
				mapaAudiencia1.put("triddecision", "");
			}
		}
		return mapaAudiencia1;
	}

	/**
	 * Carga los datos de la Audiencia2
	 * 
	 * @param citacion
	 *            Arbtramexp
	 * @param audiencia2
	 *            Arbtramexp
	 * @param lista
	 *            List
	 * @param mapaAudiencia2
	 *            Map
	 * @param dateFormat
	 *            String
	 * @return Map<String, Object>
	 * @throws Exception
	 *             e
	 */
	private Map<String, Object> cargaDatosAudiencia2(Arbtramexp citacion, List<Arbtramexp> lista,
			Map<String, Object> mapaAudiencia2, String dateFormat) throws Exception {
		citacion = this.getFechasNotificacion(citacion);
		mapaAudiencia2.put("mostrar", Y41bConstantes.VALOR_SI);
		mapaAudiencia2.put("trhoracitacion", citacion.getTrhoracitacion());

		mapaAudiencia2.put("trfeccitacion", Y41bUtils.formatearDateToString(citacion.getTrfeccitacion(), dateFormat));

		mapaAudiencia2.put("fecnotReclamado",
				Y41bUtils.formatearDateToString(citacion.getFecnotreclamado(), dateFormat));
		mapaAudiencia2.put("fecnotReclamante",
				Y41bUtils.formatearDateToString(citacion.getFecnotreclamante(), dateFormat));

		// if (audiencia2.getTrclugaud() != null
		if (citacion.getTrclugaud() != null && !citacion.getTrclugaud().equals("")) {
			Tclugaud lugaud = new Tclugaud();
			lugaud.setT4codigo(citacion.getTrclugaud());
			lugaud = this.tclugaudDao.find(lugaud);
			if (lugaud != null) {
				mapaAudiencia2.put("lugarAudiencia", lugaud.getT4nombre());
			} else {
				mapaAudiencia2.put("lugarAudiencia", "");
			}
		} else {
			mapaAudiencia2.put("lugarAudiencia", "");
		}

		if (lista != null && lista.size() > 0) {
			Arbtramexp audiencia2 = lista.get(0);
			mapaAudiencia2.put("trdecision", audiencia2.getTrdecision());
			mapaAudiencia2.put("trfecaudiencia",
					Y41bUtils.formatearDateToString(audiencia2.getTrfecaudiencia(), dateFormat));
			mapaAudiencia2.put("trhoraaudiencia", audiencia2.getTrhoraaudiencia());
			mapaAudiencia2.put("trnodir", audiencia2.getTrnodir());
			// mapaAudiencia2.put("trcolo", audiencia2.getTrcolo());
		}
		return mapaAudiencia2;
	}

	/**
	 * Carga los datos del Convenio
	 * 
	 * @param convenio
	 *            Arbtramexp
	 * @param lista
	 *            List
	 * @param mapaConvenio
	 *            Map
	 * @param dateFormat
	 *            String
	 * @return Map<String, Object>
	 * @throws Exception
	 *             e
	 */
	private Map<String, Object> cargaDatosConvenio(Arbtramexp convenio, List<Arbtramexp> lista,
			Map<String, Object> mapaConvenio, String dateFormat) throws Exception {
		convenio = lista.get(0);
		convenio = this.getFechasNotificacion(convenio);
		mapaConvenio.put("mostrar", Y41bConstantes.VALOR_SI);
		mapaConvenio.put("fecnotReclamado", Y41bUtils.formatearDateToString(convenio.getFecnotreclamado(), dateFormat));
		mapaConvenio.put("fecnotReclamante",
				Y41bUtils.formatearDateToString(convenio.getFecnotreclamante(), dateFormat));

		// La fecha de formalizacin del convenio arbitral es la la fecha
		// mayor entre la de notificacin al reclamante y la de notificacin
		// al reclamado
		if (convenio.getFecnotreclamado() != null && convenio.getFecnotreclamante() != null) {

			if (convenio.getFecnotreclamado().compareTo(convenio.getFecnotreclamante()) >= 0) {
				mapaConvenio.put("trfecconvenio",
						Y41bUtils.formatearDateToString(convenio.getFecnotreclamado(), dateFormat));
			} else {
				mapaConvenio.put("trfecconvenio",
						Y41bUtils.formatearDateToString(convenio.getFecnotreclamante(), dateFormat));
			}

		} else {
			mapaConvenio.put("trfecconvenio", "");
		}

		return mapaConvenio;
	}

	/**
	 * @param sacodigo
	 *            String
	 * @param mapa
	 *            Map<String, Object>
	 * @return Map<String, Object>
	 * @throws Exception
	 *             e
	 */
	public Map<String, Object> obtenerDatosTramitesFichaArbitraje(String sacodigo, Map<String, Object> mapa)
			throws Exception {
		String idioma = LocaleContextHolder.getLocale().getLanguage();
		Map<String, Object> mapaOrganoColegioArbitral = new HashMap<String, Object>();
		Map<String, Object> mapaResolucion = new HashMap<String, Object>();
		Map<String, Object> mapaAnalisis = new HashMap<String, Object>();
		Map<String, Object> mapaAudiencia1 = new HashMap<String, Object>();
		Map<String, Object> mapaAudiencia2 = new HashMap<String, Object>();
		Map<String, Object> mapaPrueba = new HashMap<String, Object>();
		Map<String, Object> mapaInformePericial = new HashMap<String, Object>();
		Map<String, Object> mapaPagoPericial = new HashMap<String, Object>();
		Map<String, Object> mapaConvenio = new HashMap<String, Object>();

		Solarb solarb = (Solarb) mapa.get("solarb");
		String dateFormat = "";
		if (Y41bConstantes.EUSKERA.equals(idioma)) {
			dateFormat = Y41bConstantes.FORMATO_FECHA_EU;
		} else {
			dateFormat = Y41bConstantes.FORMATO_FECHA_ES;
		}

		Arbtramexp organoColegioArbitral = new Arbtramexp();
		// sacar los datos del ltimo que est resuelto
		organoColegioArbitral.setSolarb(solarb);

		organoColegioArbitral.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
		organoColegioArbitral.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		Pagination pagination = new Pagination();
		pagination.setSort("trfecfin");
		pagination.setAscDsc("desc");

		List<Arbtramexp> lista = this.arbtramexpDao.findAll(organoColegioArbitral, pagination);

		if (lista != null && lista.size() > 0) {
			mapaOrganoColegioArbitral = this.cargaDatosColegioArbitral(solarb, organoColegioArbitral, lista,
					mapaOrganoColegioArbitral, dateFormat);
		}

		Arbtramexp resolucion = new Arbtramexp();
		// sacar los datos del ltimo que est resuelto
		resolucion.setSolarb(solarb);
		resolucion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION);
		resolucion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		pagination = new Pagination();
		pagination.setSort("trfecfin");
		pagination.setAscDsc("desc");
		lista = this.arbtramexpDao.findAll(resolucion, pagination);

		if (lista != null && lista.size() > 0) {
			mapaResolucion = cargaDatosResolucion(lista, mapaResolucion, dateFormat);
		}

		Arbtramexp analisis = new Arbtramexp();
		// sacar los datos del ltimo que est resuelto
		analisis.setSolarb(solarb);
		analisis.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ANALISIS_EMPRESA);
		analisis.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		lista = this.arbtramexpDao.findAll(analisis, pagination);
		if (lista != null && lista.size() > 0) {
			analisis = lista.get(0);
			mapaAnalisis.put("mostrar", Y41bConstantes.VALOR_SI);
			mapaAnalisis.put("tranalisis", analisis.getTranalisis());
			Arbtramexp aceptacionArb = new Arbtramexp();
			aceptacionArb.setSolarb(solarb);
			aceptacionArb.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE);
			aceptacionArb.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			lista = this.arbtramexpDao.findAll(aceptacionArb, pagination);
			if (lista != null && lista.size() > 0) {
				aceptacionArb = lista.get(0);
				mapaAnalisis.put("trresparb", aceptacionArb.getTrresparb());
				mapaAnalisis.put("trhaycontest", aceptacionArb.getTrhaycontest());
				mapaAnalisis.put("trfecrecepcion",
						Y41bUtils.formatearDateToString(aceptacionArb.getTrfecrecepcion(), dateFormat));
			}
		}

		Arbtramexp citacion = new Arbtramexp();
		citacion.setSolarb(solarb);
		citacion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA);
		citacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		List<Arbtramexp> citaciones = this.arbtramexpDao.findAll(citacion, pagination);

		if (citaciones != null && citaciones.size() > 0) {
			citacion = citaciones.get(0);
		} else {
			citacion = null;
		}

		Arbtramexp suspension = new Arbtramexp();
		suspension.setSolarb(solarb);
		suspension.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_SUSPENSION_AUDIENCIA);
		suspension.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		List<Arbtramexp> suspensiones = this.arbtramexpDao.findAll(suspension, pagination);

		if (suspensiones != null && suspensiones.size() > 0) {
			suspension = suspensiones.get(0);
		} else {
			suspension = null;
		}

		// si la citacin no tiene un trmite de suspensin resuelto y
		// relacionado con dicha citacin se sacan los datos de la audiencia.
		if (citacion != null && (suspension == null || suspension.getTrtridrel() == null
				|| !suspension.getTrtridrel().equals(citacion.getTrid()))) {

			Arbtramexp audiencia1 = new Arbtramexp();
			audiencia1.setSolarb(solarb);
			audiencia1.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA);
			audiencia1.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			lista = this.arbtramexpDao.findAll(audiencia1, pagination);
			mapaAudiencia1 = cargaDatosAudiencia(citacion, lista, mapaAudiencia1, dateFormat);
		}

		// Para dejar hacer mediacion si hay solo citacion
		if (mapaAudiencia1.get("mostrar") != null && mapaAudiencia1.get("mostrar").toString().equalsIgnoreCase("S")
				&& lista.size() == 0) {
			mapaAudiencia1.put("mediacion", "S");
		} else if (mapaAudiencia1.get("mostrar") != null
				&& mapaAudiencia1.get("mostrar").toString().equalsIgnoreCase("S") && lista.size() > 0) {
			mapaAudiencia1.put("mediacion", "N");
		}

		// Segunda audiencia
		// si la citacin para la 2 audiencia no tiene un trmite de suspensin
		// resuelto y
		// relacionado con dicha citacin se sacan los datos de la audiencia.
		citacion = new Arbtramexp();
		citacion.setSolarb(solarb);
		citacion.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA);
		citacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		citaciones = this.arbtramexpDao.findAll(citacion, pagination);

		if (citaciones != null && citaciones.size() > 0) {
			citacion = citaciones.get(0);
		} else {
			citacion = null;
		}

		suspension = new Arbtramexp();
		suspension.setSolarb(solarb);
		suspension.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_SUSPENSION_AUDIENCIA);
		suspension.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		suspensiones = this.arbtramexpDao.findAll(suspension, pagination);

		if (suspensiones != null && suspensiones.size() > 0) {
			suspension = suspensiones.get(0);
		} else {
			suspension = null;
		}

		if (citacion != null && (suspension == null || suspension.getTrtridrel() == null
				|| !suspension.getTrtridrel().equals(citacion.getTrid()))) {

			Arbtramexp audiencia2 = new Arbtramexp();
			// sacar los datos del ltimo que est resuelto
			audiencia2.setSolarb(solarb);
			audiencia2.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_2AUDIENCIA);
			audiencia2.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			lista = this.arbtramexpDao.findAll(audiencia2, pagination);
			mapaAudiencia2 = cargaDatosAudiencia2(citacion, lista, mapaAudiencia2, dateFormat);
		}

		Arbtramexp prueba = new Arbtramexp();
		prueba.setSolarb(solarb);
		prueba.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_A_PRUEBA);
		// prueba.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		lista = this.arbtramexpDao.findAll(prueba, pagination);
		if (lista != null && lista.size() > 0) {
			prueba = lista.get(0);
			prueba = this.getFechasNotificacion(prueba);
			mapaPrueba.put("existe", Y41bConstantes.VALOR_SI);
			if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(prueba.getTrestado())) {
				mapaPrueba.put("mostrar", Y41bConstantes.VALOR_SI);
				mapaPrueba.put("tridCitacionPrueba", prueba.getTrid());
				mapaPrueba.put("trrealizadapor", prueba.getTrrealizadapor());
				mapaPrueba.put("trhoracitacion", prueba.getTrhoracitacion());
				mapaPrueba.put("trfeccitacion", Y41bUtils.formatearDateToString(prueba.getTrfeccitacion(), dateFormat));
				mapaPrueba.put("trainstanciade", prueba.getTrainstanciade());

				if (!Y41bUtils.esNullOCadenaVacia(prueba.getTrcope1())) {
					Empper perito = new Empper();
					perito.setPecodigo(prueba.getTrcope1());
					perito = this.empperDao.find(perito);
					if (perito != null) {
						mapaPrueba.put("perito1", perito.getPenombre());
						mapaPrueba.put("codperito1", perito.getPecodigo());
					}
				}
				if (!Y41bUtils.esNullOCadenaVacia(prueba.getTrcope2())) {
					Empper perito = new Empper();
					perito.setPecodigo(prueba.getTrcope2());
					perito = this.empperDao.find(perito);
					if (perito != null) {
						mapaPrueba.put("perito2", perito.getPenombre());
						mapaPrueba.put("codperito2", perito.getPecodigo());
					}
				}

				Arbtramexp arbTramExpAux = (Arbtramexp) this.arbtramexpDao.find(prueba);
				String trobjetoStr = Y41bUtils.clobToString(arbTramExpAux.getTrobjeto());
				mapaPrueba.put("trobjeto", trobjetoStr);
				mapaPrueba.put("trainstanciade", prueba.getTrainstanciade());

				mapaPrueba.put("fecnotReclamado",
						Y41bUtils.formatearDateToString(prueba.getFecnotreclamado(), dateFormat));
				mapaPrueba.put("fecnotReclamante",
						Y41bUtils.formatearDateToString(prueba.getFecnotreclamante(), dateFormat));

				mapaPrueba.put("lugarPrueba", "");
				if (prueba != null) {
					prueba.setDireccionCompleta(this.dameDireccionCompleta(prueba));
					if (prueba.getDireccionCompleta() != null && !prueba.getDireccionCompleta().equals("")) {
						mapaPrueba.put("lugarPrueba", prueba.getDireccionCompleta());
					} else {
						prueba.setProvinciaTxt(this.dameProvincia(prueba));
						prueba.setMunicipioTxt(this.dameMunicipio(prueba));
						mapaPrueba.put("lugarPrueba", prueba.getMunicipioTxt() + " " + prueba.getProvinciaTxt());
					}
				}
			}
		}

		Arbtramexp informe = new Arbtramexp();
		informe.setSolarb(solarb);
		informe.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL);
		informe.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		lista = this.arbtramexpDao.findAll(informe, pagination);

		if (lista != null && lista.size() > 0) {
			informe = lista.get(0);
			informe = this.getFechasNotificacion(informe);
			mapaInformePericial.put("mostrar", Y41bConstantes.VALOR_SI);
			mapaInformePericial.put("fecnotReclamado",
					Y41bUtils.formatearDateToString(informe.getFecnotreclamado(), dateFormat));
			mapaInformePericial.put("fecnotReclamante",
					Y41bUtils.formatearDateToString(informe.getFecnotreclamante(), dateFormat));
			mapaInformePericial.put("trfecinforme",
					Y41bUtils.formatearDateToString(informe.getTrfecrecepcion(), dateFormat));
		}

		Arbtramexp pagoPericial = new Arbtramexp();
		pagoPericial.setSolarb(solarb);
		pagoPericial.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_PERICIAL);
		pagoPericial.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		lista = this.arbtramexpDao.findAll(pagoPericial, pagination);

		if (lista != null && lista.size() > 0) {
			pagoPericial = lista.get(0);
			pagoPericial = this.getFechasNotificacion(pagoPericial);
			mapaPagoPericial.put("mostrar", Y41bConstantes.VALOR_SI);
			Empper perito = new Empper();
			perito.setPecodigo(pagoPericial.getTrcope1());
			perito = this.empperDao.find(perito);
			mapaPagoPericial.put("perito", perito.getPenombre());
			mapaPagoPericial.put("codperito", perito.getPecodigo());
			mapaPagoPericial.put("trresppagoper", pagoPericial.getTrresppagoper());
			mapaPagoPericial.put("trimporte",
					Y41bUtils.formatDouble2decimalesYcomaYpuntoMiles(pagoPericial.getTrimporte().doubleValue()));
			mapaPagoPericial.put("trreffactura", pagoPericial.getTrreffactura());
			mapaPagoPericial.put("trfecemision",
					Y41bUtils.formatearDateToString(pagoPericial.getTrfecemision(), dateFormat));
			mapaPagoPericial.put("fecnotReclamado",
					Y41bUtils.formatearDateToString(pagoPericial.getFecnotreclamado(), dateFormat));
			mapaPagoPericial.put("fecnotReclamante",
					Y41bUtils.formatearDateToString(pagoPericial.getFecnotreclamante(), dateFormat));
		}

		Arbtramexp convenio = new Arbtramexp();
		convenio.setSolarb(solarb);
		convenio.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_CONVENIO_ARBITRAL);
		convenio.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		lista = this.arbtramexpDao.findAll(convenio, pagination);
		if (lista != null && lista.size() > 0) {
			mapaConvenio = cargaDatosConvenio(convenio, lista, mapaConvenio, dateFormat);
		}

		// Si el expediente tiene un tramite de citacion audiencia o audiencia
		// pendiente, el check Activo de los arbitros se debe habilitar
		String habilitarActivo = Y41bConstantes.VALOR_NO;
		citacion = new Arbtramexp();
		citacion.setSolarb(solarb);
		citacion.setListaCodigosTramites("'" + Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_AUDIENCIA + "','"
				+ Y41bConstantes.TRAMITE_ARBITRAJE_CITACION_2AUDIENCIA + "','"
				+ Y41bConstantes.TRAMITE_ARBITRAJE_AUDIENCIA + "'");
		citacion.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		List<Arbtramexp> listaCitaciones = this.arbtramexpDao.findAll(citacion, null);

		if (listaCitaciones != null && listaCitaciones.size() > 0) {
			habilitarActivo = Y41bConstantes.VALOR_SI;
		}

		mapa.put("habilitarActivo", habilitarActivo);
		mapa.put("organoColegio", mapaOrganoColegioArbitral);
		mapa.put("resolucion", mapaResolucion);
		mapa.put("audiencia1", mapaAudiencia1);
		mapa.put("audiencia2", mapaAudiencia2);
		mapa.put("analisis", mapaAnalisis);
		mapa.put("convenio", mapaConvenio);
		mapa.put("informe", mapaInformePericial);
		mapa.put("prueba", mapaPrueba);
		mapa.put("pago", mapaPagoPericial);
		mapa.put("pagoLaudo", this.obtenerDatosPagoLaudo(solarb));
		mapa.put("reconvencion", this.obtenerDatosReconvencion(solarb));
		return mapa;
	}

	private HashMap<String, Object> obtenerDatosPagoLaudo(Solarb solarb) throws ParseException {
		HashMap<String, Object> mapaPagoLaudo = new HashMap<String, Object>();
		Pagination pagination = new Pagination();
		pagination.setSort("trfecfin");
		pagination.setAscDsc("desc");
		Arbtramexp pagoLaudo = new Arbtramexp();
		pagoLaudo.setSolarb(solarb);
		pagoLaudo.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_PAGO_LAUDO);
		List<Arbtramexp> lista = this.arbtramexpDao.findAll(pagoLaudo, pagination);
		String idioma = LocaleContextHolder.getLocale().getLanguage();
		String dateFormat = "";
		if (Y41bConstantes.EUSKERA.equals(idioma)) {
			dateFormat = Y41bConstantes.FORMATO_FECHA_EU;
		} else {
			dateFormat = Y41bConstantes.FORMATO_FECHA_ES;
		}
		if (lista != null && lista.size() > 0) {
			pagoLaudo = lista.get(0);
			mapaPagoLaudo.put("existe", Y41bConstantes.VALOR_SI);
			mapaPagoLaudo.put("trfeopla", Y41bUtils.formatearDateToString(pagoLaudo.getTrfeopla(), dateFormat));

		}
		return mapaPagoLaudo;
	}

	private HashMap<String, Object> obtenerDatosReconvencion(Solarb solarb) {
		HashMap<String, Object> mapaReconvencion = new HashMap<String, Object>();
		Pagination pagination = new Pagination();
		pagination.setSort("trfecfin");
		pagination.setAscDsc("desc");
		Arbtramexp laudo = new Arbtramexp();
		laudo.setSolarb(solarb);
		laudo.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO);
		List<Arbtramexp> lista = this.arbtramexpDao.findAll(laudo, pagination);
		if (lista != null && lista.size() > 0) {
			laudo = lista.get(0);
			mapaReconvencion.put("laudoEstado", laudo.getTrestado());
		} else {
			mapaReconvencion.put("laudoEstado", "");
		}
		return mapaReconvencion;
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * 
	 * @return String
	 */
	public String dameDireccionCompleta(Arbtramexp arbtramexp) {
		StringBuffer direccion = new StringBuffer("");
		direccion.append(this.dameLineaDireccion(arbtramexp));
		if ((arbtramexp.getTrnoraMunicipioId() != null) && (arbtramexp.getTrnoraProvinciaId() != null)) {
			direccion.append(this.dameMunicipio(arbtramexp));
		}
		if ((arbtramexp.getTrnoraPortalId() != null)) {
			direccion.append(", " + this.dameCodigoPostal(arbtramexp) + ", ");
		}
		if (arbtramexp.getTrnoraProvinciaId() != null) {
			direccion.append(this.dameProvincia(arbtramexp));
		}
		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return the string
	 */
	public String dameLineaDireccion(Arbtramexp arbtramexp) {
		StringBuffer direccion = new StringBuffer("");
		T17Portal t17portal = new T17Portal();

		if (!Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrnoraCalleId())) {
			String calle = "";
			try {
				calle = this.t17CalleDao
						.findCalleConTipoVia(new T17Calle(Long.parseLong(arbtramexp.getTrnoraCalleId()), null))
						.getDsO();
			} catch (Exception e) {
			}
			if (Y41bUtils.esNullOCadenaVacia(calle)) {
				if (!Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrnodir())) {
					direccion.append(arbtramexp.getTrnodir());
				}
			} else {
				if (arbtramexp.getTrnoraPortalId() != null) {
					t17portal.setId(Long.parseLong(arbtramexp.getTrnoraPortalId()));
					t17portal.setCalleId(Long.parseLong(arbtramexp.getTrnoraCalleId()));
					List<T17Portal> list = this.t17PortalService.findAll(t17portal, null);
					if (list != null && list.size() > 0) {
						t17portal = list.get(0);
						if (t17portal != null && t17portal.getPortal() != null) {
							direccion.append(" ")
									.append(Y41bUtils.componerDireccion(calle, t17portal.getBloque(),
											t17portal.getPortal(), 0, null, arbtramexp.getTrnombrePiso(),
											arbtramexp.getTrnodir()));
						} else if (t17portal != null && t17portal.getNumero() != 0) {
							direccion.append(calle);
							direccion.append(" ");
							direccion.append(t17portal.getNumero());
							if (!Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrnodir())) {
								direccion.append(" ").append(arbtramexp.getTrnodir());
							}
						} else {
							direccion.append(calle);
							if (!Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrnodir())) {
								direccion.append(" ").append(arbtramexp.getTrnodir());
							}
						}
					} else {
						direccion.append(calle);
						if (!Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrnodir())) {
							direccion.append(" ").append(arbtramexp.getTrnodir());
						}
					}
				} else {
					direccion.append(calle);
					if (!Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrnodir())) {
						direccion.append(" ").append(arbtramexp.getTrnodir());
					}
				}
			}
		} else {
			if (!Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrnodir())) {
				direccion.append(" ").append(arbtramexp.getTrnodir());
			}
		}
		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbtramexp
	 *            the Arbtramexp
	 * @return the string
	 */
	public String dameMunicipio(Arbtramexp arbtramexp) {
		StringBuffer direccion = new StringBuffer("");
		String municipio = "";
		if ((arbtramexp.getTrnoraMunicipioId() != null) && (arbtramexp.getTrnoraProvinciaId() != null)) {
			T17Municipio municipiodVO = (this.t17MunicipioDao.find(new T17Municipio(arbtramexp.getTrnoraMunicipioId(),
					arbtramexp.getTrnoraProvinciaId(), null, null)));
			if (municipiodVO != null) {
				municipio = municipiodVO.getDsO() == null ? "" : municipiodVO.getDsO();
			}
			direccion.append(" ");
			direccion.append(municipio);
		}
		return (direccion.toString());
	}

	/**
	 * Dame direccion completa.
	 * 
	 * @param arbtramexp
	 *            the arbtramexp
	 * @return the string
	 */
	public String dameProvincia(Arbtramexp arbtramexp) {
		StringBuffer direccion = new StringBuffer("");
		String provincia = "";
		if (arbtramexp.getTrnoraProvinciaId() != null) {
			T17Provincia provinciaVO = (this.t17ProvinciaDao
					.find(new T17Provincia(arbtramexp.getTrnoraProvinciaId(), null, null)));
			if (provincia != null) {
				provincia = provinciaVO.getDsO() == null ? "" : provinciaVO.getDsO();
			}
			direccion.append(" ");
			direccion.append(provincia);
		}
		return (direccion.toString());
	}

	/**
	 * Dame dame Codigo Postal.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return String
	 */
	public String dameCodigoPostal(Arbtramexp arbtramexp) {
		StringBuffer cp = new StringBuffer("");
		T17Portal t17portal = new T17Portal();
		if (!Y41bUtils.esNullOCadenaVacia(arbtramexp.getTrnoraPortalId())) {
			t17portal.setId(Long.parseLong(arbtramexp.getTrnoraPortalId()));
			List<T17Portal> listat17portal = this.t17PortalDao.findAll(t17portal, null);
			if (listat17portal != null && listat17portal.size() > 0) {
				t17portal = listat17portal.get(0);
				return t17portal.getCodigoPostal();
			}
		}
		return (cp.toString());
	}

	/**
	 * Inserts a single row in the Santramexp table.
	 * 
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            the tramite comun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		Arbtramexp arbtramexp = new Arbtramexp();

		this.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());

		// Arbexp arbexp = this.arbexpDao.find(solarb.getArbexp());

		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_REQUERIMIENTOACREDITACIONREPRESENTACION);
		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		/*
		 * PROPIO DEL TRAMITE
		 */
		if (tramite.getInterviniente() != 0) {
			arbtramexp.setTruaidinterv(new BigDecimal(tramite.getInterviniente()));
		}

		arbtramexp.setTrid(tramiteComun.getIdTramite());

		arbtramexp.setTipoDestOrigen(tramite.getOrigen());

		arbtramexp = this.setArbtramexp(arbtramexp);

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma para actualizar
		// el
		// estado del tramite
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO.equals(arbtramexp.getTipoDestOrigen())) {
					List<Arbinterv> arbintervs = this.arbintervDao.findAllByTipo(solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO);
					if (arbintervs == null || (arbintervs != null && arbintervs.size() == 0)) {
						throw new Y41bUDAException(
								"error.tramiteRequerimientoAcreditacionRepresentacion.norepresentado", true,
								new Y41bUDAException());
					}
				} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE.equals(arbtramexp.getTipoDestOrigen())) {
					List<Arbinterv> arbintervs = this.arbintervDao.findAllByTipo(solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);
					if (arbintervs == null || (arbintervs != null && arbintervs.size() == 0)) {
						throw new Y41bUDAException(
								"error.tramiteRequerimientoAcreditacionRepresentacion.norepresentado", true,
								new Y41bUDAException());
					}
				}

				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.actualizaUltimoTramiteArbexp(arbtramexp);

				/* BLOQUE NUEVO TITULAR/REPRESENTANTE */
				/*
				 * sugerimos una tarea de notificacion para el
				 * titular/representante, habra uno por cada tipo de
				 * participacion al que se pueda notificar (titular o
				 * rep.validado)
				 */
				List<Arbinterv> reclamados = null;
				List<Arbinterv> reclamantes = null;

				/*
				 * El trmite de requerimiento de acreditacin es especial,
				 * porque puede tener como destinatario un representante que
				 * todava no se ha validado, si este es el que presenta el
				 * requerimiento. En cualquier otro trmite que genere
				 * notificaciones, el destinatario ser el titular o su
				 * representante ya validado.
				 */
				if (Y41bConstantes.TRAMITE_ARBITRAJE_REQUERIMIENTOACREDITACIONREPRESENTACION
						.equals(arbtramexp.getTrcodigo())) {
					if ("E".equals(tramite.getOrigen()) && Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE
							.equals(solarb.getArbexp().getExdestnotifreclamado())) {
						reclamados = this.arbintervDao.findAllByTipo(solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO);
					}
					if ("I".equals(tramite.getOrigen()) && Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE
							.equals(solarb.getArbexp().getExdestnotifreclamante())) {
						reclamantes = this.arbintervDao.findAllByTipo(solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);
					}
				} else {
					if ("E".equals(tramite.getOrigen()) && Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE
							.equals(solarb.getArbexp().getExdestnotifreclamado())) {
						reclamados = this.arbintervDao.findAllByTipo(solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO);
					}
					if ("I".equals(tramite.getOrigen()) && Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE
							.equals(solarb.getArbexp().getExdestnotifreclamado())) {
						reclamantes = this.arbintervDao.findAllByTipo(solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE);
					}
				}
				if ("E".equals(tramite.getOrigen())
						&& Y41bConstantes.SOLICITUDES_NOTIFICACION_TITULAR
								.equals(solarb.getArbexp().getExdestnotifreclamado())
						|| reclamados == null || reclamados.size() == 0) {
					reclamados = this.arbintervDao.findAllByTipo(solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				}
				if ("I".equals(tramite.getOrigen())
						&& Y41bConstantes.SOLICITUDES_NOTIFICACION_TITULAR
								.equals(solarb.getArbexp().getExdestnotifreclamante())
						|| reclamantes == null || reclamantes.size() == 0) {
					reclamantes = this.arbintervDao.findAllByTipo(solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
				}
				if ("E".equals(tramite.getOrigen()) && reclamados != null && reclamados.size() > 0) {
					Arbinterv reclamado = ((Arbinterv) reclamados.get(0));
					this.sugiereTramiteNotificacionAutomaticamente(arbtramexp, reclamado);
					this.sugiereTramiteRecepcionRequerimientoAcreditacionRepresentacion(arbtramexp, reclamado);
				}
				if ("I".equals(tramite.getOrigen()) && reclamantes != null && reclamantes.size() > 0) {
					Arbinterv reclamante = ((Arbinterv) reclamantes.get(0));
					this.sugiereTramiteNotificacionAutomaticamente(arbtramexp, reclamante);
					this.sugiereTramiteRecepcionRequerimientoAcreditacionRepresentacion(arbtramexp, reclamante);
				}

				this.actualizaBandeja(arbtramexp);
			}
		} else {
			this.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.eliminarDocumentosDokusi(listArbdoctempEliminados);
		return arbtramexp;
	}

	/**
	 * Finds a single row in the ArbTramExp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	public TramiteRequerimientoAcreditacionRepresentacion findTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramite, CensoMonitor censoMonitor) {

		CensoMonitor censoMonitorAux = this.censoMonitorDao.find(censoMonitor);
		Arbtramexp arbtramexp = new Arbtramexp();
		String trid = new String(tramite.getIdTramite());
		arbtramexp.setTrid(trid);
		arbtramexp = this.arbtramexpDao.find(arbtramexp);

		TramiteRequerimientoAcreditacionRepresentacion tramiteAux = new TramiteRequerimientoAcreditacionRepresentacion();
		tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
		tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
		tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
			instructorAsignado = arbtramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = arbtramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);
		tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

		/*
		 * PROPIO DEL TRAMITE
		 */
		if (arbtramexp.getTruaidinterv() != null) {
			tramiteAux.setInterviniente(Long.parseLong(arbtramexp.getTruaidinterv().toString()));
		}

		tramiteAux.setOrigen(arbtramexp.getTipoDestOrigen());

		if (this.tratamientoSeguridad(arbtramexp, censoMonitorAux)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	/**
	 * Guardar el tramite Recepcion Requerimiento Acreditacion Representacion
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtramexp addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception {

		Arbtramexp arbtramexp = new Arbtramexp();

		this.actualizaFaseArbexpDesdeTramite(tramiteComun.getIdExpediente(), tramiteComun.getIdTipoTramite());

		if (tramitar) {
			arbtramexp.setTrfecfin(tramite.getFechaFin());
			arbtramexp.setCensoMonitorEj(tramite.getInstructorEjecucion());
			// llamnar a platea
			// cambiar fase
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		} else {
			arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
		}

		Solarb solarb = new Solarb();
		solarb.setSacodigo(tramiteComun.getIdExpediente());
		solarb = this.solarbDao.find(solarb);

		arbtramexp.setTrfecini(tramite.getFechaInicio());

		Arbexp arbexp = this.arbexpDao.find(solarb.getArbexp());
		solarb.setArbexp(arbexp);

		arbtramexp.setSolarb(solarb);
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION);
		arbtramexp.setFase(solarb.getArbexp().getFase());
		arbtramexp.setCensoMonitor(tramite.getInstructorAsignado());
		arbtramexp.setTrobserves(Y41bUtils.stringToClob(tramite.getComentario()));
		/*
		 * PROPIO DEL TRAMITE
		 */
		arbtramexp.setTrresumenalegaciones(Y41bUtils.stringToClob(tramite.getResumenAlegaciones()));
		arbtramexp.setTrrespuesta(tramite.getRespuesta());
		arbtramexp.setTipoDestOrigen(tramite.getOrigen());

		arbtramexp.setTrid(tramiteComun.getIdTramite());
		arbtramexp = this.setArbtramexp(arbtramexp);

		/*
		 * Si no existe tramite de asignacion de responsable tramitado no se
		 * puede acreditar un representante porque esto significa actualizar la
		 * participacion en platea cuando todavia no esta abierta, con lo que
		 * daria un error
		 */
		if (tramitar) {
			Arbtramexp asignResponsable = new Arbtramexp();
			asignResponsable.setSolarb(solarb);
			List<Arbtramexp> larbtramexp = null;
			asignResponsable.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_ASIGNACION_RESPONSABLE);
			asignResponsable.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			larbtramexp = this.arbtramexpDao.findAll(asignResponsable, null);

			if (larbtramexp == null || larbtramexp.size() == 0) {
				throw new Y41bUDAException("error.tramiteRecepcionAcreditacionRepresentacion.asignResponsable", true,
						new Exception());
			}
		}

		if (tramitar) {

			// Si la respuesta es 'Valido', se busca un representante de origen
			// no valido y se le pone a 'Valido'. Si no encuentra representante,
			// se devuelve un mensaje de error.
			if (Y41bConstantes.RESPUESTA_ACREDITACION_VALIDO.equals(tramite.getRespuesta())) {

				Arbinterv arbinterv = new Arbinterv();
				CensoMonitor censoMonitor = arbtramexp.getCensoMonitor();
				censoMonitor = this.censoMonitorDao.find(censoMonitor);

				if ("E".equals(tramite.getOrigen())) {
					List<Arbinterv> larbinterv = this.arbintervDao.findAllByTipo(solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO);

					if (larbinterv != null && larbinterv.size() > 0) {
						arbinterv = larbinterv.get(0);
						arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO);
						this.arbintervDao.update(arbinterv);
						this.arbintervService.actualizarParticipantPlatea(solarb,
								this.arbintervDao.dameInterviniente(tramiteComun.getIdExpediente(),
										Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO),
								censoMonitor, false);
					} else {
						// buscamos representante
						larbinterv = this.arbintervDao.findAllByTipo(solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO);

						// si no lo hay error
						if (larbinterv == null || larbinterv.size() == 0) {
							throw new Y41bUDAException("error.tramiteRecepcionAcreditacionRepresentacion.reclamado",
									true, new Exception());
						}
					}
				}
				if ("I".equals(tramite.getOrigen())) {
					List<Arbinterv> larbinterv = this.arbintervDao.findAllByTipo(solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);

					if (larbinterv != null && larbinterv.size() > 0) {
						arbinterv = larbinterv.get(0);
						arbinterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE);
						this.arbintervDao.update(arbinterv);
						this.arbintervService.actualizarParticipantPlatea(solarb,
								this.arbintervDao.dameInterviniente(tramiteComun.getIdExpediente(),
										Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE),
								censoMonitor, false);
					} else {
						// buscamos representante
						larbinterv = this.arbintervDao.findAllByTipo(solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE);

						// si no lo hay error
						if (larbinterv == null || larbinterv.size() == 0) {
							throw new Y41bUDAException("error.tramiteRecepcionAcreditacionRepresentacion.reclamante",
									true, new Exception());
						}
					}
				}

			}
		}

		// buscar los documentos que no estan en la tabla de trabajo de
		// documentos y que pertenecen al Tramite
		List<Arbdoctemp> listArbdoctempEliminados = this.tratarDocumentosTemporal(tramiteComun,
				tramite.getAnyadirPlantilla());

		// Miramos si hay algun documento pendiente de firma para actualizar
		// el
		// estado del tramite
		List<Arbdoctemp> listDocumentoHecho = this.arbdoctempDao.findAllDocumentosTramite(tramiteComun, null);
		boolean isDocPendienteFirma = this.hayDocsPendienteFirma(listDocumentoHecho);

		if (tramitar) {
			if (listDocumentoHecho != null && listDocumentoHecho.size() < 1) {
				// Validacion: Debe haber almenos 1 documento
				throw new Y41bUDAException("error.solicitud.documentoException", true, new Exception());
			}
			if (isDocPendienteFirma) {
				// No se puede tramitar el tramite si tiene algun documento
				// pendiente de firma
				this.actualizaBandeja(arbtramexp);
				throw new Y41bUDAException("error.documentos.nofirmados", true, null);
			} else {
				BandejaFirma bandejaFirma = new BandejaFirma();
				bandejaFirma.setIdtramitehecho(tramiteComun.getIdTramite());
				bandejaFirma.setPcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);
				this.bandejaFirmaDao.removeBandejaFirmaExpediente(bandejaFirma);

				this.actualizaUltimoTramiteArbexp(arbtramexp);

				/* BLOQUE NUEVO TITULAR/REPRESENTANTE */
				/*
				 * sugerimos una tarea de notificacion para el
				 * titular/representante, habra uno por cada tipo de
				 * participacion al que se pueda notificar (titular o
				 * rep.validado)
				 */
				List<Arbinterv> reclamados = null;
				List<Arbinterv> reclamantes = null;

				/*
				 * El trmite de requerimiento de acreditacin es especial,
				 * porque puede tener como destinatario un representante que
				 * todava no se ha validado, si este es el que presenta el
				 * requerimiento. En cualquier otro trmite que genere
				 * notificaciones, el destinatario ser el titular o su
				 * representante ya validado.
				 */
				if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION
						.equals(arbtramexp.getTrcodigo())) {
					if ("E".equals(tramite.getOrigen()) && Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE
							.equals(solarb.getArbexp().getExdestnotifreclamado())) {
						reclamados = this.arbintervDao.findAllByTipo(solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO);
					}
					if ("I".equals(tramite.getOrigen()) && Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE
							.equals(solarb.getArbexp().getExdestnotifreclamante())) {
						reclamantes = this.arbintervDao.findAllByTipo(solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);
					}
				} else {
					if ("E".equals(tramite.getOrigen()) && Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE
							.equals(solarb.getArbexp().getExdestnotifreclamado())) {
						reclamados = this.arbintervDao.findAllByTipo(solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO);
					}
					if ("I".equals(tramite.getOrigen()) && Y41bConstantes.SOLICITUDES_NOTIFICACION_REPRESENTANTE
							.equals(solarb.getArbexp().getExdestnotifreclamado())) {
						reclamantes = this.arbintervDao.findAllByTipo(solarb,
								Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE);
					}
				}
				if ("E".equals(tramite.getOrigen())
						&& Y41bConstantes.SOLICITUDES_NOTIFICACION_TITULAR
								.equals(solarb.getArbexp().getExdestnotifreclamado())
						|| reclamados == null || reclamados.size() == 0) {
					reclamados = this.arbintervDao.findAllByTipo(solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMADO);
				}
				if ("I".equals(tramite.getOrigen())
						&& Y41bConstantes.SOLICITUDES_NOTIFICACION_TITULAR
								.equals(solarb.getArbexp().getExdestnotifreclamante())
						|| reclamantes == null || reclamantes.size() == 0) {
					reclamantes = this.arbintervDao.findAllByTipo(solarb,
							Y41bConstantes.TIPO_INTERVINIENTEARB_RECLAMANTE);
				}
				// if ("E".equals(tramite.getOrigen()) && reclamados != null
				// && reclamados.size() > 0) {
				// Arbinterv reclamado = ((Arbinterv) reclamados.get(0));
				// this.sugiereTramiteNotificacionAutomaticamente(arbtramexp,
				// reclamado);
				// }
				// if ("I".equals(tramite.getOrigen()) && reclamantes != null
				// && reclamantes.size() > 0) {
				// Arbinterv reclamante = ((Arbinterv) reclamantes.get(0));
				// this.sugiereTramiteNotificacionAutomaticamente(arbtramexp,
				// reclamante);
				// }

				this.actualizaBandeja(arbtramexp);
			}
		} else {
			this.guardarTramite(arbtramexp, tramiteComun, listDocumentoHecho, isDocPendienteFirma);
		}

		this.eliminarDocumentosDokusi(listArbdoctempEliminados);

		return arbtramexp;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramiteRecepcionRequerimientoAcreditacionRepresentacion
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteRecepcionRequerimientoAcreditacionRepresentacion findTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramite, CensoMonitor censoMonitor) {

		CensoMonitor censoMonitorAux = this.censoMonitorDao.find(censoMonitor);
		Arbtramexp arbtramexp = new Arbtramexp();
		String trid = new String(tramite.getIdTramite());
		arbtramexp.setTrid(trid);
		arbtramexp = this.arbtramexpDao.find(arbtramexp);

		TramiteRecepcionRequerimientoAcreditacionRepresentacion tramiteAux = new TramiteRecepcionRequerimientoAcreditacionRepresentacion();
		tramiteAux.setIdTramite(arbtramexp.getTrid().toString());
		tramiteAux.setFechaInicio(arbtramexp.getTrfecini());
		tramiteAux.setFechaFin(arbtramexp.getTrfecfin());

		CensoMonitor instructorAsignado = new CensoMonitor();
		if (arbtramexp.getCensoMonitor() != null && !arbtramexp.getCensoMonitor().equals("")) {
			instructorAsignado = arbtramexp.getCensoMonitor();
		}
		tramiteAux.setInstructorAsignado(instructorAsignado);

		CensoMonitor instructorEjecucion = new CensoMonitor();
		if (arbtramexp.getCensoMonitorEj() != null && !arbtramexp.getCensoMonitorEj().equals("")) {
			instructorEjecucion = arbtramexp.getCensoMonitorEj();
		}
		tramiteAux.setInstructorEjecucion(instructorEjecucion);
		tramiteAux.setEstadoTramite(arbtramexp.getTrestado());

		tramiteAux.setComentario(Y41bUtils.clobToString(arbtramexp.getTrobserves()));

		if (arbtramexp.getTrtridrel() != null) {
			tramiteAux.setPermisoModificacionOrigen(Y41bConstantes.NO);
		} else {
			tramiteAux.setPermisoModificacionOrigen(Y41bConstantes.SI);
		}

		/*
		 * PROPIO DEL TRAMITE
		 */
		tramiteAux.setOrigen(arbtramexp.getTipoDestOrigen());
		tramiteAux.setRespuesta(arbtramexp.getTrrespuesta());
		tramiteAux.setResumenAlegaciones(Y41bUtils.clobToString(arbtramexp.getTrresumenalegaciones()));

		if (this.tratamientoSeguridad(arbtramexp, censoMonitorAux)) {
			tramiteAux.setPermisoModificacion(Y41bConstantes.SI);
		} else {
			tramiteAux.setPermisoModificacion(Y41bConstantes.NO);
		}

		return tramiteAux;
	}

	/**
	 * Generar Tramite Automatico de Recepción Informacion desde Requerimiento
	 * de Acreditacion Representacion
	 * 
	 * @param RecepcionRequerimientoAcreditacionRepresentacion
	 *            Arbtramexp
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Arbtramexp
	 */
	@Transactional(rollbackFor = Throwable.class)
	private Arbtramexp sugiereTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			Arbtramexp requerimientoAcreditacionRepresentacion, Arbinterv arbinterv) throws Exception {

		Arbtramexp arbtramexp = new Arbtramexp();

		arbtramexp.setSolarb(requerimientoAcreditacionRepresentacion.getSolarb());
		arbtramexp.setTruaidinterv(arbinterv.getUaidinterv());
		arbtramexp.setTrcodigo(Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCIONREQUERIMIENTOACREDITACIONREPRESENTACION);
		arbtramexp.setTrcodigorel(requerimientoAcreditacionRepresentacion.getTrcodigo());
		arbtramexp.setTrtridrel(requerimientoAcreditacionRepresentacion.getTrid());
		arbtramexp.setFase(requerimientoAcreditacionRepresentacion.getFase());
		arbtramexp.setCensoMonitor(requerimientoAcreditacionRepresentacion.getCensoMonitorEj());

		// Evita problemas con las fechas desde hasta
		Locale locale = LocaleContextHolder.getLocale();
		Date today = new Date();
		Date todayWithZeroTime = Y41bUtils.parseDate(today, locale);

		arbtramexp.setTrfecini(todayWithZeroTime);

		arbtramexp.setTrestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		// Se fija el origen en funcin del requerimiento
		arbtramexp.setTipoDestOrigen(requerimientoAcreditacionRepresentacion.getTipoDestOrigen());

		// Se inserta el tramite
		this.arbtramexpDao.add(arbtramexp);

		return arbtramexp;
	}

	/**
	 * getTipoDocumento
	 * 
	 * @param roleId
	 *            String
	 * @return String
	 */
	protected String getTipoDocumento(String roleId) {
		String resultado = null;
		StringTokenizer tokCadena = null;
		tokCadena = new StringTokenizer(roleId, ".");
		String tipo = tokCadena.nextToken();
		String subtipo = tokCadena.nextToken();
		if (subtipo != null && !subtipo.equals("0")) {
			tipo = subtipo;
		} else {
			String asuntodocumental = tokCadena.nextToken();
			if (asuntodocumental != null && !asuntodocumental.equals("0")) {
				tipo = roleId;
			}
		}
		Arbtipdoc arbtipdoc = new Arbtipdoc();
		arbtipdoc.setIdTipodoc(tipo);
		List<Arbtipdoc> listaArbtipdoc = this.arbtipdocDao.findAll(arbtipdoc, null);
		if (listaArbtipdoc == null || (listaArbtipdoc != null && listaArbtipdoc.size() != 1)) {
			resultado = Y41bConstantes.TIPO_DOC_ARB_SOLICITUD;
		} else {
			resultado = ((Arbtipdoc) listaArbtipdoc.get(0)).getTdid();
		}
		return resultado;
	}

	/**
	 * copiarDocumentosAsientoRegistralNuevoArbitraje
	 * 
	 * @param idAsientoRegistral
	 *            String
	 * @param codigoExpediente
	 *            String
	 * @param idTramiteApertura
	 *            String
	 */
	public void copiarDocumentosAsientoRegistralNuevoArbitraje(String idAsientoRegistral, String codigoExpediente,
			String idTramiteApertura) {
		Arbtramexp2ServiceImpl.logger.info("copiarDocumentosAsientoRegistralNuevoArbitraje - Inicio");

		// Recuperar documentos del asiento registral
		AsientoRegistral asientoRegistral = new AsientoRegistral();
		asientoRegistral.setIdAsiento(idAsientoRegistral);
		asientoRegistral = this.asientoRegistralService.findAsientoRegistral(asientoRegistral);

		DocumentoAsientoRegistral docAsientoRegistral = new DocumentoAsientoRegistral();
		docAsientoRegistral.setAsientoRegistral(asientoRegistral);

		// Recuperar docs asociados
		List<DocumentoAsientoRegistral> listaDocumentoAsientoRegistral = this.documentosAsientoRegistralService
				.findAllDocumentosAR(docAsientoRegistral, null);

		for (DocumentoAsientoRegistral documentoAsientoRegistralAux : listaDocumentoAsientoRegistral) {
			if (Y41bUtils.isFilled(documentoAsientoRegistralAux.getOidDokusi())) {
				// descargar documentos dokusi
				Documento documento = new Documento();
				User user = new User();
				user.setNombre(Y41bConstantes.COD_APLICACION);
				user.setDni(Y41bConstantes.COD_APLICACION);
				documento.setUser(user);
				Procedure procedure = new Procedure();
				if (asientoRegistral.getPcodigo().equalsIgnoreCase(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SOLICITUDES);
				} else if (asientoRegistral.getPcodigo().equalsIgnoreCase(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
				} else if (asientoRegistral.getPcodigo().equalsIgnoreCase(Y41bConstantes.TIPO_PROC_SANCIONES)) {
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES);
				} else if (asientoRegistral.getPcodigo().equalsIgnoreCase(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
					procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE);
				}
				documento.setProcedure(procedure);
				documento.setOidDokusi(documentoAsientoRegistralAux.getOidDokusi());
				documento.setTipoDocumental(documentoAsientoRegistralAux.getTipoDoc());
				documento.setDescripcion(documentoAsientoRegistralAux.getDescDoc());
				Documento documentoSIR = y41bDokusiAdapterService.descargarDocumentoSIR(documento);

				Adjuntardocs adjuntardocs = new Adjuntardocs();
				adjuntardocs.setThnofile(documentoSIR.getNombre());
				adjuntardocs.setThtedesfile(documentoAsientoRegistralAux.getDescDoc());
				adjuntardocs.setThcodocumento(this.arbdoctempDao.getNewPK().toString());
				adjuntardocs.setThorigen(Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMANTE);
				adjuntardocs.setTipoDocumento(new TipoDocumento(documentoAsientoRegistralAux.getTipoDoc(), null, null));

				Blob blob;
				try {
					blob = new SerialBlob(Y41bUtilsWS.decode(documentoSIR.getBytes()));
				} catch (Y41bUDAException e) {
					throw e;
				} catch (Exception e) {
					throw new Y41bUDAException("error.generico", true, e);
				}
				adjuntardocs.setThdatafile(blob);

				adjuntardocs.setThcontenttypefile(documentoSIR.getContentType());
				adjuntardocs.setThsizefile((int) documentoSIR.getLength());

				adjuntardocs.setThidExpediente(codigoExpediente);
				adjuntardocs.setThidTramite(idTramiteApertura);
				adjuntardocs.setTipoProcedimiento(new TipoProcedimiento(Y41bConstantes.TIPO_PROC_ARBITRAJE));
				// adjuntardocs.setThfecha(new Date());
				adjuntardocs.setTrpcodigo(Y41bConstantes.TIPO_PROC_ARBITRAJE);

				// adjuntardocs.setThiddocumentum(documentoAsientoRegistralAux.getOidDokusi());
				// Guardamos el oid en el idinterviniente para identificar el
				// documento despues
				// No se puede guardar en iddocumentum porque intenta
				// descargarlo de dokusi y da error
				adjuntardocs.setIdInterviniente(documentoAsientoRegistralAux.getOidDokusi());

				adjuntardocs.setThfechaaportacion(asientoRegistral.getFechaRegistro());
				adjuntardocs.setThfecha(asientoRegistral.getFechaRegistro());
				adjuntardocs.setThfechaentrada(asientoRegistral.getFechaRegistro());
				adjuntardocs.setThnumregistroentrada(asientoRegistral.getNumRegistro());
				adjuntardocs.setThfecharegistroorigen(asientoRegistral.getFechaRegistroOrigen());
				adjuntardocs.setThnumregistroorigen(asientoRegistral.getNumRegistroOrigen());

				this.adjuntardocsDao.add(adjuntardocs);

			}
		}
	}
}