package com.ejie.y41b.service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Arbbandeja;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.TramiteARBApertura;
import com.ejie.y41b.model.TramiteARBMediacion;
import com.ejie.y41b.model.TramiteARBRecepcionSolicitudAclaracion;
import com.ejie.y41b.model.TramiteARBRecepcionSolicitudCopiaExpe;
import com.ejie.y41b.model.TramiteAdjuntarDocs;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteRecepcionRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.TramiteRequerimientoAcreditacionRepresentacion;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.platea.RegistroEntrada;

/**
 * ArbtramexpService  
 * 
 *  
 */

public interface Arbtramexp2Service {

	/**
	 * Inserts a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp add(Arbtramexp arbtramexp);

	/**
	 * Updates a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp update(Arbtramexp arbtramexp);

	/**
	 * Metodo que devuelve S si tiene permiso de modificacion, N si no tiene
	 * permiso de modificacion.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return boolean
	 */
	boolean tratamientoSeguridad(Arbtramexp arbtramexp, CensoMonitor censoMonitor);

	/**
	 * Updates a single row in the Arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbtramexp setArbtramexp(Arbtramexp arbtramexp);

	/**
	 * 
	 * @param excodigo
	 *            String
	 * @param tipoDeTramite
	 *            String
	 */
	void actualizaFaseArbexpDesdeTramite(String excodigo, String tipoDeTramite);

	/**
	 * Finds a single row in the arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            the arbtramexp
	 * @return Arbexp
	 */
	Arbexp actualizaUltimoTramiteArbexp(Arbtramexp arbtramexp);

	/**
	 * Finds a single row in the arbtramexp table.
	 * 
	 * @param arbtramexp
	 *            the arbtramexp
	 * @throws Exception
	 *             the exception
	 */
	void actualizaBandeja(Arbtramexp arbtramexp) throws Exception;

	/**
	 * Metodo que recibe una lista de documentos del tramite y los elimina en
	 * DOKUSI
	 * 
	 * @param listArbdoctemp
	 *            List<Arbdoctemp>
	 * @throws SQLException
	 *             SQLException
	 */
	void eliminarDocumentosDokusi(List<Arbdoctemp> listArbdoctemp) throws SQLException;

	/**
	 * Metodo que recibe una lista de documentos del tramite y actualiza la
	 * BANDEJA DE FIRMA con los documentos pendientes de firmar Cuando un
	 * documento se inserte en la bandeja de firma, se inserta en Dokusi el
	 * documento si no tiene oidDokusi
	 * 
	 * @param listDocumentoHecho
	 *            List<DocumentoHecho>
	 * @param tramiteComun
	 *            TramiteComun
	 * @param faseTramite
	 *            String
	 * @param tipoTramite
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	void actualizarBandejaFirma(List<Arbdoctemp> listDocumentoHecho, TramiteComun tramiteComun, String faseTramite,
			String tipoTramite) throws Exception;

	/**
	 * Actualizar el expediente.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp sugiereTramiteComunicacionAutomaticamente(Arbtramexp arbtramexp, Arbinterv arbinterv) throws Exception;

	/**
	 * Actualizar el expediente.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp sugiereTramiteNotificacionAutomaticamente(Arbtramexp arbtramexp, Arbinterv arbinterv) throws Exception;

	/**
	 * adjuntarDocumentosDeUnTramiteAOtroAutomaticamente
	 * 
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 */
	void adjuntarDocumentosDeUnTramiteAOtroAutomaticamente(String tridOrigen, String tridDestino);

	/**
	 * adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente
	 * 
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 * @param tipo
	 *            String
	 */
	void adjuntarDocumentosDeUnTipoDeUnTramiteAOtroAutomaticamente(String tridOrigen, String tridDestino, String tipo);

	/**
	 * Metodo que actualiza el estado de los tramites generados
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @throws SQLException
	 *             SQLException
	 */
	void calcularEstadoTramiteGenerado(Arbtramexp arbtramexp) throws SQLException;

	/**
	 * Actualizar el expediente.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param tipo
	 *            tipo
	 * @param fase
	 *            fase
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	// Arbtramexp sugiereTramiteAutomaticamente(Arbtramexp arbtramexp,
	// String tipo, String fase) throws Exception;
	//

	/**
	 * Actualizar el expediente.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param tipo
	 *            tipo
	 * @param fase
	 *            fase
	 * @param forzar
	 *            boolean : cuando llegamos con true significa que ya hemos
	 *            hecho comprobaciones previas para crear o no el trmite
	 *            sugerido, y queremos forzar su generacin
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp sugiereTramiteAutomaticamente(Arbtramexp arbtramexp, String tipo, String fase, boolean forzar)
			throws Exception;

	/**
	 * Actualizar el expediente.
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param tipo
	 *            tipo
	 * @param fase
	 *            fase
	 * @param decision
	 *            decision
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp sugiereTramiteDecisionAutomaticamente(Arbtramexp arbtramexp, String tipo, String fase, String decision)
			throws Exception;

	/**
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param solarb
	 *            Solarb
	 * @param tipo
	 *            String
	 * @throws Exception
	 *             Exception
	 */
	void generarNotificacionComunicacion(Arbtramexp arbtramexp, Solarb solarb, String tipo) throws Exception;

	/**
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param solarb
	 *            Solarb
	 * @param tipo
	 *            String
	 * @param arbinterv
	 *            Arbinterv
	 * @throws Exception
	 *             Exception
	 */
	public void generarNotificacionComunicacionInterviniente(Arbtramexp arbtramexp, Solarb solarb, String tipo,
			Arbinterv arbinterv) throws Exception;

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param anyadirPlantilla
	 *            String
	 * @return List<Arbdoctemp>
	 */
	List<Arbdoctemp> tratarDocumentosTemporal(TramiteComun tramiteComun, String anyadirPlantilla);

	/**
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param tramiteComun
	 *            TramiteComun
	 * @param listDocumentoHecho
	 *            Arbdoctemp
	 * @param isDocPendienteFirma
	 *            boolean
	 * @throws Exception
	 *             Exception
	 */
	void guardarTramite(Arbtramexp arbtramexp, TramiteComun tramiteComun, List<Arbdoctemp> listDocumentoHecho,
			boolean isDocPendienteFirma) throws Exception;

	/**
	 * 
	 * @param listDocumentoHecho
	 *            List<Arbdoctemp>
	 * @return boolean
	 */
	boolean hayDocsPendienteFirma(List<Arbdoctemp> listDocumentoHecho);

	/**
	 * 
	 * @param tramite
	 *            TramiteARBRecepcionSolicitudAclaracion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            tramitar
	 * @param modoARBRecepcionSolicitudAclaracion
	 *            String
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteRecepcionSolicitudAclaracion(TramiteARBRecepcionSolicitudAclaracion tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoARBRecepcionSolicitudAclaracion)
			throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param censoMonitor
	 *            censoMonitor
	 * @return TramiteARBRecepcionSolicitudAclaracion
	 */
	TramiteARBRecepcionSolicitudAclaracion findTramiteRecepcionSolicitudAclaracion(
			TramiteARBRecepcionSolicitudAclaracion tramite, CensoMonitor censoMonitor);

	/**
	 * 
	 * @param tramite
	 *            TramiteARBMediacion
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            tramitar
	 * @param modoARBMediacion
	 *            String
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteMediacion(TramiteARBMediacion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoARBMediacion) throws Exception;

	/**
	 * @param tramite
	 *            TramiteARBMediacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteARBMediacion
	 */
	TramiteARBMediacion findTramiteMediacion(TramiteARBMediacion tramite, CensoMonitor censoMonitor);

	/**
	 * Inserta los documentos en la tabla temporal de adjuntar documentacion
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addTramiteAdjuntarDocsTableTemporal(TramiteComun tramiteComun);

	/**
	 * Finds a single row in the ArbTramExp table.
	 * 
	 * @param tramite
	 *            TramiteARBApertura
	 * @param monitor
	 *            CensoMonitor
	 * @return TramiteARBApertura
	 */
	TramiteARBApertura findTramiteApertura(TramiteARBApertura tramite, CensoMonitor monitor);

	/**
	 * @param tramite
	 *            TramiteARBApertura
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            String
	 * @param tramitar
	 *            boolean
	 * @param modoARBApertura
	 *            String
	 * @param listDocumento
	 *            List<Documento>
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteApertura(TramiteARBApertura tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoARBApertura, List<Documento> listDocumento) throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idioma
	 *            idioma
	 * @param tramitar
	 *            tramitar
	 * @param modoARBRecepcionSolicitudCopiaExpe
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteRecepcionSolicitudCopiaExpe(TramiteARBRecepcionSolicitudCopiaExpe tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitar, String modoARBRecepcionSolicitudCopiaExpe)
			throws Exception;

	/**
	 * @param tramite
	 *            tramite
	 * @param monitor
	 *            censoMonitor
	 * @return TramiteARBRecepcionSolicitudCopiaExpe
	 */
	TramiteARBRecepcionSolicitudCopiaExpe findTramiteRecepcionSolicitudCopiaExpe(
			TramiteARBRecepcionSolicitudCopiaExpe tramite, CensoMonitor monitor);

	/**
	 * Inserta el documento recibido por parametro en la tabla temporal de
	 * adjuntar documentacion
	 * 
	 * @param listDocumentoExpediente
	 *            List<DocumentoExpediente>
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addDocumentosTableTemporal(List<DocumentoExpediente> listDocumentoExpediente, TramiteComun tramiteComun);

	/**
	 * @param tramiteComun
	 *            tramiteComun
	 * @param idInterviniente
	 *            idInterviniente
	 * @return RegistroEntrada
	 * @throws Exception
	 *             excepcion
	 */
	RegistroEntrada getRegistroEntrada(TramiteComun tramiteComun, String idInterviniente) throws Exception;

	/**
	 * Inserts a single row in the Arbtramexp table.
	 * 
	 * @param idioma
	 *            String
	 * @param tramite
	 *            TramiteGenerico
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            String
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteAdjuntarDocs(TramiteAdjuntarDocs tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the SanTramExp table.
	 * 
	 * @param tramiteAdjuntarDocs
	 *            TramiteAdjuntarDocs
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteAdjuntarDocs
	 */
	TramiteAdjuntarDocs findTramiteAdjuntarDocs(TramiteAdjuntarDocs tramiteAdjuntarDocs, CensoMonitor censoMonitor);

	/**
	 * 
	 * @param arbtramexp
	 *            Arbtramexp
	 * @param pagination
	 *            Pagination
	 * @return List<Arbtramexp>
	 */
	List<Arbtramexp> findTramitesAclaracion(Arbtramexp arbtramexp, Pagination pagination);

	/**
	 * 
	 * @param sacodigo
	 *            String
	 * @param mapa
	 *            Map<String, Object>
	 * @return Map<String, Object>
	 * @throws Exception
	 *             e
	 */
	Map<String, Object> obtenerDatosTramitesFichaArbitraje(String sacodigo, Map<String, Object> mapa) throws Exception;

	/**
	 * Rellena arb bandeja.
	 * 
	 * @param arbtramexp
	 *            the arbtramexp
	 * @param estado
	 *            the estado
	 * @return the arbbandeja
	 */
	Arbbandeja rellenaArbBandeja(Arbtramexp arbtramexp, String estado);

	/**
	 * Guardar tramite generico.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param tramiteComun
	 *            TramiteComun
	 * @param idioma
	 *            the idioma
	 * @param tramitear
	 *            the tramitear
	 * @param modoEditar
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteRequerimientoAcreditacionRepresentacion(TramiteRequerimientoAcreditacionRepresentacion tramite,
			TramiteComun tramiteComun, String idioma, boolean tramitear, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the santramexp table.
	 * 
	 * @param tramite
	 *            the tramite
	 * @param censoMonitor
	 *            the censo monitor
	 * @return TramiteGenerico
	 */
	TramiteRequerimientoAcreditacionRepresentacion findTramiteRequerimientoAcreditacionRepresentacion(
			TramiteRequerimientoAcreditacionRepresentacion tramite, CensoMonitor censoMonitor);

	/**
	 * Guardar el tramite Recepcion Requerimiento Acreditacion Representacion
	 * 
	 * @param tramite
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param tramiteComun
	 *            tramiteComun the tramite comun
	 * @param idioma
	 *            idioma String
	 * @param tramitar
	 *            boolean
	 * @param modoEditar
	 *            the modo editar
	 * @return Arbtramexp
	 * @throws Exception
	 *             Exception
	 */
	Arbtramexp addTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramite, TramiteComun tramiteComun, String idioma,
			boolean tramitar, String modoEditar) throws Exception;

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param tramite
	 *            TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return TramiteRecepcionRequerimientoAcreditacionRepresentacion
	 */
	TramiteRecepcionRequerimientoAcreditacionRepresentacion findTramiteRecepcionRequerimientoAcreditacionRepresentacion(
			TramiteRecepcionRequerimientoAcreditacionRepresentacion tramite, CensoMonitor censoMonitor);

	void addTramiteAdjuntarDocsFirmaArbitrosTemporal(TramiteComun tramiteComun);

	Map<String, Object> cargaDatosColegioArbitral(Solarb expDetalle, Arbtramexp organoColegioArbitral,
			List<Arbtramexp> lista, Map<String, Object> mapaOrganoColegioArbitral, String dateFormat) throws Exception;

	/**
	 * copiarDocumentosAsientoRegistralNuevoArbitraje
	 * 
	 * @param idAsientoRegistral
	 *            String
	 * @param codigoExpediente
	 *            String
	 * @param idTramiteApertura
	 *            String
	 */
	public void copiarDocumentosAsientoRegistralNuevoArbitraje(String idAsientoRegistral, String codigoExpediente,
			String idTramiteApertura);

}
