package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ArbtipdocDao;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.TipoDocumento;

/**
 * ArbtipdocServiceImpl  
 * 
 *  
 */

@Service(value = "arbtipdocService")
public class ArbtipdocServiceImpl implements ArbtipdocService {

	@Autowired
	private ArbtipdocDao arbtipdocDao;

	/**
	 * Inserts a single row in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @return Arbtipdoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtipdoc add(Arbtipdoc arbtipdoc) {
		return this.arbtipdocDao.add(arbtipdoc);
	}

	/**
	 * Updates a single row in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @return Arbtipdoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtipdoc update(Arbtipdoc arbtipdoc) {
		return this.arbtipdocDao.update(arbtipdoc);
	}

	/**
	 * Finds a single row in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @return Arbtipdoc
	 */
	public Arbtipdoc find(Arbtipdoc arbtipdoc) {
		return (Arbtipdoc) this.arbtipdocDao.find(arbtipdoc);
	}

	/**
	 * Finds a List of rows in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbtipdoc> findAll(Arbtipdoc arbtipdoc, Pagination pagination) {
		return (List<Arbtipdoc>) this.arbtipdocDao.findAll(arbtipdoc,
				pagination);
	}

	/**
	 * Counts rows in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @return Long
	 */
	public Long findAllCount(Arbtipdoc arbtipdoc) {
		return this.arbtipdocDao.findAllCount(arbtipdoc);
	}

	/**
	 * Finds rows in the Arbtipdoc table using like.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbtipdoc> findAllLike(Arbtipdoc arbtipdoc,
			Pagination pagination, Boolean startsWith) {
		return (List<Arbtipdoc>) this.arbtipdocDao.findAllLike(arbtipdoc,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbtipdoc table using like.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbtipdoc arbtipdoc, Boolean startsWith) {
		return this.arbtipdocDao.findAllLikeCount(arbtipdoc, startsWith);
	}

	/**
	 * Deletes a single row in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbtipdoc arbtipdoc) {
		this.arbtipdocDao.remove(arbtipdoc);
	}

	/**
	 * Deletes multiple rows in the Arbtipdoc table.
	 * 
	 * @param arbtipdocList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbtipdoc> arbtipdocList) {
		for (Arbtipdoc arbtipdocAux : arbtipdocList) {
			this.arbtipdocDao.remove(arbtipdocAux);
		}
	}

	/**
	 * Finds a List of rows in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipoDocumento> findAllTipoDocumento(Arbtipdoc arbtipdoc,
			Pagination pagination) {
		List<Arbtipdoc> listArbtipdoc = (List<Arbtipdoc>) this.arbtipdocDao
				.findAll(arbtipdoc, pagination);
		if (listArbtipdoc != null) {
			List<TipoDocumento> listTipoDocumento = new ArrayList<TipoDocumento>();
			if (listArbtipdoc.size() > 0) {
				TipoDocumento tipoDocumentoAux;
				for (Arbtipdoc arbtipdocAux : listArbtipdoc) {
					tipoDocumentoAux = new TipoDocumento();
					tipoDocumentoAux.setIdTipodoc(arbtipdocAux.getTdid());
					tipoDocumentoAux.setTdnombre(arbtipdocAux.getTdnombre());
					tipoDocumentoAux.setTdnombree(arbtipdocAux.getTdnombree());
					listTipoDocumento.add(tipoDocumentoAux);
				}
			}
			return listTipoDocumento;
		} else {
			return null;
		}
	}
}
