package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.TipoDocumento;

/**
 * ArbtipdocService  
 * 
 *  
 */

public interface ArbtipdocService {

	/**
	 * Inserts a single row in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @return Arbtipdoc
	 */
	Arbtipdoc add(Arbtipdoc arbtipdoc);

	/**
	 * Updates a single row in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @return Arbtipdoc
	 */
	Arbtipdoc update(Arbtipdoc arbtipdoc);

	/**
	 * Finds a single row in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @return Arbtipdoc
	 */
	Arbtipdoc find(Arbtipdoc arbtipdoc);

	/**
	 * Finds a List of rows in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbtipdoc> findAll(Arbtipdoc arbtipdoc, Pagination pagination);

	/**
	 * Counts rows in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @return Long
	 */
	Long findAllCount(Arbtipdoc arbtipdoc);

	/**
	 * Finds rows in the Arbtipdoc table using like.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbtipdoc> findAllLike(Arbtipdoc arbtipdoc, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbtipdoc table using like.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbtipdoc arbtipdoc, Boolean startsWith);

	/**
	 * Deletes a single row in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @return
	 */
	void remove(Arbtipdoc arbtipdoc);

	/**
	 * Deletes multiple rows in the Arbtipdoc table.
	 * 
	 * @param arbtipdocList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Arbtipdoc> arbtipdocList);

	/**
	 * @param arbtipdoc
	 * @param object
	 * @return
	 */
	List<TipoDocumento> findAllTipoDocumento(Arbtipdoc arbtipdoc,
			Pagination pagination);

}
