package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ArbtipdecaudDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbtipdecaud;

/**
 * ArbtipdecaudServiceImpl  
 *  
 */

@Service(value = "arbtipdecaudService")
public class ArbtipdecaudServiceImpl implements ArbtipdecaudService {

	@Autowired
	private ArbtipdecaudDao arbtipdecaudDao;

	/**
	 * Inserts a single row in the Arbtipdecaud table.
	 *
	 * @param arbtipdecaud Arbtipdecaud
	 * @return Arbtipdecaud
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtipdecaud add(Arbtipdecaud arbtipdecaud) {
		return this.arbtipdecaudDao.add(arbtipdecaud);
	}

	/**
	 * Updates a single row in the Arbtipdecaud table.
	 *
	 * @param arbtipdecaud Arbtipdecaud
	 * @return Arbtipdecaud
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbtipdecaud update(Arbtipdecaud arbtipdecaud) {
		return this.arbtipdecaudDao.update(arbtipdecaud);
	 }

	/**
	 * Finds a single row in the Arbtipdecaud table.
	 *
	 * @param arbtipdecaud Arbtipdecaud
	 * @return Arbtipdecaud
	 */
	public Arbtipdecaud find(Arbtipdecaud arbtipdecaud) {
		return (Arbtipdecaud) this.arbtipdecaudDao.find(arbtipdecaud);
	}

	/**
	 * Finds a List of rows in the Arbtipdecaud table.
	 *
	 * @param arbtipdecaud Arbtipdecaud
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Arbtipdecaud> findAll(Arbtipdecaud arbtipdecaud, Pagination pagination) {
		return (List<Arbtipdecaud>) this.arbtipdecaudDao.findAll(arbtipdecaud, pagination);
	}
    
	/**
	 * Counts rows in the Arbtipdecaud table.
	 *
	 * @param arbtipdecaud Arbtipdecaud
	 * @return Long
	 */
	public Long findAllCount(Arbtipdecaud arbtipdecaud) {        
		return  this.arbtipdecaudDao.findAllCount(arbtipdecaud);
	}

	/**
	 * Finds rows in the Arbtipdecaud table using like.
	 *
	 * @param arbtipdecaud Arbtipdecaud
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Arbtipdecaud> findAllLike(Arbtipdecaud arbtipdecaud, Pagination pagination, Boolean startsWith) {
		return (List<Arbtipdecaud>) this.arbtipdecaudDao.findAllLike(arbtipdecaud, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbtipdecaud table using like.
	 *
	 * @param arbtipdecaud Arbtipdecaud
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbtipdecaud arbtipdecaud, Boolean startsWith) {
		return this.arbtipdecaudDao.findAllLikeCount(arbtipdecaud, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Arbtipdecaud table.
	 *
	 * @param arbtipdecaud Arbtipdecaud
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbtipdecaud arbtipdecaud) {
		this.arbtipdecaudDao.remove(arbtipdecaud);
	}
	
	/**
	 * Deletes multiple rows in the Arbtipdecaud table.
	 *
	 * @param arbtipdecaudList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbtipdecaud> arbtipdecaudList) {
		for (Arbtipdecaud  arbtipdecaudAux:arbtipdecaudList) {
			this.arbtipdecaudDao.remove(arbtipdecaudAux);
		}
	}
	
}

