package com.ejie.y41b.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbnumsolDao;
import com.ejie.y41b.dao.ArbsoldocteleDao;
import com.ejie.y41b.dao.ArbsolteleDao;
import com.ejie.y41b.dao.ConsumidorDao;
import com.ejie.y41b.dao.IntervinientesDao;
import com.ejie.y41b.dao.T17LocalidadDao;
import com.ejie.y41b.dao.T17MunicipioDao;
import com.ejie.y41b.dao.T17PaisDao;
import com.ejie.y41b.dao.T17PortalDao;
import com.ejie.y41b.dao.T17ProvinciaDao;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbnumsol;
import com.ejie.y41b.model.Arbsoltele;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.ReclamacionArb;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.T17Localidad;
import com.ejie.y41b.model.T17Municipio;
import com.ejie.y41b.model.T17Pais;
import com.ejie.y41b.model.T17Portal;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.platea.ContextSubmission;
import com.ejie.y41b.model.platea.InterestedRRI;
import com.ejie.y41b.model.platea.RepresentativeRRI;
import com.ejie.y41b.model.platea.Contact;
import com.ejie.y41b.utils.Y41bEjgvUtils;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ArbsolteleServiceImpl  
 * 
 *  
 */

@Service(value = "arbsolteleService")
public class ArbsolteleServiceImpl implements ArbsolteleService {

	private static final Logger logger = LoggerFactory.getLogger(ArbsolteleServiceImpl.class);

	@Autowired()
	private ArbsolteleDao arbsolteleDao;

	@Autowired()
	private ArbsoldocteleDao arbsoldocteleDao;

	@Autowired()
	private SolarbService solarbservice;

	@Autowired()
	private ReclamacionArbService reclamacionArbService;

	@Autowired()
	private T17PaisDao paisDao;

	@Autowired()
	private T17ProvinciaDao provinciaDao;

	@Autowired()
	private T17MunicipioDao municipioDao;

	@Autowired()
	private T17LocalidadDao localidadDao;

	@Autowired()
	private T17PortalDao portalDao;

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired()
	private ArbnumsolDao arbnumsolDao;

	@Autowired()
	private ConsumidorDao consumidorDao;

	@Autowired()
	private IntervinientesDao intervinientesDao;

	/**
	 * Inserts a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return Arbsoltele
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbsoltele add(Arbsoltele arbsoltele) {
		return this.arbsolteleDao.add(arbsoltele);
	}

	/**
	 * Updates a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return Arbsoltele
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbsoltele update(Arbsoltele arbsoltele) {
		return this.arbsolteleDao.update(arbsoltele);
	}

	/**
	 * Finds a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return Arbsoltele
	 */
	public Arbsoltele find(Arbsoltele arbsoltele) {
		return (Arbsoltele) this.arbsolteleDao.find(arbsoltele);
	}

	/**
	 * Finds a List of rows in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbsoltele> findAll(Arbsoltele arbsoltele, Pagination pagination) {
		return (List<Arbsoltele>) this.arbsolteleDao.findAll(arbsoltele, pagination);
	}

	/**
	 * Counts rows in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return Long
	 */
	public Long findAllCount(Arbsoltele arbsoltele) {
		return this.arbsolteleDao.findAllCount(arbsoltele);
	}

	/**
	 * Finds rows in the Arbsoltele table using like.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbsoltele> findAllLike(Arbsoltele arbsoltele, Pagination pagination, Boolean startsWith) {
		return (List<Arbsoltele>) this.arbsolteleDao.findAllLike(arbsoltele, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbsoltele table using like.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbsoltele arbsoltele, Boolean startsWith) {
		return this.arbsolteleDao.findAllLikeCount(arbsoltele, startsWith);
	}

	/**
	 * Deletes a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbsoltele arbsoltele) {
		this.arbsolteleDao.remove(arbsoltele);
	}

	/**
	 * Deletes multiple rows in the Arbsoltele table.
	 * 
	 * @param arbsolteleList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbsoltele> arbsolteleList) {
		for (Arbsoltele arbsolteleAux : arbsolteleList) {
			this.arbsolteleDao.remove(arbsolteleAux);
		}
	}

	/**
	 * Metodo para recuperar de Dokusi los datos de la solicitud telematica
	 * 
	 * @param solicitudID
	 *            String
	 * @return HashMap<String, String>
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	private HashMap<String, String> cogerDatosSolicitudDokusi(String solicitudID) throws Exception {

		HashMap<String, String> datosSolicitud = new HashMap<String, String>();

		try {
			if (solicitudID != null) {
				String ejgvStr = this.y41bPlateaAdapterService.getRequestInformation(solicitudID, null);

				String xml = Y41bEjgvUtils.getDetailInfo(ejgvStr);

				// Mapear los datos de DetailInfo
				XMLInputFactory factory = XMLInputFactory.newInstance();
				XMLEventReader reader = factory.createXMLEventReader(new java.io.StringReader(xml));

				String nombreElemento = null;
				while (reader.hasNext()) {
					XMLEvent event = reader.nextEvent();
					if (event.isStartElement()) {
						nombreElemento = ((StartElement) event).getName().toString();
					}
					if (event.isCharacters()) {
						Characters characters = (Characters) event;
						if (characters.getData() != null && !"".equals(characters.getData())
								&& !"\n".equals(characters.getData()) && !"\r\n".equals(characters.getData())) {
							datosSolicitud.put(nombreElemento, characters.getData());
						}
					}
				}
			}

			return datosSolicitud;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
	}

	/**
	 * Metodo para recuperar de Dokusi los datos de la solicitud telematica y
	 * almacenarlos en el objeto Solarb
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param contextSubmission
	 *            ContextSubmission
	 * @param solicitudID
	 *            String
	 * @return Solarb
	 * @throws Exception
	 *             excepcion
	 * 
	 */
	protected Solarb cargarDatosArbitrajeSolTelematica(Arbexp arbexp, ContextSubmission contextSubmission,
			String solicitudID) throws Exception {

		Solarb solarb = new Solarb();
		ReclamacionArb reclamacionPrevia = new ReclamacionArb();

		try {

			HashMap<String, String> datosSolicitud = this.cogerDatosSolicitudDokusi(solicitudID);

			if (datosSolicitud != null) {

				// Calcular el numero de expediente
				BigDecimal anyo = new BigDecimal(Y41bUtils.fncObtenerAnnoSistema());
				solarb.setSanran(anyo);
				solarb.setSacoja(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);

				Arbnumsol arbnumsol = new Arbnumsol();
				arbnumsol.setArbcoor(solarb.getSacoja());
				arbnumsol.setArbnran(solarb.getSanran());
				solarb.setSanror(this.arbnumsolDao.findAndAddNumSolicitud(arbnumsol));

				// Fecha de solicitud
				solarb.setSafesoli(arbexp.getExfecreg());
				// Forma de notificacion reclamante
				solarb.setFormanotifreclamante(Y41bConstantes.TIPO_NOTIFICACION_TELEMATICA);

				// Presentado por particular
				solarb.setSainacuo(Y41bConstantes.PRESENTADOPOR_ARB_PARTICULAR);

				// TODO SAPUB
				solarb.setSapub("N");

				// Forma de presentacion
				arbexp.setExformapres(Y41bConstantes.FORMA_PRESENTACION_SOLICITUD_WEB);
				// Fecha de inicio
				arbexp.setExfecini(arbexp.getExfecreg());

				String idiomaSolicitud = Y41bConstantes.CASTELLANO;
				// Datos del hecho denunciado
				if (datosSolicitud.get("datosHecho_fecha") != null
						&& !"".equals(datosSolicitud.get("datosHecho_fecha"))) {

					String fechaHecho = datosSolicitud.get("datosHecho_fecha");

					StringTokenizer token = new StringTokenizer(fechaHecho, "/");

					Date hdfehd = null;
					if (token.nextToken().length() == 2) {
						hdfehd = Y41bUtils.parseDate(datosSolicitud.get("datosHecho_fecha"),
								new Locale(Y41bConstantes.CASTELLANO));
						idiomaSolicitud = Y41bConstantes.CASTELLANO;
					} else {
						hdfehd = Y41bUtils.parseDate(datosSolicitud.get("datosHecho_fecha"),
								new Locale(Y41bConstantes.EUSKERA));
						idiomaSolicitud = Y41bConstantes.EUSKERA;
					}
					arbexp.setHdfechd(hdfehd);
				}
				arbexp.setHdte(datosSolicitud.get("datosHecho_descripcion"));
				arbexp.setHdcotsr(datosSolicitud.get("datosPretensiones_reclamacion"));

				BigDecimal importe = null;
				if (Y41bUtils.isFilled(datosSolicitud.get("datosPretensiones_importe"))) {
					importe = new BigDecimal(
							datosSolicitud.get("datosPretensiones_importe").replace('\u002c', '\u002e'));
				}
				arbexp.setHdcaptso(importe);
				String comentarios = datosSolicitud.get("datosPretensiones_comentarios");
				if (comentarios != null && comentarios.length() > Y41bConstantes.NUM_4000) {
					arbexp.setHdteso(comentarios.substring(0, Y41bConstantes.NUM_4000));
				} else {
					arbexp.setHdteso(comentarios);
				}

				// tipo de presentacin : O --> ORDINARIA
				arbexp.setExtippres(Y41bConstantes.TIPOPRES_ARB_ORDINARIA);

				// idioma
				arbexp.setExidisol(idiomaSolicitud);

				solarb.setArbexp(arbexp);

				String nif = "";
				// Solicitante y representante
				String email = "";
				String telefono = "";

				RepresentativeRRI representanteReclamante = null;
				InterestedRRI reclamante = null;

				reclamante = contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0);

				representanteReclamante = contextSubmission.getApplicantInfoRRI().getRepresentativeRRI();

				if (contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0)
						.getAccount() != null
						&& contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0)
								.getAccount().getContactList() != null
						&& contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0)
								.getAccount().getContactList().getContact() != null
						&& !contextSubmission.getApplicantInfoRRI().getInterestedListRRI().getInterestedRRI().get(0)
								.getAccount().getContactList().getContact().isEmpty()) {
					for (Contact contact : contextSubmission.getApplicantInfoRRI().getInterestedListRRI()
							.getInterestedRRI().get(0).getAccount().getContactList().getContact()) {
						if (Y41bConstantes.CONTACT_TOOLKIT.EMAIL.equals(contact.getType())) {
							email = contact.getValue().getEmailAddress();
						}

						if (Y41bConstantes.CONTACT_TOOLKIT.SMS.equals(contact.getType())) {
							telefono = contact.getValue().getSmsNumber();
						}
					}
				}

				if (representanteReclamante != null) {

					if (contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getAccount() != null
							&& contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getAccount()
									.getContactList() != null
							&& contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getAccount()
									.getContactList().getContact() != null
							&& !contextSubmission.getApplicantInfoRRI().getRepresentativeRRI().getAccount()
									.getContactList().getContact().isEmpty()) {
						for (Contact contact : contextSubmission.getApplicantInfoRRI().getRepresentativeRRI()
								.getAccount().getContactList().getContact()) {
							if (Y41bConstantes.CONTACT_TOOLKIT.EMAIL.equals(contact.getType())) {
								email = contact.getValue().getEmailAddress();
							}

							if (Y41bConstantes.CONTACT_TOOLKIT.SMS.equals(contact.getType())) {
								telefono = contact.getValue().getSmsNumber();
							}
						}
					}
				}
				// Person[] solicitantes = contextSubmission.getApplicantInfo()
				// .getPersons().getPersonArray();
				//
				// // Si hay mas de una persona, una es la reclamante y la otra
				// es
				// // el representante
				// Person representante = null;
				// Person reclamante = null;
				// if (solicitantes.length > 1) {
				// for (Person persona : solicitantes) {
				// if (contextSubmission.getSenderID().equals(
				// persona.getId())) {
				// representante = persona;
				// } else {
				// reclamante = persona;
				// nif = reclamante.getId();
				// }
				// }
				// } else {
				// reclamante = solicitantes[0];
				// nif = reclamante.getId();
				// }

				// Buscar el codigo del Hecho denunciado
				String codexpediente = datosSolicitud.get("datosReclamacionPrev_codigo");

				ReclamacionArb reclamacionFiltro = new ReclamacionArb();
				reclamacionFiltro.setNumExpediente(codexpediente);
				reclamacionFiltro.setDtnif(nif);
				reclamacionFiltro.setindNoRelacionada(Y41bConstantes.VALOR_SI);
				reclamacionFiltro.setHdcosc(Y41bConstantes.TIPO_SOLICITUD_RECLAMACION);

				List<ReclamacionArb> listSolicitudesBusqueda = this.reclamacionArbService
						.findAllLikeSolicitudes(reclamacionFiltro, null, Boolean.FALSE);

				if (listSolicitudesBusqueda != null && listSolicitudesBusqueda.size() > 0) {
					reclamacionPrevia = listSolicitudesBusqueda.get(0);

					solarb.setSacohd(reclamacionPrevia.getHdcodigo());
				} else {
					throw new Exception("No existe reclamacion previa");
				}

				String esExtranjero = Y41bConstantes.ARBITRAJE_TOOLKIT_ESEXTRANJERO_SI.equals(
						datosSolicitud.get("datosChoiceDireccion")) ? Y41bConstantes.VALOR_SI : Y41bConstantes.VALOR_NO;

				Consumidor consumidorReclamante = new Consumidor();
				consumidorReclamante.setDtnif(reclamante.getID());
				consumidorReclamante.setDtnombre(reclamante.getName());
				consumidorReclamante.setDtapellido1(reclamante.getApe1());
				consumidorReclamante.setDtapellido2(reclamante.getApe2());
				consumidorReclamante.setDtextranjero(esExtranjero);

				// Email y telefono del reclamante
				consumidorReclamante.setDttecoem(email);
				consumidorReclamante.setDtnrtel(telefono);

				// Notice[] notices = contextSubmission.getApplicantInfo()
				// .getNotices().getNoticeArray();
				// boolean setteadoEmail = false;
				// boolean setteadoTelefono = false;
				// String email = null;
				// String telefono = null;
				// for (Notice notice : notices) {
				// if (!setteadoEmail
				// && Y41bConstantes.ARBITRAJE_TOOLKIT_CANALNOTIFICACION_EMAIL
				// .equals(notice.getChannel()
				// .getChannelType())) {
				// email = notice.getChannel().getChannelInfo().toString()
				// .replaceAll("<[^>]+>", "");
				// consumidorReclamante.setDttecoem(email);
				// setteadoEmail = true;
				// } else if (!setteadoTelefono
				// &&
				// Y41bConstantes.ARBITRAJE_TOOLKIT_CANALNOTIFICACION_TELEFONO
				// .equals(notice.getChannel()
				// .getChannelType())) {
				// telefono = notice.getChannel().getChannelInfo()
				// .toString().replaceAll("<[^>]+>", "");
				// consumidorReclamante.setDtnrtel(telefono);
				// setteadoTelefono = true;
				// }
				// }

				if (Y41bConstantes.VALOR_NO.equals(esExtranjero)) {
					// Provincia
					consumidorReclamante
							.setDtnoraProvinciaId(datosSolicitud.get("holderchoiceProvinciaDireccionEstado"));
					T17Provincia t17provincia = new T17Provincia();
					t17provincia.setId(datosSolicitud.get("holderchoiceProvinciaDireccionEstado"));
					t17provincia = this.provinciaDao.find(t17provincia);
					consumidorReclamante.setDtnombreProvincia(t17provincia.getDsO());

					// Municipio
					consumidorReclamante
							.setDtnoraMunicipioId(datosSolicitud.get("holderchoiceMunicipioDireccionEstado"));
					T17Municipio t17municipio = new T17Municipio();
					t17municipio.setProvinciaId(datosSolicitud.get("holderchoiceProvinciaDireccionEstado"));
					t17municipio.setId(datosSolicitud.get("holderchoiceMunicipioDireccionEstado"));
					t17municipio = this.municipioDao.find(t17municipio);
					consumidorReclamante.setDtnombreMunicipio(t17municipio.getDsO());

					// Localidad
					if (Y41bUtils.isFilled(datosSolicitud.get("holderchoiceLocalidadDireccionEstado"))) {
						consumidorReclamante
								.setDtnoraLocalidadId(datosSolicitud.get("holderchoiceLocalidadDireccionEstado"));
						T17Localidad t17localidad = new T17Localidad();
						t17localidad.setId(datosSolicitud.get("holderchoiceLocalidadDireccionEstado"));
						t17localidad = this.localidadDao.find(t17localidad);
						consumidorReclamante.setDtnombreLocalidad(t17localidad.getDsO());
					}

					// CP
					consumidorReclamante.setDtnombreCp(datosSolicitud.get("holderchoiceCPDireccionEstado"));
					// Calle
					consumidorReclamante.setDtnoraCalleId(datosSolicitud.get("holderchoiceCalleDireccionEstadoCod"));
					consumidorReclamante.setDtnombreCalle(datosSolicitud.get("holderchoiceCalleDireccionEstado"));

					// Portal
					consumidorReclamante.setDtnoraPortalId(null);
					consumidorReclamante.setDtnombrePortal(null);
					if (Y41bUtils.isFilled(consumidorReclamante.getDtnoraCalleId())
							&& Y41bUtils.isFilled(datosSolicitud.get("holderchoicePortalDireccionEstado"))
							&& Y41bUtils.isNumericShort(datosSolicitud.get("holderchoicePortalDireccionEstado"))) {
						T17Portal t17portal = new T17Portal();
						t17portal.setCalleId(new Long(consumidorReclamante.getDtnoraCalleId()));
						t17portal.setNumero(Short.parseShort(datosSolicitud.get("holderchoicePortalDireccionEstado")));
						List<T17Portal> listaPortales = this.portalDao.findAll(t17portal, null);
						if (listaPortales != null && listaPortales.size() == 1) {
							consumidorReclamante.setDtnoraPortalId(listaPortales.get(0).getId().toString());
						}
					}

					StringBuilder nombrePiso = new StringBuilder("");
					if (Y41bUtils.isFilled(datosSolicitud.get("holderchoiceCalleDireccionEstado"))
							&& !Y41bUtils.isFilled(consumidorReclamante.getDtnoraCalleId())) {
						nombrePiso.append(datosSolicitud.get("holderchoiceCalleDireccionEstado"));
						if (Y41bUtils.isFilled(datosSolicitud.get("holderchoicePortalDireccionEstado"))
								&& !Y41bUtils.isFilled(consumidorReclamante.getDtnoraPortalId())) {
							nombrePiso.append(" ").append(datosSolicitud.get("holderchoicePortalDireccionEstado"));
						}
					}
					// if (Y41bUtils.isFilled(datosSolicitud
					// .get("holderchoicePortalDireccionEstado"))) {
					// nombrePiso
					// .append(" ")
					// .append(datosSolicitud
					// .get("holderchoicePortalDireccionEstado")
					// + " ");
					// }
					if (Y41bUtils.isFilled(datosSolicitud.get("holderchoiceEscaleraDireccionEstado"))) {
						nombrePiso.append(datosSolicitud.get("holderchoiceEscaleraDireccionEstado") + " ");
					}
					if (Y41bUtils.isFilled(datosSolicitud.get("holderchoicePisoDireccionEstado"))) {
						nombrePiso.append(datosSolicitud.get("holderchoicePisoDireccionEstado"));
					}
					if (Y41bUtils.isFilled(datosSolicitud.get("holderchoiceLetraDireccionEstado"))) {
						nombrePiso.append(datosSolicitud.get("holderchoiceLetraDireccionEstado") + " ");
					}

					consumidorReclamante.setDtnombrePiso(nombrePiso.toString().trim());

				} else {
					// Pais
					T17Pais t17pais = new T17Pais();
					t17pais.setId(datosSolicitud.get("holderchoicePaisDireccionExtranjero"));
					t17pais = this.paisDao.find(t17pais);
					consumidorReclamante.setDtnoraPaisNombre(t17pais.getDsO());
					consumidorReclamante.setDtnoraPaisId(datosSolicitud.get("holderchoicePaisDireccionExtranjero"));

					// Direccion
					StringBuilder direccion = new StringBuilder("");
					if (Y41bUtils.isFilled(datosSolicitud.get("holderchoiceDireccionExtranjero"))) {
						direccion.append(datosSolicitud.get("holderchoiceDireccionExtranjero"));
					}
					if (!"".equals(direccion.toString())) {
						direccion.append(" - ");
					}
					if (Y41bUtils.isFilled(datosSolicitud.get("holderchoiceCPDireccionExtranjero"))) {
						direccion.append(datosSolicitud.get("holderchoiceCPDireccionExtranjero"));
					}

					consumidorReclamante.setDtdireccion_nocapv(direccion.toString());
				}

				boolean presentadoPorTitular = false;
				if (contextSubmission.getSenderID() != null && reclamante != null && reclamante.getID() != null
						&& contextSubmission.getSenderID().equalsIgnoreCase(reclamante.getID())) {
					presentadoPorTitular = true;
				}

				// Buscar el reclamante (tiene que existir porque parte de una
				// reclamacin previa ya creada en el sistema)
				Intervinientes intervinientes = new Intervinientes();
				intervinientes.setIdExpediente(reclamacionPrevia.getHdcodigo());
				intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO);

				List<Intervinientes> listIntervinientes = this.intervinientesDao.findAll(intervinientes, null);
				if (listIntervinientes.size() > 0) {
					intervinientes = listIntervinientes.get(0);

					Consumidor consumidorAux = new Consumidor();
					consumidorAux.setDtcodigo(intervinientes.getDtcodigo());
					List<Consumidor> listConsumidor = this.consumidorDao.findAllLikeConsumidor(consumidorAux, null,
							false);
					if (listConsumidor != null && listConsumidor.size() > 0) {
						// Si tiene representante, solo se actualiza el nombre y
						// apellidos
						consumidorAux = listConsumidor.get(0);

						this.actualizarConsumidor(consumidorAux, consumidorReclamante, presentadoPorTitular);

						solarb.setDtcodigo(consumidorAux.getDtcodigo());
					}
				}

				// Si hay un representante, recoger sus datos personales y
				// direccin
				if (representanteReclamante != null) {
					Arbinterv arbIntervRepresentante = new Arbinterv();
					// Inicialmente el representante se marca como no validado
					// (se valida posteriormente en el tramite de acreditacion
					// del
					// representante)
					arbIntervRepresentante
							.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTESOL_REPRESENTANTE_RECLAMANTE_NO_VALIDADO);

					arbIntervRepresentante.setUanombre(representanteReclamante.getName());
					arbIntervRepresentante.setUaapellido1(representanteReclamante.getApe1());
					arbIntervRepresentante.setUaapellido2(representanteReclamante.getApe2());
					arbIntervRepresentante.setUanif(representanteReclamante.getID());
					arbIntervRepresentante.setUacoem(email);
					arbIntervRepresentante.setUanrtel(telefono);

					if (!presentadoPorTitular) {
						arbIntervRepresentante.setUaextranjero(esExtranjero);
						if (Y41bConstantes.VALOR_NO.equals(esExtranjero)) {
							// Provincia
							arbIntervRepresentante
									.setUaprovId(datosSolicitud.get("holderchoiceProvinciaDireccionEstado"));

							// Municipio
							arbIntervRepresentante
									.setUamunId(datosSolicitud.get("holderchoiceMunicipioDireccionEstado"));

							// Localidad
							arbIntervRepresentante
									.setUalocId(datosSolicitud.get("holderchoiceLocalidadDireccionEstado"));

							// CP
							arbIntervRepresentante.setUacpId(datosSolicitud.get("holderchoiceCPDireccionEstado"));
							// Calle
							arbIntervRepresentante
									.setUacalleId(datosSolicitud.get("holderchoiceCalleDireccionEstadoCod"));

							// Portal
							arbIntervRepresentante.setUaportalId(null);
							if (Y41bUtils.isFilled(arbIntervRepresentante.getUacalleId())
									&& Y41bUtils.isFilled(datosSolicitud.get("holderchoicePortalDireccionEstado"))
									&& Y41bUtils
											.isNumericShort(datosSolicitud.get("holderchoicePortalDireccionEstado"))) {
								T17Portal t17portal = new T17Portal();
								t17portal.setCalleId(new Long(arbIntervRepresentante.getUacalleId()));
								t17portal.setNumero(
										Short.parseShort(datosSolicitud.get("holderchoicePortalDireccionEstado")));
								List<T17Portal> listaPortales = this.portalDao.findAll(t17portal, null);
								if (listaPortales != null && listaPortales.size() == 1) {
									arbIntervRepresentante.setUaportalId(listaPortales.get(0).getId().toString());
								}
							}

							// Nombre piso (calle + portal + escalera + piso +
							// letra)
							StringBuilder nombrePiso = new StringBuilder("");
							if (Y41bUtils.isFilled(datosSolicitud.get("holderchoiceCalleDireccionEstado"))
									&& !Y41bUtils.isFilled(arbIntervRepresentante.getUacalleId())) {
								nombrePiso.append(datosSolicitud.get("holderchoiceCalleDireccionEstado"));
								if (Y41bUtils.isFilled(datosSolicitud.get("holderchoicePortalDireccionEstado"))
										&& !Y41bUtils.isFilled(arbIntervRepresentante.getUaportalId())) {
									nombrePiso.append(" ")
											.append(datosSolicitud.get("holderchoicePortalDireccionEstado"));
								}
							}
							// Escalera
							if (Y41bUtils.isFilled(datosSolicitud.get("holderchoiceEscaleraDireccionEstado"))) {
								nombrePiso.append(datosSolicitud.get("holderchoiceEscaleraDireccionEstado") + " ");
							}
							// Piso
							if (Y41bUtils.isFilled(datosSolicitud.get("holderchoicePisoDireccionEstado"))) {
								nombrePiso.append(datosSolicitud.get("holderchoicePisoDireccionEstado"));
							}
							// Letra
							if (Y41bUtils.isFilled(datosSolicitud.get("holderchoiceLetraDireccionEstado"))) {
								nombrePiso.append(datosSolicitud.get("holderchoiceLetraDireccionEstado") + " ");
							}

							arbIntervRepresentante.setUanombrePiso(nombrePiso.toString().trim());
						} else {
							// Pais
							arbIntervRepresentante
									.setUapaisId(datosSolicitud.get("holderchoicePaisDireccionExtranjero"));

							StringBuilder direccion = new StringBuilder("");
							if (Y41bUtils.isFilled(datosSolicitud.get("holderchoiceDireccionExtranjero"))) {
								direccion.append(datosSolicitud.get("holderchoiceDireccionExtranjero"));
							}
							if (!"".equals(direccion.toString())) {
								direccion.append(" - ");
							}
							if (Y41bUtils.isFilled(datosSolicitud.get("holderchoiceCPDireccionExtranjero"))) {
								direccion.append(datosSolicitud.get("holderchoiceCPDireccionExtranjero"));
							}

							arbIntervRepresentante.setUadireNocapv(direccion.toString());
						}
					}

					solarb.setRepresentante(arbIntervRepresentante);
				}
			}

		} catch (

		Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			ArbsolteleServiceImpl.logger.error("cargarDatosArbitrajeSolTelematica", e);
			throw new Y41bUDAException("error.platea.invocation", true, e);
		}
		return solarb;
	}

	/**
	 * Metodo para actualizar lso datos del consumidor
	 * 
	 * @param consumidorAux
	 *            Consumidor
	 * @param consumidorReclamante
	 *            Consumidor
	 * @param presentadoPorTitular
	 *            boolean
	 */
	private void actualizarConsumidor(Consumidor consumidorAux, Consumidor consumidorReclamante,
			boolean presentadoPorTitular) {

		ArbsolteleServiceImpl.logger.info("actualizarConsumidor - consumidorAux: " + consumidorAux.toString());
		ArbsolteleServiceImpl.logger
				.info("actualizarConsumidor - consumidorReclamante: " + consumidorReclamante.toString());
		ArbsolteleServiceImpl.logger.info("actualizarConsumidor - presentadoPorTitular: " + presentadoPorTitular);

		consumidorAux.setCensoMonitor(new CensoMonitor(Y41bConstantes.CODIGO_USUARIO_SYS_CENSO_MONITOR, null));
		consumidorAux.setDtnombre(consumidorReclamante.getDtnombre());
		consumidorAux.setDtnif(consumidorReclamante.getDtnif());
		consumidorAux.setDtapellido1(consumidorReclamante.getDtapellido1());
		consumidorAux.setDtapellido2(consumidorReclamante.getDtapellido2());

		if (presentadoPorTitular) {
			consumidorAux.setDtextranjero(consumidorReclamante.getDtextranjero());

			if (!Y41bUtils.esNullOCadenaVacia(consumidorReclamante.getDttecoem())) {
				consumidorAux.setDttecoem(consumidorReclamante.getDttecoem());
			}
			if (!Y41bUtils.esNullOCadenaVacia(consumidorReclamante.getDtnrtel())) {
				consumidorAux.setDtnrtel(consumidorReclamante.getDtnrtel());
			}
			consumidorAux.setDtnoraProvinciaId(consumidorReclamante.getDtnoraProvinciaId());
			consumidorAux.setDtnombreProvincia(consumidorReclamante.getDtnombreProvincia());
			consumidorAux.setDtnoraMunicipioId(consumidorReclamante.getDtnoraMunicipioId());
			consumidorAux.setDtnombreMunicipio(consumidorReclamante.getDtnombreMunicipio());
			consumidorAux.setDtnoraLocalidadId(consumidorReclamante.getDtnoraLocalidadId());
			consumidorAux.setDtnombreLocalidad(consumidorReclamante.getDtnombreLocalidad());
			consumidorAux.setDtnombreCp(consumidorReclamante.getDtnombreCp());
			consumidorAux.setDtnoraCalleId(consumidorReclamante.getDtnoraCalleId());
			consumidorAux.setDtnombreCalle(consumidorReclamante.getDtnombreCalle());
			consumidorAux.setDtnombrePortal(consumidorReclamante.getDtnombrePortal());
			consumidorAux.setDtnoraPortalId(consumidorReclamante.getDtnoraPortalId());
			consumidorAux.setDtnombrePiso(consumidorReclamante.getDtnombrePiso());
			consumidorAux.setDtnoraPaisId(consumidorReclamante.getDtnoraPaisId());
			consumidorAux.setDtdireccion_nocapv(consumidorReclamante.getDtdireccion_nocapv());
		}

		this.consumidorDao.update(consumidorAux);

	}

	/**
	 * Metodo de recepcion y almacenamiento de una solicitud telemtica de
	 * arbitraje generada a traves del toolkit de formularios
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param contextSubmission
	 *            ContextSubmission
	 * @param listDocumento
	 *            List
	 * @param solicitudID
	 *            String
	 * @return Solarb
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Solarb recibirSolicitudTelematica(Arbexp arbexp, ContextSubmission contextSubmission,
			List<Documento> listDocumento, String solicitudID) throws Exception {

		Solarb solarb = new Solarb();
		try {
			// Recuperar de Dokusi los datos de la solicitud telematica
			Solarb solicitudDetalleAux = this.cargarDatosArbitrajeSolTelematica(arbexp, contextSubmission, solicitudID);

			// aadimos la solicitud
			Map<String, Object> retornoAlta = this.solarbservice.addDesdeTelematica(solicitudDetalleAux, listDocumento);

			Solarb nuevasolicitud = (Solarb) retornoAlta.get("solarb");
			// Arbtramexp tramiteApertura = (Arbtramexp) retornoAlta
			// .get("tramiteApertura");
			nuevasolicitud.setNumExpediente(nuevasolicitud.damecodCompletoPlatea());

			ArbsolteleServiceImpl.logger.debug("FIN RECIBIR SOLICITUD TELEMTICA");
			// devolver la solicitud
		} catch (Exception e) {
			e.printStackTrace();
			throw new Exception();
		}

		return solarb;
	}

	/**
	 * eliminar las solicitudes telemticas que se quedan en BBDD pero que no se
	 * llegan a recibir porque no se han registrado Eliminamos aquellas que
	 * hayan pasado ms de una semana.
	 * 
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void limpiarTemporalesTelematicasAntiguas() throws Exception {

		// se podran borrar todos los documentos "muertos" de dokusi... pero en
		// reclamaciones no se hace, ni siquiera eliminan las muertas...
		this.arbsoldocteleDao.removeTelematicosAntiguas();

		this.arbsolteleDao.removeTelematicosAntiguas();

	}

	/**
	 * Metodo para validar la resolucion previa a partir del NIF del reclamante
	 * y el cdigo de expediente
	 * 
	 * @param nif
	 *            String
	 * @param codexpediente
	 *            String
	 * @return boolean
	 * @throws Exception
	 *             ex
	 */
	public boolean validarReclamacionPrevia(String nif, String codexpediente) throws Exception {

		boolean esValida = false;

		try {

			ReclamacionArb reclamacionFiltro = new ReclamacionArb();
			reclamacionFiltro.setNumExpediente(codexpediente != null ? codexpediente.toUpperCase() : codexpediente);
			reclamacionFiltro.setDtnif(nif);
			reclamacionFiltro.setindNoRelacionada(Y41bConstantes.VALOR_SI);
			reclamacionFiltro.setHdcosc(Y41bConstantes.TIPO_SOLICITUD_RECLAMACION);

			Long totalReclamacionPrevia = this.reclamacionArbService.findAllLikeSolicitudesCount(reclamacionFiltro,
					Boolean.FALSE);

			if (totalReclamacionPrevia > 0) {
				esValida = true;
			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new Exception();
		}

		return esValida;
	}

	/**
	 * Mtodo para comprobar que el expediente de reclamacin cumpla unas
	 * condiciones. La resolucion previa indicado en campo a partir del NIF del
	 * reclamante y el reclamado de expediente (en arbitraje hay que comprobar
	 * que no haya expedientes anteriores.
	 * 
	 * @param nifReclamante
	 *            String
	 * @param nifReclamado
	 *            String
	 * @return HashMap<String, String>
	 * @throws Exception
	 *             excepcion
	 * 
	 */
	public List<ReclamacionArb> cogerExpedientesReclamacionPrevia(String nifReclamante, String nifReclamado)
			throws Exception {

		List<ReclamacionArb> listSolicitudesBusqueda = null;

		ReclamacionArb reclamacionPrevia = new ReclamacionArb();
		HashMap<String, String> datosReclamacionPrevia = new HashMap<String, String>();

		try {
			if (!Y41bUtils.esNullOCadenaVacia(nifReclamante) && !Y41bUtils.esNullOCadenaVacia(nifReclamado)) {
				ReclamacionArb reclamacionFiltro = new ReclamacionArb();
				reclamacionFiltro.setDtnif(nifReclamante);
				reclamacionFiltro.setEsnif(nifReclamado);
				reclamacionFiltro.setindNoRelacionada(Y41bConstantes.VALOR_SI);
				reclamacionFiltro.setHdcosc(Y41bConstantes.TIPO_SOLICITUD_RECLAMACION);

				listSolicitudesBusqueda = this.reclamacionArbService.findAllLikeSolicitudes(reclamacionFiltro, null,
						Boolean.FALSE);

				return listSolicitudesBusqueda;
			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new Exception();
		}

		return listSolicitudesBusqueda;
	}

	/**
	 * Metodo para coger el dato de la resolucion previa indicado en campo a
	 * partir del NIF del reclamante y el cdigo de expediente (en el toolkit
	 * hay que coger los datos campo por campo)
	 * 
	 * @param nif
	 *            String
	 * @param codexpediente
	 *            String
	 * @return HashMap<String, String>
	 * @throws Exception
	 *             excepcion
	 * 
	 */
	public HashMap<String, String> cogerDatosReclamacionPrevia(String nif, String codexpediente) throws Exception {

		ReclamacionArb reclamacionPrevia = new ReclamacionArb();
		HashMap<String, String> datosReclamacionPrevia = new HashMap<String, String>();

		try {

			if (!Y41bUtils.esNullOCadenaVacia(nif)) {
				ReclamacionArb reclamacionFiltro = new ReclamacionArb();
				reclamacionFiltro.setNumExpediente(codexpediente != null ? codexpediente.toUpperCase() : codexpediente);
				reclamacionFiltro.setDtnif(nif);
				reclamacionFiltro.setindNoRelacionada(Y41bConstantes.VALOR_SI);
				reclamacionFiltro.setHdcosc(Y41bConstantes.TIPO_SOLICITUD_RECLAMACION);

				List<ReclamacionArb> listSolicitudesBusqueda = this.reclamacionArbService
						.findAllLikeSolicitudes(reclamacionFiltro, null, Boolean.FALSE);

				if (listSolicitudesBusqueda != null && listSolicitudesBusqueda.size() > 0) {
					reclamacionPrevia = listSolicitudesBusqueda.get(0);

					datosReclamacionPrevia.put("datosReclamacionPrev_codigo", codexpediente);
					datosReclamacionPrevia.put("es", Y41bUtils.formatearDateToString(reclamacionPrevia.getHdfehd(),
							Y41bConstantes.FORMATO_FECHA_ES, Y41bConstantes.CASTELLANO));
					datosReclamacionPrevia.put("eu", Y41bUtils.formatearDateToStringEuskera(
							reclamacionPrevia.getHdfehd(), Y41bConstantes.FORMATO_FECHA_EU, Y41bConstantes.EUSKERA));
					datosReclamacionPrevia.put("datosHecho_descripcion", reclamacionPrevia.getHdte());
					datosReclamacionPrevia.put("datosPretensiones_reclamacion", reclamacionPrevia.getHdcotsr());
					if (reclamacionPrevia.getHdcaptso() != null) {
						datosReclamacionPrevia.put("datosPretensiones_importe",
								reclamacionPrevia.getHdcaptso().toString().replace('\u002e', '\u002c'));
					} else {
						datosReclamacionPrevia.put("datosPretensiones_importe", "0");
					}
					datosReclamacionPrevia.put("datosPretensiones_comentarios", reclamacionPrevia.getHdteso());
				}
			}

			return datosReclamacionPrevia;

		} catch (Exception e) {
			e.printStackTrace();
			throw new Exception();
		}
	}

}
