package com.ejie.y41b.service;

import com.ejie.y41b.model.platea.ContextSubmission;
import com.ejie.x38.dto.Pagination;

import java.util.HashMap;
import java.util.List;

import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbsoltele;
import com.ejie.y41b.model.ReclamacionArb;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.dokusi.Documento;

/**
 * ArbsolteleService  
 * 
 *  
 */

public interface ArbsolteleService {

	/**
	 * Inserts a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return Arbsoltele
	 */
	Arbsoltele add(Arbsoltele arbsoltele);

	/**
	 * Updates a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return Arbsoltele
	 */
	Arbsoltele update(Arbsoltele arbsoltele);

	/**
	 * Finds a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return Arbsoltele
	 */
	Arbsoltele find(Arbsoltele arbsoltele);

	/**
	 * Finds a List of rows in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbsoltele> findAll(Arbsoltele arbsoltele, Pagination pagination);

	/**
	 * Counts rows in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return Long
	 */
	Long findAllCount(Arbsoltele arbsoltele);

	/**
	 * Finds rows in the Arbsoltele table using like.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbsoltele> findAllLike(Arbsoltele arbsoltele, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Arbsoltele table using like.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbsoltele arbsoltele, Boolean startsWith);

	/**
	 * Deletes a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return
	 */
	void remove(Arbsoltele arbsoltele);

	/**
	 * Deletes multiple rows in the Arbsoltele table.
	 * 
	 * @param arbsolteleList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Arbsoltele> arbsolteleList);

	/**
	 * Proceso la recepcin de una solicitud telemtica de arbitraje generada a
	 * traves del toolkit de formularios
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param contextSubmission
	 *            ContextSubmission
	 * @param listDocumento
	 *            List
	 * @param solicitudID
	 *            String
	 * @return Solarb
	 * @throws Exception
	 *             Exception
	 */
	Solarb recibirSolicitudTelematica(Arbexp arbexp, ContextSubmission contextSubmission, List<Documento> listDocumento,
			String solicitudID) throws Exception;

	/**
	 * eliminar las solicitudes telemticas que se quedan en BBDD pero que no se
	 * llegan a recibir porque no se han registrado Eliminamos aquellas que
	 * hayan pasado ms de una semana.
	 * 
	 * @throws Exception
	 *             Exception
	 */
	void limpiarTemporalesTelematicasAntiguas() throws Exception;

	/**
	 * metodo para validar la resolucion previa a partir del NIF del reclamante
	 * y el cdigo de expediente
	 * 
	 * @param nif
	 *            String
	 * @param codexpediente
	 *            String
	 * @return boolean
	 * @throws Exception
	 *             ex
	 */
	boolean validarReclamacionPrevia(String nif, String codexpediente) throws Exception;

	/**
	 * Mtodo para comprobar que el expediente de reclamacin cumpla unas
	 * condiciones. La resolucion previa indicado en campo a partir del NIF del
	 * reclamante y el reclamado de expediente (en arbitraje hay que comprobar
	 * que no haya expedientes anteriores.
	 * 
	 * @param nifReclamante
	 *            String
	 * @param nifReclamado
	 *            String
	 * @return HashMap<String, String>
	 * @throws Exception
	 *             excepcion
	 * 
	 */
	List<ReclamacionArb> cogerExpedientesReclamacionPrevia(String nifReclamante, String nifReclamado) throws Exception;

	/**
	 * Metodo para coger el dato de la resolucion previa indicado en campo a
	 * partir del NIF del reclamante y el cdigo de expediente (en el toolkit
	 * hay que coger los datos campo por campo)
	 * 
	 * @param nif
	 *            String
	 * @param codexpediente
	 *            String
	 * @return HashMap<String, String>
	 * @throws Exception
	 *             ex
	 */
	HashMap<String, String> cogerDatosReclamacionPrevia(String nif, String codexpediente) throws Exception;
}
