package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ArbsoldocteleDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbsoldoctele;

/**
 * ArbsoldocteleServiceImpl  
 *  
 */

@Service(value = "arbsoldocteleService")
public class ArbsoldocteleServiceImpl implements ArbsoldocteleService {

	@Autowired
	private ArbsoldocteleDao arbsoldocteleDao;

	/**
	 * Inserts a single row in the Arbsoldoctele table.
	 *
	 * @param arbsoldoctele Arbsoldoctele
	 * @return Arbsoldoctele
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbsoldoctele add(Arbsoldoctele arbsoldoctele) {
		return this.arbsoldocteleDao.add(arbsoldoctele);
	}

	/**
	 * Updates a single row in the Arbsoldoctele table.
	 *
	 * @param arbsoldoctele Arbsoldoctele
	 * @return Arbsoldoctele
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbsoldoctele update(Arbsoldoctele arbsoldoctele) {
		return this.arbsoldocteleDao.update(arbsoldoctele);
	 }

	/**
	 * Finds a single row in the Arbsoldoctele table.
	 *
	 * @param arbsoldoctele Arbsoldoctele
	 * @return Arbsoldoctele
	 */
	public Arbsoldoctele find(Arbsoldoctele arbsoldoctele) {
		return (Arbsoldoctele) this.arbsoldocteleDao.find(arbsoldoctele);
	}

	/**
	 * Finds a List of rows in the Arbsoldoctele table.
	 *
	 * @param arbsoldoctele Arbsoldoctele
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Arbsoldoctele> findAll(Arbsoldoctele arbsoldoctele, Pagination pagination) {
		return (List<Arbsoldoctele>) this.arbsoldocteleDao.findAll(arbsoldoctele, pagination);
	}
    
	/**
	 * Counts rows in the Arbsoldoctele table.
	 *
	 * @param arbsoldoctele Arbsoldoctele
	 * @return Long
	 */
	public Long findAllCount(Arbsoldoctele arbsoldoctele) {        
		return  this.arbsoldocteleDao.findAllCount(arbsoldoctele);
	}

	/**
	 * Finds rows in the Arbsoldoctele table using like.
	 *
	 * @param arbsoldoctele Arbsoldoctele
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Arbsoldoctele> findAllLike(Arbsoldoctele arbsoldoctele, Pagination pagination, Boolean startsWith) {
		return (List<Arbsoldoctele>) this.arbsoldocteleDao.findAllLike(arbsoldoctele, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbsoldoctele table using like.
	 *
	 * @param arbsoldoctele Arbsoldoctele
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbsoldoctele arbsoldoctele, Boolean startsWith) {
		return this.arbsoldocteleDao.findAllLikeCount(arbsoldoctele, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Arbsoldoctele table.
	 *
	 * @param arbsoldoctele Arbsoldoctele
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbsoldoctele arbsoldoctele) {
		this.arbsoldocteleDao.remove(arbsoldoctele);
	}
	
	/**
	 * Deletes multiple rows in the Arbsoldoctele table.
	 *
	 * @param arbsoldocteleList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbsoldoctele> arbsoldocteleList) {
		for (Arbsoldoctele  arbsoldocteleAux:arbsoldocteleList) {
			this.arbsoldocteleDao.remove(arbsoldocteleAux);
		}
	}
	
}

