package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ArbpropbandejaDao;
import com.ejie.y41b.dao.DocumentoHechoDao;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbpropbandeja;
import com.ejie.y41b.model.DocumentoHecho;

/**
 * ArbpropbandejaServiceImpl  
 * 
 *  
 */

@Service(value = "arbpropbandejaService")
public class ArbpropbandejaServiceImpl implements ArbpropbandejaService {

	@Autowired()
	private ArbpropbandejaDao arbpropbandejaDao;
	@Autowired()
	private DocumentoHechoDao documentoHechoDao;

	/**
	 * Inserts a single row in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @return Arbpropbandeja
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbpropbandeja add(Arbpropbandeja arbpropbandeja) {
		return this.arbpropbandejaDao.add(arbpropbandeja);
	}

	/**
	 * Updates a single row in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @return Arbpropbandeja
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbpropbandeja update(Arbpropbandeja arbpropbandeja) {
		return this.arbpropbandejaDao.update(arbpropbandeja);
	}

	/**
	 * Finds a single row in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @return Arbpropbandeja
	 */
	public Arbpropbandeja find(Arbpropbandeja arbpropbandeja) {
		return (Arbpropbandeja) this.arbpropbandejaDao.find(arbpropbandeja);
	}

	/**
	 * Finds a single row in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @return String
	 */
	public String findReclamante(Arbpropbandeja arbpropbandeja) {
		return (String) this.arbpropbandejaDao.findReclamante(arbpropbandeja);
	}

	/**
	 * Finds a List of rows in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbpropbandeja> findAll(Arbpropbandeja arbpropbandeja,
			Pagination pagination) {
		if (pagination != null) {
			if ("baprsanid".equals(pagination.getSort())) {
				pagination.setSort("BAPRARBID");
			} else if ("censoMonitor.monombre".equals(pagination.getSort())) {
				pagination.setSort("MONOMBRE");
			} else if ("baprsanmunic".equals(pagination.getSort())) {
				pagination.setSort("BAPRARBMUNIC");
			} else if ("baprsanprov".equals(pagination.getSort())) {
				pagination.setSort("BAPRARBPROV");
			} else if ("establecimiento.esnoco".equals(pagination.getSort())) {
				pagination.setSort("ESNOCO");
			} else if ("baprsanfec".equals(pagination.getSort())) {
				pagination.setSort("BAPRARBFEC");
			} else if ("tipoProcedimiento.pnombre".equals(pagination.getSort())) {
				pagination.setSort("PNOMBRE");
			} else if ("tipoProcedimiento.pnombree"
					.equals(pagination.getSort())) {
				pagination.setSort("PNOMBREE");
			} else if ("tipoProcedimiento.pcodigo".equals(pagination.getSort())) {
				pagination.setSort("PCODIGO");
			} else if ("baprarbexcodcompleto".equals(pagination.getSort())) {
				if (pagination.getAscDsc().equals("asc")) {
					pagination
							.setSort("SUBSTR(BAPRARBEXCODCOMPLETO,0,6) ASC, CASE REGEXP_COUNT(BAPRARBEXCODCOMPLETO,'-',1) WHEN 2 THEN TO_NUMBER(SUBSTR(BAPRARBEXCODCOMPLETO,-4,4)) ELSE  TO_NUMBER(SUBSTR(BAPRARBEXCODCOMPLETO,-6,4)) END ASC , TO_NUMBER(SUBSTR(BAPRARBEXCODCOMPLETO,8,INSTR(BAPRARBEXCODCOMPLETO,'-',1,2)-8)) ");
				} else if (pagination.getAscDsc().equals("desc")) {
					pagination
							.setSort("SUBSTR(BAPRARBEXCODCOMPLETO,0,6) DESC, CASE REGEXP_COUNT(BAPRARBEXCODCOMPLETO,'-',1) WHEN 2 THEN TO_NUMBER(SUBSTR(BAPRARBEXCODCOMPLETO,-4,4)) ELSE  TO_NUMBER(SUBSTR(BAPRARBEXCODCOMPLETO,-6,4)) END DESC , TO_NUMBER(SUBSTR(BAPRARBEXCODCOMPLETO,8,INSTR(BAPRARBEXCODCOMPLETO,'-',1,2)-8)) ");
				}
			} else if ("baprarbexcodigo".equals(pagination.getSort())) {
				pagination.setSort("BAPRARBEXCODIGO");
			}
		}
		List<Arbpropbandeja> lArbpropbandeja = (List<Arbpropbandeja>) this.arbpropbandejaDao
				.findAll(arbpropbandeja, pagination);
		for (int i = 0; i < lArbpropbandeja.size(); i++) {
			arbpropbandeja = lArbpropbandeja.get(i);
			DocumentoHecho doc = new DocumentoHecho();
			doc.setQ5hdcodigo(arbpropbandeja.getBaprarbexcodigo());
			doc.setQ5idTipodoc(Y41bConstantes.TIPO_DOC_SOL_ARBITRAJE);
			Long cont = this.documentoHechoDao.findAllCount(doc);
			if (cont.longValue() > 0L) {
				lArbpropbandeja.get(i).setTieneSolArb(Y41bConstantes.VALOR_SI);
			}
		}
		return lArbpropbandeja;
	}

	/**
	 * Counts rows in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @return Long
	 */
	public Long findAllCount(Arbpropbandeja arbpropbandeja) {
		return this.arbpropbandejaDao.findAllCount(arbpropbandeja);
	}

	/**
	 * 
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @return Long
	 */
	public Arbpropbandeja getObserv(Arbpropbandeja arbpropbandeja) {

		Arbpropbandeja arbpropbandejaAux = (Arbpropbandeja) this.arbpropbandejaDao
				.find(arbpropbandeja);

		return arbpropbandejaAux;
	}

	/**
	 * 
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * 
	 */
	public void setObserv(Arbpropbandeja arbpropbandeja) {

		this.arbpropbandejaDao.setObservaciones(arbpropbandeja);

	}

	/**
	 * Finds rows in the Arbpropbandeja table using like.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbpropbandeja> findAllLike(Arbpropbandeja arbpropbandeja,
			Pagination pagination, Boolean startsWith) {
		return (List<Arbpropbandeja>) this.arbpropbandejaDao.findAllLike(
				arbpropbandeja, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbpropbandeja table using like.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbpropbandeja arbpropbandeja,
			Boolean startsWith) {
		return this.arbpropbandejaDao.findAllLikeCount(arbpropbandeja,
				startsWith);
	}

	/**
	 * Deletes a single row in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbpropbandeja arbpropbandeja) {
		this.arbpropbandejaDao.remove(arbpropbandeja);
	}

	/**
	 * Deletes a single row in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeSolicitudes(Arbpropbandeja arbpropbandeja) {
		this.arbpropbandejaDao.removeSolicitudes(arbpropbandeja);
	}

	/**
	 * Deletes multiple rows in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandejaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbpropbandeja> arbpropbandejaList) {
		for (Arbpropbandeja arbpropbandejaAux : arbpropbandejaList) {
			this.arbpropbandejaDao.remove(arbpropbandejaAux);
		}
	}

}
