package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TipReqNormativoDao;
import com.ejie.y41b.model.TipReqNormativo;
import com.ejie.y41b.model.Y41bArbolTiposInfraccion;
import com.ejie.y41b.model.Y41bTipoInfraccionTree;

/**
 * ArbolTiposInfraccionServiceImpl  
 * 
 *  
 */
@Service(value = "arbolTiposInfraccionService")
public class ArbolTiposInfraccionServiceImpl implements
		ArbolTiposInfraccionService {

	@Autowired()
	private TipReqNormativoDao tipReqNormativoDao;

	@Override()
	public Y41bArbolTiposInfraccion obtenerArbol(
			TipReqNormativo filterTipReqNormativo, Pagination pagination) {

		List<Y41bTipoInfraccionTree> lstArbolTiposInfraccion = new ArrayList<Y41bTipoInfraccionTree>();

		List<Y41bTipoInfraccionTree> lstTiposInfraccion = this.tipReqNormativoDao
				.findAllTiposInfraccionPadre(null, pagination);

		for (Y41bTipoInfraccionTree gr : lstTiposInfraccion) {

			if (this.tieneHijos(gr, filterTipReqNormativo, pagination)) {
				gr = this.obtieneTipoInfraccion(gr, filterTipReqNormativo,
						pagination);
				lstArbolTiposInfraccion.add(gr);
			}
		}

		Y41bArbolTiposInfraccion tree = new Y41bArbolTiposInfraccion();
		tree.setLstTiposInfraccion(lstArbolTiposInfraccion);

		return tree;
	}

	/**
	 * 
	 * @param y41bTipoInfraccionTree
	 *            Y41bTipoInfraccionTree
	 * @param filterTipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @return Y41bTipoInfraccionTree
	 */
	private Y41bTipoInfraccionTree obtieneTipoInfraccion(
			Y41bTipoInfraccionTree y41bTipoInfraccionTree,
			TipReqNormativo filterTipReqNormativo, Pagination pagination) {

		List<Y41bTipoInfraccionTree> lstY41bTipoInfraccionTree = this.tipReqNormativoDao
				.findAllChildren(y41bTipoInfraccionTree, pagination);

		if (lstY41bTipoInfraccionTree != null
				&& lstY41bTipoInfraccionTree.size() > 0) {
			List<Y41bTipoInfraccionTree> lstTiposInfraccion = new ArrayList();
			for (Y41bTipoInfraccionTree gr : lstY41bTipoInfraccionTree) {
				if (this.tieneHijos(gr, filterTipReqNormativo, pagination)) {
					gr = this.obtieneTipoInfraccion(gr, filterTipReqNormativo,
							pagination);
					lstTiposInfraccion.add(gr);
				}
			}

			y41bTipoInfraccionTree.setTiposInfraccion(lstTiposInfraccion);
		}

		return y41bTipoInfraccionTree;
	}

	/**
	 * 
	 * @param y41bTipoInfraccionTree
	 *            Y41bTipoInfraccionTree
	 * @param filterTipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @return boolean
	 */
	private boolean tieneHijos(Y41bTipoInfraccionTree y41bTipoInfraccionTree,
			TipReqNormativo filterTipReqNormativo, Pagination pagination) {

		// comprobar si tiene tipos infraccion habituales
		// Si tiene return true
		// Si no tiene return false
		Long numTiposInfraccion = this.tipReqNormativoDao
				.countTiposInfraccionHijos(y41bTipoInfraccionTree,
						filterTipReqNormativo, false);

		if (numTiposInfraccion > 0) {
			return true;
		} else {
			return false;
		}
	}

}
