package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.SectorDao;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Y41bArbolSectores;
import com.ejie.y41b.model.Y41bSectorTree;

/**
 * ArbolSectoresServiceImpl  
 * 
 *  
 */
@Service(value = "arbolSectoresService")
public class ArbolSectoresServiceImpl implements ArbolSectoresService {

	@Autowired()
	private SectorDao sectorDao;

	@Override()
	public Y41bArbolSectores obtenerArbol(Sector filterSector,
			Pagination pagination) {

		List<Y41bSectorTree> lstArbolSectores = new ArrayList<Y41bSectorTree>();

		List<Sector> listSectores = this.sectorDao.findAll(null, pagination);

		for (Sector sector : listSectores) {

			Y41bSectorTree sectorTree = new Y41bSectorTree(
					sector.getSecodigo(), sector.getSenombre(),
					sector.getSenombree(), sector.getSecose(),
					sector.getSeinsel1());

			boolean encontrado = false;
			if (lstArbolSectores != null && lstArbolSectores.size() > 0) {
				int i = 0;
				Y41bSectorTree grAux = null;
				for (Y41bSectorTree gr : lstArbolSectores) {
					if (sectorTree.getSecodigo().contains(gr.getSecodigo())) {

						grAux = gr;

						encontrado = true;
						break;
					}
					i++;
				}

				if (!encontrado) {
					lstArbolSectores.add(sectorTree);
				} else {
					grAux = obtieneSector(grAux, sectorTree);
					lstArbolSectores.set(i, grAux);
				}
			} else {
				lstArbolSectores.add(sectorTree);
			}
		}

		Y41bArbolSectores tree = new Y41bArbolSectores();
		tree.setLstSectores(lstArbolSectores);

		return tree;
	}

	/**
	 * 
	 * @param gr
	 *            Y41bSectorTree
	 * @param sectorTree
	 *            Y41bSectorTree
	 * @return Y41bSectorTree
	 */
	public Y41bSectorTree obtieneSector(Y41bSectorTree gr,
			Y41bSectorTree sectorTree) {

		List<Y41bSectorTree> lstSectores = gr.getSectores();

		boolean encontrado = false;
		boolean encontrado2 = false;
		if (lstSectores.size() > 0) {
			Y41bSectorTree grAux2 = null;
			int i = 0;
			for (Y41bSectorTree grAux : lstSectores) {
				if (sectorTree.getSecodigo().contains(grAux.getSecodigo())) {
					encontrado2 = true;
					if (grAux.getSecodigo().length() == 1
							&& sectorTree.getSecodigo().length() == 3) {
						lstSectores.add(sectorTree);
						break;
					} else {
						if (grAux.getSecodigo().length() + 1 == sectorTree
								.getSecodigo().length()) {
							grAux.getSectores().add(sectorTree);
							break;
						} else {
							grAux2 = grAux;

							encontrado = true;
							break;
						}
					}
				}
				i++;
			}
			if (encontrado) {
				grAux2 = obtieneSector(grAux2, sectorTree);
				lstSectores.set(i, grAux2);

			}
			if (!encontrado2) {
				lstSectores.add(sectorTree);
			}
		} else {
			if (sectorTree.getSecodigo().contains(gr.getSecodigo())) {
				if (gr.getSecodigo().length() == 1
						&& sectorTree.getSecodigo().length() == 3) {
					lstSectores.add(sectorTree);
				} else {
					if (gr.getSecodigo().length() + 1 == sectorTree
							.getSecodigo().length()) {
						lstSectores.add(sectorTree);
					}
				}
			}
		}

		return gr;
	}
}