package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ProductoDao;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Y41bArbolProductos;
import com.ejie.y41b.model.Y41bProductoTree;

/**
 * ArbolProductosServiceImpl  
 * 
 *  
 */
@Service(value = "arbolProductosService")
public class ArbolProductosServiceImpl implements ArbolProductosService {

	@Autowired()
	private ProductoDao productoDao;

	@Override()
	public Y41bArbolProductos obtenerArbol(Producto filterProducto,
			Pagination pagination) {

		List<Y41bProductoTree> lstArbolProductos = new ArrayList<Y41bProductoTree>();

		List<Producto> listProductos = this.productoDao.findAll(null,
				pagination);

		for (Producto producto : listProductos) {

			Y41bProductoTree productoTree = new Y41bProductoTree(
					producto.getPscodigo(), producto.getPsnombre(),
					producto.getPsnombree(), producto.getPscose(),
					producto.getPssel1());

			boolean encontrado = false;
			if (lstArbolProductos != null && lstArbolProductos.size() > 0) {
				int i = 0;
				Y41bProductoTree grAux = null;
				for (Y41bProductoTree gr : lstArbolProductos) {
					if (productoTree.getPscodigo().contains(gr.getPscodigo())) {

						grAux = gr;

						encontrado = true;
						break;
					}
					i++;
				}

				if (!encontrado) {
					lstArbolProductos.add(productoTree);
				} else {
					grAux = obtieneProducto(grAux, productoTree);
					lstArbolProductos.set(i, grAux);
				}
			} else {
				lstArbolProductos.add(productoTree);
			}
		}

		Y41bArbolProductos tree = new Y41bArbolProductos();
		tree.setLstProductos(lstArbolProductos);

		return tree;
	}

	/**
	 * 
	 * @param gr
	 *            Y41bProductoTree
	 * @param productoTree
	 *            productoTree
	 * @return Y41bProductoTree
	 */
	public Y41bProductoTree obtieneProducto(Y41bProductoTree gr,
			Y41bProductoTree productoTree) {

		List<Y41bProductoTree> lstProductos = gr.getProductos();

		boolean encontrado = false;
		boolean encontrado2 = false;
		if (lstProductos.size() > 0) {
			Y41bProductoTree grAux2 = null;
			int i = 0;
			for (Y41bProductoTree grAux : lstProductos) {
				if (productoTree.getPscodigo().contains(grAux.getPscodigo())) {
					encontrado2 = true;
					if (grAux.getPscodigo().length() == 1
							&& productoTree.getPscodigo().length() == 3) {
						lstProductos.add(productoTree);
						break;
					} else {
						if (grAux.getPscodigo().length() + 1 == productoTree
								.getPscodigo().length()) {
							grAux.getProductos().add(productoTree);
							break;
						} else {
							grAux2 = grAux;

							encontrado = true;
							break;
						}
					}
				}
				i++;
			}
			if (encontrado) {
				grAux2 = obtieneProducto(grAux2, productoTree);
				lstProductos.set(i, grAux2);

			}
			if (!encontrado2) {
				lstProductos.add(productoTree);
			}
		} else {
			if (productoTree.getPscodigo().contains(gr.getPscodigo())) {
				if (gr.getPscodigo().length() == 1
						&& productoTree.getPscodigo().length() == 3) {
					lstProductos.add(productoTree);
				} else {
					if (gr.getPscodigo().length() + 1 == productoTree
							.getPscodigo().length()) {
						lstProductos.add(productoTree);
					}
				}
			}
		}

		return gr;
	}
}
