package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.GrupoOrganismoDao;
import com.ejie.y41b.model.Y41bArbolOrganismos;
import com.ejie.y41b.model.Y41bGrupoOrganismoTree;
import com.ejie.y41b.model.Y41bOrganismoTree;

/**
 * ArbolOrganismosServiceImpl  
 * 
 *  
 */
@Service(value = "arbolOrganismosService")
public class ArbolOrganismosServiceImpl implements ArbolOrganismosService {

	@Autowired()
	private GrupoOrganismoDao gruposDao;

	@Override()
	public Y41bArbolOrganismos obtenerArbol(boolean mostrarNoActivas,
			String codOrgConectado, Pagination pagination) {

		List<Y41bGrupoOrganismoTree> lstArbolGrupos = new ArrayList<Y41bGrupoOrganismoTree>();

		Y41bGrupoOrganismoTree grupoFiltro = new Y41bGrupoOrganismoTree();
		// grupoFiltro.setGrupoId(Y41bConstantes.GRUPO_RAIZ_ID);
		// grupoFiltro.setPadreId(null);

		// Get root
		// Y41bGrupoOrganismoTree rootGrupo = this.gruposDao.find(grupoFiltro);

		// Obtenemos los grupos
		grupoFiltro.setGrupoId(null);
		grupoFiltro.setPadreId(null);
		grupoFiltro.setActiva(Y41bConstantes.VALOR_SI);

		List<Y41bGrupoOrganismoTree> lstGrupo = this.gruposDao.findAll(
				grupoFiltro, null);
		// lstGrupo.add(0, rootGrupo);

		for (Y41bGrupoOrganismoTree gr : lstGrupo) {

			if (this.tieneEntidadesKontsumonet(gr, mostrarNoActivas, pagination)) {
				gr = this.obtieneGrupo(gr, mostrarNoActivas, codOrgConectado,
						pagination);
				lstArbolGrupos.add(gr);
			}
		}

		Y41bArbolOrganismos tree = new Y41bArbolOrganismos();
		tree.setLstGrupos(lstArbolGrupos);

		return tree;
	}

	/**
	 * 
	 * @param grupoFiltro
	 *            Y41bGrupoOrganismoTree
	 * @param mostrarNoActivas
	 *            boolean
	 * @param codOrgConectado
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return Y41bGrupoOrganismoTree
	 */
	private Y41bGrupoOrganismoTree obtieneGrupo(
			Y41bGrupoOrganismoTree grupoFiltro, boolean mostrarNoActivas,
			String codOrgConectado, Pagination pagination) {
		List<Y41bGrupoOrganismoTree> lstGrupoChildren = this.gruposDao
				.findAllChildren(grupoFiltro);

		if (lstGrupoChildren != null && lstGrupoChildren.size() > 0) {
			List<Object> lstGrupos = new ArrayList();
			for (Y41bGrupoOrganismoTree gr : lstGrupoChildren) {
				if (this.tieneEntidadesKontsumonet(gr, mostrarNoActivas,
						pagination)) {
					gr = this.obtieneGrupo(gr, mostrarNoActivas,
							codOrgConectado, pagination);
					lstGrupos.add(gr);
				}
			}

			List<Y41bOrganismoTree> lstOrganismo = this.obtieneOrganismos(
					grupoFiltro, mostrarNoActivas, codOrgConectado, pagination);

			for (Y41bOrganismoTree ent : lstOrganismo) {
				lstGrupos.add(ent);
			}

			grupoFiltro.setLstChildren(lstGrupos);

		} else {
			grupoFiltro.setLstChildren(this.obtieneOrganismos(grupoFiltro,
					mostrarNoActivas, codOrgConectado, pagination));
		}

		return grupoFiltro;
	}

	/**
	 * 
	 * @param gr
	 *            Y41bGrupoOrganismoTree
	 * @param mostrarNoActivas
	 *            boolean
	 * @param codOrgConectado
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List<Y41bOrganismoTree>
	 */
	private List<Y41bOrganismoTree> obtieneOrganismos(
			Y41bGrupoOrganismoTree gr, boolean mostrarNoActivas,
			String codOrgConectado, Pagination pagination) {

		Y41bOrganismoTree Y41bOrganismoTreeKey = new Y41bOrganismoTree();
		if (mostrarNoActivas) {
			Y41bOrganismoTreeKey.setActiva(null); // Muestra todas
		} else {
			Y41bOrganismoTreeKey.setActiva(Y41bConstantes.VALOR_SI);
		}

		Y41bOrganismoTreeKey.setCodOrg(codOrgConectado);

		Y41bGrupoOrganismoTree fGr = this.gruposDao.findGrupoEntidad(gr,
				Y41bOrganismoTreeKey, pagination);
		return fGr.getEntidads();

	}

	/**
	 * 
	 * @param Y41bGrupoOrganismoTree
	 *            Y41bGrupoOrganismoTree
	 * @param mostrarNoActivas
	 *            boolean
	 * @param pagination
	 *            Pagination
	 * @return boolean
	 */
	private boolean tieneEntidadesKontsumonet(
			Y41bGrupoOrganismoTree Y41bGrupoOrganismoTree,
			boolean mostrarNoActivas, Pagination pagination) {

		// comprobar si tiene entidades de kontsumonet
		// Si tiene return true:
		// Si no tiene se buscan sus hijos y por cada hijo se mira si tiene
		// entidades de kontsumonet
		// si no tiene ninguno return false.

		boolean entidadesKontsumonet = false;

		Long numEntidades = this.gruposDao
				.countEntidadesKontsumonet(Y41bGrupoOrganismoTree);

		if (numEntidades > 0) {
			return true;
		} else {
			List<Y41bGrupoOrganismoTree> lstGrupoChildren = this.gruposDao
					.findAllChildren(Y41bGrupoOrganismoTree);

			if (lstGrupoChildren != null && lstGrupoChildren.size() > 0) {
				for (Y41bGrupoOrganismoTree gr : lstGrupoChildren) {
					entidadesKontsumonet = this.tieneEntidadesKontsumonet(gr,
							mostrarNoActivas, pagination);
					if (entidadesKontsumonet) {
						return entidadesKontsumonet;
					}
				}
				return false;
			} else {
				return false;
			}
		}
	}

}
