package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ArbnumsolDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbnumsol;

/**
 * ArbnumsolServiceImpl  
 *  
 */

@Service(value = "arbnumsolService")
public class ArbnumsolServiceImpl implements ArbnumsolService {

	@Autowired
	private ArbnumsolDao arbnumsolDao;

	/**
	 * Inserts a single row in the Arbnumsol table.
	 *
	 * @param arbnumsol Arbnumsol
	 * @return Arbnumsol
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbnumsol add(Arbnumsol arbnumsol) {
		return this.arbnumsolDao.add(arbnumsol);
	}

	/**
	 * Updates a single row in the Arbnumsol table.
	 *
	 * @param arbnumsol Arbnumsol
	 * @return Arbnumsol
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbnumsol update(Arbnumsol arbnumsol) {
		return this.arbnumsolDao.update(arbnumsol);
	 }

	/**
	 * Finds a single row in the Arbnumsol table.
	 *
	 * @param arbnumsol Arbnumsol
	 * @return Arbnumsol
	 */
	public Arbnumsol find(Arbnumsol arbnumsol) {
		return (Arbnumsol) this.arbnumsolDao.find(arbnumsol);
	}

	/**
	 * Finds a List of rows in the Arbnumsol table.
	 *
	 * @param arbnumsol Arbnumsol
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Arbnumsol> findAll(Arbnumsol arbnumsol, Pagination pagination) {
		return (List<Arbnumsol>) this.arbnumsolDao.findAll(arbnumsol, pagination);
	}
    
	/**
	 * Counts rows in the Arbnumsol table.
	 *
	 * @param arbnumsol Arbnumsol
	 * @return Long
	 */
	public Long findAllCount(Arbnumsol arbnumsol) {        
		return  this.arbnumsolDao.findAllCount(arbnumsol);
	}

	/**
	 * Finds rows in the Arbnumsol table using like.
	 *
	 * @param arbnumsol Arbnumsol
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Arbnumsol> findAllLike(Arbnumsol arbnumsol, Pagination pagination, Boolean startsWith) {
		return (List<Arbnumsol>) this.arbnumsolDao.findAllLike(arbnumsol, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbnumsol table using like.
	 *
	 * @param arbnumsol Arbnumsol
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbnumsol arbnumsol, Boolean startsWith) {
		return this.arbnumsolDao.findAllLikeCount(arbnumsol, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Arbnumsol table.
	 *
	 * @param arbnumsol Arbnumsol
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbnumsol arbnumsol) {
		this.arbnumsolDao.remove(arbnumsol);
	}
	
	/**
	 * Deletes multiple rows in the Arbnumsol table.
	 *
	 * @param arbnumsolList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbnumsol> arbnumsolList) {
		for (Arbnumsol  arbnumsolAux:arbnumsolList) {
			this.arbnumsolDao.remove(arbnumsolAux);
		}
	}
	
}

