package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ArbnumadhreuDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbnumadhreu;

/**
 * ArbnumadhreuServiceImpl  
 * 
 *  
 */

@Service(value = "arbnumadhreuService")
public class ArbnumadhreuServiceImpl implements ArbnumadhreuService {

	@Autowired()
	private ArbnumadhreuDao arbnumadhreuDao;

	/**
	 * Inserts a single row in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @return Arbnumadhreu
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Throwable.class)
	public Arbnumadhreu add(Arbnumadhreu arbnumadhreu) {
		return this.arbnumadhreuDao.add(arbnumadhreu);
	}

	/**
	 * Updates a single row in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @return Arbnumadhreu
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbnumadhreu update(Arbnumadhreu arbnumadhreu) {
		return this.arbnumadhreuDao.update(arbnumadhreu);
	}

	/**
	 * Finds a single row in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @return Arbnumadhreu
	 */
	public Arbnumadhreu find(Arbnumadhreu arbnumadhreu) {
		return (Arbnumadhreu) this.arbnumadhreuDao.find(arbnumadhreu);
	}

	/**
	 * Finds a List of rows in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbnumadhreu> findAll(Arbnumadhreu arbnumadhreu,
			Pagination pagination) {
		return (List<Arbnumadhreu>) this.arbnumadhreuDao.findAll(arbnumadhreu,
				pagination);
	}

	/**
	 * Counts rows in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @return Long
	 */
	public Long findAllCount(Arbnumadhreu arbnumadhreu) {
		return this.arbnumadhreuDao.findAllCount(arbnumadhreu);
	}

	/**
	 * Finds rows in the Arbnumadhreu table using like.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbnumadhreu> findAllLike(Arbnumadhreu arbnumadhreu,
			Pagination pagination, Boolean startsWith) {
		return (List<Arbnumadhreu>) this.arbnumadhreuDao.findAllLike(
				arbnumadhreu, pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbnumadhreu table using like.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbnumadhreu arbnumadhreu, Boolean startsWith) {
		return this.arbnumadhreuDao.findAllLikeCount(arbnumadhreu, startsWith);
	}

	/**
	 * Deletes a single row in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbnumadhreu arbnumadhreu) {
		this.arbnumadhreuDao.remove(arbnumadhreu);
	}

	/**
	 * Deletes multiple rows in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreuList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbnumadhreu> arbnumadhreuList) {
		for (Arbnumadhreu arbnumadhreuAux : arbnumadhreuList) {
			this.arbnumadhreuDao.remove(arbnumadhreuAux);
		}
	}

}
