package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.ArbmotrasDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbmotras;

/**
 * ArbmotrasServiceImpl  
 * 
 *  
 */

@Service(value = "arbmotrasService")
public class ArbmotrasServiceImpl implements ArbmotrasService {

	@Autowired
	private ArbmotrasDao arbmotrasDao;

	/**
	 * Inserts a single row in the Arbmotras table.
	 * 
	 * @param arbmotras
	 *            Arbmotras
	 * @return Arbmotras
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbmotras add(Arbmotras arbmotras) {
		return this.arbmotrasDao.add(arbmotras);
	}

	/**
	 * Updates a single row in the Arbmotras table.
	 * 
	 * @param arbmotras
	 *            Arbmotras
	 * @return Arbmotras
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Arbmotras update(Arbmotras arbmotras) {
		return this.arbmotrasDao.update(arbmotras);
	}

	/**
	 * Finds a single row in the Arbmotras table.
	 * 
	 * @param arbmotras
	 *            Arbmotras
	 * @return Arbmotras
	 */
	public Arbmotras find(Arbmotras arbmotras) {
		return (Arbmotras) this.arbmotrasDao.find(arbmotras);
	}

	/**
	 * Finds a List of rows in the Arbmotras table.
	 * 
	 * @param arbmotras
	 *            Arbmotras
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbmotras> findAll(Arbmotras arbmotras, Pagination pagination) {
		return (List<Arbmotras>) this.arbmotrasDao.findAll(arbmotras,
				pagination);
	}

	/**
	 * Counts rows in the Arbmotras table.
	 * 
	 * @param arbmotras
	 *            Arbmotras
	 * @return Long
	 */
	public Long findAllCount(Arbmotras arbmotras) {
		return this.arbmotrasDao.findAllCount(arbmotras);
	}

	/**
	 * Finds rows in the Arbmotras table using like.
	 * 
	 * @param arbmotras
	 *            Arbmotras
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Arbmotras> findAllLike(Arbmotras arbmotras,
			Pagination pagination, Boolean startsWith) {
		return (List<Arbmotras>) this.arbmotrasDao.findAllLike(arbmotras,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Arbmotras table using like.
	 * 
	 * @param arbmotras
	 *            Arbmotras
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Arbmotras arbmotras, Boolean startsWith) {
		return this.arbmotrasDao.findAllLikeCount(arbmotras, startsWith);
	}

	/**
	 * Deletes a single row in the Arbmotras table.
	 * 
	 * @param arbmotras
	 *            Arbmotras
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Arbmotras arbmotras) {
		this.arbmotrasDao.remove(arbmotras);
	}

	/**
	 * Deletes multiple rows in the Arbmotras table.
	 * 
	 * @param arbmotrasList
	 *            List
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Arbmotras> arbmotrasList) {
		for (Arbmotras arbmotrasAux : arbmotrasList) {
			this.arbmotrasDao.remove(arbmotrasAux);
		}
	}

}
